
#include <stdlib.h>
#include <stdio.h>

#include "f_nuser.h"
#include "hmalloc.h"
#include "log.h"
#include "db.h"
#include "config.h"
#include "cstring.h"
#include "csock.h"

struct db_t *nuser_db = NULL;

/*
 *	Get an entry from the network user file
 */

struct nuserf_t *read_nuserf(call_t *call)
{
	struct nuserf_t *f;
	call_t tcall;
	datum key, content;
	
	strcpy(tcall, (char *)call);
	truncssid(&tcall);
	
	key.dptr = (void *)&tcall;
	key.dsize = strlen(tcall) + 1;
	
	content = db_fetch(nuser_db, key);
	if (content.dptr) {
		if (content.dsize != sizeof(struct nuserf_t)) {
			log(L_ERR, "read_nuserf(): OUCH, db entry of wrong size: %d != %d", content.dsize, sizeof(struct nuserf_t));
			hfree(content.dptr);
			return NULL;
		}
		f = (struct nuserf_t *)content.dptr;
		return f;
	}
	
	return NULL;
}

/*
 *	Write an entry to the network user file
 */

void write_nuserf(struct nuserf_t *fp)
{
	call_t tcall;
	datum key, content;
	
	strcpy(tcall, fp->call);
	truncssid(&tcall);
	
	key.dptr = (void *)&tcall;
	key.dsize = strlen(tcall) + 1;
	
	content.dptr = (void *)fp;
	content.dsize = sizeof(struct nuserf_t);
	
	db_store(nuser_db, key, content, DB_REPLACE);
}

/*
 *	Open network user file
 */
 
int open_nuserf(void)
{
	nuser_db = db_open(nuser_f);
	if (!nuser_db) {
		log(L_CRIT, "open_nuserf(): db_open() failed for %s, abandon ship.", nuser_f);
		exit(1);
	}
	return 0;
}

/*
 *	Close network user file
 */
 
int close_nuserf(void)
{
	db_close(nuser_db);
	return 0;
}

/*
 *	Set additional information for user
 */

void set_user_data(struct nuser_t *nu, struct link_t *l, call_t *call, 
		int type, char *value)
{
	struct nuserf_t *fp;
	
	if (!valid_call(call))
		return;
	
	if (!(fp = read_nuserf(call))) {
		fp = hmalloc(sizeof(struct nuserf_t));
		strcpy(fp->call, (char *)call);
		*fp->node = '\0';
		fp->q = 0;
		*fp->name = '\0';
		*fp->qth = '\0';
	}
	
	switch (type) {

	case 1:
		strcpy(fp->name, value);
		if (l)
			log(L_NUSER, "%s: name set to %s", fp->call, value);
		break;

	case 2:
		strcpy(fp->qth, value);
		if (l)
			log(L_NUSER, "%s: qth set to %s", fp->call, value);
		break;

	case 4:
		if (fp->q <= 7 && strcmp(value, fp->node)) {
			strcpy(fp->node, value);
			fp->q = 7;
			if (l)
				log(L_NUSER, "%s: home node set to %s", fp->call, value);
		}
		break;
	}

	if (nu)
		strcpy(nu->name, fp->name);
	write_nuserf(fp);
	hfree(fp);
}

/*
 *	Set the home node in the network user file, if necessary
 */

void set_homenode(struct nuser_t *n, call_t *call, call_t *node, int q)
{
	struct nuserf_t *fp;

	if (!(valid_call(call) && valid_call(node)))
		return;

	if (!(fp = read_nuserf(call))) {
		fp = hmalloc(sizeof(struct nuserf_t));
		*fp->node = '\0';
		fp->q = 0;
		strcpy(fp->call, (char *)call);
		*fp->name = '\0';
		*fp->qth = '\0';
	}

	if (fp->q <= q) {
		strcpy(fp->node, (char *)node);
		fp->q = q;
		write_nuserf(fp);
	}
	
	if (n)
		strcpy(n->name, fp->name);
		
	hfree(fp);
}

/*
 *	unetwork
 */

int cmd_unetwork(struct csock_t *s, int argc, char **argv)
{
	char st[80];
	datum key;
	char **l;
	int llen = 20;
	int lent = 0;
	int n, i = 0;
	
	l = hmalloc(llen * sizeof(char *));
	
	csputs(s, "Network user file list:\n");
	
	/* Read keys to a array of pointers */
	key = db_firstkey(nuser_db);
	while (key.dptr) {
		key.dptr[key.dsize - 1] = '\0'; /* just to be sure. */
		if (i == llen)
			llen += 20;
		l = hrealloc(l, llen * sizeof(char *));
		l[i] = key.dptr;
		lent++;
		i++;
		key = db_nextkey(nuser_db, key);
	}
	
	/* Sort the array */
	qsort(l, lent, sizeof(char *), (int (*)(const void *, const void *))strpcmp);
	
	/* Print the array and free the data*/
	st[0] = '\0';
	n = 0;
	for (i = 0; i < lent; i++) {
		sprintf(st + strlen(st), " %-7.7s", l[i]);
		hfree(l[i]);
		n++;
		if (n == 9) {
			csprintf(s, "%s\n", st);
			st[0] = '\0';
			n = 0;
		}
	}
	if (n) {
		csprintf(s, "%s\n", st);
		st[0] = '\0';
		n = 0;
	}
	
	hfree(l); /* free the array too */
	
	return 0;
}

