
#ifndef TIMER_H
#define TIMER_H

#include <time.h>

struct timer_t {
	time_t	at;		/* When to expire (0 for as soon as possible) */
	long	interval;	/* When to re-expire (0 for one-shot) */
	
	void *ptr;			/* Parameter passed to function */
	void (*func) (void *ptr);	/* Function to call */
	
	struct timer_t	*next;
	struct timer_t	**prevp;
};

extern int timer_pending;
extern time_t now;

extern void timer_init(void);				/* Hook to a timer interrupt */
extern void timer_event(void);				/* Timer event */
extern struct timer_t *set_timer(time_t at, long interval,
		void (*func) (void *ptr), void *ptr);	/* Install a timer */
extern int del_timer(struct timer_t *t);		/* Delete a timer */

#endif TIMER_H

