
#ifndef LOG_H
#define LOG_H

#define LOG_LEN	2048

#define L_ERR           1	/* Error conditions */
#define L_R_ERR         2	/* Routing errors */
#define L_ROUTING       4	/* Route changes */
#define L_LINK		8	/* Link state changes */
#define L_NODE		16	/* Node add/drop messages */
#define L_NUSER		32	/* Network users */
#define L_LUSER		64	/* Local users */
#define L_TALK		128	/* Talk messages */
#define L_ANN		256	/* Announcements */
#define L_DX		512	/* DX spots */
#define L_WWV		1024	/* WWV information */
#define L_CRIT		4096	/* Critical conditions */
#define L_INFO		8129	/* General system information (up/down) */
#define L_SECURITY	16384	/* Security events (su, etc) */
#define L_DEBUG         32768	/* Debugging messages (verbose) */
#define L_PING		65536	/* Pings */
#define L_CMDS		131072	/* All commands */
#define L_SDEBUG	262144	/* Socket debugging */
#define L_SINFO		524288	/* Socket information (bindings, connections) */
#define L_COMPR		1048576	/* Compression details (rates, etc) */

#define L_DEFLEVEL	(L_ERR | L_R_ERR | L_LINK | L_LUSER | L_CRIT | L_INFO | L_SECURITY | L_SINFO | L_DEBUG | L_COMPR)

#define L_STDERR        1  /* Log to stderror */
#define L_SYSLOG        2  /* Log to syslog */

#define L_DEFDEST	(L_STDERR)

extern int log_level;    /* Logging level */
extern int log_dest;     /* Logging destination */

extern int open_log(void);
extern int log(int level, const char *fmt, ...);

#endif
