
#ifndef CSTRING_H
#define CSTRING_H

#include "ctypes.h"

typedef char chartable_t[256];
struct charset_t {
	chartable_t table;
	char desc[51];
	struct charset_t *next;
};

struct stringlist_t {
	char *s;
	struct stringlist_t *next;
	struct stringlist_t **prevp;
};

/* EOL conventions */

#define CR              "\r"
#define LF              "\n"
#define CRLF		"\r\n"

/* character sets */
extern struct charset_t *charset_default;	/* Default charset */
extern struct charset_t *charsets;

/* Look-up tables */
extern chartable_t upcase_ch;
extern chartable_t lowcase_ch;
extern chartable_t clean_ch;

/* misc */
extern void cstring_init(void);		/* Initialize stuff */
extern int isabortstr(char *s); 	/* Is this an /ex or ctrl-z */

/* callsigns */
extern int valid_call(const call_t *call);	/* Is this a valid callsign */
extern int getssid(const call_t *call);		/* Get SSID of a call */
call_t *truncssid(call_t *call);		/* Truncate SSID of a call */

/* String translations */
extern char *add_lf(char **s);		/* CR => CRLF */
extern char *hstrupr(char *s);		/* Upper case */
extern char *hstrlwr(char *s);		/* Lower case */
extern char *capitalize(char *s);	/* First up, rest low */
extern char *strtranslate(char *s, struct charset_t *set); /* charset translation */

/* Safe string copying */
extern char *hstrncpy(char *dest, char *src, int n); /* Safe strncpy */

/* String formatting */
extern char *spaces(int n);		/* Return N spaces */
extern char *backspaces(int n);		/* Backspaces (CTRL-H) */
extern char *padleft(char *s, int n);	/* Pad to left */
extern char *padright(char *s, int n);	/* Pad to right */
extern char *cleanstr(char *s);		/* Remove excess whitespace */
extern char *format(char *prefix, char *text, int linelen, int cr_end);

/* Freq */
extern char *freq2str(long i);		/* Frequency to a string */
extern long str2freq(char *s);

/* Num => Str */
extern char *bytes2str(int i);

/* Str => Num */
extern int str2bool(char *s);

/* String list handling */
extern struct stringlist_t *add_string(struct stringlist_t *list, char *s);

#endif
