/*
 * This file contains the definitions of the entry points into the Rose
 * configuration functions.
 */

#ifndef	_RSCONFIG_H
#define	_RSCONFIG_H

#ifndef	TRUE
#define	TRUE	1
#endif

#ifndef	FALSE
#define	FALSE	0
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * This function must be called before using any of the other functions in
 * this part of the library. It returns the number of active ports, or 0
 * on failure.
 */
extern int rs_config_load_ports(void);

/*
 * This function allows the enumeration of all the active configured ports.
 * Passing NULL as the argument returns the first port name in the list,
 * subsequent calls to this function should be made with the last port name
 * returned. A NULL return indicates either an error, or the end of the list.
 */
extern char *rs_config_get_next(char *);

/*
 * This function maps the device name onto the port name (as used in the axports
 * file. On error a NULL is returned.
 */
extern char *rs_config_get_name(char *);

/*
 * This function maps the port name onto the address of the port. On error a
 * NULL is returned.
 */
extern char *rs_config_get_addr(char *);

/*
 * This function maps the port name onto the device name of the port. On error a
 * NULL is returned.
 */
extern char *rs_config_get_dev(char *);

/*
 * This function maps the Rose address in network format onto the port name.
 * On error, NULL is returned.
 */
extern char *rs_config_get_port(rose_address *);

/*
 * This function takes the port name and returns the maximum packet length.
 * On error a 0 is returned.
 */
extern int rs_config_get_paclen(char *);

/*
 * This function takes the port name and returns the description of the port.
 * On error a NULL is returned.
 */
extern char *rs_config_get_desc(char *);

#ifdef __cplusplus
}
#endif

#endif
