
#include "f_luser.h"
#include "hmalloc.h"
#include "log.h"
#include "db.h"
#include "config.h"
#include "cstring.h"

#define LUSER_F		DATA_D "luser.db"

struct db_t *luser_db = NULL;

/*
 *	Get an entry from the local user file
 */

struct luserf_t *read_luserf(call_t call)
{
	struct luserf_t *f;
	call_t tcall;
	datum key, content;
	
	strcpy(tcall, call);
	truncssid(&tcall);
	
	key.dptr = (void *)&tcall;
	key.dsize = strlen(tcall);
	
	content = db_fetch(luser_db, key);
	if (content.dptr) {
		if (content.dsize != sizeof(struct luserf_t)) {
			log(L_ERR, "read_luserf(): OUCH, db entry of wrong size: %d != %d", content.dsize, sizeof(struct luserf_t));
			hfree(content.dptr);
			return NULL;
		}
		f = (struct luserf_t *)content.dptr;
		return f;
	}
	
	return NULL;
}

/*
 *	Write an entry to the local user file
 */

void write_luserf(struct luserf_t *fp)
{
	call_t tcall;
	datum key, content;
	
	strcpy(tcall, fp->call);
	truncssid(&tcall);
	
	key.dptr = (void *)&tcall;
	key.dsize = strlen(tcall);
	
	content.dptr = (void *)fp;
	content.dsize = sizeof(struct luserf_t);
	
	db_store(luser_db, key, content);
}

/*
 *	Open local user file
 */
 
int open_luserf(void)
{
	luser_db = db_open(LUSER_F);
	if (!luser_db) {
		log(L_CRIT, "open_luserf(): db_open() failed for %s, abandon ship.", LUSER_F);
		exit(1);
	}
	return 0;
}

/*
 *	Close local user file
 */
 
int close_luserf(void)
{
	db_close(luser_db);
	return 0;
}

