
#ifndef NET_USER_H
#define NET_USER_H	1

#include <time.h>
#include "network.h"

extern struct nuser_t *nusers;	/* Users */

extern int nuser_count;		/* How many users on the network */
extern int kuser_count;		/* How many KNOWN users on the network */
extern int nuser_max;		/* Users high water mark */
extern int kuser_max;	

extern int away_strings;	/* Away strings allocated */

/* User list handling */
void free_nusersn(struct node_t *n);

extern void net_adduser(struct nuser_t *n);
extern void net_deluser(struct link_t *l, struct nuser_t *n);
extern struct nuser_t *nuser_login(struct link_t *froml, call_t *call,
			struct node_t *node, int here);
extern void nuser_logout(struct link_t *l, call_t *call,
			struct node_t *n, time_t time);

extern int count_users(void);			/* Update user counts */

extern struct nuser_t *get_nuser(call_t *call);			/* Find user */
extern struct nuser_t *get_nuserh(call_t *call, struct node_t *node);	/* Find user on node */

extern void net_here(struct link_t *forml, call_t *call);		/* User here */
extern void net_away(struct link_t *froml, call_t *call, char *reason);	/* User away */
extern void net_userdata(struct nuser_t *n, struct link_t *froml, 
			call_t *usercall, int type, char *data);	/* User data */


#endif
