
Unit UGroups;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

   { User parameters }
  PUGroups = ^TUGroups;
  TUGroups = object(TDialog)
    Backup      : PConfig;
    Abandon     : Boolean;
    Usr_Timeout : PWordEntry;
    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RUGroups: TStreamRec = (
     ObjType: 10044;
     VmtLink: Ofs(TypeOf(TUGroups)^);
     Load:    @TUGroups.Load;
     Store:   @TUGroups.Store
  );

Procedure RegisterUserSetForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TUGroups *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TUGroups.Init;
Var
  R : TRect;
Const
  InfoXEnd   = 29;
  EntryXPos  = 31;
Begin

  R.Assign(0, 0, 41, 17);
  inherited Init(R,'User settings');

{
  R.Assign(EntryXPos,2,EntryXPos + 5,3);
  BPQInt := New(PByteEntry, Init(R,@Config^.BPQInt,3,1,255));
  Insert(BPQInt);

  R.Assign(2, 2, InfoXEnd, 3);
  Insert(New(PLabel, Init(R, 'G8BPQ ~I~nterrupt:', BPQInt)));

  R.Assign(EntryXPos,3,EntryXPos + 3,4);
  ApplNum := New(PByteEntry, Init(R,@Config^.ApplNum,1,1,8));
  Insert(ApplNum);

  R.Assign(2, 3, InfoXEnd, 4);
  Insert(New(PLabel, Init(R, '~A~pplication number:', ApplNum)));

  Inc(Config^.Start_Port);
  R.Assign(EntryXPos,5,EntryXPos + 4,6);
  Start_port := New(PByteEntry, Init(R,@Config^.Start_port,2,1,64));
  Insert(Start_Port);

  R.Assign(2, 5, InfoXEnd, 6);
  Insert(New(PLabel, Init(R, '~F~irst BPQ stream used:', Start_port)));

  R.Assign(EntryXPos,6,EntryXPos + 4,7);
  No_ports := New(PByteEntry, Init(R,@Config^.No_ports,2,1,64));
  Insert(No_ports);

  R.Assign(2, 6, InfoXEnd, 7);
  Insert(New(PLabel, Init(R, 'Amount of ~s~treams used:', No_ports)));

  R.Assign(EntryXPos,8, EntryXPos + 5,9);
  Max_paclen := New(PByteEntry, Init(R,@Config^.Max_paclen,3,80,230));
  Insert(Max_paclen);

  R.Assign(2, 8, InfoXEnd, 9);
  Insert(New(PLabel, Init(R, 'Maximum ~p~aclen:', Max_paclen)));

  R.Assign(EntryXPos,9,EntryXPos + 7,10);
  Link_reset := New(PWordEntry, Init(R,@Config^.Link_reset,5,0,65535));
  Insert(Link_reset);

  R.Assign(2, 9, InfoXEnd, 10);
  Insert(New(PLabel, Init(R, 'Link timer ~r~eset interval:', Link_reset)));

  R.Assign(22, 11, 36, 13);
  MonitorMode := New(PMonitorMode, Init(R,
  NewSItem('~B~and', NewSItem('A~c~tions', nil))));
  Insert(MonitorMode);

  R.Assign(2, 11, 19, 12);
  Insert(New(PLabel, Init(R, '~M~onitored items:', MonitorMode)));

  R.Assign(9, 14, 19, 16);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

}

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Config^;

End;

Destructor TUGroups.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Config);
        Config := Backup;
        End
   else Dispose(Backup);

End;

Constructor TUGroups.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TUGroups.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TUGroups.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterUserSetForm;
Begin
  RegisterType(RUGroups);
End;

End.
