{$F-} {$R+} {$Q+} {$I-} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Linker;

  { Implements the linking connection script system. A place of many bugs.
    Ugly. }

Interface
Uses Dos, Protocol;
Type
  LinkJobP   = ^LinkJobRec;
  LinkJobPP  = ^LinkJobP;
  LinkJobRec = Record
               Sock    : Byte;   { Socket }
               Script  : Text;   { Scriptitiedosto }
               Timer,            { Laskuri }
               Timeout : Word;   { Mihin asti odotetaan }
               State,            { Tila }
               Proto   : Byte;   { Mik protokolla }
               Link    : LinkRecP;
               LineN   : Byte;   { Monesko rivi menossa }
               Line    : String; { Rivi scriptist }
               PrevP   : LinkJobPP;
               Next    : LinkJobP;
               End;

Var
  LinkJobs       : Byte;     { Montako linkkerin tyt menossa }

 { ********************************************************************* }

          { Aloittaa linkkauksen }
Procedure StartConnect(Const InScript:NameStr;InProto:Byte;l:LinkRecP;InTimeout:Word);
Procedure EndConnect(p:Byte);           { Linkki tehty }
Procedure AbortConnects;                { Katkaise linkkaus kesken }

Procedure Linkup(p:Byte);               { Vastaanotto }
Procedure Login(p:Byte);                { Konnekti linkkistreamiin }
Procedure Logout(p:Byte);               { Disconnecti ---- " ----- }

Procedure MinTimer;                     { Kerran minuutissa }
Procedure SecTimer;                     { Kerran sekunnissa }

Procedure CheckConScript(Const Name:NameStr); { Tarkistaa scriptin }

 { ********************************************************************* }

Implementation
Uses BPQ, CStrings, Screen, Config, Files, PCLink, Convers,
     Flxapp, ConfFile;
Var
  Jobs : LinkJobP;

 { ********************************************************************* }

Function GetJob(p:Byte):LinkJobP;
Var
  Job : LinkJobP;
Begin

  Job := Jobs;
  While assigned(Job) and (Job^.Sock <> p)
    do Job := Job^.Next;
  GetJob := Job;

End;

 { ********************************************************************* }

Procedure RCmd(Job:LinkJobP); { Lukee scriptitiedostosta }
Begin

 With Job^
  do Begin
     Repeat
       ReadLn(Script,Line);
       If not eof(Script)
         then IOCheck('reading connect script file');
       Inc(LineN);
     until ((Line[1] <> '#') and (Length(Line) > 0)) or eof(Script);

     If eof(Script) then Line := '';

     If Pos('{',Line) > 0
       then Line := Copy(Line,1,Pos('{',Line)-1);

     Line := CleanStr(Line);
     End;

End;

 { ********************************************************************* }

Function GetPar(Job:LinkJobP;num:Byte):String;
Var
  Start,Stop,Current,Len : Byte;
  Str : String;
Begin

  Stop := 0;

  If (num > 0) then Begin
                    Current := 0;
                    Len := Length(Job^.Line);
                    Repeat
                    Start := Stop + 1;
                     { Haetaan " }
                     While (Start < Len) and (Job^.Line[Start] <> '"')
                       do Inc(Start);
                     Inc(Start);
                     { Parametrin loppu }
                     Stop := Start;
                     While (Stop < Len) and (Job^.Line[Stop] <> '"')
                       do Inc(Stop);
                     Inc(Current);
                     If (Start > Len) or (Stop > Len)
                       then Begin
                            Start := 2;
                            Stop := 1;
                            Current := num;
                            End;
                    until Current = num;
                    Dec(Stop);
                    Str := Copy(Job^.Line,Start,Stop-Start+1);
                    End
               else Str := Copy(Job^.Line,1,Start-1);

 GetPar := Str;

End;

 { ********************************************************************* }
 { Kynnist linkkauksen }

Procedure StartConnect(Const InScript:NameStr;InProto:Byte;l:LinkRecP;InTimeout:Word);
Var
  st  : Byte;
  Job : LinkJobP;
Begin

 { Add a new job to the beginning of the list }
 New(Job);
 Jobs^.PrevP := @Job^.Next;
 Job^.Next := Jobs;
 Job^.PrevP := @Jobs;
 Jobs := Job;

 Inc(LinkJobs);

 With Job^
  do Begin
     Proto := InProto;
     Link := l;
     Timer := 0;
     Timeout := InTimeout;
     State := 0;
     Assign(Script,CluPath + InScript + '.con');
     Reset(Script);
     End;

 { Scriptitiedosto }
 RCmd(Job);

 { Vapaa socket }
 st := Conf^.Ifc.No_Ports;
 While Assigned(Sock[st]) do Dec(st);
 Job^.Sock := st;

 Case Conf^.Ifc.IfType of

   G8BPQ : Begin
           BPQ_Connect(st);
           BPQ.Login(st);
           End;

   Flex  : Begin
           BPQ.Login(st);
           Stream[st] := Flex_Connect(Job^.Link^.AxCall,UpCaseStr(GetPar(Job,1)));
           RCmd(Job);
           End;

 End;

 With Sock[st]^
  do Begin
     Mode := SM_Linking;
     SockMode := Raw;
     CharSet := Job^.Link^.CharSet;
     If Job^.Link^.Traced
       then Begin
            Traced := True;
            Tracefile := Job^.Link^.Call + '.trc';
            End;
     End;

 Job^.Link^.Sock := st;
 Port[st] := Job^.Link;

 Action(66,'Trying ' + Job^.Link^.Call + '...');

End;

 { ********************************************************************* }
 { Linkkity pois }

Procedure RemoveJob(Job:LinkJobP);
Begin

 Close(Job^.Script);
 Job^.PrevP^ := Job^.Next;
 If Assigned(Job^.Next)
   then Job^.Next^.PrevP := Job^.PrevP;
 Dispose(Job);
 Dec(LinkJobs);

End;

 { ********************************************************************* }

Procedure EndConnect(p:Byte);
Begin

 RemoveJob(GetJob(p));

End;

 { ********************************************************************* }

Procedure AbortConnects;                { Katkaise linkkaus kesken }
Var
  Job : LinkJobP;
Begin

 Job := Jobs;
 While Assigned(Job)
  do Begin
     BPQ.Disconnect(Job^.Sock);
     Job := Job^.Next;
     End;

End;

 { ********************************************************************* }
 { Konnekti linkkerin streamiin }

Procedure Login(p:Byte);
Var
 Job : LinkJobP;
Begin

 With Sock[p]^
  do Begin
     Link_InActive := 0;
     Paclen := 230;
     End;

 Job := GetJob(p);

 If Conf^.Ifc.IfType = G8BPQ
   then Begin
        Send(p,'*** LINKED TO ' + Job^.Link^.AxCall + Cr);
        Kick(p);
        End;

 Send(p,GetPar(Job,1) + Cr);
 Kick(p);

 RCmd(Job);

End;

 { ********************************************************************* }
 { Katkes, mokoma }

Procedure Logout(p:Byte);
Var
  i   : Byte;
  Job : LinkJobP;
Begin

 Job := GetJob(p);

 If Assigned(Job)
   then Begin
        Case Job^.Proto of
         4 : Begin { PC }
             With Job^.Link^
              do Begin
                 Action(66,'Failed ' + Job^.Link^.Call);
                 Log(L_Link,'Linking to ' + Call + ' failed.');
                 DropRoutes(Job^.Link);
                 If State = LS_Init
                   then State := LS_Disc;
                 Sock := 0;
                 LastTry := 0;
                 End;
             End;
{
         6 : Begin
             b := Job[JobN[p]]^.Num;
             Action(66,'Disconnected stream ' + Int2Str(Stream[p]));
             Log(L_Link,'Linking to ' + CLink[b]^.Name + ' failed.');
             CLink[b]^.Sock := 0;
             CLink[b]^.State := 0;
             CLink[b]^.LastTry := 0;
             End;
}
        End;
        RemoveJob(Job);
        End;

End;

 { ********************************************************************* }
 { Linkkerin vastaanotto }

Procedure Linkup(p:Byte);
Var
 Cmd : Char;
 l   : Byte;
 Par : String;
 Job : LinkJobP;
Begin

 Job := GetJob(p);

 If Assigned(Job) then

 With Job^
  do Begin
     Cmd := UpCaseCh[Line[1]];

     If (Length(Line) = 0)
       then Cmd := ' ';

     Case Cmd of
       'R' : Begin
             IBuffer := UpCaseStr(IBuffer);
             Par := UpCaseStr(GetPar(Job,1));

             If Pos(Par,IBuffer) > 0  { Onnistuiko?!? }
               then Begin { Hahaa, onnistui => siirrytn seuraavaan pykln }
                    RCmd(Job);
                    If (Length(Line) = 0) { Loppu! }
                      then BPQ.Sock[Sock]^.SockMode := Ascii
                      else Begin
                           Cmd := UpCaseCh[Line[1]];
                           If Cmd = 'S'
                             then Linkup(p)
                           End;
                    End
               else { Ei ainakaan onnistunut, mutta eponnistuiko?!? }
                    Begin
                    l := 1;
                    Repeat
                      Inc(l);
                      Par := UpCaseStr(GetPar(Job,l));
                    until (Par = '') or (Pos(Par,IBuffer) > 0);
                    If Pos(Par,IBuffer) > 0
                      then Disconnect(p); { Pahus }
                    End;

             End;

       'S' : Begin
             Send(p,GetPar(Job,1) + Cr);
             Kick(p);

             RCmd(Job);
             If (Length(Line) = 0) { Loppu! }
               then BPQ.Sock[Sock]^.SockMode := Ascii
               else Begin
                    Cmd := UpCaseCh[Line[1]];
                    If Cmd = 'S'
                      then Linkup(p)
                    End;
             End;

       else  Begin
             If (Cmd = ' ')
               then { Ohjeet loppu, odotetaan tunnistusta }
                    Case Proto of
                      4 : If (Copy(IBuffer,1,2) = 'PC') then PCLink.PCRcv(p);
                      { 6 : Convers.EndOfLink(Job[b]^.Num); }
                    End;
             End;
     End; { case }
     End; { with }

 Sock[p]^.MaxFrame := GetMaxFrame(p);

End;

 { ********************************************************************* }

Procedure MinTimer;                        { Kerran minuutissa }
Var
  Job : LinkJobP;
Begin

 Job := Jobs;
 While Assigned(Job)
  do Begin
     With Job^
       do Begin
          Inc(Timer);
          If Timer = Timeout
            then Disconnect(Sock);
          End;
     Job := Job^.Next;
     End;

End;

 { ********************************************************************* }

Procedure SecTimer;                        { Kerran sekunnissa }
Var
  Job : LinkJobP;
Begin

 If (Conf^.Ifc.IfType = Flex) and not (LinkJobs = 0)
   then Begin
        Job := Jobs;
        While Assigned(Job)
          do Begin
             With Job^ do
               If (State = 0) and (l2_State(Stream[Sock]) and $f = 5)
                 then Begin
                      State := 1;
                      LinkUp(Sock);
                      End;
             Job := Job^.Next;
             End;
        End;

End;

 { ********************************************************************* }

Procedure CheckConScript(Const Name:NameStr);
Var
  Cmd     : String;
  cFound  : Boolean;
  Job     : LinkJobP;

  Procedure LCfgError(Problem:String);
  Begin
    WriteLn(CrLf + Format(True,'    ',Problem));
    Halt(1);
  End;


Begin

 New(Job);
 With Job^ do
 Begin
 Assign(Script,CluPath + Name + '.con');
 Reset(Script);
 IOCheck('opening ' + Name + '.con');
 Write(' ' + Name);
 LineN := 0;
 cFound := False;

 RCmd(Job);
 Repeat
  Cmd := UpCaseCh[Line[1]];
  Case Cmd[1] of

   'S' : Begin
         If (Conf^.Ifc.IfType = G8BPQ) or cFound
           then Begin
                If (GetPar(Job,1) = '')
                  then LCfgError('No parameter for the S command on line ' + Int2Str(LineN) + ' !');
                End
           else LCfgError('The C command must be the first one used in PC/FlexNet mode!');
         End;

   'R' : Begin
         If (Conf^.Ifc.IfType = G8BPQ) or cFound
           then Begin
                If (GetPar(Job,2) = '') or (GetPar(Job,1) = '')
                  then LCfgError('There should be at least two parameters for the R command'
                               + ' on line ' + Int2Str(LineN) + ' !');
                End
           else LCfgError('The C command must be the first one used in PC/FlexNet mode!');
         End;

   'C' : If Conf^.Ifc.IfType = Flex
           then Begin
                If (GetPar(Job,1) = '')
                  then LCfgError('No parameter for the C command on line ' + Int2Str(LineN) + ' !');
                cFound := True;
                End
           else LCfgError('Command C is not used in G8BPQ mode.');

  else LCfgError('Weird command on line ' + Int2Str(LineN) + ' !');
  End;
  RCmd(Job);
 until eof(Script);

 Close(Script);
 End;

 Dispose(Job);

End;

 { ********************************************************************* }

Begin

 LinkJobs := 0;
 Jobs := nil;

End.
