{$R-} {$Q-} {$I-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1997

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Config;

  { Implements the startup procedure (yes, the master initialization
    function is here), critical error and heap memory error handlers,
    the exit procedure, and the (non-working?) software watchdog timer.
    Also includes a bunch of global constants like version numbers and
    copyright/address defines. }

Interface
Uses ConfFile;
Type
  BootMethod              = (warm,cold);

Const
  { You are not allowed to change these (or at least, not change their meaning). }
  Copyright               = 'Copyright 1994-1997 Heikki Hannikainen, OH7LZB';
  Licence                 = 'Free software released with source code under the GNU GPL.';
  Author_Address          = 'hessu@pspt.fi - oh7lzb@oh7rba.ampr.org - OH7LZB@OH7RBA.FIN.EU';

  { Feel free to change this, for example to your callsign suffix, or some
    string describing the nature of this subtree/modification }
  SubVersion              = 'lzb';
  { Feel free to add your copyrights here, and/or describe your modifications a bit. }
  SubCopyright            = 'Compiled from the original distributed source tree.';

  { DO change these when compiling! }
  CompileDate             = '23-Sep-98';
  CompiledBy              = 'OH7LZB';

  { Feel free to change these after making some progress. Just make sure
    you've changed SubVersion to your own befoure touching these. }
  Versio                  = SubVersion + '-1.00';
  CluID                   = 'Clusse-100';

  Processor               = {$IFDEF Use_8088} '(8088)'  {$ENDIF}
                            {$IFDEF Use_8086} '(8086)'  {$ENDIF}
                            {$IFDEF Use_286}  '(80286)' {$ENDIF} ;
Var

  DosVer                : Word;         { DOS versio }

  InfoStr               : String[80];
  QTHLoc                : String[6];

  PauseAtStartup        : Boolean;

  HeapAtStartup,                        { Paljonko vapaata heappia alussa }
  HeapMinFree,                          { Pienin vapaa heap }
  HeapMinFreeMax,                       { Pienin vapaa heap block }
  HeapAllocs            : LongInt;      { Montako kertaa heappia varattu }

  OtherStaticMem        : Word;

  Watchdog              : Boolean;
  WatchTimer,
  WatchMax              : Word;

Const
  TicksPerSec           = 1193180 div 65536; { How many timer ticks per sec }
  WatchResetS           = 20 * 60;           { When to reboot in seconds    }
  WatchResetT           = WatchResetS * TicksPerSec; { .. in ticks }

Function HeapUsed:LongInt;                 { Paljonko heappia kytss }
Procedure Reboot(Method:BootMethod);       { Boottaa koneen }

Procedure SetInterrupts;
Procedure RestoreInterrupts;

Function Raise(w:LongInt;i:Byte):LongInt;  { Potenssiin korotus }
Procedure CriticalError(Const Situation:String;Errlvl:Byte); { Muu paha }

Function ErrorName(Num:Integer):String;
Procedure IOCheck(Const State:String);           { Tarkistaa IOResultin }

Procedure CPause;
Procedure CWriteLn(Const StrOut:String);

Procedure SystemInit;                      { Jrjestelmn configurointi }

 { ***************************************************************** }

Implementation
Uses Crt, Dos, Bpq, Unproto, Convers, Cluster, Files, Multitsk,
     Protocol, Screen, CStrings, XMSLib, Filters, Speech;
Var
  OrigExitProc   : Pointer;

  Int1BSave      : Pointer;
  Int1CSave      : Procedure;

  ConfLinePos    : Byte;

  Running        : Boolean;

 { ***************************************************************** }

Function HeapUsed:LongInt;                 { Paljonko heappia kytss }
Begin

 HeapUsed := HeapAtStartup - MemAvail;

End;

 { ***************************************************************** }
 { Boottaa koneen }

Procedure Reboot(Method:BootMethod);
Begin

 Case method of

   warm : Inline(
            $FB/                  { STI              }
            $B8/00/00/            { MOV   AX,0000    }
            $8E/$D8/              { MOV   DS,AX      }
            $B8/$34/$12/          { MOV   AX,1234    }
            $A3/$72/$04/          { MOV   [0472],AX  }
            $EA/$00/$00/$FF/$FF); { JMP   FFFF:0000  }

   cold : Inline(
            $FB/                  { STI              }
            $B8/01/00/            { MOV   AX,0001    }
            $8E/$D8/              { MOV   DS,AX      }
            $B8/$34/$12/          { MOV   AX,1234    }
            $A3/$72/$04/          { MOV   [0472],AX  }
            $EA/$00/$00/$FF/$FF); { JMP   FFFF:0000  }
 End;

End;

 { ***************************************************************** }
 { Watchdog timer ISR                                                }
 {$F+}

Procedure TimerHandler; interrupt;
Begin

  Inc(WatchTimer);
  If WatchTimer > WatchMax
    then WatchMax := WatchTimer;
  If WatchTimer >= WatchResetT
    then Reboot(cold);
  Inline($9C);
  Int1CSave;

End;

 { ***************************************************************** }
 { Break handler ISR                                                 }

Procedure BreakHandler; interrupt;
Begin
End;

 {$F-}
 { ***************************************************************** }

Procedure SetInterrupts;
Begin

 {$IFNDEF Debug}

 GetIntVec($1B,Int1BSave);
 SetIntVec($1B,Addr(BreakHandler));

 If Watchdog
   then Begin
        WatchTimer := 0;
        GetIntVec($1C,@Int1CSave);
        SetIntVec($1C,@TimerHandler);
        End;

 {$ENDIF}

End;

Procedure RestoreInterrupts;
Begin

 {$IFNDEF Debug}

 If Watchdog
   then SetIntVec($1C,@Int1CSave);  { Remove the watchdog... }
 SetIntVec($1B,Int1BSave);  { Break handling back to DOS... }

 {$ENDIF}

End;

 { ***************************************************************** }

Function Raise(w:LongInt;i:Byte):LongInt;     (* Potenssiin korotus *)
var
  l : Byte;   (* silmukkamuuttuja *)
  t : LongInt; (* vlitulos *)
Begin (* Raise *)

 t := w;

 If i > 1
   then For l := 2 to i
           do t := t * w
   else if i = 1
          then t := w
          else t := 1;

 Raise := t;

End; (* Raise *)

 { ***************************************************************** }

Function ErrorName(Num:Integer):String;
Begin

 Case Num of
      1 : ErrorName := 'Invalid function number';
      2 : ErrorName := 'File not found';
      3 : ErrorName := 'Path not found';
      4 : ErrorName := 'Too many open files';
      5 : ErrorName := 'File access denied';
      6 : ErrorName := 'Invalid file handle';
     12 : ErrorName := 'Invalid file access code';
     15 : ErrorName := 'Invalid drive number';
     16 : ErrorName := 'Cannot remove current directory';
     17 : ErrorName := 'Cannot rename across drives';
     18 : ErrorName := 'No more files';
    100 : ErrorName := 'Disk read error';
    101 : ErrorName := 'Disk write error';
    102 : ErrorName := 'File not assigned';
    103 : ErrorName := 'File not open';
    104 : ErrorName := 'File not open for input';
    105 : ErrorName := 'File not open for output';
    106 : ErrorName := 'Invalid numeric format';
    150 : ErrorName := 'Disk is write-protected';
    151 : ErrorName := 'Bad drive request struct length';
    152 : ErrorName := 'Drive not ready';
    154 : ErrorName := 'CRC error in data';
    156 : ErrorName := 'Disk seek error';
    157 : ErrorName := 'Unknown media type';
    158 : ErrorName := 'Sector not found';
    159 : ErrorName := 'Printer out of paper';
    160 : ErrorName := 'Device write fault';
    161 : ErrorName := 'Device read fault';
    162 : ErrorName := 'Hardware failure';
    200 : ErrorName := 'Division by zero';
    201 : ErrorName := 'Range check error';
    202 : ErrorName := 'Stack overflow error';
    203 : ErrorName := 'Heap overflow error';
    204 : ErrorName := 'Invalid pointer operation';
    205 : ErrorName := 'Floating point overflow';
    206 : ErrorName := 'Floating point underflow';
    207 : ErrorName := 'Invalid floating point operation';
    208 : ErrorName := 'Overlay manager not installed';
    209 : ErrorName := 'Overlay file read error';
    210 : ErrorName := 'Object not initialized';
    211 : ErrorName := 'Call to abstract method';
    212 : ErrorName := 'Stream registration error';
    213 : ErrorName := 'Collection index out of range';
    214 : ErrorName := 'Collection overflow error';
    215 : ErrorName := 'Arithmetic overflow error';
    216 : ErrorName := 'General Protection fault';
 Else ErrorName := 'Illegal Error ' + Int2Str(Num) + ' (UGH!)';
 End;

End;

 { ***************************************************************** }

Procedure IOCheck(Const State:String);
Var
 ErrorNum : Integer;
 s        : String;
Begin

 ErrorNum := IOResult;
 If ErrorNum > 0
   then Begin
        CloseScreen;
        s := 'I/O Error ' + Int2Str(ErrorNum) + ' occurred while ' + State + ':' + CrLf
           + '  ' + ErrorName(ErrorNum) + CrLf
           + '  Uptime ' + Secs2Str(UpTime);

        LogError(s);
        WriteLn(CrLf + DateStr(Now) + ' ' + TimeStrL(Now) + ' ' + s + CrLf);
        freeAllXMS;

        Halt(10);

        End;

End;

 { ***************************************************************** }

Procedure CriticalError(Const Situation:String;Errlvl:Byte); { Muu paha }
Var
  b    : Byte;
  regs : Registers;
Begin

 CloseScreen;
 WriteLn(CrLf + ' Critical: ' + Situation + CrLf);
 LogError(Situation);
 WriteLast('Clusse',DateStrSPad(now) + ' ' + TimeStrS(now) + ' - Critical shutdown!');

 Cut_Monitor;

 { Disc & Suljetaan streamit }
 Case Conf^.Ifc.IfType of

   G8BPQ : For b := 1 to Conf^.Ifc.No_Ports
             do Begin
                regs.ah := $06; { Disconnect stream }
                regs.cx := $02;
                regs.al := Stream[b];
                intr(Conf^.Ifc.BPQInt,regs);
                regs.ah := $01; { Close stream }
                regs.dl := $00;
                regs.cl := $00;
                regs.al := Stream[b];
                intr(Conf^.Ifc.BPQInt,regs);
                End;

 End;

 IfClose;
 freeAllXMS;
 Halt(Errlvl);

End;

 { ***************************************************************** }

Function HeapErrorHandler(Size : Word):integer; far;
Begin

 Inc(HeapAllocs);

 If Size > 0 then
  Begin
  CloseScreen;
  WriteLn(CrLf + CrLf + '    Out of memory !' + CrLf + CrLf
          + ' Cannot allocate a block of ' + Int2Str(Size) + ' bytes from the heap.');
  WriteLn(' Total ' + Int2Str(MemAvail) + ' bytes free heap, largest free block ' + Int2Str(MaxAvail) + ' bytes.' + CrLf);
  LogError('Out of memory: ' + Int2Str(Size) + ' requested, '
         + Int2Str(MemAvail) + ' free, largest ' + CrLf
         + '  ' + Int2Str(MaxAvail) + ' bytes. Uptime ' + Secs2Str(UpTime) );
  If Running then WriteLast('Clusse',DateStrSPad(now) + ' ' + TimeStrS(now) + ' - Crash: Out of memory.');
  freeAllXMS;
  IfClose;
  Halt(11);
  End;

 HeapErrorHandler := -2;

End;

 { ***************************************************************** }
 {$IFNDEF Debug}

Procedure ExitProcedure; Far;
Var s : String;
Begin

 ExitProc := OrigExitProc;
 IfClose;
 Speech.UnInstall;

 If Assigned(ErrorAddr) then { Run-time error }
   Begin

   CloseScreen;
   While (not (IBuffer[0] = #0)) and (IBuffer[Length(IBuffer)] = Cr)
      do Dec(IBuffer[0]);

   s := 'Run-time error ' + Int2Str(ExitCode) + ' at ' + Pointer2Str(ErrorAddr) + ':' + CrLf
      + '  ' + ErrorName(ExitCode) + CrLf
      + '  ib: ' + IBuffer + CrLf
      + '  Uptime ' + Secs2Str(UpTime);
   LogError(s);
   If Running then WriteLast('Clusse',DateStrSPad(now) + ' ' + TimeStrS(now) + ' - Crash: Run-time error.');
   WriteLn(CrLf + DateStr(Now) + ' ' + TimeStrL(Now) + ' CLUSSE:  ' + s + Cr);
   freeAllXMS;

   ErrorAddr := nil;
   ExitCode := 99;

   RestoreInterrupts;

   End
 else WriteLn(DateStr(Now) + ' ' + TimeStrL(Now) + ' Clusse Exit - Errorlevel ' + Int2Str(ExitCode)
          + ' - Uptime ' + Secs2Str(UpTime));

End;

 {$ENDIF}
 { ***************************************************************** }

Procedure CPause;
Var
  Ch : Char;
Begin

 Write(' *** Press any key to continue...');
 Ch := ReadKey;
 GotoXy(1,WhereY);
 ClrEol;

End;

 { ***************************************************************** }

Procedure CWriteLn(Const StrOut:String);
Begin

 WriteLn(StrOut);
 If PauseAtStartup
   then Begin
        Inc(ConfLinePos);
        If ConfLinePos = Hi(WindMax)
          then Begin
               CPause;
               ConfLinePos := 1;
               End;
        End;
End;

 { ***************************************************************** }

Procedure ParamHelp;
Begin

  Write('    Valid parameters:' + CrLf + CrLf
      + ' -h : Parameter help' + CrLf
      + ' -c : Create clusse.chr, a ''clean'' character translation table.' + CrLf);
  Write(' -d : Use a different root directory for Clusse files. For example' + CrLf
      + '      ''-dc:\clu\''. Default is the executable directory.' + CrLf
      + ' -e : Disable expiry' + CrLf
      + ' -i : Release timeslice through DPMI when idle' + CrLf
      + ' -n : Disable linking' + CrLf
      + ' -m : Disable band monitoring code' + CrLf);
  Write(' -p : Wait for a keypress at startup before switching to windowed mode.' + CrLf
      + ' -t : Use a different directory for temporary files. Like -d in syntax.' + CrLf
      + ' -w : Enable software watchdog (reboots if stuck) (EXPERIMENTAL!)' + CrLf
      + ' -x : Disable XMS usage' + CrLf
       );

  Halt(0);

End;

 { ***************************************************************** }
 { XMS init }

Procedure MemoryInit;
Begin

 Write(' o XMS: ');
 If xmsDisabled
   then Begin
        xmsPresent := False;
        CWriteLn('Disabled.');
        end
   else Begin
        detectXMS;
        If XMSPresent
          then Begin
               CWriteLn('Version ' + PrintXMSVersion + ', XMM ' + PrintXMMVersion + '. '
                   + Int2Str(XMSTotalFreeMemory) + ' KB free, largest block '
                   + Int2Str(XMSLargestBlock) + ' KB.');
               End
          else CWriteLn('Not present.');
        End;

End;

 { ***************************************************************** }

Procedure SystemInit;

Var
    CharTableF  : File of CharTable;       { *.chr }

    ErrNr       : Integer;

    i           : LongInt;
    b           : Byte;
    m           : Word;
    s           : String;
    st          : String[50];
    ch          : Char;

 { *************** }
Procedure FormatError;
Begin
 Write( CrLf + '  Error on line ',ConfLineNr,', position ',errnr,'!' + CrLf);
 Halt(1);
End;
 { *************** }
Procedure Settingerror(S:String);
Begin
  Write(CrLf + '  Error in configuration !' + CrLf + ' ' + S + CrLf + CrLf);
  Halt(1);
End;
 { ***************************************************************** }
Function RColorSet:Byte;

Var S    : String;
    Tavu : Byte;
Begin

 S := GetConfLine;

 If Length(S) <> 2 then Begin
                        ErrNr := Length(S);
                        SettingError('Color setting must be 2 characters long!');
                        End;

 Case LowCaseCh[S[1]] of
  '0' : Tavu := 0;
  '1' : Tavu := 1;
  '2' : Tavu := 2;
  '3' : Tavu := 3;
  '4' : Tavu := 4;
  '5' : Tavu := 5;
  '6' : Tavu := 6;
  '7' : Tavu := 7;
  '8' : Tavu := 8;
  '9' : Tavu := 9;
  'a' : Tavu := $a;
  'b' : Tavu := $b;
  'c' : Tavu := $c;
  'd' : Tavu := $d;
  'e' : Tavu := $e;
  'f' : Tavu := $f;
  else Begin
       ErrNr := 1;
       SettingError('Invalid color setting on line ' + Int2Str(ConfLineNr) + '!');
       End
 End;

 Tavu := Tavu shl 4;

 Case LowCaseCh[S[2]] of
  '0' : Tavu := Tavu or 0;
  '1' : Tavu := Tavu or 1;
  '2' : Tavu := Tavu or 2;
  '3' : Tavu := Tavu or 3;
  '4' : Tavu := Tavu or 4;
  '5' : Tavu := Tavu or 5;
  '6' : Tavu := Tavu or 6;
  '7' : Tavu := Tavu or 7;
  '8' : Tavu := Tavu or 8;
  '9' : Tavu := Tavu or 9;
  'a' : Tavu := Tavu or $a;
  'b' : Tavu := Tavu or $b;
  'c' : Tavu := Tavu or $c;
  'd' : Tavu := Tavu or $d;
  'e' : Tavu := Tavu or $e;
  'f' : Tavu := Tavu or $f;
  else Begin
       ErrNr := 2;
       SettingError('Invalid color setting on line ' + Int2Str(ConfLineNr) + '!');
       End
 End;

 RColorSet := Tavu;

End;
 { ***************************************************************** }

Procedure IllegalParameter(Num:Byte);
Begin
 WriteLn('   Illegal parameter ''' + ParamStr(Num) + '''!');
 WriteLn(' See the -help option...');
 Halt(2);
End;

 { ***************************************************************** }

 Begin { Init }

  UseDirectVideo := True;
  DirectVideo := False;
  ClrScr;
  b := Hi(WindMax);
  Window(1,1,80,1);
  TextAttr := $1b;
  ClrScr;
  Write(Center('-=-=-=-  OH7LZB Clusse ' + Versio + ' (' + CompileDate + '/' + CompiledBy + ') '
      + ' startup  -=-=-=-'));
  Window(1,2,80,b+1);
  GotoXY(1,Hi(WindMax)-5);
  TextAttr := OrigAttr;

  { Init variables }
  Running := False;
  DosVer := DosVersion;
  PauseAtStartup := False;
  ConfLinePos := 1;
  Randomize;
  ErrNr := 0;

  HeapAllocs := 0;
  HeapAtStartup := MemAvail;
  HeapMinFree := HeapAtStartup;
  HeapMinFreeMax := MaxAvail;
  OtherStaticMem := 0;

  xmsDisabled := False;
  Watchdog := False;
  WatchMax := 0;

  PCLinksC := 0;

  { Some code actually requires DOS 3.0 }
  If (Lo(DosVer) < 3)
    then Begin
         WriteLn(' DOS 3.0 or newer required!');
         Halt(9);
         End;

 { Kellonaika }
  GetDate(Dt.Year,Dt.Month,Dt.Day,DayOfWeek);
  GetTime(Dt.Hour,Dt.Min,Dt.Sec,m);
  PackTime(Dt,Now);
  StartUpTime := Now;

 { Directories }
  { Root }
  FSplit(ParamStr(0),CluPath,S,S);
  { Temp }
  TempPath := CluPath; { Default }
  s := GetEnv('tmp'); { Environment variables tmp and temp }
  If s <> '' then TempPath := s;
  s := GetEnv('temp');
  If s <> '' then TempPath := s;

 { Tarkistetaan parametrit }
  If ParamCount > 0 then
    for i := 1 to ParamCount do
      Begin
      s := ParamStr(i);
      If (s[1] = '-') or (s[1] = '/')
        Then Case LowCaseCh[s[2]] of

               'h','?' : ParamHelp;
               'c'     : MakeCharTableFile;
               'd'     : CluPath := Copy(S,3,Length(s)-2);
               'e'     : ExpiryOK := False;
               'i'     : ReleaseTime := True;
               'n'     : PCLinksC := 255;
               'm'     : IfMonitor := False;
               'p'     : PauseAtStartup := True;
               't'     : TempPath := Copy(s,3,Length(S)-2);
               'w'     : Watchdog := True;
               'x'     : xmsDisabled := True;

             else IllegalParameter(i);
             End { Case }
        else IllegalParameter(i);
      End;

  CluPath := LowCaseStr(CluPath);
  If CluPath[Length(CluPath)] <> '\'
    then CluPath := CluPath + '\';
  TempPath := LowCaseStr(TempPath);
  If TempPath[Length(TempPath)] <> '\'
    then TempPath := TempPath + '\';
  DataPath     := CluPath + 'data\';
  uDataPath    := CluPath + 'userdata\';
  DataBasePath := CluPath + 'db\';
  LogPath      := CluPath + 'log\';
  TextPath     := CluPath + 'text\';
  UserPath     := CluPath + 'user\';
  IncomingPath := UserPath + 'incoming\';
  PgPath       := CluPath + 'pg\';
  SpeechPath   := CluPath + 'speech\';

  SwapFileName := TempPath + 'clusse.swp';
  Comspec := GetEnv('COMSPEC');

 { Initialize interrupt handlers }
  SetInterrupts;

 {$IFNDEF Debug}
 { Heap error handler }
  HeapError := @HeapErrorHandler;
 { Exit procedure }
  OrigExitProc := ExitProc;
  ExitProc := @ExitProcedure;
 {$ENDIF}

  CWriteLn(' o Using ' + CluPath + ' as root directory.');
  CWriteLn(' o Multitaskers: ');

  If Multitaskers
   then Begin
        If DesqViewActive
          then CWriteLn('    DesqView version ' + DesqViewVerStr + ' detected.');
        If WindowsActive
          then CWriteLn('    Windows ' + WindowsVerStr + ' in ' + WindowsModeStr + ' mode detected.');
        If OS2Active
          then CWriteLn('    OS/2 Warp version ' + OS2VerStr + ' detected.' + Cr);
        If DPMIActive
          then CWriteLn('    DPMI version ' + DPMIVerStr + ' detected.');
        End
   else CWriteLn('    None detected.');

  If not FileExists(CluPath + 'links.ini') then PCLinksC := 255;

  InitScreen;       { Nytt }
  MemoryInit;       { Muisti }
  Files.InitPaths;  { Hakemistot }

 { Luetaan configit }

  Write(' o Reading clusse.cfg... ');
  b := ConfFile.ReadConfig;
  If b <> 0
    then Begin
           Case b of
             1 : s := 'File ' + CluPath + 'clusse.cfg not found (or I/O error)';
             2 : s := 'File corrupted (signature check failed)';
             3 : s := 'Wrong configuration file version';
           else s := 'Illegal error';
           End;
         WriteLn('oooops:' + CrLf + '   ' + s);
         Halt(1);
         End;
  Inc(OtherStaticMem,SizeOf(Conf^));
  CWriteLn('Done.');

  Write(' o Reading charsets.ini...');
  If FileExists(CluPath+'charsets.ini')
   then Begin
        AssignConf(CluPath+'charsets.ini');
        ErrNr := 0;

        Val(GetConfLine,i,ErrNr); If (ErrNr = 0) and (I >= 0) and (I <= 5)
                                then CharSets := i
                                else FormatError;

        Val(GetConfLine,i,ErrNr); If (ErrNr = 0) and (I >= 0) and (I <= 5)
                                then DefaultCharSet := i
                                else FormatError;

        If CharSets > 5 then SettingError('You can have only 5 character sets.');
        If DefaultCharSet > CharSets then SettingError('Illegal default charset.');
        Write(' ' + Int2Str(CharSets) + ' sets.');
        If CharSets > 0
         then Begin { Luetaan tiedostot }
              Write(' Reading table files: ');
              For i := 1 to CharSets do
                Begin
                s := GetConfLine;
                Val(s[1],b,ErrNr); { Taulun numero }
                If (ErrNr <> 0) or (b > CharSets) or Assigned(CharSet[b])
                   then FormatError;
                Write(Int2Str(b) + ',');
                If CharSet[b] = nil then New(CharSet[b])
                                    else SettingError('Cannot redefine a character table.');
                m := Pos(' ',s) + 1;
                s[m-1] := '_';
                st := Copy(s,m,Pos(' ',s)-m) + '.chr';
                Assign(CharTableF,CluPath + st);
                Reset(CharTableF);
                If IOResult <> 0 then SettingError('Character table file ' + CluPath + st + ' not found.');
                Read(CharTableF,CharSet[b]^.Table);
                Close(CharTableF);
                IOCheck('reading ' + st);
                m := Pos(' ',s) + 1;
                While (m < Length(s)) and (s[m] = ' ') do Inc(m);
                CharSet[b]^.Desc := Copy(s,m,Length(s)-m+1);
                End;
              End;
        CloseConf;
        CWriteLn('Done.');
        End
   else Begin
        CWriteLn(' file not found, translation tables disabled.');
        CharSets := 0;
        DefaultCharSet := 0;
        End;

 { Protokollapuoli }
  Protocol.Init;

  If (PCLinksC = 0)
    then Begin
         Write(' o Reading links.ini...');
         Protocol.ReadConfig;
         End
    else Begin
         CWriteLn(' o Linking disabled (links.ini not found or -n parameter used).');
         LinkPorts := 0;
         PCLinksC := 0;
         CLinksC := 0;
         End;
  UsrPorts := Conf^.Ifc.No_Ports - LinkPorts;

 { UI user interface }
  Unproto.Init;

 { Band table }
  Filters.Init;

 { Tiedostot kuntoon }
  Files.InitFiles;
  Convers.Init;

 { Puheet }
  Speech.Init;

  Write(' o Initializing ');

  Case Conf^.Ifc.IfType of
    G8BPQ : Write('the G8BPQ interface...');
    Flex  : Write('the PC/FlexNet interface...');
  End;

  b := IfInit;

  If b = 0
    then CWriteLn(' OK.')
    else Begin
         Case b of

           1 : WriteLn(Crlf + '   G8BPQ switch code not found! Wrong interrupt settings perhaps?');
           2 : WriteLn(Crlf + '   The G8BPQ switch is too old. 4.05 or newer required, ' + IfVersion + ' found.');
           3 : WriteLn(CrLf + '   PC/FlexNet kernel not found!');

         End;
         Halt(1);
         End;

  If PauseAtStartup then CPause;
  CWriteLn(' o Opening windows...');

  InitWindows;
  SetCursorSize(Off);

 { Lopputekstit }

  Action(65,'Ready.');
  Log(L_UpDown,'Initialized ' + Versio + ' (' + CompileDate + ') ' + Processor);
  WriteLast('Clusse',DateStrSPad(now) + ' ' + TimeStrS(now) + ' - Initialized ' + Versio);
  Unproto.UI_Index;
  Running := True;

  TextAttr := Pal^[cmRxCon];

  Display(Cr+'  OH7LZB Clusse ' + Versio + ' (' + CompileDate +  '/' + CompiledBy + ') '
               + Processor {$IFDEF debug} + ' (Debug)' {$ENDIF} + Cr
          + '  DX-Cluster/Conference software initialized as ' + CluCall + '.' + Cr + Cr
          + ' ' + Copyright + Cr + ' ' + Author_address + Cr);

  Display(' ' + Licence + Cr + ' ' + SubCopyright + Cr + Cr);

  {$IFDEF Debug}
  Display(' This is a debugging version - not to be distributed!' + Cr + Cr);
  {$ENDIF}

  Display('  Running under DOS ' + Int2Str(Lo(DosVer)) + '.' + Int2Str(Hi(DosVer)) + '.' + Cr);
  If DesqViewActive
    then Display('  DesqView v' + DesqViewVerStr + ' detected.' + Cr);
  If WindowsActive
    then Display('  Microsoft Windows ' + WindowsVerStr + ' in ' + WindowsModeStr + ' mode detected.' + Cr);
  If OS2Active
    then Display('  OS/2 Warp v' + OS2VerStr + ' detected.' + Cr);
  If DPMIActive
    then Begin
         Display('  DPMI v' + DPMIVerStr + ' detected.');
         If ReleaseTime
           then Display(' Releasing timeslice when idle.');
         Display(Cr);
         End;

  Case Conf^.Ifc.IfType of

    G8BPQ : Begin
            Display('  G8BPQ Packet Switch v' + IfVersion + ' initialized.' + Cr);
            Display('  Using BPQ Application number ' + Int2Str(Conf^.Ifc.Applnum)
                  + ', streams ' + Int2Str(Conf^.Ifc.Start_port+1) + '-' + Int2Str(Conf^.Ifc.No_ports+Conf^.Ifc.Start_port)
                  + ' (total ' + Int2Str(Conf^.Ifc.No_ports) + ').' + Cr
                  + '   ' + Int2Str(LinkPorts) + ' streams allocated for linking.' + Cr);
            End;

    Flex  : Begin
            Display('  PC/FlexNet kernel v' + IfVersion + ' initialized. Maximum ' + Int2Str(UsrPorts) + ' users allowed.'
                   + Cr);
            End;

  End;

  Display('  ' + int2Str(MemAvail) + ' bytes free base memory.' + Cr);
  If XMSPresent then
  Display('  XMS Version ' + PrintXMSVersion + ', XMM ' + PrintXMMVersion + '. '
                 + Int2Str(XMSTotalFreeMemory) + ' KB free, largest block '
                 + Int2Str(XMSLargestBlock) + ' KB.' + Cr
                 + '   ' + Int2Str(XMSUsed) + ' KB allocated by Clusse.' + Cr);

  If Watchdog
    then Display('  Software watchdog installed.' + Cr);

  If Conf^.Sound.SoundHW <> SHW_none
    then Begin
         Display('  Speech code initialized.' + Cr);
{         Speech.CW('DE ' + Conf^.Sound.Mycall + ' K');}
         End;

{  Display('  Video segment is at ' + HexW2Str(VideoSeg) + Cr);}

  Display(Cr);

 End; { Init }

 { ***************************************************************** }

End.
