{$F-} {$I-} {$R+} {$Q-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

 (*

  Stream mode integers:
    0: Disconnected
    1: Clusse ("normal" cluster command mode)
    2: Conference
    3: CluLink protocol (unimplemented)
    4: PacketCluster link (mostly implemented)
    5: Linking
    6: Conversd link (almost implemented, but commented out in the source)
    7: Console connect (from console to the BPQ node)
    10: ThrowOut (being disconnected)

 *)

Unit BPQ;

  { Implements a sort of socket abstraction layer to protect the rest
    of the code from seeing the ugly BPQ "stream" interface (which is
    actually a block interface), or the very different PC/FlexNet
    API. Also provides some callsign handling functions and does
    the band monitoring. Hey, even some IP/TCP/UDP/ARP decoding! }

Interface
Uses Dos, Files, Protocol, ConfFile, Filters;

Type
  AX25Call = Record
             Call : String[6];
             SSID : Byte;
             End;
  pAX25Call = ^AX25Call;

  { In/Out buffer types }
  InBuffer    = String[255];
  OutBuffer   = Array [1..255] of Byte;
  PacketQP    = ^PacketQ;
  PacketQ     = Record
                Data : OutBuffer;
                Next : PacketQP;
                End;

  tSMode      = (SM_Disc,     SM_Clusse,  SM_Convers,  SM_CluLink,
                 SM_PCLink,   SM_Linking, SM_ConvLink, SM_Console,
                 SM_ThrowOut );
  SockMType   = (Raw,Ascii);

  SocketTypeP = ^SocketType;
  SocketType  = Record
                Mode          : tSMode;       { What sort of socket is this }

                { Parameters }
                Paclen        : Byte;       { Paclen }
                MaxFrame      : Byte;       { MaxFrame }
                CharSet       : Byte;       { Character conversion table }
                SockMode      : SockMType;  { Socket mode (raw/ascii) }

                { Timers }
                Usr_Inactive  : Word;       { User inactive (min) }
                Link_Inactive : Word;       { Link inactive (min) }

                { Traffic counters }
                Tx, Rx        : LongInt;    { sent / received }

                { Buffers }
                InBuf         : InBuffer;   { Incoming data }
                OutBuf        : OutBuffer;  { Outgoing data }
                OutBufPos     : Byte;       { Position in the outgoing buf }
                OutBPQBuf     : PacketQP;   { BPQ front buffer (unused/unimplemented) }

                { Tracing }
                Traced        : Boolean;    { Are we tracing this }
                Tracefile     : String[12]; { Trace log file }
                End;

  LUserP      = ^LUserRec;
  LUserRec    = Record
                f             : LUserFP;    { -> LUserFRec }
                n             : NUserRecP;  { -> NUserRec }
                fl            : FlRecP;     { -> FlRec }
                Group         : Byte;       { Effective group }

                M2, M3        : Byte;       { "submodes" in the Clusse mode }
                M4            : LongInt;

                MTimer        : LongInt;    { submode timer }
                Seed          : Word;       { another }
                Str           : String;     { submode string }
                Path          : PathStr;    { Current "dos" directory }

                LastTalkFrom  : String[20];   { Who sent the last talk }
                Illegals      : Byte;         { How many subsequent bad commands }
                SUTries       : Byte;         { How many failed SU tries }
                Here          : Boolean;      { Here or not? }
                AwayStrP      : ^tAwayString; { Away string }
                Locked        : Boolean;      { Lock used in some loops }
                End;

Const
  MaxDigis    = 8;

Type

  UIPacketP   = ^UIPacketRec;    { Defines an UI frame, used for sending }
  UIPacketRec = Record           { and receiving broadcasts }
                Port        : Byte;
                FromCall    : AX25Call;
                ToCall      : AX25Call;
                DigiPath    : Array[1..MaxDigis] of AX25Call;
                Digis       : Byte;
                Data        : String;
                End;

Const
  ModeStr : Array[SM_Disc..SM_ThrowOut] of String[7] =
    ('Disconn','Clusse ','Convers','CluLink','PC Link','Linking','ConvLnk','Console','Leaving');
  SmStr   : Array [Raw..Ascii] of Char = ('R', 'A');
  SockMax = 64;

Var

  IfInited        : Boolean;           { Is the interface (PC/FlexNet or BPQ) initialized }

  IfMonitor       : Boolean;           { Are we monitoring the band }

  AXCluCall       : AX25Call;          { Cluster AX.25 callsign }

  UsrPorts,                            { How many user sockets allocated }
  LinkPorts,                           { How many link sockets allocated }
  ApplMask    : Byte;                  { Application mask (BPQ funnies) }

  IfVersion  : String[5];              { Interface software version }
  IfVMajor,
  IfVMinor   : Byte;                   { as well, used for version comparisons }

  OBuffer    : String[255];               { Outgoing temporary data buffer }

  Sock       : Array[0..SockMax] of SocketTypeP; { Sockets }
  Stream     : Array[0..SockMax] of Word;        { Socket => stream lookup }
  SockNum    : Array[0..SockMax] of Byte;        { Stream => socket lookup }
  LUser      : Array[0..SockMax] of LUserP;      { Local user }
  Port       : Array[1..SockMax] of LinkRecP; { which link port for socket }

  BPQSocks   : Byte;                        { How many BPQ sockets allocated }

  LUserCount : Byte;                        { How many local users }
  LoginCount : LongInt;                     { Connections since last reboot }

  FrMon,                                    { Frames monitored }
  FrSent,                                   { Frames sent }
  FrRec      : LongInt;                     { Frames received }

  MinBuf,                                   { Low BPQ internal buf watermark }
  MaxBuf     : Byte;                        { High ... }

Function GetLUser(Const Call:CallRec):Byte;  { Find local user for callsign }
Function GetLUserS(Call:CallRec):Byte; { Find local user, not checking the SSID }

Function BPQ_loaded:Boolean;           { Do we have BPQ loaded }

Function User_frames(p:Byte):Word;
Function IfBuffers:Byte;               { How many buffers free in BPQ }

Procedure ForceNodeBC;                 { Make BPQ send a node broadcast }

Function BPQ_CheckState(p:Byte):Byte;    { Has the BPQ stream state changed }
Function Flex_GetCon:Byte;               { Has the PC/FlexNet kernel have any new connections for us }
Function Flex_CheckStream(p:Byte):Byte;  { Check PC/FlexNet stream state  }

Function Get_Callsign(p:Byte):String;    { Get the peer callsign from the interface }
Function GetMaxFrame(p:byte):byte;       { Get the maxframe... }
Function GetSockPort(b:Byte):Byte;       { Which physical port is the connection on }

Function StripSSID(Call:CallRec):String;  { Strip SSID of the callsign }
Function SSID(Call:CallRec):Byte;         { Strip the callsign, return SSID }
Function ValidCall(Call:CallRec):Boolean; { Check if the callsign is a "valid" callsign }

Function Get_resp(p:Byte):Boolean;       { Poll stream for new received data }

Procedure Kick(p:Byte);                { Flush the socket buffer }
Procedure Send(p:Byte;Const Text:String);    { Send data on the stream, flush at paclen only }
Procedure SendUI(Packet:UIPacketP);    { Send an UI frame }

Procedure Login(sok:byte);             { Socket has been opened }
Procedure Logout(p:byte);              { Socket has been closed }

Procedure BPQ_Connect(p:Byte);         { Connect this stream to the BPQ node }
Function Flex_Connect(Const Source,Dest:String):Word; { PC/FlexNet Connect }
Procedure Disconnect(p:Byte);          { Disconnect the stream *now* }
Procedure ThrowOut(p:Byte);            { Disconnect "nicely" (after some time to allow the transmit buffers to clean) }

Procedure OpenStream(p:Byte);          { Initialize stream for use }
Procedure CloseStream(p:Byte);         { Close stream after use }

Procedure Toggle_Monitor;              { Toggle band monitoring }
Procedure Cut_Monitor;                 { Disable monitoring in BPQ }
Procedure Band_Monitor;                { Monitor the band }

Procedure SecTimer;                    { Called once a second }
Procedure MinTimer;                    { Called once a minute }
Function  IfInit:Byte;                 { Initialize the interface at startup }
Procedure IfClose;                     { Close the interface at shutdown }

 { Komennot }
Procedure Socketlist_Cmd(p:Byte);       { User command: list sockets }

 { ==== ==== ==== ==== ==== ==== ==== ==== ==== ==== ==== ==== ==== }

Implementation
uses FlxApp, Cluster, Config, Convers, Crt, Multitsk, Screen, CStrings,
     Unproto;

Var
  BPQbuff    : Array [1..400] of Byte;          { BPQ API I/O buf }
  Regs       : Registers;                       { Registers, used for BPQ API }

 { ***************************************************************** }

Procedure CallBPQ;
Begin

 {$IFDEF DPMI}
   { I once tried to figure out how to make Clusse run in protected
     mode, with DPMI, but failed to figure out how to call BPQ from
     there. This is probably the only thing you should need to fill
     to get it working... aha, and the DOS shell too. }
 {$ELSE}
 Intr(Conf^.Ifc.BPQint,Regs);
 {$ENDIF}

End;

 { ***************************************************************** }
 { Is BPP loaded }

Function BPQ_loaded: Boolean;
Var
  Seg ,ofs  : word;
  Seg1,ofs1 : word;
  i         : Byte;
  St        : String[5];

Begin
  Seg := 0;
  Ofs := 4 * Conf^.Ifc.BPQInt;             { Address of Int }
  Ofs1 := memw[Seg:Ofs];               { Find address of BPQcode }
  Seg1 := memw[Seg:ofs+2];

  ofs1 := Ofs1 - 7;
  St := '';
  For I := 0 to 4 do
  Begin
    ofs := Ofs1 + I;
    St := St + Chr(mem[Seg1:Ofs]);     { Read byte from memory }
  End;

  If (St = 'G8BPQ') { Does it match string }
    then Begin
         BPQ_Loaded := True;
         IfVMajor := mem[Seg1:Ofs1+5];  { Get version }
         IfVMinor := mem[Seg1:Ofs1+6];
         IfVersion := Int2Str(IfVMajor) + '.' + IntStr(IfVMinor);
         End
    else BPQ_Loaded := False;

End;

 { **************************************************************** }
 { Paikallista kyttj etsitn .... }

Function GetLUser(Const Call:CallRec):Byte; { Etsii kyttjn }
Var
  b : Byte;
Begin

 b := 0;
 While (b <= UsrPorts) and not (Assigned(LUser[b])
       and (LUser[b]^.f^.Call = Call))
  do Inc(b);

 If b <= UsrPorts
   then GetLUser := b
   else GetLUser := 255;

End;

Function GetLUserS(Call:CallRec):Byte;
Var
  b : Byte;
Begin

 b := 0;
 While (b <= UsrPorts) and not (Assigned(LUser[b])
       and (StripSSID(LUser[b]^.f^.Call) = Call))
  do Inc(b);

 If b <= UsrPorts
   then GetLUserS := b
   else GetLUserS := 255;

End;

 { ***************************************************************** }
 { Paljonko buffereita nodessa vapaana }

Function IfBuffers:Byte;
Begin

 Case Conf^.Ifc.IfType of

  G8BPQ : Begin
          Regs.ah := 7;
          CallBPQ;
          IfBuffers := regs.dx;
          End;

  Flex  : IfBuffers := 0;

 End;

End;

 { ***************************************************************** }
 { Paljonko frameja jonossa streamilla }

Function User_frames(p:Byte):Word;
Begin

 If (p > 0) and (p < 65)
   then Case Conf^.Ifc.IfType of

          G8BPQ : Begin
                  Regs.ah := 7;
                  Regs.al := Stream[p];
                  CallBPQ;
                  User_frames := regs.Cx;
                  End;

          Flex  : User_frames := l2_unack(Stream[p]);

        End
   else User_frames := 0;
End;

 { ***************************************************************** }

Function GetPacLen(p:byte):byte; { Paclen streamille }
Var
  n   : byte;
  Str : String[11];
Begin

 If (p > 0) and (p < 65)
   then Case Conf^.Ifc.IfType of

         G8BPQ : Begin
                 Regs.ah := $08;
                 Regs.al := Stream[p];
                 Regs.di := Ofs(Str);
                 Regs.es := Seg(Str);
                 CallBPQ;
                 n := Regs.bx;
                 If (n > Conf^.Ifc.Max_Paclen) or (n = 0)
                   then n := Conf^.Ifc.Max_Paclen;
                 GetPacLen := n;
                 End;

         Flex  : GetPacLen := Conf^.Ifc.Max_Paclen;

        End
   Else GetPacLen := 230;

end;

 { ***************************************************************** }

Function GetMaxFrame(p:byte):byte; { Maxframe streamille }
Var
  n   : byte;
  Str : String[11];
Begin

 If (p > 0) and (p < 65)
   then Case Conf^.Ifc.IfType of

          G8BPQ : Begin
                  Regs.ah := $08;
                  Regs.al := Stream[p];
                  Regs.di := Ofs(Str);
                  Regs.es := Seg(Str);
                  CallBPQ;
                  If (regs.ax and 2 = 2)
                    then n := regs.dx
                    else n := regs.cx;
                  If (n = 0) then n := 8;
                  GetMaxFrame := n;
                  End;

          Flex  : GetMaxFrame := l2_maxframe(Stream[p]);

        End
   else GetMaxFrame := 8;

end;

 { ***************************************************************** }

Function GetSockPort(b:Byte):Byte;
Var
 fFrame : pFrame;
Begin

 If b = 0
  then GetSockPort := 255
  else Case Conf^.Ifc.IfType of

         G8BPQ : Begin
                 Regs.ah := 8;
                 Regs.al := Stream[b];
                 CallBPQ;
                 GetSockPort := Regs.al;
                 End;

         Flex  : Begin
                 fFrame := l2_get_f(Stream[b]);
                 GetSockPort := fFrame^.Kanal;
                 End;

       End;

End;

 { ***************************************************************** }

Procedure ForceNodeBC;
Begin

If (Conf^.Ifc.IfType = G8BPQ) and (IfvMajor >= 4) and (IfvMinor >= 8)
 then Begin
      regs.ah := 12;
      regs.dx := 2;
      CallBPQ;
      End;
End;

 { ***************************************************************** }
 { Onko streamin status muuttunut (Connect/Disconnect) }
 { 0 = ei, 1 = connect, 2 = disconnect }

Function BPQ_CheckState(p:Byte):Byte;
Var
  n : Byte;
Begin

 if (p > SockMax)
   then Begin
        BPQ_CheckState := 0;
        Exit;
        End;

 n := 0;
 regs.ah := $04;
 regs.al := Stream[p];
 CallBPQ;

 If regs.dx = 1
   then Begin
        If regs.cx <> 0
          then n := 1
          else n := 2;

        regs.ah := $05;
        regs.al := Stream[p];
        CallBPQ;

        If n = 1
          then BPQ.Login(p);

        End;

 Case n of

   1 : If Assigned(Sock[p]) and Sock[p]^.Traced
         then AppendF(CluPath + Sock[p]^.Tracefile,'** ' + TimeStrL(Now) + ' '
                      + DateStr(Now) + ' - Connected on stream ' + Int2Str(Stream[p]) + CrLf);

   2 : If Assigned(Sock[p]) and Sock[p]^.Traced
         then AppendF(CluPath + Sock[p]^.Tracefile,'** ' + TimeStrL(Now) + ' '
                      + DateStr(Now) + ' - Disconnected' + CrLf);

 End;

 BPQ_CheckState := n;

End;

 { ***************************************************************** }

Function Flex_GetCon:Byte;
Var
  w : Word;
  p : Byte;
Begin

 Flex_GetCon := 0;
 w := l2_pget_sabm(CluCall);
 If w > 0
   then Begin
        p := 1;
        While (p <= Conf^.Ifc.no_Ports) and not (Assigned(sock[p]) and false)
         do Inc(p);
        If p > Conf^.Ifc.no_Ports
         then Begin { New user }
              p := 1; { Find a free socket }
              While (p <= UsrPorts) and Assigned(sock[p])
               do Inc(p);
              If p <= UsrPorts { found one }
               then Begin
                    l2_sabmresp(w); { Accept the connection }
                    Stream[p] := w;
                    BPQ.Login(p);
                    Flex_GetCon := p;
                    End
               else l2_sabm_dm(w); { We're full, don't accept }
              End
         else Begin { Hey, we were waiting for this connection.. umm? duh }
              l2_sabm_dm(w);
              End;
        End;
End;

 { ***************************************************************** }

Function Flex_CheckStream(p:Byte):Byte;
Var
  w : Word;
Begin

 w := l2_state(Stream[p]);
 If (w = 0) or (w = 1)
   then Flex_CheckStream := 2 { Disconnected }
   else If Get_Resp(p)
          then Flex_CheckStream := 1  { Data queued }
          else Flex_CheckStream := 0; { Idle }

End;

 { ***************************************************************** }
 { Hakee streamissa kiinni olevan kutsun }

Function Get_Callsign(p:Byte):String;
Var n       : Byte;
    Strinki : String[10];
    pF      : pFrame;
Begin
If p > 0
  Then If Assigned(Sock[p])
          Then Begin
               Strinki := '';
               Case Conf^.Ifc.IfType of

                 G8BPQ : Begin
                         regs.ah := $08; { Get callsign }
                         regs.al := Stream[p];
                         regs.di := Ofs(BPQbuff);
                         regs.es := Seg(BPQbuff);
                         CallBPQ;

                         n := 1;	{ Strip callsign }
                         While (n < 11) and (Char(BPQbuff[n]) <> ' ')
                           do Begin
                              Strinki := Strinki + Chr(BPQbuff[n]);
                              Inc(n);
                              End;
                         End;

                 Flex  : Begin
                         pF := l2_get_f(Stream[p]);
                         Strinki := MkCallStr(pF^.Dest);
                         End;

               End;

               If (Sock[p]^.Mode = SM_CluLink) or (Sock[p]^.Mode = SM_PCLink)
                  or (Sock[p]^.Mode = SM_Linking)
                 then Strinki := Port[p]^.Call
               End
          else Strinki := 'Disc'
  else Strinki := Conf^.ConsoleCall;
Get_Callsign := Strinki;
End;

 { ***************************************************************** }

Function StripSSID(Call:CallRec):String;
Var
  b : Byte;
  s : CallRec;
Begin

 b := 1;
 s := '';

 While (b <= Length(Call)) and (Call[b] <> '-')
  do Begin
     s := s + Call[b];
     Inc(b);
     End;

 StripSSID := s;

End;

Function SSID(Call:CallRec):Byte;        { Kutsusta SSID }
Var
  b : Byte;
  s : String[3];
Begin

 b := Pos('-',Call);
 If b > 0 then Begin
               s := Copy(Call,b + 1,Length(Call)-b);
               SSID := Str2Word(s);
               End
          else SSID := 0;

End;

Function ValidCall(Call:CallRec):Boolean; { Onko hyvksyttv kutsu }
Var
  stat : Boolean;
  num,
  chr,
  b    : Byte;
  st   : CallRec;
Begin

 st := StripSSID(UpCaseStr(Call));
 stat := True;
 chr := 0;
 num := 0;

 For b := 1 to Length(st)
  do { Both letters and numbers? }
     If (Ord(Call[b]) >= 48) and (Ord(Call[b]) <= 57) { A number? }
       then Inc(num)
       else If (Ord(Call[b]) >= 65) and (Ord(Call[b]) <= 90) { A letter? }
              then Inc(chr)
              else { Neither! }
                   If not ((Call[b] = '/') or (Call[b] = '-')) { Exceptions, we allow these }
                     then stat := False;

 If not ((num > 0) and (chr > 1))
   then stat := False;

 ValidCall := stat;

End;

 { ***************************************************************** }
 { Onko tavaraa jonossa, jos on, rivillinen IBufferiin }

Function Get_resp(p:Byte):Boolean;
Var
  I       : Word;
  TBuffer : String[255];
  Ib      : PInfo;
Begin

 With Sock[p]^ do Begin

 Get_resp := False;

 I := Pos(Chr($0D),InBuf);

If I > 0
 then Begin
      IBuffer := Copy(InBuf,1,I);
      Delete(InBuf,1,I);
      Get_Resp := True;
      End
 else
  Begin

  Case Conf^.Ifc.IfType of

    G8BPQ : Begin
            regs.di := Ofs(BPQbuff);
            regs.es := Seg(BPQbuff);
            regs.ah := $03;
            regs.al := Stream[p];
            CallBPQ;
            End;

    Flex  : Begin
            Ib := l2_Get_i(Stream[p]);
            If Assigned(Ib)
              then Begin
                   regs.cx := Ib^.Length;
                   Move(Ib^.text,BPQBuff,256);
                   l2_i_ack(Stream[p]);
                   End
              else regs.cx := 0;
            End;

  End;

  If regs.cx > 0
    then Begin
         Inc(FrRec);
         Link_Inactive := 0;
         Usr_Inactive := 0;
         TBuffer := '';

         { Link RX countterit }
         Inc(Rx,Regs.cx);

         Case SockMode of

          Raw  : Begin
                 For i := 1 to Regs.cx
                   do TBuffer := TBuffer + Chr(BPQbuff[I]);
                 IBuffer := TBuffer;
                 Get_Resp := True;
                 End;

          Ascii : Begin

                  For I := 1 to Regs.cx do { Filter some bad stuff. }
                    If ((BPQbuff[I] > $1F) or (BPQbuff[I] = $0D) or (BPQbuff[I] = $07)
                       or (BPQbuff[I] = $09) or (BPQbuff[I] = $1A))
                      then TBuffer := TBuffer + Chr(BPQbuff[I]);

                  If CharSet > 0 { Character translation table }
                    then TBuffer := TranslateChSet(CharSet,TBuffer);

                  I := Pos(Chr($0D),TBuffer);

                  If (I > 0) or (Length(InBuf) = 255)
                    then Begin
                         IBuffer := InBuf + Copy(TBuffer,1,I);
                         InBuf := '';
                         Delete(TBuffer,1,I);
                         Get_Resp := True;
                         End;

                  InBuf := InBuf + TBuffer;
                  End;
         End;

         If Traced
           then AppendF(CluPath + Tracefile,'<- ' + TimeStrL(now) + ' ' + AddLf(IBuffer));
         End;
 End;
 End; { With... }
End;

 { ***************************************************************** }
 { Flush transmit buffer }

Procedure Kick(p:Byte);
Var Pack  : Array[1..255] of Byte;
    n     : Word;
    b     : byte;
    s     : String;
Begin

If (p <= SockMax) and Assigned(Sock[p])
then With Sock[p]^ do
If (OutBufPos > 0)
  then Begin
       If p > 0
         then Begin
              n := 0;
               Repeat

                Case Conf^.Ifc.IfType of

                  G8BPQ : Begin
                          b := 0;
                          Repeat
                            Inc(n); Inc(b);
                            Pack[b] := OutBuf[n];
                          until (n = OutBufPos) or (b = PacLen);
                          regs.cx := b;
                          regs.si := Ofs(Pack);
                          regs.es := Seg(Pack);
                          regs.ah := $02;
                          regs.al := Stream[p];
                          CallBPQ;
                          End;

                  Flex  : Begin
                          s := '';
                          b := 0;
                          Repeat
                            Inc(n); Inc(b);
                            s := s + Chr(OutBuf[n]);
                          until (n = OutBufPos) or (b = PacLen);
                          If l2_ialloc(Stream[p],b)
                            then Begin
                                 l2_send_Str(Stream[p],s);
                                 l2_pack(Stream[p]);
                                 End
                            else Begin
                                 l2_kill_qso(Stream[p]);
{                                 CriticalError('PC/FlexNet interface problem. I said this wouldn''t work!',21);
 }                                End;
                          End;
                End;

                Inc(FrSent);
               until n = OutBufPos;
              OutBufPos := 0;
              End;
       Link_InActive := 0;
       End;
End;

 { ***************************************************************** }
 { Flush all user sockets }

Procedure KickAss;
Var
 b : Byte;
Begin

 For b := 1 to UsrPorts
  do Kick(b);

End;

 { ***************************************************************** }
 { Put data to transmit buffer }

Procedure Send(p:Byte;Const Text:String);
var
  Inp : Byte;
  s   : String;
Begin

 If ((p > SockMax) or not assigned(Sock[p]))
   then exit; { Oijoi. Tthn ei saisi sattua. }
              { "Uh-oh. This shouldn't happen." }

 With Sock[p]^ do Begin

 { Character translation tables }
 If (SockMode = ascii) and (CharSet > 0)
   then s := TranslateChSet(CharSet,Text)
   else s := Text;

 { Link tx countteri }
 Inc(Tx,Length(s));

 { Trace }
 If Traced
   then Appendf(CluPath + Tracefile ,'-> ' + TimeStrL(now) + ' ' + AddLf(s));

 If p > 0
   then For Inp := 1 to Length(s) do
            Begin
            Inc(OutBufPos);
            OutBuf[OutBufPos] := Ord(s[Inp]);  { Convert char to byte }
            If OutBufPos = Paclen then Kick(p);
            End
   else Begin
        TextAttr := Pal^[cmRxRec];
        Display(s);
        Link_Inactive := 0;
        End;
 End; { With... }

end;

 { ***************************************************************** }

Procedure SendRaw(port:Byte;Data:String);
Var Pack : Array[1..255] of Byte;
    n    : Word;
Begin

 Case Conf^.Ifc.IfType of
   G8BPQ : Begin
           For n := 1 to Length(Data) do Pack[n] := Ord(Data[n]);
           regs.cx := n;
           regs.si := Ofs(Pack);
           regs.es := Seg(Pack);
           regs.ah := $10;
           regs.al := port;
           CallBPQ;
           End;
 End;

 Inc(FrSent);

End;

 { ***************************************************************** }

Procedure BPQ_SendUI(Packet:UIPacketP);    { Lhet UI frame }
Var
 b     : Byte;
 w     : Word;

 Procedure Callsign(Kutsu:AX25Call);
 Var
   i : Byte;
 Begin

 For i := 1 to Length(Kutsu.Call)
  do Begin
     Inc(w);
     BPQBuff[w] := Ord(Kutsu.Call[i]) shl 1;
     End;

 While i < 6 { Pad with spaces }
  do Begin
     Inc(i);
     Inc(w);
     BPQBuff[w] := $40;
     End;

 Inc(w); { SSID }
 BpqBuff[w] := (Kutsu.SSID and $0f) shl 1;

 End;

Begin

With Packet^ do
 Begin
 w := 0;

 { To }
 Callsign(ToCall);
 BpqBuff[w] := BpqBuff[w] or $e0;

 { From }
 Callsign(FromCall);
 BpqBuff[w] := ((FromCall.SSID and $0f) shl 1) or $60;

 { Digipeaters }
 For b := 1 to Digis
  do Callsign(DigiPath[b]);
 BpqBuff[w] := BpqBuff[w] or $01;  { This is the last one }

 { Control }
 Inc(w);
 BpqBuff[w] := $03; { UI }

 { PID }
 Inc(w);
 BpqBuff[w] := $f0; { No L3 present }

 { Info }
 For b := 1 to Length(Data)
  do Begin
     Inc(w);
     BpqBuff[w] := Ord(Data[b]);
     End;

 { Ja menemn... }
 { And off we go... }

 regs.ah := 10;
 regs.al := Port;
 regs.cx := w;
 regs.si := Ofs(BpqBuff);
 regs.es := Seg(BpqBuff);
 CallBPQ;

 End;

End;

Procedure Flex_SendUI(Packet:UIPacketP);    { FlexNet: Lhet UI frame }
Var
  s  : String;
  b  : Byte;
  ok : Boolean;
Begin

 With Packet^
  do Begin
     s := ToCall.Call + '-' + Int2Str(ToCall.SSID);
     If not (Digis = 0)
       then Begin
            s := s + ' v';
            For b := 1 to Digis
             do s := s + ' ' + DigiPath[b].Call + '-' + Int2Str(DigiPath[b].SSID);
            End;
     ok := l2_pSend_ui(FromCall.Call + '-' + Int2Str(FromCall.SSID),s,$f0,0,Data);
     End;

End;

Procedure SendUI(Packet:UIPacketP);    { Lhet UI frame }
Begin

  Case Conf^.Ifc.IfType of
    G8BPQ : BPQ_SendUI(Packet);
    Flex  : Flex_SendUI(Packet);
  End;

 Inc(FrSent);

End;

 { ***************************************************************** }

Procedure Login(sok:byte);
Begin

 If Assigned(Sock[sok]) then Exit; { Kaiken varalta... } { just to be sure }

 New(Sock[sok]);
 Inc(BPQSocks);
 With Sock[sok]^
  do Begin
     Mode := SM_Disc;
     SockMode := ascii;
     Paclen := GetPacLen(sok);
     MaxFrame := GetMaxFrame(sok);
     CharSet := 0;
     Usr_Inactive := 0;
     Link_Inactive := 0;
     Tx := 0;
     Rx := 0;
     InBuf := '';
     OutBufPos := 0;
     OutBPQBuf := nil;
     Traced := False;
     Tracefile := '';
     End;

End;

Procedure Logout(p:byte);
Begin

 If Assigned(Sock[p]) then Dispose(Sock[p]); { Just to be sure... }
 Sock[p] := nil;
 Dec(BPQSocks);
 If Conf^.Ifc.IfType = Flex
   then Stream[p] := 0;

End;

 { ***************************************************************** }
 { Connect stream to node using node callsign }

Procedure BPQ_Connect(p:Byte);
Begin

 regs.cx := 0;
 regs.dl := $01;
 regs.ah := $06;
 regs.al := Stream[p];
 CallBPQ;

End;

 { ***************************************************************** }

Function Flex_Connect(Const Source,Dest:String):Word;
Begin

 Flex_Connect := l2_pConnect(Source,Dest);

End;

 { ***************************************************************** }
 { Disconnect stream }

Procedure Disconnect(p:Byte);
Begin

If (p > 0)
  then Begin
       If (p <= SockMax)
        then Case Conf^.Ifc.IfType of

                 G8BPQ : Begin
                         regs.cx := 2; { Disconnect stream }
                         regs.ah := $06;
                         regs.al := Stream[p];
                         CallBPQ;
                         End;

                 Flex  : l2_cancel_qso(Stream[p]);

             End
       End
  else Begin
       TextAttr := Pal^[cmRxCon];
       Display(' *** Console logout'+Cr);
       SetCursorSize(Off);
       Cluster.Logout(0);
       BPQ.Logout(0);
       ConsoleMode := 0;
       End;
End;

 { ***************************************************************** }

Procedure ThrowOut(p:Byte);
Begin

 If p > 0
   then Begin

        If not (LUser[p]^.M2 = 255)
          then Action(p,'Leaving...');

        Sock[p]^.Mode := SM_ThrowOut;

        Case Conf^.Ifc.IfType of
          G8BPQ : Sock[p]^.Usr_Inactive := 0;
          Flex  : l2_stop_qso(Stream[p]);
        End;

        End
   else Disconnect(p);

End;

 { ***************************************************************** }
 { Open stream (Validate) }

Procedure OpenStream(p:Byte);
Begin
  regs.cl := 0;         { Application flags  }
  regs.dl := ApplMask;  { Application number }
  regs.ah := $01;
  regs.al := Stream[p];
  CallBPQ;
End;

 { ***************************************************************** }
 { Close stream (Devalidate) }

Procedure CloseStream(p:Byte);
Begin
  regs.dl := $0;        { Set application flags to 0 }
  regs.cl := $0;        { Disable band tracing }
  regs.ah := $01;
  regs.al := Stream[p];
  CallBPQ;
End;

 { ***************************************************************** }

Procedure SecTimer;                       { Kerran sekunnissa }
Var w : Word;
Begin

  { ThrowOut }
  If (Conf^.Ifc.IfType = G8BPQ)
    then Begin
         w := IfBuffers;
         { Onko muistia jljell } { Any bpq buffers free }
         If w < Conf^.Ifc.Buf_Treshold
           then CriticalError('BPQ running out of buffer space!',21);
         If w < BPQ.MinBuf then BPQ.MinBuf := w;
           If w > BPQ.MaxBuf then BPQ.MaxBuf := w;

         For w := 1 to UsrPorts
           do If Sock[w]^.Mode = SM_ThrowOut
                then Begin
                     Inc(Sock[w]^.Usr_InActive);
                     If Sock[w]^.Usr_InActive = 1 then Disconnect(w);
                     End;
         End;

 KickAss; { Kickit kyttjille. } { Flush user sockets. }

End;

 { ***************************************************************** }

Procedure MinTimer;                       { Kerran minuutissa }
Var
  b : Byte;
Const
  Null : Char = Chr(0);
Begin

 For b := 0 to Conf^.Ifc.NO_Ports do
  If Assigned(Sock[b]) then With Sock[b]^ do
  Begin

  Inc(Link_Inactive);
  Inc(Usr_Inactive);

  If assigned(LUser[b])
    then With LUser[b]^ do
         Begin

         If (Conf^.Ifc.Usr_TimeOut > 0)
           then Begin

                If Sock[b]^.Usr_InActive = (Conf^.Ifc.Usr_TimeOut-1)
                  then Begin
                       Idle := False;
                       Send(b,'>>> Inactivity timeout in 1 minute!' + Cr);
                       end;

                If Sock[b]^.Usr_InActive = Conf^.Ifc.Usr_Timeout
                  then Begin
                       Action(b,'Inactivity timeout');
                       Log(L_LUser,f^.Call+'/'+Int2Str(b)+' Inactivity timeout');
                       Disconnect(b);
                       End;
                End;

         Case M2 of

           1 : Begin
               Inc(MTimer);
               If MTimer = 15
                 then Begin
                      Send(b,'You''re talking to ' + Str + '. Type /ex or <CTRL-Z> to end.' + Cr);
                      MTimer := 0;
                      End;
               End;
         End;

         If (Conf^.Ifc.Link_Reset > 0)
           and (f_Timer in f^.Flags)
           and (Link_Inactive = Conf^.Ifc.Link_reset)
           and not (b = 0)
           then Begin
                Idle := False;
                Link_Inactive := 0;
                Case Conf^.Ifc.IfType of
                  G8BPQ : Begin
                          Regs.cx := 1;
                          Regs.si := Ofs(Null);
                          Regs.es := Seg(Null);
                          Regs.ah := $02;
                          Regs.al := Stream[b];
                          CallBPQ;
                          End;
                End;
                Inc(FrSent);
                End;
         End;
  End;

End;

 { ***************************************************************** }

Procedure CloseBPQ;                    { Sulkee BPQ:n }
Var b, bb : Byte;

  Function DumbPoll(p:Byte):Byte;
  Var n:Byte;
  Begin
    n := 0;
    regs.ah := $04;
    regs.al := Stream[p];
    CallBPQ;
    If regs.dx = 1
      then Begin
           regs.ah := $05;
           regs.al := Stream[p];
           CallBPQ;
           n := 1;
           End;
    DumbPoll := n;
  End;

  Function DumbGet_resp(p:Byte):Boolean;
  Begin
    DumbGet_resp := False;
    regs.di := Ofs(BPQbuff);
    regs.es := Seg(BPQbuff);
    regs.ah := $03;
    regs.al := Stream[p];
    CallBPQ;
    If regs.cx > 0
      then DumbGet_resp := True;
  End;

Begin

 { Disc & Suljetaan streamit } { disconnect and close streams }
 For b := 1 to Conf^.Ifc.No_Ports do
     begin
     regs.ah := $04; { Stream status }
     regs.al := Stream[b];
     CallBPQ;
     If regs.cx = $01 { Connected? }
       then Begin
            regs.ah := $06; { Disconnect stream }
            regs.cx := $02;
            regs.al := Stream[b];
            CallBPQ;
            regs.ah := $05; { Ack status change }
            regs.al := Stream[b];
            CallBPQ;
            End;
     regs.ah := $01; { Close stream }
     regs.dl := $00;
     regs.cl := $00;
     regs.al := Stream[b];
     CallBPQ;
     End;

 { Tyhjennetn BPQ } { clean up BPQ buffers }
 Repeat
  Idle := True;
  For b := 1 to Conf^.Ifc.No_ports do
      Begin
      bb := DumbPoll(b);
      If bb > 0 then Idle := False;
      If DumbGet_resp(b) then Idle := False;
      End;
 until Idle = True;

End;

 { ***************************************************************** }

Procedure CloseFlex;
Var
  b : Byte;
Begin

 b := ax_exit;

End;

 { ***************************************************************** }

Procedure IfClose;
Begin

 If IfInited then

 Case Conf^.Ifc.IfType of
  G8BPQ : CloseBPQ;
  Flex  : CloseFlex;
 End;

 IfInited := False;

End;

 { ***************************************************************** }

Procedure InitBPQ;
Var
  i : Byte;
Begin

 { Socketeille streamit }

 For i := 0 to SockMax
   do Begin
      Stream[i] := 0;
      SockNum[i] := 0;
      End;

 For i := 1 to Conf^.Ifc.No_Ports
   do Begin
      Stream[i] := Conf^.Ifc.Start_Port + i;
      SockNum[Stream[i]] := i;
      End;

 { Application number => bit-significant application mask }
 ApplMask := Raise(2,(Conf^.Ifc.ApplNum-1));

 { Close first ... just to be sure (if we crashed and left it open) }
 CloseBPQ;

 { Streams open }
 For i := 1 to UsrPorts do OpenStream(i);

 If IfMonitor
   then Begin { Enable monitoring }
        regs.cl := $80;
        regs.dl := ApplMask;
        regs.ah := $01;
        regs.al := Stream[1];
        CallBPQ;
        End;

End;

 { ***************************************************************** }

Function IfInit:Byte;
Var Result : Byte;
    b      : Byte;
Begin

 Result := 0;

 Case Conf^.Ifc.IfType of
   G8BPQ : Begin
           If not BPQ_loaded
             then Result := 1
             else If (IfVMajor + (IfVMinor / 100)) < 4.05
                    then Result := 2
                    else Begin
                         InitBPQ;
                         Write(' v' + IfVersion + ' -');
                         End;

           End;

   Flex  : Begin
           Case ax_init of
             1 : Write(' mini');
             2 : Write(' digipeater');
           else Result := 3;
           End;
           If Result = 0
             then Begin
                  IfVersion := l2_pversion;
                  Write(' kernel v' + IfVersion + ' found -');
                  End;
           End;
 End;

 If Result = 0
   then IfInited := True;

 IfInit := Result;

End;

 { ***************************************************************** }

Function SockSessionType(b:Byte):String;
Var
  s  : String;
  pF : pFrame;
  w  : Word;
Begin

 If b = 0
  then SockSessionType := '- Console'
  else Case Conf^.Ifc.IfType of

         G8BPQ : Begin
                 Regs.ah := 8;
                 Regs.al := Stream[b];
                 CallBPQ;
                 s := '';
                 If Regs.ah and 32 = 32 then s := s + 'Host ';
                 If Regs.ah and 1  = 1  then s := s + 'L2 ';
                 If Regs.ah and 2  = 2  then s := s + 'L4 ';
                 If Regs.ah and 4  = 4  then s := s + 'Uplink ';
                 If Regs.ah and 8  = 8  then s := s + 'Downlink ';
                 SockSessionType := PadLeft(2,Int2Str(Regs.al)) + s;
                 End;

         Flex  : Begin
                 pF := l2_get_f(Stream[b]);
                 w := l2_state(Stream[b]);
                 Case (w and $f) of
                   0 : s := 'Peer not heard';
                   1 : s := 'Peer busy';
                   2 : s := 'Connecting';
                   3 : s := 'Resyncing';
                   4 : s := 'Disconnecting';
                   5 : s := 'Idle';
                   6 : s := 'REJ sent';
                   7 : s := 'Polling';
                 else s := '';
                 End;

                 SockSessionType := PadLeft(2,Int2Str(pF^.Kanal)) + s;
                 End;

       End;

End;

 { ***************************************************************** }

Procedure Socketlist_Cmd(p:Byte);       { Lista BPQ:lle kytss olevista
                                          streameista }
Var b : Byte;
Begin

 Case Conf^.Ifc.IfType of

   G8BPQ : Begin
           Action(p,'BPQ socket list');
           Send(p,'BPQ sockets used:       Inact.    Data    Connection' + Cr
                + ' Callsign  St Mode      Usr Lnk  TX   RX  NA Mf Pln P Type' + Cr);

           For b := 0 to SockMax do
            If Assigned(Sock[b])
              then With Sock[b]^
                    do Send(p,' ' + PadLeft(10,Get_Callsign(b))
                        + PadLeft(3,Int2Str(Stream[b]))
                        + ModeStr[Mode] + ' '
                        + SmStr[SockMode] + ' '
                        + PadLeft(4,Mins2StrS(Usr_InActive))
                        + PadLeft(4,Mins2StrS(Link_InActive))
                        + PadRight(4,Bytes2Str(Tx))
                        + PadRight(5,Bytes2Str(Rx)) + ' '
                        + PadLeft(3,Int2Str(User_Frames(b)))
                        + PadLeft(3,Int2Str(MaxFrame))
                        + PadLeft(4,Int2Str(Paclen))
                        + SockSessionType(b) + Cr);
           End;

   Flex  : Begin
           Action(p,'PC/FlexNet socket list');
           Send(p,'PC/FlexNet sockets:     Inact.    Data    Connection' + Cr
                + ' Callsign  St   Mode    Usr Lnk  TX   RX  NA Mf Pln P State' + Cr);

           For b := 0 to SockMax do
            If Assigned(Sock[b])
              then With Sock[b]^
                     do Send(p,' ' + PadLeft(10,Get_Callsign(b))
                        + PadLeft(5,Int2Str(Stream[b]))
                        + ModeStr[Mode] + ' '
                        + PadLeft(4,Mins2StrS(Usr_InActive))
                        + PadLeft(4,Mins2StrS(Link_InActive))
                        + PadRight(4,Bytes2Str(Tx))
                        + PadRight(5,Bytes2Str(Rx)) + ' '
                        + PadLeft(3,Int2Str(User_Frames(b)))
                        + PadLeft(3,Int2Str(MaxFrame))
                        + PadLeft(4,Int2Str(Paclen))
                        + SockSessionType(b) + Cr);
           End;
 End;

End;

 { ***************************************************************** }
 { ***************************************************************** }
 {   Band monitoring code                                            }
 { ***************************************************************** }
 { ***************************************************************** }

 { Toggle band monitoring }

Procedure Toggle_Monitor;
Begin

 If MO_Band in Conf^.Ifc.MonitorMode
   then Exclude(Conf^.Ifc.MonitorMode,MO_Band)
   else Include(Conf^.Ifc.MonitorMode,MO_Band);

End;

 { ***************************************************************** }
 { BPQ monitorointi pois kokonaan }

Procedure Cut_Monitor;
Begin

 Case Conf^.Ifc.IfType of

   G8BPQ : Begin
           regs.ah := $01;
           regs.cl := $00;
           regs.dl := ApplMask;
           regs.al := Stream[1];
           CallBPQ;
           End;

   Flex  : l2_Clr_Monitor;

 End;

End;

 { ***************************************************************** }

Procedure Flex_SetMonitor;
Var
 tFilter : tTrace;
 MonOK   : Boolean;
Begin

 With tFilter
  do Begin
     ch_mask := 65535;
     typfilter := 0;
     trxfilter := 3;
     Call[0] := #0;
     End;

 MonOK := l2_set_monitor(@tFilter);

End;

 { ***************************************************************** }
 { Monitor channels }

Procedure Band_Monitor;
Var
  OutBuf        : Array[1..500] of Char;
  OutBufPos     : Word;
  St10          : String[10];
  IPos, J       : Integer;
  Info          : Boolean;    { Does the frame have an info field }
  Pass          : Boolean;
  f             : File of Byte;
  l             : Word;
  Frame         : pFrame;
  UIFrame       : Boolean;
  Packet        : UIPacketP;

Procedure Out(s:String);
Var
  b : Byte;
Begin

 For b := 1 to Length(s)
  do Begin
     Inc(OutBufPos);
     OutBuf[OutBufPos] := s[b];
     End;

End;

Procedure HitIt(c:Byte);
Var
  Outs : String;
  b    : Word;
Begin


 Outs := '';

 If MO_Band in Conf^.Ifc.MonitorMode then
 For b := 1 to OutBufPos
  do Begin
     Outs := Outs + OutBuf[b];
     If (Length(Outs) = 255) or (b = OutBufPos)
       then Begin
            TextAttr := c;
            Screen.Monitor(Outs);
            Outs := '';
            End;
     End;

 OutBufPos := 0;

End;

 { ****** Decode callsigns }


Procedure GetCall(S:Integer;var c:AX25Call);
Var
  I : Byte;
  St: String[10];
Begin

  I := 1;
  c.Call := '';
  While (I<7) and ((BPQbuff[I+S] Shr 1) <> $20) do
  Begin
    c.Call := c.Call + Chr(BPQbuff[I+S] Shr 1);
    Inc(I);
  End;

  c.SSID := ((BPQbuff[S+7] Shr 1) and $0F);

  If c.SSID <> 0
    then Begin
         Str(c.SSID,St);          { Strip SSID }
         St := c.Call + '-' + St;
         End
    else St := c.Call;

  Out(PadLeft(9,St));

End;

Procedure Callsign(S:Integer);
Var c : AX25Call;
Begin

  GetCall(s,c);

End;

 { ****** Decode Net/Rom information }

Procedure Netrom(NrPos:Integer);
Var Opcode : Byte;

  Procedure IndexOut(Pos:Byte);
  Begin
    Str((BPQbuff[NrPos + Pos]),St10);
    Out(' ' + St10);
    Str((BPQbuff[NrPos + Pos + 1]),St10);
    Out('/' + St10);
  End;

Begin

  Out(' NR ');
  Callsign(NrPos);
  Out(' ');
  Callsign(NrPos + 7);
  OpCode := BPQbuff[NrPos + 20];

  Case (OpCode and $0F) of
  1 : Begin
      Out(' C' + Cr + ' From user ');
      Callsign(NrPos + 21);
      Out(' at node ');
      Callsign(NrPos + 28);
      Out(' Socket');
      IndexOut(16);
      Str((BPQbuff[NrPos + 21]),St10);
      Out(', suggested L4 window: ' + St10);
      End;
  2 : Begin
      Out(' CA');
      IndexOut(NrPos + 16);
      Out(Cr + ' Socket');
      IndexOut(18);
      Str((BPQbuff[NrPos + 21]),St10);
      Out(', accepted L4 window: ' + St10);
      End;
  3 : Begin
      Out(' D');
      IndexOut(16);
      End;
  4 : Begin
      Out(' DA');
      IndexOut(16);
      End;
  5 : Begin
      Out(' I');
      IndexOut(16);
      Str((BPQbuff[NrPos + 18]),St10);
      Out(' ' + St10);
      Str((BPQbuff[NrPos + 19]),St10);
      Out('-' + St10);
      If OpCode and $20 = $20
        then Out(' Fr');
      If OpCode and $40 = $40
        then Out(' Na');
      If OpCode and $80 = $80
        then Out(' Ch');
      Info := True;
      IPos := NrPos + 21;                    { Correct counter to show text }
      End;
  6 : Begin
      If OpCode and $40 = $40
        then Out(' NA')
        else Out(' IA');
      IndexOut(16);
      Str((BPQbuff[NrPos + 19]),St10);
      Out(' ' + St10);
      If OpCode and $80 = $80
        then Out(' Ch');
      End;
  else
     Begin
       Out(' (Type ' + St10 + ')');
     End
  End;

End;

 { ****** Decode Net/Rom node table }

Procedure Node_table;
Var
  w     : Word;
  Eol   : Boolean;
Begin

  Out(' NET/ROM Nodes Broadcast from (');
  TextAttr := Pal^[cmMonHeaders];

  Eol := True;
  w := 1;

{ Mist bc tulee }
  While (w < 7) and ((BPQbuff[w + IPos]) <> $20)
    do Begin
       Out(Chr(BPQbuff[w+IPos]));
       Inc(w);
       End;

  Out(')');

  HitIt(Pal^[cmMonHeaders]);

  Inc(IPos,6);
  w := 0;

  If (IPos < Regs.Cx) and (MO_Band in Conf^.Ifc.MonitorMode)
    then Begin
         TextAttr := Pal^[cmMonHeaders];
         Screen.Monitor('  Node      Alias    Via       Quality  Node      Alias    Via       Quality ');
         End;

  While IPos < Regs.Cx do
    Begin
    Eol := not Eol;
    Out('  ');
    Callsign(IPos);                                { Dest node }
    Inc(IPos,7);

    w := 1;
    St10 := ' (';
    While (w < 7) and (BPQbuff[w + IPos] <> $20) do
    Begin
      St10 := St10 + Chr(BPQbuff[w + IPos]);         { Dest alias }
      Inc(w);
    End;

    Out(PadLeft(10,St10 + ')'));
    Inc(IPos,6);

    Callsign(IPos);                                { Via callsign }
    Inc(IPos,8);

    Str(BPQbuff[IPos],St10);                       { Quality byte }
    Out(' ' + PadLeft(7,St10));
    If Eol then HitIt(Pal^[cmMonHeaders]);
  End;

  If not Eol then HitIt(Pal^[cmMonHeaders]);

  If (w = 0) and (MO_Band in Conf^.Ifc.MonitorMode)
    then Begin
         TextAttr := Pal^[cmMonHeaders];
         Screen.Monitor('    No routes here.');
         End;

end;

 { ****** Decode IP header }

Procedure WordOut(pos:Byte);
Begin
 Out(Int2Str((BPQBuff[pos] shl 8) or BPQBuff[pos+1])); { network to host byte order }
End;

Procedure IPOut(pos:Byte);
Begin
 Out(Int2Str(BPQBuff[pos]) + '.' + Int2Str(BPQBuff[pos+1]) + '.'
            + Int2Str(BPQBuff[pos+2]) + '.' + Int2Str(BPQBuff[pos+3]));
End;

Procedure IP_Header(pos:Integer);
Begin

 Out(' IP ');
 IPOut(pos+15);
 Out('  ');
 IPOut(pos+19);
 Out(' ttl ' + Int2Str(BPQBuff[pos+11]));
 If (BPQBuff[pos+9] and 64 = 64) then Out(' DF');
 If (BPQBuff[pos+9] and 32 = 32) then Out(' MF');
 Out(Cr);

 Case BPQBuff[pos+12] of
  1  : Begin
       Out('ICMP: ');
       Case BPQBuff[pos+23] of
         0 : Out('Echo reply');
         3 : Begin
             Out('Destination unreachable: ');
             Case BPQBuff[pos+24] of
               0 : Out('Net unreachable');
               1 : Out('Host unreachable');
               2 : Out('Protocol unreachable');
               3 : Out('Port unreachable');
               4 : Out('Fragmentation needed and DF set');
               5 : Out('Source route failed');
             End;
             End;
         4 : Out('Source quench');
         5 : Out('Redirect');
         8 : Out('Echo request');
        11 : Out('Time exceeded');
        12 : Out('Parameter problem');
       else Out('Unknown: ' + Int2Str(BPQBuff[23]));
       End;
       End;
  4  : Out('IPIP');
  6  : Begin
       Out('TCP: ');
       WordOut(pos+23);
       Out(' - ');
       WordOut(pos+25);
       If BPQBuff[pos + 36] and 1  = 1  then Out(' FIN');
       If BPQBuff[pos + 36] and 2  = 2  then Out(' SYN');
       If BPQBuff[pos + 36] and 4  = 4  then Out(' RST');
       If BPQBuff[pos + 36] and 8  = 8  then Out(' PSH');
       If BPQBuff[pos + 36] and 16 = 16 then Out(' ACK');
       If BPQBuff[pos + 36] and 32 = 32 then Out(' URG');
       IPos := pos + 43;               { Correct counter to show text }
       End;
  17 : Begin
       Out('UDP: ');
       WordOut(pos+23);
       Out(' - ');
       WordOut(pos+25);
       Out(' length ');
       WordOut(pos+27);
       End;
  73 : Out('RSPF');
  93 : Out('AXIP');
 else Out('unknown ' + HexB2Str(BPQBuff[pos+12]));
 End;

End;

 { ****** Decode ARP header }

Procedure ARP_Header(pos:Integer);
Begin

 Info := False;

 Case BPQBuff[pos+10] of
  1 : Out(' ARP request:');
  2 : Out(' ARP reply:');
  3 : Out(' RARP request:');
  4 : Out(' RARP reply:');
 End;

 Out(Cr + '  From: '); IPOut(pos+18); Out(' '); Callsign(pos+10);
 Out(Cr + '  To:   '); IPOut(pos+29); Out(' '); Callsign(pos+21);

End;

 { ****** Start of Header }

Function Raw_header:Boolean; { Decode a *RAW* ax.25 frame }
Begin

  Info := False;

  Packet^.Port := (BPQbuff[3] and $0F);
  Str(Packet^.Port,St10);      { Port number }
  Out(TimeStrL(now) + ' ' + St10 +':');

  GetCall(12,Packet^.FromCall);                { From callsign }

  Out(' ');

  GetCall(5,Packet^.ToCall);                 { To callsign }

  Packet^.Digis := 0;
  J := 19;
  While ((BPQbuff[J] and $01) <> 1) and (Packet^.Digis < MaxDigis)
    do Begin { Digipeaters }
       Out('v ');
       Inc(Packet^.Digis);
       GetCall(J,Packet^.DigiPath[Packet^.Digis]);
       If (BPQbuff[J+7] and $80) = $80 then Out('*'); {Digi bit}
       Inc(J,7);
       End;

  IPos := J + 3;

  Case (BPQbuff[J+1] and $01) of

    0 : Begin                             { An information frame }

         Out(' <I ');

         Str(((BPQBuff[J+1] shr 1) and $07),St10);
         Out(St10);

         Str((BPQBuff[J+1] shr 5),St10);

         Out(St10 + '>');

         Case BPQbuff[J+2] of            { Case on the L3 PID }
          $cf : Netrom(J+2);              { Net/Rom }
          $f0 : Info := True;             { No L3 protocol }
          $c3 : Begin
                Out(' TexNet');
                Info := True;
                End;
          $cc : Begin
                IP_Header(j);
                Info := True;
                End;
          $cd,
          $ce : ARP_Header(j);
          Else  Begin                     { Any other PID }
                  Out(' Unknown L3 ' + HexB2Str(BPQbuff[j+2]));
                  Info := True;
                End;
         End;                             { End of PID case }
        End;
    1 : Begin                              { Must be a U or S frame }
          If (BPQbuff[J+1] and $02)=0 then { Is this an supervisory frame }
          Begin
            St10 := '';
            Case (BPQbuff[J+1] and $0C) of
              $00 : St10 := 'RR';   { Acknowledge }
              $04 : St10 := 'RNR';  { Renumbering }
              $08 : St10 := 'REJ';  { Reject }
            End;

            Out(' <' + St10);
            Str((BPQbuff[J+1] Shr 5),St10);      { Strip out N(R) }
            Out(' ' + St10 + '>');
          End
          else
          Case (BPQbuff[J+1] and $EC) of      { U Frame }
          0  : Begin
                 Out(' <UI>');
                 UIFrame := True;
                 If ((BPQbuff[6] Shr 1) = Ord('N')) and
                    ((BPQbuff[7] Shr 1) = Ord('O')) and
                    (BPQbuff[22] = $FF ) then Node_table  { Gee, a NODES broadcast! }
                 else Begin
                      Info := True; { Aha, we have some data as well }
                      Case BPQbuff[J+2] of            { Case on the L3 PID }
                        $cc : IP_Header(j);
                        $cd,
                        $ce : ARP_Header(j);
                      End;
                      { Dump this UI frame to a file, for hand decoding 8-) }
                      {
                      Assign(f,'uidump.dat');
                      Rewrite(f);
                      l := 5;
                      While l <= Regs.Cx
                       do Begin
                          Inc(l);
                          Write(f,BPQBuff[l]);
                          End;
                      Close(f);
                      }
                      End;
               End;
          $0C : Out(' <DM>');
          $2C : Out(' <SABM>');
          $40 : Out(' <DISC>');
          $60 : Out(' <UA>');
          $84 : Out(' <FRMR>');
          End;
        End;
  End;      { End of Info/Super case }

  HitIt(Pal^[cmMonHeaders]);

  If Info then Raw_header := True
          else Raw_header := False;

End;

Function Flex_header:Boolean; { Decode a half-decoded frame (i hate to do this!)... }
Var b : Byte;

  Procedure Flx2AxCall(const flxCall:tFlxCall; var AxCall:Ax25Call);
  Var
    b : Byte;
  Begin

   b := 0;
   While (b < 6) and (flxCall[b] <> ' ')
    do Begin
       AxCall.Call[b+1] := flxCall[b];
       Inc(b);
       End;
   AxCall.Call[0] := Chr(b);
   AxCall.SSID := Str2Byte(flxCall[6]);

  End;

Begin

  Info := False;
  Move(Frame^.Text^,BPQbuff,256);
  regs.cx := Frame^.TextLen and $ff;
  IPos := 1;
  j := 1;

  Str(Frame^.Kanal,st10);
  Out(TimeStrL(now) + ' ' + st10 + ':' + PadLeft(9,MkCallStr(Frame^.Source))
                 + ' ' + PadLeft(9,MkCallStr(Frame^.Dest)));

  Flx2AxCall(Frame^.Source,Packet^.FromCall);
  Flx2AxCall(Frame^.Dest,Packet^.ToCall);

  Packet^.Digis := Frame^.Digis;
  If (Frame^.digis > 0) and (Frame^.Digis <= Max_anz_digis)
   then Begin
        Out('v');
        For b := 1 to Frame^.digis
          do Begin
             Move(Frame^.Digi[b], Packet^.DigiPath[b], SizeOf(Packet^.DigiPath[b]));
             Out(' ' + MkCallStr(Frame^.Digi[b]));
{             If Frame^.NextDigi = b - 1
               then Out('*');
}             End;
        End;

  Case Frame^.Typ of

    1 : Begin { Information }

         Out(' <I ' + Int2Str(Frame^.ns) + Int2Str(Frame^.nr) + '>');

         Case Frame^.pid of            { Case on the L3 PID }
          $cf : Netrom(1);                { Net/Rom }
          $f0 : Info := True;             { No L3 protocol }
          $c3 : Begin
                Out(' TexNet');
                Info := True;
                End;
          $cc : Begin
                IP_Header(-2);
                Info := True;
                End;
          $cd,
          $ce : ARP_Header(-2);
          Else  Begin                     { Any other PID }
                  Out(' Unknown L3 ' + HexB2Str(Frame^.pid));
                  Info := True;
                End;
          End;                             { End of PID case }

        End;

    2 : Begin { RR }
        Str(Frame^.nr,St10);
        Out(' <RR ' + St10 + '>');
        End;

    3 : Begin { RNR }
        Str(Frame^.nr,St10);
        Out(' <RNR' + St10 + '>');
        End;

    4 : Begin { REJ }
        Str(Frame^.nr,St10);
        Out(' <REJ' + St10 + '>');
        End;

    5 : Out(' <SABM>');
    6 : Out(' <DISC>');
    7 : Out(' <DM>');
    8 : Out(' <UA>');
    9 : Out(' <FRMR>');

    10 : Begin
         Out(' <UI>');
         UIFrame := True;

         If (Frame^.pid = $cf) and (Frame^.Dest = 'NODES 0')
           then Node_table { Gee, a NODES broadcast! }
           else Begin
                Info := True; { Oho, tavaraakin lytyy! }
                Case Frame^.pid of { Case on the L3 PID }
                  $cc : IP_Header(-2);
                  $cd,
                  $ce : ARP_Header(-2);
                End;
                End

         End;

  End;  { End of type case }

  HitIt(Pal^[cmMonHeaders]);

  If Info then Flex_header := True
          else Flex_header := False;

  l2_ack_monitor;

End;

 { ****** End of Header }

Begin

  UIFrame := False;
  Case Conf^.Ifc.IfType of

    G8BPQ : Begin
            regs.di := Ofs(BPQbuff);
            regs.es := Seg(BPQbuff);
            regs.ah := 11;                  { Monitor function }
            regs.al := Conf^.Ifc.Start_port+1;
            CallBPQ;
            End;

    Flex  : Begin
            If not l2_chk_monitor
             then Flex_SetMonitor;

            Frame := l2_get_monitor;
            If Assigned(Frame)
              then regs.cx := 1
              else regs.cx := 0;

            End;

  End;

  If regs.cx > 0 then             { Is there any data }
    Begin

      Idle := False;
      OutBufPos := 0;
      Inc(FrMon);
      New(Packet);

      If ((Conf^.Ifc.IfType = G8BPQ) and Raw_header) or ((Conf^.Ifc.IfType = Flex) and Flex_header)
        then Begin { If valid info in frame }

             Packet^.Data := '';
             While (IPos <= regs.cx) and (OutBufPos < 500)
               do Begin
                  Inc(OutBufPos);
                  OutBuf[OutBufPos] := CleanCh[Chr(BPQbuff[IPos])];
                  Packet^.Data := Packet^.Data + OutBuf[OutBufPos];
                  Inc(IPos);
                  End;

             If (OutBufPos > 0) and (OutBuf[OutBufPos] = Cr)
               then Dec(OutBufPos);

             HitIt(Pal^[cmMonText]);

             If UIFrame
               then If (Packet^.ToCall.Call = AXCluCall.Call) and (Packet^.ToCall.SSID = AXCluCall.SSID)
                      then UI_Receive(Packet)
                      else If (Packet^.ToCall.Call = 'DX') and (Packet^.ToCall.SSID = 0)
                             then UI_ReceiveBC(Packet);

             End;

      Dispose(Packet);
    End;
End;

 { ***************************************************************** }

Begin

 IfInited := False;
 IfMonitor := True;

 For IfVMajor := 0 to SockMax do Sock[IfVMajor] := nil;

 IfVMajor := 0;
 IfVMinor := 0;
 IfVersion := '';

 BPQSocks := 0;

 LUserCount := 0;
 LoginCount := 0;

 FrSent := 0;
 FrRec := 0;
 FrMon := 0;

 MinBuf := 255;
 MaxBuf := 0;

End.

