
   /* Backup
   Used to back up message directory on other directory or drive
   Deletes what's not on the source drive and copies what's not
   on the backup drive.  N3EPY 1 May 1990
   dir_list was taken from CBBS mbrestm.c
   */

#include "sys\types.h"
#include "sys\stat.h"
#include "fcntl.h"
#include "dos.h"
#include "ctype.h"
#include "time.h"

#define BUFSIZE 4096
#define PATHSIZE 60
#define true 1
#define false 0

char buff[BUFSIZE];
char spp[44], tpp[44], sname[800][13], tname[800][13];
char srcpath[PATHSIZE], tgtpath[PATHSIZE];
char *tempfile[2];
char pathfile[PATHSIZE];
int scount, tcount;
int cmp();
int xx;
int prtok;

main(argc,argv)

int argc;
char *argv[];

{
  struct tm *timeptr;
  time_t elapsed_seconds;

  printf("\n    ************  CBBS FILE BACKUP  ************\n");
  printf("      for CBBS by Richard Johnson, N3EPY/AAR3PY\n");
  printf("                    Version 1.5\n\n");
  strcpy(srcpath,argv[1]);
  strcpy(tgtpath,argv[2]);

  if(argc < 3)
  {
  printf("    Command format should be: MBBACKUP c:\\mb\\msgs\\ d:\\mb\\msgs\\ 1\n");
  printf("    or: MBBACKUP [source path]\\ [target path]\\ [verbose switch]\n");
  printf("    The verbose switch is optional. 1 will display all file actions.\n");
  printf("    This will slow the process if there is a lot to do.  If you want\n");
  printf("    to see just the essentials, omit the third argument or make it a 0.\n");
  exit(0);
  }
  prtok = 0;

  if(argc == 4)
  prtok = atoi(argv[3]);

  dir_list();
  printf("Performing Deletion Operation\n");
  tardel();
  printf("Performing Copying Operation\n");
  srccpy();
  time(&elapsed_seconds);
  timeptr = localtime(&elapsed_seconds);
  printf("*** DONE at %2d:%2d:%2d on %2d/%2d/%2d ***\n", timeptr->tm_hour,
       timeptr->tm_min, timeptr->tm_sec, timeptr->tm_mon + 1, timeptr->tm_mday,
       timeptr->tm_year);
}
/*
 *  Read the file names from the current directory and store
 *  the results in an array but exclude any name that is not
 *  made up of all numbers.
 *  Sort the resulting list in ascending order.
 */

dir_list()
{
  int x, y;
  int c;
  char *sfile_name[1];
  char *tfile_name[1];
  char *directory = "*.";
  char spath[60];
  char tpath[60];
  xx = 1;
  scount = 0;

  strcpy(spath,srcpath);
  strcpy(tpath,tgtpath);
  strcat(spath,directory);
  strcat(tpath,directory);
  sfile_name[0] = spath;
  tfile_name[0] = tpath;

  printf("Reading source directory.....\n");
  bdos(0x1a, (unsigned)spp, 0);
  if(18==bdos(0x4e, (unsigned)sfile_name[0], 0))
    {
      printf("No message files are found\n");
      exit(0);
    }

  if (num( &spp[30])) strcpy(sname[scount++], &spp[30]);

  for(;;)
  {
    if(18==bdos(0x4f, 0, 0)) break;
    if (num( &spp[30])) strcpy (sname[scount++], &spp[30]);
  }
  printf("There are %d message files\n", scount);
  if (scount)
    {
      printf("***Sorting***\n");
      qsort (sname, scount, 13, cmp);
      for(x=0, y=1; x< scount; x++, y++)
      {
	if(prtok)
	{
	printf("%6s", sname[x]);
	if(y == 10) { printf("\n"); y=0; }
	}
      }
      if(prtok)
      printf("\n");
    }
  printf("Reading target directory.....\n");
  tcount = 0;
  bdos(0x1a, (unsigned)tpp, 0);
  if(18==bdos(0x4e, (unsigned)tfile_name[0], 0))
    {
      printf("No message files are found\n");
      return;
    }

  if (num( &tpp[30])) strcpy (tname[tcount++], &tpp[30]);

  for(;;)
  {
    if(18==bdos(0x4f, 0, 0)) break;
    if (num( &tpp[30])) strcpy (tname[tcount++], &tpp[30]);
  }
  printf("There are %d message files\n", tcount);
  if (tcount)
    {
      printf("***Sorting***\n");
      qsort (tname, tcount, 13, cmp);
      for(x=0, y=1; x< tcount; x++, y++)
      {
	if(prtok)
	{
	printf("%6s", tname[x]);
	if(y == 10) { printf("\n"); y=0; }
	}
      }
      if(prtok)
      printf("\n");
    }
}

/*
 *  Compare two strings converted to integers.
 */

int cmp(n1,n2)
char *n1;
char *n2;
{
   return (atoi(n1) - atoi(n2));

}

/*
 *  is the string a number?
 */

num(p)
char *p;
{
  for (; *p; p++) if (!isdigit(*p)) return false;
  return true;
}


/*
 *  Search the target directory for the filemanes in the
 *  source directory.  If no match, copy that file to the
 *  target directory
 */

srccpy()
{
	int h = 0;
	int i = 0;
	int cpyok;
	int lim = 0;

	for(h=0; h<scount; h++)
	{
	cpyok = 1;
	for(i=lim; i<tcount; i++)
	{
		if(cpyok)
		{
		if(prtok)
		printf("Comparing target %s and source %s for copy-ability!\n",tname[i],sname[h]);

		if(atoi(tname[i]) == atoi(sname[h]))
			{
			cpyok = 0;
			lim = i+1;
			}
		}
	}
	if(cpyok)
		{
		tempfile[1] = sname[h];
		cpyfile();
		}
	}
}

/*   Check the source directory for files on the target
 *   directory.  If no match, delete that file from the
 *   directory.
 */


tardel()
{
	int h = 0;
	int i = 0;
	int delok;
	int lim = 0;

	for(h=0; h<tcount; h++)
	{
	delok = 1;
	for(i=lim; i<scount; i++)
	{
		if(delok)
		{
		if(prtok)
		printf("Comparing target %s and source %s for deletion validation\n",tname[h],sname[i]);

		if(atoi(tname[h]) == atoi(sname[i]))
			{
			delok = 0;
			lim = i+1;
			}
		}
	}
	if(delok)
		{
		tempfile[2] = tname[h];
		delfile();
		}
	}
}



cpyfile()
{
	int infile, outfile, bytes;
	char spathfile[PATHSIZE];
	char tpathfile[PATHSIZE];


	strcpy(spathfile,srcpath);
	strcpy(tpathfile,tgtpath);

	strcat(spathfile,tempfile[1]);
	strcat(tpathfile,tempfile[1]);

	if((infile = open(spathfile, O_RDONLY | O_BINARY)) < 0)
		{
		printf("Can't open %s.\n",spathfile);
		exit(1);
		}

	if((outfile = open(tpathfile,
		O_CREAT | O_WRONLY | O_BINARY, S_IWRITE)) < 0)
		{
		printf("Can't open %s.",tpathfile);
		exit(1);
		}
	if(prtok)
	printf("Copying %s.....\n",tpathfile);
	while((bytes = read(infile, buff, BUFSIZE)) > 0)
		write(outfile,buff,bytes);

	close(infile);
	close(outfile);

}


delfile()
{
	strcpy(pathfile,tgtpath);
	strcat(pathfile,tempfile[2]);
	if(prtok)
	printf("Deleting %s.....\n",pathfile);
	unlink(pathfile);

}

