Program CWKEY;
{ Monitoring program for CW TSR by S57RA }

uses
  Dos,
  TPString,
  TPCrt,
  TPCmd,
  TPWindow,
  TPMenu,
  TPEdit;

Type Str80 = String[80];
     ID_Array = Array [0..9] of byte;


Const SoftInt : Byte = $60;
      ID      : ID_Array = ($50,$53,$51,$52,$56,$57,$1E,$06,$55,$89);


Var F_Array :Array[1..10] of str80;
    w1,w2   :Word;
    reg     :Registers;
    txt:string[80];
    Stext:String[80];

    SIP : ^ID_Array;

Const IntNo : Byte = $60;

procedure InitMenu(var M : Menu);
const
  Color1 : MenuColorArray = ($1E, $1B, $1E, $7E, $1E, $0E, $19, $78);
  Color2 : MenuColorArray = ($1E, $1E, $1F, $7F, $1F, $0E, $19, $78);
  Color3 : MenuColorArray = ($9E, $9F, $9E, $7E, $9E, $0E, $19, $78);
  Frame1 : FrameArray = 'Ȼͺ';

begin
  {Customize this call for special exit characters and custom item displays}
  M := NewMenu([], nil);

  SubMenu(1,2,1,Horizontal,Frame1,Color1,'<< S57RA TSR CW key >>');
    MenuWidth(80);
    MenuItem('Run',2,1,1,'Running MEMKEYER');
    SubMenu(3,4,1,Vertical,Frame1,Color2,'');
      MenuHeight(18);
      MenuItem('PTT On/Off',1,1,2,'SWITCH PTT ON/OFF');
      MenuItem('QRQ',2,1,3,'Increase speed');
      MenuItem('QRS',3,1,4,'Decrease speed ');
      MenuItem('Pass TEXT',4,1,5,'Enter text to transmit');
      MenuItem('SELECT KBD',5,1,6,'Transmit characters from keyboard, <ESC> to stop');
      MenuItem('F1 text',6,1,8,'Send F1 preset text');
      MenuItem('F2 text',7,1,9,'Send F2 preset text');
      MenuItem('F3 text',8,1,10,'Send F3 preset text');
      MenuItem('F4 text',9,1,11,'Send F4 preset text');
      MenuItem('F5 text',10,1,12,'Send f5 preset text');
      MenuItem('F6 text',11,1,13,'send f6 preset text');
      MenuItem('F7 text',12,1,14,'Send F7 preset text');
      MenuItem('F8 text',13,1,15,'Send F8 preset text');
      MenuItem('F9 text',14,1,16,'Send F9 preset text');
      MenuItem('F10 text',15,1,17,'Send F10 preset text');
      PopSublevel;
    MenuItem('Options',23,1,18,'Set parameters');
    SubMenu(18,4,1,Vertical,Frame1,Color2,'');
      MenuItem('Define F1..F10',1,1,19,'Enter text ');
      SubMenu(29,6,1,Vertical,Frame1,Color2,'');
        MenuWidth(22);
        MenuItem('F1',1,1,20,'Enter F1 text');
        MenuItem('F2        ',2,1,21,'Set F2 text');
        MenuItem('F3',3,1,22,'');
        MenuItem('F4',4,1,23,'');
        MenuItem('F5',5,1,24,'');
        MenuItem('F6',6,1,25,'');
        MenuItem('F7',7,1,26,'');
        MenuItem('F8',8,1,27,'');
        MenuItem('F9',9,1,28,'');
        MenuItem('F10',10,1,29,'');
        PopSublevel;
      MenuItem('PTT Delay',2,1,32,'Set PTT delay in mS');
      MenuItem('DOT/DASH ratio',3,1,33,'Set Dot/Dash ratio');
      MenuItem('DOT/PAUSE ratio',4,1,34,'Set Dot to pause ratio (0.5 - 2)');
      MenuItem('DOT/Character PAUSE',5,1,35,'Set DOT to Character pause ratio');
      MenuItem('VOXDELAY',6,1,36,'Set VOX delay');
      MenuItem('SQUEEZE ',7,1,37,'Enable / disable iambic keying');
      MenuItem('PRESET SPEED',8,1,38,'Preset speed aprox. char/min (15-250)');
      MenuItem('PADDLE INTERFACE',9,1,39,'Padle iface enable/disable');
      MenuItem('TSR Check',10,1,40,'Check if TSR is loaded');
      MenuItem('ACTIVATE COMPORT',11,1,41,'Activate COM port interrupt triger');
      MenuItem('DEACTIVATE COMPORT',12,1,42,'Deactivate TSR COMPORT trigger');
      MenuItem('TONE',13,1,43,'Set tone frequency in Hz');
      MenuItem('SPEAKER MONITOR',14,1,46,'Monitor enable/disable');
      PopSublevel;
    MenuItem('About',50,1,44,'SETING UTILITY FOR VHFCW PROGRAM by Pavle, S57RA@S50BOX.SVN.EU');
    MenuItem('Exit',71,1,45,'Exit MEMKEYER');
    PopSublevel;

  ResetMenu(M);
end;


{--------------------------}
{-------------------------------------------------}
Function Installed: Boolean;
var i: integer;
    p: Pointer;
begin
  i:=0;
  GetIntVec(SoftInt, P);
  SIP:=P;
  While (i<10) and (SIP^[i]=ID[i]) do inc(i); { compare }
  Installed:=(i>=10);
end;
{-------------------------------------------------}

{--------------------------}

FUNCTION  YesNo(Prompt: String;Defv:Char):Boolean;
const ActiveFrame : FrameArray = 'Ȼͺ';
      Explode     : Boolean    = True;

var ch, Ch1:char;
    dx,dy,l:integer;
    covers : pointer;
    Win    : WindowPtr;
    MOld,MaOld: Integer;
    K         : Word;
    Escaped:Boolean;
    YN:Boolean;

begin
      Mold:=WindMin;
      MaOld:=WindMax;
      CH1:=#255;
      HiddenCursor;
      Shadow:=True;
      FrameChars:=ActiveFrame;



      if not MakeWindow(Win, 3, 16, 3+3+4+Length(Prompt),18,
      true,true,false,$1E, $1B, $1E, '') then
         begin
           Writeln('Cannot display message');
           readln;
           Windmin:=MOld;
           WindMax:=MaOld;
           exit;
         end;
      if not DisplayWindow(Win) then
      begin
           Writeln('Cannot display message        :');
           readln;
           DisposeWindow(EraseTopWindow);
           Windmin:=MOld;
           WindMax:=MaOld;
           exit;
         end;
      SetTopWindow(Win);
      gotoxy(2,1);

      YesNo:=YesOrNo(Prompt,1,2,$1e,DefV);

      DisposeWindow(EraseTopWindow);

      Windmin:=MOld;
      WindMax:=MaOld;
      NormalCursor;
end;  { writemsg }

{--------------------------}

FUNCTION  ReadInt(Prompt: String;NLo,NHi,Defv:integer):Integer;
const ActiveFrame : FrameArray = 'Ȼͺ';
      Explode     : Boolean    = True;

var ch, Ch1:char;
    dx,dy,l:integer;
    covers : pointer;
    Win    : WindowPtr;
    MOld,MaOld: Integer;
    K         : Word;
    Escaped:Boolean;
    Ig:Integer;

begin
      Mold:=WindMin;
      MaOld:=WindMax;
      CH1:=#255;
      HiddenCursor;
      Shadow:=True;
      FrameChars:=ActiveFrame;



      if not MakeWindow(Win, 3, 16, 3+3+4+Length(Prompt),18,
      true,true,false,$1E, $1B, $1E, '') then
         begin
           Writeln('Cannot display message');
           readln;
           Windmin:=MOld;
           WindMax:=MaOld;
           exit;
         end;
      if not DisplayWindow(Win) then
      begin
           Writeln('Cannot display message        :');
           readln;
           DisposeWindow(EraseTopWindow);
           Windmin:=MOld;
           WindMax:=MaOld;
           exit;
         end;
      SetTopWindow(Win);
      gotoxy(2,1);
      Ig:=Defv;

      ReadInteger(Prompt,1,2,4,
                      $1e, $1b,NLo, NHi, Escaped,Ig);
  {-Prompt for and receive a string}
      if Escaped then ReadInt:=0 else ReadInt:=Ig;

      DisposeWindow(EraseTopWindow);

      Windmin:=MOld;
      WindMax:=MaOld;
      NormalCursor;
end;  { writemsg }

{--------------------------}
FUNCTION  ReadText(Prompt: String;le:byte):String;
const ActiveFrame : FrameArray = 'Ȼͺ';
      Explode     : Boolean    = True;

var ch, Ch1:char;
    dx,dy,l:integer;
    covers : pointer;
    Win    : WindowPtr;
    MOld,MaOld: Integer;
    K         : Word;
    Escaped:Boolean;
    St:String;

begin
      Mold:=WindMin;
      MaOld:=WindMax;
      CH1:=#255;
      HiddenCursor;
      Shadow:=True;
      FrameChars:=ActiveFrame;



      if not MakeWindow(Win, 3, 16, 3+le+4+Length(Prompt),18,
      true,true,false,$1E, $1B, $1E, '') then
         begin
           Writeln('Cannot display message');
           readln;
           Windmin:=MOld;
           WindMax:=MaOld;
           exit;
         end;
      if not DisplayWindow(Win) then
      begin
           Writeln('Cannot display message        :');
           readln;
           DisposeWindow(EraseTopWindow);
           Windmin:=MOld;
           WindMax:=MaOld;
           exit;
         end;
      SetTopWindow(Win);
      gotoxy(2,1);
      St:='';
      ReadString(Prompt,1,2,Le,
                     $1E, $1B, $1E,Escaped, St);
  {-Prompt for and receive a string}
      if Escaped then ReadText:='' else ReadText:=ST;

      DisposeWindow(EraseTopWindow);

      Windmin:=MOld;
      WindMax:=MaOld;
      NormalCursor;
end;  { writemsg }

{--------------------------}
Procedure CI(F,P:Word);
begin
  With reg do
  begin
    AH:=$30;
    AL:=F;
    BX:=P;
    Intr(SoftInt,reg);
  end;
end;
{--------------------------}
Procedure CIT(F,P:Word;var ST:String);
begin
  With reg do
  begin
    AH:=$30;
    AL:=F;
    bx:=Seg(St); cx:=Ofs(St);
    Intr($60,reg);
  end;
end;
{--------------------------}

var
  M : Menu;
  Ch : Char;
  Key : MenuKey;
  Co: Integer;

begin
  If (ParamStr(1)<>'') then
  begin
    Val(ParamStr(1), SoftInt, Co);
    if (Co<>0) or (Softint>255) or (SoftInt<$60) then
    begin
     Writeln ('Invalid parameter for soft. interrupt, valid $60 - $255');
     Exit;
    end;
  end;
  if not Installed then
  begin
    Writeln('This program can only be used when VHFCW tsr is loaded.');
    Writeln;
    Writeln('If VHFCW is loaded, and soft. interrupt<>$60 then use');
    Writeln('CWMONI $XX  - XX is interrupt number');
    Exit;
  end;

  TPEdit.WindowRelative:= True;
  FillChar(F_Array, SizeOf(F_Array),0);
  CLRSCR;
  InitMenu(M);
 Repeat
  Key := MenuChoice(M, Ch);
  Case Key Of
    2:begin  { PTT }
       CI(2,0);
      end;
    3:begin
       CI(3,0);
      end;
    4:begin
       CI(4,0);
      end;
    5:begin
       Stext:=ReadText('CW Text:',40);
       CIT(5,0,Stext);
      end;
    6:begin
       repeat
         Ch:=ReadKey;
         SText:=Ch;
         CIT(5,0,Stext);
       until Ch=#27;
      end;
    7:begin
       Repeat
         Ch:=Chr(Random(27)+65);
         SText:=Ch;
         CIT(5,0,Stext);
       Until not Keypressed;
      end;
    8:begin
        CIT(5,0,F_Array[1]);
      end;
    9:begin
        CIT(5,0,F_Array[2]);
      end;
    10:begin
        CIT(5,0,F_Array[3]);
      end;
    11:begin
        CIT(5,0,F_Array[4]);
      end;
    12:begin
        CIT(5,0,F_Array[5]);
      end;
    13:begin
        CIT(5,0,F_Array[6]);
      end;
    14:begin
        CIT(5,0,F_Array[7]);
      end;
    15:begin
        CIT(5,0,F_Array[8]);
      end;
    16:begin
        CIT(5,0,F_Array[9]);
      end;
    17:begin
        CIT(5,0,F_Array[10]);
      end;
    20:begin
       F_Array[1]:=ReadText('F1:',60);
      end;
    21:begin
       F_Array[2]:=ReadText('F2:',60);
      end;
    22:begin
       F_Array[3]:=ReadText('F3:',60);
      end;
    23:begin
       F_Array[4]:=ReadText('F4:',60);
      end;
    24:begin
       F_Array[5]:=ReadText('F5:',60);
      end;
    25:begin
       F_Array[6]:=ReadText('F6:',60);
      end;
    26:begin
       F_Array[7]:=ReadText('F7:',60);
      end;
    27:begin
       F_Array[8]:=ReadText('F8:',60);
      end;
    28:begin
       F_Array[9]:=ReadText('F9:',60);
      end;
    29:begin
       F_Array[10]:=ReadText('F10:',60);
      end;
    31:begin

      end;
    32:begin
         CI(6,ReadInt('PTT DELAY mS [1..(80)..999]:',1,999,80));
      end;
    33:begin
         CI(7,ReadInt('RATIO DOT/DASH [10..(35)..50]:',10,50,35))
      end;
    34:begin
         CI(8,ReadInt('RATIO DOT/PAUSE [2..(10)..50]:',2,50,10))
      end;
    35:begin
         CI(9,ReadInt('RATIO DOT/CHAR.PAUSE [2..30..100]:',2,100,30))
      end;
    36:begin
         CI(10,ReadInt('VOX DELAY mS [50..(300)..2000]:',50,2000,300));
      end;
    37:begin
         if YesNo('IAMBIC KEYING ENABLE [(Y),N]','Y') then
         CI(11,1) else CI(11,0);
      end;
    38:begin
         CI(1,ReadInt('APROX. SPEED Ch/min [10..(80)..260]:',10,260,80))
      end;
    39:begin
        if YesNo('PADDLE INTERFACE CONNECTED [(Y),N]','Y') then
        CI(13,1) else CI(13,0);
      end;
    40:begin
        CI(14,0)
      end;
    41:begin
        CI(15,0)
      end;
    42:begin
        CI(16,0)
      end;
    43:begin
        CI(17,ReadInt('CW MONITOR TONE Fq Hz [50..(600)..2000]:',50,2000,500))
      end;
    46:begin
         if YesNo('PC SPEAKER MONITOR ENABLE [(Y),N]','Y') then
         CI(12,1) else CI(12,0);
      end;
  end;
 Until Key=45;            { case }
  EraseMenu(M, False);
end.
