;************************************************
; TMS320C26 DSK RS232 INTERFACE DRIVER - PROTOTYPE!
; Keith Larson
; DSP Applications
; Texas Instruments Inc
; (C)opyright 1992, 1993
; Modified: 11/12/93 - Johan B. Forrer
; 	Change conf 1 -> conf 2 so that all operations
; 	leaves 1024 words of code and 512 words of data
;************************************************/
YES     .set    1
NO      .set    0
;-----------------------------------------------------------;
TEMP            .set   0x60     ;
WORD16          .set   0x61     ;
PADDR           .set   0x62     ;
WORD            .set   0x63     ;
TEMPx           .set   0x64     ;
_IMR            .set   0x65     ;
BITLEN          .set   0x66     ;RS232 bitwidth in C26 clock ticks
BITLEN2         .set   0x67     ;RS232 bitwidth in C26 clock ticks
USR_PRD         .set   0x68
USR_AR0         .set   0x69
USR_AR1         .set   0x6A
USR_AR2         .set   0x6B
USR_AR3         .set   0x6C
STAT0           .set   0x6D
STAT1           .set   0x6E
;----------------------------------------------------------------
        .include  "mmregs.asm"
        .ps     0xFA00          ;
        B       KLKRNL          ;FA00  RS
        B       KLKRNL          ;FA02  INT0
        B       KLKRNL          ;FA04  INT1
        B       KLKRNL          ;FA06  INT2
       ;B       QFIX            ;FA08  TINT -> RECOVER ARP
        ret
        ret
        ret                     ;FA0A  RINT
        ret                     ;
        ret                     ;FA0C  XINT
        ret                     ;
        B       KLKRNL          ;FA0E  TRAP
        ;--------------------------------------------------------------
        b       CMD             ;FA10  JUMP table to KLKRNL routines
        b       XMIT            ;FA12
        b       XMIT16          ;FA14
        b       RECV            ;FA16
        b       RECV16          ;FA18
        b       CXMIT           ;FA1A
        ;--------------------------------------------------------------
QFIX    sst     STAT0           ; save STATUS & DP
        sst1    STAT1           ; save ARP
        ldpk    0               ;
        lst1    STAT1           ; restore ARP
        ldp     STAT0           ; restore DP
        ret                     ;
        ;--------------------------------------------------------------
KLKRNL: dint                    ;
        sxf                     ;initialize line
        ldpk    0               ;
        conf    2               ;
        zac                     ;
        sacl    IMR             ;
        lac     BITLEN,1        ; 2 x
        add     BITLEN          ; 3 x
        addk    4
        sfr                     ; 1.5 x
        sfr                     ; 1/2
        sacl    BITLEN          ;Store Baud Timer
        sacl    PRD             ;
        sfr                     ;
        sacl    BITLEN2         ;Store Baud Timer/2
        ;-----------------------
CMD     call    RECV,*,AR0      ;get 8 bit CMD from host
        bz      CMD             ;
        subk    1               ;
        bz      W_PS            ;1 = write program space
        subk    1               ;
        bz      R_PS            ;2 = read program space
        subk    1               ;
        bz      W_DS            ;3 = write data space
        subk    1               ;
        bz      R_DS            ;4 = read data space
        subk    1               ;
        bnz     USRCMD          ;5 = Execute program at next word
        call    RECV16          ;
;       lac     WORD16          ;
        bacc                    ;
USRCMD  subk    1               ;
        bz      BR_PS           ;6 = block read program space
        subk    1               ;
        bz      BR_DS           ;7 = block read data space
        subk    1               ;
        bnz     CMD             ;8 = return to TOS, usually user code
        ret
;============================================================
; W_PS & R_PS are used to access program memory
;============================================================
W_PS    call    KRNL            ;
W_PS2   call    RECV16          ;copy length words to PS
        sacl    WORD            ;
        lac     PADDR           ;ACCU=src address
        tblw    WORD            ;
        addk    1               ;
        sacl    PADDR           ;
        larp    AR3             ;
        banz    W_PS2,*-,AR2    ;
        b       CMD             ;
        ;------------------------
BR_PS   ; NOT IMPLIMENTED!!!
        ;------------------------
R_PS    call    KRNL            ;
R_PS2   lac     PADDR           ;
        tblr    TEMP            ;
        addk    1               ;
        sacl    PADDR           ;
        lac     TEMP            ;
        call    XMIT16          ;
        larp    AR3             ;
        banz    R_PS2,*-,AR2    ;next word
        b       CMD             ;
;============================================================
; W_DS & R_DS are used to access data memory
;============================================================
W_DS    call    KRNL            ;
W_DS2   call    RECV16          ;build data word
        larp    AR2             ;
        sacl    *+,0,AR3        ;write the word   <<< missing shift!!!
        banz    W_DS2,*-,AR2    ;
        b       CMD             ;
        ;------------------------
R_DS    call    KRNL            ;
R_DS2   larp    AR2             ;get word
        lac     *+,0            ;
        call    XMIT16,*        ;
        larp    AR3             ;
        banz    R_DS2,*-        ;next word
        b       CMD             ;
        ;------------------------
BR_DS   call    KRNL            ;
BR_DS2  larp    AR2             ;get word
        lac     *+,0            ;
        call    CXMIT,*         ;transmit chars W/O handshake
        call    CXMIT,*         ;
        larp    AR3             ;
        banz    BR_DS2,*-       ;next word
        b       CMD             ;
;============================================================
; KRNL is common to all block transfers
;============================================================
KRNL    call    RECV16          ;1 st word is address
        lar     AR2,WORD16      ;
        sar     AR2,PADDR       ;
        call    RECV16          ;2 nd word is length-1
        lar     AR3,WORD16      ;
        larp    AR2             ;
        ret                     ;
;============================================================
; RECV returns word in bottom 8 bits of ACCL
;============================================================
RECV16:
        call    RECV            ;recv LO
        sacl    WORD16          ;
        call    RECV            ;recv HI
        rptk    7               ;
        sfl                     ;build HI+LO
        or      WORD16          ;
        sacl    WORD16          ;
        ret                     ;
        ;------------------------
RECV    call    SAVE
        call    TINT_ON
        lark    AR1,8           ; take 9 samples (START >> shifted out!)
        lac     BITLEN2         ; Load bitlen/2
        sacl    PRD             ;
WSBIT   bioz    SBIT,*,AR0      ; wait for start bit
        b       WSBIT           ;
SBIT    sach    TIM             ; Set   TINT (ACCU_hi = 0)
        idle                    ; Clear TINT and load BITLEN/2 into TIM
        lac     BITLEN          ; Load bitlen first idle will be bitlen/2
        sacl    PRD             ;
        zac                     ; Bits are add/shifted -> accu (must start 0)
        ;------------------------
NBIT    idle                    ; wait bitlen  (1st time is bitlen/2)
SKIP    sfr                     ; shift to new posn
        bioz    RB0,*,AR1       ; test bit
RB1     addk    0x80            ; if 1, add new bit
RB0     banz    NBIT,*-,AR0     ; last bit?
        andk    0xff            ;
        bioz    $               ; wait for STOP before RET
      ;  idle
        call    RESTORE         ;
        b       TINT_OFF        ; branch -> ret (save a word!)
;       call    TINT_OFF        ;
;       ret                     ; ACCU = RECEIVED CHAR
;============================================================
; XMIT assumes word is in bottom 8 bits of ACCL
;============================================================
XMIT16: call    XMIT            ;xmit LO
;       call    XMIT            ;xmit HI  Fall thru saves 3 words!
;       ret                     ;
;------------------------------------------------------------
XMIT    call    SAVE            ;
        ldpk    TEMPx           ;
        sacl    TEMPx           ;
        call    RECV            ; Handshake with slow host
        lac     TEMPx           ;
CXMIT   call    SAVE            ;
        call    TINT_ON         ;
        sfl                     ; first bit is 0 (Start bit)
        lark    AR1,8           ; 1 start, 8 DATA
        idle                    ; synch 1 st bit
        idle                    ;
SENDBIT ror                     ; TEMP = ........X XXXXXXXX0
        bnc     XB0             ;
        sxf                     ;
        b       XB1             ;
XB0     rxf                     ;
XB1     idle                    ; wait for bit
        mar     *,AR1           ; TINT sets ARP=0
        banz    SENDBIT,*-,AR0  ; send another bit?
        sxf                     ;
        idle                    ; Stop bit
        idle                    ; Stop bit
        call    RESTORE         ;
;       call    TINT_OFF        ;
;       ret                     ;
;--------------------------------
TINT_OFF ldpk    IMR            ;
         lar     AR0,_IMR       ;Restore old IMR
         sar     AR0,IMR        ;
         ret                    ;
;--------------------------------
TINT_ON ldpk    IMR             ;
        lar     AR0,BITLEN      ; Load bitlen
        sar     AR0,PRD         ;
        lar     AR0,IMR         ;Keep old IMR
        sar     AR0,_IMR        ;
        lark    AR0,0x8         ;Enable only TINT
        sar     AR0,IMR         ;
        ret                     ;
;--------------------------------
SAVE:   ldpk    USR_AR0         ; NOTE: Accumulator is used to pass
        sar     AR0,USR_AR0     ;       values and is not saved!
        sar     AR1,USR_AR1     ;
        sar     AR2,USR_AR2     ;
        sar     AR3,USR_AR3     ;
        lar     AR0,PRD         ;
        sar     AR0,USR_PRD     ;
        ret                     ;
;--------------------------------
RESTORE ldpk    USR_AR0         ; NOTE: Accumulator is used to pass
        lar     AR0,USR_PRD     ;       values and is not saved!
        sar     AR0,PRD         ;
        lar     AR0,USR_AR0     ;
        lar     AR1,USR_AR1     ;
        lar     AR2,USR_AR2     ;
        lar     AR3,USR_AR3     ;
        ret                     ;
