/************************************************
 TMS320C26 DSK RS232 DRIVER AND ASSORTED FUNCTIONS
 Keith Larson
 DSP Applications
 Texas Instruments Inc
 (C)opyright 1992, 1993
 ************************************************/
typedef unsigned char uchar;
typedef unsigned long ulong;
typedef unsigned int  uint;

void initcom(int,int);
void DTR_lo(int);
void DTR_hi(int);
unsigned int read4(char *);

void cxmit(char,int);
void ixmit(int,int);

unsigned int  ircv(int);
unsigned int  Bircv(int);
unsigned char crcv(int);
unsigned char Bcrcv(int);

void write_data(int, int, int *);
void read_data (int, int, int *);
void Bread_data (int, int, int *);
void rcv_buf(int port_no,int *ptr);
void rcv_char_buf(int length,char *ptr);

void reset(int);
void usage(void);

void cmdline(void);
unsigned int load_file(int, char *);
unsigned int load_DSK(int, char *);
void execute(int);

#define SYNCH   0        // DSK_COMM Synch value (wait for CMD)
#define UL_PROG 1        // Upload prog
#define DL_PROG 2        // Download prog
#define UL_DATA 3        // Upload data
#define DL_DATA 4        // Download data
#define BRANCH  5        // BRANCH (execute at) next 16 bit value

#define BDL_PROG 6        // Fast block Download prog >>> NO HANDSHAKE! <<<
#define BDL_DATA 7        // Fast block Download data >>> NO HANDSHAKE! <<<
