#include <stdio.h>
#include "nrutil.h"
#include "com_hack.h"
#include "nr_hack.h"

#define TRUE 1
#define FALSE 0

#define MAX_LINE  100  /* Maximum characters on one line of input file */

#define DRIVEN_ONLY 1
#define PARASITES_ONLY 2
#define ALL 3               /* randomisation method in 'optimise' */

/* better criteria, see optimise and better.c */

#define GAIN                  1
#define FB                    2
#define RESISTANCE            4
#define REACTANCE             8
#define VSWR                 16
#define REASONABLE           32

#ifndef Z0
#define Z0                             50
#endif


#define MAX_DRIVEN                 6 /* There are 6 bits info on a driven ele */
#define MAX_PARASITIC              4 /* But only 4 on a parasitic */

#define  X 			                 1/* index into driven and parasitic arrays */
#define  Y 			                 2
#define  LENGTH	                 3
#define	DIAMETER	                 4
#define	VOLTAGE	                 5/* Volt and phase not on parasistic ele */
#define	PHASE		                 6
#define 	REAL			              0
#define 	IMAGINARY	              1
#define  HEADER_SIZE             100/* size of header in .out files in bytes */   

typedef struct element_data {double x,y,length;} fred;

typedef struct performance_data {double r,x,gain,fb,swr,tau_sq;} f4;

typedef struct flags {int bflg, cflg, dflg, eflg, errflg,fflg;
		int gflg, hflg, lflg, oflg, pflg, rflg;
		int sflg, tflg, wflg, xflg, Fflg, Gflg, Rflg;
		int Cflg, Sflg, Tflg, Wflg, Xflg, Zoflg;} f2;

typedef struct pattern {
			double three_dB_E, three_dB_H;
			double first_null_E, first_null_level_E;
			double first_null_H, first_null_level_H;
			double first_sidelobe_E, first_sidelobe_level_E;
			double first_sidelobe_H, first_sidelobe_level_H;
								}f3;
int main(int argc, char **argv);
void copy_matrix(int length, int width, double **to, double **from);
char *get_data_filenames(int argc, char **argv, char *input);
char *string(long lower, long upper);
void free_string(char *string, long lower, long upper);
int get_number_of_elements(char *datafile, int *driven, int *parasitic);
void read_yagi_data(char *line, char *file, double *frequency, double *min_frequency, double*max_frequency, double *step_frequency, int dr, double **dr_data, int parasitic, double **para_data, double *angular_step);
void   self_impedance(int i, double frequency, int driven, int parasitic, double **data, double **impedance);
void   mutual_impedance(int i, int j, double frequency, int driven, int parasitic, double **d, double **p, double **impedance);
void   fill_z_matrix(double frequency, int driven, int parasitic, double **d, double **p, double **impedance);
void z21(double lamda, double d, double mean_length, double *r21, double *x21);
double ci(double); 
void fill_v_vector(int driven, int parasitic, double **d, double *v_vector);
void write_header_to_disk(FILE *ofp, int elements, int driven,
int parasitic, double min_frequency, double max_frequency, double frequency,
double step_frequency, double angular_step);
void write_vector(double *v, int elements, FILE *ofp);
int  read_header(FILE *ifp, FILE *ofp, double *min_f, double *max_f, double *step_f, double *f, double *angular_step);
void z_input(struct FCOMPLEX v, struct FCOMPLEX i, struct FCOMPLEX *z);
void reflection_coefficient(struct FCOMPLEX z_input, double *mag, double *phase);
double calculate_vswr(double magnitude);
double calculate_power_input(double real_z, struct FCOMPLEX current);
void   write_coordinates_of_elements_to_disk(FILE *ofp, int driven,
int parasitic, double **driven_data, double **parasitic_data);
void gain(double theta, double phi, double  pin, double normallised_f, struct
element_data *cordinates,struct FCOMPLEX *current, int elements, double *E, double *H, double actual_frequency, double design_frequency);
struct FCOMPLEX E_to_complex_power(struct FCOMPLEX x);
struct FCOMPLEX **FCOMPLEXmatrix(long a, long b, long c, long d);
void free_FCOMPLEXmatrix(struct FCOMPLEX **m, long nrl, long nrh, long ncl, long nch);
void free_FCOMPLEXvector(struct FCOMPLEX *v, long nrl, long nrh);
void free_element_data_vector( struct element_data *v, long nl, long nh);


struct FCOMPLEX *FCOMPLEXvector(long a, long b);
struct element_data *element_data_vector(long low, long high);
void print_z_matrix(double f, int elements, double **z_matrix);
void write_gain_at_various_angles(FILE *gain_fp, double angular_step, double pin, double normalised_f, double f, struct element_data *coordinates, struct FCOMPLEX *current, int elements, double design_f);

void write_input_data_to_disk(FILE *fp, char *notes, double frequency, double min_f, double max_f, double step_f, int elements ,int driven,int parasitic, double angular_step,double **d, double **p, double scale_factor); 
void randomise(int randomisation_method, double frequency, double percent, double **driven_data, double **parasitic_data, int driven, int parasitic);

/* int is_it_better(int criteria,struct performance_data new,struct performance_data best);  */
int is_it_better(int criteria, struct performance_data n, struct performance_data b);
double version(void);

void write_data_for_gnuplot(FILE *fp1,FILE  *fp2,FILE *fp3,FILE *fp4,FILE *fp5,FILE *fp6, double f,double normalised_f,double input_impedance_r, double input_impedance_i, double vswr, double gain_E_plane,double  fb_ratio);
void usage_first(char *str);
void usage_input(char *str);
void usage_yagi(char *str);
void usage_output(char *str);
void usage_optimise(char *str);
void write_file_for_gnuplot_to_load(FILE *fp, char *filename);

double performance(struct flags flag, struct performance_data data, double max_gain, double max_fb,double weight_gain, double weight_fb, double weight_vswr, double weight_combined);
int getoptions(int argc, char **argv, char *opts);

void copy_complex_data_to_real_matrix(int elements, double **from, double **to);
void show_all_first_parameters(char *exefile);
void show_all_optimise_parameters(char *exefile);
double randreal(void);
int    randint(void);
void solve_equations(double frequency, int driven, int parasitic, double **driven_data, double **parasitic_data, double *v, double **z, double *pin, struct FCOMPLEX *voltage, struct FCOMPLEX *current, struct FCOMPLEX *input_impedance, struct element_data *coordinates, double **A, double *b, int *indx);
void genetic_algorithm(char *output_filename, char *update_filename, struct flags flag, double frequency, double minf, double maxf, double stepf, double angular_step, int driven ,int  parasitic, double **driven_data, double **parasitic_data, double *v, double **zz, double
*pin, struct FCOMPLEX *voltage, struct FCOMPLEX *current, struct FCOMPLEX
*input_impedance, struct element_data *coordinates, double **A, double *b, int
*indx);

double get_genetic_algorithm_fitness(struct flags flag, double frequency, int driven, int parasitic, double **driven_data, double **parasitic_data, double *v, double **z, double *pin, struct FCOMPLEX *voltage, struct FCOMPLEX *current, struct FCOMPLEX *input_impedance, struct element_data *coordinates, double **A, double  *b, int *indx, struct performance_data *data2);

void check_flags(struct flags flag, int argc, int optind, char *exefilename);
void error_message(char *str);
double determine_maximum_gain(double f, double  l);
double determine_maximum_gain2(int elements);


void do_since_better(int i, char *output_filename, char *update_filename, struct FCOMPLEX input_impedance, struct performance_data n,struct flags flag,char * notes,double frequency, double min_frequency,double max_frequency,double  step_frequency,int elements, int driven,int parasitic,double angular_step,double **driven_data,double **parasitic_data,double scale_factor,double new_performance);
double gaussian();
void sensitivity(double boom_sd, double length_sd, double **driven_data, double**parasitic_data, int driven, int parasites);
double log2(double x);
void mprove(double **a ,double **LU_of_a,int n, int *indx, double *b, double *x);
void seedRNG(void);
double error_3dB_E(double x); 
double error_3dB_H(double x); 
double zbrent(double (*func)(), double x1, double x2, double tol);  
double Objective(char *gene);
int GA_Free(void);
int GA_Error(char *error_mesg);
void SetPrint(int a);
int Initialise(int popsise, int genesize);
int Selection(FILE *fd, int gene);
double ss2r(char *string, int pos, int len);
