#include <stdio.h>
#include <errno.h>
#include "yagi.h"

/* This routine prints the data to disk and to stdout, since the new result
is better than all previous */

void do_since_better(int i, char *output_filename, char *update_filename, struct FCOMPLEX input_impedance, struct performance_data n,struct flags flag,char * notes,double frequency,double min_frequency,double max_frequency,double  step_frequency,int elements, int driven,int parasitic,double angular_step,double **driven_data,double **parasitic_data,double scale_factor,double new_perf)
{
			static int run_first_time=TRUE;

			FILE *fp_out, *update_fp;
			printf("%5d %.3lfdBi, %.2lfdB F/B, Z=(%.2lf %+.2lf j) Ohm vswr=%.3lf:1",i,n.gain, n.fb, input_impedance.r, input_impedance.i,n.swr);
			if(flag.Wflg || flag.gflg)
				printf(" fit=%.5lf",new_perf);
			printf("\n");
			update_fp=fopen(update_filename,"a");
			if(run_first_time==TRUE && flag.wflg)
				fprintf(update_fp, "Optimised for wide-band use\n");
			if(run_first_time==TRUE && flag.gflg)
				fprintf(update_fp, "Optimised With the genetic algoritm\n");
			run_first_time=FALSE;
			fprintf(update_fp,"%5d %.3lfdBi, %.2lfdB F/B, Z=(%.2lf %+.2lf j) Ohms vswr=%.3lf:1",i,n.gain, n.fb, input_impedance.r,input_impedance.i ,n.swr);
			if(flag.Wflg || flag.gflg)
				fprintf(update_fp," fit=%lf",new_perf);
			fprintf(update_fp,"\n");
			fclose(update_fp);
			/* write our best design to date to disk */
			
			fp_out=fopen(output_filename,"wt");
			write_input_data_to_disk(fp_out, notes, frequency/1e6,                          min_frequency/1e6,max_frequency/1e6, step_frequency/1e6, elements,              driven, parasitic, angular_step,driven_data, parasitic_data,                    scale_factor); 
			fclose(fp_out);

#ifdef DEBUG
	if(errno)
	{
		fprintf(stderr,"Errno =%d in dobetter.c\n", errno);
		exit(1);
	}
#endif
}
