#include <stdio.h>
#include <math.h>
#include <errno.h>
#ifdef sun
#include <stdlib.h>
#endif
#include "yagi.h"

extern double boom_factor;
extern int errno;
#define MIN_RDS   0.05 /* Minimum reflector-driven spacing in lambda */

void randomise(int randomisation_method, double frequency, double max_percent, double **driven_data, double**parasitic_data, int driven, int parasites)
{
	int i;
	static int run_first_time=TRUE;
	double y, old_boom_length, new_boom_length;
	static double max_boom_length;
	if(run_first_time==TRUE)
	{
		run_first_time=FALSE;
		max_boom_length=(1+boom_factor/100)*parasitic_data[parasites][X];
	}
	if ((randomisation_method & DRIVEN_ONLY) == DRIVEN_ONLY)
	{
		for(i=1;i<=driven; ++i) /* randomise the driven */
		{
			y=1+0.02*max_percent*(randreal()-0.5);
			driven_data[i][X]*=y;

			y=1+0.02*max_percent*(randreal()-0.5);
			driven_data[i][LENGTH]*=y;
		}
	}
	if ((randomisation_method & PARASITES_ONLY) == PARASITES_ONLY)
	{

	   /* reflector position stays at x=0 */
		y=1+0.02*max_percent*(randreal()-0.5);
		parasitic_data[1][LENGTH]*=y;
		
		old_boom_length=parasitic_data[parasites][X];    
		y=1+0.02*max_percent*(randreal()-0.5);
		new_boom_length=old_boom_length*y;
		
		if(new_boom_length > max_boom_length)
			new_boom_length=max_boom_length;
		/* rearrange directors */
		for(i=2; i<=parasites; ++i)
		{
			y=1+0.02*max_percent*(randreal()-0.5);
			parasitic_data[i][LENGTH]*=y;

			y=1+0.02*max_percent*(randreal()-0.5);
			parasitic_data[i][X]*=y*(new_boom_length/old_boom_length);
		}
	}

#ifdef DEBUG
	if(errno)
	{
	fprintf(stderr,"Errno =%d in randomis.c\n", errno);
	exit(1);
	}
#endif
}

