#include <stdio.h>
#include <math.h>
#ifdef i386
#ifndef DOS
#include <ieeefp.h>
#endif
#endif 
#include <errno.h>
#include "yagi.h"

/* The function performance gives a performance rating for the antenna
between 0 and 1, for use in a genetic algorithm to get performance. All
parameters are roughly linear */ 

extern int errno;

double performance(struct flags flag, struct performance_data data, double max_gain, double max_fb, double weight_gain, double weight_fb,
double weight_tau, double weight_combined)
{
	double answer, total_weight;
	double gain, fb;
	double gain_performance,fb_performance,tau_performance,combined_performance;
	double true_forward_gain;

	if(flag.cflg==0)  /* 3 sepparate weights used: gain, FB and swr */
	{
		weight_gain*=1.2;  /* These add to 3.0 */
		weight_fb*=0.6;
		weight_tau*=1.2;

		total_weight=weight_gain+weight_fb+weight_tau; /* should be 100 */
		if(data.fb > max_fb)
			 data.fb=max_fb;
		
		/* Gains and FB are in dB. Convert to linear scaling so they 
		are more representiitive of performance */

		gain=pow(10,data.gain/10.0);         
		max_gain=pow(10,max_gain/10.0);
		fb=pow(10,data.fb/10.0);            
		max_fb=pow(10,max_fb/10.0);   

		gain_performance=weight_gain*gain/max_gain;
		fb_performance=weight_fb*fb/max_fb;
		tau_performance=weight_tau*data.tau_sq;    
		answer=(gain_performance+fb_performance+tau_performance)/total_weight;
		/* printf("tp=%lf fbp = %lf taup=%lf total w =%lf ans = %lf\n", gain_performance, fb_performance, tau_performance, total_weight, answer); */
	}
	else if (flag.cflg) /* combined SWR/gain and FB sepparate */
	{
		weight_combined*=1.085; /* 66x1.085=71.61 */
		weight_fb*=.83;         /* 33.3333 * .83 = 27.7 */

		if(data.fb > max_fb)
			 data.fb=max_fb;


		gain=pow(10,data.gain/10.0);         
		max_gain=pow(10,max_gain/10.0);

		fb=pow(10,data.fb/10.0);            
		max_fb=pow(10,max_fb/10.0); 

		true_forward_gain=gain*data.tau_sq;

		combined_performance=weight_combined*true_forward_gain/max_gain;
		fb_performance=weight_fb*fb/max_fb;

		total_weight=weight_combined+weight_fb;

		answer=(combined_performance+fb_performance)/total_weight;
		/* printf("combined=%lf fbp = %lf total w =%lf ans = %lf\n", combined_performance, fb_performance, total_weight, answer); */
	}
	if(data.r < 1)
		answer=0.0;
#ifdef i386
#ifndef DOS
	if(isnanf(answer))
		answer=0.0;
#endif
#endif

#ifdef sun
	if(isnan(answer));
		answer=0.0;
#endif

#ifdef DEBUG
	if(errno)
	{
		fprintf(stderr,"Errno =%d in perform.c\n", errno);
		exit(1);
	}
#endif
	return(answer);
}




