#ct2az.awk (C) Joseph Mack NA3T 1996, GNU Public License
# Converts .grd files from the contesting program CT into
# AZ_PROJ grid.dat files. Allows drawing of grids worked in
# a contest.
#
# Since CT updates its files after each entry of a contact,
# it is possible to update the AZ_PROJ map (by redrawing it)
# at the same time.
#
# to get output on stdout (the screen) run this command line 
# (can use mawk instead of awk)
# awk -f ct2az.awk your_ct_grid_file.grd
#
# to produce a file
# mawk -f ct2az.awk your_ct_grid_file.grd > ct_grid.dat
#
BEGIN 	{
	OFS = ":"
	print "%Generated by ct2az.awk (C) Joseph Mack 1996 NA3T"
	}
# Is the first field a gridsquare?
$1 ~ /[A-z][A-z][0-9][0-9]/{
	# check each band and print an AZ_PROJ grid: line
	if ($3 > 0) {print "grid",50,"",$1,$3 " contacts"}
	if ($4 > 0) {print "grid",144,"",$1,$4 " contacts"}
	if ($5 > 0) {print "grid",222,"",$1,$5 " contacts"}
	if ($6 > 0) {print "grid",432,"",$1,$6 " contacts"}
	if ($7 > 0) {print "grid",903,"",$1,$7 " contacts"}
	if ($8 > 0) {print "grid",1296,"",$1,$8 " contacts"}
	if ($9 > 0) {print "grid",2.3,"",$1,$9 " contacts"}
	if ($10 > 0) {print "grid",3.4,"",$1,$10 " contacts"}
	if ($11 > 0) {print "grid",5.7,"",$1,$11 " contacts"}
	if ($12 > 0) {print "grid",10,"",$1,$12 " contacts"}
	if ($13 > 0) {print "grid",24,"",$1,$13 " contacts"}
	}
