'       nv.bas: viewer for NEC-2 input files

'             9 Nov 95: quick change to add origin movement

'       Written by David de Schweinitz <dave.des@metronet.com>
'       Distribute freely.
'
'       I wrote this to get a quick look at simple geometry files.  I tried
'       to clean it up some before I sent it out, but not much.  Please let
'       me know if it's any use.  Suggestions, enhancements, or pointers
'       to other (preferably free) related programs would be appreciated.
'
'       This program will run under QBasic with one minor change
'       (noted below), but it is much faster in QuickBasic.  If it's
'       too slow on a machine that does not have a math co-processor, try
'       compiling it with QuickBasic 3.0.  It should run much faster.
'       Be careful running any QuickBasic 3.0 executable with graphics
'       calls while running MS Windows, however.  I've had problems with
'       major system crashes running similar programs at full-screen DOS
'       prompt under Windows.  I've had no problems with QuickBasic 4.5
'       executables (like the one distributed with this listing).  They
'       usually will not run in a window, but do fine full-screen.
'
'       This program only reads GW cards.  It doesn't handle ground planes or
'       arcs or anything else.  It wouldn't take much to add these functions,
'       in anyone's interested.  If I do any more enhancement to the program,
'       it'll probably be to add some editing capability.
'
'       If you see a bunch of % signs in the number displays, that indicates
'       that the wire parameters are too big or too small for the fixed
'       decimal format I used.  You may need to edit these lines if you want
'       to read the numbers.
'
'       Two example files are included with this program.  CAR_C.NEC and
'       CAR_S.NEC are comma- and space-delimited files generated using
'       the Univ. of Stellenbosch WIREGRID program.
'
'       Good luck and have fun!
'                                       Dave
'
'  This is a special version of NVNEW (which is an enhanced version, by
' Stumpff, of NV) that displays NEC geometries in a more compass-oriented
' fashion.
'
'  GM, GA, GH, GR, and GX card processing added by Stumpff.
'
DECLARE FUNCTION DEC&(B AS STRING)     'For GX card processing.
DECLARE FUNCTION XP! (X!, Y!, Z!, PHI!, THETA!)
DECLARE FUNCTION YP! (X!, Y!, Z!, PHI!, THETA!)
'
'  Added by Stumpff to detect input file.
'
DECLARE FUNCTION EXIST%(FILE$)
'
'  Added by Stumpff to turn comma-delimited lines into space-delimited
' ones in "proper NEC format."
'
DECLARE FUNCTION FIXGW$(STRNG$)
DECLARE FUNCTION FIXGA$(STRNG$)
DECLARE FUNCTION FIXGH$(STRNG$)
DECLARE FUNCTION FIXGXR$(STRNG$)
DECLARE FUNCTION FIXGM$(STRNG$)
'
'  The following user defined type was added by Stumpff for printer and
' PCX/BMP routines.  (Note that the calls to INTERRUPTX added here will
' make this program unusable in QBasic.  This can be fixed using a "QBasic
' add-on" which allows QBasic to call interrupts.  Let me know if you need
' this--gstumpff@yahoo.com.)
'
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
COMMON SHARED /REGS/INREGS AS REGISTERS,OUTREGS AS REGISTERS
     DIM SHARED deg2rad AS DOUBLE       'Addition by Stumpff for accuracy.
     deg2rad = 4# * ATN(1#) / 180#
     NUUM% = 12000   '   Maximum number of wires
     DIM NSEG%(NUUM%), x1(NUUM%), y1(NUUM%), z1(NUUM%),  x2(NUUM%), y2(NUUM%), z2(NUUM%), rad(NUUM%)
     DIM NTAG%(NUUM%)
'
'  Addition by Stumpff for GM, GR, and GX card processing.
'
     DIM K AS INTEGER,NMIN AS INTEGER,I1 AS INTEGER,I2 AS LONG,ETAG AS INTEGER
     DIM STSEG AS INTEGER,ESEG AS INTEGER
     DIM DPI AS INTEGER,PTEST AS INTEGER   'Addition by Stumpff for printing.
     CONST ESC = 27, DOWN = 80, UP = 72, LEFT = 75, RIGHT = 77
     CONST HOME = 71, ENDKEY = 79, PGDN = 81, PGUP = 73
'
'  PFLAG, NXFLAG, and ENDFLAG variables added by Stumpff for processing
' NEC files with more than one structure represented.  BMPNUM added by
' Stumpff for multiple BMP file output.
'
     DIM PFLAG AS INTEGER,ENDFLAG AS INTEGER,NXFLAG AS INTEGER,BMPNUM AS INTEGER
'    CLS
     LINECOL% = 14: SLINECOL% = 12   '  Line colors (changable)
     XAXISCOL% = 5: YAXISCOL% = 2: ZAXISCOL% = 7: SHEETCOL% = 8: BMPNUM=0

     NECFILE$ = COMMAND$      'reads NEC input file name from command line.
     WHILE EXIST(NECFILE$)<>1 'Addition by Stumpff in case COMMAND$ is null.
     LINE INPUT "NEC input file name?";NECFILE$
     WEND
'
'  SCREEN 9 moved and replaced by Stumpff to make more versatile
' video mode decision.  (Video change occurrence here also allows its
' screen clear cabability to be used.)
'
'  CARDLINE is the old screen line 40, ANGLELINE is the old screen line
' 14, and BOTTOM is the old pixel vertical coordinate 290.
'
     DIM MODE AS INTEGER,BOTTOM AS INTEGER,CARDLINE AS INTEGER
     DIM ANGLELINE AS INTEGER
'
'  Try to set VGA mode first.  If that doesn't work, try EGA.
'
     ON ERROR GOTO TRYEGA
     MODE=12
     CARDLINE=57
     BOTTOM=440
     ANGLELINE=16
     SCREEN MODE
'
'  If routine gets to here, either mode 9 or mode 12 was found.
'
     GOTO GOTMODE
TRYEGA:
     IF MODE=9 THEN RESUME NOGRAPHICS
     MODE=9
     CARDLINE=40
     BOTTOM=290
     ANGLELINE=14
     RESUME
NOGRAPHICS:
ON ERROR GOTO 0
PRINT
PRINT "You need either EGA 640 x 350 or VGA 640 x 480 graphics to use this ";
PRINT "program."
GOTO DONE
GOTMODE:
ON ERROR GOTO 0
'
'  WIDTH statement moved to here because VGA won't let it be used before
' SCREEN statement.
'
IF MODE=9 THEN
WIDTH 80, 43
ELSE
'
'  Mode 12 palette saving routine added by Stumpff for use by MAKEPCX
' routine.  (Palette can't be read in subroutine because WIDTH statement
' somehow interferes with that.)
'
DIM SHARED PALDATA(15,1 TO 3) AS INTEGER
OUT &H3C7,0
FOR N%=0 TO 15
FOR M%=1 TO 3
PALDATA(N%,M%)=INP(&H3C9)
NEXT M%
NEXT N%
WIDTH 80, 60
END IF
'
'    This program first tries to read the file as space-delimited.  If it
'    is comma-delimited, the file is closed, re-opened and then re-read.
'    I'm sure that there must be a more elegant way to do this, but this
'    seems to work OK.
'    If you use one type exclusively you may want to edit the following
'    lines accordingly.
'
'  Note from Stumpff: comma-delimited files are now handled by simply
' changing all commas in a line to spaces.
'
     DISTSQD = 0      ' Initialize value used to scale screen.
     HEIGHT=0         'Additional initialization added by Stumpff.
     OPEN NECFILE$ FOR INPUT AS #1
     delimtype$ = ""
'
'  Counting of GW cards changed by Stumpff so that n% = 0 can be watched
' for.  (This variable is also used for the GA/GH card additions by
' Stumpff because GA/GH cards are simply turned into the equivalent of
' whatever GW cards would have been equivalently necessary to generate an
' arc or helix.)
'
'  Label added by Stumpff for processing of multi-structure NEC files.
'
PFLAG=1
NXFLAG=0
NEXTSTRUCT:
ENDFLAG=0
     n% = 0
'
'    Skip through the comment cards:
'
     DO
'
'  EOF testing added here and elsewhere by Stumpff for multi-structure NEC
' file processing.
'
       IF EOF(1) THEN EXIT DO
       LINE INPUT #1, j$
       IF LEFT$(j$, 2) = "CE" THEN EXIT DO
     LOOP
     DO
       IF EOF(1) THEN EXIT DO
       LINE INPUT #1, j$
'
'  Get rid of commas.
'
CALL COM2SPC(j$)
       IF LEFT$(j$, 2) = "GS" OR LEFT$(j$, 2) = "GE" THEN EXIT DO
'
'  Skip any non-GW, non-GA, non-GH, non-GX, non-GR, or non-GM cards.
' (PROC% variable introduced by Stumpff to keep line length below 81
' characters.)
'
PROC%=0 : IF LEFT$(j$, 2) = "GW" OR LEFT$(j$,2)="GM" THEN PROC%=1
IF LEFT$(j$,2)="GA" OR LEFT$(j$,2)="GH" OR LEFT$(j$,2)="GX" THEN PROC%=1
IF LEFT$(j$,2)="GR" THEN PROC%=1
'
'  Label added by Stumpff so GR card can be faked as GM card.
'
REPROC:
       IF PROC%=1 THEN
IF LEFT$(j$,2)="GW" THEN
'
'  In case comma-delimited GW line was changed to a space-delimited one,
' put line in standard, fixed column format.  (Similar functions are
' called for other cards.  This serves as a comment for those function
' calls too.)
'
j$=FIXGW$(j$)
'
'  This line moved to here by Stumpff.
'
         n% = n% + 1
         IF n% = 1 THEN   'Check first GW card for commas:
           FOR m% = 1 TO LEN(j$) - 1
             IF MID$(j$, m%, 1) = "," OR MID$(j$, m%, 1) = ";" THEN
               delimtype$ = "comma"
'
'  Another addition by Stumpff to allow fix of comma-delimiting routine.
'
DL$="," : IF MID$(j$,m%,1)=";" THEN DL$=";"
               EXIT FOR
             END IF
           NEXT m%
'           IF delimtype$ = "comma" THEN EXIT DO
         END IF
         NTAG%(n%) = VAL(MID$(j$, 3, 3))
         NSEG%(n%) = VAL(MID$(j$, 6, 5))
         x1(n%) = VAL(MID$(j$, 11, 10)): y1(n%) = VAL(MID$(j$, 21, 10)): z1(n%) = VAL(MID$(j$, 31, 10))
         x2(n%) = VAL(MID$(j$, 41, 10)): y2(n%) = VAL(MID$(j$, 51, 10)): z2(n%) = VAL(MID$(j$, 61, 10))
         rad(n%) = VAL(MID$(j$, 71, 10))
'
'   Don't reset height variable if NXFLAG = 1.  (Added by Stumpff.)
'
IF NXFLAG=0 THEN
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
'
'  Watch out for first node being at origin.  (Added by Stumpff.)
'
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
END IF
ELSEIF LEFT$(j$,2)="GA" THEN
'
'  Process GA card.  First, if it's first non-CE card, check for commas
' or semicolons.
'
j$=FIXGA$(j$)
IF n%=0 THEN
COMMAPOS%=INSTR(j$,",") : SEMIPOS%=INSTR(j$,";")
IF COMMAPOS%<>0 OR SEMIPOS%<>0 THEN
delimtype$="comma"
DL$="," : IF SEMIPOS%<>0 THEN DL$=";"
EXIT DO
END IF
END IF
NS%=VAL(MID$(j$,6,5))
RADA=VAL(MID$(j$,11,10))
ANG1=VAL(MID$(j$,21,10))*deg2rad
ANG2=VAL(MID$(j$,31,10))*deg2rad
DA=(ANG2-ANG1)/CSNG(NS%)
n%=n%+1
NTAG%(n%)=VAL(MID$(j$,3,3))
rad(n%)=VAL(MID$(j$,41,10))
NSEG%(n%)=1
x1(n%)=RADA*COS(ANG1)
y1(n%)=0
z1(n%)=RADA*SIN(ANG1)
x2(n%)=RADA*COS(ANG1+DA)
y2(n%)=0
z2(n%)=RADA*SIN(ANG1+DA)
IF NXFLAG=0 THEN
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
END IF
IF NS%>1 THEN
FOR M%=2 TO NS%
n%=n%+1
ANG=ANG1+DA*CSNG(M%)
NTAG%(n%)=VAL(MID$(j$,3,3))
rad(n%)=VAL(MID$(j$,41,10))
NSEG%(n%)=1
x1(n%)=x2(n%-1)
y1(n%)=0
z1(n%)=z2(n%-1)
x2(n%)=RADA*COS(ANG)
y2(n%)=0
z2(n%)=RADA*SIN(ANG)
IF NXFLAG=0 THEN
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
'
'  Watch out for first node being at origin.  (Added by Stumpff.)
'
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
END IF
NEXT M%
END IF
ELSEIF LEFT$(j$,2)="GH" THEN
'
'  Process GH card.  (The first part is very like the GA card tests.)
'
j$=FIXGH$(j$)
IF n%=0 THEN
COMMAPOS%=INSTR(j$,",") : SEMIPOS%=INSTR(j$,";")
IF COMMAPOS%<>0 OR SEMIPOS%<>0 THEN
delimtype$="comma"
DL$="," : IF SEMIPOS%<>0 THEN DL$=";"
EXIT DO
END IF
END IF
NS%=VAL(MID$(j$,6,5))
SEP=VAL(MID$(j$,11,10))
HL=VAL(MID$(j$,21,10))
A1=VAL(MID$(j$,31,10))
B1=VAL(MID$(j$,41,10))
A2=VAL(MID$(j$,51,10))
B2=VAL(MID$(j$,61,10))
'
'  Calculate rate at which x and y radii vary along axis.  Watch for
' spiral condition.  (The spiral condition is treated rather crudely and
' may not match exactly what NEC does, especially for elliptical spirals.)
'
IF ABS(HL)>1E-10 THEN
SPIRAL%=0
SLOPEX=(A2-A1)/ABS(HL)
SLOPEY=(B2-B1)/ABS(HL)
NTURNS=ABS(HL)/SEP
ELSE
SPIRAL%=1
RMAX=B2 : IF A2>RMAX THEN RMAX=A2
RMIN=A1 : IF B1<RMIN THEN RMIN=B1
NTURNS=(RMAX-RMIN)/SEP
SLOPEX=(A2-A1)/CSNG(NS%)
SLOPEY=(B2-B1)/CSNG(NS%)
END IF
DA=360*NTURNS*deg2rad/CSNG(NS%)
DZDA=HL/NTURNS/360/deg2rad
n%=n%+1
NTAG%(n%)=VAL(MID$(j$,3,3))
rad(n%)=VAL(MID$(j$,71,10))
NSEG%(n%)=1
x1(n%)=A1
y1(n%)=0
z1(n%)=0
z2(n%)=DZDA*DA
IF SPIRAL%=1 THEN RADX=A1+SLOPEX : RADY=B1+SLOPEY
IF SPIRAL%=0 THEN RADX=A1+ABS(z2(n%))*SLOPEX : RADY=B1+ABS(z2(n%))*SLOPEY
'
'  Apply equation of ellipse.
'
RHO=1/SQR((COS(DA)/RADX)^2+(SIN(DA)/RADY)^2)
x2(n%)=RHO*COS(DA)
y2(n%)=RHO*SIN(DA)
IF NXFLAG=0 THEN
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
END IF
IF NS%>1 THEN
FOR M%=2 TO NS%
n%=n%+1
ANG=DA*CSNG(M%)
NTAG%(n%)=VAL(MID$(j$,3,3))
rad(n%)=VAL(MID$(j$,71,10))
NSEG%(n%)=1
x1(n%)=x2(n%-1)
y1(n%)=y2(n%-1)
z1(n%)=z2(n%-1)
z2(n%)=DZDA*ANG
IF SPIRAL%=1 THEN RADX=A1+CSNG(M%)*SLOPEX : RADY=B1+CSNG(M%)*SLOPEY
IF SPIRAL%=0 THEN RADX=A1+ABS(z2(n%))*SLOPEX : RADY=B1+ABS(z2(n%))*SLOPEY
RHO=1/SQR((COS(ANG)/RADX)^2+(SIN(ANG)/RADY)^2)
x2(n%)=RHO*COS(ANG)
y2(n%)=RHO*SIN(ANG)
IF NXFLAG=0 THEN
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
'
'  Watch out for first node being at origin.  (Added by Stumpff.)
'
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
END IF
NEXT M%
END IF
ELSEIF LEFT$(j$,2)="GX" THEN
'
'  Process GX cards.
'
j$=FIXGXR$(j$)
IF n%=0 THEN
COMMAPOS%=INSTR(j$,",") : SEMIPOS%=INSTR(j$,";")
IF COMMAPOS%<>0 OR SEMIPOS%<>0 THEN
delimtype$="comma"
DL$="," : IF SEMIPOS%<>0 THEN DL$=";"
EXIT DO
END IF
ELSE
'
'  Get tag increment.
'
I1=VAL(MID$(j$,3,3))
'
'  Get reflection switch string and treat it as binary number.
'
I2STR$=RTRIM$(LTRIM$(MID$(j$,6,5)))
I2=DEC(I2STR$)
IF (I2 AND 1&)=1& THEN
'
'  Do reflection about xy-plane.
'
NNEW%=n%
FOR M%=1 TO n%
NNEW%=NNEW%+1
X1(NNEW%)=X1(M%) : Y1(NNEW%)=Y1(M%) : Z1(NNEW%)=-Z1(M%)
X2(NNEW%)=X2(M%) : Y2(NNEW%)=Y2(M%) : Z2(NNEW%)=-Z2(M%)
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(NNEW%)>0 THEN NTAG%(NNEW%)=NTAG%(NNEW%)+I1
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%) : RAD(NNEW%)=RAD(M%)
NEXT M%
'
'  Update n% AND I1 for next reflection (and subsequent card processing).
'
n%=NNEW% : I1=2*I1
END IF
IF (I2 AND 2&)=2& THEN
'
'  Do reflection about xz-plane.
'
NNEW%=n%
FOR M%=1 TO n%
NNEW%=NNEW%+1
X1(NNEW%)=X1(M%) : Y1(NNEW%)=-Y1(M%) : Z1(NNEW%)=Z1(M%)
X2(NNEW%)=X2(M%) : Y2(NNEW%)=-Y2(M%) : Z2(NNEW%)=Z2(M%)
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(NNEW%)>0 THEN NTAG%(NNEW%)=NTAG%(NNEW%)+I1
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%) : RAD(NNEW%)=RAD(M%)
NEXT M%
'
'  Update n% AND I1 for next reflection (and subsequent card processing).
'
n%=NNEW% : I1=2*I1
END IF
IF (I2 AND 4&)=4& THEN
'
'  Do reflection about yz-plane.
'
NNEW%=n%
FOR M%=1 TO n%
NNEW%=NNEW%+1
X1(NNEW%)=-X1(M%) : Y1(NNEW%)=Y1(M%) : Z1(NNEW%)=Z1(M%)
X2(NNEW%)=-X2(M%) : Y2(NNEW%)=Y2(M%) : Z2(NNEW%)=Z2(M%)
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(NNEW%)>0 THEN NTAG%(NNEW%)=NTAG%(NNEW%)+I1
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%) : RAD(NNEW%)=RAD(M%)
NEXT M%
'
'  Update n% for subsequent card processing.
'
n%=NNEW%
END IF
END IF
ELSEIF LEFT$(j$,2)="GR" THEN
'
'  Process GR cards.
'
j$=FIXGXR$(j$)
IF n%=0 THEN
COMMAPOS%=INSTR(j$,",") : SEMIPOS%=INSTR(j$,";")
IF COMMAPOS%<>0 OR SEMIPOS%<>0 THEN
delimtype$="comma"
DL$="," : IF SEMIPOS%<>0 THEN DL$=";"
EXIT DO
END IF
ELSE
'
'  Get tag increment and number of structure occurrences.
'
I1STR$=MID$(j$,3,3)
I2=VAL(MID$(j$,6,5))
I2STR$=LTRIM$(STR$(I2-1&))
'
'  Since what a GR card does appears to be a subset of what a GM card
' could be used for, a "fake GM card" will be created and then processed
' as if a true GM card had been read from the file.
'
WHILE LEN(I2STR$)<5
I2STR$=" "+I2STR$
WEND
j$="GM"+I1STR$+I2STR$+"        0.        0."
ROZ=1E-5*INT(360E5/I2+.501) : ROZSTR$=LTRIM$(STR$(ROZ))
WHILE LEN(ROZSTR$)<10
ROZSTR$=" "+ROZSTR$
WEND
j$=j$+ROZSTR$+"        0.        0.        0.        1."
'
'  Go back and process "GM card" just created.
'
GOTO REPROC
END IF
ELSE
'
'  Process GM cards.  (Recalculate DISTSQD and height in process.)
'
j$=FIXGM$(j$)
'
'  Number of wires may eventually increase (if NRPT on GM card > 0).
' However, in the meantime, don't apply GM processing to "faked GW data"
' already created by current GM card processing--i.e., save value of n%
' and update it later.
'
IF n%=0 THEN
COMMAPOS%=INSTR(j$,",") : SEMIPOS%=INSTR(j$,";")
IF COMMAPOS%<>0 OR SEMIPOS%<>0 THEN
delimtype$="comma"
DL$="," : IF SEMIPOS%<>0 THEN DL$=";"
EXIT DO
END IF
ELSE
NNEW%=n%
ITGI%=VAL(MID$(j$,3,3))
NRPT%=VAL(MID$(j$,6,5))
ROX0=VAL(MID$(j$,11,10))
ROY0=VAL(MID$(j$,21,10))
ROZ0=VAL(MID$(j$,31,10))
XS0=VAL(MID$(j$,41,10))
YS0=VAL(MID$(j$,51,10))
ZS0=VAL(MID$(j$,61,10))
ROX=ROX0 : ROY=ROY0 : ROZ=ROZ0 : XS=XS0 : YS=YS0 : ZS=ZS0
ITS=VAL(MID$(j$,71,10))
MTAG%=INT(ITS)
'
'  GET FRACTIONAL PART OF ITS.  IF NONZERO, TAKE IT TO BE ENDING TAG
' NUMBER FOR GM TRANSFORMATION.  OTHERWISE, TAKE TAG NUMBER OF LAST
' SEGMENT ENCOUNTERED BEFORE GM CARD AS ENDING TAG NUMBER.
'
ITSFRC=ITS-MTAG%
ETAG=INT(1000*ITSFRC+.0001)
IF ETAG=0 THEN ETAG=32767
'
'  REACQUIRE ETAG IF NEC4 PARAMETERS ARE PRESENT ON GM CARD AND THEN GET
' THOSE PARAMETERS TOO.  DEFINE DEFAULT START AND END SEGMENT NUMBERS
' FIRST, IN CASE IT'S A NEC2 FILE.
'
STSEG=1 : ESEG=n%
IF LEN(j$)>80 THEN
F8=VAL(MID$(j$,81,10)) : F9=VAL(MID$(j$,91,10)) : F10=VAL(MID$(j$,101,10))
STSEG=INT(F8) : ETAG=INT(F9) : ESEG=INT(F10)
END IF
IF MTAG%<1 THEN MTAG%=1
IF STSEG<1 THEN STSEG=1
IF ESEG>n% THEN ESEG=n%
'
'  Find first wire number with a tag number of MTAG%.  (This wouldn't be
' necessary if it was guaranteed that tag numbers = wire numbers, but that
' isn't guaranteed.)
'
NMIN=0
FOR K=1 TO n%
IF NTAG%(K)=MTAG% THEN NMIN=K : EXIT FOR
NEXT K
'
'  Watch out for something happening that really shouldn't happen and
' apply about only fix that's possible.
'
IF NMIN=0 THEN NMIN=MTAG%
'
'  This step is just in case NEC file wasn't created quite right.
'
IF NRPT%<0 THEN NRPT%=0
FOR K=0 TO NRPT%
FOR M%=1 TO n%
IF M%>=STSEG AND M%<=ESEG THEN
IF (NTAG%(M%)>=MTAG% AND NTAG%(M%)<=ETAG) AND ((K=0 AND NRPT%=0) OR K>0) THEN
'
'  Rotate structure successively about three axes.  (Note that if NRPT% >
' 0, it's a copy of the structure that is being rotated or translated.)
'
MS%=M%+K*(n%-NMIN+1)
y1(MS%)=y1(M%) : z1(MS%)=z1(M%)
CALL COROT(y1(MS%),z1(MS%),ROX)
y2(MS%)=y2(M%) : z2(MS%)=z2(M%)
CALL COROT(y2(MS%),z2(MS%),ROX)
x1(MS%)=x1(M%)
CALL COROT(x1(MS%),z1(MS%),-ROY)
x2(MS%)=x2(M%)
CALL COROT(x2(MS%),z2(MS%),-ROY)
CALL COROT(x1(MS%),y1(MS%),ROZ)
CALL COROT(x2(MS%),y2(MS%),ROZ)
'
'  Translate structure.
'
x1(MS%)=x1(MS%)+XS
y1(MS%)=y1(MS%)+YS
z1(MS%)=z1(MS%)+ZS
x2(MS%)=x2(MS%)+XS
y2(MS%)=y2(MS%)+YS
z2(MS%)=z2(MS%)+ZS
IF K>0 THEN
NNEW%=NNEW%+1
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(M%)>0 THEN NTAG%(NNEW%)=NTAG%(M%)+ITGI%*K
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%)
RAD(NNEW%)=RAD(M%)
END IF
IF NXFLAG=0 THEN
DISTSQD = x1(MS%) * x1(MS%) + y1(MS%) * y1(MS%) + z1(MS%) * z1(MS%)
IF DISTSQD=0 THEN DISTSQD = x2(MS%) * x2(MS%) + y2(MS%) * y2(MS%) + z2(MS%) * z2(MS%)
IF DISTSQD > height THEN height = DISTSQD
END IF
END IF
END IF
NEXT M%
IF K>0 THEN
'
'  Update transformation variables for next copy.  (Otherwise, all copies
' of original structure end up on top of each other.)
'
ROX=ROX0+ROX : ROY=ROY0+ROY : ROZ=ROZ0+ROZ
XS=XS0+XS : YS=YS0+YS : ZS=ZS0+ZS
END IF
NEXT K
'
'  Now update number of wires.  (Next GM card transforms results of last
' GM card's effects.)
'
n%=NNEW%
END IF
END IF
       END IF
     LOOP
'
'  Look for NX or EN card (addition by Stumpff for multi-structure NEC
' files).
'
WHILE LEFT$(j$,2)<>"NX" AND LEFT$(j$,2)<>"EN" AND NOT EOF(1)
LINE INPUT#1,j$
WEND
IF EOF(1) OR LEFT$(j$,2)="EN" THEN ENDFLAG=1
     IF delimtype$ = "comma" THEN GOSUB commadelim
'
'  Addition by Stumpff:  test for no GW/GA/GH cards.
'
IF n%=0 THEN SCREEN 0 : PRINT "No GW, GA, or GH cards!" : GOTO DONE
IF NXFLAG=0 THEN
     height = 1.1 * SQR(height)  'Scale display to fit input file
     XPMIN = -height / 2: YPMIN = -height / 2
END IF
IF LEFT$(j$,2)="NX" THEN NXFLAG=1
     GOSUB newwindow
'
'  Old definition of nmax% changed by Stumpff because of above change in
' how GW cards are counted.
'
'     nmax% = n% - 1
     nmax% = n%
'
'  Don't reprint "help information" or do other unnecessary stuff if first
' structure in a multi-structure NEC file isn't the one being displayed.
'
IF PFLAG=1 THEN
     PHI = 320: THETA = 60
'
'  Get printer type to see if printer message is warranted.
'
     PRINTER$=UCASE$(ENVIRON$("PRINTER"))
     PTEST=INSTR(PRINTER$,"LASERJET")+INSTR(PRINTER$,"EPSONLQ")
     PTEST=PTEST+INSTR(PRINTER$,"8PIN")

     LOCATE 2, 68: PRINT "AXIS LENGTH:"
     LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
'
'  Different LOCATE routine structure implemented by Stumpff to handle
' difference between VGA and EGA screens.
'
IF MODE=9 THEN
     LOCATE 6, 68: PRINT " PGUP/PGDN "
     LOCATE 7, 68: PRINT "    KEYS"
     LOCATE 8, 68: PRINT "CHANGE SCALE"
     LOCATE 12, 68: PRINT " PHI THETA"
     LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
     LOCATE 16, 68: PRINT " ARROW KEYS"
     LOCATE 17, 68: PRINT "  TO ROTATE"
     LOCATE 20, 68: PRINT "2-4-6-8-0:"
     LOCATE 21, 68: PRINT " SHIFT AXES"
     LOCATE 24, 68: PRINT "  +/-,n"
     LOCATE 25, 68: PRINT "TO HIGHLIGHT"
     LOCATE 26, 68: PRINT "   A WIRE:"
     LOCATE 27, 68: PRINT " DATA BELOW"
     LOCATE 31, 68: PRINT "B,L,S,X,Y,Z"
     LOCATE 32, 68: PRINT "CHANGE COLORS"
     LOCATE 34, 68: PRINT "  <ESC>"
     LOCATE 35, 68: PRINT "   TO"
     LOCATE 36, 68: PRINT "  QUIT"
     IF PTEST<>0 THEN LOCATE 38,68 : PRINT "O TO PRINT"
ELSE
     LOCATE 8, 68: PRINT " PGUP/PGDN "
     LOCATE 9, 68: PRINT "    KEYS"
     LOCATE 10, 68: PRINT "CHANGE SCALE"
     LOCATE 14, 68: PRINT " PHI THETA"
     LOCATE 16, 68: PRINT USING " ###"; PHI; THETA
     LOCATE 20, 68: PRINT " ARROW KEYS"
     LOCATE 21, 68: PRINT "  TO ROTATE"
     LOCATE 25, 68: PRINT "2-4-6-8-0:"
     LOCATE 26, 68: PRINT " SHIFT AXES"
     LOCATE 30, 68: PRINT "  +/-,n"
     LOCATE 31, 68: PRINT "TO HIGHLIGHT"
     LOCATE 32, 68: PRINT "   A WIRE:"
     LOCATE 33, 68: PRINT " DATA BELOW"
     LOCATE 37, 68: PRINT "B,L,S,X,Y,Z"
     LOCATE 38, 68: PRINT "CHANGE COLORS"
     LOCATE 42, 68: PRINT "  <ESC>"
     LOCATE 43, 68: PRINT "   TO"
     LOCATE 44, 68: PRINT "  QUIT"
     IF PTEST<>0 THEN LOCATE 48,68 : PRINT "O TO PRINT"
     IF MODE=12 THEN
     LOCATE 52,68 : PRINT "C FOR PCX"
     LOCATE 54,68 : PRINT "T FOR BMP"
     END IF
     IF NXFLAG=1 THEN LOCATE 60,58 : PRINT "HOME FOR NEXT STRUCTURE";
END IF
PFLAG=0
END IF
     hn% = 1
     LOCATE CARDLINE, 1: PRINT "CARD TAG SEGS    X1       Y1       Z1       X2       Y2       Z2      RAD   "
     LOCATE CARDLINE+1, 1: PRINT USING "####"; hn%;
     PRINT USING " ###"; NTAG%(hn%);
     PRINT USING " ###"; NSEG%(hn%);
     PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
'
'  Change sign of x coordinates (addition by Stumpff).
'
FOR m%=1 TO n%
x1(m%)=-x1(m%) : x2(m%)=-x2(m%)
NEXT m%

DRAWIT:
     VIEW (10, 10)-(530, BOTTOM), SHEETCOL%   ' re-draws the background
'    The XP and YP functions do the coordinate rotation
     XP1 = XP(0!, 0!, 0!, PHI, THETA): YP1 = YP(0!, 0!, 0!, PHI, THETA)
'
'   Variable height sign change by Stumpff to reverse direction of x-axis.
'
     XP2 = XP(-height / 4, 0!, 0!, PHI, THETA): YP2 = YP(-height / 4, 0!, 0!, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), XAXISCOL%
     XP1 = XP(0!, 0!, 0!, PHI, THETA): YP1 = YP(0!, 0!, 0!, PHI, THETA)
     XP2 = XP(0!, height / 4, 0!, PHI, THETA): YP2 = YP(0!, height / 4, 0!, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), YAXISCOL%
     XP1 = XP(0!, 0!, 0!, PHI, THETA): YP1 = YP(0!, 0!, 0!, PHI, THETA)
     XP2 = XP(0!, 0!, height / 4, PHI, THETA): YP2 = YP(0!, 0!, height / 4, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), ZAXISCOL%
     FOR n% = 1 TO nmax%
       XP1 = XP(x1(n%), y1(n%), z1(n%), PHI, THETA): YP1 = YP(x1(n%), y1(n%), z1(n%), PHI, THETA)
       XP2 = XP(x2(n%), y2(n%), z2(n%), PHI, THETA): YP2 = YP(x2(n%), y2(n%), z2(n%), PHI, THETA)
       LINE (XP1, YP1)-(XP2, YP2), LINECOL%
     NEXT n%
     XP1 = XP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA): YP1 = YP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA)
     XP2 = XP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA): YP2 = YP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), SLINECOL%

ALREADYDRAWN:
     DO
       test$ = INKEY$
     LOOP WHILE test$ = ""
     ' Convert 2-byte extended code to 1-byte ASCII code and handle
'
'  Addition by Stumpff so "O" doesn't mask as END key.
'
     if len(test$)=1 and test$="O" then test$="o"
     test$ = RIGHT$(test$, 1)
     SELECT CASE test$
'
'  This was added by Stumpff to keep END from causing crash when printer
' isn't turned on and PRINTER environment variable is set.  (END key masks
' as "O".)
'
       CASE CHR$(ENDKEY)
'
'   Added by Stumpff for multi-structure NEC file processing.
'
       CASE CHR$(HOME)
       IF NXFLAG=0 THEN GOTO ALREADYDRAWN
       IF ENDFLAG=1 THEN SEEK #1,1
       GOTO NEXTSTRUCT
'
'   Added by Stumpff for BMP output.
'
       CASE "t","T"
         IF MODE=12 THEN
         CALL MAKEBMP(BOTTOM,BMPNUM)
         IF BMPNUM<32767 THEN
         BMPNUM=BMPNUM+1
         ELSE
         BMPNUM=0
         END IF
         BEEP
         END IF
         GOTO ALREADYDRAWN
       CASE CHR$(PGUP) 'REDUCE SCALE
         VIEW (10, 10)-(530, BOTTOM), SHEETCOL%
         height = 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE CHR$(PGDN) 'EXPAND SCALE
         height = 1 / 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE "6" 'move to right
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "4" 'move to left
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "8" 'move up
         yoffset = yoffset - height / 10
         GOSUB newwindow
       CASE "2" 'move down
         yoffset = yoffset + height / 10
         GOSUB newwindow
       CASE "9" 'move up and right
         yoffset = yoffset - height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "7" 'move up and left
         yoffset = yoffset - height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "3" 'move down and right
         yoffset = yoffset + height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "1" 'move down and left
         yoffset = yoffset + height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "0" 'back to origin
         xoffset = 0: yoffset = 0
         GOSUB newwindow
       CASE CHR$(RIGHT)
         PHI = (PHI + 370) MOD 360     'IF test replaced by MOD function by
                                       ' Stumpff.
         LOCATE ANGLELINE, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(LEFT)
         PHI = PHI - 10
         IF PHI < 0 THEN PHI = PHI + 360
         LOCATE ANGLELINE, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(UP)
         THETA = THETA + 10
'
'  Constraints on THETA here and below added by Stumpff.
'
         IF THETA>180 THEN THETA=360-THETA : PHI=(PHI+180) MOD 360
         LOCATE ANGLELINE, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(DOWN)
         THETA = THETA - 10
         IF THETA<0 THEN THETA=-THETA : PHI=(PHI+180) MOD 360
         LOCATE ANGLELINE, 68: PRINT USING " ###"; PHI; THETA
       CASE "-"
         hn% = hn% - 1: IF hn% < 1 THEN hn% = nmax%
         LOCATE CARDLINE+1, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###"; NSEG%(hn%);
'
'  Displayed signs of x1 and x2 reversed, here and below, by Stumpff to
' reflect what NEC actually analyzes.  (They weren't reversed initially
' for hn% = 1 because the stored x data hadn't yet had its signs
' reversed.)
'
         PRINT USING " ###.####"; -x1(hn%); y1(hn%); z1(hn%); -x2(hn%); y2(hn%); z2(hn%); rad(hn%)
       CASE "+"
         hn% = hn% + 1: IF hn% > nmax% THEN hn% = 1
         LOCATE CARDLINE+1, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###"; NSEG%(hn%);
         PRINT USING " ###.####"; -x1(hn%); y1(hn%); z1(hn%); -x2(hn%); y2(hn%); z2(hn%); rad(hn%)
       CASE "n", "N"
         LOCATE 20, 10: INPUT "Enter segment number"; hn%
         IF hn% < 1 THEN hn% = 1
         IF hn% > nmax% THEN hn% = nmax%
         LOCATE CARDLINE+1, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###"; NSEG%(hn%);
         PRINT USING " ###.####"; -x1(hn%); y1(hn%); z1(hn%); -x2(hn%); y2(hn%); z2(hn%); rad(hn%)
       CASE "l", "L"
         LINECOL% = LINECOL% + 1
         IF LINECOL% > 15 THEN LINECOL% = 0
       CASE "s", "S"
         SLINECOL% = SLINECOL% + 1
         IF SLINECOL% > 15 THEN SLINECOL% = 0
       CASE "x", "X"
         XAXISCOL% = XAXISCOL% + 1
         IF XAXISCOL% > 15 THEN XAXISCOL% = 0
       CASE "y", "Y"
         YAXISCOL% = YAXISCOL% + 1
         IF YAXISCOL% > 15 THEN YAXISCOL% = 0
       CASE "z", "Z"
         ZAXISCOL% = ZAXISCOL% + 1
         IF ZAXISCOL% > 15 THEN ZAXISCOL% = 0
       CASE "b", "B"
         SHEETCOL% = SHEETCOL% + 1
         IF SHEETCOL% > 15 THEN SHEETCOL% = 0
'
'  The following was added by Stumpff to print picture on printer
' specified with "PRINTER" environmnent variable.  (If PRINTER = LASERJET,
' the environment variable DPI should be set equal to the desired number
' of dots per inch before running this program.  If PRINTER = 8PIN, the
' environment variable TYPE should be set equal to I if your 8-pin printer
' is set up to emulate IBM graphics (or if it *is* an IBM printer).)
'
       CASE "O", "o"
         IF INSTR(PRINTER$,"LASERJET")<>0 THEN
'
'  HP Laserjet or Deskjet--get dots per inch.
'
         DPI=VAL(ENVIRON$("DPI")) : IF DPI=0 THEN DPI=75
         CALL HPRINT(10,10,530,BOTTOM,DPI,1)
         ELSEIF INSTR(PRINTER$,"EPSONLQ")<>0 THEN
'
'  EPSONLQ
'
         CALL EPRINT(10,10,530,BOTTOM,1)
         ELSEIF INSTR(PRINTER$,"8PIN")<>0 THEN
'
'  8-pin--get emulation switch.
'
         PTYPE$=LTRIM$(RTRIM$(UCASE$(ENVIRON$("TYPE"))))
         IF PTYPE$="IBM" THEN PTYPE$="I"
         IF PTYPE$<>"I" THEN PTYPE$="S"
         CALL PRINT8(10,10,530,BOTTOM,1,PTYPE$)
         END IF
         BEEP         'Just to let human know printer's done.
         GOTO ALREADYDRAWN
       CASE "C", "c"
'
'  This was added by Stumpff to make PCX file (NECGEO.PCX) if video mode
' 12 is in use.  (BOTTOM is passed to MAKEPCX instead of hard-coding it
' inside the subroutine in case I ever get motivated to make the sub-
' routine convert a 4-bit palette to an 8-bit one so it can handle mode 9
' graphics.)
'
         IF MODE=12 THEN
         CALL MAKEPCX(BOTTOM)
         BEEP
         END IF
         GOTO ALREADYDRAWN
       CASE CHR$(ESC)
         GOTO DONE
     END SELECT
     GOTO DRAWIT

DONE:
CLOSE #1
SCREEN 0
WIDTH 80
'    STOP     'Commented out by Stumpff.
     END

commadelim:         'read comma-delimited NEC-2 input file
'
'  This routine was fixed by Stumpff using subroutine PARSE.  (That
' subroutine is also used for Stumpff's addition of GA/GH card processing.)
'
     OPEN NECFILE$ FOR INPUT AS #1
     n% = 0
'    Skip through the comment cards:
     DO
       LINE INPUT #1, j$
       IF LEFT$(j$, 2) = "CE" THEN EXIT DO
     LOOP
'    Read geometry cards. Quit at GS or GE
     DO
'
'  In addition to using subroutine PARSE, Stumpff also modified input
' method.
'
       LINE INPUT #1, j$
       IF LEFT$(j$,2) = "GS" OR LEFT$(j$,2) = "GE" THEN EXIT DO
'
'  Skip any non-GW, non-GA, non-GH, non-GX, non-GR, or non-GM cards.
'
PROC%=0 : IF LEFT$(j$,2) = "GW" OR LEFT$(j$,2)="GM" THEN PROC%=1
IF LEFT$(j$,2)="GA" OR LEFT$(j$,2)="GH" OR LEFT$(j$,2)="GX" THEN PROC%=1
IF LEFT$(j$,2)="GR" THEN PROC%=1
'
'  Label added by Stumpff so GR card can be faked as GM card.
'
CREPROC:
       IF PROC%=1 THEN
       IF LEFT$(j$,2)="GW" THEN
       n% = n% + 1
       CALL PARSE(j$,DL$,S1$,S2$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       NTAG%(n%)=VAL(S1$)
       CALL PARSE(S3$,DL$,S1$,S2$)
       NSEG%(n%)=VAL(S1$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       x1(n%)=VAL(S1$)
       CALL PARSE(S3$,DL$,S1$,S2$)
       y1(n%)=VAL(S1$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       z1(n%)=VAL(S1$)
       CALL PARSE(S3$,DL$,S1$,S2$)
       x2(n%)=VAL(S1$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       y2(n%)=VAL(S1$)
       CALL PARSE(S3$,DL$,S1$,S2$)
       z2(n%)=VAL(S1$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       rad(n%)=VAL(S1$)
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
'
'  Watch out for first node being at origin.  (Added by Stumpff.)
'
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
       ELSEIF LEFT$(j$,2)="GA" THEN
       CALL PARSE(j$,DL$,S1$,S2$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       ITG%=VAL(S1$)
       CALL PARSE(S3$,DL$,S1$,S2$)
       NS%=VAL(S1$)
       CALL PARSE(S2$,DL$,S1$,S3$)
       RADA=VAL(S1$)
       CALL PARSE(S3$,DL$,S1$,S2$)
       ANG1=VAL(S1$)*deg2rad
       CALL PARSE(S2$,DL$,S1$,S3$)
       ANG2=VAL(S1$)*deg2rad
       CALL PARSE(S3$,DL$,S1$,S2$)
       RADW=VAL(S1$)
DA=(ANG2-ANG1)/CSNG(NS%)
n%=n%+1
NTAG%(n%)=ITG%
rad(n%)=RADW
NSEG%(n%)=1
x1(n%)=RADA*COS(ANG1)
y1(n%)=0
z1(n%)=RADA*SIN(ANG1)
x2(n%)=RADA*COS(ANG1+DA)
y2(n%)=0
z2(n%)=RADA*SIN(ANG1+DA)
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
IF NS%>1 THEN
FOR M%=2 TO NS%
n%=n%+1
ANG=ANG1+DA*CSNG(M%)
NTAG%(n%)=ITG%
rad(n%)=RADW
NSEG%(n%)=1
x1(n%)=x2(n%-1)
y1(n%)=0
z1(n%)=z2(n%-1)
x2(n%)=RADA*COS(ANG)
y2(n%)=0
z2(n%)=RADA*SIN(ANG)
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
NEXT M%
END IF
ELSEIF LEFT$(j$,2)="GH" THEN
CALL PARSE(j$,DL$,S1$,S2$)
CALL PARSE(S2$,DL$,S1$,S3$)
ITG%=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
NS%=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
SEP=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
HL=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
A1=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
B1=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
A2=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
B2=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
RADW=VAL(S1$)
IF ABS(HL)>1E-10 THEN
SPIRAL%=0
SLOPEX=(A2-A1)/ABS(HL)
SLOPEY=(B2-B1)/ABS(HL)
NTURNS=ABS(HL)/SEP
ELSE
SPIRAL%=1
RMAX=B2 : IF A2>RMAX THEN RMAX=A2
RMIN=A1 : IF B1<RMIN THEN RMIN=B1
NTURNS=(RMAX-RMIN)/SEP
SLOPEX=(A2-A1)/CSNG(NS%)
SLOPEY=(B2-B1)/CSNG(NS%)
END IF
DA=360*NTURNS*deg2rad/CSNG(NS%)
DZDA=HL/NTURNS/360/deg2rad
n%=n%+1
rad(n%)=RADW
NTAG%(n%)=ITG%
NSEG%(n%)=1
x1(n%)=A1
y1(n%)=0
z1(n%)=0
z2(n%)=DZDA*DA
IF SPIRAL%=1 THEN RADX=A1+SLOPEX : RADY=B1+SLOPEY
IF SPIRAL%=0 THEN RADX=A1+ABS(z2(n%))*SLOPEX : RADY=B1+ABS(z2(n%))*SLOPEY
RHO=1/SQR((COS(DA)/RADX)^2+(SIN(DA)/RADY)^2)
x2(n%)=RHO*COS(DA)
y2(n%)=RHO*SIN(DA)
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
IF NS%>1 THEN
FOR M%=2 TO NS%
n%=n%+1
ANG=DA*CSNG(M%)
NTAG%(n%)=ITG%
rad(n%)=RADW
NSEG%(n%)=1
x1(n%)=x2(n%-1)
y1(n%)=y2(n%-1)
z1(n%)=z2(n%-1)
z2(n%)=DZDA*ANG
IF SPIRAL%=1 THEN RADX=A1+CSNG(M%)*SLOPEX : RADY=B1+CSNG(M%)*SLOPEY
IF SPIRAL%=0 THEN RADX=A1+ABS(z2(n%))*SLOPEX : RADY=B1+ABS(z2(n%))*SLOPEY
RHO=1/SQR((COS(ANG)/RADX)^2+(SIN(ANG)/RADY)^2)
x2(n%)=RHO*COS(ANG)
y2(n%)=RHO*SIN(ANG)
         DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
'
'  Watch out for first node being at origin.  (Added by Stumpff.)
'
IF DISTSQD=0 THEN DISTSQD = x2(n%) * x2(n%) + y2(n%) * y2(n%) + z2(n%) * z2(n%)
         IF DISTSQD > height THEN height = DISTSQD
NEXT M%
END IF
ELSEIF LEFT$(j$,2)="GX" THEN
'
'  Process GX cards.
'
IF n%>0 THEN
'
'  Get tag increment.
'
CALL PARSE(j$,DL$,S1$,S2$)
CALL PARSE(S2$,DL$,S1$,S3$)
I1=VAL(S1$)
'
'  Get reflection switch string and treat it as binary number.
'
CALL PARSE(S3$,DL$,I2STR$,S2$)
I2=DEC(I2STR$)
IF (I2 AND 1&)=1& THEN
'
'  Do reflection about xy-plane.
'
NNEW%=n%
FOR M%=1 TO n%
NNEW%=NNEW%+1
X1(NNEW%)=X1(M%) : Y1(NNEW%)=Y1(M%) : Z1(NNEW%)=-Z1(M%)
X2(NNEW%)=X2(M%) : Y2(NNEW%)=Y2(M%) : Z2(NNEW%)=-Z2(M%)
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(NNEW%)>0 THEN NTAG%(NNEW%)=NTAG%(NNEW%)+I1
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%) : RAD(NNEW%)=RAD(M%)
NEXT M%
'
'  Update n% AND I1 for next reflection (and subsequent card processing).
'
n%=NNEW% : I1=2*I1
END IF
IF (I2 AND 2&)=2& THEN
'
'  Do reflection about xz-plane.
'
NNEW%=n%
FOR M%=1 TO n%
NNEW%=NNEW%+1
X1(NNEW%)=X1(M%) : Y1(NNEW%)=-Y1(M%) : Z1(NNEW%)=Z1(M%)
X2(NNEW%)=X2(M%) : Y2(NNEW%)=-Y2(M%) : Z2(NNEW%)=Z2(M%)
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(NNEW%)>0 THEN NTAG%(NNEW%)=NTAG%(NNEW%)+I1
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%) : RAD(NNEW%)=RAD(M%)
NEXT M%
'
'  Update n% AND I1 for next reflection (and subsequent card processing).
'
n%=NNEW% : I1=2*I1
END IF
IF (I2 AND 4&)=4& THEN
'
'  Do reflection about yz-plane.
'
NNEW%=n%
FOR M%=1 TO n%
NNEW%=NNEW%+1
X1(NNEW%)=-X1(M%) : Y1(NNEW%)=Y1(M%) : Z1(NNEW%)=Z1(M%)
X2(NNEW%)=-X2(M%) : Y2(NNEW%)=Y2(M%) : Z2(NNEW%)=Z2(M%)
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(NNEW%)>0 THEN NTAG%(NNEW%)=NTAG%(NNEW%)+I1
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%) : RAD(NNEW%)=RAD(M%)
NEXT M%
'
'  Update n% for subsequent card processing.
'
n%=NNEW%
END IF
END IF
ELSEIF LEFT$(j$,2)="GR" THEN
'
'  Process GR cards.
'
IF n%>0 THEN
'
'  Get tag increment and number of structure occurrences.
'
CALL PARSE(j$,DL$,S1$,S2$)
CALL PARSE(S2$,DL$,I1STR$,S3$)
CALL PARSE(S3$,DL$,I2STR$,S2$)
I2=VAL(I2STR$)
I2STR$=LTRIM$(STR$(I2-1&))
'
'  Since what a GR card does appears to be a subset of what a GM card
' could be used for, a "fake GM card" will be created and then processed
' as if a true GM card had been read from the file.
'
j$="GM,"+I1STR$+","+I2STR$+",0.,0."
ROZ=1E-5*INT(360E5/I2+.501) : ROZSTR$=LTRIM$(STR$(ROZ))
j$=j$+","+ROZSTR$+",0.,0.,0.,1."
'
'  Go back and process "GM card" just created.
'
GOTO CREPROC
END IF
       ELSE
'
'  Process GM cards.  (Recalculate DISTSQD and height in process.)
'
'  Number of wires may eventually increase (if NRPT on GM card > 0).
' However, in the meantime, don't apply GM processing to "faked GW data"
' already created by current GM card processing--i.e., save value of n%
' and update it later.
'
IF n%>0 THEN
NNEW%=n%
CALL PARSE(j$,DL$,S1$,S2$)
CALL PARSE(S2$,DL$,S1$,S3$)
ITGI%=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
NRPT%=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
ROX0=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
ROY0=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
ROZ0=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
XS0=VAL(S1$)
CALL PARSE(S2$,DL$,S1$,S3$)
YS0=VAL(S1$)
CALL PARSE(S3$,DL$,S1$,S2$)
ZS0=VAL(S1$)
ROX=ROX0 : ROY=ROY0 : ROZ=ROZ0 : XS=XS0 : YS=YS0 : ZS=ZS0
CALL PARSE(S2$,DL$,S1$,S3$)
ITS=VAL(S1$)
MTAG%=INT(ITS)
IF MTAG%<1 THEN MTAG%=1
'
'  Find first wire number with a tag number of NMIN.  (This wouldn't be
' necessary if it was guaranteed that tag numbers = wire numbers, but that
' isn't guaranteed.)
'
NMIN=0
FOR K=1 TO n%
IF NTAG%(K)=MTAG% THEN NMIN=K : EXIT FOR
NEXT K
'
'  Watch out for something happening that really shouldn't happen and
' apply about only fix that's possible.
'
IF NMIN=0 THEN NMIN=MTAG%
'
'  This step is just in case NEC file wasn't created quite right.
'
IF NRPT%<0 THEN NRPT%=0
FOR K=0 TO NRPT%
FOR M%=1 TO n%
IF (NTAG%(M%)>=MTAG%) AND ((K=0 AND NRPT%=0) OR K>0) THEN
'
'  Rotate structure successively about three axes.  (Note that if NRPT% >
' 0, it's a copy of the structure that is being rotated or translated.)
'
MS%=M%+K*(n%-NMIN+1)
y1(MS%)=y1(M%) : z1(MS%)=z1(M%)
CALL COROT(y1(MS%),z1(MS%),ROX)
y2(MS%)=y2(M%) : z2(MS%)=z2(M%)
CALL COROT(y2(MS%),z2(MS%),ROX)
x1(MS%)=x1(M%)
CALL COROT(x1(MS%),z1(MS%),-ROY)
x2(MS%)=x2(M%)
CALL COROT(x2(MS%),z2(MS%),-ROY)
CALL COROT(x1(MS%),y1(MS%),ROZ)
CALL COROT(x2(MS%),y2(MS%),ROZ)
'
'  Translate structure.
'
x1(MS%)=x1(MS%)+XS
y1(MS%)=y1(MS%)+YS
z1(MS%)=z1(MS%)+ZS
x2(MS%)=x2(MS%)+XS
y2(MS%)=y2(MS%)+YS
z2(MS%)=z2(MS%)+ZS
IF K>0 THEN
NNEW%=NNEW%+1
NTAG%(NNEW%)=NTAG%(M%)
IF NTAG%(M%)>0 THEN NTAG%(NNEW%)=NTAG%(M%)+ITGI%*K
IF NTAG%(NNEW%)>999 THEN NTAG%(NNEW%)=999
NSEG%(NNEW%)=NSEG%(M%)
RAD(NNEW%)=RAD(M%)
END IF
DISTSQD = x1(MS%) * x1(MS%) + y1(MS%) * y1(MS%) + z1(MS%) * z1(MS%)
IF DISTSQD=0 THEN DISTSQD = x2(MS%) * x2(MS%) + y2(MS%) * y2(MS%) + z2(MS%) * z2(MS%)
IF DISTSQD > height THEN height = DISTSQD
END IF
NEXT M%
IF K>0 THEN
'
'  Update transformation variables for next copy.  (Otherwise, all copies
' of original structure end up on top of each other.)
'
ROX=ROX0+ROX : ROY=ROY0+ROY : ROZ=ROZ0+ROZ
XS=XS0+XS : YS=YS0+YS : ZS=ZS0+ZS
END IF
NEXT K
'
'  Now update number of wires.  (Next GM card transforms results of last
' GM card's effects.)
'
n%=NNEW%
END IF
       END IF
       END IF
     LOOP
     CLOSE #1
     RETURN

newwindow:
     WINDOW (XPMIN + xoffset, YPMIN + yoffset)-(1.4 * height + XPMIN + xoffset, height + YPMIN + yoffset)
     RETURN

     END

     FUNCTION XP (X, Y, Z, PHI, THETA)
'       deg2rad = ATN(1!) / 45
       XP = -X * SIN(PHI * deg2rad) + Y * COS(PHI * deg2rad)
     END FUNCTION

     FUNCTION YP (X, Y, Z, PHI, THETA)
'      deg2rad = ATN(1!) / 45
      YP = Z * SIN(THETA * deg2rad) - X * COS(THETA * deg2rad) * COS(PHI * deg2rad) - Y * COS(THETA * deg2rad) * SIN(PHI * deg2rad)
     END FUNCTION

'  The following printer routines were added by Stumpff.
'
'  This subroutine prints graphics data to an HP Laserjet/Deskjet printer.
' (XL,YL) are the SCREEN coordinates of upper lefthand corner of the
' rectangular region on the screen to be printed and (XR,YR) are the
' coordinates of the lower righthand corner.  DPI is the dots/inch that
' you want to print at.  FF should be input as 1 if you want to form feed
' when you're done printing.  (Any other value means "no form feed.")
' Since this subroutine uses the LPRINT command or its bios equivalent,
' the I/O port is assumed to be LPT1.
'
SUB HPRINT(XL AS INTEGER,YL AS INTEGER,XR AS INTEGER,YR AS INTEGER,DPI AS INTEGER,FF AS INTEGER)
DIM VPAGE AS INTEGER,J AS INTEGER,I AS INTEGER,K AS INTEGER,BCOL,PIXEL AS INTEGER
DIM W8 AS INTEGER,W AS INTEGER,PEX AS INTEGER,V AS INTEGER,BYTES AS INTEGER
'
'   SHEETCOL is SHARED here because screen pixels will only be printed if
'  they're different from the viewport background.
'
SHARED SHEETCOL%
'
'  Get visible page and leave it as stored in BH.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
VPAGE=OUTREGS.BX
'
'  Get width of screen area.
'
W=XR-XL+1
'
'  Get number of whole bytes in each line and excess number of bits that
' must be padded with zeros to make a complete byte.
'
W8=8*INT(W/8+.001)
PEX=W-W8
'
'  Set up printer.
'
WIDTH "LPT1:",255
LPRINT CHR$(27);"&l0O";
LPRINT CHR$(27);"*t";LTRIM$(RTRIM$(STR$(DPI)));"R";
BYTES=W8/8+SGN(PEX)
FOR J=YL TO YR
'
'  Convert 8 bits at a time in line J to bytes and print each byte.
' (All that matters here is whether the attribute of the pixel is 0 or
' some color.  Any color but 0 is treated as a bit of one.  An attribute
' equal to SHEETCOL is set to 0 in order to avoid printing the
' background in the grid display.)
'
'  First, start raster graphics and tell printer how many bytes are coming
' for Jth line of pixels.
'
LPRINT CHR$(27);"*r0A";CHR$(27);"*b";
CALL BLPRINT(LTRIM$(RTRIM$(STR$(BYTES)))+"W")
'
'  Watch out for there being less than 8 columns of pixels to print.
'
IF W8>0 THEN
FOR I=XL TO XL+W8-1 STEP 8
V=0
FOR K=1 TO 8
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I+K-1
INREGS.DX=J
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V=V+SGN(PIXEL)*2^(8-K)
NEXT K
'
'  Print byte.
'
CALL BLPRINT(CHR$(V))
NEXT I
END IF
'
'  Print "excess byte" in row J.
'
IF PEX>0 THEN
V=0
FOR I=1 TO PEX
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=XL+I+W8-1
INREGS.DX=J
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V=V+SGN(PIXEL)*2^(8-I)
NEXT I
CALL BLPRINT(CHR$(V))
END IF
NEXT J
'
'  End graphics transfer and form feed printer if FF = 1.
'
LPRINT CHR$(27);"*rbC";
IF FF=1 THEN LPRINT CHR$(12);
END SUB
'
'  This subroutine prints the portion of a graphics screen within the
' rectangle specified by (XL,YL) and (XR,YR) on a 24-pin Epson LQ
' printer.  Like HPRINT, FF is input as 1 to form feed when finished.
'
SUB EPRINT(XL AS INTEGER,YL AS INTEGER,XR AS INTEGER,YR AS INTEGER,FF AS INTEGER)
DIM VPAGE AS INTEGER,I AS INTEGER,J AS INTEGER,K AS INTEGER,PIXEL AS INTEGER
DIM W AS INTEGER,H24 AS INTEGER,LEX AS INTEGER,N1 AS INTEGER,N2 AS INTEGER
DIM V1 AS INTEGER,V2 AS INTEGER,V3 AS INTEGER
'
'   SHEETCOL is SHARED here because screen pixels will only be printed if
'  they're different from the viewport background.
'
SHARED SHEETCOL%
'
'  Get visible page and leave it as stored in BH.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
VPAGE=OUTREGS.BX
'
'  Get width and height of screen area.
'
W=XR-XL+1  : H=CSNG(YR-YL)+1
'
'  Being a typical dot matrix printer, the Epson LQ prints a column of
' dots as the printhead moves horizontally across the page.  In this
' particular case, there are 24 dots in that column.  Find the number
' of lines in the picture area that is an integral multiple of 24.  The
' bits for the excess lines must be padded with zeros to make a complete
' set of 24.
'
H24=24*INT(H/24+.001)
LEX=CINT(H)-H24
'
'  Set up printer.
'
WIDTH "LPT1:",255
'
'  N1 and N2 are the low and high bytes of width W.
'
N1=W AND &HFF
N2=(W AND &HFF00&)/256
LPRINT CHR$(27);"3";CHR$(24);
'
'  Watch out for there being less than 24 lines of pixels to print.
'
IF H24>0 THEN
FOR J=YL TO YL+H24-1 STEP 24
'
'  Get three bytes corresponding to each column of 24 pixels in pixel
' rows J to J + 23.  (All that matters here is whether the attribute of
' the pixel is 0 or some color.  Any color but 0 is treated as a bit of
' one.  An attribute equal to SHEETCOL is set to 0 in order to avoid
' printing the background in the grid display.)
'
'  First, tell printer how many bits are coming for each row of pixels.
'
LPRINT CHR$(27);"*";CHR$(39);
CALL BLPRINT(CHR$(N1)+CHR$(N2))
FOR I=XL TO XR
V1=0
V2=0
V3=0
FOR K=1 TO 8
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=J+K-1
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V1=V1+SGN(PIXEL)*2^(8-K)
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=J+K+7
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V2=V2+SGN(PIXEL)*2^(8-K)
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=J+K+15
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V3=V3+SGN(PIXEL)*2^(8-K)
NEXT K
'
'  Print 3 bytes.
'
CALL BLPRINT(CHR$(V1)+CHR$(V2)+CHR$(V3))
NEXT I
'
'  Reset starting print position.
'
LPRINT
NEXT J
END IF
'
'  Print excess lines of pixels.
'
IF LEX>0 THEN
LPRINT CHR$(27);"*";CHR$(39);
CALL BLPRINT(CHR$(N1)+CHR$(N2))
FOR I=XL TO XR
V1=0
V2=0
V3=0
FOR J=1 TO 8
IF J<=LEX THEN
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=YL+J+H24-1
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V1=V1+SGN(PIXEL)*2^(8-J)
END IF
IF J+8<=LEX THEN
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=YL+J+H24+7
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V2=V2+SGN(PIXEL)*2^(8-J)
END IF
IF J+16<=LEX THEN
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=YL+J+H24+15
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V3=V3+SGN(PIXEL)*2^(8-J)
END IF
NEXT J
CALL BLPRINT(CHR$(V1)+CHR$(V2)+CHR$(V3))
NEXT I
LPRINT
END IF
'
'  Graphics data is transferred.  Reset printer line spacing.
'
LPRINT CHR$(27);"2";
'
'  Form feed printer if FF = 1.
'
IF FF=1 THEN LPRINT CHR$(12);
END SUB
'
'  This subroutine prints the portion of a graphics screen within the
' rectangle specified by (XL,YL) and (XR,YR) using "standard" 8-pin
' graphics commands.  It should work with 9-pin printers such as Epsons,
' the Panasonic KX-P1092, the Star SG-10 or 15, etc.  (It should also
' work with the Epson LQ, if 8-pin graphics are acceptable.)  Like HPRINT
' and EPRINT, FF is input as 1 to form feed when finished.  The character
' string PTYPE$ should be input as "S" if your printer is set up in its
' standard or native mode and "I" if it's set up to emulate IBM graphics.
'
SUB PRINT8(XL AS INTEGER,YL AS INTEGER,XR AS INTEGER,YR AS INTEGER,FF AS INTEGER,PTYPE$)
DIM VPAGE AS INTEGER,I AS INTEGER,J AS INTEGER,K AS INTEGER,PIXEL AS INTEGER
DIM W AS INTEGER,V AS INTEGER,H8 AS INTEGER,N1 AS INTEGER,N2 AS INTEGER
DIM LEX AS INTEGER
'
'   SHEETCOL is SHARED here because screen pixels will only be printed if
'  they're different from the viewport background.
'
SHARED SHEETCOL%
'
'  Get visible page and leave it as stored in BH.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
VPAGE=OUTREGS.BX
'
'  Get width and height of screen area.
'
W=XR-XL+1  : H=CSNG(YR-YL)+1
'
'  Data is sent to the printer one column of 8 dots at a time.  Find the
' number of lines in the picture area that is an integral multiple of 8.
' The bits for the excess lines must be padded with zeros to make a
' complete set of 8.
'
H8=8*INT(H/8+.001)
LEX=CINT(H)-H8
'
'  Set up printer.
'
WIDTH "LPT1:",255
'
'  N1 and N2 are the low and high bytes of width W.
'
N1=W AND &HFF
N2=(W AND &HFF00&)/256
LPRINT CHR$(27);"A";CHR$(8);
IF UCASE$(PTYPE$)="I" THEN LPRINT CHR$(27);"2";
'
'  Watch out for there being less than 8 lines of pixels to print.
'
IF H8>0 THEN
FOR J=YL TO YL+H8-1 STEP 8
'
'  Get byte corresponding to each column of 8 pixels in pixel rows J to
' J + 7.  (All that matters here is whether the attribute of the pixel is
' 0 or some color.  Any color but 0 is treated as a bit of one.  An
' attribute equal to SHEETCOL is set to 0 in order to avoid printing the
' background in the grid display.)
'
'  First, tell printer how many bits are coming for each row of pixels.
'
LPRINT CHR$(27);"L";
CALL BLPRINT(CHR$(N1)+CHR$(N2))
FOR I=XL TO XR
V=0
FOR K=1 TO 8
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=J+K-1
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V=V+SGN(PIXEL)*2^(8-K)
NEXT K
'
'  Print byte.
'
CALL BLPRINT(CHR$(V))
NEXT I
'
'  Reset starting print position.
'
LPRINT
NEXT J
END IF
'
'  Print excess lines of pixels.
'
IF LEX>0 THEN
LPRINT CHR$(27);"L";
CALL BLPRINT(CHR$(N1)+CHR$(N2))
FOR I=XL TO XR
V=0
FOR J=1 TO LEX
INREGS.AX=&HD00
INREGS.BX=VPAGE
INREGS.CX=I
INREGS.DX=YL+J+H8-1
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PIXEL=OUTREGS.AX AND &HFF : IF PIXEL=SHEETCOL% THEN PIXEL=0
V=V+SGN(PIXEL)*2^(8-J)
NEXT J
CALL BLPRINT(CHR$(V))
NEXT I
LPRINT
END IF
'
'  Graphics data is transferred.  Reset printer line spacing.
'
IF UCASE$(PTYPE$)="I" THEN LPRINT CHR$(27);"A";CHR$(12);
LPRINT CHR$(27);"2";
'
'  Form feed printer if FF = 1.
'
IF FF=1 THEN LPRINT CHR$(12);
END SUB
'
'  This is a bios replacement for LPRINT.  It's useful when you're
' printing graphics data and there's some chance that a graphics data byte
' just might be 13.  (LPRINT seems to want to append an ascii 10 in that
' situation.)  Since the only good reason to use it as a replacement for
' LPRINT is when you're printing graphics data, BLPRINT will not append
' carriage return or line feed characters unless those characters are
' explicitly contained in string STRNG$.
'
SUB BLPRINT(STRNG$)
DIM I AS INTEGER,L AS INTEGER
L=LEN(STRNG$)
FOR I=1 TO L
INREGS.AX=ASC(MID$(STRNG$,I,1))
INREGS.DX=0
CALL INTERRUPTX(&H17,INREGS,OUTREGS)
NEXT I
END SUB
'
'  This routine (by Stumpff) parses an input string S$ into separate
' strings S1$ and S2$ based on the delimiting character DL$.
'
SUB PARSE(S$,DL$,S1$,S2$)
SI$=LTRIM$(RTRIM$(S$))
N=LEN(SI$)
S1$=SI$
S2$=""
IF N=0 THEN GOTO TERM
I=INSTR(SI$,DL$)
IF I=0 THEN GOTO TERM
S1$=RTRIM$(MID$(SI$,1,I-1))
S2$=LTRIM$(MID$(SI$,I+1,N-I))
TERM:
END SUB
'
'  This subroutine rotates NEC model coordinates about an axis by angle
' THETA (degrees).  (The interpretation of "X" and "Y" depends on how
' the subroutine is used.)
'
SUB COROT(X,Y,THETA)
XTEMP=X*COS(THETA*deg2rad)-Y*SIN(THETA*deg2rad)
Y=X*SIN(THETA*deg2rad)+Y*COS(THETA*deg2rad)
X=XTEMP
END SUB
'
'  This function can be used by QB/Qbasic programs to determine if a file
' (FILE$ in the parameter list) exists.  It returns an INTEGER 0 if the
' file doesn't exist, 1 if it does, 3 if the path-specification (if
' included in the file name) is invalid (which may for all intents and
' purposes be the same as the file not existing), and 2 if the function,
' for some reason, cannot determine whether or not the file exists.
'
'  Your MAIN routine must include the following DECLARE statement.
'
'   DECLARE FUNCTION EXIST%(FILE$)
'
DEFINT E
FUNCTION EXIST%(FILE$)
'
'  Alias input file name with F$ and make latter asciiz string.
'
F$=RTRIM$(LTRIM$(FILE$))+CHR$(0)
'
'  Set up machine code to open file for read-only access and call it.
'
DIM MCODE(1 TO 21) AS INTEGER,AX AS INTEGER,CF AS INTEGER,SM AS INTEGER
DIM OS AS INTEGER,OSC AS INTEGER
SM=VARSEG(F$) : OS=SADD(F$)
DEF SEG=VARSEG(MCODE(1))
OSC=VARPTR(MCODE(1))
POKE OSC,&H55                                         'PUSH BP
POKE OSC+1,&H89 : POKE OSC+2,&HE5                     'MOV BP,SP
POKE OSC+3,&HB8 : POKE OSC+4,0 : POKE OSC+5,&H3D      'MOV AX,3D00
POKE OSC+6,&HBB                                       'MOV BX,[SM]
POKE OSC+7,SM AND &HFF
POKE OSC+8,(SM AND &HFF00&)/256
POKE OSC+9,&H8E : POKE OSC+10,&HDB                    'MOV DS,BX
POKE OSC+11,&HBA                                      'MOV DX,[OS]
POKE OSC+12,OS AND &HFF
POKE OSC+13,(OS AND &HFF00&)/256
POKE OSC+14,&HCD : POKE OSC+15,&H21                   'INT 21
POKE OSC+16,&H89 : POKE OSC+17,&HC3                   'MOV BX,AX
POKE OSC+18,&H9F                                      'LAHF
POKE OSC+19,&H8B : POKE OSC+20,&H7E : POKE OSC+21,6   'MOV DI,[BP+6]
POKE OSC+22,&H89 : POKE OSC+23,&H1D                   'MOV [DI],BX
POKE OSC+24,&H8B : POKE OSC+25,&H7E : POKE OSC+26,8   'MOV DI,[BP+8]
POKE OSC+27,&H89 : POKE OSC+28,5                      'MOV [DI],AX
POKE OSC+29,&H5D                                      'POP BP
POKE OSC+30,&HCA : POKE OSC+31,4 : POKE OSC+32,0      'RETF 4
'
'  The following is to close the file (thus freeing the handle) if a file
' gets opened.
'
POKE OSC+33,&HB4 : POKE OSC+34,&H3E                   'MOV AH,3E
POKE OSC+35,&HBB : POKE OSC+36,0 : POKE OSC+37,0      'MOV BX,[HANDLE]
POKE OSC+38,&HCD : POKE OSC+39,&H21                   'INT 21
POKE OSC+40,&HCB                                      'RETF
CALL ABSOLUTE(CF,AX,OSC)
'
'  Get carry flag.  If it's zero, file exists.  If it's not zero,
' file either doesn't or interrupt call failed for some other reason.
'
CF=((CF AND &HFF00&)/256) AND 1%
IF CF=0 THEN
'
'  File exists.  Close it, set function value, and return.  (The values
' originally put at offsets 36 and 37 in the machine code were dummy.
' They're made real here, now that the file handle is known.)
'
POKE OSC+36,AX AND &HFF : POKE OSC+37,(AX AND &HFF00&)/256
CALL ABSOLUTE(OSC+33)
EX=1                         'Temporary function value
ELSE
'
'  Interrupt call couldn't find file.  Find out why (look at the value of
' AX returned).
'
IF AX=2 THEN
'
'  It apparently failed because file doesn't exist.  Set function value
' and return.
'
EX=0
ELSE
'
'  Interrupt call failed for some other reason.  Set function value to 2
' and return.  An exception is if the reason for failure is an invalid
' path-specification.  In that event, the file certainly doesn't exist.
' However, in that special case, set function value to 3 (which is the
' value of the error code in this case).
'
EX=2 : IF AX=3 THEN EX=AX
END IF
END IF
DEF SEG
EXIST=EX
END FUNCTION
DEFSNG E
'
'  This subroutine generates a PCX file (NECGEO.PCX) for the displayed NEC
' geometry.  (It assumes video mode 12 is in use; the MAIN routine doesn't
' call it if the mode is set to 9.  A bios call is used to read the screen
' pixel data instead of QB's POINT function so Stumpff could avoid having
' to figure out details of the WINDOW function.  Also, note that even
' though mode 12 is in use, this routine makes an 8-bit PCX file.)
'
SUB MAKEPCX(BOTTOM AS INTEGER)
'
'  If old NECGEO.PCX exists delete it.
'
IF EXIST("NECGEO.PCX")=1 THEN KILL "NECGEO.PCX"
'
'  Make various initializations.
'
DIM PLANES AS INTEGER,S AS STRING*1,BYTES AS LONG,I AS INTEGER,NFILE AS INTEGER
DIM HRES AS INTEGER,VRES AS INTEGER,W AS INTEGER,H AS INTEGER,COUNT AS LONG
DIM BPROW AS INTEGER,J AS INTEGER,SLAST AS STRING*1,BYTE AS INTEGER
DIM CODEBYTE AS STRING*1,SAVES AS STRING*1,LSAVES AS STRING*1
'
'  Make various initializations for creation of PCX header.
'
PLANES=1 : HRES=640 : VRES=480 : BPROW=521 : H=BOTTOM-10 : W=BPROW-1
'
'  Get number of bytes in image.
'
BYTES=CLNG(H+1)*CLNG(BPROW)
'
'  Open PCX file and output header.
'
NFILE=FREEFILE
OPEN "NECGEO.PCX" FOR BINARY AS #NFILE
S=CHR$(10)
PUT#NFILE,,S
S=CHR$(5)
PUT#NFILE,,S
S=CHR$(1)
PUT#NFILE,,S
S=CHR$(8)
PUT#NFILE,,S
S=CHR$(0)
FOR I=1 TO 4
PUT#NFILE,,S
NEXT I
PUT#NFILE,,W
PUT#NFILE,,H
PUT#NFILE,,HRES
PUT#NFILE,,VRES
'
'  Define 16-color palette.
'
FOR I=0 TO 15
FOR J=1 TO 3
S=CHR$(PALDATA(I,J))
PUT#NFILE,,S
NEXT J
NEXT I
S=CHR$(&H13)
PUT#NFILE,,S
S=CHR$(PLANES)
PUT#NFILE,,S
PUT#NFILE,,BPROW
S=CHR$(1)
PUT#NFILE,,S
S=CHR$(0)
FOR I=1 TO 59
PUT#NFILE,,S
NEXT I
'
'  PCX header is generated.  Transfer graphics data to PCX file.
'
'  Get visible page and leave it as stored in BH.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
INREGS.BX=OUTREGS.BX
INREGS.AX=&HD00
INREGS.CX=10
INREGS.DX=10
'
'  Input "starter byte."
'
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
SLAST=CHR$(OUTREGS.AX AND &HFF)
INREGS.CX=INREGS.CX+1
IF INREGS.CX>530 THEN INREGS.DX=INREGS.DX+1 : INREGS.CX=10
'
'  This is just for the unlikely event that BYTES = 1.
'
SAVES=CHR$(0) : LSAVES=SAVES
COUNT=1&
GETBYTE:
'
'  J stores the number of identical bytes to be repeated when PCX file is
' read by PCX viewer.
'
J=1
IF COUNT<BYTES THEN
'
'  Look for up to 63 identical graphics bytes and store them as two bytes,
' one giving a counter and the second giving the byte to be repeated.
'
FOR I=2 TO 63
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
S=CHR$(OUTREGS.AX AND &HFF)
INREGS.CX=INREGS.CX+1
IF INREGS.CX>530 THEN INREGS.DX=INREGS.DX+1 : INREGS.CX=10
COUNT=COUNT+1&
IF S=SLAST THEN J=I
IF S<>SLAST THEN EXIT FOR
IF COUNT=BYTES THEN EXIT FOR
NEXT I
END IF
'
'  CODEBYTE may store the above mentioned counter, or it may not be used
' at all.
'
CODEBYTE=CHR$(192+J)
BYTE=ASC(SLAST)
'
'  If there's only one identical image byte in the sequence, the code
' byte isn't needed unless the byte > 191.
'
IF BYTE>191 OR J>1 THEN PUT#NFILE,,CODEBYTE
PUT#NFILE,,SLAST
IF COUNT<BYTES THEN
'
'  If all 63 bytes input above are identical, a new starter byte is
' needed.
'
IF J=63 THEN
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
SLAST=CHR$(OUTREGS.AX AND &HFF)
INREGS.CX=INREGS.CX+1
IF INREGS.CX>530 THEN INREGS.DX=INREGS.DX+1 : INREGS.CX=10
COUNT=COUNT+1&
END IF
'
'  If all (less than 63) bytes input above aren't identical, starter byte
' is already available--it's the last byte read from the screen.
'
IF J<63 THEN SLAST=S
GOTO GETBYTE
END IF
'
'  COUNT must equal BYTES.  However, in that situation, if SAVES <>
' LSAVES, the last byte read from the screen didn't get output.  Fix that.
'
IF SAVES<>LSAVES THEN
CODEBYTE=CHR$(193)
BYTE=ASC(SAVES)
IF BYTE>191 THEN PUT#NFILE,,CODEBYTE
PUT#NFILE,,SAVES
END IF
'
'  Image data is in PCX file.  Process 256-color palette.  (Since mode 12
' is in effect, palette data past attribute 15 is dummied out.)
'
S=CHR$(12)
PUT#NFILE,,S
FOR I=0 TO 15
FOR J=1 TO 3
S=CHR$(PALDATA(I,J))
PUT#NFILE,,S
NEXT J
NEXT I
S=CHR$(0)
FOR I=16 TO 255
PUT#NFILE,,S
PUT#NFILE,,S
PUT#NFILE,,S
NEXT I
'
'  PCX file is generated; CLOSE it and quit.
'
CLOSE #NFILE
END SUB
'
'  This subroutine generates a BMP file (NEC#####.BMP, where ##### is a 5-
' digit string representing a number equal numerically to BMPNUM in the
' parameter list) for the displayed NEC geometry.  (It assumes video mode
' 12 is in use; the MAIN routine doesn't call it if the mode is set to 9.
' A bios call is used to read the screen pixel data instead of QB's POINT
' function so Stumpff could avoid having to figure out details of the
' WINDOW function.  Also, note that even though mode 12 is in use, this
' routine makes an 8-bit BMP file.  It does, however, generate a 24-bit
' palette for compatibility with Windows.)
'
SUB MAKEBMP(BOTTOM AS INTEGER,BMPNUM AS INTEGER)
DIM HLEN AS LONG,OFFS AS LONG,BITS AS INTEGER,PLANES AS INTEGER,J AS INTEGER
DIM ZPAD AS LONG,ATTR AS STRING*1,PALVAR(1 TO 3) AS STRING*1,W AS LONG,H AS LONG
DIM NBYTES AS LONG,LOFILE AS LONG,N AS INTEGER,BM AS STRING*2,I AS INTEGER
DIM ZERO AS STRING*1
'
'  Get width and height of image.
'
W=521& : H=BOTTOM-9
'
'  Define some static parameters.
'
OFFS=1078&
NBYTES=524&*H
LOFILE=NBYTES+OFFS
HLEN=40&
BITS=8
PLANES=1
ZPAD=0&
BM="BM"
ZERO=CHR$(0)
'
'  Open bmp file and generate header.
'
N=FREEFILE
BMPSTR$=LTRIM$(STR$(BMPNUM))
WHILE LEN(BMPSTR$)<5
BMPSTR$="0"+BMPSTR$
WEND
BFILE$="NEC"+BMPSTR$+".BMP"
OPEN BFILE$ FOR BINARY AS #N
PUT#N,,BM
PUT#N,,LOFILE
PUT#N,,ZPAD
PUT#N,,OFFS
PUT#N,,HLEN
PUT#N,,W
PUT#N,,H
PUT#N,,PLANES
PUT#N,,BITS
PUT#N,,ZPAD
PUT#N,,NBYTES
FOR I=1 TO 4
PUT#N,,ZPAD
NEXT I
'
'  Generate 24-bit palette using current palette data.  (Scale 6-bit
' RGB values to 8 bits.)
'
OUT &H3C7,0
FOR I=0 TO 15
'
'  BMP files store palette data in reverse order from the standard video
' palette.
'
FOR J=1 TO 3
PALVAR(J)=CHR$(CINT(255!*INP(&H3C9)/63!))
NEXT J
FOR J=3 TO 1 STEP -1
PUT#N,,PALVAR(J)
NEXT J
PUT#N,,ZERO
NEXT I
FOR I=1 TO 960
PUT#N,,ZERO
NEXT I
'
'  Get visible page and leave it as stored in BH.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
INREGS.BX=OUTREGS.BX
'
'  Get and write image data.  (BMP files store last row first.)
'
INREGS.AX=&HD00
FOR J=BOTTOM TO 10 STEP -1
FOR I=10 TO 530
INREGS.CX=I
INREGS.DX=J
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
ATTR=CHR$(OUTREGS.AX AND &HFF)
PUT#N,,ATTR
NEXT I
'
'  Pad scan line to 32-bit boundary.
'
FOR I=1 TO 3
PUT#N,,ZERO
NEXT I
NEXT J
CLOSE #N
END SUB
'
'  This function inputs a string representing a binary number and converts
' it to a decimal number.
'
FUNCTION DEC&(B AS STRING)
DIM V AS LONG,N AS INTEGER,I AS INTEGER
N=LEN(B)
V=0
FOR I=1 TO N
V=V+2&^(I-1)*VAL(MID$(B,N-I+1,1))
NEXT I
DEC=V
END FUNCTION
'
'  This subroutine changes all occurrences of "," in STRNG$ to a space.
'
SUB COM2SPC(STRNG$)
DIM L AS INTEGER,I AS INTEGER
L=LEN(STRNG$)
IF L>0 THEN
FOR I=1 TO L
C$=MID$(STRNG$,I,1)
IF C$="," THEN C$=" "
MID$(STRNG$,I,1)=C$
NEXT I
END IF
END SUB
'
'  This function puts a space-delimited GW line in standard NEC format.
' It will terminate the program if a field is longer than the allowed 3,
' 5, or 10 characters.
'
FUNCTION FIXGW$(STRNG$)
DIM L AS INTEGER
L=LEN(STRNG$)
NUMB$=MID$(STRNG$,3,L-2)
CALL PARSE(NUMB$," ",ITGSTR$,S1$)
WHILE LEN(ITGSTR$)<3
ITGSTR$=" "+ITGSTR$
WEND
IF LEN(ITGSTR$)>3 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ITG parameter on GW card longer than 3 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",NSSTR$,S2$)
WHILE LEN(NSSTR$)<5
NSSTR$=" "+NSSTR$
WEND
IF LEN(NSSTR$)>5 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "NS parameter on GW card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",X1STR$,S1$)
WHILE LEN(X1STR$)<10
X1STR$=" "+X1STR$
WEND
IF LEN(X1STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "XW1 parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",Y1STR$,S2$)
WHILE LEN(Y1STR$)<10
Y1STR$=" "+Y1STR$
WEND
IF LEN(Y1STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "YW1 parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",Z1STR$,S1$)
WHILE LEN(Z1STR$)<10
Z1STR$=" "+Z1STR$
WEND
IF LEN(Z1STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ZW1 parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",X2STR$,S2$)
WHILE LEN(X2STR$)<10
X2STR$=" "+X2STR$
WEND
IF LEN(X2STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "XW2 parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",Y2STR$,S1$)
WHILE LEN(Y2STR$)<10
Y2STR$=" "+Y2STR$
WEND
IF LEN(Y2STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "YW2 parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",Z2STR$,S2$)
WHILE LEN(Z2STR$)<10
Z2STR$=" "+Z2STR$
WEND
IF LEN(Z2STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ZW2 parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",RADSTR$,S1$)
WHILE LEN(RADSTR$)<10
RADSTR$=" "+RADSTR$
WEND
IF LEN(RADSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "RAD parameter on GW card longer than 10 characters."
PRINT
STOP
END IF
FIXGW$="GW"+ITGSTR$+NSSTR$+X1STR$+Y1STR$+Z1STR$+X2STR$+Y2STR$+Z2STR$+RADSTR$
END FUNCTION
'
'  This function puts a space-delimited GA line in standard NEC format.
' It will terminate the program if a field is longer than the allowed 3,
' 5, or 10 characters.
'
FUNCTION FIXGA$(STRNG$)
DIM L AS INTEGER
L=LEN(STRNG$)
NUMB$=MID$(STRNG$,3,L-2)
CALL PARSE(NUMB$," ",ITGSTR$,S1$)
WHILE LEN(ITGSTR$)<3
ITGSTR$=" "+ITGSTR$
WEND
IF LEN(ITGSTR$)>3 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ITG parameter on GA card longer than 3 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",NSSTR$,S2$)
WHILE LEN(NSSTR$)<5
NSSTR$=" "+NSSTR$
WEND
IF LEN(NSSTR$)>5 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "NS parameter on GA card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",RADASTR$,S1$)
WHILE LEN(RADASTR$)<10
RADASTR$=" "+RADASTR$
WEND
IF LEN(RADASTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "RADA parameter on GA card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",ANG1STR$,S2$)
WHILE LEN(ANG1STR$)<10
ANG1STR$=" "+ANG1STR$
WEND
IF LEN(ANG1STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ANG1 parameter on GA card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",ANG2STR$,S1$)
WHILE LEN(ANG2STR$)<10
ANG2STR$=" "+ANG2STR$
WEND
IF LEN(ANG2STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ANG2 parameter on GA card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",RADSTR$,S2$)
WHILE LEN(RADSTR$)<10
RADSTR$=" "+RADSTR$
WEND
IF LEN(RADSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "RAD parameter on GA card longer than 10 characters."
PRINT
STOP
END IF
FIXGA$="GA"+ITGSTR$+NSSTR$+RADASTR$+ANG1STR$+ANG2STR$+RADSTR$
END FUNCTION
'
'  This function puts a space-delimited GH line in standard NEC format.
' It will terminate the program if a field is longer than the allowed 3,
' 5, or 10 characters.
'
FUNCTION FIXGH$(STRNG$)
DIM L AS INTEGER
L=LEN(STRNG$)
NUMB$=MID$(STRNG$,3,L-2)
CALL PARSE(NUMB$," ",ITGSTR$,S1$)
WHILE LEN(ITGSTR$)<3
ITGSTR$=" "+ITGSTR$
WEND
IF LEN(ITGSTR$)>3 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ITG parameter on GH card longer than 3 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",NSSTR$,S2$)
WHILE LEN(NSSTR$)<5
NSSTR$=" "+NSSTR$
WEND
IF LEN(NSSTR$)>5 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "NS parameter on GH card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",SSTR$,S1$)
WHILE LEN(SSTR$)<10
SSTR$=" "+SSTR$
WEND
IF LEN(SSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "S parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",HLSTR$,S2$)
WHILE LEN(HLSTR$)<10
HLSTR$=" "+HLSTR$
WEND
IF LEN(HLSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "HL parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",A1STR$,S1$)
WHILE LEN(A1STR$)<10
A1STR$=" "+A1STR$
WEND
IF LEN(A1STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "A1 parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",B1STR$,S2$)
WHILE LEN(B1STR$)<10
B1STR$=" "+B1STR$
WEND
IF LEN(B1STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "B1 parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",A2STR$,S1$)
WHILE LEN(A2STR$)<10
A2STR$=" "+A2STR$
WEND
IF LEN(A2STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "A2 parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",B2STR$,S2$)
WHILE LEN(B2STR$)<10
B2STR$=" "+B2STR$
WEND
IF LEN(B2STR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "B2 parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",RADSTR$,S1$)
WHILE LEN(RADSTR$)<10
RADSTR$=" "+RADSTR$
WEND
IF LEN(RADSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "RAD parameter on GH card longer than 10 characters."
PRINT
STOP
END IF
FIXGH$="GH"+ITGSTR$+NSSTR$+SSTR$+HLSTR$+A1STR$+B1STR$+A2STR$+B2STR$+RADSTR$
END FUNCTION
'
'  This function puts a space-delimited GX or GR line in standard NEC
' format.  It will terminate the program if a field is longer than the
' allowed 3 or 5 characters.
'
FUNCTION FIXGXR$(STRNG$)
DIM L AS INTEGER
L=LEN(STRNG$)
L2$=LEFT$(STRNG$,2)
NUMB$=MID$(STRNG$,3,L-2)
CALL PARSE(NUMB$," ",I1STR$,S1$)
WHILE LEN(I1STR$)<3
I1STR$=" "+I1STR$
WEND
IF LEN(I1STR$)>3 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "I1 parameter on ";L2$;" card longer than 3 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",I2STR$,S2$)
WHILE LEN(I2STR$)<5
I2STR$=" "+I2STR$
WEND
IF LEN(I2STR$)>5 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "I2 parameter on ";L2$;" card longer than 5 characters."
PRINT
STOP
END IF
FIXGXR$=L2$+I1STR$+I2STR$
END FUNCTION
'
'  This function puts a space-delimited GM line in standard NEC format.
' It will terminate the program if a field is longer than the allowed 3,
' 5, or 10 characters.
'
FUNCTION FIXGM$(STRNG$)
DIM L AS INTEGER
L=LEN(STRNG$)
NUMB$=MID$(STRNG$,3,L-2)
CALL PARSE(NUMB$," ",ITGISTR$,S1$)
WHILE LEN(ITGISTR$)<3
ITGISTR$=" "+ITGISTR$
WEND
IF LEN(ITGISTR$)>3 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ITGI parameter on GM card longer than 3 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",NRPTSTR$,S2$)
WHILE LEN(NRPTSTR$)<5
NRPTSTR$=" "+NRPTSTR$
WEND
IF LEN(NRPTSTR$)>5 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "NRPT parameter on GM card longer than 5 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",ROXSTR$,S1$)
WHILE LEN(ROXSTR$)<10
ROXSTR$=" "+ROXSTR$
WEND
IF LEN(ROXSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ROX parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",ROYSTR$,S2$)
WHILE LEN(ROYSTR$)<10
ROYSTR$=" "+ROYSTR$
WEND
IF LEN(ROYSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ROY parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",ROZSTR$,S1$)
WHILE LEN(ROZSTR$)<10
ROZSTR$=" "+ROZSTR$
WEND
IF LEN(ROZSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ROZ parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",XSSTR$,S2$)
WHILE LEN(XSSTR$)<10
XSSTR$=" "+XSSTR$
WEND
IF LEN(XSSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "XS parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",YSSTR$,S1$)
WHILE LEN(YSSTR$)<10
YSSTR$=" "+YSSTR$
WEND
IF LEN(YSSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "YS parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",ZSSTR$,S2$)
WHILE LEN(ZSSTR$)<10
ZSSTR$=" "+ZSSTR$
WEND
IF LEN(ZSSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "ZS parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",ITSSTR$,S1$)
WHILE LEN(ITSSTR$)<10
ITSSTR$=" "+ITSSTR$
WEND
IF LEN(ITSSTR$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "F7 parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
F8$="" : F9$="" : F10$=""
IF S1$<>"" THEN
'
'  Look for NEC4 fields.
'
CALL PARSE(S1$," ",F8$,S2$)
WHILE LEN(F8$)<10
F8$=" "+F8$
WEND
IF LEN(F8$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "F8 parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S2$," ",F9$,S1$)
WHILE LEN(F9$)<10
F9$=" "+F9$
WEND
IF LEN(F9$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "F9 parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
CALL PARSE(S1$," ",F10$,S2$)
WHILE LEN(F10$)<10
F10$=" "+F10$
WEND
IF LEN(F10$)>10 THEN
CLOSE #1
SCREEN 0
WIDTH 80
PRINT
PRINT "F10 parameter on GM card longer than 10 characters."
PRINT
STOP
END IF
END IF
TEMP$="GM"+ITGISTR$+NRPTSTR$+ROXSTR$+ROYSTR$+ROZSTR$+XSSTR$+YSSTR$+ZSSTR$
FIXGM$=TEMP$+ITSSTR$+F8$+F9$+F10$
END FUNCTION
