#ifndef NEC_H
#define NEC_H

//------------------------------------------------------------------------------
// Copyright (c), 1997 Ralph Holland
// History:
// 000: 26 Apr 97, RBH - Initial Writing
// Description:
// Contains definitions just for nec.cpp
//------------------------------------------------------------------------------

#include <map>
using std::map;
#include <vector>
using std::vector;

#include <strstrea.h>
#include "Stand.h"
//#include "File.h"           // file processing
#include "machdep.h"		// machine dependent files


// Use the std::features for these - why should I write them?
typedef map<int,int>	TagMap;
typedef vector<Numeric> AFrequency;

// The Nec Class
class Nec {
public:

	Nec(int argc,char *argv[]);

private:

	Nec() {}				    // hide the default constructor
	Nec(Nec &) {}			    // hide the copy constructor
	operator = (Nec &) {}		// hide the assignment operator

private:

	// local model data
	// C++ joke and trusim: "only friends (and self) can touch private parts"

	// the types of ground in nec2d
    enum KGround				// found in GN card
	{ FreeSpace=-1				
	, Perfect=0
	, Finite=1
	, SommerfeldGround=2
	};
	
	// the input cards that are processed, including Non (don't care)
	enum KLine 
	{ Non						// Nothing identified
	, FR						// Frequency card
	, GA						// Arc
	, GH						// Helix
	, GN						// End Geometry card
	, GR						// Rotate
	, GW						// Wire
	, GX						// Reflection
	, SM						// Multiple surface patches
	, SP						// Surface patch
	};

	// member variables
	bool		forEffect;		// set when nec2d is not to be executed
    Numeric		epsilon;        // relative dielectric constant of first ground
    Numeric		sigma;	        // relative dielectric constant of second ground
    size_t		cSegment;		// number of segments in geometetry
	size_t		cSegmentOverride; // set by the -snn or -Snn option
    KGround		kGround;		// type of ground in the model
	
	string		inputPath;		// input file
	string		outputPath;		// output file
	string		configPath;		// configuration file
	string		somnecExec;		// name of somnec executable
	string		somnecPath;		// pathname for SOMNECDATA database

   	// Used to invoke the somnec2d interpolation grid generator for Sommerfeld ground
    void		sommerfeld(const char * sommerfeldExec, Numeric frequecmcy); // Execute SOMMERFELD for each frequency

    // Used to Shell to nec2d variant
	void		shell(const char *execName);

	// Sum the number of segments
	void		totalSegment(size_t &segments,size_t &patches);

	TagMap		tagMap;
	int			patch;
	AFrequency  aFrequency;

	// return the type of card
	static KLine lineKind(const char *line);

	// strip a token from a string
	static string stripToken(string &line,size_t width);

	// the usage procedure
	static void usage(const char *name);

	void insertTag(int tag,int count);

};


#endif // NEC_D