#ifndef MACHDEP_H
#define MACHDEP_H

//------------------------------------------------------------------------------
// Copyright (c), 1997 Ralph Holland
// History:
// 000: 14 Apr 2001, Ralph B. Holland - Initial Writing
// Description:
// Contains machine dependent definitions and declarations
// This is by far the messiest header file!
//------------------------------------------------------------------------------

// Do some funny stuff to work out what platform we are on
#define PLATOFMR_DOS	1
#define PLATFORM_WIN	2
#define PALTFORM_UNIX	4

#if defined(WIN32)
#  define PLATFORM PLATFORM_WIN
#elif defined(__WIN31__)
#  define PLATFORM PLATFORM_WIN
#elif defined(__LINUX__)
#  define PLATFORM PLATFORM_UNIX
#elif defined(__UNIX__)
#  define PLATFORM PLATFORM_UNIX
// add your elif other platforms here if required
#else
#  define PLATFORM PLATFORM_DOS
#endif


// common definitions used in nec.cpp for portability
// reasons.
#define NEC2_IN         "nec2.in"
#define SOMNEC_IN       "som2d.in"
#define SOMNEC_OUT      "SOM2D.NEC"

// Now platform dependent definitions
#if PLATFORM==PLATFORM_WIN || PLATFORM==PLATFORM_DOS
    // Windows - leave these alone - they work for IBM compatibles
#  define NEC_SHELL       "nec2d.bat"
#  define SOMNEC_SHELL    "som2d.bat"
#  define TREE_DELIMITER  '\\'
#else
    // Assume Unix file separator and naming conventions - you may 
	// adjust these if required
#  define NEC_SHELL       "nec2d.sh"
#  define SOMNEC_SHELL    "som2d.sh"
#  define TREE_DELIMITER  '/'
#endif

// This is here to implement File related stuff
#include <io.h>
#include <direct.h>

// Declare missing functions for non WIN platforms
#if PLATFORM != PLATFORM_WIN
bool CopyFile(const char *fromPath,const char *toPath, bool failIfExists);
bool DeleteFile(const char *path);
#else
#  include <windows.h>
#endif // PLATFORM_WIN


// MakeDir supplied here to mimic Borland mkdir which
// makes sure that all directories in the path exist, 
// Microsoft mkdir() does not, nor I think does linux or Unix.
void MakeDir( const char *path );

// inline this because access is available on all platforms
inline bool Exists(const char *pathName) {
	return ::access(pathName,0x00)==0;
}


#endif // MACHDEP_H