'
'  This subroutine opens an already existing file (FILE$) for reading or
' writing (FOPT = 0), opens a new file for writing (FOPT = 1), or opens
' an already existing file for reading only (FOPT = 2).  If FOPT = 1 and
' the file already exists, it is truncated to zero length, thus making it
' a new file.  The routine returns the file handle as HANDLE.  If HANDLE
' is returned as zero, that is an indication that the open operation was
' not successful.  Otherwise, HANDLE should be used with the routines to
' write/read the file, position/read the file pointer, close it, get its
' length, or change/read its date or time (FWRITE/FREAD, FPOINT/FSEEK,
' FCLOSE, FLOF, and DATETIME, respectively).  If FOPT = 0 or 1, this
' routine will not work with an already existing file if that file has the
' read-only attribute set.
'
'  This routine requires the FIO.INC include file.  Also, do not try to
' read a file longer than 2 GB or generate such a file opened with this
' routine.
'
SUB FOPEN(FILE$,HANDLE AS INTEGER,FOPT AS INTEGER)
DIM OS AS INTEGER,CF AS INTEGER,SMT AS INTEGER,OST AS INTEGER,DX AS INTEGER
'
'  Alias FILE$ with F$, make it an ASCIIZ string, and get its position in
' memory.
'
F$=LTRIM$(RTRIM$(FILE$))+CHR$(0)
SMT=VARSEG(F$) : OST=SADD(F$)
'
'  Update machine code.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
POKE OS+14,SMT AND &HFF : POKE OS+15,(SMT AND &HFF00&)/256
POKE OS+19,OST AND &HFF : POKE OS+20,(OST AND &HFF00&)/256
IF FOPT=0 OR FOPT=2 THEN
POKE OS+5,2-FOPT : POKE OS+6,&H3D
ELSE
POKE OS+6,&H3C
POKE OS+11,0 : POKE OS+12,0
END IF
'
'  Open file.
'
CALL ABSOLUTE(CF,HANDLE,DX,OS)
DEF SEG
'
'  Look at carry flag and make sure everything worked okay.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
HANDLE=0
PRINT
PRINT "Error; file ";FILE$;" not opened."
PRINT
END IF
END SUB
'
'  This subroutine closes a file with handle HANDLE.  It requires the
' FIO.INC include file.
'
SUB FCLOSE(HANDLE AS INTEGER)
DIM OS AS INTEGER,CF AS INTEGER,BX AS INTEGER,DX AS INTEGER
'
'  Update machine code.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
'
'  Update machine code and close file.
'
POKE OS+6,&H3E
POKE OS+8,HANDLE AND &HFF : POKE OS+9,(HANDLE AND &HFF00&)/256
CALL ABSOLUTE(CF,BX,DX,OS)
DEF SEG
'
'  Get and test carry flag.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
PRINT
PRINT "Error; file with handle ";LTRIM$(STR$(HANDLE));" not closed."
PRINT
END IF
END SUB
'
'  This routine writes BYTES bytes (a LONG variable) to the file specified
' by a file handle HANDLE.  SMBUF is the memory segment of the buffer
' storing the data to be written and OSBUF is the memory offset.
'
'  This routine requires the FIO.INC include file and will not write more
' than 65,535 bytes at one time.
'
SUB FWRITE(HANDLE AS INTEGER,BYTES AS LONG,SMBUF AS INTEGER,OSBUF AS INTEGER)
DIM CF AS INTEGER,BX AS INTEGER,OS AS INTEGER,DX AS INTEGER
'
'  Update machine code and write BYTES bytes.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
POKE OS+6,&H40
POKE OS+8,HANDLE AND &HFF : POKE OS+9,(HANDLE AND &HFF00&)/256
POKE OS+11,BYTES AND &HFF& : POKE OS+12,(BYTES AND &HFF00&)/256
POKE OS+14,SMBUF AND &HFF : POKE OS+15,(SMBUF AND &HFF00&)/256
POKE OS+19,OSBUF AND &HFF : POKE OS+20,(OSBUF AND &HFF00&)/256
CALL ABSOLUTE(CF,BX,DX,OS)
DEF SEG
'
'  Get and test carry flag.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
PRINT
PRINT "Error writing file."
PRINT
CALL FCLOSE(HANDLE)
STOP
END IF
END SUB
'
'  This routine reads BYTES bytes (a LONG variable) from the file
' specified by a file handle HANDLE.  SMBUF is the memory segment of where
' the data read will be placed and OSBUF is the memory offset.
'
'  This routine requires the FIO.INC include file and will not read more
' than 65,535 bytes at one time.
'
SUB FREAD(HANDLE AS INTEGER,BYTES AS LONG,SMBUF AS INTEGER,OSBUF AS INTEGER)
DIM CF AS INTEGER,BX AS INTEGER,OS AS INTEGER,DX AS INTEGER
'
'  Update machine code and read BYTES bytes.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
POKE OS+6,&H3F
POKE OS+8,HANDLE AND &HFF : POKE OS+9,(HANDLE AND &HFF00&)/256
POKE OS+11,BYTES AND &HFF& : POKE OS+12,(BYTES AND &HFF00&)/256
POKE OS+14,SMBUF AND &HFF : POKE OS+15,(SMBUF AND &HFF00&)/256
POKE OS+19,OSBUF AND &HFF : POKE OS+20,(OSBUF AND &HFF00&)/256
CALL ABSOLUTE(CF,BX,DX,OS)
DEF SEG
'
'  Get and test carry flag.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
PRINT
PRINT "Error reading file."
PRINT
CALL FCLOSE(HANDLE)
STOP
END IF
END SUB
'
'  This routine moves the file pointer of a file with handle HANDLE to
' FLOC, a zero-based byte offset from the beginning of the file.  (It is a
' LONG integer.)
'
'  This routine requires the FIO.INC include file and does not restrict
' FLOC to be less than 65,536.
'
'  FLOCNEW is a LONG integer giving the offset the pointer was actually
' moved to.  You can have your calling routine test it against FLOC to
' make sure you didn't accidentally set the pointer to after the end of
' the file, for example.  (If FLOCNEW is returned as zero, and FLOC wasn't
' zero, the indication is that the pointer move operation failed for some
' reason--you should also see an error message to that effect.)
'
'  (The primary use for this routine is to position the file pointer in
' preparation for using FWRITE or FREAD.  Note that, if you are writing or
' reading the file sequentially from the beginning, you do not need this
' subroutine.  The DOS calls used by FWRITE and FREAD automatically
' position the file pointer to the byte after the last byte written/read.)
'
SUB FPOINT(HANDLE AS INTEGER,FLOC AS LONG,FLOCNEW AS LONG)
DIM CF AS INTEGER,BX AS INTEGER,OS AS INTEGER,MSIG AS LONG,LSIG AS LONG
DIM DX AS INTEGER,AXLONG AS LONG,DXLONG AS LONG
'
'  Update machine code and move pointer.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
POKE OS+5,0 : POKE OS+6,&H42
POKE OS+8,HANDLE AND &HFF : POKE OS+9,(HANDLE AND &HFF00&)/256
'
'  The CX and DX registers are used slightly differently here than what's
' indicated in FIO.INC.
'
'  Put most significant part of FLOC in CX.
'
MSIG=(FLOC AND &HFFFF0000&)/65536&
POKE OS+11,MSIG AND &HFF& : POKE OS+12,(MSIG AND &HFF00&)/256
'
'  Put least significant part of FLOC in DX.
'
LSIG=(FLOC AND &HFFFF&)
POKE OS+19,LSIG AND &HFF& : POKE OS+20,(LSIG AND &HFF00&)/256
CALL ABSOLUTE(CF,BX,DX,OS)
DEF SEG
'
'  Get and test carry flag.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
PRINT
PRINT "Error moving file pointer."
PRINT
'
'  Rather than stop execution, just set FLOCNEW to zero.
'
FLOCNEW=0&
ELSE
'
'  Pointer move was successful.  Get offset it was actually moved to so
' calling routine can test it against requested point.  (The value of AX
' returned from the interrupt call is actually returned to ABSOLUTE as
' BX.)
'
AXLONG=BX AND &HFFFF&
DXLONG=DX AND &HFFFF&
FLOCNEW=AXLONG+65536&*DXLONG
END IF
END SUB
'
'  This subroutine is a replacement for QB's BSAVE function.  It saves
' data in a manner that as closely as possible emulates QB's BSAVE funct-
' ion.  It, however, allows the number of bytes saved to be up to 2 GB
' instead of BSAVE's 65,535-byte limit.  The first three bytes in the file
' will be the same as in a conventional BSAVEd file.  (First byte = FDh,
' second two bytes specify the segment the data was saved from.)  The
' fourth byte will be zero.  The fifth byte will be the high byte of the
' number of bytes following the 7-byte header.  The sixth and seventh
' bytes will be the lowest two bytes.  Thus, if there is less than 65,536
' bytes of data saved, the file should work with a conventional BLOAD
' function.  (However, you MUST specify the memory offset with BLOAD; the
' format used here will totally destroy BLOAD's default use of bytes 4 and
' 5 as a memory offset.  For larger files, use BBLOAD, the complement to
' this routine.)
'
'  In the parameter list, FILE$ is the file name to save the data to,
' SM is the memory segment storing the data to be BBSAVEd (an INTEGER
' variable), OS is the memory offset (an INTEGER variable) and BYTES is
' the number of BYTES to save (a LONG variable).
'
'  This routine still needs FIO.INC, however, you do not need to call
' FOPEN beforehand (or FCLOSE afterwards).
'
SUB BBSAVE(FILE$,SM AS INTEGER,OS AS INTEGER,BYTES AS LONG)
DIM HANDLE AS INTEGER,NBLOCK AS INTEGER,EXCESS AS LONG,LOWBYTES AS INTEGER
DIM I AS INTEGER,SM1 AS LONG
'
'  Alias SM with SM1.
'
SM1=SM
'
'  Open file.
'
CALL FOPEN(FILE$,HANDLE,1)
'
'  If file opened okay, proceed.
'
IF HANDLE>0 THEN
'
'  Write header.
'
H$=CHR$(&HFD)
CALL FWRITE(HANDLE,1&,VARSEG(H$),SADD(H$))
CALL FWRITE(HANDLE,2&,VARSEG(SM),VARPTR(SM))
H$=CHR$(0)
CALL FWRITE(HANDLE,1&,VARSEG(H$),SADD(H$))
H$=CHR$((BYTES AND &HFF0000&)/65536&)
CALL FWRITE(HANDLE,1&,VARSEG(H$),SADD(H$))
LOWBYTES=BYTES AND &HFFFF&
CALL FWRITE(HANDLE,2&,VARSEG(LOWBYTES),VARPTR(LOWBYTES))
'
'  Header's written.  Get number of complete 65,520-byte blocks of data in
' BYTES.  (File-write routine can't write more than 65,535 bytes at a
' time, but that value isn't an integral number of memory segments.)
'
NBLOCK=INT(CDBL(BYTES)/65520&+.001)
'
'  Get remainder.
'
EXCESS=BYTES MOD 65520&
'
'  Write NBLOCK of data and then write EXCESS.
'
IF NBLOCK>0 THEN
FOR I=1 TO NBLOCK
CALL FWRITE(HANDLE,65520&,CINT(SM1),OS)
'
'  Update segment to write data from and make sure it fits in a 2-byte
' integer space.
'
SM1=SM1+4095& : IF SM1>32767& THEN SM1=SM1-65536&
NEXT I
END IF
IF EXCESS>0& THEN CALL FWRITE(HANDLE,EXCESS,CINT(SM1),OS)
'
'  Close file.
'
CALL FCLOSE(HANDLE)
END IF
END SUB
'
'  This subroutine is the complement to BBSAVE; it is a replacement for
' QB's BLOAD function for large files.  (See BBSAVE for more information.
' SM and OS now specify where the BBLOADed data goes to in memory.)
' If you wish to use this routine with files generated using QB's standard
' BSAVE statement, they must have been generated by saving from a memory
' block starting at a segment boundary (zero memory offset), e.g., from a
' dynamic array or perhaps the video buffer.
'
'  This routine still needs FIO.INC, however, you do not need to call
' FOPEN beforehand (or FCLOSE afterwards).
'
SUB BBLOAD(FILE$,SM AS INTEGER,OS AS INTEGER)
DIM HANDLE AS INTEGER,NBLOCK AS INTEGER,EXCESS AS LONG,LOWBYTES AS INTEGER
DIM I AS INTEGER,SM1 AS LONG,HIGHBYTE AS LONG,FLOCNEW AS LONG,BYTES AS LONG
'
'  Alias SM with SM1.
'
SM1=SM
'
'  Open file for reading.
'
CALL FOPEN(FILE$,HANDLE,2)
'
'  If file opened okay, proceed.
'
IF HANDLE>0 THEN
'
'  Get file size information.
'
CALL FPOINT(HANDLE,4&,FLOCNEW)
'
'  Make sure file pointer got set right.
'
IF FLOCNEW=4& THEN
H$=" "
CALL FREAD(HANDLE,1&,VARSEG(H$),SADD(H$))
HIGHBYTE=ASC(H$)
LOWBYTES=0
CALL FREAD(HANDLE,2&,VARSEG(LOWBYTES),VARPTR(LOWBYTES))
BYTES=HIGHBYTE*65536&+(LOWBYTES AND &HFFFF&)
'
'  Get number of complete 65,520-byte blocks of data in BYTES.
'
NBLOCK=INT(CDBL(BYTES)/65520&+.001)
'
'  Get remainder.
'
EXCESS=BYTES MOD 65520&
'
'  Read NBLOCK of data and then read EXCESS.
'
IF NBLOCK>0 THEN
FOR I=1 TO NBLOCK
CALL FREAD(HANDLE,65520&,CINT(SM1),OS)
'
'  Update segment to write data to and make sure it fits in a 2-byte
' integer space.
'
SM1=SM1+4095& : IF SM1>32767& THEN SM1=SM1-65536&
NEXT I
END IF
IF EXCESS>0& THEN CALL FREAD(HANDLE,EXCESS,CINT(SM1),OS)
END IF
'
'  Close file.
'
CALL FCLOSE(HANDLE)
END IF
END SUB
'
'  This function returns the length of a file with handle HANDLE--the
' analog of QB's LOF function.  (It's basically subroutine FPOINT slightly
' reworked.)
'
'  This routine requires the FIO.INC include file.
'
FUNCTION FLOF&(HANDLE AS INTEGER)
DIM CF AS INTEGER,BX AS INTEGER,OS AS INTEGER,DX AS INTEGER,AXLONG AS LONG
DIM DXLONG AS LONG,FLOC AS LONG,FLOCNEW AS LONG
'
'  Get current position of file pointer so it can be restored later.
'
FLOC=FSEEK(HANDLE)
'
'  Update machine code and move pointer to end of file.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
POKE OS+5,2 : POKE OS+6,&H42
POKE OS+8,HANDLE AND &HFF : POKE OS+9,(HANDLE AND &HFF00&)/256
POKE OS+11,0 : POKE OS+12,0
POKE OS+19,0 : POKE OS+20,0
CALL ABSOLUTE(CF,BX,DX,OS)
DEF SEG
'
'  Get and test carry flag.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
PRINT
PRINT "Can't get file size."
CALL FCLOSE(HANDLE)
STOP
ELSE
'
'  Pointer move was successful.  Get offset it was actually moved to (the
' file size).  (The value of AX returned from the interrupt call is
' actually returned to ABSOLUTE as BX.)
'
AXLONG=BX AND &HFFFF&
DXLONG=DX AND &HFFFF&
FLOF=AXLONG+65536&*DXLONG
'
'  Reposition file pointer.
'
CALL FPOINT(HANDLE,FLOC,FLOCNEW)
END IF
END FUNCTION
'
'  This function returns the current file pointer position for the file
' with handle HANDLE--the analog of QB's SEEK function.  (It's basically
' function FLOF slightly reworked.)
'
'  This routine requires the FIO.INC include file.
'
FUNCTION FSEEK&(HANDLE AS INTEGER)
DIM CF AS INTEGER,BX AS INTEGER,OS AS INTEGER,DX AS INTEGER,AXLONG AS LONG
DIM DXLONG AS LONG
'
'  Update machine code and move pointer to where it's at.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))
POKE OS+5,1 : POKE OS+6,&H42
POKE OS+8,HANDLE AND &HFF : POKE OS+9,(HANDLE AND &HFF00&)/256
POKE OS+11,0 : POKE OS+12,0
POKE OS+19,0 : POKE OS+20,0
CALL ABSOLUTE(CF,BX,DX,OS)
DEF SEG
'
'  Get and test carry flag.
'
CF=(CF AND &HFF00&)/256 AND 1%
IF CF<>0 THEN
PRINT
PRINT "Can't get file pointer location."
CALL FCLOSE(HANDLE)
STOP
ELSE
'
'  Pointer "move" was successful.  Get offset it was actually "moved" to
' (the file pointer location).  (The value of AX returned from the
' interrupt call is actually returned to ABSOLUTE as BX.)
'
AXLONG=BX AND &HFFFF&
DXLONG=DX AND &HFFFF&
FSEEK=AXLONG+65536&*DXLONG
END IF
END FUNCTION
'
'  Depending on the input one-byte string GETSET$, this routine either
' returns the time (FTIME$) and date (FDATE$) of an open file with handle
' HANDLE or sets the file time and date to the values specified by those
' variables as inputs.  FTIME$ and FDATE$ are 8-byte strings.  If you're
' setting the time and date, they must be input as such, e.g., January 8,
' 2003 is the string "01:08:03" and 2:20 and 5 seconds P.M. is "14:20:05".
' (Note the use of 24-hour time.)  GETSET$ is input as "S" if you want to
' set the time and date and anything but "S" (e.g., "G") if you want to
' get the date and time (i.e., without changing either).
'
'  CF is an output return code.  If it's anything but zero, the routine
' didn't work.
'
'  This routine needs the include file FIO.INC.
'
SUB DATETIME(HANDLE AS INTEGER,FTIME$,FDATE$,GETSET$,CF AS INTEGER)
DIM OS AS INTEGER,CX AS INTEGER,DX AS INTEGER,DXLONG AS LONG,CXLONG AS LONG
DIM YEAR AS INTEGER,MONTH AS INTEGER,DAY AS INTEGER,HOUR AS INTEGER
DIM MINUTE AS INTEGER,SECOND AS INTEGER
'
'  Update machine code for date/time reading or setting.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))+46
POKE OS+7,HANDLE AND &HFF : POKE OS+8,(HANDLE AND &HFF00&)/256
IF UCASE$(GETSET$)<>"S" THEN
POKE OS+4,0
CALL ABSOLUTE(CF,CX,DX,OS)
CF=INT(CF AND &HFF00&)/256 AND 1%
IF CF=0 THEN
HOUR=(CX AND 63488&)/2048 : MINUTE=(CX AND 2016)/32 : SECOND=(CX AND 31)*2
H$=LTRIM$(STR$(HOUR)) : IF HOUR<10 THEN H$="0"+H$
M$=LTRIM$(STR$(MINUTE)) : IF MINUTE<10  THEN M$="0"+M$
S$=LTRIM$(STR$(SECOND)) : IF SECOND<10 THEN S$="0"+S$
FTIME$=H$+":"+M$+":"+S$
YEAR=(DX AND 65024&)/512-20 : MONTH=(DX AND 480)/32 : DAY=DX AND 31
Y$=LTRIM$(STR$(YEAR)) : IF YEAR<9 THEN Y$="0"+Y$
M$=LTRIM$(STR$(MONTH)) : IF MONTH<10 THEN M$="0"+M$
D$=LTRIM$(STR$(DAY)) : IF DAY<10 THEN D$="0"+D$
FDATE$=M$+":"+D$+":"+Y$
END IF
ELSE
POKE OS+4,1
HOUR=VAL(LEFT$(FTIME$,2)) : MINUTE=VAL(MID$(FTIME$,4,2))
SECOND=VAL(RIGHT$(FTIME$,2))/2
CXLONG=CLNG(HOUR)*2048&+CLNG(MINUTE)*32&+CLNG(SECOND)/2&
IF CXLONG>32767& THEN CXLONG=CXLONG-65536&
CX=CINT(CXLONG)
POKE OS+10,CX AND &HFF : POKE OS+11,(CX AND &HFF00&)/256
MONTH=VAL(LEFT$(FDATE$,2)) : DAY=VAL(MID$(FDATE$,4,2))
YEAR=VAL(RIGHT$(FDATE$,2))+20
DXLONG=CLNG(YEAR)*512&+CLNG(MONTH)*32&+CLNG(DAY)
IF DXLONG>32767& THEN DXLONG=DXLONG-65536&
DX=CINT(DXLONG)
POKE OS+13,DX AND &HFF : POKE OS+14,(DX AND &HFF00&)/256
CALL ABSOLUTE(CF,CX,DX,OS)
END IF
DEF SEG
END SUB
