/* A rather trivial program to generate a random password for my numeric
   password scheme for JNOS using 60 distinct integers from 1 to 99
   Pete VE5VA
*/
#include <stdio.h>
#include <stdlib.h>
int vector[100];
#ifdef MCH_AMIGA
long dates[3];
#endif
main(argc,argv)
int argc;
char *argv[];
{
   FILE *pwd;
   register int j,k,l;
#ifdef MCH_AMIGA
   DateStamp((struct DateStamp *)&dates[0]);
   srand((short)((dates[0]*50 + dates[2]) | 1));
#else
   randomize();
#endif
   if((pwd = fopen("mbox.pwd","w")) == NULL) {
      printf("Can't create mbox.pwd file\n");
      exit(10);
   }
   /* j counts the 60 numbers. 'l' is used to limit the number of times
      around the loop because rand() is not a super efficient generator
      of random numbers and can itself go into a loop.
   */
   fprintf(pwd,"# Random password generated by makepass for a JNOS having the\n");
   fprintf(pwd,"# numeric sysop password mod by VE5VA\n");
   fprintf(pwd,"mbox password \"\"");
   for(j=0,l=0;(j < 60) && (l<2000);l++) {
#ifdef MCH_AMIGA
      k = rand()%99 + 1;
#else
      k = random(99)+1;
#endif
      if(vector[k])continue;
      vector[k] = 1;
      if((j % 10) == 0)fprintf(pwd,"\nmbox password ");
      fprintf(pwd,"%4d",k);
      j++;
   }
   fprintf(pwd,"\n");
   if(l >= 2000) {
      printf("rand must have looped - try again\n");
   }
   fclose(pwd);
}
