/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.repository.spi;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.encoders.Hex;

public abstract class PGPPublicKeyService {
    public static final String SERVICE_NAME = PGPPublicKeyService.class.getName();

    public PGPPublicKey getKey(byte[] fingerprint) {
        return this.getKey(PGPPublicKeyService.toHex(fingerprint));
    }

    public abstract PGPPublicKey getKey(String var1);

    public abstract Collection<PGPPublicKey> getKeys(long var1);

    public abstract PGPPublicKey addKey(PGPPublicKey var1);

    public abstract Set<PGPPublicKey> getVerifiedCertifications(PGPPublicKey var1);

    public abstract Date getVerifiedRevocationDate(PGPPublicKey var1);

    public boolean isCreatedBeforeRevocation(PGPSignature signature, PGPPublicKey key) {
        long signatureCreationTime;
        if (signature.getKeyID() != key.getKeyID()) {
            throw new IllegalArgumentException("The signature's key ID must be the same as the key's key ID");
        }
        Date verifiedRevocationDate = this.getVerifiedRevocationDate(key);
        return verifiedRevocationDate == null || (signatureCreationTime = signature.getCreationTime().getTime()) < verifiedRevocationDate.getTime();
    }

    public static String toHexFingerprint(PGPPublicKey key) {
        return Hex.toHexString((byte[])key.getFingerprint());
    }

    public static String toHex(byte[] bytes) {
        return Hex.toHexString((byte[])bytes);
    }

    public static String toHex(long keyID) {
        return String.format("%1$016x", keyID);
    }

    public static long compareSignatureTimeToKeyValidityTime(PGPSignature signature, PGPPublicKey key) {
        if (signature.getKeyID() != key.getKeyID()) {
            throw new IllegalArgumentException("The signature's key ID must be the same as the key's key ID");
        }
        long keyCreationTime = key.getCreationTime().getTime();
        long signatureCreationTime = signature.getCreationTime().getTime();
        long delta = signatureCreationTime - keyCreationTime;
        if (delta < 0L) {
            return delta;
        }
        long validSeconds = key.getValidSeconds();
        if (validSeconds != 0L && (delta = signatureCreationTime - (keyCreationTime + validSeconds * 1000L)) > 0L) {
            return delta;
        }
        return 0L;
    }
}

