/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;

public class UnsignedIntegerRendering
extends AbstractIntegerRendering {
    public UnsignedIntegerRendering(String renderingId) {
        super(renderingId);
    }

    private String convertToString(byte[] byteArray, int columnSize, int endianess) {
        long result = 0L;
        switch (columnSize) {
            case 1: {
                result = byteArray[0];
                result &= 0xFFL;
                break;
            }
            case 2: {
                result = RenderingsUtil.convertByteArrayToInt(byteArray, endianess, this.getAddressableSize());
                break;
            }
            case 4: {
                result = RenderingsUtil.convertByteArrayToLong(byteArray, endianess, this.getAddressableSize());
                break;
            }
            case 8: {
                BigInteger value = RenderingsUtil.convertByteArrayToUnsignedLong(byteArray, endianess, this.getAddressableSize());
                return value.toString();
            }
            case 16: {
                BigInteger bigRet = RenderingsUtil.convertByteArrayToUnsignedBigInt(byteArray, endianess, this.getAddressableSize());
                return bigRet.toString();
            }
            default: {
                BigInteger bigRet = RenderingsUtil.convertByteArrayToUnsignedBigInt(byteArray, endianess, columnSize, this.getAddressableSize());
                return bigRet.toString();
            }
        }
        String ret = Long.toString(result);
        return ret;
    }

    private byte[] convertToBytes(int colSize, String newValue, int endianess) {
        byte[] bytes;
        switch (colSize) {
            case 1: {
                short i = Short.parseShort(newValue);
                bytes = RenderingsUtil.convertShortToByteArray(i, endianess, this.getAddressableSize());
                bytes = this.extractBytes(bytes, endianess, colSize);
                break;
            }
            case 2: {
                int i = Integer.parseInt(newValue);
                bytes = RenderingsUtil.convertIntToByteArray(i, endianess, this.getAddressableSize());
                bytes = this.extractBytes(bytes, endianess, colSize);
                break;
            }
            case 4: {
                long i = Long.parseLong(newValue);
                bytes = RenderingsUtil.convertLongToByteArray(i, endianess, this.getAddressableSize());
                bytes = this.extractBytes(bytes, endianess, colSize);
                break;
            }
            case 8: {
                BigInteger i = new BigInteger(newValue);
                bytes = RenderingsUtil.convertBigIntegerToByteArray(i, endianess, this.getAddressableSize());
                bytes = this.extractBytes(bytes, endianess, colSize);
                break;
            }
            case 16: {
                BigInteger i = new BigInteger(newValue);
                byte[] bytes2 = RenderingsUtil.convertUnsignedBigIntegerToByteArray(i, endianess, this.getAddressableSize());
                bytes2 = this.extractBytes(bytes2, endianess, colSize);
                return bytes2;
            }
            default: {
                BigInteger i = new BigInteger(newValue);
                byte[] bytes3 = RenderingsUtil.convertUnsignedBigIntToByteArray(i, endianess, colSize, this.getAddressableSize());
                bytes3 = this.extractBytes(bytes3, endianess, colSize);
                return bytes3;
            }
        }
        return bytes;
    }

    @Override
    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        boolean invalid = false;
        MemoryByte[] memoryByteArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryByte memByte = memoryByteArray[n2];
            if (!memByte.isReadable()) {
                invalid = true;
                break;
            }
            ++n2;
        }
        if (invalid) {
            StringBuilder strBuf = new StringBuilder();
            int i = 0;
            while (i < data.length) {
                strBuf.append(paddedStr);
                ++i;
            }
            return strBuf.toString();
        }
        int columnSize = this.getBytesPerColumn();
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(data);
        }
        byte[] byteArray = new byte[data.length];
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = data[i].getValue();
            ++i;
        }
        if (2 == endianess) {
            StringBuilder strBuf = new StringBuilder();
            int i2 = 0;
            while (i2 < byteArray.length) {
                strBuf.append(paddedStr);
                ++i2;
            }
            return strBuf.toString();
        }
        return this.convertToString(byteArray, columnSize, endianess);
    }

    @Override
    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        int columnSize = this.getBytesPerColumn();
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(currentValues);
        }
        if (endianess == 2) {
            byte[] retBytes = new byte[currentValues.length];
            int i = 0;
            while (i < currentValues.length) {
                retBytes[i] = currentValues[i].getValue();
                ++i;
            }
            return retBytes;
        }
        return this.convertToBytes(columnSize, data, endianess);
    }

    private byte[] extractBytes(byte[] bytes, int endianess, int colSize) {
        if (colSize > bytes.length) {
            throw new NumberFormatException();
        }
        if (endianess == 1) {
            int i = 0;
            while (i < colSize) {
                if (bytes[i] != 0) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            byte[] copy = new byte[colSize];
            int j = 0;
            int k = bytes.length - colSize;
            while (j < copy.length && k < bytes.length) {
                copy[j] = bytes[k];
                ++j;
                ++k;
            }
            bytes = copy;
        } else {
            int i = colSize;
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            byte[] copy = new byte[colSize];
            int j = 0;
            while (j < copy.length) {
                copy[j] = bytes[j];
                ++j;
            }
            bytes = copy;
        }
        return bytes;
    }
}

