/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     TYPECAST = 326,
     CSTRING = 327,
     CVARIABLE = 328,
     CPP_LINE = 329,
     IP = 330,
     DOLCONST = 331,
     ECONST = 332,
     NCONST = 333,
     UCONST = 334,
     UIDENT = 335,
     ABORT_P = 336,
     ABSOLUTE_P = 337,
     ACCESS = 338,
     ACTION = 339,
     ADD_P = 340,
     ADMIN = 341,
     AFTER = 342,
     AGGREGATE = 343,
     ALL = 344,
     ALSO = 345,
     ALTER = 346,
     ALWAYS = 347,
     ANALYSE = 348,
     ANALYZE = 349,
     AND = 350,
     ANY = 351,
     ARRAY = 352,
     AS = 353,
     ASC = 354,
     ASSERTION = 355,
     ASSIGNMENT = 356,
     ASYMMETRIC = 357,
     AT = 358,
     AUTHORIZATION = 359,
     BACKWARD = 360,
     BEFORE = 361,
     BEGIN_P = 362,
     BETWEEN = 363,
     BIGINT = 364,
     BINARY = 365,
     BIT = 366,
     BOOLEAN_P = 367,
     BOTH = 368,
     BY = 369,
     CACHE = 370,
     CALLED = 371,
     CASCADE = 372,
     CASCADED = 373,
     CASE = 374,
     CAST = 375,
     CATALOG_P = 376,
     CHAIN = 377,
     CHAR_P = 378,
     CHARACTER = 379,
     CHARACTERISTICS = 380,
     CHECK = 381,
     CHECKPOINT = 382,
     CLASS = 383,
     CLOSE = 384,
     CLUSTER = 385,
     COALESCE = 386,
     COLLATE = 387,
     COLUMN = 388,
     COMMENT = 389,
     COMMIT = 390,
     COMMITTED = 391,
     CONCURRENTLY = 392,
     CONFIGURATION = 393,
     CONNECTION = 394,
     CONSTRAINT = 395,
     CONSTRAINTS = 396,
     CONTENT_P = 397,
     CONTINUE_P = 398,
     CONVERSION_P = 399,
     COPY = 400,
     COST = 401,
     CREATE = 402,
     CREATEDB = 403,
     CREATEROLE = 404,
     CREATEUSER = 405,
     CROSS = 406,
     CSV = 407,
     CURRENT_P = 408,
     CURRENT_CATALOG = 409,
     CURRENT_DATE = 410,
     CURRENT_ROLE = 411,
     CURRENT_SCHEMA = 412,
     CURRENT_TIME = 413,
     CURRENT_TIMESTAMP = 414,
     CURRENT_USER = 415,
     CURSOR = 416,
     CYCLE = 417,
     DATA_P = 418,
     DATABASE = 419,
     DAY_P = 420,
     DEALLOCATE = 421,
     DEC = 422,
     DECIMAL_P = 423,
     DECLARE = 424,
     DEFAULT = 425,
     DEFAULTS = 426,
     DEFERRABLE = 427,
     DEFERRED = 428,
     DEFINER = 429,
     DELETE_P = 430,
     DELIMITER = 431,
     DELIMITERS = 432,
     DESC = 433,
     DICTIONARY = 434,
     DISABLE_P = 435,
     DISCARD = 436,
     DISTINCT = 437,
     DO = 438,
     DOCUMENT_P = 439,
     DOMAIN_P = 440,
     DOUBLE_P = 441,
     DROP = 442,
     EACH = 443,
     ELSE = 444,
     ENABLE_P = 445,
     ENCODING = 446,
     ENCRYPTED = 447,
     END_P = 448,
     ENUM_P = 449,
     ESCAPE = 450,
     EXCEPT = 451,
     EXCLUDING = 452,
     EXCLUSIVE = 453,
     EXECUTE = 454,
     EXISTS = 455,
     EXPLAIN = 456,
     EXTERNAL = 457,
     EXTRACT = 458,
     FALSE_P = 459,
     FAMILY = 460,
     FETCH = 461,
     FIRST_P = 462,
     FLOAT_P = 463,
     FOLLOWING = 464,
     FOR = 465,
     FORCE = 466,
     FOREIGN = 467,
     FORWARD = 468,
     FREEZE = 469,
     FROM = 470,
     FULL = 471,
     FUNCTION = 472,
     GLOBAL = 473,
     GRANT = 474,
     GRANTED = 475,
     GREATEST = 476,
     GROUP_P = 477,
     HANDLER = 478,
     HAVING = 479,
     HEADER_P = 480,
     HOLD = 481,
     HOUR_P = 482,
     IDENTITY_P = 483,
     IF_P = 484,
     ILIKE = 485,
     IMMEDIATE = 486,
     IMMUTABLE = 487,
     IMPLICIT_P = 488,
     IN_P = 489,
     INCLUDING = 490,
     INCREMENT = 491,
     INDEX = 492,
     INDEXES = 493,
     INHERIT = 494,
     INHERITS = 495,
     INITIALLY = 496,
     INNER_P = 497,
     INOUT = 498,
     INPUT_P = 499,
     INSENSITIVE = 500,
     INSERT = 501,
     INSTEAD = 502,
     INT_P = 503,
     INTEGER = 504,
     INTERSECT = 505,
     INTERVAL = 506,
     INTO = 507,
     INVOKER = 508,
     IS = 509,
     ISNULL = 510,
     ISOLATION = 511,
     JOIN = 512,
     KEY = 513,
     LANCOMPILER = 514,
     LANGUAGE = 515,
     LARGE_P = 516,
     LAST_P = 517,
     LC_COLLATE_P = 518,
     LC_CTYPE_P = 519,
     LEADING = 520,
     LEAST = 521,
     LEFT = 522,
     LEVEL = 523,
     LIKE = 524,
     LIMIT = 525,
     LISTEN = 526,
     LOAD = 527,
     LOCAL = 528,
     LOCALTIME = 529,
     LOCALTIMESTAMP = 530,
     LOCATION = 531,
     LOCK_P = 532,
     LOGIN_P = 533,
     MAPPING = 534,
     MATCH = 535,
     MAXVALUE = 536,
     MINUTE_P = 537,
     MINVALUE = 538,
     MODE = 539,
     MONTH_P = 540,
     MOVE = 541,
     NAME_P = 542,
     NAMES = 543,
     NATIONAL = 544,
     NATURAL = 545,
     NCHAR = 546,
     NEW = 547,
     NEXT = 548,
     NO = 549,
     NOCREATEDB = 550,
     NOCREATEROLE = 551,
     NOCREATEUSER = 552,
     NOINHERIT = 553,
     NOLOGIN_P = 554,
     NONE = 555,
     NOSUPERUSER = 556,
     NOT = 557,
     NOTHING = 558,
     NOTIFY = 559,
     NOTNULL = 560,
     NOWAIT = 561,
     NULL_P = 562,
     NULLIF = 563,
     NULLS_P = 564,
     NUMERIC = 565,
     OBJECT_P = 566,
     OF = 567,
     OFF = 568,
     OFFSET = 569,
     OIDS = 570,
     OLD = 571,
     ON = 572,
     ONLY = 573,
     OPERATOR = 574,
     OPTION = 575,
     OPTIONS = 576,
     OR = 577,
     ORDER = 578,
     OUT_P = 579,
     OUTER_P = 580,
     OVER = 581,
     OVERLAPS = 582,
     OVERLAY = 583,
     OWNED = 584,
     OWNER = 585,
     PARSER = 586,
     PARTIAL = 587,
     PARTITION = 588,
     PASSWORD = 589,
     PLACING = 590,
     PLANS = 591,
     POSITION = 592,
     PRECEDING = 593,
     PRECISION = 594,
     PRESERVE = 595,
     PREPARE = 596,
     PREPARED = 597,
     PRIMARY = 598,
     PRIOR = 599,
     PRIVILEGES = 600,
     PROCEDURAL = 601,
     PROCEDURE = 602,
     QUOTE = 603,
     RANGE = 604,
     READ = 605,
     REAL = 606,
     REASSIGN = 607,
     RECHECK = 608,
     RECURSIVE = 609,
     REFERENCES = 610,
     REINDEX = 611,
     RELATIVE_P = 612,
     RELEASE = 613,
     RENAME = 614,
     REPEATABLE = 615,
     REPLACE = 616,
     REPLICA = 617,
     RESET = 618,
     RESTART = 619,
     RESTRICT = 620,
     RETURNING = 621,
     RETURNS = 622,
     REVOKE = 623,
     RIGHT = 624,
     ROLE = 625,
     ROLLBACK = 626,
     ROW = 627,
     ROWS = 628,
     RULE = 629,
     SAVEPOINT = 630,
     SCHEMA = 631,
     SCROLL = 632,
     SEARCH = 633,
     SECOND_P = 634,
     SECURITY = 635,
     SELECT = 636,
     SEQUENCE = 637,
     SERIALIZABLE = 638,
     SERVER = 639,
     SESSION = 640,
     SESSION_USER = 641,
     SET = 642,
     SETOF = 643,
     SHARE = 644,
     SHOW = 645,
     SIMILAR = 646,
     SIMPLE = 647,
     SMALLINT = 648,
     SOME = 649,
     STABLE = 650,
     STANDALONE_P = 651,
     START = 652,
     STATEMENT = 653,
     STATISTICS = 654,
     STDIN = 655,
     STDOUT = 656,
     STORAGE = 657,
     STRICT_P = 658,
     STRIP_P = 659,
     SUBSTRING = 660,
     SUPERUSER_P = 661,
     SYMMETRIC = 662,
     SYSID = 663,
     SYSTEM_P = 664,
     TABLE = 665,
     TABLESPACE = 666,
     TEMP = 667,
     TEMPLATE = 668,
     TEMPORARY = 669,
     TEXT_P = 670,
     THEN = 671,
     TIME = 672,
     TIMESTAMP = 673,
     TO = 674,
     TRAILING = 675,
     TRANSACTION = 676,
     TREAT = 677,
     TRIGGER = 678,
     TRIM = 679,
     TRUE_P = 680,
     TRUNCATE = 681,
     TRUSTED = 682,
     TYPE_P = 683,
     UNBOUNDED = 684,
     UNCOMMITTED = 685,
     UNENCRYPTED = 686,
     UNION = 687,
     UNIQUE = 688,
     UNKNOWN = 689,
     UNLISTEN = 690,
     UNTIL = 691,
     UPDATE = 692,
     USER = 693,
     USING = 694,
     VACUUM = 695,
     VALID = 696,
     VALIDATOR = 697,
     VALUE_P = 698,
     VALUES = 699,
     VARCHAR = 700,
     VARIADIC = 701,
     VARYING = 702,
     VERBOSE = 703,
     VERSION_P = 704,
     VIEW = 705,
     VOLATILE = 706,
     WHEN = 707,
     WHERE = 708,
     WHITESPACE_P = 709,
     WINDOW = 710,
     WITH = 711,
     WITHOUT = 712,
     WORK = 713,
     WRAPPER = 714,
     WRITE = 715,
     XML_P = 716,
     XMLATTRIBUTES = 717,
     XMLCONCAT = 718,
     XMLELEMENT = 719,
     XMLFOREST = 720,
     XMLPARSE = 721,
     XMLPI = 722,
     XMLROOT = 723,
     XMLSERIALIZE = 724,
     YEAR_P = 725,
     YES_P = 726,
     ZONE = 727,
     NULLS_FIRST = 728,
     NULLS_LAST = 729,
     WITH_TIME = 730,
     IDENT = 731,
     FCONST = 732,
     SCONST = 733,
     BCONST = 734,
     XCONST = 735,
     Op = 736,
     ICONST = 737,
     PARAM = 738,
     POSTFIXOP = 739,
     UMINUS = 740
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define TYPECAST 326
#define CSTRING 327
#define CVARIABLE 328
#define CPP_LINE 329
#define IP 330
#define DOLCONST 331
#define ECONST 332
#define NCONST 333
#define UCONST 334
#define UIDENT 335
#define ABORT_P 336
#define ABSOLUTE_P 337
#define ACCESS 338
#define ACTION 339
#define ADD_P 340
#define ADMIN 341
#define AFTER 342
#define AGGREGATE 343
#define ALL 344
#define ALSO 345
#define ALTER 346
#define ALWAYS 347
#define ANALYSE 348
#define ANALYZE 349
#define AND 350
#define ANY 351
#define ARRAY 352
#define AS 353
#define ASC 354
#define ASSERTION 355
#define ASSIGNMENT 356
#define ASYMMETRIC 357
#define AT 358
#define AUTHORIZATION 359
#define BACKWARD 360
#define BEFORE 361
#define BEGIN_P 362
#define BETWEEN 363
#define BIGINT 364
#define BINARY 365
#define BIT 366
#define BOOLEAN_P 367
#define BOTH 368
#define BY 369
#define CACHE 370
#define CALLED 371
#define CASCADE 372
#define CASCADED 373
#define CASE 374
#define CAST 375
#define CATALOG_P 376
#define CHAIN 377
#define CHAR_P 378
#define CHARACTER 379
#define CHARACTERISTICS 380
#define CHECK 381
#define CHECKPOINT 382
#define CLASS 383
#define CLOSE 384
#define CLUSTER 385
#define COALESCE 386
#define COLLATE 387
#define COLUMN 388
#define COMMENT 389
#define COMMIT 390
#define COMMITTED 391
#define CONCURRENTLY 392
#define CONFIGURATION 393
#define CONNECTION 394
#define CONSTRAINT 395
#define CONSTRAINTS 396
#define CONTENT_P 397
#define CONTINUE_P 398
#define CONVERSION_P 399
#define COPY 400
#define COST 401
#define CREATE 402
#define CREATEDB 403
#define CREATEROLE 404
#define CREATEUSER 405
#define CROSS 406
#define CSV 407
#define CURRENT_P 408
#define CURRENT_CATALOG 409
#define CURRENT_DATE 410
#define CURRENT_ROLE 411
#define CURRENT_SCHEMA 412
#define CURRENT_TIME 413
#define CURRENT_TIMESTAMP 414
#define CURRENT_USER 415
#define CURSOR 416
#define CYCLE 417
#define DATA_P 418
#define DATABASE 419
#define DAY_P 420
#define DEALLOCATE 421
#define DEC 422
#define DECIMAL_P 423
#define DECLARE 424
#define DEFAULT 425
#define DEFAULTS 426
#define DEFERRABLE 427
#define DEFERRED 428
#define DEFINER 429
#define DELETE_P 430
#define DELIMITER 431
#define DELIMITERS 432
#define DESC 433
#define DICTIONARY 434
#define DISABLE_P 435
#define DISCARD 436
#define DISTINCT 437
#define DO 438
#define DOCUMENT_P 439
#define DOMAIN_P 440
#define DOUBLE_P 441
#define DROP 442
#define EACH 443
#define ELSE 444
#define ENABLE_P 445
#define ENCODING 446
#define ENCRYPTED 447
#define END_P 448
#define ENUM_P 449
#define ESCAPE 450
#define EXCEPT 451
#define EXCLUDING 452
#define EXCLUSIVE 453
#define EXECUTE 454
#define EXISTS 455
#define EXPLAIN 456
#define EXTERNAL 457
#define EXTRACT 458
#define FALSE_P 459
#define FAMILY 460
#define FETCH 461
#define FIRST_P 462
#define FLOAT_P 463
#define FOLLOWING 464
#define FOR 465
#define FORCE 466
#define FOREIGN 467
#define FORWARD 468
#define FREEZE 469
#define FROM 470
#define FULL 471
#define FUNCTION 472
#define GLOBAL 473
#define GRANT 474
#define GRANTED 475
#define GREATEST 476
#define GROUP_P 477
#define HANDLER 478
#define HAVING 479
#define HEADER_P 480
#define HOLD 481
#define HOUR_P 482
#define IDENTITY_P 483
#define IF_P 484
#define ILIKE 485
#define IMMEDIATE 486
#define IMMUTABLE 487
#define IMPLICIT_P 488
#define IN_P 489
#define INCLUDING 490
#define INCREMENT 491
#define INDEX 492
#define INDEXES 493
#define INHERIT 494
#define INHERITS 495
#define INITIALLY 496
#define INNER_P 497
#define INOUT 498
#define INPUT_P 499
#define INSENSITIVE 500
#define INSERT 501
#define INSTEAD 502
#define INT_P 503
#define INTEGER 504
#define INTERSECT 505
#define INTERVAL 506
#define INTO 507
#define INVOKER 508
#define IS 509
#define ISNULL 510
#define ISOLATION 511
#define JOIN 512
#define KEY 513
#define LANCOMPILER 514
#define LANGUAGE 515
#define LARGE_P 516
#define LAST_P 517
#define LC_COLLATE_P 518
#define LC_CTYPE_P 519
#define LEADING 520
#define LEAST 521
#define LEFT 522
#define LEVEL 523
#define LIKE 524
#define LIMIT 525
#define LISTEN 526
#define LOAD 527
#define LOCAL 528
#define LOCALTIME 529
#define LOCALTIMESTAMP 530
#define LOCATION 531
#define LOCK_P 532
#define LOGIN_P 533
#define MAPPING 534
#define MATCH 535
#define MAXVALUE 536
#define MINUTE_P 537
#define MINVALUE 538
#define MODE 539
#define MONTH_P 540
#define MOVE 541
#define NAME_P 542
#define NAMES 543
#define NATIONAL 544
#define NATURAL 545
#define NCHAR 546
#define NEW 547
#define NEXT 548
#define NO 549
#define NOCREATEDB 550
#define NOCREATEROLE 551
#define NOCREATEUSER 552
#define NOINHERIT 553
#define NOLOGIN_P 554
#define NONE 555
#define NOSUPERUSER 556
#define NOT 557
#define NOTHING 558
#define NOTIFY 559
#define NOTNULL 560
#define NOWAIT 561
#define NULL_P 562
#define NULLIF 563
#define NULLS_P 564
#define NUMERIC 565
#define OBJECT_P 566
#define OF 567
#define OFF 568
#define OFFSET 569
#define OIDS 570
#define OLD 571
#define ON 572
#define ONLY 573
#define OPERATOR 574
#define OPTION 575
#define OPTIONS 576
#define OR 577
#define ORDER 578
#define OUT_P 579
#define OUTER_P 580
#define OVER 581
#define OVERLAPS 582
#define OVERLAY 583
#define OWNED 584
#define OWNER 585
#define PARSER 586
#define PARTIAL 587
#define PARTITION 588
#define PASSWORD 589
#define PLACING 590
#define PLANS 591
#define POSITION 592
#define PRECEDING 593
#define PRECISION 594
#define PRESERVE 595
#define PREPARE 596
#define PREPARED 597
#define PRIMARY 598
#define PRIOR 599
#define PRIVILEGES 600
#define PROCEDURAL 601
#define PROCEDURE 602
#define QUOTE 603
#define RANGE 604
#define READ 605
#define REAL 606
#define REASSIGN 607
#define RECHECK 608
#define RECURSIVE 609
#define REFERENCES 610
#define REINDEX 611
#define RELATIVE_P 612
#define RELEASE 613
#define RENAME 614
#define REPEATABLE 615
#define REPLACE 616
#define REPLICA 617
#define RESET 618
#define RESTART 619
#define RESTRICT 620
#define RETURNING 621
#define RETURNS 622
#define REVOKE 623
#define RIGHT 624
#define ROLE 625
#define ROLLBACK 626
#define ROW 627
#define ROWS 628
#define RULE 629
#define SAVEPOINT 630
#define SCHEMA 631
#define SCROLL 632
#define SEARCH 633
#define SECOND_P 634
#define SECURITY 635
#define SELECT 636
#define SEQUENCE 637
#define SERIALIZABLE 638
#define SERVER 639
#define SESSION 640
#define SESSION_USER 641
#define SET 642
#define SETOF 643
#define SHARE 644
#define SHOW 645
#define SIMILAR 646
#define SIMPLE 647
#define SMALLINT 648
#define SOME 649
#define STABLE 650
#define STANDALONE_P 651
#define START 652
#define STATEMENT 653
#define STATISTICS 654
#define STDIN 655
#define STDOUT 656
#define STORAGE 657
#define STRICT_P 658
#define STRIP_P 659
#define SUBSTRING 660
#define SUPERUSER_P 661
#define SYMMETRIC 662
#define SYSID 663
#define SYSTEM_P 664
#define TABLE 665
#define TABLESPACE 666
#define TEMP 667
#define TEMPLATE 668
#define TEMPORARY 669
#define TEXT_P 670
#define THEN 671
#define TIME 672
#define TIMESTAMP 673
#define TO 674
#define TRAILING 675
#define TRANSACTION 676
#define TREAT 677
#define TRIGGER 678
#define TRIM 679
#define TRUE_P 680
#define TRUNCATE 681
#define TRUSTED 682
#define TYPE_P 683
#define UNBOUNDED 684
#define UNCOMMITTED 685
#define UNENCRYPTED 686
#define UNION 687
#define UNIQUE 688
#define UNKNOWN 689
#define UNLISTEN 690
#define UNTIL 691
#define UPDATE 692
#define USER 693
#define USING 694
#define VACUUM 695
#define VALID 696
#define VALIDATOR 697
#define VALUE_P 698
#define VALUES 699
#define VARCHAR 700
#define VARIADIC 701
#define VARYING 702
#define VERBOSE 703
#define VERSION_P 704
#define VIEW 705
#define VOLATILE 706
#define WHEN 707
#define WHERE 708
#define WHITESPACE_P 709
#define WINDOW 710
#define WITH 711
#define WITHOUT 712
#define WORK 713
#define WRAPPER 714
#define WRITE 715
#define XML_P 716
#define XMLATTRIBUTES 717
#define XMLCONCAT 718
#define XMLELEMENT 719
#define XMLFOREST 720
#define XMLPARSE 721
#define XMLPI 722
#define XMLROOT 723
#define XMLSERIALIZE 724
#define YEAR_P 725
#define YES_P 726
#define ZONE 727
#define NULLS_FIRST 728
#define NULLS_LAST 729
#define WITH_TIME 730
#define IDENT 731
#define FCONST 732
#define SCONST 733
#define BCONST 734
#define XCONST 735
#define Op 736
#define ICONST 737
#define PARAM 738
#define POSTFIXOP 739
#define UMINUS 740




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 387 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1447 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1471 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   85248

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  505
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  617
/* YYNRULES -- Number of rules. */
#define YYNRULES  2435
/* YYNRULES -- Number of states. */
#define YYNSTATES  4235

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   740

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   492,     2,     2,
     497,   498,   490,   488,   500,   489,   499,   491,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   502,   501,
     485,   484,   486,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   495,     2,   496,   493,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   503,     2,   504,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   487,
     494
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   244,   250,   252,   253,   256,   257,   260,
     263,   267,   271,   273,   275,   277,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   299,   303,   306,   309,   312,
     315,   319,   323,   329,   335,   340,   346,   351,   355,   361,
     365,   371,   377,   384,   386,   388,   392,   398,   405,   410,
     412,   413,   416,   417,   419,   421,   423,   425,   427,   429,
     432,   436,   440,   444,   448,   452,   456,   460,   464,   467,
     473,   476,   479,   482,   485,   489,   493,   497,   499,   503,
     505,   509,   511,   513,   515,   518,   521,   524,   526,   528,
     530,   532,   534,   536,   538,   542,   549,   551,   553,   555,
     557,   559,   560,   562,   564,   567,   571,   576,   580,   583,
     586,   588,   592,   597,   603,   608,   611,   616,   618,   620,
     622,   624,   626,   629,   632,   635,   638,   643,   648,   653,
     658,   660,   664,   668,   673,   680,   687,   694,   701,   706,
     714,   717,   722,   726,   730,   734,   738,   742,   747,   752,
     756,   760,   764,   768,   772,   776,   781,   786,   790,   793,
     797,   801,   805,   808,   811,   815,   818,   820,   822,   823,
     826,   827,   831,   834,   835,   837,   841,   845,   847,   853,
     857,   860,   863,   874,   881,   883,   885,   887,   889,   891,
     894,   895,   897,   899,   903,   907,   909,   911,   915,   919,
     923,   928,   930,   931,   934,   935,   939,   940,   942,   943,
     955,   968,   970,   972,   975,   978,   981,   984,   985,   987,
     988,   990,   994,   996,   998,  1000,  1004,  1007,  1008,  1012,
    1014,  1016,  1019,  1021,  1025,  1030,  1035,  1038,  1044,  1046,
    1049,  1052,  1055,  1059,  1062,  1063,  1066,  1069,  1072,  1075,
    1078,  1081,  1085,  1087,  1092,  1099,  1107,  1119,  1123,  1124,
    1126,  1130,  1132,  1135,  1138,  1141,  1142,  1144,  1146,  1149,
    1152,  1153,  1157,  1161,  1164,  1166,  1168,  1171,  1174,  1179,
    1180,  1183,  1186,  1189,  1190,  1194,  1199,  1204,  1205,  1208,
    1209,  1214,  1215,  1221,  1225,  1226,  1228,  1232,  1234,  1237,
    1241,  1242,  1248,  1253,  1255,  1256,  1258,  1261,  1264,  1266,
    1269,  1273,  1276,  1279,  1282,  1285,  1289,  1293,  1295,  1299,
    1301,  1302,  1304,  1307,  1309,  1315,  1325,  1327,  1328,  1330,
    1333,  1336,  1339,  1341,  1342,  1345,  1346,  1352,  1360,  1362,
    1363,  1370,  1373,  1374,  1378,  1384,  1392,  1399,  1408,  1416,
    1423,  1430,  1435,  1436,  1438,  1442,  1447,  1449,  1453,  1455,
    1458,  1461,  1464,  1467,  1469,  1471,  1482,  1485,  1486,  1489,
    1492,  1494,  1495,  1500,  1507,  1513,  1518,  1523,  1532,  1534,
    1536,  1538,  1546,  1556,  1565,  1580,  1600,  1602,  1604,  1606,
    1610,  1612,  1614,  1616,  1618,  1622,  1623,  1625,  1626,  1628,
    1630,  1632,  1636,  1637,  1639,  1641,  1643,  1645,  1647,  1649,
    1652,  1653,  1655,  1658,  1660,  1663,  1664,  1667,  1669,  1672,
    1675,  1682,  1691,  1700,  1705,  1711,  1716,  1721,  1726,  1730,
    1738,  1747,  1754,  1761,  1768,  1775,  1779,  1781,  1785,  1789,
    1791,  1793,  1795,  1797,  1799,  1801,  1805,  1809,  1813,  1815,
    1819,  1823,  1825,  1829,  1843,  1845,  1849,  1854,  1860,  1865,
    1873,  1876,  1878,  1879,  1882,  1883,  1885,  1886,  1893,  1902,
    1911,  1913,  1917,  1923,  1929,  1937,  1947,  1955,  1965,  1971,
    1978,  1985,  1990,  1992,  1994,  1996,  1998,  2000,  2002,  2004,
    2006,  2010,  2014,  2018,  2022,  2024,  2028,  2030,  2033,  2036,
    2040,  2046,  2049,  2052,  2053,  2060,  2068,  2076,  2084,  2093,
    2102,  2109,  2118,  2128,  2138,  2146,  2157,  2165,  2174,  2183,
    2192,  2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,
    2219,  2221,  2223,  2225,  2227,  2229,  2234,  2237,  2242,  2245,
    2251,  2256,  2261,  2265,  2269,  2273,  2275,  2277,  2279,  2281,
    2284,  2287,  2289,  2291,  2293,  2296,  2299,  2301,  2304,  2307,
    2309,  2311,  2319,  2327,  2338,  2340,  2342,  2345,  2350,  2356,
    2358,  2362,  2365,  2368,  2371,  2374,  2376,  2379,  2382,  2387,
    2391,  2394,  2397,  2400,  2403,  2406,  2408,  2412,  2414,  2417,
    2421,  2422,  2424,  2428,  2431,  2438,  2445,  2455,  2459,  2460,
    2464,  2465,  2479,  2494,  2496,  2497,  2500,  2501,  2503,  2507,
    2512,  2517,  2524,  2526,  2529,  2530,  2532,  2534,  2535,  2537,
    2539,  2540,  2550,  2563,  2571,  2574,  2575,  2579,  2582,  2584,
    2588,  2592,  2595,  2597,  2601,  2605,  2609,  2612,  2615,  2617,
    2619,  2621,  2623,  2626,  2628,  2630,  2632,  2634,  2639,  2645,
    2647,  2651,  2655,  2657,  2660,  2665,  2671,  2673,  2675,  2677,
    2679,  2683,  2687,  2690,  2693,  2696,  2699,  2701,  2704,  2707,
    2709,  2711,  2713,  2717,  2720,  2721,  2724,  2726,  2730,  2736,
    2738,  2741,  2743,  2744,  2750,  2758,  2764,  2772,  2778,  2786,
    2790,  2796,  2802,  2808,  2810,  2814,  2826,  2837,  2848,  2851,
    2854,  2855,  2865,  2868,  2869,  2874,  2879,  2884,  2886,  2888,
    2890,  2891,  2899,  2906,  2913,  2920,  2927,  2935,  2945,  2955,
    2962,  2969,  2976,  2983,  2990,  2999,  3008,  3015,  3022,  3029,
    3038,  3047,  3056,  3065,  3072,  3074,  3075,  3078,  3079,  3087,
    3094,  3101,  3108,  3115,  3122,  3129,  3137,  3144,  3151,  3158,
    3165,  3173,  3181,  3191,  3201,  3208,  3215,  3222,  3231,  3240,
    3249,  3256,  3258,  3260,  3264,  3268,  3270,  3272,  3274,  3276,
    3278,  3280,  3282,  3283,  3285,  3287,  3289,  3291,  3293,  3295,
    3296,  3303,  3312,  3315,  3318,  3321,  3324,  3327,  3331,  3335,
    3338,  3341,  3344,  3347,  3351,  3354,  3360,  3365,  3369,  3373,
    3377,  3379,  3381,  3382,  3386,  3389,  3392,  3394,  3398,  3401,
    3403,  3404,  3413,  3424,  3428,  3433,  3438,  3439,  3442,  3448,
    3451,  3452,  3456,  3460,  3464,  3468,  3472,  3476,  3480,  3484,
    3488,  3492,  3496,  3500,  3504,  3509,  3513,  3517,  3519,  3520,
    3526,  3533,  3538,  3541,  3542,  3547,  3551,  3557,  3564,  3569,
    3576,  3583,  3589,  3597,  3599,  3600,  3607,  3619,  3631,  3643,
    3657,  3667,  3679,  3690,  3695,  3698,  3704,  3707,  3708,  3713,
    3719,  3725,  3728,  3733,  3735,  3737,  3739,  3740,  3742,  3743,
    3745,  3746,  3750,  3751,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3772,  3773,  3779,  3784,  3788,  3789,  3791,  3793,
    3795,  3797,  3802,  3811,  3815,  3816,  3822,  3824,  3829,  3832,
    3834,  3838,  3841,  3844,  3845,  3852,  3855,  3856,  3862,  3866,
    3867,  3870,  3873,  3876,  3880,  3882,  3886,  3888,  3891,  3893,
    3894,  3902,  3904,  3908,  3910,  3912,  3916,  3922,  3925,  3927,
    3931,  3939,  3940,  3944,  3947,  3950,  3953,  3954,  3957,  3960,
    3962,  3964,  3968,  3972,  3974,  3977,  3982,  3987,  3990,  3994,
    4000,  4006,  4008,  4010,  4020,  4022,  4025,  4030,  4035,  4040,
    4043,  4047,  4049,  4053,  4058,  4061,  4063,  4064,  4068,  4072,
    4077,  4082,  4087,  4092,  4095,  4097,  4099,  4100,  4102,  4104,
    4105,  4107,  4113,  4115,  4116,  4118,  4119,  4123,  4125,  4129,
    4134,  4138,  4143,  4148,  4151,  4154,  4159,  4163,  4169,  4178,
    4180,  4181,  4183,  4185,  4187,  4191,  4192,  4194,  4196,  4198,
    4200,  4202,  4204,  4208,  4209,  4212,  4213,  4215,  4219,  4221,
    4222,  4224,  4227,  4232,  4237,  4240,  4241,  4244,  4248,  4251,
    4252,  4254,  4258,  4260,  4263,  4265,  4268,  4274,  4281,  4287,
    4289,  4292,  4294,  4299,  4303,  4308,  4314,  4319,  4325,  4330,
    4336,  4339,  4344,  4346,  4349,  4352,  4355,  4357,  4359,  4360,
    4365,  4368,  4370,  4373,  4376,  4381,  4383,  4387,  4389,  4392,
    4396,  4398,  4401,  4402,  4405,  4410,  4415,  4416,  4418,  4422,
    4425,  4428,  4432,  4438,  4445,  4448,  4452,  4456,  4461,  4462,
    4464,  4466,  4468,  4470,  4472,  4475,  4481,  4483,  4485,  4487,
    4489,  4492,  4496,  4500,  4501,  4503,  4505,  4507,  4509,  4511,
    4514,  4517,  4520,  4523,  4526,  4528,  4532,  4533,  4535,  4537,
    4539,  4541,  4547,  4550,  4552,  4554,  4556,  4558,  4564,  4567,
    4570,  4573,  4575,  4579,  4583,  4586,  4588,  4589,  4593,  4594,
    4600,  4603,  4609,  4612,  4614,  4617,  4621,  4622,  4624,  4626,
    4628,  4630,  4632,  4634,  4638,  4642,  4646,  4650,  4654,  4658,
    4662,  4663,  4665,  4670,  4672,  4676,  4682,  4685,  4688,  4692,
    4696,  4700,  4704,  4708,  4712,  4716,  4720,  4724,  4728,  4731,
    4734,  4738,  4742,  4745,  4749,  4755,  4760,  4767,  4771,  4777,
    4782,  4789,  4794,  4801,  4807,  4815,  4819,  4822,  4827,  4830,
    4834,  4838,  4843,  4847,  4852,  4856,  4861,  4867,  4874,  4881,
    4889,  4896,  4904,  4911,  4919,  4923,  4928,  4933,  4940,  4943,
    4947,  4952,  4954,  4958,  4961,  4964,  4968,  4972,  4976,  4980,
    4984,  4988,  4992,  4996,  5000,  5004,  5007,  5010,  5016,  5023,
    5030,  5038,  5042,  5047,  5049,  5051,  5054,  5059,  5061,  5063,
    5065,  5068,  5071,  5074,  5076,  5081,  5087,  5094,  5103,  5110,
    5117,  5123,  5125,  5127,  5132,  5134,  5139,  5141,  5146,  5148,
    5153,  5155,  5157,  5159,  5161,  5163,  5165,  5172,  5177,  5182,
    5187,  5192,  5199,  5205,  5211,  5217,  5222,  5229,  5234,  5239,
    5244,  5249,  5255,  5263,  5271,  5281,  5286,  5293,  5299,  5307,
    5315,  5323,  5326,  5330,  5334,  5338,  5343,  5344,  5349,  5351,
    5355,  5359,  5361,  5363,  5365,  5368,  5371,  5372,  5375,  5376,
    5378,  5382,  5386,  5389,  5392,  5393,  5400,  5402,  5403,  5407,
    5408,  5411,  5414,  5415,  5417,  5422,  5425,  5428,  5431,  5436,
    5440,  5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,  5462,
    5464,  5466,  5468,  5470,  5472,  5474,  5476,  5481,  5483,  5488,
    5490,  5495,  5497,  5500,  5502,  5505,  5507,  5511,  5513,  5517,
    5521,  5525,  5528,  5530,  5534,  5538,  5539,  5541,  5543,  5545,
    5547,  5549,  5551,  5553,  5555,  5560,  5564,  5567,  5571,  5572,
    5576,  5580,  5583,  5586,  5588,  5589,  5592,  5595,  5599,  5602,
    5604,  5606,  5610,  5616,  5618,  5621,  5626,  5629,  5630,  5632,
    5633,  5635,  5638,  5641,  5644,  5648,  5654,  5656,  5659,  5660,
    5663,  5665,  5666,  5668,  5670,  5672,  5676,  5680,  5682,  5686,
    5690,  5693,  5695,  5697,  5699,  5701,  5703,  5707,  5709,  5712,
    5714,  5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,  5735,
    5737,  5739,  5741,  5743,  5745,  5748,  5754,  5757,  5761,  5768,
    5770,  5772,  5774,  5776,  5778,  5780,  5782,  5784,  5786,  5789,
    5792,  5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,
    5812,  5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,
    5852,  5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,
    5872,  5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,
    5892,  5894,  5896,  5898,  5900,  5902,  5904,  5906,  5908,  5910,
    5912,  5914,  5916,  5918,  5920,  5922,  5924,  5926,  5928,  5930,
    5932,  5934,  5936,  5938,  5940,  5942,  5944,  5946,  5948,  5950,
    5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,  5968,  5970,
    5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,  5988,  5990,
    5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,  6010,
    6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,  6030,
    6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,  6050,
    6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,  6070,
    6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,  6090,
    6092,  6094,  6096,  6098,  6100,  6102,  6104,  6105,  6108,  6113,
    6117,  6120,  6122,  6124,  6126,  6128,  6130,  6131,  6140,  6141,
    6156,  6159,  6165,  6169,  6172,  6175,  6179,  6187,  6189,  6191,
    6193,  6194,  6197,  6200,  6202,  6203,  6205,  6209,  6211,  6214,
    6215,  6218,  6219,  6222,  6223,  6225,  6229,  6234,  6238,  6240,
    6242,  6244,  6246,  6249,  6250,  6253,  6258,  6259,  6262,  6265,
    6268,  6270,  6272,  6280,  6284,  6286,  6288,  6290,  6292,  6295,
    6296,  6298,  6302,  6306,  6310,  6314,  6315,  6320,  6326,  6332,
    6333,  6335,  6337,  6339,  6341,  6344,  6347,  6350,  6352,  6355,
    6356,  6364,  6365,  6371,  6372,  6377,  6380,  6383,  6384,  6387,
    6389,  6391,  6393,  6395,  6397,  6399,  6401,  6403,  6405,  6407,
    6409,  6415,  6418,  6420,  6424,  6427,  6430,  6434,  6435,  6441,
    6443,  6444,  6450,  6453,  6456,  6458,  6460,  6462,  6465,  6468,
    6472,  6474,  6477,  6480,  6484,  6488,  6493,  6496,  6498,  6501,
    6503,  6505,  6508,  6511,  6515,  6517,  6519,  6521,  6523,  6524,
    6526,  6530,  6536,  6537,  6540,  6541,  6543,  6546,  6550,  6553,
    6555,  6557,  6559,  6560,  6562,  6564,  6566,  6568,  6570,  6573,
    6576,  6580,  6581,  6583,  6586,  6588,  6593,  6598,  6599,  6601,
    6603,  6607,  6609,  6611,  6613,  6615,  6618,  6621,  6623,  6626,
    6629,  6631,  6633,  6635,  6640,  6645,  6650,  6652,  6653,  6657,
    6661,  6666,  6668,  6672,  6676,  6681,  6683,  6687,  6691,  6693,
    6695,  6697,  6704,  6706,  6710,  6714,  6721,  6723,  6727,  6731,
    6733,  6735,  6738,  6741,  6743,  6745,  6747,  6749,  6751,  6753,
    6755,  6757,  6759,  6761,  6763,  6765,  6767,  6769,  6771,  6773,
    6778,  6783,  6785,  6787,  6792,  6797,  6801,  6802,  6810,  6812,
    6813,  6814,  6822,  6826,  6831,  6835,  6837,  6839,  6841,  6844,
    6848,  6854,  6857,  6863,  6866,  6868,  6870,  6872,  6874,  6876,
    6878,  6880,  6882,  6884,  6886,  6888,  6890,  6892,  6894,  6896,
    6898,  6900,  6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,
    6918,  6920,  6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,
    6938,  6940,  6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,
    6958,  6960,  6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,
    6978,  6980,  6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,
    6998,  7000,  7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,
    7018,  7020,  7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,
    7038,  7040,  7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,
    7058,  7060,  7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,
    7078,  7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,
    7098,  7100,  7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,
    7118,  7120,  7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,
    7138,  7140,  7142,  7144,  7146,  7148,  7150,  7152,  7154,  7156,
    7158,  7160,  7162,  7164,  7166,  7168,  7170,  7172,  7174,  7176,
    7178,  7180,  7182,  7184,  7186,  7188,  7190,  7192,  7194,  7196,
    7198,  7200,  7202,  7204,  7206,  7208,  7210,  7212,  7214,  7216,
    7218,  7220,  7222,  7224,  7226,  7228,  7230,  7232,  7234,  7236,
    7238,  7240,  7242,  7244,  7246,  7248,  7250,  7252,  7254,  7256,
    7258,  7260,  7262,  7264,  7266,  7268,  7270,  7272,  7274,  7276,
    7278,  7280,  7282,  7284,  7286,  7288,  7290,  7292,  7294,  7296,
    7298,  7300,  7302,  7304,  7306,  7308,  7310,  7312,  7314,  7316,
    7318,  7320,  7322,  7324,  7326,  7328,  7330,  7332,  7334,  7336,
    7338,  7340,  7342,  7344,  7346,  7348,  7350,  7352,  7354,  7356,
    7358,  7360,  7362,  7364,  7366,  7368,  7370,  7372,  7374,  7376,
    7378,  7380,  7382,  7384,  7386,  7388,  7390,  7392,  7394,  7396,
    7398,  7400,  7402,  7404,  7406,  7408,  7410,  7412,  7414,  7416,
    7418,  7420,  7422,  7424,  7426,  7428,  7430,  7432,  7434,  7436,
    7438,  7440,  7442,  7444,  7446,  7448,  7450,  7452,  7454,  7456,
    7458,  7460,  7462,  7464,  7466,  7468,  7470,  7472,  7474,  7476,
    7478,  7482,  7484,  7485,  7487,  7490,  7492,  7495,  7497,  7499,
    7502,  7505,  7507,  7509,  7511,  7513,  7515,  7517,  7519,  7521,
    7523,  7525,  7527,  7529,  7531,  7533,  7535,  7537,  7540,  7544,
    7546,  7549,  7551,  7555,  7557,  7561,  7563,  7565,  7567,  7569,
    7571,  7573,  7575,  7577,  7579,  7581,  7583,  7585,  7587,  7589,
    7591,  7593,  7595,  7597,  7599,  7601,  7603,  7605,  7607,  7609,
    7611,  7613,  7615,  7617,  7619,  7621,  7623,  7625,  7627,  7629,
    7631,  7633,  7635,  7637,  7639,  7641,  7643,  7645,  7647,  7649,
    7651,  7653,  7655,  7657,  7659,  7661,  7663,  7665,  7667,  7669,
    7671,  7673,  7675,  7677,  7679,  7681,  7683,  7686,  7690,  7693,
    7697,  7699,  7703,  7707,  7711,  7715,  7719,  7723,  7725,  7727,
    7728,  7731,  7734,  7736,  7738,  7741
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     506,     0,    -1,   974,    -1,   774,    -1,   775,    -1,   780,
      -1,   618,    -1,   632,    -1,   732,    -1,   520,    -1,   750,
      -1,   751,    -1,   599,    -1,   545,    -1,   514,    -1,   513,
      -1,   783,    -1,   782,    -1,   636,    -1,   516,    -1,   515,
      -1,   788,    -1,   543,    -1,   555,    -1,   785,    -1,   684,
      -1,   540,    -1,   556,    -1,   976,    -1,   651,    -1,   740,
      -1,   784,    -1,   779,    -1,   616,    -1,   627,    -1,   713,
      -1,   519,    -1,   663,    -1,   669,    -1,   670,    -1,   605,
      -1,   523,    -1,   598,    -1,   565,    -1,   613,    -1,   637,
      -1,   508,    -1,   512,    -1,   633,    -1,   770,    -1,  1118,
      -1,   820,    -1,   653,    -1,   807,    -1,   544,    -1,   652,
      -1,   742,    -1,   617,    -1,   631,    -1,   522,    -1,   673,
      -1,   674,    -1,   675,    -1,   611,    -1,   758,    -1,   677,
      -1,   615,    -1,   650,    -1,   517,    -1,   518,    -1,   635,
      -1,   778,    -1,   800,    -1,   794,    -1,   687,    -1,   690,
      -1,   701,    -1,   705,    -1,   802,    -1,   760,    -1,   769,
      -1,   809,    -1,   759,    -1,   797,    -1,   676,    -1,   744,
      -1,   736,    -1,   735,    -1,   737,    -1,   747,    -1,   691,
      -1,   702,    -1,   978,    -1,   823,    -1,   762,    -1,   682,
      -1,   761,    -1,   813,    -1,   787,    -1,   537,    -1,   527,
      -1,   539,    -1,   767,    -1,  1055,    -1,   981,    -1,   998,
      -1,  1056,    -1,  1038,    -1,  1053,    -1,  1039,    -1,   999,
      -1,  1043,    -1,  1065,    -1,  1057,    -1,  1044,    -1,  1073,
      -1,  1075,    -1,  1068,    -1,  1060,    -1,  1076,    -1,  1079,
      -1,  1081,    -1,    -1,   147,   370,   966,   509,   510,    -1,
     456,    -1,    -1,   510,   511,    -1,    -1,   334,  1108,    -1,
     334,   307,    -1,   192,   334,  1108,    -1,   431,   334,  1108,
      -1,   406,    -1,   301,    -1,   239,    -1,   298,    -1,   148,
      -1,   295,    -1,   149,    -1,   296,    -1,   150,    -1,   297,
      -1,   278,    -1,   299,    -1,   139,   270,   967,    -1,   441,
     436,  1108,    -1,   438,   956,    -1,   408,   965,    -1,    86,
     956,    -1,   370,   956,    -1,   234,   370,   956,    -1,   234,
     222,   956,    -1,   147,   438,   966,   509,   510,    -1,    91,
     370,   966,   509,   510,    -1,    91,   370,   966,   538,    -1,
      91,   438,   966,   509,   510,    -1,    91,   438,   966,   538,
      -1,   187,   370,   956,    -1,   187,   370,   229,   200,   956,
      -1,   187,   438,   956,    -1,   187,   438,   229,   200,   956,
      -1,   147,   222,   966,   509,   510,    -1,    91,   222,   966,
     521,   438,   956,    -1,    85,    -1,   187,    -1,   187,   222,
     956,    -1,   187,   222,   229,   200,   956,    -1,   147,   376,
     524,   104,   966,   525,    -1,   147,   376,   968,   525,    -1,
     968,    -1,    -1,   525,   526,    -1,    -1,   565,    -1,   705,
      -1,   598,    -1,   637,    -1,   690,    -1,   767,    -1,   387,
     528,    -1,   387,   273,   528,    -1,   387,   385,   528,    -1,
     529,   419,   530,    -1,   529,   484,   530,    -1,   529,   419,
     170,    -1,   529,   484,   170,    -1,   529,   215,   153,    -1,
     417,   472,   534,    -1,   421,   765,    -1,   385,   125,    98,
     421,   765,    -1,   121,  1108,    -1,   376,  1108,    -1,   288,
     535,    -1,   370,   536,    -1,   385,   104,   536,    -1,   385,
     104,   170,    -1,   461,   320,   905,    -1,  1088,    -1,   529,
     499,   968,    -1,   531,    -1,   530,   500,   531,    -1,   533,
      -1,   536,    -1,   604,    -1,   350,   430,    -1,   350,   136,
      -1,   360,   350,    -1,   383,    -1,   425,    -1,   204,    -1,
     317,    -1,   313,    -1,  1108,    -1,  1110,    -1,   892,  1108,
     894,    -1,   892,   497,   965,   498,  1108,   894,    -1,   604,
      -1,   170,    -1,   273,    -1,  1108,    -1,   170,    -1,    -1,
     968,    -1,  1108,    -1,   363,   529,    -1,   363,   417,   472,
      -1,   363,   421,   256,   268,    -1,   363,   385,   104,    -1,
     363,    89,    -1,   387,   528,    -1,   537,    -1,   390,   529,
    1121,    -1,   390,   417,   472,  1121,    -1,   390,   421,   256,
     268,  1121,    -1,   390,   385,   104,  1121,    -1,   390,    89,
      -1,   387,   141,   541,   542,    -1,    89,    -1,   954,    -1,
     173,    -1,   231,    -1,   127,    -1,   181,    89,    -1,   181,
     412,    -1,   181,   414,    -1,   181,   336,    -1,    91,   410,
     864,   546,    -1,    91,   237,   955,   546,    -1,    91,   382,
     955,   546,    -1,    91,   450,   955,   546,    -1,   547,    -1,
     546,   500,   547,    -1,    85,   748,   570,    -1,    91,   748,
     968,   548,    -1,    91,   748,   968,   187,   302,   307,    -1,
      91,   748,   968,   387,   302,   307,    -1,    91,   748,   968,
     387,   399,   967,    -1,    91,   748,   968,   387,   402,   968,
      -1,   187,   748,   968,   549,    -1,    91,   748,   968,   749,
     428,   872,   550,    -1,    85,   578,    -1,   187,   140,   957,
     549,    -1,   387,   456,   315,    -1,   387,   457,   315,    -1,
     130,   317,   957,    -1,   387,   457,   130,    -1,   190,   423,
     957,    -1,   190,    92,   423,   957,    -1,   190,   362,   423,
     957,    -1,   190,   423,    89,    -1,   190,   423,   438,    -1,
     180,   423,   957,    -1,   180,   423,    89,    -1,   180,   423,
     438,    -1,   190,   374,   957,    -1,   190,    92,   374,   957,
      -1,   190,   362,   374,   957,    -1,   180,   374,   957,    -1,
     239,   955,    -1,   294,   239,   955,    -1,   330,   419,   966,
      -1,   387,   411,   957,    -1,   387,   551,    -1,   363,   551,
      -1,   387,   170,   896,    -1,   187,   170,    -1,   117,    -1,
     365,    -1,    -1,   439,   896,    -1,    -1,   497,   553,   498,
      -1,   456,   551,    -1,    -1,   554,    -1,   553,   500,   554,
      -1,  1089,   484,   657,    -1,  1089,    -1,  1089,   499,  1089,
     484,   657,    -1,  1089,   499,  1089,    -1,   129,   957,    -1,
     129,    89,    -1,   145,   561,   955,   580,   562,   557,   558,
     563,   509,   559,    -1,   145,   824,   419,   558,   509,   559,
      -1,   215,    -1,   419,    -1,  1108,    -1,   400,    -1,   401,
      -1,   559,   560,    -1,    -1,   110,    -1,   315,    -1,   176,
     781,  1108,    -1,   307,   781,  1108,    -1,   152,    -1,   225,
      -1,   348,   781,  1108,    -1,   195,   781,  1108,    -1,   211,
     348,   581,    -1,   211,   302,   307,   581,    -1,   110,    -1,
      -1,   456,   315,    -1,    -1,   564,   177,  1108,    -1,    -1,
     439,    -1,    -1,   147,   566,   410,   955,   497,   567,   498,
     588,   589,   590,   591,    -1,   147,   566,   410,   955,   312,
     955,   497,   567,   498,   589,   590,   591,    -1,   414,    -1,
     412,    -1,   273,   414,    -1,   273,   412,    -1,   218,   414,
      -1,   218,   412,    -1,    -1,   568,    -1,    -1,   569,    -1,
     568,   500,   569,    -1,   570,    -1,   575,    -1,   578,    -1,
     968,   872,   571,    -1,   571,   572,    -1,    -1,   140,   957,
     573,    -1,   573,    -1,   574,    -1,   302,   307,    -1,   307,
      -1,   433,   729,   592,    -1,   343,   258,   729,   592,    -1,
     126,   497,   896,   498,    -1,   170,   897,    -1,   355,   955,
     580,   583,   584,    -1,   172,    -1,   302,   172,    -1,   241,
     173,    -1,   241,   231,    -1,   269,   955,   576,    -1,   576,
     577,    -1,    -1,   235,   171,    -1,   197,   171,    -1,   235,
     141,    -1,   197,   141,    -1,   235,   238,    -1,   197,   238,
      -1,   140,   957,   579,    -1,   579,    -1,   126,   497,   896,
     498,    -1,   433,   497,   581,   498,   729,   592,    -1,   343,
     258,   497,   581,   498,   729,   592,    -1,   212,   258,   497,
     581,   498,   355,   955,   580,   583,   584,   647,    -1,   497,
     581,   498,    -1,    -1,   582,    -1,   581,   500,   582,    -1,
     968,    -1,   280,   216,    -1,   280,   332,    -1,   280,   392,
      -1,    -1,   585,    -1,   586,    -1,   585,   586,    -1,   586,
     585,    -1,    -1,   317,   437,   587,    -1,   317,   175,   587,
      -1,   294,    84,    -1,   365,    -1,   117,    -1,   387,   307,
      -1,   387,   170,    -1,   240,   497,   954,   498,    -1,    -1,
     456,   551,    -1,   456,   315,    -1,   457,   315,    -1,    -1,
     317,   135,   187,    -1,   317,   135,   175,   373,    -1,   317,
     135,   340,   373,    -1,    -1,   411,   957,    -1,    -1,   439,
     237,   411,   957,    -1,    -1,   955,   594,   589,   590,   591,
      -1,   497,   595,   498,    -1,    -1,   596,    -1,   595,   500,
     596,    -1,   968,    -1,   456,   163,    -1,   456,   294,   163,
      -1,    -1,   147,   566,   382,   955,   600,    -1,    91,   382,
     955,   601,    -1,   601,    -1,    -1,   602,    -1,   601,   602,
      -1,   115,   604,    -1,   162,    -1,   294,   162,    -1,   236,
     603,   604,    -1,   281,   604,    -1,   283,   604,    -1,   294,
     281,    -1,   294,   283,    -1,   329,   114,   680,    -1,   397,
     509,   604,    -1,   364,    -1,   364,   509,   604,    -1,   114,
      -1,    -1,  1107,    -1,   489,  1107,    -1,   967,    -1,   147,
     606,   612,   260,   536,    -1,   147,   606,   612,   260,   536,
     223,   607,   609,   610,    -1,   427,    -1,    -1,   957,    -1,
     957,   681,    -1,   442,   607,    -1,   294,   442,    -1,   608,
      -1,    -1,   259,  1108,    -1,    -1,   187,   612,   260,   536,
     549,    -1,   187,   612,   260,   229,   200,   536,   549,    -1,
     346,    -1,    -1,   147,   411,   957,   614,   276,  1108,    -1,
     330,   957,    -1,    -1,   187,   411,   957,    -1,   187,   411,
     229,   200,   957,    -1,   147,   212,   163,   459,   957,   609,
     619,    -1,   187,   212,   163,   459,   957,   549,    -1,   187,
     212,   163,   459,   229,   200,   957,   549,    -1,    91,   212,
     163,   459,   957,   608,   621,    -1,    91,   212,   163,   459,
     957,   608,    -1,    91,   212,   163,   459,   957,   621,    -1,
     321,   497,   620,   498,    -1,    -1,   624,    -1,   620,   500,
     624,    -1,   321,   497,   622,   498,    -1,   623,    -1,   622,
     500,   623,    -1,   624,    -1,   387,   624,    -1,    85,   624,
      -1,   187,   625,    -1,   625,   626,    -1,  1089,    -1,  1108,
      -1,   147,   384,   957,   628,   630,   212,   163,   459,   957,
     619,    -1,   428,  1108,    -1,    -1,   449,  1108,    -1,   449,
     307,    -1,   629,    -1,    -1,   187,   384,   957,   549,    -1,
     187,   384,   229,   200,   957,   549,    -1,    91,   384,   957,
     629,   621,    -1,    91,   384,   957,   629,    -1,    91,   384,
     957,   621,    -1,   147,   438,   279,   210,   634,   384,   957,
     619,    -1,   160,    -1,   438,    -1,   966,    -1,   187,   438,
     279,   210,   634,   384,   957,    -1,   187,   438,   279,   229,
     200,   210,   634,   384,   957,    -1,    91,   438,   279,   210,
     634,   384,   957,   621,    -1,   147,   423,   957,   638,   639,
     317,   955,   641,   199,   347,   963,   497,   644,   498,    -1,
     147,   140,   423,   957,    87,   639,   317,   955,   646,   647,
     210,   188,   372,   199,   347,   963,   497,   644,   498,    -1,
     106,    -1,    87,    -1,   640,    -1,   639,   322,   640,    -1,
     246,    -1,   175,    -1,   437,    -1,   426,    -1,   210,   642,
     643,    -1,    -1,   188,    -1,    -1,   372,    -1,   398,    -1,
     645,    -1,   644,   500,   645,    -1,    -1,   965,    -1,  1107,
      -1,  1108,    -1,  1106,    -1,   480,    -1,   968,    -1,   215,
     955,    -1,    -1,   648,    -1,   648,   649,    -1,   649,    -1,
     649,   648,    -1,    -1,   302,   172,    -1,   172,    -1,   241,
     231,    -1,   241,   173,    -1,   187,   423,   957,   317,   955,
     549,    -1,   187,   423,   229,   200,   957,   317,   955,   549,
      -1,   147,   100,   957,   126,   497,   896,   498,   647,    -1,
     187,   100,   957,   549,    -1,   147,    88,   963,   658,   654,
      -1,   147,    88,   963,   659,    -1,   147,   319,   739,   654,
      -1,   147,   428,   680,   654,    -1,   147,   428,   680,    -1,
     147,   428,   680,    98,   497,   870,   498,    -1,   147,   428,
     680,    98,   194,   497,   662,   498,    -1,   147,   415,   378,
     331,   680,   654,    -1,   147,   415,   378,   179,   680,   654,
      -1,   147,   415,   378,   413,   680,   654,    -1,   147,   415,
     378,   138,   680,   654,    -1,   497,   655,   498,    -1,   656,
      -1,   655,   500,   656,    -1,  1089,   484,   657,    -1,  1089,
      -1,   723,    -1,   972,    -1,   922,    -1,   604,    -1,  1108,
      -1,   497,   925,   498,    -1,   497,   490,   498,    -1,   497,
     660,   498,    -1,   661,    -1,   660,   500,   661,    -1,  1110,
     484,   657,    -1,  1108,    -1,   662,   500,  1108,    -1,   147,
     319,   128,   680,   666,   210,   428,   872,   439,   959,   667,
      98,   664,    -1,   665,    -1,   664,   500,   665,    -1,   319,
     965,   739,   668,    -1,   319,   965,   739,   738,   668,    -1,
     217,   965,   963,   715,    -1,   217,   965,   497,   925,   498,
     963,   715,    -1,   402,   872,    -1,   170,    -1,    -1,   205,
     680,    -1,    -1,   353,    -1,    -1,   147,   319,   205,   680,
     439,   959,    -1,    91,   319,   205,   680,   439,   959,    85,
     664,    -1,    91,   319,   205,   680,   439,   959,   187,   671,
      -1,   672,    -1,   671,   500,   672,    -1,   319,   965,   497,
     925,   498,    -1,   217,   965,   497,   925,   498,    -1,   187,
     319,   128,   680,   439,   959,   549,    -1,   187,   319,   128,
     229,   200,   680,   439,   959,   549,    -1,   187,   319,   205,
     680,   439,   959,   549,    -1,   187,   319,   205,   229,   200,
     680,   439,   959,   549,    -1,   187,   329,   114,   956,   549,
      -1,   352,   329,   114,   956,   419,   957,    -1,   187,   678,
     229,   200,   679,   549,    -1,   187,   678,   679,   549,    -1,
     410,    -1,   382,    -1,   450,    -1,   237,    -1,   428,    -1,
     185,    -1,   144,    -1,   376,    -1,   415,   378,   331,    -1,
     415,   378,   179,    -1,   415,   378,   413,    -1,   415,   378,
     138,    -1,   680,    -1,   679,   500,   680,    -1,   968,    -1,
     968,   681,    -1,   499,   960,    -1,   681,   499,   960,    -1,
     426,   833,   865,   683,   549,    -1,   143,   228,    -1,   364,
     228,    -1,    -1,   134,   317,   685,   680,   254,   686,    -1,
     134,   317,    88,   963,   658,   254,   686,    -1,   134,   317,
     217,   963,   715,   254,   686,    -1,   134,   317,   319,   739,
     738,   254,   686,    -1,   134,   317,   140,   957,   317,   680,
     254,   686,    -1,   134,   317,   374,   957,   317,   680,   254,
     686,    -1,   134,   317,   374,   957,   254,   686,    -1,   134,
     317,   423,   957,   317,   680,   254,   686,    -1,   134,   317,
     319,   128,   680,   439,   959,   254,   686,    -1,   134,   317,
     319,   205,   680,   439,   959,   254,   686,    -1,   134,   317,
     261,   311,   604,   254,   686,    -1,   134,   317,   120,   497,
     872,    98,   872,   498,   254,   686,    -1,   134,   317,   612,
     260,   680,   254,   686,    -1,   134,   317,   415,   378,   331,
     680,   254,   686,    -1,   134,   317,   415,   378,   179,   680,
     254,   686,    -1,   134,   317,   415,   378,   413,   680,   254,
     686,    -1,   134,   317,   415,   378,   138,   680,   254,   686,
      -1,   133,    -1,   164,    -1,   376,    -1,   237,    -1,   382,
      -1,   410,    -1,   185,    -1,   428,    -1,   450,    -1,   144,
      -1,   411,    -1,   370,    -1,  1108,    -1,   307,    -1,   206,
     688,   689,   957,    -1,   206,   957,    -1,   286,   688,   689,
     957,    -1,   286,   957,    -1,   206,   688,   689,   957,  1121,
      -1,   206,   688,   957,  1121,    -1,   206,   689,   957,  1121,
      -1,   206,   957,  1121,    -1,   206,   688,   957,    -1,   206,
     689,   957,    -1,   293,    -1,   344,    -1,   207,    -1,   262,
      -1,    82,   967,    -1,   357,   967,    -1,   967,    -1,    89,
      -1,   213,    -1,   213,   967,    -1,   213,    89,    -1,   105,
      -1,   105,   967,    -1,   105,    89,    -1,   215,    -1,   234,
      -1,   219,   692,   317,   695,   419,   696,   698,    -1,   368,
     692,   317,   695,   215,   696,   549,    -1,   368,   219,   320,
     210,   692,   317,   695,   215,   696,   549,    -1,   693,    -1,
      89,    -1,    89,   345,    -1,    89,   497,   581,   498,    -1,
      89,   345,   497,   581,   498,    -1,   694,    -1,   693,   500,
     694,    -1,   381,   580,    -1,   355,   580,    -1,   147,   580,
      -1,   968,   580,    -1,   954,    -1,   410,   954,    -1,   382,
     954,    -1,   212,   163,   459,   956,    -1,   212,   384,   956,
      -1,   217,   699,    -1,   164,   956,    -1,   260,   956,    -1,
     376,   956,    -1,   411,   956,    -1,   697,    -1,   696,   500,
     697,    -1,   966,    -1,   222,   966,    -1,   456,   219,   320,
      -1,    -1,   700,    -1,   699,   500,   700,    -1,   963,   715,
      -1,   219,   693,   419,   956,   703,   704,    -1,   368,   693,
     215,   956,   704,   549,    -1,   368,    86,   320,   210,   693,
     215,   956,   704,   549,    -1,   456,    86,   320,    -1,    -1,
     220,   114,   966,    -1,    -1,   147,   706,   237,   961,   317,
     955,   707,   497,   708,   498,   552,   591,   868,    -1,   147,
     706,   237,   137,   961,   317,   955,   707,   497,   708,   498,
     552,   591,   868,    -1,   433,    -1,    -1,   439,   959,    -1,
      -1,   709,    -1,   708,   500,   709,    -1,   968,   710,   711,
     712,    -1,   899,   710,   711,   712,    -1,   497,   896,   498,
     710,   711,   712,    -1,   680,    -1,   439,   680,    -1,    -1,
      99,    -1,   178,    -1,    -1,   473,    -1,   474,    -1,    -1,
     147,   714,   217,   963,   717,   367,   722,   725,   729,    -1,
     147,   714,   217,   963,   717,   367,   410,   497,   731,   498,
     725,   729,    -1,   147,   714,   217,   963,   717,   725,   729,
      -1,   322,   361,    -1,    -1,   497,   716,   498,    -1,   497,
     498,    -1,   719,    -1,   716,   500,   719,    -1,   497,   718,
     498,    -1,   497,   498,    -1,   724,    -1,   718,   500,   724,
      -1,   720,   721,   723,    -1,   721,   720,   723,    -1,   721,
     723,    -1,   720,   723,    -1,   723,    -1,   234,    -1,   324,
      -1,   243,    -1,   234,   324,    -1,   446,    -1,   969,    -1,
     723,    -1,   872,    -1,   969,   681,   492,   428,    -1,   388,
     969,   681,   492,   428,    -1,   719,    -1,   719,   170,   896,
      -1,   719,   484,   896,    -1,   727,    -1,   725,   727,    -1,
     116,   317,   307,   244,    -1,   367,   307,   317,   307,   244,
      -1,   403,    -1,   232,    -1,   395,    -1,   451,    -1,   202,
     380,   174,    -1,   202,   380,   253,    -1,   380,   174,    -1,
     380,   253,    -1,   146,   604,    -1,   373,   604,    -1,   538,
      -1,    98,   728,    -1,   260,   536,    -1,   455,    -1,   726,
      -1,  1108,    -1,  1108,   500,  1108,    -1,   456,   654,    -1,
      -1,   721,   723,    -1,   730,    -1,   731,   500,   730,    -1,
      91,   217,   700,   733,   734,    -1,   726,    -1,   733,   726,
      -1,   365,    -1,    -1,   187,   217,   963,   715,   549,    -1,
     187,   217,   229,   200,   963,   715,   549,    -1,   187,    88,
     963,   658,   549,    -1,   187,    88,   229,   200,   963,   658,
     549,    -1,   187,   319,   739,   738,   549,    -1,   187,   319,
     229,   200,   739,   738,   549,    -1,   497,   872,   498,    -1,
     497,   872,   500,   872,   498,    -1,   497,   300,   500,   872,
     498,    -1,   497,   872,   500,   300,   498,    -1,   919,    -1,
     968,   499,   739,    -1,   147,   120,   497,   872,    98,   872,
     498,   456,   217,   700,   741,    -1,   147,   120,   497,   872,
      98,   872,   498,   457,   217,   741,    -1,   147,   120,   497,
     872,    98,   872,   498,   456,   243,   741,    -1,    98,   233,
      -1,    98,   101,    -1,    -1,   187,   120,   743,   497,   872,
      98,   872,   498,   549,    -1,   229,   200,    -1,    -1,   356,
     745,   955,   746,    -1,   356,   409,   957,   746,    -1,   356,
     164,   957,   746,    -1,   237,    -1,   410,    -1,   211,    -1,
      -1,    91,    88,   963,   658,   359,   419,   957,    -1,    91,
     144,   680,   359,   419,   957,    -1,    91,   164,   958,   359,
     419,   958,    -1,    91,   217,   700,   359,   419,   957,    -1,
      91,   222,   966,   359,   419,   966,    -1,    91,   612,   260,
     957,   359,   419,   957,    -1,    91,   319,   128,   680,   439,
     959,   359,   419,   957,    -1,    91,   319,   205,   680,   439,
     959,   359,   419,   957,    -1,    91,   376,   957,   359,   419,
     957,    -1,    91,   410,   864,   359,   419,   957,    -1,    91,
     382,   955,   359,   419,   957,    -1,    91,   450,   955,   359,
     419,   957,    -1,    91,   237,   955,   359,   419,   957,    -1,
      91,   410,   864,   359,   748,   957,   419,   957,    -1,    91,
     423,   957,   317,   955,   359,   419,   957,    -1,    91,   370,
     966,   359,   419,   966,    -1,    91,   438,   966,   359,   419,
     966,    -1,    91,   411,   957,   359,   419,   957,    -1,    91,
     415,   378,   331,   680,   359,   419,   957,    -1,    91,   415,
     378,   179,   680,   359,   419,   957,    -1,    91,   415,   378,
     413,   680,   359,   419,   957,    -1,    91,   415,   378,   138,
     680,   359,   419,   957,    -1,    91,   428,   680,   359,   419,
     957,    -1,   133,    -1,    -1,   387,   163,    -1,    -1,    91,
      88,   963,   658,   387,   376,   957,    -1,    91,   185,   680,
     387,   376,   957,    -1,    91,   217,   700,   387,   376,   957,
      -1,    91,   410,   864,   387,   376,   957,    -1,    91,   382,
     955,   387,   376,   957,    -1,    91,   450,   955,   387,   376,
     957,    -1,    91,   428,   680,   387,   376,   957,    -1,    91,
      88,   963,   658,   330,   419,   966,    -1,    91,   144,   680,
     330,   419,   966,    -1,    91,   164,   958,   330,   419,   966,
      -1,    91,   185,   680,   330,   419,   966,    -1,    91,   217,
     700,   330,   419,   966,    -1,    91,   612,   260,   957,   330,
     419,   966,    -1,    91,   319,   739,   738,   330,   419,   966,
      -1,    91,   319,   128,   680,   439,   959,   330,   419,   966,
      -1,    91,   319,   205,   680,   439,   959,   330,   419,   966,
      -1,    91,   376,   957,   330,   419,   966,    -1,    91,   428,
     680,   330,   419,   966,    -1,    91,   411,   957,   330,   419,
     966,    -1,    91,   415,   378,   179,   680,   330,   419,   966,
      -1,    91,   415,   378,   138,   680,   330,   419,   966,    -1,
      91,   212,   163,   459,   957,   330,   419,   966,    -1,    91,
     384,   957,   330,   419,   966,    -1,   303,    -1,   754,    -1,
     497,   753,   498,    -1,   753,   501,   755,    -1,   755,    -1,
     823,    -1,   802,    -1,   813,    -1,   807,    -1,   759,    -1,
     754,    -1,    -1,   381,    -1,   437,    -1,   175,    -1,   246,
      -1,   247,    -1,    90,    -1,    -1,   187,   374,   957,   317,
     955,   549,    -1,   187,   374,   229,   200,   957,   317,   955,
     549,    -1,   304,   968,    -1,   271,   968,    -1,   435,   968,
      -1,   435,   490,    -1,    81,   763,    -1,   107,   763,   766,
      -1,   397,   421,   766,    -1,   135,   763,    -1,   193,   763,
      -1,   371,   763,    -1,   375,   968,    -1,   358,   375,   968,
      -1,   358,   968,    -1,   371,   763,   419,   375,   968,    -1,
     371,   763,   419,   968,    -1,   341,   421,  1108,    -1,   135,
     342,  1108,    -1,   371,   342,  1108,    -1,   458,    -1,   421,
      -1,    -1,   256,   268,   532,    -1,   350,   318,    -1,   350,
     460,    -1,   764,    -1,   765,   500,   764,    -1,   765,   764,
      -1,   765,    -1,    -1,   147,   566,   450,   955,   580,    98,
     823,   768,    -1,   147,   322,   361,   566,   450,   955,   580,
      98,   823,   768,    -1,   456,   126,   320,    -1,   456,   118,
     126,   320,    -1,   456,   273,   126,   320,    -1,    -1,   272,
     962,    -1,   147,   164,   958,   509,   771,    -1,   771,   772,
      -1,    -1,   411,   773,   957,    -1,   411,   773,   170,    -1,
     276,   773,  1108,    -1,   276,   773,   170,    -1,   413,   773,
     957,    -1,   413,   773,   170,    -1,   191,   773,  1108,    -1,
     191,   773,   965,    -1,   191,   773,   170,    -1,   263,   773,
    1108,    -1,   263,   773,   170,    -1,   264,   773,  1108,    -1,
     264,   773,   170,    -1,   139,   270,   773,   967,    -1,   330,
     773,   957,    -1,   330,   773,   170,    -1,   484,    -1,    -1,
      91,   164,   958,   509,   776,    -1,    91,   164,   958,   387,
     411,   957,    -1,    91,   164,   958,   538,    -1,   776,   777,
      -1,    -1,   139,   270,   773,   967,    -1,   187,   164,   958,
      -1,   187,   164,   229,   200,   958,    -1,   147,   185,   680,
     781,   872,   571,    -1,    91,   185,   680,   548,    -1,    91,
     185,   680,   187,   302,   307,    -1,    91,   185,   680,   387,
     302,   307,    -1,    91,   185,   680,    85,   578,    -1,    91,
     185,   680,   187,   140,   957,   549,    -1,    98,    -1,    -1,
      91,   415,   378,   179,   680,   654,    -1,    91,   415,   378,
     138,   680,    85,   279,   210,   956,   456,   679,    -1,    91,
     415,   378,   138,   680,    91,   279,   210,   956,   456,   679,
      -1,    91,   415,   378,   138,   680,    91,   279,   361,   680,
     456,   680,    -1,    91,   415,   378,   138,   680,    91,   279,
     210,   956,   361,   680,   456,   680,    -1,    91,   415,   378,
     138,   680,   187,   279,   210,   956,    -1,    91,   415,   378,
     138,   680,   187,   279,   229,   200,   210,   956,    -1,   147,
     666,   144,   680,   210,  1108,   419,  1108,   215,   680,    -1,
     130,   790,   955,   786,    -1,   130,   790,    -1,   130,   790,
     961,   317,   955,    -1,   439,   961,    -1,    -1,   440,   791,
     792,   790,    -1,   440,   791,   792,   790,   955,    -1,   440,
     791,   792,   790,   788,    -1,   789,   790,    -1,   789,   790,
     955,   793,    -1,    94,    -1,    93,    -1,   448,    -1,    -1,
     216,    -1,    -1,   214,    -1,    -1,   497,   956,   498,    -1,
      -1,   201,   796,   790,   795,    -1,   823,    -1,   802,    -1,
     813,    -1,   807,    -1,   820,    -1,   976,    -1,   800,    -1,
     789,    -1,    -1,   341,   997,   798,    98,   799,    -1,   341,
     997,   215,  1042,    -1,   497,   925,   498,    -1,    -1,   823,
      -1,   802,    -1,   813,    -1,   807,    -1,   199,   997,   801,
    1120,    -1,   147,   566,   410,   593,    98,   199,   997,   801,
      -1,   497,   924,   498,    -1,    -1,   246,   252,   955,   803,
     806,    -1,   823,    -1,   497,   804,   498,   823,    -1,   170,
     444,    -1,   805,    -1,   804,   500,   805,    -1,   968,   946,
      -1,   366,   951,    -1,    -1,   175,   215,   866,   808,   869,
     806,    -1,   439,   857,    -1,    -1,   277,   833,   865,   810,
     812,    -1,   234,   811,   284,    -1,    -1,    83,   389,    -1,
     372,   389,    -1,   372,   198,    -1,   389,   437,   198,    -1,
     389,    -1,   389,   372,   198,    -1,   198,    -1,    83,   198,
      -1,   306,    -1,    -1,   437,   866,   387,   814,   856,   869,
     806,    -1,   815,    -1,   814,   500,   815,    -1,   816,    -1,
     817,    -1,   818,   484,   948,    -1,   497,   819,   498,   484,
     950,    -1,   968,   946,    -1,   818,    -1,   819,   500,   818,
      -1,   169,   957,   821,   161,   822,   210,   823,    -1,    -1,
     821,   294,   377,    -1,   821,   377,    -1,   821,   110,    -1,
     821,   245,    -1,    -1,   456,   226,    -1,   457,   226,    -1,
     825,    -1,   824,    -1,   497,   825,   498,    -1,   497,   824,
     498,    -1,   827,    -1,   826,   837,    -1,   826,   836,   850,
     841,    -1,   826,   836,   840,   851,    -1,   828,   827,    -1,
     828,   826,   837,    -1,   828,   826,   836,   850,   841,    -1,
     828,   826,   836,   840,   851,    -1,   827,    -1,   824,    -1,
     381,   835,   951,   831,   856,   868,   848,   849,   907,    -1,
     855,    -1,   410,   864,    -1,   826,   432,   834,   826,    -1,
     826,   250,   834,   826,    -1,   826,   196,   834,   826,    -1,
     456,   829,    -1,   456,   354,   829,    -1,   830,    -1,   829,
     500,   830,    -1,   957,   793,    98,   824,    -1,   252,   832,
      -1,  1121,    -1,    -1,   414,   833,   955,    -1,   412,   833,
     955,    -1,   273,   414,   833,   955,    -1,   273,   412,   833,
     955,    -1,   218,   414,   833,   955,    -1,   218,   412,   833,
     955,    -1,   410,   955,    -1,   955,    -1,   410,    -1,    -1,
      89,    -1,   182,    -1,    -1,   182,    -1,   182,   317,   497,
     924,   498,    -1,    89,    -1,    -1,   837,    -1,    -1,   323,
     114,   838,    -1,   839,    -1,   838,   500,   839,    -1,   896,
     439,   922,   712,    -1,   896,   711,   712,    -1,   270,   842,
     314,   844,    -1,   314,   844,   270,   842,    -1,   270,   842,
      -1,   314,   844,    -1,   270,   842,   500,   844,    -1,   314,
     845,   846,    -1,   206,   847,   843,   846,   318,    -1,   314,
     845,   846,   206,   847,   843,   846,   318,    -1,   840,    -1,
      -1,   896,    -1,    89,    -1,   967,    -1,   497,   896,   498,
      -1,    -1,   896,    -1,   898,    -1,   372,    -1,   373,    -1,
     207,    -1,   293,    -1,   222,   114,   924,    -1,    -1,   224,
     896,    -1,    -1,   852,    -1,   210,   350,   318,    -1,   850,
      -1,    -1,   853,    -1,   852,   853,    -1,   210,   437,   854,
     812,    -1,   210,   389,   854,   812,    -1,   312,   954,    -1,
      -1,   444,   950,    -1,   855,   500,   950,    -1,   215,   857,
      -1,    -1,   858,    -1,   857,   500,   858,    -1,   864,    -1,
     864,   860,    -1,   867,    -1,   867,   860,    -1,   867,    98,
     497,   870,   498,    -1,   867,    98,   968,   497,   870,   498,
      -1,   867,   968,   497,   870,   498,    -1,   824,    -1,   824,
     860,    -1,   859,    -1,   497,   859,   498,   860,    -1,   497,
     859,   498,    -1,   858,   151,   257,   858,    -1,   858,   861,
     257,   858,   863,    -1,   858,   257,   858,   863,    -1,   858,
     290,   861,   257,   858,    -1,   858,   290,   257,   858,    -1,
      98,   968,   497,   956,   498,    -1,    98,   968,    -1,   968,
     497,   956,   498,    -1,   968,    -1,   216,   862,    -1,   267,
     862,    -1,   369,   862,    -1,   242,    -1,   325,    -1,    -1,
     439,   497,   956,   498,    -1,   317,   896,    -1,   955,    -1,
     955,   490,    -1,   318,   955,    -1,   318,   497,   955,   498,
      -1,   864,    -1,   865,   500,   864,    -1,   864,    -1,   864,
     968,    -1,   864,    98,   968,    -1,   899,    -1,   453,   896,
      -1,    -1,   453,   896,    -1,   453,   153,   312,   957,    -1,
     453,   153,   312,  1105,    -1,    -1,   871,    -1,   870,   500,
     871,    -1,   968,   872,    -1,   874,   873,    -1,   388,   874,
     873,    -1,   874,    97,   495,   965,   496,    -1,   388,   874,
      97,   495,   965,   496,    -1,   874,    97,    -1,   388,   874,
      97,    -1,   873,   495,   496,    -1,   873,   495,  1119,   496,
      -1,    -1,   876,    -1,   878,    -1,   880,    -1,   884,    -1,
     891,    -1,   892,   894,    -1,   892,   497,   965,   498,   894,
      -1,   878,    -1,   881,    -1,   885,    -1,   891,    -1,   969,
     877,    -1,   969,   681,   877,    -1,   497,   924,   498,    -1,
      -1,   248,    -1,   249,    -1,   393,    -1,   109,    -1,   351,
      -1,   208,   879,    -1,   186,   339,    -1,   168,   877,    -1,
     167,   877,    -1,   310,   877,    -1,   112,    -1,   497,   965,
     498,    -1,    -1,   882,    -1,   883,    -1,   882,    -1,   883,
      -1,   111,   889,   497,   924,   498,    -1,   111,   889,    -1,
     886,    -1,   887,    -1,   886,    -1,   887,    -1,   888,   497,
     965,   498,   890,    -1,   888,   890,    -1,   124,   889,    -1,
     123,   889,    -1,   445,    -1,   289,   124,   889,    -1,   289,
     123,   889,    -1,   291,   889,    -1,   447,    -1,    -1,   124,
     387,   968,    -1,    -1,   418,   497,   965,   498,   893,    -1,
     418,   893,    -1,   417,   497,   965,   498,   893,    -1,   417,
     893,    -1,   251,    -1,   475,   472,    -1,   457,   417,   472,
      -1,    -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,
     282,    -1,   895,    -1,   470,   419,   285,    -1,   165,   419,
     227,    -1,   165,   419,   282,    -1,   165,   419,   895,    -1,
     227,   419,   282,    -1,   227,   419,   895,    -1,   282,   419,
     895,    -1,    -1,   379,    -1,   379,   497,   965,   498,    -1,
     898,    -1,   896,    71,   872,    -1,   896,   103,   417,   472,
     896,    -1,   488,   896,    -1,   489,   896,    -1,   896,   488,
     896,    -1,   896,   489,   896,    -1,   896,   490,   896,    -1,
     896,   491,   896,    -1,   896,   492,   896,    -1,   896,   493,
     896,    -1,   896,   485,   896,    -1,   896,   486,   896,    -1,
     896,   484,   896,    -1,   896,   921,   896,    -1,   921,   896,
      -1,   896,   921,    -1,   896,    95,   896,    -1,   896,   322,
     896,    -1,   302,   896,    -1,   896,   269,   896,    -1,   896,
     269,   896,   195,   896,    -1,   896,   302,   269,   896,    -1,
     896,   302,   269,   896,   195,   896,    -1,   896,   230,   896,
      -1,   896,   230,   896,   195,   896,    -1,   896,   302,   230,
     896,    -1,   896,   302,   230,   896,   195,   896,    -1,   896,
     391,   419,   896,    -1,   896,   391,   419,   896,   195,   896,
      -1,   896,   302,   391,   419,   896,    -1,   896,   302,   391,
     419,   896,   195,   896,    -1,   896,   254,   307,    -1,   896,
     255,    -1,   896,   254,   302,   307,    -1,   896,   305,    -1,
     917,   327,   917,    -1,   896,   254,   425,    -1,   896,   254,
     302,   425,    -1,   896,   254,   204,    -1,   896,   254,   302,
     204,    -1,   896,   254,   434,    -1,   896,   254,   302,   434,
      -1,   896,   254,   182,   215,   896,    -1,   896,   254,   302,
     182,   215,   896,    -1,   896,   254,   312,   497,   925,   498,
      -1,   896,   254,   302,   312,   497,   925,   498,    -1,   896,
     108,   947,   897,    95,   897,    -1,   896,   302,   108,   947,
     897,    95,   897,    -1,   896,   108,   407,   897,    95,   897,
      -1,   896,   302,   108,   407,   897,    95,   897,    -1,   896,
     234,   937,    -1,   896,   302,   234,   937,    -1,   896,   923,
     918,   824,    -1,   896,   923,   918,   497,   896,   498,    -1,
     433,   824,    -1,   896,   254,   184,    -1,   896,   254,   302,
     184,    -1,   898,    -1,   897,    71,   872,    -1,   488,   897,
      -1,   489,   897,    -1,   897,   488,   897,    -1,   897,   489,
     897,    -1,   897,   490,   897,    -1,   897,   491,   897,    -1,
     897,   492,   897,    -1,   897,   493,   897,    -1,   897,   485,
     897,    -1,   897,   486,   897,    -1,   897,   484,   897,    -1,
     897,   921,   897,    -1,   921,   897,    -1,   897,   921,    -1,
     897,   254,   182,   215,   897,    -1,   897,   254,   302,   182,
     215,   897,    -1,   897,   254,   312,   497,   925,   498,    -1,
     897,   254,   302,   312,   497,   925,   498,    -1,   897,   254,
     184,    -1,   897,   254,   302,   184,    -1,   943,    -1,   964,
      -1,  1105,   946,    -1,   497,   896,   498,   946,    -1,   938,
      -1,   899,    -1,   824,    -1,   200,   824,    -1,    97,   824,
      -1,    97,   926,    -1,   917,    -1,   963,   497,   498,   910,
      -1,   963,   497,   924,   498,   910,    -1,   963,   497,   446,
     896,   498,   910,    -1,   963,   497,   924,   500,   446,   896,
     498,   910,    -1,   963,   497,    89,   924,   498,   910,    -1,
     963,   497,   182,   924,   498,   910,    -1,   963,   497,   490,
     498,   910,    -1,   155,    -1,   158,    -1,   158,   497,   965,
     498,    -1,   159,    -1,   159,   497,   965,   498,    -1,   274,
      -1,   274,   497,   965,   498,    -1,   275,    -1,   275,   497,
     965,   498,    -1,   156,    -1,   160,    -1,   386,    -1,   438,
      -1,   154,    -1,   157,    -1,   120,   497,   896,    98,   872,
     498,    -1,   203,   497,   928,   498,    -1,   328,   497,   930,
     498,    -1,   337,   497,   932,   498,    -1,   405,   497,   933,
     498,    -1,   422,   497,   896,    98,   872,   498,    -1,   424,
     497,   113,   936,   498,    -1,   424,   497,   265,   936,   498,
      -1,   424,   497,   420,   936,   498,    -1,   424,   497,   936,
     498,    -1,   308,   497,   896,   500,   896,   498,    -1,   131,
     497,   924,   498,    -1,   221,   497,   924,   498,    -1,   266,
     497,   924,   498,    -1,   463,   497,   924,   498,    -1,   464,
     497,   287,  1089,   498,    -1,   464,   497,   287,  1089,   500,
     902,   498,    -1,   464,   497,   287,  1089,   500,   924,   498,
      -1,   464,   497,   287,  1089,   500,   902,   500,   924,   498,
      -1,   465,   497,   903,   498,    -1,   466,   497,   905,   896,
     906,   498,    -1,   467,   497,   287,  1089,   498,    -1,   467,
     497,   287,  1089,   500,   896,   498,    -1,   468,   497,   896,
     500,   900,   901,   498,    -1,   469,   497,   905,   896,    98,
     874,   498,    -1,   449,   896,    -1,   449,   294,   443,    -1,
     500,   396,   471,    -1,   500,   396,   294,    -1,   500,   396,
     294,   443,    -1,    -1,   462,   497,   903,   498,    -1,   904,
      -1,   903,   500,   904,    -1,   896,    98,  1089,    -1,   896,
      -1,   184,    -1,   142,    -1,   340,   454,    -1,   404,   454,
      -1,    -1,   455,   908,    -1,    -1,   909,    -1,   908,   500,
     909,    -1,   968,    98,   911,    -1,   326,   911,    -1,   326,
     968,    -1,    -1,   497,   912,   913,   836,   914,   498,    -1,
     968,    -1,    -1,   333,   114,   924,    -1,    -1,   349,   915,
      -1,   373,   915,    -1,    -1,   916,    -1,   108,   916,    95,
     916,    -1,   429,   338,    -1,   429,   209,    -1,   153,   372,
      -1,   372,   497,   924,   498,    -1,   372,   497,   498,    -1,
     497,   924,   500,   896,   498,    -1,    96,    -1,   394,    -1,
      89,    -1,   481,    -1,   920,    -1,   488,    -1,   489,    -1,
     490,    -1,   491,    -1,   492,    -1,   493,    -1,   485,    -1,
     486,    -1,   484,    -1,   481,    -1,   319,   497,   739,   498,
      -1,   919,    -1,   319,   497,   739,   498,    -1,   919,    -1,
     319,   497,   739,   498,    -1,   269,    -1,   302,   269,    -1,
     230,    -1,   302,   230,    -1,   896,    -1,   924,   500,   896,
      -1,   872,    -1,   925,   500,   872,    -1,   495,   924,   496,
      -1,   495,   927,   496,    -1,   495,   496,    -1,   926,    -1,
     927,   500,   926,    -1,   929,   215,   896,    -1,    -1,  1110,
      -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,   282,
      -1,   379,    -1,  1108,    -1,   896,   931,   934,   935,    -1,
     896,   931,   934,    -1,   335,   896,    -1,   897,   234,   897,
      -1,    -1,   896,   934,   935,    -1,   896,   935,   934,    -1,
     896,   934,    -1,   896,   935,    -1,   924,    -1,    -1,   215,
     896,    -1,   210,   896,    -1,   896,   215,   924,    -1,   215,
     924,    -1,   924,    -1,   824,    -1,   497,   924,   498,    -1,
     119,   942,   939,   941,   193,    -1,   940,    -1,   939,   940,
      -1,   452,   896,   416,   896,    -1,   189,   896,    -1,    -1,
     896,    -1,    -1,   953,    -1,   953,   945,    -1,   499,   960,
      -1,   499,   490,    -1,   495,   896,   496,    -1,   495,   896,
     502,   896,   496,    -1,   944,    -1,   945,   944,    -1,    -1,
     946,   944,    -1,   102,    -1,    -1,   896,    -1,   170,    -1,
     948,    -1,   949,   500,   948,    -1,   497,   949,   498,    -1,
     952,    -1,   951,   500,   952,    -1,   896,    98,  1089,    -1,
     896,  1110,    -1,   896,    -1,   490,    -1,   973,    -1,   968,
      -1,   955,    -1,   954,   500,   955,    -1,   953,    -1,   953,
     945,    -1,   957,    -1,   956,   500,   957,    -1,   968,    -1,
     968,    -1,   968,    -1,  1089,    -1,   968,    -1,  1108,    -1,
     969,    -1,   953,   945,    -1,   965,    -1,  1107,    -1,  1108,
      -1,  1106,    -1,   480,    -1,   963,  1108,    -1,   963,   497,
     924,   498,  1108,    -1,   875,  1108,    -1,   892,  1108,   894,
      -1,   892,   497,   965,   498,  1108,   894,    -1,   425,    -1,
     204,    -1,   307,    -1,  1102,    -1,  1101,    -1,   482,    -1,
     968,    -1,   965,    -1,  1102,    -1,   488,   965,    -1,   489,
     965,    -1,  1110,    -1,  1093,    -1,   970,    -1,  1083,    -1,
    1092,    -1,   123,    -1,   444,    -1,  1110,    -1,  1093,    -1,
     971,    -1,  1083,    -1,  1086,    -1,  1092,    -1,   109,    -1,
     111,    -1,   112,    -1,   124,    -1,   131,    -1,   167,    -1,
     168,    -1,   200,    -1,   203,    -1,   208,    -1,   221,    -1,
     243,    -1,   249,    -1,   251,    -1,   266,    -1,   289,    -1,
     291,    -1,   300,    -1,   308,    -1,   310,    -1,   324,    -1,
     328,    -1,   337,    -1,   339,    -1,   351,    -1,   372,    -1,
     388,    -1,   393,    -1,   405,    -1,   417,    -1,   418,    -1,
     422,    -1,   424,    -1,   445,    -1,   462,    -1,   463,    -1,
     464,    -1,   465,    -1,   466,    -1,   467,    -1,   468,    -1,
     469,    -1,   104,    -1,   108,    -1,   110,    -1,   151,    -1,
     157,    -1,   214,    -1,   216,    -1,   230,    -1,   242,    -1,
     254,    -1,   255,    -1,   257,    -1,   267,    -1,   269,    -1,
     290,    -1,   305,    -1,   325,    -1,   326,    -1,   327,    -1,
     369,    -1,   391,    -1,   448,    -1,    89,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,
      99,    -1,   102,    -1,   113,    -1,   119,    -1,   120,    -1,
     126,    -1,   132,    -1,   133,    -1,   140,    -1,   147,    -1,
     154,    -1,   155,    -1,   156,    -1,   158,    -1,   159,    -1,
     160,    -1,   170,    -1,   172,    -1,   178,    -1,   182,    -1,
     183,    -1,   189,    -1,   193,    -1,   196,    -1,   204,    -1,
     206,    -1,   210,    -1,   212,    -1,   215,    -1,   219,    -1,
     222,    -1,   224,    -1,   234,    -1,   241,    -1,   250,    -1,
     252,    -1,   265,    -1,   270,    -1,   274,    -1,   275,    -1,
     292,    -1,   302,    -1,   307,    -1,   313,    -1,   314,    -1,
     316,    -1,   317,    -1,   318,    -1,   322,    -1,   323,    -1,
     335,    -1,   343,    -1,   355,    -1,   366,    -1,   381,    -1,
     386,    -1,   394,    -1,   407,    -1,   410,    -1,   416,    -1,
     420,    -1,   425,    -1,   433,    -1,   438,    -1,   439,    -1,
     446,    -1,   452,    -1,   453,    -1,   455,    -1,   456,    -1,
     316,    -1,   292,    -1,    -1,   974,   975,    -1,  1098,   980,
     507,   501,    -1,  1098,   507,   501,    -1,  1098,  1000,    -1,
    1005,    -1,  1116,    -1,    74,    -1,   503,    -1,   504,    -1,
      -1,   147,   566,   410,   593,    98,   977,   823,   597,    -1,
      -1,   147,   714,   374,   957,    98,   979,   317,   756,   419,
     955,   868,   183,   757,   752,    -1,   103,  1041,    -1,     9,
     419,   982,   989,   990,    -1,     9,   419,   170,    -1,     9,
     991,    -1,   164,   982,    -1,   983,   986,   988,    -1,   984,
     502,   985,   988,   491,   983,   994,    -1,   993,    -1,  1108,
      -1,   958,    -1,    -1,  1110,  1104,    -1,   481,   987,    -1,
     985,    -1,    -1,   968,    -1,   968,   499,   987,    -1,    75,
      -1,   502,   965,    -1,    -1,    98,  1041,    -1,    -1,   438,
     991,    -1,    -1,   992,    -1,   992,   491,   992,    -1,   992,
      21,   114,   992,    -1,   992,   439,   992,    -1,   966,    -1,
    1108,    -1,  1102,    -1,  1104,    -1,   481,   995,    -1,    -1,
     968,   996,    -1,   968,   996,   481,   995,    -1,    -1,   484,
     965,    -1,   484,  1110,    -1,   484,  1102,    -1,   957,    -1,
     993,    -1,   169,   957,   821,   161,   822,   210,   997,    -1,
     199,   231,  1042,    -1,  1001,    -1,  1012,    -1,  1014,    -1,
     604,    -1,   500,   604,    -1,    -1,   894,    -1,   470,   419,
     282,    -1,   470,   419,   379,    -1,   165,   419,   165,    -1,
     285,   419,   285,    -1,    -1,  1007,  1006,  1009,  1008,    -1,
    1098,   107,   169,    34,   501,    -1,  1098,   193,   169,    34,
     501,    -1,    -1,  1010,    -1,    74,    -1,  1014,    -1,  1012,
      -1,  1010,  1014,    -1,  1010,  1012,    -1,  1010,    74,    -1,
    1014,    -1,  1011,  1014,    -1,    -1,    70,  1013,  1021,  1037,
    1090,   873,   501,    -1,    -1,  1018,  1021,  1015,  1034,   501,
      -1,    -1,  1021,  1016,  1034,   501,    -1,  1024,   501,    -1,
     502,   965,    -1,    -1,  1019,  1020,    -1,  1019,    -1,  1020,
      -1,    56,    -1,    67,    -1,    65,    -1,    50,    -1,    51,
      -1,    69,    -1,  1030,    -1,  1026,    -1,  1022,    -1,  1090,
     497,  1002,  1003,   498,    -1,  1090,  1004,    -1,  1028,    -1,
     194,  1087,  1023,    -1,   194,  1023,    -1,   194,  1087,    -1,
     503,  1114,   504,    -1,    -1,  1028,  1025,   503,  1011,   504,
      -1,  1024,    -1,    -1,  1029,  1027,   503,  1011,   504,    -1,
      43,  1087,    -1,   432,  1087,    -1,    43,    -1,   432,    -1,
    1031,    -1,  1033,  1032,    -1,    44,    35,    -1,    44,    35,
     248,    -1,    44,    -1,    44,   248,    -1,    44,    25,    -1,
      44,    25,   248,    -1,    44,    25,    25,    -1,    44,    25,
      25,   248,    -1,    44,   123,    -1,    35,    -1,    35,   248,
      -1,   248,    -1,    25,    -1,    25,   248,    -1,    25,    25,
      -1,    25,    25,   248,    -1,     5,    -1,   123,    -1,   186,
      -1,    36,    -1,    -1,  1035,    -1,  1034,   500,  1035,    -1,
    1037,  1091,   873,  1017,  1036,    -1,    -1,   484,  1115,    -1,
      -1,   490,    -1,   490,   490,    -1,   169,   398,  1110,    -1,
      15,  1040,    -1,  1041,    -1,   153,    -1,    89,    -1,    -1,
     958,    -1,   170,    -1,   993,    -1,   993,    -1,    72,    -1,
      17,   957,    -1,    17,    89,    -1,    28,   957,  1045,    -1,
      -1,  1046,    -1,   439,  1050,    -1,  1047,    -1,   439,  1049,
      14,  1111,    -1,   252,  1049,    14,  1111,    -1,    -1,    37,
      -1,  1051,    -1,  1051,   500,  1050,    -1,  1052,    -1,  1102,
      -1,  1101,    -1,   965,    -1,   488,   965,    -1,   489,   965,
      -1,  1107,    -1,   488,  1107,    -1,   489,  1107,    -1,  1108,
      -1,  1106,    -1,  1109,    -1,    13,   244,   957,  1047,    -1,
      13,  1054,   957,  1047,    -1,    13,  1054,   957,  1048,    -1,
      29,    -1,    -1,     3,    14,  1111,    -1,   166,    14,  1111,
      -1,    18,    14,  1111,  1058,    -1,  1059,    -1,  1058,   500,
    1059,    -1,  1104,   484,  1064,    -1,   387,    14,  1111,  1061,
      -1,  1062,    -1,  1061,   500,  1062,    -1,  1064,   484,  1063,
      -1,   965,    -1,  1104,    -1,    10,    -1,    18,    14,  1111,
     443,  1063,  1066,    -1,  1067,    -1,  1066,   500,  1067,    -1,
    1104,   484,  1072,    -1,   387,    14,  1111,   443,  1063,  1069,
      -1,  1070,    -1,  1069,   500,  1070,    -1,  1072,   484,  1071,
      -1,  1107,    -1,  1063,    -1,   489,  1107,    -1,   489,   965,
      -1,  1108,    -1,     8,    -1,   163,    -1,    11,    -1,    12,
      -1,    22,    -1,    23,    -1,    24,    -1,   287,    -1,    26,
      -1,    27,    -1,   339,    -1,    31,    -1,    32,    -1,    33,
      -1,   428,    -1,   387,     4,   484,  1074,    -1,   387,     4,
     419,  1074,    -1,   317,    -1,   313,    -1,   387,   139,   419,
    1041,    -1,   387,   139,   484,  1041,    -1,   387,   139,  1041,
      -1,    -1,   428,  1077,  1090,   254,  1021,   873,  1078,    -1,
      30,    -1,    -1,    -1,    45,  1080,  1089,   254,  1021,   873,
    1078,    -1,    46,    38,  1082,    -1,    46,   302,    16,  1082,
      -1,    46,    40,  1082,    -1,   143,    -1,    39,    -1,    42,
      -1,    20,   957,    -1,    19,   419,   957,    -1,   183,   957,
     497,  1099,   498,    -1,   183,     6,    -1,     7,   957,   497,
    1099,   498,    -1,     7,   957,    -1,  1084,    -1,  1085,    -1,
       6,    -1,     7,    -1,     8,    -1,    10,    -1,    11,    -1,
      12,    -1,    16,    -1,    19,    -1,    20,    -1,    21,    -1,
      22,    -1,    23,    -1,    24,    -1,    26,    -1,    27,    -1,
      31,    -1,    32,    -1,    33,    -1,    34,    -1,    37,    -1,
      38,    -1,    39,    -1,    40,    -1,    42,    -1,     9,    -1,
      13,    -1,    15,    -1,    28,    -1,    45,    -1,    46,    -1,
       5,    -1,    25,    -1,    29,    -1,    35,    -1,    43,    -1,
      36,    -1,    44,    -1,  1089,    -1,  1110,    -1,  1094,    -1,
    1096,    -1,   970,    -1,  1083,    -1,  1092,    -1,   123,    -1,
     444,    -1,  1091,    -1,  1086,    -1,   123,    -1,   244,    -1,
     248,    -1,   432,    -1,   419,    -1,  1092,    -1,  1094,    -1,
    1110,    -1,   970,    -1,   971,    -1,  1084,    -1,  1090,    -1,
     972,    -1,  1095,    -1,  1085,    -1,    50,    -1,    51,    -1,
      56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,    -1,
    1094,    -1,  1095,    -1,   165,    -1,   227,    -1,   282,    -1,
     285,    -1,   379,    -1,   470,    -1,  1096,    -1,   139,    -1,
      81,    -1,    82,    -1,    83,    -1,    84,    -1,    85,    -1,
      86,    -1,    87,    -1,    88,    -1,    90,    -1,    91,    -1,
      92,    -1,   100,    -1,   101,    -1,   103,    -1,   105,    -1,
     106,    -1,   107,    -1,   114,    -1,   115,    -1,   117,    -1,
     118,    -1,   122,    -1,   125,    -1,   127,    -1,   128,    -1,
     129,    -1,   130,    -1,   134,    -1,   135,    -1,   136,    -1,
     137,    -1,   138,    -1,   141,    -1,   142,    -1,   143,    -1,
     144,    -1,   145,    -1,   146,    -1,   148,    -1,   149,    -1,
     150,    -1,   152,    -1,   161,    -1,   162,    -1,   163,    -1,
     164,    -1,   166,    -1,   169,    -1,   171,    -1,   173,    -1,
     175,    -1,   176,    -1,   177,    -1,   179,    -1,   180,    -1,
     181,    -1,   184,    -1,   185,    -1,   186,    -1,   187,    -1,
     188,    -1,   190,    -1,   191,    -1,   192,    -1,   195,    -1,
     197,    -1,   198,    -1,   199,    -1,   201,    -1,   202,    -1,
     205,    -1,   207,    -1,   211,    -1,   213,    -1,   217,    -1,
     218,    -1,   220,    -1,   223,    -1,   225,    -1,   226,    -1,
     228,    -1,   229,    -1,   231,    -1,   232,    -1,   233,    -1,
     235,    -1,   236,    -1,   237,    -1,   238,    -1,   239,    -1,
     240,    -1,   245,    -1,   246,    -1,   247,    -1,   256,    -1,
     258,    -1,   259,    -1,   260,    -1,   261,    -1,   262,    -1,
     263,    -1,   264,    -1,   268,    -1,   271,    -1,   272,    -1,
     273,    -1,   276,    -1,   277,    -1,   278,    -1,   279,    -1,
     280,    -1,   281,    -1,   283,    -1,   284,    -1,   286,    -1,
     287,    -1,   288,    -1,   293,    -1,   294,    -1,   295,    -1,
     296,    -1,   297,    -1,   298,    -1,   299,    -1,   301,    -1,
     303,    -1,   304,    -1,   306,    -1,   309,    -1,   311,    -1,
     312,    -1,   315,    -1,   319,    -1,   320,    -1,   329,    -1,
     330,    -1,   331,    -1,   332,    -1,   334,    -1,   336,    -1,
     341,    -1,   342,    -1,   340,    -1,   344,    -1,   345,    -1,
     346,    -1,   347,    -1,   348,    -1,   350,    -1,   352,    -1,
     353,    -1,   354,    -1,   356,    -1,   357,    -1,   358,    -1,
     359,    -1,   360,    -1,   361,    -1,   362,    -1,   363,    -1,
     364,    -1,   365,    -1,   367,    -1,   368,    -1,   370,    -1,
     371,    -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,
     377,    -1,   378,    -1,   382,    -1,   383,    -1,   385,    -1,
     387,    -1,   389,    -1,   390,    -1,   392,    -1,   395,    -1,
     396,    -1,   397,    -1,   398,    -1,   399,    -1,   400,    -1,
     401,    -1,   402,    -1,   403,    -1,   404,    -1,   406,    -1,
     409,    -1,   408,    -1,   411,    -1,   412,    -1,   413,    -1,
     414,    -1,   415,    -1,   421,    -1,   423,    -1,   426,    -1,
     427,    -1,   428,    -1,   430,    -1,   431,    -1,   434,    -1,
     435,    -1,   436,    -1,   437,    -1,   440,    -1,   441,    -1,
     442,    -1,   443,    -1,   447,    -1,   449,    -1,   450,    -1,
     451,    -1,   454,    -1,   457,    -1,   458,    -1,   460,    -1,
     461,    -1,   471,    -1,   472,    -1,  1100,    -1,  1097,   500,
    1100,    -1,    41,    -1,    -1,  1114,    -1,  1104,  1103,    -1,
    1104,    -1,  1104,  1103,    -1,  1104,    -1,  1104,    -1,    22,
    1104,    -1,    22,   957,    -1,    73,    -1,   483,    -1,   479,
      -1,   477,    -1,   478,    -1,    77,    -1,    78,    -1,    79,
      -1,    76,    -1,   480,    -1,   476,    -1,    72,    -1,    80,
      -1,   957,    -1,   993,    -1,  1117,    -1,   497,   498,    -1,
     497,  1113,   498,    -1,  1112,    -1,  1113,  1112,    -1,  1115,
      -1,  1114,   500,  1115,    -1,  1113,    -1,   503,  1114,   504,
      -1,  1117,    -1,   497,    -1,   498,    -1,   500,    -1,   501,
      -1,  1110,    -1,   965,    -1,  1107,    -1,  1108,    -1,   490,
      -1,   488,    -1,   489,    -1,   491,    -1,   492,    -1,   307,
      -1,    47,    -1,    48,    -1,    49,    -1,    50,    -1,    51,
      -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    57,    -1,    58,    -1,    60,    -1,    59,    -1,    61,
      -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,    66,
      -1,    67,    -1,    68,    -1,    70,    -1,    69,    -1,     5,
      -1,   194,    -1,   227,    -1,   248,    -1,    25,    -1,   282,
      -1,   285,    -1,   379,    -1,    35,    -1,    36,    -1,    43,
      -1,    44,    -1,   470,    -1,   123,    -1,   208,    -1,   419,
      -1,   432,    -1,   445,    -1,   495,    -1,   496,    -1,   484,
      -1,   502,    -1,   166,   997,    -1,   166,   341,   997,    -1,
     166,    89,    -1,   166,   341,    89,    -1,   965,    -1,   497,
    1119,   498,    -1,  1119,   488,  1119,    -1,  1119,   489,  1119,
      -1,  1119,   490,  1119,    -1,  1119,   491,  1119,    -1,  1119,
     492,  1119,    -1,  1108,    -1,   968,    -1,    -1,  1046,  1121,
      -1,  1121,  1046,    -1,  1046,    -1,  1121,    -1,   252,  1097,
      -1,  1048,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1193,  1193,  1196,  1198,  1200,  1202,  1204,  1206,  1208,
    1210,  1212,  1214,  1216,  1218,  1220,  1222,  1224,  1226,  1228,
    1230,  1232,  1234,  1236,  1254,  1256,  1258,  1260,  1262,  1264,
    1266,  1268,  1270,  1272,  1274,  1276,  1278,  1280,  1282,  1284,
    1286,  1288,  1290,  1292,  1294,  1296,  1298,  1300,  1302,  1304,
    1306,  1313,  1315,  1317,  1319,  1321,  1323,  1325,  1327,  1329,
    1331,  1333,  1335,  1337,  1339,  1341,  1343,  1345,  1347,  1349,
    1351,  1353,  1355,  1357,  1359,  1361,  1363,  1365,  1367,  1369,
    1371,  1373,  1375,  1377,  1384,  1386,  1388,  1390,  1392,  1394,
    1396,  1398,  1400,  1402,  1404,  1410,  1412,  1414,  1416,  1418,
    1420,  1422,  1424,  1426,  1432,  1442,  1446,  1454,  1458,  1468,
    1478,  1479,  1490,  1497,  1503,  1514,  1520,  1529,  1536,  1542,
    1551,  1558,  1566,  1571,  1579,  1584,  1590,  1595,  1601,  1605,
    1609,  1613,  1617,  1621,  1625,  1629,  1633,  1637,  1641,  1645,
    1649,  1653,  1657,  1661,  1665,  1669,  1673,  1677,  1681,  1685,
    1689,  1693,  1701,  1709,  1717,  1725,  1733,  1741,  1745,  1753,
    1757,  1765,  1773,  1781,  1785,  1793,  1797,  1805,  1809,  1817,
    1822,  1828,  1833,  1839,  1843,  1847,  1851,  1855,  1859,  1867,
    1871,  1875,  1883,  1887,  1891,  1895,  1899,  1903,  1907,  1911,
    1915,  1920,  1924,  1928,  1932,  1936,  1940,  1948,  1952,  1960,
    1964,  1972,  1976,  1980,  1994,  1998,  2002,  2006,  2014,  2018,
    2022,  2026,  2034,  2038,  2042,  2046,  2050,  2054,  2058,  2066,
    2070,  2075,  2081,  2085,  2093,  2097,  2101,  2105,  2109,  2117,
    2121,  2129,  2133,  2137,  2141,  2145,  2154,  2162,  2166,  2174,
    2178,  2186,  2194,  2198,  2202,  2206,  2214,  2218,  2222,  2226,
    2234,  2238,  2246,  2250,  2254,  2258,  2262,  2266,  2270,  2274,
    2278,  2282,  2286,  2290,  2294,  2298,  2302,  2306,  2310,  2314,
    2318,  2322,  2326,  2330,  2334,  2338,  2342,  2346,  2350,  2354,
    2358,  2362,  2366,  2370,  2378,  2382,  2390,  2394,  2399,  2405,
    2410,  2416,  2424,  2429,  2435,  2439,  2447,  2451,  2455,  2459,
    2467,  2471,  2479,  2490,  2501,  2505,  2513,  2517,  2521,  2529,
    2534,  2540,  2544,  2548,  2552,  2556,  2560,  2564,  2568,  2572,
    2576,  2584,  2589,  2595,  2600,  2606,  2611,  2617,  2622,  2628,
    2632,  2640,  2644,  2648,  2652,  2656,  2660,  2665,  2671,  2676,
    2682,  2686,  2694,  2698,  2702,  2710,  2718,  2723,  2729,  2733,
    2737,  2745,  2749,  2753,  2757,  2761,  2765,  2769,  2777,  2781,
    2785,  2789,  2797,  2805,  2810,  2816,  2820,  2824,  2828,  2832,
    2836,  2844,  2848,  2856,  2860,  2864,  2868,  2876,  2881,  2887,
    2891,  2899,  2907,  2911,  2916,  2921,  2927,  2931,  2935,  2939,
    2944,  2950,  2958,  2966,  2970,  2974,  2978,  2982,  2990,  2995,
    3001,  3005,  3009,  3014,  3020,  3024,  3028,  3033,  3039,  3044,
    3050,  3055,  3061,  3069,  3074,  3080,  3084,  3092,  3100,  3104,
    3109,  3115,  3123,  3131,  3136,  3142,  3146,  3154,  3158,  3162,
    3166,  3170,  3174,  3178,  3182,  3186,  3190,  3194,  3198,  3206,
    3211,  3217,  3221,  3225,  3236,  3240,  3248,  3253,  3259,  3263,
    3271,  3275,  3283,  3288,  3294,  3299,  3305,  3309,  3317,  3322,
    3328,  3336,  3341,  3347,  3351,  3359,  3367,  3371,  3379,  3383,
    3387,  3395,  3400,  3406,  3410,  3418,  3426,  3430,  3438,  3442,
    3446,  3450,  3458,  3466,  3474,  3482,  3490,  3495,  3501,  3505,
    3513,  3518,  3524,  3528,  3536,  3540,  3544,  3552,  3560,  3564,
    3568,  3576,  3580,  3588,  3596,  3600,  3608,  3612,  3620,  3624,
    3632,  3636,  3640,  3644,  3652,  3657,  3663,  3668,  3674,  3678,
    3686,  3690,  3695,  3701,  3705,  3709,  3713,  3717,  3721,  3729,
    3734,  3740,  3744,  3751,  3755,  3763,  3769,  3773,  3781,  3785,
    3793,  3797,  3805,  3814,  3823,  3827,  3831,  3835,  3839,  3843,
    3847,  3851,  3855,  3859,  3863,  3871,  3879,  3883,  3891,  3895,
    3903,  3907,  3911,  3915,  3919,  3927,  3931,  3939,  3947,  3951,
    3959,  3967,  3971,  3979,  3987,  3991,  3999,  4003,  4007,  4011,
    4015,  4023,  4028,  4034,  4039,  4045,  4051,  4057,  4065,  4069,
    4077,  4081,  4089,  4093,  4101,  4105,  4113,  4117,  4125,  4133,
    4141,  4145,  4153,  4157,  4161,  4165,  4169,  4173,  4177,  4181,
    4185,  4189,  4193,  4197,  4205,  4209,  4217,  4221,  4229,  4233,
    4241,  4249,  4253,  4258,  4264,  4268,  4272,  4276,  4280,  4284,
    4288,  4292,  4296,  4300,  4304,  4308,  4312,  4316,  4320,  4324,
    4328,  4336,  4340,  4344,  4348,  4352,  4356,  4360,  4364,  4368,
    4372,  4376,  4380,  4388,  4392,  4400,  4405,  4410,  4414,  4418,
    4423,  4428,  4433,  4438,  4443,  4452,  4456,  4460,  4464,  4468,
    4478,  4488,  4498,  4502,  4506,  4516,  4520,  4524,  4534,  4542,
    4546,  4554,  4562,  4566,  4574,  4578,  4582,  4586,  4590,  4598,
    4602,  4610,  4614,  4618,  4622,  4630,  4634,  4638,  4642,  4646,
    4650,  4654,  4658,  4662,  4666,  4674,  4678,  4686,  4690,  4698,
    4703,  4709,  4713,  4721,  4729,  4737,  4741,  4749,  4754,  4760,
    4765,  4771,  4775,  4783,  4788,  4794,  4799,  4805,  4809,  4817,
    4821,  4825,  4833,  4837,  4842,  4848,  4852,  4857,  4863,  4867,
    4872,  4878,  4882,  4886,  4894,  4899,  4905,  4909,  4917,  4921,
    4929,  4933,  4941,  4945,  4953,  4957,  4961,  4965,  4969,  4977,
    4981,  4985,  4989,  4993,  5001,  5009,  5017,  5021,  5025,  5033,
    5037,  5041,  5049,  5053,  5061,  5065,  5069,  5073,  5077,  5081,
    5085,  5089,  5093,  5097,  5101,  5105,  5109,  5117,  5121,  5125,
    5129,  5137,  5141,  5149,  5154,  5160,  5168,  5172,  5180,  5188,
    5192,  5200,  5205,  5211,  5215,  5223,  5227,  5235,  5239,  5247,
    5251,  5255,  5259,  5267,  5271,  5279,  5283,  5287,  5295,  5299,
    5304,  5310,  5318,  5323,  5329,  5333,  5337,  5345,  5349,  5357,
    5362,  5368,  5372,  5376,  5380,  5384,  5388,  5392,  5396,  5400,
    5404,  5408,  5412,  5416,  5420,  5424,  5428,  5432,  5436,  5440,
    5444,  5448,  5452,  5456,  5464,  5469,  5475,  5480,  5486,  5490,
    5494,  5498,  5502,  5506,  5510,  5518,  5522,  5526,  5530,  5534,
    5538,  5542,  5546,  5550,  5554,  5558,  5562,  5566,  5570,  5574,
    5578,  5586,  5590,  5594,  5602,  5606,  5614,  5618,  5622,  5626,
    5630,  5638,  5643,  5649,  5653,  5657,  5661,  5669,  5673,  5678,
    5684,  5688,  5696,  5704,  5712,  5716,  5724,  5728,  5732,  5736,
    5740,  5744,  5748,  5752,  5756,  5760,  5764,  5768,  5772,  5776,
    5784,  5788,  5793,  5799,  5803,  5807,  5815,  5819,  5823,  5831,
    5836,  5842,  5846,  5854,  5859,  5864,  5870,  5876,  5884,  5892,
    5897,  5903,  5907,  5911,  5915,  5919,  5923,  5927,  5931,  5935,
    5939,  5943,  5947,  5951,  5955,  5959,  5963,  5971,  5976,  5982,
    5986,  5994,  6002,  6007,  6013,  6021,  6025,  6033,  6041,  6045,
    6049,  6053,  6057,  6065,  6070,  6076,  6084,  6088,  6092,  6096,
    6100,  6104,  6112,  6120,  6124,  6128,  6136,  6141,  6147,  6151,
    6155,  6163,  6167,  6175,  6179,  6187,  6192,  6198,  6203,  6209,
    6214,  6220,  6225,  6231,  6239,  6243,  6247,  6251,  6255,  6259,
    6263,  6271,  6276,  6282,  6288,  6298,  6303,  6309,  6313,  6317,
    6321,  6329,  6331,  6339,  6344,  6350,  6358,  6362,  6366,  6374,
    6378,  6386,  6394,  6399,  6405,  6413,  6418,  6424,  6432,  6437,
    6443,  6447,  6451,  6455,  6459,  6463,  6467,  6471,  6479,  6484,
    6490,  6498,  6502,  6510,  6514,  6522,  6530,  6538,  6546,  6550,
    6558,  6590,  6592,  6596,  6600,  6604,  6613,  6619,  6623,  6631,
    6635,  6643,  6647,  6655,  6659,  6663,  6667,  6671,  6675,  6679,
    6683,  6691,  6695,  6703,  6707,  6711,  6715,  6719,  6723,  6731,
    6735,  6743,  6747,  6755,  6763,  6768,  6770,  6776,  6780,  6784,
    6788,  6792,  6796,  6800,  6804,  6812,  6817,  6823,  6827,  6832,
    6838,  6842,  6846,  6851,  6857,  6862,  6868,  6876,  6880,  6888,
    6892,  6900,  6904,  6908,  6912,  6916,  6921,  6925,  6929,  6937,
    6942,  6948,  6952,  6960,  6964,  6969,  6975,  6983,  6991,  6995,
    7003,  7007,  7015,  7020,  7026,  7031,  7037,  7041,  7049,  7054,
    7060,  7064,  7072,  7076,  7084,  7089,  7095,  7099,  7107,  7112,
    7118,  7122,  7130,  7134,  7138,  7142,  7146,  7150,  7154,  7158,
    7164,  7168,  7172,  7180,  7184,  7188,  7192,  7196,  7200,  7208,
    7212,  7216,  7220,  7228,  7232,  7236,  7240,  7248,  7253,  7259,
    7263,  7271,  7275,  7279,  7283,  7291,  7295,  7303,  7307,  7311,
    7319,  7327,  7332,  7338,  7342,  7346,  7351,  7357,  7361,  7369,
    7377,  7379,  7381,  7385,  7389,  7393,  7401,  7411,  7422,  7431,
    7435,  7439,  7443,  7447,  7451,  7455,  7463,  7467,  7471,  7475,
    7483,  7487,  7495,  7500,  7506,  7510,  7514,  7518,  7522,  7526,
    7530,  7534,  7538,  7542,  7546,  7554,  7559,  7565,  7569,  7577,
    7581,  7589,  7597,  7605,  7609,  7617,  7621,  7629,  7637,  7645,
    7649,  7653,  7657,  7661,  7665,  7673,  7678,  7684,  7689,  7695,
    7699,  7703,  7707,  7715,  7723,  7727,  7732,  7738,  7742,  7746,
    7750,  7754,  7758,  7762,  7766,  7770,  7774,  7778,  7782,  7786,
    7791,  7797,  7801,  7809,  7813,  7817,  7821,  7825,  7829,  7833,
    7837,  7841,  7845,  7849,  7853,  7857,  7861,  7865,  7869,  7873,
    7877,  7881,  7885,  7889,  7893,  7897,  7901,  7905,  7909,  7913,
    7917,  7921,  7925,  7929,  7933,  7937,  7941,  7945,  7949,  7953,
    7957,  7961,  7965,  7969,  7973,  7977,  7981,  7985,  7989,  7993,
    7997,  8001,  8005,  8009,  8013,  8017,  8021,  8025,  8029,  8034,
    8038,  8046,  8050,  8054,  8058,  8062,  8066,  8070,  8074,  8078,
    8082,  8086,  8090,  8094,  8098,  8102,  8106,  8110,  8114,  8118,
    8122,  8126,  8130,  8138,  8142,  8146,  8150,  8154,  8158,  8162,
    8166,  8170,  8174,  8178,  8186,  8190,  8194,  8198,  8202,  8206,
    8210,  8214,  8218,  8222,  8226,  8230,  8234,  8238,  8242,  8246,
    8250,  8254,  8258,  8262,  8266,  8270,  8274,  8278,  8282,  8286,
    8290,  8294,  8298,  8302,  8306,  8310,  8314,  8318,  8322,  8326,
    8330,  8334,  8338,  8342,  8346,  8350,  8354,  8358,  8362,  8366,
    8370,  8378,  8382,  8390,  8394,  8398,  8403,  8409,  8417,  8421,
    8429,  8433,  8441,  8445,  8453,  8457,  8462,  8468,  8473,  8479,
    8483,  8491,  8499,  8503,  8508,  8514,  8522,  8526,  8533,  8538,
    8544,  8548,  8553,  8559,  8564,  8573,  8577,  8581,  8589,  8593,
    8597,  8605,  8609,  8613,  8621,  8625,  8633,  8637,  8641,  8645,
    8649,  8653,  8657,  8661,  8665,  8673,  8677,  8685,  8689,  8697,
    8701,  8705,  8709,  8713,  8717,  8725,  8729,  8737,  8741,  8749,
    8753,  8757,  8765,  8769,  8777,  8782,  8788,  8792,  8796,  8800,
    8804,  8808,  8812,  8816,  8824,  8828,  8836,  8844,  8849,  8855,
    8859,  8863,  8867,  8871,  8876,  8882,  8890,  8898,  8902,  8906,
    8914,  8918,  8926,  8934,  8938,  8946,  8954,  8959,  8965,  8970,
    8976,  8980,  8988,  8992,  8996,  9000,  9008,  9012,  9021,  9023,
    9031,  9036,  9042,  9046,  9054,  9058,  9066,  9074,  9078,  9086,
    9090,  9094,  9098,  9106,  9110,  9118,  9122,  9130,  9134,  9142,
    9146,  9154,  9162,  9170,  9178,  9186,  9194,  9202,  9206,  9214,
    9218,  9222,  9226,  9230,  9234,  9238,  9242,  9246,  9250,  9254,
    9258,  9262,  9266,  9267,  9272,  9278,  9286,  9290,  9291,  9295,
    9303,  9307,  9311,  9315,  9316,  9317,  9318,  9323,  9327,  9331,
    9335,  9336,  9337,  9342,  9346,  9350,  9354,  9358,  9362,  9366,
    9370,  9374,  9378,  9382,  9386,  9390,  9394,  9398,  9402,  9406,
    9410,  9414,  9418,  9422,  9426,  9430,  9434,  9438,  9442,  9446,
    9450,  9454,  9458,  9462,  9466,  9470,  9474,  9478,  9482,  9486,
    9490,  9494,  9498,  9502,  9506,  9514,  9518,  9522,  9526,  9530,
    9534,  9538,  9542,  9546,  9550,  9554,  9558,  9562,  9566,  9570,
    9574,  9578,  9582,  9586,  9590,  9594,  9598,  9606,  9610,  9614,
    9618,  9622,  9626,  9630,  9634,  9638,  9642,  9646,  9650,  9654,
    9658,  9662,  9666,  9670,  9674,  9678,  9682,  9686,  9690,  9694,
    9698,  9702,  9706,  9710,  9714,  9718,  9722,  9726,  9730,  9734,
    9738,  9742,  9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,
    9778,  9782,  9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,
    9818,  9822,  9826,  9830,  9834,  9838,  9842,  9846,  9850,  9854,
    9858,  9862,  9866,  9870,  9874,  9878,  9882,  9886,  9890,  9894,
    9898,  9902,  9906,  9910,  9918,  9925,  9938,  9939,  9942,  9943,
    9944,  9950,  9951,  9952,  9953,  9954,  9957,  9957,  9967,  9966,
    9976,  9992,  9994,  9997,  9999, 10003, 10015, 10031, 10035, 10046,
   10047, 10050, 10062, 10071, 10072, 10075, 10076, 10077, 10080, 10081,
   10084, 10085, 10088, 10089, 10092, 10094, 10096, 10098, 10102, 10109,
   10116, 10132, 10165, 10175, 10178, 10180, 10193, 10194, 10196, 10198,
   10202, 10215, 10222, 10259, 10268, 10270, 10271, 10274, 10276, 10277,
   10280, 10281, 10282, 10283, 10284, 10291, 10290, 10300, 10302, 10304,
   10305, 10306, 10309, 10310, 10311, 10312, 10313, 10316, 10317, 10321,
   10320, 10337, 10335, 10350, 10349, 10362, 10368, 10369, 10372, 10374,
   10375, 10378, 10379, 10380, 10381, 10384, 10385, 10388, 10396, 10413,
   10421, 10444, 10542, 10576, 10578, 10580, 10584, 10588, 10587, 10638,
   10640, 10639, 10654, 10660, 10667, 10672, 10675, 10676, 10679, 10680,
   10681, 10682, 10683, 10684, 10685, 10693, 10701, 10704, 10705, 10706,
   10707, 10708, 10709, 10717, 10725, 10726, 10727, 10730, 10731, 10734,
   10736, 10740, 10826, 10827, 10834, 10835, 10836, 10842, 10851, 10854,
   10855, 10856, 10857, 10860, 10861, 10862, 10865, 10867, 10875, 10876,
   10882, 10884, 10885, 10888, 10889, 10892, 10899, 10906, 10906, 10908,
   10908, 10910, 10917, 10918, 10921, 10922, 10923, 10924, 10925, 10926,
   10927, 10928, 10929, 10935, 10942, 10949, 10958, 10959, 10971, 10982,
   10993, 10997, 10998, 11001, 11006, 11010, 11011, 11014, 11020, 11028,
   11031, 11038, 11042, 11043, 11046, 11049, 11053, 11054, 11057, 11063,
   11071, 11072, 11081, 11090, 11102, 11103, 11104, 11105, 11106, 11107,
   11108, 11109, 11110, 11111, 11112, 11113, 11114, 11115, 11116, 11123,
   11124, 11127, 11128, 11135, 11136, 11137, 11144, 11143, 11160, 11161,
   11168, 11167, 11236, 11242, 11248, 11256, 11262, 11268, 11274, 11280,
   11286, 11292, 11298, 11304, 11315, 11316, 11319, 11320, 11321, 11322,
   11323, 11324, 11325, 11326, 11327, 11328, 11329, 11330, 11331, 11332,
   11333, 11334, 11335, 11336, 11337, 11338, 11339, 11340, 11341, 11342,
   11345, 11346, 11347, 11348, 11349, 11350, 11354, 11355, 11356, 11357,
   11358, 11359, 11360, 11363, 11366, 11367, 11368, 11369, 11370, 11371,
   11372, 11373, 11378, 11379, 11380, 11381, 11382, 11383, 11384, 11385,
   11386, 11389, 11390, 11391, 11392, 11395, 11396, 11397, 11398, 11401,
   11402, 11403, 11404, 11405, 11406, 11407, 11425, 11425, 11427, 11428,
   11429, 11430, 11431, 11432, 11438, 11439, 11442, 11443, 11444, 11445,
   11446, 11447, 11448, 11449, 11450, 11451, 11452, 11453, 11454, 11455,
   11456, 11457, 11458, 11459, 11460, 11461, 11462, 11463, 11464, 11465,
   11466, 11467, 11468, 11469, 11470, 11471, 11472, 11473, 11475, 11476,
   11477, 11478, 11479, 11480, 11481, 11482, 11483, 11484, 11485, 11486,
   11487, 11488, 11490, 11491, 11492, 11493, 11494, 11495, 11496, 11497,
   11498, 11499, 11500, 11501, 11502, 11503, 11504, 11505, 11506, 11507,
   11509, 11510, 11511, 11512, 11513, 11514, 11515, 11517, 11518, 11519,
   11520, 11521, 11522, 11523, 11524, 11525, 11527, 11528, 11529, 11530,
   11531, 11532, 11533, 11534, 11535, 11536, 11537, 11538, 11539, 11540,
   11541, 11542, 11543, 11544, 11545, 11546, 11547, 11548, 11549, 11550,
   11551, 11552, 11553, 11554, 11555, 11556, 11557, 11558, 11560, 11561,
   11563, 11564, 11565, 11566, 11567, 11568, 11569, 11570, 11571, 11572,
   11573, 11574, 11575, 11576, 11577, 11578, 11579, 11580, 11581, 11582,
   11583, 11584, 11585, 11586, 11587, 11588, 11589, 11590, 11591, 11592,
   11593, 11594, 11595, 11596, 11597, 11598, 11599, 11600, 11601, 11602,
   11603, 11604, 11605, 11606, 11607, 11608, 11609, 11610, 11611, 11612,
   11613, 11614, 11615, 11616, 11617, 11618, 11619, 11620, 11622, 11623,
   11624, 11625, 11626, 11627, 11628, 11629, 11630, 11631, 11632, 11633,
   11634, 11635, 11636, 11637, 11638, 11639, 11640, 11641, 11642, 11643,
   11644, 11645, 11646, 11647, 11648, 11649, 11650, 11651, 11652, 11653,
   11654, 11655, 11656, 11657, 11658, 11659, 11660, 11661, 11662, 11663,
   11664, 11665, 11666, 11667, 11668, 11669, 11670, 11671, 11673, 11676,
   11676, 11679, 11685, 11686, 11689, 11691, 11696, 11706, 11713, 11714,
   11715, 11718, 11751, 11753, 11755, 11758, 11768, 11778, 11788, 11789,
   11792, 11794, 11795, 11796, 11799, 11801, 11809, 11810, 11811, 11815,
   11816, 11820, 11821, 11824, 11825, 11828, 11829, 11830, 11831, 11832,
   11835, 11836, 11837, 11838, 11839, 11840, 11841, 11842, 11843, 11844,
   11845, 11846, 11847, 11848, 11849, 11850, 11851, 11852, 11853, 11854,
   11855, 11856, 11857, 11858, 11859, 11860, 11861, 11862, 11863, 11864,
   11865, 11866, 11867, 11868, 11869, 11870, 11871, 11872, 11873, 11874,
   11875, 11876, 11877, 11878, 11879, 11880, 11881, 11882, 11883, 11884,
   11885, 11886, 11887, 11888, 11889, 11890, 11893, 11894, 11895, 11896,
   11899, 11900, 11901, 11902, 11903, 11904, 11905, 11906, 11907, 11910,
   11911, 11912, 11913, 11914, 11917, 11918
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", 
  "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", 
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", 
  "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONCURRENTLY", 
  "CONFIGURATION", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", 
  "CONTINUE_P", "CONVERSION_P", "COPY", "COST", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDING", "EXCLUSIVE", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL", 
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", 
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", 
  "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", 
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", 
  "PARTITION", "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", 
  "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", 
  "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE_P", 
  "VALUES", "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", 
  "VIEW", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", 
  "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", 
  "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", 
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", 
  "WITH_TIME", "IDENT", "FCONST", "SCONST", "BCONST", "XCONST", "Op", 
  "ICONST", "PARAM", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "','", "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", 
  "CreateRoleStmt", "opt_with", "OptRoleList", "OptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableResetStmt", "SetResetClause", "VariableShowStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "create_as_target", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "opt_with_data", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", 
  "NumericOnly", "CreatePLangStmt", "opt_trusted", "handler_name", 
  "validator_clause", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text", 
  "FetchStmt", "fetch_direction", "from_in", "GrantStmt", "RevokeStmt", 
  "privileges", "privilege_list", "privilege", "privilege_target", 
  "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "opt_if_exists", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "opt_set_data", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleActionList", 
  "RuleActionMulti", "RuleActionStmt", "RuleActionStmtOrEmpty", "event", 
  "opt_instead", "DropRuleStmt", "NotifyStmt", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "with_clause", "cte_list", "common_table_expr", 
  "into_clause", "OptTempTableName", "opt_table", "opt_all", 
  "opt_distinct", "opt_sort_clause", "sort_clause", "sortby_list", 
  "sortby", "select_limit", "opt_select_limit", "select_limit_value", 
  "opt_select_fetch_first_value", "select_offset_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "type_list", "array_expr", 
  "array_expr_list", "extract_list", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "RoleId", "SignedIconst", "ColId", "type_function_name", 
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword", 
  "SpecialRuleRelation", "statements", "statement", "CreateAsStmt", "@1", 
  "RuleStmt", "@2", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@3", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@4", "var_declaration", 
  "@5", "@6", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@9", "opt_reference", "ECPGVar", 
  "@10", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColLabel", 
  "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ecpg_param", "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", 
  "ecpg_xconst", "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 
  "DeallocateStmt", "Iresult", "execute_rest", "ecpg_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,    61,    60,    62,   739,    43,    45,
      42,    47,    37,    94,   740,    91,    93,    40,    41,    46,
      44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   505,   506,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   508,   509,   509,   510,   510,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   512,   513,   514,   515,   516,   517,   517,   518,
     518,   519,   520,   521,   521,   522,   522,   523,   523,   524,
     524,   525,   525,   526,   526,   526,   526,   526,   526,   527,
     527,   527,   528,   528,   528,   528,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   528,   528,   529,   529,   530,
     530,   531,   531,   531,   532,   532,   532,   532,   533,   533,
     533,   533,   534,   534,   534,   534,   534,   534,   534,   535,
     535,   535,   536,   536,   537,   537,   537,   537,   537,   538,
     538,   539,   539,   539,   539,   539,   540,   541,   541,   542,
     542,   543,   544,   544,   544,   544,   545,   545,   545,   545,
     546,   546,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   548,   548,   549,   549,   549,   550,
     550,   551,   552,   552,   553,   553,   554,   554,   554,   554,
     555,   555,   556,   556,   557,   557,   558,   558,   558,   559,
     559,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   561,   561,   562,   562,   563,   563,   564,   564,   565,
     565,   566,   566,   566,   566,   566,   566,   566,   567,   567,
     568,   568,   569,   569,   569,   570,   571,   571,   572,   572,
     572,   573,   573,   573,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   576,   576,   577,   577,   577,   577,   577,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     581,   582,   583,   583,   583,   583,   584,   584,   584,   584,
     584,   585,   586,   587,   587,   587,   587,   587,   588,   588,
     589,   589,   589,   589,   590,   590,   590,   590,   591,   591,
     592,   592,   593,   594,   594,   595,   595,   596,   597,   597,
     597,   598,   599,   600,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   612,
     613,   614,   614,   615,   615,   616,   617,   617,   618,   618,
     618,   619,   619,   620,   620,   621,   622,   622,   623,   623,
     623,   623,   624,   625,   626,   627,   628,   628,   629,   629,
     630,   630,   631,   631,   632,   632,   632,   633,   634,   634,
     634,   635,   635,   636,   637,   637,   638,   638,   639,   639,
     640,   640,   640,   640,   641,   641,   642,   642,   643,   643,
     644,   644,   644,   645,   645,   645,   645,   645,   645,   646,
     646,   647,   647,   647,   647,   647,   648,   648,   649,   649,
     650,   650,   651,   652,   653,   653,   653,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   655,   655,   656,   656,
     657,   657,   657,   657,   657,   658,   658,   659,   660,   660,
     661,   662,   662,   663,   664,   664,   665,   665,   665,   665,
     665,   666,   666,   667,   667,   668,   668,   669,   670,   670,
     671,   671,   672,   672,   673,   673,   674,   674,   675,   676,
     677,   677,   678,   678,   678,   678,   678,   678,   678,   678,
     678,   678,   678,   678,   679,   679,   680,   680,   681,   681,
     682,   683,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   687,   687,   687,   687,   687,
     687,   687,   687,   687,   687,   688,   688,   688,   688,   688,
     688,   688,   688,   688,   688,   688,   688,   688,   688,   689,
     689,   690,   691,   691,   692,   692,   692,   692,   692,   693,
     693,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   696,   696,   697,   697,   698,
     698,   699,   699,   700,   701,   702,   702,   703,   703,   704,
     704,   705,   705,   706,   706,   707,   707,   708,   708,   709,
     709,   709,   710,   710,   710,   711,   711,   711,   712,   712,
     712,   713,   713,   713,   714,   714,   715,   715,   716,   716,
     717,   717,   718,   718,   719,   719,   719,   719,   719,   720,
     720,   720,   720,   720,   721,   722,   723,   723,   723,   724,
     724,   724,   725,   725,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   727,   727,   727,
     727,   728,   728,   729,   729,   730,   731,   731,   732,   733,
     733,   734,   734,   735,   735,   736,   736,   737,   737,   738,
     738,   738,   738,   739,   739,   740,   740,   740,   741,   741,
     741,   742,   743,   743,   744,   744,   744,   745,   745,   746,
     746,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   748,   748,   749,   749,   750,   750,
     750,   750,   750,   750,   750,   751,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   752,   752,   752,   753,   753,   754,   754,   754,   754,
     754,   755,   755,   756,   756,   756,   756,   757,   757,   757,
     758,   758,   759,   760,   761,   761,   762,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   762,   762,   762,   762,
     763,   763,   763,   764,   764,   764,   765,   765,   765,   766,
     766,   767,   767,   768,   768,   768,   768,   769,   770,   771,
     771,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   773,   773,   774,
     774,   775,   776,   776,   777,   778,   778,   779,   780,   780,
     780,   780,   780,   781,   781,   782,   783,   783,   783,   783,
     783,   783,   784,   785,   785,   785,   786,   786,   787,   787,
     787,   788,   788,   789,   789,   790,   790,   791,   791,   792,
     792,   793,   793,   794,   795,   795,   795,   795,   795,   795,
     795,   796,   796,   797,   797,   798,   798,   799,   799,   799,
     799,   800,   800,   801,   801,   802,   803,   803,   803,   804,
     804,   805,   806,   806,   807,   808,   808,   809,   810,   810,
     811,   811,   811,   811,   811,   811,   811,   811,   812,   812,
     813,   814,   814,   815,   815,   816,   817,   818,   819,   819,
     820,   821,   821,   821,   821,   821,   822,   822,   822,   823,
     823,   824,   824,   825,   825,   825,   825,   825,   825,   825,
     825,   826,   826,   827,   827,   827,   827,   827,   827,   828,
     828,   829,   829,   830,   831,   831,   831,   832,   832,   832,
     832,   832,   832,   832,   832,   833,   833,   834,   834,   834,
     835,   835,   835,   835,   836,   836,   837,   838,   838,   839,
     839,   840,   840,   840,   840,   840,   840,   840,   840,   841,
     841,   842,   842,   843,   843,   843,   844,   845,   846,   846,
     847,   847,   848,   848,   849,   849,   850,   850,   851,   851,
     852,   852,   853,   853,   854,   854,   855,   855,   856,   856,
     857,   857,   858,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   859,   859,   859,   859,   860,
     860,   860,   860,   861,   861,   861,   861,   862,   862,   863,
     863,   864,   864,   864,   864,   865,   865,   866,   866,   866,
     867,   868,   868,   869,   869,   869,   869,   870,   870,   871,
     872,   872,   872,   872,   872,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   875,   875,   875,   875,
     876,   876,   877,   877,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   878,   879,   879,   880,   880,   881,
     881,   882,   883,   884,   884,   885,   885,   886,   887,   888,
     888,   888,   888,   888,   888,   889,   889,   890,   890,   891,
     891,   891,   891,   892,   893,   893,   893,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   895,   895,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   900,   900,   901,   901,   901,   901,   902,   903,   903,
     904,   904,   905,   905,   906,   906,   906,   907,   907,   908,
     908,   909,   910,   910,   910,   911,   912,   912,   913,   913,
     914,   914,   914,   915,   915,   916,   916,   916,   917,   917,
     917,   918,   918,   918,   919,   919,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   921,   921,   922,   922,   923,
     923,   923,   923,   923,   923,   924,   924,   925,   925,   926,
     926,   926,   927,   927,   928,   928,   929,   929,   929,   929,
     929,   929,   929,   929,   930,   930,   931,   932,   932,   933,
     933,   933,   933,   933,   933,   934,   935,   936,   936,   936,
     937,   937,   938,   939,   939,   940,   941,   941,   942,   942,
     943,   943,   944,   944,   944,   944,   945,   945,   946,   946,
     947,   947,   948,   948,   949,   949,   950,   951,   951,   952,
     952,   952,   952,   953,   953,   954,   954,   955,   955,   956,
     956,   957,   958,   959,   960,   961,   962,   963,   963,   964,
     964,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   964,   965,   966,   967,   967,   967,   967,
     968,   968,   968,   968,   968,   968,   968,   969,   969,   969,
     969,   969,   969,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   973,   973,   974,   974,   975,   975,
     975,   975,   975,   975,   975,   975,   977,   976,   979,   978,
     980,   981,   981,   981,   981,   982,   982,   982,   982,   983,
     983,   984,   985,   986,   986,   987,   987,   987,   988,   988,
     989,   989,   990,   990,   991,   991,   991,   991,   992,   992,
     992,   993,   994,   994,   995,   995,   996,   996,   996,   996,
     997,   997,   998,   999,  1000,  1001,  1001,  1002,  1003,  1003,
    1004,  1004,  1004,  1004,  1004,  1006,  1005,  1007,  1008,  1009,
    1009,  1009,  1010,  1010,  1010,  1010,  1010,  1011,  1011,  1013,
    1012,  1015,  1014,  1016,  1014,  1014,  1017,  1017,  1018,  1018,
    1018,  1019,  1019,  1019,  1019,  1020,  1020,  1021,  1021,  1021,
    1021,  1021,  1021,  1022,  1022,  1022,  1023,  1025,  1024,  1026,
    1027,  1026,  1028,  1028,  1029,  1029,  1030,  1030,  1031,  1031,
    1031,  1031,  1031,  1031,  1031,  1031,  1031,  1032,  1032,  1032,
    1032,  1032,  1032,  1032,  1032,  1032,  1032,  1033,  1033,  1034,
    1034,  1035,  1036,  1036,  1037,  1037,  1037,  1038,  1039,  1040,
    1040,  1040,  1040,  1041,  1041,  1041,  1042,  1042,  1043,  1043,
    1044,  1045,  1045,  1046,  1046,  1047,  1048,  1049,  1049,  1050,
    1050,  1051,  1051,  1051,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1053,  1053,  1053,  1054,  1054,  1055,  1056,
    1057,  1058,  1058,  1059,  1060,  1061,  1061,  1062,  1063,  1063,
    1064,  1065,  1066,  1066,  1067,  1068,  1069,  1069,  1070,  1071,
    1071,  1071,  1071,  1071,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1073,
    1073,  1074,  1074,  1075,  1075,  1075,  1077,  1076,  1078,  1078,
    1080,  1079,  1081,  1081,  1081,  1082,  1082,  1082,  1082,  1082,
    1082,  1082,  1082,  1082,  1083,  1083,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1085,  1085,  1085,  1085,  1085,  1085,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1087,  1088,  1088,  1088,  1088,  1088,  1088,
    1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,  1089,  1089,
    1089,  1090,  1090,  1090,  1090,  1091,  1091,  1091,  1091,  1092,
    1092,  1092,  1092,  1092,  1092,  1092,  1093,  1093,  1094,  1094,
    1094,  1094,  1094,  1094,  1095,  1095,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1097,
    1097,  1098,  1099,  1099,  1100,  1100,  1101,  1102,  1103,  1103,
    1103,  1104,  1105,  1106,  1107,  1108,  1108,  1108,  1108,  1108,
    1109,  1110,  1110,  1110,  1111,  1111,  1112,  1112,  1112,  1113,
    1113,  1114,  1114,  1115,  1115,  1116,  1116,  1116,  1116,  1116,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
    1117,  1117,  1117,  1117,  1117,  1117,  1118,  1118,  1118,  1118,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1120,
    1120,  1120,  1120,  1120,  1121,  1121
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     5,     5,     4,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     1,
       0,     2,     0,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     5,
       2,     2,     2,     2,     3,     3,     3,     1,     3,     1,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     6,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       1,     3,     4,     5,     4,     2,     4,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     4,     4,     4,     4,
       1,     3,     3,     4,     6,     6,     6,     6,     4,     7,
       2,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       3,     3,     2,     2,     3,     2,     1,     1,     0,     2,
       0,     3,     2,     0,     1,     3,     3,     1,     5,     3,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     3,     3,     1,     1,     3,     3,     3,
       4,     1,     0,     2,     0,     3,     0,     1,     0,    11,
      12,     1,     1,     2,     2,     2,     2,     0,     1,     0,
       1,     3,     1,     1,     1,     3,     2,     0,     3,     1,
       1,     2,     1,     3,     4,     4,     2,     5,     1,     2,
       2,     2,     3,     2,     0,     2,     2,     2,     2,     2,
       2,     3,     1,     4,     6,     7,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     5,     9,     1,     0,     1,     2,
       2,     2,     1,     0,     2,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     7,     6,     8,     7,     6,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,     1,     1,
       1,     7,     9,     8,    14,    19,     1,     1,     1,     3,
       1,     1,     1,     1,     3,     0,     1,     0,     1,     1,
       1,     3,     0,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     4,     5,     4,     4,     4,     3,     7,
       8,     6,     6,     6,     6,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     3,    13,     1,     3,     4,     5,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     2,     4,     2,     5,
       4,     4,     3,     3,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     2,     2,     1,     2,     2,     1,
       1,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     9,     3,     0,     3,
       0,    13,    14,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,    11,    10,    10,     2,     2,
       0,     9,     2,     0,     4,     4,     4,     1,     1,     1,
       0,     7,     6,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     6,     6,     8,     8,     6,     6,     6,     8,
       8,     8,     8,     6,     1,     0,     2,     0,     7,     6,
       6,     6,     6,     6,     6,     7,     6,     6,     6,     6,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     1,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       6,     8,     2,     2,     2,     2,     2,     3,     3,     2,
       2,     2,     2,     3,     2,     5,     4,     3,     3,     3,
       1,     1,     0,     3,     2,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     2,     4,     1,     1,     1,     0,     1,     0,     1,
       0,     3,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     2,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     3,     5,     8,     1,
       0,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     0,     2,     0,     1,     3,     1,     0,
       1,     2,     4,     4,     2,     0,     2,     3,     2,     0,
       1,     3,     1,     2,     1,     2,     5,     6,     5,     1,
       2,     1,     4,     3,     4,     5,     4,     5,     4,     5,
       2,     4,     1,     2,     2,     2,     1,     1,     0,     4,
       2,     1,     2,     2,     4,     1,     3,     1,     2,     3,
       1,     2,     0,     2,     4,     4,     0,     1,     3,     2,
       2,     3,     5,     6,     2,     3,     3,     4,     0,     1,
       1,     1,     1,     1,     2,     5,     1,     1,     1,     1,
       2,     3,     3,     0,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     2,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     4,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     3,     2,     4,     2,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     4,     5,     6,     8,     6,     6,
       5,     1,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     1,     1,     1,     1,     1,     6,     4,     4,     4,
       4,     6,     5,     5,     5,     4,     6,     4,     4,     4,
       4,     5,     7,     7,     9,     4,     6,     5,     7,     7,
       7,     2,     3,     3,     3,     4,     0,     4,     1,     3,
       3,     1,     1,     1,     2,     2,     0,     2,     0,     1,
       3,     3,     2,     2,     0,     6,     1,     0,     3,     0,
       2,     2,     0,     1,     4,     2,     2,     2,     4,     3,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     4,     1,
       4,     1,     2,     1,     2,     1,     3,     1,     3,     3,
       3,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     3,     2,     3,     0,     3,
       3,     2,     2,     1,     0,     2,     2,     3,     2,     1,
       1,     3,     5,     1,     2,     4,     2,     0,     1,     0,
       1,     2,     2,     2,     3,     5,     1,     2,     0,     2,
       1,     0,     1,     1,     1,     3,     3,     1,     3,     3,
       2,     1,     1,     1,     1,     1,     3,     1,     2,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     5,     2,     3,     6,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     4,     3,
       2,     1,     1,     1,     1,     1,     0,     8,     0,    14,
       2,     5,     3,     2,     2,     3,     7,     1,     1,     1,
       0,     2,     2,     1,     0,     1,     3,     1,     2,     0,
       2,     0,     2,     0,     1,     3,     4,     3,     1,     1,
       1,     1,     2,     0,     2,     4,     0,     2,     2,     2,
       1,     1,     7,     3,     1,     1,     1,     1,     2,     0,
       1,     3,     3,     3,     3,     0,     4,     5,     5,     0,
       1,     1,     1,     1,     2,     2,     2,     1,     2,     0,
       7,     0,     5,     0,     4,     2,     2,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     0,     1,
       3,     5,     0,     2,     0,     1,     2,     3,     2,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     2,
       3,     0,     1,     2,     1,     4,     4,     0,     1,     1,
       3,     1,     1,     1,     1,     2,     2,     1,     2,     2,
       1,     1,     1,     4,     4,     4,     1,     0,     3,     3,
       4,     1,     3,     3,     4,     1,     3,     3,     1,     1,
       1,     6,     1,     3,     3,     6,     1,     3,     3,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       4,     1,     1,     4,     4,     3,     0,     7,     1,     0,
       0,     7,     3,     4,     3,     1,     1,     1,     2,     3,
       5,     2,     5,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     0,     1,     2,     1,     2,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       2,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     3,     2,     3,
       1,     3,     3,     3,     3,     3,     3,     1,     1,     0,
       2,     2,     1,     1,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    1756,     0,     2,     1,  2394,  2398,  2402,  2403,  2321,  2404,
    2405,  2370,  2371,  2372,  2373,  2374,  2375,  2376,  2377,  2378,
    2379,  2380,  2381,  2383,  2382,  2384,  2385,  2386,  2387,  2388,
    2389,  2390,  2391,  2393,  2392,  2342,  1763,  2339,  2336,  2337,
    2338,  2343,  2407,  2395,  2408,  2396,  2397,  2399,  2400,  2369,
    2401,  2409,  2410,  2411,  2406,  2341,  2334,  2335,  1594,  2414,
    2365,  2366,  2364,  2367,  2368,  2412,  2413,  2356,  2357,  2358,
    2359,  2415,  1764,  1765,  2361,  1757,  1761,  1825,  1898,  2362,
    2363,  2360,  1762,  2355,  1898,     0,  2016,  2017,  2018,     0,
    2019,  2020,  2021,  1947,  1912,  2022,     0,     0,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,     0,  2031,  2032,  2033,
    2034,  1897,  2035,  2036,  2037,  2038,  2039,  1874,  1880,  2000,
       0,  1854,  1855,  1851,  1853,  1852,  1856,  1839,   922,   459,
     994,   993,     0,  1655,   922,  1656,  1613,  1657,  1614,  1615,
    1616,   241,     0,   996,  1617,     0,   922,   322,   337,  1658,
    1659,  1780,     0,  1618,  1619,     0,     0,     0,   459,   922,
       0,     0,  1620,  1012,  1621,     0,  1622,  1660,  1661,     0,
    1623,  1662,  1663,  1624,     0,  1625,  1626,  1664,  1665,  1666,
    1627,  1667,  1668,     0,     0,  1106,     0,  1628,  1669,  1629,
    1630,     0,  1670,  1631,  1632,  1633,  1671,  1672,  1673,  1634,
    1635,  1636,     0,  1637,     0,     0,     0,     0,     0,  1674,
     922,  1638,     0,  1113,     0,  1639,     0,  1675,  1640,     0,
    1641,     0,  1642,  1643,  1644,  1645,  1106,  1996,  1875,     0,
       0,   998,     0,  1646,  1676,     0,  1647,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,     0,     0,    46,    47,    15,    14,
      20,    19,    68,    69,    36,     9,    59,    41,   100,    99,
     101,    26,    22,    54,    13,    23,    27,    43,    42,    12,
      40,    63,    44,    66,    33,    57,     6,    34,    58,     7,
      48,    70,    18,    45,    67,    29,    55,    52,    37,    38,
      39,    60,    61,    62,    84,    65,    95,    25,    74,    75,
      90,    76,    91,    77,    35,     8,    87,    86,    88,    30,
      56,    85,    89,    10,    11,    64,    82,    79,    96,    94,
     102,    80,    49,     3,     4,    71,    32,     5,    17,    16,
      31,    24,    98,    21,   996,    73,    83,    72,    78,    53,
      81,    97,    51,    93,  1082,  1069,  1115,  1081,     0,  1084,
    2072,  2073,    28,    92,   122,   104,   105,   110,  1760,  1814,
    1815,  1816,  1898,  1849,  1850,  1843,  1859,  1869,  1858,  1862,
    1870,  1857,  1876,     0,   107,   109,   111,   114,   108,   103,
     106,   113,   118,   112,   117,   115,   116,   119,   120,   121,
    2074,  1290,  2071,    50,  1831,     0,  1898,  1833,  1832,     0,
    2040,  2041,  2042,  2043,  2044,  2045,  2079,  2080,  2081,  2082,
    2083,  2085,  2084,  2331,  2096,  2097,  2098,  2099,  2100,  2101,
    2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,
    2112,  2113,  2114,  2115,  2116,  2117,  1605,  2118,  2119,  2120,
    2121,  2122,  2123,  2124,  2125,  2126,  2127,  2095,  2128,  2129,
    2130,  2131,  2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,
    2140,  2141,  2088,  2142,  2143,  2144,  2145,  2146,  2147,  2148,
    2149,  2150,  2151,  2152,  2153,  2154,  2155,  2156,  2157,  2158,
    2159,  2160,  2161,  2162,  2163,  2164,  2165,  2166,  2167,  2168,
    2169,  2170,  2171,  2172,  2173,  2174,  2175,  2089,  2176,  2177,
    2178,  2179,  2180,  2181,  2182,  2183,  2184,  2185,  2186,  2187,
    2188,  2189,  2190,  2191,  2192,  2193,  2194,  2195,  2196,  2197,
    2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,  2206,  2207,
    2090,  2208,  2209,  2091,  2210,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,
    2226,  2227,  2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,
    2238,  2236,  2237,  2239,  2240,  2241,  2242,  2243,  2244,  2245,
    2246,  2247,  2248,  2249,  2250,  2251,  2252,  2253,  2254,  2255,
    2256,  2257,  2258,  2259,  2260,  2261,  2262,  2263,  2264,  2265,
    2266,  2267,  2092,  2268,  2269,  2270,  2271,  2272,  2273,  2274,
    2275,  2276,  2277,  2278,  2279,  2280,  2281,  2282,  2283,  2284,
    2285,  2287,  2286,  2288,  2289,  2290,  2291,  2292,  1780,  2293,
    2294,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,  2303,
    2304,  2305,  2306,  2307,  1606,  2308,  2309,  2310,  2311,  2312,
    2313,  2314,  2315,  2316,  2093,  2317,  2318,  1798,  1595,  1602,
    1773,  1794,  1603,  2014,  2015,  1604,  1601,  2086,  2087,  2094,
    1800,  2327,  1799,  1600,  1946,     0,     0,  1911,  1910,  1914,
    1913,  1572,  1915,  1908,  1909,  1801,  1919,  1918,  1571,     0,
    1921,  2046,  2047,  2048,  2049,  2051,  2050,  2052,  1677,  1678,
    1679,  1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,  1688,
    2064,  1689,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,
    1698,  1699,  1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,
    1708,  1709,  1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,
    2065,  2066,  1718,  1719,  1720,  1721,  1722,  1723,  1724,  1725,
    1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,
    1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  2068,  1744,
    1745,  2067,  1746,  1747,  1748,  1749,  1750,  1751,  1752,  1753,
    2076,  2078,  2063,  1872,  2053,  2075,  2062,  2069,  2070,  2077,
    1882,  1878,  1886,  1881,     0,     0,     0,     0,  1898,   921,
     920,   906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   458,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1770,     0,   930,   301,   300,   995,
     984,   459,     0,   909,   321,     0,     0,     0,     0,     0,
       0,     0,   581,     0,     0,     0,     0,     0,     0,     0,
       0,   170,     0,     0,   332,   331,     0,     0,   446,     0,
     723,     0,     0,   459,     0,     0,     0,  1779,  1774,  1784,
       0,  1777,  1778,  1600,     0,  2418,  2236,  1810,  1811,  2416,
    2278,  1061,     0,   242,   245,   243,   244,     0,     0,   823,
     608,     0,   607,     0,     0,     0,   605,     0,     0,     0,
       0,   609,   603,     0,   602,     0,     0,     0,   606,     0,
     604,     0,     0,   910,     0,  1864,  1865,  2178,  1024,  1011,
     996,  2097,   672,   676,   667,   673,   679,   680,   668,   665,
     666,  2249,     0,     0,     0,     0,   656,  1596,   671,  1597,
     685,   378,   378,   378,     0,   684,   689,   378,     0,   903,
     937,  1576,  1105,     0,     0,   658,   902,  2293,  1016,     0,
       0,   827,     0,   828,     0,  2264,   914,   228,  2060,  2270,
    1642,  2293,  2061,   224,  2057,  2058,   197,  2059,  2055,  2056,
    2054,  2101,     0,     0,   684,     0,   911,   912,  1112,  1110,
       0,     0,     0,     0,     0,  2128,  2201,   221,  2260,  2265,
    2270,  1642,  2293,  2316,   179,     0,   235,  2270,  1642,  2293,
       0,   930,  1755,  1754,     0,  1085,  1567,  1191,  1564,  1563,
       0,     0,  1873,   905,   904,  1197,     0,   997,  1000,     0,
    1156,  2247,  1089,  1091,  1002,  1082,     0,  1759,   991,  1109,
    1109,     0,  1109,     0,  1074,  1082,  1115,  1081,     0,   922,
       0,  1841,  1869,  1848,  1904,  1845,     0,     0,  1894,  1890,
    1887,  1895,  1896,  1889,  1877,  1279,  1280,  1281,  1278,  1291,
    1277,     0,  1820,  1282,  1861,  1826,     0,  1836,  1835,  1834,
    2344,  2345,  1948,  1772,  1791,     0,     0,     0,     0,     0,
       0,  1927,  1920,  1922,  1924,  1884,  1883,  1879,     0,     0,
       0,     0,  2006,  2007,  2005,     0,  2002,  2004,     0,  1904,
       0,     0,  1577,  1609,  1603,  1611,  1604,  1601,  1600,     0,
     616,   125,     0,     0,     0,     0,     0,     0,  2120,  2166,
    1474,  1484,  1482,  1483,  1476,  1477,  1478,  1479,  1480,  1481,
       0,   813,  1475,     0,   125,     0,     0,     0,     0,     0,
       0,     0,     0,  2205,   125,     0,     0,     0,     0,     0,
     926,   929,   907,   987,     0,  1564,     0,     0,   641,     0,
     650,   642,   647,     0,   644,     0,     0,   652,     0,   643,
     645,   646,   651,     0,     0,   648,   649,     0,     0,   918,
     378,     0,     0,     0,     0,     0,   125,   974,     0,   336,
     335,   125,   334,   333,  2120,  2166,     0,   744,   125,     0,
     172,   487,   462,     0,     0,   548,  2205,   125,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1783,  1789,     0,
    1781,  1949,  2419,  2417,  1907,     0,  1036,  2177,     0,   288,
       0,     0,  2177,   965,     0,  2177,     0,  2177,   165,  1569,
    2120,  2166,  2177,     0,     0,  2177,   157,  2177,     0,  2177,
     288,  2177,   463,     0,  2177,     0,  2177,  2205,   159,     0,
    2177,   288,   614,     0,     0,  2349,  2353,     0,  2351,  2346,
    1863,  1917,  1916,  1813,     0,  2429,     0,   669,   678,   677,
     675,   674,   670,  1598,  1599,     0,   663,   664,  1927,  2435,
     662,   686,     0,     0,   693,   692,   691,     0,     0,     0,
     694,     0,  1195,  1039,     0,   917,     0,     0,     0,     0,
     830,   830,   830,   913,   227,   225,     0,     0,     0,     0,
       0,     0,   919,     0,     0,     0,  1613,  1614,  1615,  1539,
       0,  1605,  1616,  1617,  1404,  1391,  1400,  1405,  1392,  1394,
    1401,  1618,  1619,  2154,  1620,  1621,  1590,  1622,  1623,  1234,
    1625,  1626,  1627,  1396,  1398,  1628,  1629,     0,  1591,  1631,
    1632,  2228,  1634,  1635,  1637,  1638,  1402,  1640,  1641,  1642,
    1643,  1644,  1645,  1589,     0,  1403,  1646,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,  2333,  1583,  1485,  2332,     0,     0,
    1562,     0,  1379,     0,  1226,  1227,  1249,  1250,  1228,  1255,
    1256,  1268,  1229,     0,  1561,  1293,  1378,  1383,     0,  1377,
    1373,  1096,  1557,  1540,     0,  1374,  1579,  1593,  1592,  2327,
    1548,  1582,  1580,  1581,     0,     0,     0,   190,     0,     0,
    1995,   237,     0,   238,  1565,  2270,   180,   220,   192,   219,
     193,   222,   223,   191,     0,  2118,   181,     0,   188,     0,
       0,     0,     0,     0,     0,     0,   231,   908,     0,  1193,
       0,     0,  1546,  1568,  1192,   623,     0,     0,  1198,     0,
     999,   996,  1553,  1552,  1554,     0,  1090,     0,     0,     0,
    1072,  1071,  1002,  1107,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,  1149,  1130,  1146,  1150,     0,  1078,  1157,
    1758,  1904,  1905,     0,  1899,     0,  1898,  1898,  1892,  1891,
    1888,     0,     0,     0,     0,     0,     0,     0,  1817,   443,
    1819,   441,     0,     0,  1793,     0,  1797,  1795,  1927,  1943,
    1927,  1944,  1945,     0,  1950,  1951,     0,  1928,  2340,     0,
       0,  1934,     0,  1923,  1929,  1931,  1933,  1932,  1941,  1937,
    1940,  1942,  1885,  1898,  2013,     0,  2008,  2011,     0,  2003,
       0,  1578,     0,     0,     0,     0,     0,   617,     0,     0,
       0,   124,   963,   230,   961,     0,     0,     0,     0,   968,
       0,     0,     0,     0,   777,     0,     0,     0,     0,     0,
       0,   778,   776,   779,   786,   799,   802,     0,   713,   163,
     164,     0,     0,   855,   855,     0,     0,   855,     0,     0,
       0,     0,     0,     0,     0,   247,   250,     0,     0,     0,
       0,     0,     0,     0,   127,   154,     0,     0,     0,   428,
     440,     0,     0,     0,     0,     0,   437,     0,   125,   248,
     422,   425,     0,     0,     0,   496,   495,   855,     0,   246,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   127,   156,     0,     0,   249,     0,  1827,     0,
     924,   925,     0,   928,     0,   983,     0,     0,     0,     0,
       0,     0,  2120,  2166,     0,     0,     0,     0,     0,     0,
     324,   307,   308,   125,   306,     0,     0,   545,     0,  1237,
    1266,  1244,  1266,  1266,  1233,  1233,  1246,  1235,  1273,     0,
    1266,  1233,  1238,     0,  1236,  1276,  1276,  1261,     0,  1218,
    1219,  1220,  1221,  1247,  1248,  1222,  1253,  1254,  1223,  1290,
    1233,  1610,  1612,  1608,  1607,     0,   940,   973,     0,     0,
     127,   582,     0,     0,   546,     0,   127,     0,   168,     0,
     491,     0,     0,     0,     0,     0,     0,   507,   506,     0,
       0,   547,     0,   127,   424,     0,   414,   378,     0,     0,
    2126,     0,  1575,     0,     0,  1787,  1785,  1782,     0,  1775,
    1789,  1064,  1066,  1065,     0,  1063,     0,  1206,     0,   288,
     286,   287,   543,   822,     0,     0,     0,     0,   288,     0,
       0,  2177,     0,  2177,     0,     0,   288,   288,     0,     0,
       0,     0,   492,     0,   613,   611,   610,   612,     0,     0,
       0,     0,     0,  2177,   288,     0,     0,   601,  2347,     0,
       0,  2350,     0,  1866,  1495,     0,  2432,  1021,  2433,   337,
       0,     0,  1003,  1010,  1005,  1007,  1006,  1008,  1004,  1009,
     655,   660,   661,     0,  2434,  2319,  2325,     0,     0,   379,
     381,     0,  2141,     0,  2170,  2193,  2265,  2268,     0,  2288,
       0,   695,   718,   690,     0,     0,  1033,  1026,     0,     0,
    1049,   657,  1014,  1497,     0,     0,     0,   829,   826,   825,
     824,   226,   198,     0,     0,     0,   720,  2264,   916,     0,
       0,  1381,  1382,  1265,  1252,  1538,     0,     0,  1260,  1259,
       0,     0,     0,     0,  1242,  1241,  1240,  1380,  1505,     0,
    1239,     0,     0,     0,     0,  1266,  1266,  1264,  1312,     0,
    1243,     0,     0,  1518,     0,  1524,     0,     0,     0,  1272,
       0,  1270,     0,     0,  1348,     0,     0,     0,     0,     0,
       0,     0,  1296,  1297,  1606,  1379,  1495,     0,  1586,     0,
       0,  1258,     0,  1290,     0,     0,     0,     0,  1551,  1493,
       0,     0,  1326,  1491,     0,  1328,     0,     0,     0,  1485,
    1484,  1482,  1483,  1476,  1477,  1478,  1479,  1480,  1481,  1489,
    1309,     0,  1560,     0,  1308,  1927,     0,  1159,  1095,  1541,
       0,  1584,     0,  2326,  2328,  1375,  1992,  1991,  1990,  1989,
    1960,     0,  1954,  1955,     0,  1993,  1994,   239,   240,   236,
       0,     0,   195,   194,     0,   217,   218,   187,   216,     0,
     212,   213,  1443,  1442,   196,   186,   184,   209,   211,   210,
     208,   182,   199,   201,   202,   203,   185,   183,   234,   232,
       0,     0,     0,  1543,  1542,  1574,  1547,     0,     0,   288,
    1898,  1199,     0,  1159,  1051,  1053,  1054,     0,  1548,   988,
    1556,     0,  1092,     0,     0,   992,  1088,  1081,  1087,  1116,
    1117,   737,  1086,  1140,  1141,  1135,     0,  1155,  1155,  1132,
    1123,  1131,  1124,     0,  1136,  1293,  1148,  1076,  1129,  1075,
       0,  1151,  1149,  1130,     0,  1906,  1904,  1844,  1218,  1898,
    1837,  1898,  1893,  1823,  1284,  1285,  1286,  1287,  1288,  1289,
    1824,     0,  1821,  1283,  1822,   442,     0,     0,     0,  1790,
       0,  1771,  1796,  1958,     0,  1959,     0,     0,  1935,  1938,
    1936,  1939,     0,     0,  1218,  2322,  2009,  2322,  1218,     0,
       0,     0,     0,     0,     0,     0,   618,     0,     0,     0,
    2288,   229,   959,     0,     0,     0,     0,     0,   971,   372,
       0,   285,     0,     0,     0,     0,     0,     0,     0,   784,
       0,     0,     0,     0,   785,   782,   783,  2265,   801,   800,
     798,   759,   761,   760,     0,   763,   747,     0,   748,     0,
       0,   758,   766,   764,     0,     0,   854,   260,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   278,
       0,     0,     0,     0,   283,     0,     0,     0,   282,     0,
       0,     0,     0,     0,     0,   814,     0,   153,     0,     0,
     427,   439,     0,   431,   432,   429,   433,   434,     0,     0,
       0,     0,     0,     0,   426,     0,     0,   489,   488,   494,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   498,   499,     0,   500,     0,   155,     0,
       0,     0,     0,     0,     0,   207,   923,   927,   986,   985,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   310,
       0,   568,  1607,   544,     0,  1218,     0,  1214,  1210,  1279,
    1278,  1277,     0,  1224,  1233,  1230,     0,   938,   347,   453,
     161,     0,     0,     0,   556,   559,     0,   123,   172,   337,
       0,   171,   173,   175,   176,   177,   174,   178,   486,   490,
       0,   461,     0,     0,     0,     0,     0,   511,   510,   513,
     512,     0,   508,     0,     0,     0,   152,   421,   423,  1766,
       0,   339,   403,     0,   444,     0,     0,     0,     0,     0,
    1768,     0,  1788,     0,     0,     0,     0,  1062,     0,  1169,
    1035,  1160,  1171,  1162,  1164,  1200,  1567,     0,     0,  1033,
       0,   805,     0,   966,  2177,   288,     0,   803,   166,  1570,
       0,     0,     0,     0,     0,   807,   598,   158,     0,   288,
     288,   464,     0,   288,   160,     0,     0,     0,   456,   288,
     615,  2348,  2354,  2352,  1023,     0,  2430,  2431,     0,  1061,
     659,     0,     0,  2324,     0,   687,     0,   377,   701,     0,
       0,   700,   711,   702,   703,   697,   696,   704,     0,     0,
     720,  1028,     0,  1029,  1548,     0,  1025,     0,  1046,     0,
    1044,     0,  1196,  1048,  1037,  1015,     0,  1013,  1018,  1020,
    1019,  1017,     0,     0,     0,   684,     0,     0,   288,   915,
       0,  1501,     0,  1502,     0,     0,     0,  1537,  1533,     0,
       0,     0,     0,     0,  1509,  1510,  1511,  1508,  1512,  1507,
       0,     0,  1513,  1506,     0,     0,     0,     0,     0,  1263,
    1262,     0,     0,     0,     0,     0,     0,     0,  1351,  1383,
       0,     0,  1469,     0,  1495,  1523,     0,     0,  1274,     0,
       0,     0,     0,     0,     0,     0,  1495,  1529,     0,     0,
       0,  1441,     0,  1438,     0,     0,     0,     0,  1548,     0,
       0,     0,     0,  1587,  1294,  1310,  1559,     0,  1550,     0,
       0,  1317,     0,  1530,  1344,     0,  1349,  1332,     0,  1325,
       0,  1330,  1334,  1313,  1551,  1494,     0,  1492,     0,     0,
    1311,     0,  1306,  1304,  1305,  1298,  1299,  1300,  1301,  1302,
    1303,  1307,  1473,  1471,  1472,     0,     0,     0,  1329,  2035,
    2171,  2201,     0,  1106,  1106,  1094,  1104,  1558,     0,  1202,
       0,     0,     0,     0,  1454,     0,  2330,  2329,  1549,     0,
       0,     0,  1566,     0,     0,  1290,     0,   233,  1194,  1544,
       0,   621,   622,   620,  1218,  1058,     0,     0,  1206,     0,
    1057,   990,   989,  1555,  1001,  1093,     0,   735,   736,     0,
     740,     0,     0,  1133,  1147,     0,  1049,  1049,     0,     0,
       0,  1138,  1139,  1126,  1080,  1079,  1842,  1900,  1847,  1868,
    1838,  1871,  1292,  1818,  1860,     0,  1792,  1961,  1962,     0,
    1952,  1953,  1925,  1930,  1999,     0,  2323,     0,     0,   566,
     565,     0,     0,     0,   866,   832,   619,   867,   833,   960,
       0,   962,     0,     0,     0,     0,     0,   288,   969,   868,
     284,   970,   859,     0,     0,     0,   469,   470,     0,   780,
     781,   869,   834,     0,   860,   762,  1233,   746,     0,     0,
     757,     0,   756,  1233,  1233,   835,   162,   252,     0,   857,
     264,   277,   272,   273,   271,   288,   288,     0,     0,     0,
       0,   274,   269,   270,   266,   279,   280,   843,     0,   294,
     297,   281,   262,   265,   263,   251,     0,  1573,     0,     0,
     809,     0,     0,   846,     0,     0,   136,   138,   140,     0,
       0,   134,   142,   137,   139,   141,   135,   143,   133,     0,
       0,   132,     0,     0,     0,     0,   126,   874,   839,   430,
     435,   841,   438,   862,   436,  2100,  2155,  2271,     0,   476,
     478,     0,   483,   880,   840,     0,   861,   876,   848,     0,
       0,     0,     0,     0,     0,     0,   975,     0,     0,     0,
     875,   853,   864,     0,   847,   842,   863,     0,     0,   205,
     204,   206,     0,     0,     0,     0,     0,     0,     0,     0,
     654,   630,   653,     0,     0,     0,     0,     0,     0,     0,
     624,   323,   304,   305,     0,   303,   567,     0,     0,     0,
    1215,  1211,     0,     0,     0,     0,     0,     0,  1231,     0,
       0,   958,   958,   958,   958,   958,   958,   958,   939,   967,
     452,   472,     0,   587,   555,     0,     0,   378,   167,     0,
       0,     0,   460,   554,   552,   551,   553,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,     0,     0,   338,
     340,   342,   343,   344,     0,   415,   417,     0,     0,   407,
       0,     0,     0,     0,   726,   751,     0,   769,   752,     0,
       0,     0,   789,   794,   790,   772,     0,  1786,  1780,  1067,
    1068,     0,  1082,     0,  1171,     0,  1170,  1182,     0,     0,
    1188,  1186,     0,  1188,     0,  1188,     0,  1163,     0,  1165,
    1182,  1568,     0,     0,  1203,  1034,   288,     0,     0,   466,
     288,     0,   288,     0,   288,   288,     0,   900,   493,     0,
     540,     0,     0,   288,   600,  1496,     0,     0,  1926,  2320,
     688,   380,     0,   699,     0,     0,   710,   705,   707,     0,
     714,     0,     0,  1031,  1032,  1047,  1040,  1042,  1041,     0,
       0,  1038,  1498,   599,     0,     0,   288,     0,   715,  1111,
    1499,  1500,     0,     0,     0,     0,  1534,     0,     0,  1417,
    1393,  1395,  1232,  1407,     0,  1245,  1418,  1419,  1397,  1399,
       0,  1486,     0,     0,  1408,  1353,  1354,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1366,  1365,  1409,  1468,     0,     0,  1521,  1522,  1410,  1275,
    1276,  1276,     0,     0,  1528,     0,     0,     0,  1415,  1420,
       0,     0,  1425,     0,  1446,     0,     0,     0,  1376,  1496,
    1267,  1268,     0,     0,     0,     0,     0,     0,     0,     0,
    1350,  1333,  1327,     0,  1331,  1335,     0,     0,     0,     0,
    1319,  1345,  1315,     0,     0,  1321,     0,  1346,  1106,  1106,
    1106,  1106,  1103,     0,     0,  1158,     0,  1143,     0,     0,
       0,  1454,     0,  1384,  1454,     0,  1974,  1976,  1977,  1978,
    1979,  1980,  1982,  1983,  1985,  1986,  1987,  1975,  1981,  1984,
    1988,  1965,  1966,     0,  1956,  1957,   189,     0,   214,   200,
       0,  1999,     0,     0,  1052,  1033,  1055,  1118,     0,  1487,
     740,   738,   739,  1120,     0,     0,  1154,  1153,  1152,  1121,
    1125,  1122,     0,     0,  1902,  1828,     0,     0,  1998,  2001,
    2012,  2010,  1840,   865,   831,   858,   958,     0,   371,     0,
       0,     0,   972,   451,     0,   450,   448,   468,   774,     0,
    1233,   749,   754,   755,     0,   347,     0,     0,   253,     0,
     261,   258,   275,   267,   276,   268,   291,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   871,
     148,     0,     0,     0,     0,   129,   128,   149,   147,     0,
     146,     0,   480,   481,   479,   475,     0,   482,   484,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   870,   836,   625,     0,     0,   626,   634,     0,     0,
     627,     0,     0,     0,     0,     0,     0,   636,   326,   311,
     315,   974,   974,     0,   316,   974,   312,   974,   309,   569,
       0,  2228,  1476,  1477,   563,   570,   560,   562,   561,   564,
     535,     0,     0,     0,  1216,     0,  2420,  2428,  2427,     0,
    1290,     0,   958,   957,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   358,     0,     0,   352,     0,     0,
     794,   346,   349,   350,     0,   465,     0,   557,   558,     0,
     337,     0,     0,   515,   509,     0,   571,   549,     0,  1209,
     472,  1024,   420,   339,   364,   399,     0,   413,     0,   401,
     400,   402,     0,   409,   936,   453,     0,   726,     0,     0,
     750,     0,     0,     0,   787,   791,   788,     0,     0,   765,
       0,   773,   743,     0,  1803,  1060,  1812,  1173,  1180,     0,
    1161,     0,  1187,  1183,     0,  1184,     0,     0,  1185,     0,
       0,  1180,     0,     0,     0,   806,     0,   288,   804,     0,
     594,     0,   596,   808,   288,   288,   501,     0,   457,   414,
    1066,   698,   712,   708,     0,     0,   681,   717,  1027,  1030,
    1045,  1043,   720,     0,   682,   719,  1503,  1251,     0,  1536,
    1532,     0,  1504,     0,  1516,  1515,  1352,  1517,     0,  1371,
       0,     0,  1363,  1361,  1362,  1355,  1356,  1357,  1358,  1359,
    1360,  1364,  1526,  1525,  1519,  1520,  1271,  1269,     0,  1412,
    1413,  1414,  1527,  1421,     0,  1440,  1439,     0,     0,     0,
    1427,     0,     0,  1436,     0,  1470,  1257,  1290,  1295,     0,
       0,  1318,  1531,  1336,     0,     0,     0,  1314,     0,     0,
       0,     0,  1323,  1486,     0,     0,     0,     0,     0,     0,
    1098,  1097,  1201,     0,  1145,  1454,  1454,  1454,  1390,  1457,
    1452,  1453,  1385,  1585,     0,     0,     0,     0,  1545,  1997,
       0,  1059,  1050,     0,  1119,  1134,  1127,  1135,  1846,     0,
    1901,  1963,  1964,     0,   373,     0,     0,   794,   879,   449,
     775,     0,   767,   345,     0,   856,     0,     0,     0,     0,
     295,   296,   299,     0,     0,     0,     0,     0,   588,   574,
       0,     0,   589,   590,     0,     0,   811,   812,   810,   144,
     130,   151,   150,   131,   145,   477,   844,     0,     0,     0,
       0,     0,   878,   852,   877,   850,   849,   851,   845,   503,
       0,   628,     0,     0,   629,   640,   638,   637,   639,   631,
     327,   125,     0,     0,     0,     0,     0,     0,     0,   537,
       0,     0,   542,   531,   533,     0,     0,     0,  1212,     0,
       0,     0,     0,     0,     0,  1217,  1225,   530,     0,   949,
     948,   947,   951,   950,   953,   952,   944,   943,   956,   955,
     942,   941,   946,   945,     0,     0,   356,   360,   361,   359,
     351,   794,   378,   411,     0,     0,     0,     0,     0,   517,
       0,   550,     0,  1208,   497,  1022,     0,  1767,     0,   362,
       0,   403,   341,   416,   417,     0,     0,   412,     0,   931,
     455,     0,     0,   725,     0,   753,   770,   771,     0,     0,
     794,   793,   895,   896,   893,   894,     0,     0,  1776,  1172,
       0,     0,  1174,     0,     0,  1176,  1178,     0,     0,     0,
       0,     0,  1571,  1454,  1204,  1205,   288,   467,   288,   288,
     901,   541,     0,     0,     0,     0,   706,   288,     0,  1535,
    1406,  1416,  1514,     0,     0,  1372,     0,     0,  1411,  1647,
       0,     0,  1444,  1445,  1426,     0,  2214,  1431,     0,     0,
       0,  1588,  1342,  1340,  1337,     0,  1338,     0,     0,  1320,
    1316,     0,  1322,  1347,  1102,  1101,  1100,  1099,     0,     0,
    1448,  1388,  1389,  1386,  1459,  1456,     0,  1967,     0,  1970,
    1968,  1969,  1973,  1290,  1056,     0,     0,  1903,   964,     0,
     794,   411,   768,   254,   255,   256,   257,   290,     0,   872,
     837,     0,     0,   580,     0,     0,     0,     0,   873,   838,
       0,     0,     0,   980,     0,     0,   632,   633,   310,     0,
     313,   318,     0,   319,   314,   317,   539,   538,   536,   532,
     534,  1213,     0,   820,   820,  2421,  2422,  2423,  2424,  2425,
    2426,     0,   535,   954,     0,     0,   348,   411,   385,     0,
     353,     0,   473,     0,   936,   339,   472,   516,     0,     0,
     572,   418,     0,   403,     0,     0,   363,     0,   407,     0,
     404,     0,   408,     0,     0,     0,     0,   445,     0,     0,
       0,     0,   727,   734,   734,   792,     0,   796,     0,   764,
     741,     0,  1806,  1802,     0,  1181,  1190,     0,  1177,  1175,
    1166,     0,  1168,   821,   595,   597,   502,     0,   709,   716,
     288,  1367,     0,     0,     0,     0,  1422,     0,  1423,  1428,
    1432,     0,  1429,  1430,  1339,  1343,  1341,  1324,  1142,  1144,
       0,  1083,     0,  1115,  1454,  1972,  1971,   215,  1488,     0,
       0,   411,   374,     0,   259,   298,     0,     0,   586,   575,
       0,     0,   591,     0,     0,     0,     0,     0,   635,   302,
     325,   320,   820,     0,   817,   816,   529,     0,   355,   354,
       0,   390,     0,   471,     0,   584,   932,   485,   518,   519,
     514,     0,   419,   407,   368,   366,   370,   367,   365,   369,
       0,   409,   405,   406,     0,   933,     0,   454,   982,     0,
       0,   293,     0,     0,   732,   737,   737,   795,     0,     0,
    1202,     0,  1804,  1179,     0,  1167,   683,  1368,     0,  1369,
       0,     0,  1434,  1433,  1447,  1449,     0,     0,  1462,  1114,
    1387,  1128,   378,   375,   289,     0,   578,   585,   576,   586,
       0,     0,   976,     0,   977,   978,   981,   815,   819,   818,
       0,   382,   383,   384,     0,   357,   386,   387,     0,   474,
       0,     0,     0,   409,   398,   329,   934,   935,   293,   734,
       0,   409,   728,   733,   740,   740,   794,   797,     0,  1807,
    1809,  1808,     0,  1189,  1370,  1437,  1424,  1435,     0,     0,
    1458,     0,     0,     0,   385,     0,   577,   593,   592,     0,
       0,     0,     0,     0,   388,     0,   389,   410,   583,     0,
     522,   330,   409,   737,   292,  1202,   730,   729,   742,   899,
    1805,  1450,  1451,     0,     0,     0,  1460,  1463,  1461,  1455,
     390,     0,   979,     0,   395,     0,   394,     0,   392,   391,
     573,   527,     0,   520,   523,   528,   526,   524,   525,  1202,
     740,   721,   898,   897,     0,     0,  1467,  1466,  1465,   535,
     579,     0,   393,   397,   396,   504,     0,   722,   731,   881,
     892,  1769,   882,   890,   887,   889,   888,   886,     0,   376,
       0,   521,     0,   891,   885,  1082,  1069,  1464,     0,   883,
     892,   522,   884,     0,   505
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   245,   246,  1572,  2237,  2806,   247,   248,   249,
     250,   251,   252,   253,   254,   255,  1602,   256,   257,  1199,
    1748,  2341,   258,  2161,   995,  2041,  2042,  2286,  2043,  2027,
    1438,  2044,  1573,  1594,   260,   261,  1432,  2019,   262,   263,
     264,  1615,  1616,  1579,  1792,  3984,  2228,  4111,  2768,  2769,
     265,   266,  2874,  1693,  2875,  3318,   825,  2308,  3641,  3642,
     267,  1745,  2928,  2929,  2930,  2931,  2899,  3361,  3362,  3363,
    2932,  3709,  3906,  2933,  2169,  1294,  1858,  1859,  4011,  4095,
    4096,  4097,  4178,  3711,  2939,  3393,  3717,  3890,  1765,  2372,
    2934,  2935,  3707,   268,   269,  2367,  1640,  1641,  2242,  3324,
     270,   853,  3225,  2900,  2901,  3917,   271,   813,   272,  1752,
     273,   274,   275,   276,  3365,  3891,  1645,  2818,  2819,  2820,
    2821,  3277,   277,  1750,  1646,  2350,   278,   279,   280,  2275,
     281,   282,   283,  1759,  2361,  2362,  3700,  3898,  4020,  4182,
    4183,  3882,  3652,  3653,  3654,   284,   285,   286,   287,  1744,
    2333,  2334,  3325,  1563,  1697,  2310,  2311,  3375,   288,  3598,
    3599,   854,  4101,  4078,   289,   290,  3602,  3603,   291,   292,
     293,   294,   295,   902,  1261,  1262,  2744,   296,  2059,   297,
    1178,  2861,   298,   924,   925,   299,   300,   934,  2485,   936,
    1870,  3016,  3017,  3456,  2451,  1114,   301,   302,  2460,  2488,
     303,   855,  3399,  3921,  3922,  4045,  2660,  3193,   304,   856,
    1598,  2197,  2379,  2946,  2947,  2199,  2200,  3408,  2201,  2948,
    2953,  2954,  2955,  3404,  3412,  3927,  3928,   305,  1596,  2190,
     306,   307,   308,  1620,  1130,   309,  4004,   310,  1231,   311,
     954,  1888,   312,  2208,  3239,   313,   314,  4211,  4222,  4223,
    4224,  3736,  4194,   315,  4213,   317,   318,   319,   816,  1150,
    1151,  1152,   320,  3719,   321,   322,  2327,  2898,  3344,   323,
     324,  2162,  2711,   325,   326,   327,  1738,   328,   329,   330,
     331,  1675,   332,   333,   334,   820,  1018,  1471,  1479,   335,
    1842,   910,   336,  1308,  2477,   337,  1275,  4214,  1876,  2462,
    2463,  2466,  4215,  1787,   340,  1880,  2471,  2474,  4216,  2063,
    2064,  2065,  2066,  2067,  2646,   342,  1225,  2386,  4217,  1392,
     345,   346,   347,   348,  1022,  1023,  1997,  2615,   943,  1485,
     980,  1033,  1034,  2079,  2080,  2098,  2099,  2090,  2662,  2092,
    2093,  2673,  2085,  3544,  3810,  2096,  2097,  1495,  1496,  2666,
     349,  2619,  2390,  2391,  2392,  2966,  2976,  3423,  3745,  2393,
    1303,  1016,  2394,  3147,  2399,  2920,  2921,  2202,  2318,  1719,
    1393,  1720,  2325,  1394,  1920,  1722,  1395,  1396,  1397,  1725,
    1398,  1399,  1400,  1401,  1904,  1961,  1402,  1403,  1939,  1062,
    1063,  1834,  2527,  1405,  1406,  3513,  3789,  3780,  2552,  2553,
    2034,  3509,  3971,  4064,  4065,  3552,  3550,  3814,  3973,  4133,
    4166,  4167,  1407,  2605,  1989,  1132,  1408,  3327,  1991,  2547,
    2150,  1902,  2494,  2510,  2511,  2524,  3063,  2531,  2536,  3086,
    3087,  2548,  2574,  1409,  2497,  2498,  3047,  1906,  1410,  1462,
    1463,  2005,  2570,  1474,  1475,  1020,  1411,  1412,  1413,  1871,
    1007,  3741,  1239,   670,  2776,  2054,  1154,   940,  1414,  1415,
    1416,   647,  1519,  1008,  1102,   649,  1103,   770,  1009,     2,
      75,   352,  2925,   353,  2956,   354,   355,   858,   859,   860,
    1217,  1218,  1777,  1779,  1524,  2131,   650,   651,   868,  3738,
    3933,  4052,   908,   356,   357,   358,   359,  1520,  2127,  1064,
      76,    84,    77,  1065,   395,   396,  2109,   360,   788,  2110,
    1501,  1044,  3204,   362,   363,   364,   365,   366,   905,   367,
    1046,   368,  1047,   369,   370,   371,   372,  1054,   373,  1503,
    1504,  3570,  1505,   374,   375,   673,   674,  1273,   376,   377,
    1082,  1083,  1084,  1289,  1853,  1543,  1544,  1545,   378,   666,
     379,   380,   381,  1534,  1535,   382,  2012,  2013,  2134,  2014,
     383,  2687,  2688,   384,  3171,  3172,  3820,  3173,   385,  2008,
     386,   387,  1011,  3209,   388,   784,   389,  1096,   652,   653,
     654,  1105,   773,   966,  2822,   775,   776,   655,   656,   657,
     658,   659,  1854,    78,  2695,  1855,  1417,  1418,  2003,  1419,
    1420,  1421,  1422,  1423,  1551,   663,  1072,  1265,  1266,  2696,
    1268,    82,  1269,   393,  3339,  1837,  1290
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3761
static const int yypact[] =
{
   -3761,   360, 10074, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, 18547, -3761,
   -3761, -3761, -3761, -3761, 82904,   616, -3761, -3761, -3761, 44732,
   -3761, -3761, -3761,   245, 55590, -3761, 63126,  1086, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, 69720, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, 48042,  1262, -3761,
     370, -3761, -3761, -3761, -3761, -3761, -3761, -3761,   592,  8473,
   -3761, -3761, 59829, -3761,    65, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, 63597,   716, -3761,   794,   791,   108, 11191, -3761,
   -3761, 45678, 57945, -3761, -3761, 70191,   972,   131,  6374,   592,
   18073, 64068, -3761,  1861, -3761, 42330, -3761, -3761, -3761, 56061,
   -3761, -3761, -3761, -3761,   974, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, 69720,   296,   934, 42814, -3761, -3761, -3761,
   -3761, 69720, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, 64539, -3761,  1222,   756, 70662, 71133, 55119, -3761,
    1188, -3761, 69720,  1045, 47570, -3761, 71604, -3761, -3761,  1136,
   -3761, 58416, -3761, -3761, -3761, -3761,   934, -3761, 48042, 40406,
   58416,  1139,  1091, -3761, -3761, 72075, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761,  1241,  1099, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761,   716, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761,  1278, -3761,   741,  1289,  1264,  1114,
   -3761, -3761, -3761, -3761,  4362, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, 84305,   301, -3761, -3761, -3761,  1178, -3761,  1187,
   -3761, -3761, -3761,  1375, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,  1528, -3761, -3761, -3761,  1672, 83371, -3761, -3761, 65010,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, 45205, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,   137, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, 69720, 69720, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, 65010,
    1286, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
     414,  1488, -3761, -3761, 48042,  2313,  2313,  1852, 84305, -3761,
   -3761, -3761, 48986, 69720, 69720, 69720,  1643, 48986, 69720, 60300,
   37021, -3761, 69720, 69720, 60300, 69720, 58416, 69720,  1497, 69720,
   69720, 72546, 60300,  1621, -3761,  1860,   679, -3761, -3761, -3761,
   60300, 10616,   296, -3761, -3761, 60300,  1484, 48986, 69720,  1420,
    1511, 69720, -3761, 69720,  1806,  1384, 69720,  1470, 37509,  1611,
   69720, 69720, 69720, 69720, -3761, -3761,  1617, 69720, -3761, 69720,
   -3761, 73017,  1210,  1635,  1857,  1769,    77, -3761, -3761,  1560,
    1507, -3761, -3761,  1958, 65010, -3761, 60771, -3761, -3761, -3761,
     126, -3761, 58416, -3761, -3761, -3761, -3761, 49458, 69720,  1831,
   -3761, 73488, -3761,  1903, 49930, 73959, -3761, 37997,  1963, 74430,
   74901, -3761, -3761, 75372, -3761, 75843,  1705, 76314, -3761, 76785,
   -3761,  1854, 77256, -3761, 16853, -3761,  1659,  1950,  1656, -3761,
     716,   236, -3761,    91,   164,   198, -3761, -3761,   228,   241,
     258,   236,  1693,  1693, 61242, 69720,  1930, -3761, -3761, -3761,
     410,  1697,  1697,  1697,  1880,   -83, -3761,  1697, 60300, -3761,
   -3761, -3761, -3761, 58416,  1126, -3761, -3761,   296,   225,  2087,
   69720, -3761, 69720, -3761, 60300, 69720, -3761, -3761, -3761,  2100,
    1736,  1956, -3761,  1742, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,  1898,  1927,  1959,    24,   296,  1872, -3761, -3761,  1993,
   24438,   906, 65010,   296, 43298, 58887, 77727,   313, 46624,   296,
   65481,  1844,   679,  2006, -3761,    28, -3761,  2227,  1863,  2083,
     386,   679, -3761, -3761, 34638, -3761,  1352,  1882, -3761, -3761,
   58416, 84772, -3761, -3761, -3761, 78198,  1964, -3761,  2132, 24931,
   -3761, 69720,  1876, -3761,  1864,  1887,  1897, -3761, 60300,  1119,
    1119,  2267,  1119,  1279,  1686, -3761,   741,  1306,  1091,   592,
    1941, -3761, -3761, -3761,  1909, -3761,  1925,  1928, -3761,   456,
    2198, -3761, -3761, -3761, -3761,  2052,  2066,  2094,  2098,  1967,
    2103,   379, -3761, -3761, -3761, -3761,  2309, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761,  2440,  2425, 45678, 45678,  2108,    -6,
     153,   359, -3761, -3761, -3761,  2302, -3761, -3761,  2315, 69720,
    2156, 69720, -3761, -3761, -3761, 78669, -3761, -3761,  2313,  1909,
    1352,  2091, -3761, -3761,   237, -3761,   367,   395,   420,   500,
    2099,  1185,   557,  2125,  2684,  2109,   717,  2855, 69720, 69720,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
    2110, -3761, -3761,  2106,  1364,   871,  6962,   764,  3799,  1085,
     670,  2291,  1394,  2405,  1381,  4054, 69720,  2121,  2357,   -26,
   -3761,    16, -3761,  2187,  2310,  2311, 48986,  2134, -3761, 69720,
   -3761, -3761, -3761, 48986, -3761,  2318, 38485, -3761, 69720, -3761,
   -3761, -3761, -3761,  2255, 69720, -3761, -3761,  2375, 69720, -3761,
    1697,   185,  2139,  2512, 52290, 69720,  2183,  2542,  2186, -3761,
   -3761,  2183, -3761, -3761, 69720, 69720,  2145,  1323,  2183,  2543,
    2544,  2218,  2319,   712,  1356,   109,  2441,  2183, 60300, 60300,
   60300,  2390, 69720, 79140, 48986, 69720, 65952, -3761,  2150,  1560,
   -3761, -3761, -3761, -3761, -3761,  1062,  2215,  2457,  2091,   324,
    2458,  2166,  2464, -3761,  2207,  2467,  2109,  2468,  2169, -3761,
   79611, 80082,  2470,  2110, 69720,  2473,  2169,  2477,  2367,  2485,
     324,  2486, -3761,   724,  2487,  2371,  2489,  1405,  2169, 47097,
    2490,    60, -3761, 17430, 16853, -3761, 20039,  1460, -3761, -3761,
   -3761, -3761, -3761, -3761, 27396,    39,  1595, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, 69720,  1930,  1930,  1183, -3761,
   -3761,  2194, 69720, 69720, -3761, -3761, -3761, 56532, 69720, 59358,
   -3761,   256, -3761,     3, 69720, -3761,  1950, 52290,  2595, 69720,
    2483,  2483,  2483, -3761, -3761, -3761,  2427, 69720,  2495,  2496,
   56532, 69720, -3761, 80553,  2199,  1494,   983,   380,  1026, 27396,
    2202,   304,   304,  2203, -3761, -3761, -3761,   493,  2211,  2212,
   -3761,   880,   880,  2368,  2214,  2217, -3761,   926,  2219, -3761,
    1092,  1031,  2220,  2222,  2223,  1889,   304, 27396, -3761,  2225,
     880,  2226,  2229,  2230,  1140,  2232, -3761,  1294,  2233,   321,
     531,  2235,  2237, -3761,  2214, -3761,   224,  2249,  2250,  2251,
    2253,  2254,  2256,  2257, -3761, -3761, -3761, -3761, 27396, 27396,
   -3761, 23452, -3761,   296, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,    78, -3761,  1082,  7144, -3761, -3761,  2383, 27396, -3761,
   -3761,   283, -3761,  1352,  1244, -3761, -3761, -3761, -3761,   306,
   -3761, -3761, -3761, -3761,  1657,  1657,   156, -3761, 59829, 59829,
   -3761, -3761,  1024,  2224, -3761,   973, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, 46151,  2614, -3761,  1526,    16,  1050,
    2562, 40878, 41362,  1930,  1930,  2481, -3761, -3761, 60300, -3761,
   27396, 39462, -3761,  1352, -3761,    67,  2504, 69720, -3761, 35110,
   -3761,   716, -3761, 10383, -3761,  1540,  1876, 69720, 69720,  2668,
   -3761, -3761,  1864, -3761, -3761,  1264,  1264, 27396,  1264,   701,
     -33, 25424, 27396,  2558,   663,  2561, -3761,  1279,  1686, -3761,
   -3761,  1909,  2282,  1587, -3761, 54177, 83838, 83838,  2525, -3761,
   -3761,   661,   742,  2396,  2494,  1693,  1014,  1103, -3761, -3761,
    2280, -3761,  2612, 59829,  2344, 45678, -3761, -3761,  2746, -3761,
    2746, -3761, -3761,   102,  2284, -3761,  2301, -3761, -3761,  1103,
    1103, -3761,  2773, -3761,  2292, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, 84305,  2294, 69720, -3761,  2297,  2298, -3761,
   84772,  1352, 39934,  1475,  2374,  2377, 48042,  2299,  2380,  2382,
   81024, -3761, -3761, -3761, -3761,   750,   628,  2386,   100, -3761,
   69720,  2491,   379,  2426, -3761,  2388,  2391,  2505,   379,   621,
   81495, -3761, -3761, -3761, -3761, -3761,  1713, 21525, -3761, -3761,
   -3761,  2392,  2378,   218,  2680,  2498,  1010,  1682,   369, 60300,
    2578,  2399,  2401,  2324,   931,  2322, -3761,  2385,  2387, 51346,
    2499, 38973,  2409, 77727, -3761, -3761,  2412,  2413,   379, -3761,
    2719,   379,   379,  1224,  2720,  2416,   328,  1417,  2183,  2322,
    1944, -3761,  2339,  2420,   443, -3761,  2519,   107,  1421,  2322,
    2422,  2423, 69720, 69720, 69720, 69720, 60300,  2424,  2430,  2469,
   61713,  2432, -3761, -3761,  2433,  1455,  2322,  1144, -3761,  1327,
   -3761, -3761,   679, -3761, 69720, -3761, 60300,  2091, 52290,  2527,
    2109,   379, 69720, 69720,  2110,  1094,   781,  2538, 69720,  2602,
    2407, -3761, -3761,  2183, -3761, 39934,  2145, -3761,  2372, -3761,
    2418, -3761,  2418,  2418,  2376,  2376,  2384, -3761, -3761,  1889,
    2418,  2376, -3761, 53234, -3761,  -130,  1438, -3761,  2770,  2774,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,  1615,
    1553, -3761, -3761, -3761, -3761,  2783, -3761, -3761, 52290, 69720,
   -3761,  2704,  2436, 48042, -3761,  2437, -3761, 69720,   920,   296,
    2428, 69720,  2604, 69720, 69720, 69720, 69720, -3761, -3761,   647,
      41, -3761, 61713, -3761,  1944,  2785,    14,  1697, 46624,  2678,
   69720,  2572, -3761,  2393,  2793, -3761,  2394, -3761,  1693, -3761,
    2150, -3761,  1597, -3761,  2518, -3761, 30833,  2443, 48986,   324,
   -3761, -3761, -3761, -3761, 52290, 69720, 81966, 48986,   324, 69720,
   69720,  2701,  2463,  2705,  2471, 38973,   324,   104, 69720, 69720,
   60300, 69720, -3761, 69720, -3761, -3761, -3761, -3761, 69720, 60300,
   69720, 61713,  2706,  2707,   324, 69720, 69720, -3761, -3761, 19958,
    1478, -3761, 16853, -3761, 10383,  1549,  1930, -3761,  1286,   872,
   69720, 65010, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
    1930, -3761, -3761,  2897,  2414, -3761,   306, 69720,  1565, -3761,
   -3761,  1575, 69720,    93, 48986, 69720, 69720, 60300, 60300, 69720,
    2493,  2224,   -88, -3761,  2480, 34166,  2549, -3761,   136, 58416,
    2623, -3761, -3761, -3761,  1596,  1796,   480, -3761, -3761, -3761,
   -3761, -3761, -3761, 59358, 56061,  2722,   143, 69720, -3761, 27396,
   23945, -3761, -3761, -3761,  2442, 10383,  2500, 27396, -3761, -3761,
   27396,  1693,  1693, 27396, -3761, -3761, -3761, -3761,  2902,  1693,
   -3761, 27396, 27396,  1693,  1693,  2418,  2418, -3761,  7048, 27396,
   -3761, 38973, 27396, 28875, 21031, 27396,  2521,  2482,  1693, -3761,
    1693, -3761, 27396, 22959, -3761, 27396,  2655, 27396,  1050,  2656,
   27396,  1050,  2882,  2882,  1091,  1723,  4355,  2455, -3761,  2569,
    1693, -3761,  1693,   740, 52290, 27396, 48042,  2540,   176, 27396,
    2461,  1795, -3761, 27396,   745, -3761,  2462, 27396,  2545,   140,
   27396, 27396, 27396, 27396, 27396, 27396, 27396, 27396, 27396, -3761,
   29368,   162, -3761,   -74,   247, 57003, 24438,  2750, -3761,   206,
   20537, -3761, 65010, -3761, -3761,  1352, -3761, -3761, -3761, -3761,
   -3761,   102,  2472, -3761,  2484, -3761, -3761, -3761, -3761, -3761,
   60300,  2614, -3761, -3761,  2546, -3761, -3761, -3761, -3761,  1274,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,  2475, -3761, -3761, -3761, -3761, -3761,  2475, -3761, -3761,
    1930,  2478,  2128, -3761, -3761, -3761, -3761,  2733,  2741,   324,
   84305, -3761, 69720,   122, -3761, -3761, -3761,  2502, -3761, 57474,
   -3761, 24931, -3761,  1603,  2214, -3761,  2734, -3761, -3761,  2488,
   -3761,  7761,  2734, -3761, -3761,   182,  2652,  2671,  2671, -3761,
     -35, 10383,  2723,  1751, 10383,  1793, -3761, -3761, -3761, -3761,
     992, -3761,  2558,   663,  1604, -3761,  1909, -3761, -3761, 19019,
   -3761, 19493, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,  2492, -3761, -3761, -3761, -3761,   379,  2497,  2955, -3761,
   45678, -3761, -3761, -3761,  1958, -3761,  1958,  2982, -3761, -3761,
   -3761, -3761, 65010,  1810, -3761, 16853, -3761, 16853, -3761,  2501,
    1613,  2575,  2577,  2622, 69720, 69720, -3761, 48042, 69720, 69720,
   69720, -3761,  2861,  2506, 69720,  2743,  2747,  2509, -3761, -3761,
   69720, -3761,  2708, 69720, 27396,  2712, 69720,  1166,  2713, -3761,
     891, 69720, 69720,  2696, -3761, -3761, -3761, 46624, -3761, -3761,
   -3761,  2698, -3761, -3761, 53234, -3761, -3761,  1634, -3761, 52762,
   50402, -3761, -3761,  1168, 69720, 69720, -3761, -3761, 69720, 69720,
   69720, 69720, 62184, 69720, 69720,  1015,  1028, 69720, 62655, -3761,
   60300, 69720, 69720, 48042, -3761, 69720,  2709,   169, -3761,  4088,
   69720, 69720,  2523,  1637,  2608, -3761, 69720,  4897, 69720, 69720,
   -3761, -3761,   379, -3761, -3761, -3761, -3761, -3761, 69720, 69720,
     379, 69720,   379,   857, -3761, 48514, 69720, -3761, -3761, -3761,
   69720, 69720, 69720, 69720, 69720,  1153,   -55,  2669,  2670,  2672,
   69720, 69720, 69720, -3761, -3761,  2649, -3761, 69720,  4897, 69720,
   69720,  2617,  2618,   161,  2688, -3761, -3761, -3761, -3761, -3761,
    2786,  2943, 69720,  2790,  2794,  2613,  2615,  2802,   487, 69720,
   69720, 69720, 69720, 69720, 69720,  2804,   487,  2744,    51, -3761,
    1638, -3761,  2576, -3761, 27396,  2966, 52290,  2571,  2573,  2650,
   -3761,  2653,  1693, -3761,  1650, -3761,   647,  1792, -3761,   476,
    4897,  2863, 69720,  1671, -3761,  2591, 60300,  4897, -3761,  3077,
   56061, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
    2864, -3761,   296,  2145,  2145,  2145,  2145, -3761, -3761, -3761,
   -3761,  1550, -3761,  2581, 69720,  2697,  4897, -3761,  1944,  2881,
   60300, 54648,  1730,  2985,  2867,   296,  2767, 60300, 22005,  3667,
   -3761, 65952, -3761,  2600,  2860,  2866,  2883, -3761, 30354, 66423,
    2596,  2213, -3761, 66423, 66894, -3761,  1352,  2598, 25917,  2549,
    2091, -3761,  2999, -3761,  2898,   324,  2109, -3761,  2169, -3761,
   69720, 69720, 69720, 69720,  2110, -3761, -3761,  2169,  2784,   324,
     324, -3761,  2788,   324,  2169,  2718,  2896, 46624, -3761,    60,
   -3761, -3761, -3761, -3761, -3761, 27396, -3761, -3761,  2703, -3761,
   -3761, 65010,  1958, -3761,  1676, -3761, 69720, -3761,  2169,  2648,
   69720,  2624, -3761,  2169,  2169,  2224,  2224,  2169, 67365,  3022,
    2905, -3761,  1709, -3761, -3761, 24438, -3761,   266, -3761,   577,
    1058,  2833, -3761, -3761, -3761, -3761, 52290, -3761, -3761, -3761,
   -3761, -3761, 69720,   132,  2810,  2628, 67365,  3017,   324, -3761,
    1719, -3761,  1490, -3761,  1492, 27396, 27396,    52, -3761,  7791,
    1726,  2636,  2640,  1732, -3761, -3761, -3761, -3761, -3761, -3761,
    2641,  2925, -3761, -3761,  2644,  1746,  1750,  2646,  2657, -3761,
   -3761,  3519,  2658,  8280,  2660, 28875, 28875,   546, -3761, -3761,
   28875,  2662, -3761,  1755,  7901,  2647,  2664,  2681, -3761,  2665,
    2673,  8651, 26410, 27396, 26410, 26410,  8779,  2647,  2674,  1758,
   48042,  9394,  1772, -3761, 27396, 48042,  3642, 27396, -3761, 27396,
   69720,  2675,  2676, -3761, -3761,  7048, -3761,  2682, -3761, 28875,
   28875,  3314, 23452, -3761, -3761,  2935, -3761, -3761,  2011, -3761,
    2679, -3761, -3761,  4012,   193, 27396,  2461, 27396,  2748, 38973,
    2271, 27396,  8705,  5763,  5763,   183,   183,   110,   110,   110,
    1334,   247, -3761, -3761, -3761,  2689,  2232, 27396, -3761,  3152,
    1799,  1883, 60300,  5512, 10799, -3761, -3761, -3761, 30833,  2716,
   27396, 27396, 27396,  2677,  2851,  1803, -3761, -3761, -3761,  1935,
    2982,   102, -3761,   679,  1693,   740, 41846, -3761, -3761, -3761,
   27396, -3761, -3761, -3761, -3761, -3761,  1809, 35110,  2443, 24931,
    1352, -3761, -3761, -3761, -3761, -3761, 27396, -3761, -3761,  2252,
    1717, 27396,  1751, -3761, -3761, 60300,  2623,  2623, 27396, 27396,
   25424, -3761, -3761,  2972, -3761, -3761, -3761, -3761,  1331, -3761,
   -3761, -3761, -3761, -3761, -3761,  2687, -3761,  2691, -3761,  2711,
   -3761, -3761, -3761, -3761,   130,  2683,  2693,  2699,   940, -3761,
   -3761, 69720, 69720, 69720, -3761, -3761, -3761, -3761, -3761, -3761,
    2919, -3761, 27396,   422,  2702,  2710, 69720,   324, -3761, -3761,
   10383, -3761, -3761,  2754,  2779, 69720,  2519, -3761,  2957, -3761,
   -3761, -3761, -3761,  2906, -3761, -3761,  1553, -3761, 50402, 52762,
   -3761, 52762, -3761,  1553,  1251, -3761,  2169, -3761, 52290,   267,
   -3761, -3761, -3761, -3761, -3761,   324,   324, 69720, 69720, 69720,
   69720, -3761, -3761, -3761, -3761, -3761, -3761, -3761,  1840, -3761,
    1084, -3761, -3761, -3761, -3761, -3761,  1186, -3761,  1044, 52290,
   -3761, 51818, 69720, -3761, 69720,  2933, -3761, -3761, -3761,  2870,
     606, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,  1039,
   69720, -3761,  1693,  2871, 69720,  2776, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, 48042, 48042, 48042,  1845, -3761,
   -3761,   296, -3761, -3761, -3761,  2797, -3761, -3761, -3761,  2940,
    2942,  2944,  2805,  2806,  2807,  2808, -3761,  2811,  2812,  2813,
   -3761, -3761, -3761, 69720, -3761, -3761, -3761, 69720, 69720, -3761,
   -3761, -3761,   487, 52290,  2975,   487,   487, 69720, 69720,   487,
   -3761, -3761, -3761,  2981,  2984,  2986,  2987,  2990,  2991,   487,
   -3761, -3761, -3761, -3761,   185,  2296, -3761,   126, 36533,  4771,
    2752,  2573,  2753,  1693, 32736,  1016,  2954,  2755, -3761,  1584,
    2978,  2772,  2772,  2772,  2772,  2772,  2772,  2772, -3761,  2208,
   -3761,  2937,  2826, -3761, -3761, 48042, 36533,  1697,   920,  2900,
    1268,  3096, -3761, -3761, -3761, -3761, -3761, 60300,   647,   296,
    1856, -3761, 52290, 69720, 65010,  1241,  2765, 60300,  2766,  2768,
   -3761, -3761, -3761, -3761,  1859, -3761, 52290,   -34,  2950,  2949,
    1241, 69720,  2852, 60300,  2831, -3761,  1867,    57, -3761,   296,
   46624, 50874, -3761,  3341, -3761, -3761,  2958, -3761, 69720, -3761,
   -3761, 33694, 32263,  2213,  2778, 69720, -3761,  2775, 30833,  3025,
    2959, -3761, 30833,  2959,  1037,  2959,  3026, -3761, 35582, -3761,
    2777,  1443, 20537,  2967, 10383, -3761,   324, 52290, 69720, -3761,
     324,  2846,   324,  2848,   324,   324, 60300, -3761, -3761, 60300,
   -3761, 69720, 61713,   324, -3761, 10383, 60300,  1425, -3761, -3761,
   -3761, -3761, 69720,  2169, 48986, 69720,   975, -3761, -3761,  2968,
   -3761,  1241, 69720,  1352,  2789, -3761, -3761, -3761, -3761,  3092,
    3098, -3761, -3761, -3761, 69720, 56532,   150, 69720, -3761, -3761,
   -3761, -3761,  2803,  1870,  9786, 27396, -3761,  3104, 52290, -3761,
   -3761, -3761, -3761, -3761, 27396, -3761, -3761, -3761, -3761, -3761,
   27396, -3761, 27396,  3090, -3761,  3235,  3235, 52290, 28875,  1347,
    2226, 28875, 28875, 28875, 28875, 28875, 28875, 28875, 28875, 28875,
   29861,   434, -3761, -3761, 27396, 27396,  3099,  3090, -3761, -3761,
    1025,  1025, 52290,  2817,  2647,  2818,  2820, 27396, -3761, -3761,
    1871, 48042, -3761, 27396,  8102,  1890,  2859,  9702,  1352,  4841,
   -3761,  3186,   296, 27396,   714,  2068, 27396,  1891, 27396,  3105,
   -3761, -3761, -3761,  2814, -3761, -3761, 52290, 27396, 28875, 28875,
    4794, -3761,  9372, 27396,  2821,  9842, 23452, -3761,   934,   934,
     934,   934, -3761, 60300, 60300,  2596, 27396,  3102,  1894,  1904,
    4915,  2851, 36054, -3761,   263, 26903, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,  2825, -3761,  2842, -3761, -3761,    16,  2829, -3761, -3761,
    6966,   130,  2844, 69720, -3761,  2549, -3761, -3761,  2835, -3761,
    1717, -3761, -3761, -3761,  5280,  3018,  2224, -3761, -3761, -3761,
   -3761, -3761,   701,  1693,  2853, -3761,  1958,  1935, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761,  2772,  5359, -3761, 69720,
   69720,  1905, -3761, -3761, 69720, -3761,  2099, -3761, -3761,  3091,
    1320, -3761, -3761, -3761,  2910, -3761,   681,  1447, -3761,  2911,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, 48042, 36533, 48042,
    2921,  2922,    90,   696,  2927,  2930,  2857,  2868,  2869, -3761,
    2169,   236,   296, 69720, 69720, -3761, -3761,  2169, -3761,   296,
    2169,   296, -3761, -3761, -3761, -3761, 48514, -3761, -3761, 69720,
    3141,   613,  1529, 69720, 69720, 69720, 69720, 69720, 69720, 69720,
    2519, -3761, -3761, -3761,  2872,   487, -3761, -3761,  3108,  3110,
   -3761,   487,   487,   487,   487,   487,   487, -3761,   119, -3761,
   -3761,  2542,  2542,    23, -3761,  2542, -3761,  2542, -3761, -3761,
    2576,  2835,  1693,  1103, -3761, -3761, -3761, -3761, -3761, -3761,
     698,  1693,  1778,  2875, -3761, 33215, -3761, -3761, -3761,  1823,
     740, 60300,  2772, -3761,   343,   309,   993,  1285, 67836, 68307,
   68778,  2876, 69720, 28875, -3761,  1038,   682, -3761,  3107, 60300,
    2918, -3761, -3761, -3761,  2878, -3761, 52290, -3761, -3761,  3278,
     872, 60300,  2920,  3167, -3761,  1923, -3761, -3761, 69720, -3761,
    2937,  1656,  2931, 54648, -3761,  3143, 54648, -3761, 69720, -3761,
   -3761, -3761,  3251,  2977,  2934,   476,   296,  2831, 69720,  2892,
   -3761, 50402, 27396, 27396, -3761,  2891, -3761,  2899,  5428, -3761,
    2145, -3761, -3761,   629,  2917, -3761, -3761, 66423,  2903, 69720,
    2213, 30833, -3761, -3761,  2027, -3761, 30833,  3144, -3761, 30833,
   69720,  2907, 69720,  1924, 43777, -3761,  2904,   324, -3761, 69720,
   -3761, 69720, -3761, -3761,   324,   324, -3761,  3019, -3761,  2908,
    1597,  2169, -3761, -3761,  3187, 67365, -3761, -3761, -3761, -3761,
   -3761, -3761,   143,  3192, -3761, -3761, -3761, -3761, 27396, 10383,
   -3761,  2913, 10383,  5717, 10383,  3099, -3761,   843,  3193, -3761,
     938,  2912,   843,   928,   928,   217,   217,    97,    97,    97,
    3235,   434, 10383, 10383, -3761, -3761, -3761, -3761,  2914, -3761,
   -3761, -3761,  2647, -3761, 27889, -3761, -3761,  2964,  2969,  2923,
   -3761, 27396, 28382,  2924, 53234, -3761, -3761,   740,  2882, 28875,
   28875,  1790, -3761,   391, 27396, 52290,  1934,  1790,  2190,  2630,
   27396, 27396, 10111,   180, 27396,  5966, 60300, 60300, 60300, 60300,
   -3761, -3761, 10383,  3306,  3201,  2851,  2851,  2851, -3761, 82437,
   -3761, -3761, -3761, -3761, 27396,  1935,  1847,   296, -3761, -3761,
    1091, -3761, -3761, 38973, -3761, -3761, -3761,   182, -3761, 16853,
   -3761, -3761, -3761,   236, -3761,  1939,  1940,  2918, -3761,  2299,
   -3761,  3000, -3761,  2208,  3122, -3761,  3125,   236, 69720, 52290,
   -3761, -3761,  2953, 69720, 69720,  1693,  1693, 52290,  2938, -3761,
    1693,  1693,  2941, -3761, 69720, 69720, -3761, -3761, -3761, -3761,
   -3761,  2169,  2169, -3761, -3761, -3761, -3761, 69720, 69720, 69720,
   69720,  3233, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
    3189, -3761,   487,   487, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,  2183,  3263,   296,   296,  3137, 69720,   296,   296, -3761,
    1072,  3273, -3761,  3205,   594,  2951,  1338,  3231, -3761,  1669,
   33215, 33215, 33215, 33215, 33215, -3761, -3761,  3234,   236, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, 27396,  1362,   843, -3761, -3761, -3761,
   -3761,  2918,  1697,  3011, 48042,  3012,  1241,   188, 69720,  3264,
    3254, -3761,   296, -3761, -3761, -3761,   159, -3761,  2956,   149,
    2961,  1730, -3761, -3761, -3761,   836, 69720, -3761,  1096, -3761,
    3196,  3241,  2962, -3761, 31312, -3761, 10383, 10383,   296, 53706,
    3341, -3761, -3761, -3761, -3761, -3761,  3041, 69720, -3761, -3761,
   69720,  1943, -3761, 27396,  2965, -3761, -3761, 30833,  2027,  1962,
   69720,  1965, 52290,  2851, -3761, -3761,   324, -3761,   324,   324,
   -3761, -3761, 69720, 69720,  3253,  3154, -3761,   324, 67365, 10383,
   -3761, -3761, -3761, 28875,  3260, -3761,  2979, 52290, -3761,  2980,
    1976,  1977, -3761, -3761, -3761,  6373,  3035, 10383,  3083,  2983,
    2988, -3761,  1138,  1138,   391,  1981, -3761, 28875, 28875,  1790,
    1790, 27396,  1790, -3761, -3761, -3761, -3761, -3761, 27396, 27396,
    3027, -3761, -3761, -3761,  3147, -3761,  6389, -3761,  1103, -3761,
   -3761, -3761, -3761,   740, -3761,  2992,  1751, -3761, -3761,  3128,
    2918,  3011, -3761, -3761, -3761, -3761, -3761,  3045, 36533, -3761,
   -3761, 31791, 38973, -3761,    90,  2995,  2996,   696, -3761, -3761,
     984,   657,  3029,  2169,  3284,   487, -3761, -3761, -3761,   296,
   -3761, -3761, 69720,  2997, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, 48986,  3390,  3390, -3761,  1538,  1538, -3761, -3761,
   -3761, 60300,   698, -3761,  6691,  3188, -3761,  3011,  3216,  3266,
   -3761,  1984, -3761, 69720,  2934, 54648,  2937, -3761,  1184,  3158,
   -3761, -3761,  3338,  1730,   167,  1256, -3761, 60300,  2949,  3133,
   -3761,  3134, -3761,  3387,  3194,  3389,   296, -3761, 69720, 31312,
   27396,  1994, -3761, 69249, 22478, -3761, 52762, -3761,  1995, -3761,
   -3761, 60300,  3032, -3761,  1999, -3761, 10383, 69720, -3761, -3761,
   -3761,  2000, -3761, -3761, -3761, -3761, -3761,  1241, -3761, -3761,
     150,   462, 28875, 52290,  2008, 27396, -3761, 27396, -3761, -3761,
   -3761,    17, -3761, -3761, -3761,  1138,  1138,  1790,  2647, 10383,
   69720, -3761,  3403,  3197,  2851, -3761, -3761, -3761, -3761,  3206,
   60300,  3011, -3761, 27396, -3761, -3761, 52290,  2109,   -73, -3761,
   52290, 52290, -3761, 69720, 69720, 69720, 69720, 69720, -3761,  2296,
   -3761,  2997,  3390,   808, -3761, -3761, -3761,  3309, -3761, -3761,
     479,  3209,  3112, -3761, 48042,  3322, -3761, -3761, -3761, -3761,
   -3761, 48986, -3761,  2949, -3761, -3761, -3761, -3761, -3761, -3761,
    2020,  2977, -3761, -3761,  3208, -3761,  3210, -3761, -3761,  2031,
    6904,  3075, 31312, 69720, -3761,  1051,  1051, -3761,  5428, 53706,
    2716,   144,  3051, -3761,  2032, -3761, -3761,   462,  2036, -3761,
    2045,  2048,  3094, -3761,  3033, -3761,  3436, 27396,   671, -3761,
   -3761, -3761,  1697, -3761, 10383,  2064, -3761, -3761, -3761,  3182,
    2070,  2074,  3039,  3084,  3039, -3761,  2169, -3761, -3761, -3761,
    3353, -3761, -3761, -3761,   219, -3761,  3225,  3228, 69720, -3761,
   69720,  3448,  3050,  2977, -3761, -3761, -3761, -3761,  3075, 69249,
    2324,  2977, -3761, -3761,  1717,  1717,  3341, -3761,  3366, -3761,
   -3761, -3761, 69720, -3761, -3761, -3761, -3761, -3761, 69720,  3053,
    2647,   115,   115,  3054,  3216, 48986, -3761, -3761, -3761, 69720,
    3179,   365,   365,  3378, -3761,  3119, -3761, -3761, -3761,    90,
   44255, -3761,  2977,  1051, -3761,  2716, -3761, -3761, -3761,   687,
   -3761, -3761, -3761,   124,  3190,    80, -3761, -3761, -3761, -3761,
    3209,  2109, -3761,  3360, -3761,  3476, -3761,   609, -3761, -3761,
    2938, -3761,  2085, -3761, -3761, -3761, -3761, -3761, -3761,  2716,
    1717, -3761, -3761, -3761,  1379,  3466, -3761, -3761, -3761,   698,
   -3761,  3217, -3761, -3761, -3761, -3761, 44255, -3761, -3761, -3761,
    2017, -3761, -3761, -3761, -3761, -3761, -3761, -3761,   124, -3761,
   48986, -3761,  1142, -3761, -3761,  1214,  1897, -3761,  3068, -3761,
    2017, 44255, -3761,  2096, -3761
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3761, -3761,  3212, -3761, -1106,   139, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
    1232, -3761, -3761,   -80,  1576,  2119,   936, -3761, -3761, -3761,
   -3761,  -954,   277,   550, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761,   707,  1345,   826,   680, -3761, -1598,  -531, -3761,   331,
   -3761, -3761, -3761,   705,  -278, -3761, -3761, -3761, -3761, -3761,
   -1660,  -125,   199, -3761,   200,  1376,   350, -3761,   -97, -3761,
   -3761, -3761, -3761,  -177,   876,  -927, -1269,  1147,  -537,  -570,
    -495,  -493,  -538, -3761, -3454, -3074, -2479, -2889, -3761, -3761,
   -3761,   220, -3761, -1649, -3761, -3761,  1841, -1505, -3761,  -905,
   -3761, -3761,   665,  1430,   214, -3761, -3761,   -18, -3761, -3761,
   -3761, -3761, -3761, -3761, -3229, -3761, -1579, -3761,   334, -2712,
     795, -3761, -3761, -3761,  1865, -3761, -3761, -3761, -3761, -1676,
   -3761, -3761, -1642, -3761,  1287,   699, -3761, -3761, -3761,  -615,
    -588, -3761, -3670,   -31,   -29, -3761, -3761, -3761, -3761, -1165,
   -3761,   723, -2780, -1082, -3761, -3761,   752, -3761, -3761,  -517,
    -210,  1899, -3761,  -441, -3761, -3761, -3761,  -204, -3761, -3761,
   -3761, -3761, -3761, -3761, -1795,  -601, -1078, -3761, -3761, -3761,
   -3761, -1728, -3761,  3458,   508, -1641, -3761,  -148,  -111,  2349,
   -1266, -2411,   194, -3761, -3761, -1829, -3761, -3761, -3761, -2336,
   -1640, -3761,   253,  -268,  -390, -3618, -2871, -3058, -3761, -3761,
   -1220, -3761, -3761, -3761, -1503,  1453, -2158, -3761, -2118,   255,
   -3267,  -961, -2858, -3761, -3216,  -392, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -1218,  -835, -3761, -3061, -3761, -3761, -3761,
   -3761,   954, -3761,   171, -3761, -3761, -3761, -3761, -3761,  -540,
    -566, -3761, -3761, -3761,   287, -3761, -3761, -3761,  1712, -1118,
    -926,  2667, -1632,  -229, -3761, -3761, -3761, -3761, -2709, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761, -1186, -3761, -3761, -3761,
   -3761, -3761, -3761,  1600,  3508,  -232, -3761, -3761,  2191, -3761,
   -3761, -3761, -3761, -3761, -3761,  2400,   297,   -30, -3761, -3761,
     655, -2270,   -25, -3761, -3761, -3761, -3761,  -258,   -22, -3761,
    1032, -3761, -3761, -1942, -3761,  2406,  1245,   240,   -61,     5,
    -242,  -211,  -193, -3761,  2685,  2221, -3761, -3761,  -213,  1567,
   -3761, -1032, -1029, -3761,  1035,  -870,  1589,  1027,   127,  -216,
   -3761, -2590,   494, -3761, -3761,  -868,  1593, -3761,  2204,  1619,
   -3761,  1640,  1093, -2278,  1321, -2271,   736,  -371,   -36,  -153,
    2714,  2843, -3761, -3760,  1069, -3199,   340,  -395, -1951, -1658,
   -3761, -3761, -1298,  5100, -3761, -3761, -3761,  6473,  6642, -3761,
   -3761,  9072, 10332, -3761, -1153,   608, 11535,  5054, -1305, -1703,
   -1399, 13719,   393,  -661, -1740, -3761, -3761, -3761,  -235,   619,
     -98, -3761, -3761, -3761,  -405, -2550,  -402, -3761, -3761, -3761,
    -403, -3394, -1763, -3761,  -789, -3761, 14074,  1073, -3761, -1253,
   -1288, -1809, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -1354,
   -2913,  -525,  1145, -3761, -3761,  1236, -3761, -3761, -3761, -1387,
   -1037, -1909,  1150, -1935, -3761, -1016,  1270,  1744,  2205,  -973,
    3971,  -685, 11811,  -133, -2161, -1424, -1059, -3761,  -708, -3761,
      25,  2210,  -157,  5511,  3120,    31,   -39, -2739, -3761, -3761,
   -3761,  2465, -3761, -3761, -3761, -3761, -3761,  3124,   780, -3761,
    2524, -3761,  1366,  1968, -3761, -3761,  1624,  -881,   -21, -3761,
    -367, -3761,  -138, -3761, -3761, -3761, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761, -3761, -3761,  2244,   141, -3761,   -47,
   -3761, -3761, -3761, -3761, -3761,  3393,  -301, -3761,  2854,  -293,
   -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761, -3761,  2258,
    1651, -3761,  2659, -3761, -3761, -3761,   -53,  2460, -3761, -3761,
   -3761, -1132,  1487,  2692,  -909,  1620, -3761, -3761, -3761, -3761,
   -3761, -3761, -3761, -3761,  1631, -3761, -3761,  1148, -1940,  1633,
   -3761, -3761,   562, -3761, -3761,   227, -3761,   565, -3761,  2350,
   -3761, -3761, -3761,   598, -3761, -3761, -3761,  -558,  9796,   -27,
      45,   -13,   700, -3761,   -67,   -42,  2275,  7848, 12708,   105,
      82,   -89, -3761,  3391,  1642,  1342,  -950,   -69,  1929, 11302,
     353, -1080,     7,    -2, -3761,  2373,  -620, -1116,  2528,  -696,
   -1785, -3761,  3788, -3761, -2615, -3761,  -872
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2292
static const short yytable[] =
{
      80,  1548,  1026,  1196,  1497,  1295,  1296,  1498,   928,    79,
    1300,  1131,  1433,  1010,   869,  2224,  1798,   343,   857,  1884,
     660,  1835,  1499,   852,  1861,  1806,  2323,    74,  1624,   928,
    2429,   361,  1567,  1673,  1440,  2452,   391,   398,  1662,   351,
    1761,  2739,   391,  1914,  1915,   351,  2395,  2433,   338,  1131,
     774,   390,  1243,   339,  1895,  2315,   341,   390,   935,  1080,
     973,  1041,  1930,  1561,   948,  1941,  1448,  2259,  1005,  1042,
    2778,  2629,  3195,   672,  3153,  3036,  2056,  1015,   351,   814,
    1736,  2740,  2742,   344,  1101,  1740,  2365,   662,  2342,  1115,
     390,  2493,  1746,   774,  2198,  3411,   929,   974,  1131,  2343,
    1696,  1763,  1028,  3272,   772,  3274,  2344,  2345,  2346,   350,
    2963,   672,  2116,  2118,  2119,   350,  2347,   929,   969,  1182,
    2645,   351,  2977,  2979,  3020,   969,  3368,   969,  1456,  2985,
     861,  1546,  3564,   390,   994,  2254,  2653,  1036,  1957,  3328,
     901,  3730,  2156,  1836,  3693,  2425,  1789,   772,   350,   862,
    1831,  3704,   826,  1595,  1771,  1037,  1518,  2678,  1075,  2650,
    3208,   774,   771,  1493,   413,  1494,  2010,  3328,  3067,  1228,
    2529,  2903,  1542,  3494,  2056,   413,  1236,  1790,  1908,  1909,
    1278,  1964,   941,  3345,  3346,  3347,  3348,  3349,  3350,   351,
     927,   350,  1109,  2694,  1112,  1526,  1527,  2698,    35,   779,
    1238,   390,  1959,  1927,  1246,   771,    41,  1760,  1267,  1142,
    2057,   927,  4007,  1967,  1258,   772,    35,   413,   824,  2467,
     873,  1790,   778,  4163,    41,   397,   413,  3402,  1097, -1474,
    2608,  3749,  1187,  3751,   815,  2363, -1474,  1878,   964,  1321,
    2206,  3045,   779,  1450,  1221,   964,  1530,   964,  1205,  1025,
    2992,  2602,  2994,  1690,  1964,   413,  2449,  3908,  2603,   350,
    2563,    37,    38,    39,    40,   778,  2872,  1790,  4164, -1490,
    2174,   413,  1148,   771,   664,  2834, -1490,  4164,  2568,  2668,
    4077,  3389, -1578, -1578, -1578, -1578,  1967,  1280,  3067,  4197,
    4118,  1288,  1670,   343,  1214,  2568,  -328,  2849,  2606,  2773,
   -1261, -1261, -1261, -1261,  2835,  1824,  4046,  3595,  4024,   413,
     779,  4062,   968, -1610, -1610, -1610, -1610,  2086,  1964,   968,
     391,   968,  3901,   351,   338,  3645,  2370,  1936,  2002,   339,
    1673,  1684,   341,   778,  2468,   390,  1298,  2618,  4025,    37,
      38,    39,    40, -2110,  2163,  1937,  3904,  3034, -1261,  1069,
    1967,  2206,   122,  1035,   391,   259,  2087,   351,  2164,   344,
       3,  3831,  1426,  2487,  2881,   316,  1149,  1938,  2459,   390,
     126,  3646,    37,    38,    39,    40,  1999,  1131,  1071,   413,
   -1266, -1266, -1266, -1266,  3905,    37,    38,    39,    40,    37,
      38,    39,    40,   350,  4141,  4191,  1537, -1276, -1276, -1276,
   -1276,  -125,  2175,  1838,  2088,  4026,  1914,  1915,   785,  3596,
     786,  1941,  1800,  1930,  1851,  1852, -2167,  1299,  4198,    37,
      38,    39,    40,  2607,  1619,  1791,  1874,   350, -1266,  4207,
    2165,  2058,   413,  1528,  1671,    37,    38,    39,    40,  1085,
    1306,  1790,  1743, -1612, -1612, -1612, -1612,  1451,  1677,  4023,
   -2169,  1215,   413,  3902,  3236,  1680, -1266, -1266, -1266, -1266,
    2293,  2215,  1964,  2223,  3025,  2669,  2297,   874,  3591,  1791,
    2873, -1608, -1608, -1608, -1608,  3887,  2176,  2450,  1081,  3672,
   -2195,  1508,  4174,  1437,  2774,   857,   789,  1099,  4063,   665,
    2023,  4153,  3597, -2213,  1967,  1042, -1607, -1607, -1607, -1607,
    2370,  1971,  1972,  1879,  2496,  3067,  1773,  3573,  2469,  3328,
   -2239,  2371,  1452,  3669,  3930,  1791,  1672,  1617,  1618,    37,
      38,    39,    40,   790,  1299,  2470,  2260,  1317, -2212,  4219,
    2250,  2313,  2252,  3067, -1474,  1995,  2315,  1068,  2364,  1998,
    1559,  3403,  2028,   875,  4165,   876,  2045,  2045,  2163,  1908,
    1909,  3941,  1975,  4165,  2287,  3023,  2604,  1927,  3640,  1807,
    1826,  2166,  3772,    37,    38,    39,    40,  1879,  1830, -1659,
   -1659, -1659, -1659,    58, -1490,  1960,  1076,  1689,  2870,   922,
     923,  2048,  2049,  2569,    58,  1691,  1692,  2309,  2444,  3152,
    3079,  2850, -2110,  1741,  1742,  2290,  1533,   861,  2727,  2011,
    3128,  3548,    55,  1988,  1800,   244,  1743, -1276, -1276, -1276,
   -1276,  1769,  2056,  1872,  3981,  2288,   862,  3067,  2628,  1542,
      55,  3232,  2647,  3233,  1886,  2884,    58,  2102,  1077,  2103,
     399,   259,  1299,  3668,  2165,  2189,  1896,   213,  1288,  1802,
    1804,   316,  1575,  1800,  2132, -2292,  2490,  2492,  2395,  3108,
    3455,  2167,  2324,  1138,  3237,  3026,  4142,  2500,  1071,  4175,
    2503,  1111,  1086,    57,    58, -2167,   221,  4017,  2515,  2516,
     922,   923,   787,  1985,  1986,  1987,  1988,  2179,  1276,  2661,
      58,  2533,  2535,  2184, -1578,  3895,   922,   923,  3069,  1791,
    3420,  3175,  2549,  3181,  3424,  4091,  3298,  3299,  1186, -2169,
     232,  1460, -1261, -1578,  1509,  1461,  2437,  3076,  3077,  3078,
    3079,  2376,   235,  1831,  3186, -1610, -2292,  1088,    58,  1015,
    3659, -1261,  1307,  2240,   922,   923,  2243,  2244,  1223, -2195,
    4176,  2216, -2212,  2706, -1610,  1983,  1984,  1985,  1986,  1987,
    1988,    57, -2213,  2217,  1576,   351,   391,  2625,  1233,   351,
    2257,  1903,  4177,  1875,  1277,  1291,  1279,   390,  1281, -2239,
    3326,   390,  2529,  2529,  1282,  2166,  3649,  2529,  2170,  4195,
    2723,   772,  2519,  2520,    57,  3027,  2294,  4192,  1936,  4203,
    3068,  4116, -1266,  1996,  1571,  3067,  2235,    57,  3326,  1718,
    1302,    57,  2218,  2073,  2860,  2185,  1937, -2212,  2171, -1276,
    3069, -1266,  1599,  1177,  3732,  -125,  2529,  2529,  1652,  3519,
    -125,  4092, -2212,  4005,  2374,   350,  -125,  -125,  1938,   350,
    1179,    57,  2357,  3618,  4227,    58,  2113,  1903,  3263,   771,
    1564,  2095,  1131,  3409,  4031,  1211,    56,    57,  1384,  1538,
    2373,    58,   929,  1071,   929, -1612,   929,  1539,  1540,  1653,
    1753,  2171,   929,  2584,  3689,  2167,    56,  1302, -1266,  1565,
     906,    58,  1814,  2254, -1612,  3070,   779,   922,  1517,  1489,
    3649,  4093,  3411, -1608,  2186,  3733,  2163, -1266,  2395,  1983,
    1984,  1985,  1986,  1987,  1988,  1317,  1272,  1577,  2114,   778,
    2164,  1754, -1608,  2358,  2455,  2456,  3651,   969, -1607,  2482,
    4158,   969,    80,  1815,  1600,  2319,  1436,  1292,  2083,  4088,
    1446,    79,  1883,  3600,  3067,  3562,  4204, -1607,  2725,  2300,
     950,    57,  3074,  3075,  3076,  3077,  3078,  3079,  1012,    74,
    2172,  1430,  3178,  1491,  4193,  1148,   927,  1029,   927,  3650,
     927,  4087,  3982,  2115,  1578,  1305,   927,  1283,  1284,  4103,
    3074,  3075,  3076,  3077,  3078,  3079, -1233, -1233, -1233, -1233,
    2301,  1071,  2165,   672,  2436,    57,  3028,  1056,  3069,  1466,
    2414, -1659,   351,  1322,  3619,  2585,  3264,  1492,  2440,  2586,
    1800,  1427,  3892,  3584,   390,  1439,  1442,  1443,  1936,  3690,
   -1659,  1030,   929,   951,  2084,  3811,  3812,  3813,  4009,  3067,
    3651,  1654, -1246, -1246, -1246, -1246,  1937,   660,   660, -1276,
    3734,  3909,  1547,   789,  2587,  3601,  1131,   964,  3994,  2245,
    4131,   964,  1057,  3910,  2117,  2320,  2888,  1386,  1940,  1149,
    3071,  3072,  3073,  3070,  3074,  3075,  3076,  3077,  3078,  3079,
    1059,  4089,   350,  1755,  4132,  3876,  3877,  3878,  3879,  3880,
     790,  2265,  2266,  2267,  2268,  1816,  4156,  4157,  3985, -1237,
   -1237, -1237, -1237,  1548,  1031,  2729,  3735,  2339,  1521,    37,
      38,    39,    40,  2359,   662,   662,  1601,  1444,  2397,  1550,
    2400,  2295,  2296,  1655,  2360,  1642,   927,  2305,  1549,  2406,
     835,   968,  4073,  2166,  1643,   968,  2522,  3069,  2021,  3328,
     679,  2836, -1244, -1244, -1244, -1244,  1541, -1273, -1273, -1273,
   -1273,   821,  2302,  3995,  2408,    37,    38,    39,    40,  1059,
    3774,  1059,  3775,  2417,  3293,  1756,  3767,  3296,  3297,  3252,
    3326,  3300,  4208,   822,   978,  2424,  2588,  1817,  2246,  2340,
    2247,  3307,  1131,  3742,  2730,   837,  3739,  3227,  3746,  1026,
    2657,  3748,  2353,  2354,  2355,  2356,  1115,  1800,    37,    38,
      39,    40,  3070,  3674,   819,   952,   953,  1883, -1235, -1235,
   -1235, -1235,  1781,  1032,  4114,  4115,  3911,  2448,  2637,  1694,
    2453,  2454,  3069,  2167,  2457,  3452,  2990,   872,  2913,  2914,
    2915,  2916,  2032,  1546,  2303,  1386,  2995,  2017,  3071,  3072,
    3073,  1626,  3074,  3075,  3076,  3077,  3078,  3079,  1483,  3067,
    2321,  3687,   789,  1644,  3913,  1848, -1238, -1238, -1238, -1238,
    1537,  2683,  3914,  1782,  2233,  2430,   938,   979,  2395,  2658,
    1627,  3253,  2395,  3466,  2033,  3231,  3979,  3723,  2829,  2069,
    1877,  3561,  3043,  2114,  2830,  3866,  1844,  3070,  2342,   790,
    3776,  1845,  2144,  2970,  1846,  2018,   413,  1442,  3411,  2343,
    1042,    80,    80,  2628,    80, -1233,  2344,  2345,  2346,  3688,
      79,    79,  2528,    79,  2076,  2078,  2347,  2082,  3758,  2971,
    3759,   344,  4190,  2291,   844,  1272,   845,   780,    74,    74,
    3094,    74,  2077,  2077,  3426,  2077,  2122,   781,  2115,  2123,
    1883,  1484,  4099,  3867,  2973,  2529,   344,  1783,  2529,  2529,
    2529,  2529,  2529,  2529,  2529,  2529,  2529,  2529,  2986,  3117,
      37,    38,    39,    40,  1386,  1424,  3447,  3071,  3072,  3073,
    1901,  3074,  3075,  3076,  3077,  3078,  3079,  2809, -1233,  3390,
    2831,   916,  2225,  2328,   942,  2812,  3265,  2814,  2298,  1917,
      37,    38,    39,    40,  1957,  1017,  1784,  3950, -1233,  2981,
     917,    37,    38,    39,    40,  2529,  2529,  3148,  3149,  3915,
   -1236, -1236, -1236, -1236,  3254,  2015,  2016,  1913,   929,  1944,
    1048,  2087,   929,   929,  2211,   782,  2245,  2226,  2227,  2757,
    1425,  1958,  3069,  2124,  2055,  1059,  1955,  4027,  2168,  2402,
    1049,  1963,  2759,  3255, -1246,  1964,  2975,   672,   672,  1386,
    1050,  2299,  2001, -2292, -2292,  1650,  3074,  3075,  3076,  3077,
    3078,  3079,   351,  1919,  4070, -1070,  2207,  4028,  2223,  2088,
    3029,  3454,  1285,  2212,   390,  2884, -1073,  1967,  2758,  1785,
    3993,  3212,  1442,  1757,  1651,  2030,  2888,  3221,   772,  1442,
    1442,  2760,  1304, -1077,  1521,  3676,   660,  3070,  1521,  1521,
    2723, -1237,  1758,  2220,   391,   391,   351,   351,   351,  3938,
    2129,    57,   927,  3003,  2281,  3455,   927,   927,   390,   390,
     390,   969,  1936,  2832,  1800,  1489,  2116,  1642,  3351,  1490,
    1035,  1035,   350,  1035,  4029,  3030,  2724, -1070,  1051,  2055,
    1937,   969,   672,  2282, -1244,  2246,   771,  2247, -1073, -1273,
     783,   391,  2833,   929,   351,  1568,  3250,    57,  2148,   929,
    2746,   351,  2692,   662,  2125, -1077,   390,   351, -1273,  3478,
     975,  3479,  3353,   390,   969,  1781,   350,   350,   350,   390,
    2121,   835,  1284,   779,  1569,  3251,  2139,  2141,   207,  1491,
     771,   949,  4105,   772,   156,  3872,  4018,  1001,  2133,   929,
      57,  1052,   929,   929,  2138,  2140,   778,  3631,  3248,  2564,
   -1235,  3926,  1570,  3634,  3635,  3636,  3637,  3638,  3639,  1962,
      56,  3873,  4019,  3249,   350,    58,  3450,   779,  1019,  1521,
    2529,   350,  1208,  1492,  2056,  1521,   837,   350,    35,   413,
    1027,   964,    37,    38,    39,    40,    41,   927,  2725,   789,
    3585,   771,   929,   927,  1038,  1821,  3819,  2174, -1238,  1386,
    1209,   964,   213,  1053,  4151,   174,  3074,  3075,  3076,  3077,
    3078,  3079,  4155,  1026,  1822,  1521,  2628,  3666,  1521,  1521,
    4229,  1571,  2258,  4230, -1070,   213,   790,  2810,   779,  3480,
    1208,   221, -1233,   927,   964, -1073,   927,   927,  3230,  3481,
    1210,  1574,  2403, -1233,  3885,  1913, -1233,  1566, -1233,  3357,
    1783,   778, -1077,  4189,   221,   968,  2335,  2283,  3371,  1045,
    2397,  2395,  4209,   191,  1625,   232,  2395,  2284,  1521,  2395,
   -1867,  2854,  3196,  1055,  1663,   968,  2025,   235,  2863,  2864,
    2865,  2866,  2867,  2868,   351,  3358,   927,  3176,   232,  3475,
    2285,  3629,  1480,     8,  2438, -1070,   390,  3359,  1210,  1784,
    3326,  2628,    57,  1622,  1657,  1081,  2472,   207,   968,  3433,
     772,  2045,  4015,  3495, -1070,   844,  1087,   845,   244,  3620,
    1661,  2000,  1839,  3234,   207, -1073,  2484,  2348,  1913,  3586,
    2157,  1623,    57,  1658,  3134,  1056,  2529,  2529,  3621,  2644,
     213,   244, -1077,    57,  1840,  3013,  1442,  1042,  1623,  3463,
     156,  2634, -1236,  -337,   350,  2209, -1070,  1708,  2214, -1070,
    2319,  1659,  2483,   963,  3827,  3496,  3497, -1073,   771,   221,
   -1073,  2389,  1000,  2251,  1841,  3360,  1189,  2262,  1190,  2026,
    1131,  2278,  1785,  2382, -1077,  2151,  1113, -1077,  4047,  2991,
    1057,  2993,  3581,  1058,  3791,  2206,   230,  1913,  2261,  2157,
    1571,  3008,  2213,   232,  2481,   779,  2884,    80,  2225,  1581,
      80,  2280,  2225,  3203,  2152,   235,    79,  1571,  3526,    79,
     791,   174,  1056,  1639,  3502,  1649,  3587,  1460,   778,  3588,
    2554,  1461,  1666,  2557,    74,  2478,  3790,    74,   823,  1582,
    2479,  1964,  2153,  2480,  2528,  2528,  2225,  2917,  1098,  2528,
    3189,   903,  2918,  2226,  2227,  1140,  4210,  2226,  2227,  2330,
    1025,  1146,  1192,   413,  1193,  2337,    37,    38,    39,    40,
     344,  3926, -1114,  1967,  1147,  1936, -1114,  1057,  1968,  2566,
    2320,  3341,  2366,  1181,  3856,  3857,  2918,  1059,  2528,  2528,
    2397,  2226,  2227,  1937,  2223,  1583,  2512,  1184,  2223, -1082,
     413,  2882,   976,    37,    38,    39,    40,   351,  2663, -1082,
    1812,  2890,  2888, -1082,  1185,  1940,  2501,  2502,  1460,   390,
   -1578,  1827,  1461,  3156,  2514,  1584,  3157,  3158,  2517,  2518,
    3575,  3576,  2223,   772,   130,   131, -1114,  3159,  3160,  3161,
    1832,  3162,  3163,  2539,  1833,  2540,  3164,  3165,  3166,  1188,
    2006,   156,  1197, -1082,  2007,  2573,   213,  2575,  1832,  2576,
    3369,   801,  2432,  2891,  3923,  2561,  3040,  2562,  3041,  1900,
    2435,   244,  3042, -1082,  1059,  1203,  3406,   350,  1060,  2577,
   -1114,  1212,    55,    56,    57,   221,  1213,  2395,    58,  1219,
    2529,   771,  1925,  1926,   922,  1517,   929,  3093,   391,  3095,
    3096,   351,  1271,   413,  1970,  1061,  2708,  2635,  3662,  3663,
    3664,   413,   230,   390,  2529,  2529,  2133, -1082,  2070,   232,
    2071,  1216,   174,  4002,  1971,  1972, -1082,  2434,   779,  2435,
    1913,   235,  1566,  2384,  2385,  2892,  2893,   929,  1673,  1628,
    1230,   660,  2680,  2445,  2680,  2446,  1234,   391,  2894,   391,
     351,   778,   351,  2447,  1547,  2446,   207,  1244,  2188,  2655,
    1587,  3032,   390,  1253,   390,  2321,  1588,  2106,  2107,  3189,
    2055,   350,   244,  1589,  2475,  1975,  2476,  2578,  3167,  3260,
    1623,  2654,  2579,  1800,  2106,  2676,  1629,  2580,  1591,  1976,
     927,  2700,  2322,  2476,  1259,  3267,  1592,  3189,   351,  3270,
    3977,  1071,  2895,  2671,  2672,  3643,  3644,  3998,   662,  3647,
     390,  3648,  2737,  1521,  2738,  2780,  2876,  2781,  2877,  3067,
     350,  1550,   350,    80,   772,    80,  1026,  1913,  3579,  2157,
    1549,   927,    79,  1274,    79, -1082,  2770,  3660,  3661,  3662,
    3663,  3664,   904,  3520,  1593, -1137, -1137,  3875,  1541,  2904,
      74,  2905,    74,   929,  3010,    58,  2446,   213,  2969,  3923,
    1630,   929,  1288,   929,   351,  1443,  2937,  2938,   350,  2529,
    3191,  3192,   156,  3119,  1293,  3120,   390,  1297,  4082,  1964,
    4084,  1309,   771,  2896,  1314,  2897,   221,  3021,  1315,  3022,
     772,  3138,  1316,  3139,  2910,  3121,   351,  3039,  1318,  2435,
    2581,  1480,  3168,  1965,  3049,  1631,  2435,  1632,   390,  2582,
    3052,  1967,  2435,   230,  3656,  3657,  1968,  3795,  2253,   779,
     232,  1317,   772,  2970,  3056,  3731,  2435,  1319,  3057,  1521,
    2435,  3781,   235,  3083,   350,  2435,  3099,  1521,  2435,  1521,
    2397,  3067,   778,   174,  2397,  1889,  1890,   927,   771,  2971,
    3102,  1979,  3103,  1634,  3169,   927,  1320,   927,  1983,  1984,
    1985,  1986,  1987,  1988,  2972,  3797,   350,    56,    57,  1384,
    1538,  1323,    58,   244,  2973,  3140,  2862,  3141,  1539,  1540,
     771,  3154,  3923,  3155,  2862,   779,  1115,  3182,  1636,  3183,
    1324,  3660,  3661,  3662,  3663,  3664,  1447,  2974,  3122,  3665,
    1089,   191,  3069,  3123,    56,    57,  1449,  3451,   778,    58,
    1026,  1453,  1090,  1091,  3351,  1454,  3818,   779,  3246,  1455,
    3247,  1638,  1964,  3275,  3743,  3276,  1470,  2887,  3352,  3462,
    2912,  1469,  1092,  3235,  3377,  1093,  3378,  3387,  1969,  3388,
     778,  1478,  1970,  3170,  2969,  3400,  1965,  3401,  3467,  3503,
    2435,  3504,  1464,  2942,  1967,    81,  1477,  3863,  3353,  1968,
    3354,  1487,  1971,  1972,  3256,  1480,  3258,  3070,  3510,  3522,
    3511,  2435,  3545,  2962,  2435,  1481,  2975,  1973,   213,  1502,
    3143,  3144,  3546,  3577,  2435,  2446,  3309,  2528,  3197,  3198,
    2528,  2528,  2528,  2528,  2528,  2528,  2528,  2528,  2528,  2528,
    1071,  3701,  3753,  3702,  3155,  1442,  1006,   221,  1506,  2970,
    1974,  1507,  3796,  1975,  2476,  1006,  3124,  3829,  3830,  2446,
    2446,  3935,  1500,  1800,  3069,  3125,  1510,  1976,  3310,  3355,
    1977,   392,  3199,  3200,   230,  2971,  1094,   392,  3294,  3189,
    3940,   232,  3378,  3942,  1515,  3378,  3744,  2528,  2528,  2401,
    2972,  1511,  3311,   235,  3956,  3958,  3957,  2435,  2407,  3964,
    2973,  2476,  4013,  3100,  4014,  1512,  2415,  2416,  3105,  3954,
     392,  3312,  4041,  4048,  4042,  4049,  1095,  4053,  4055,  1800,
    3378,  1969,  1522,  2974,  2428,  1970,  4059,  3313,  2476,  3070,
    3356,   351,  4154,  1513,   244,  3357,   351,  1514,  4104,  1978,
    2020,  3314,  1516,   390,   863,  1971,  1972,  3379,   390,  4108,
    4123,  4042,  1800,   392,  4124,  3858,  2476,   772,  1523,  1525,
    1973,  3235,   772,  4125,  3824,  3103,  4126,  1528,  2435,  1386,
    1552,  3358,  3071,  3072,  3073,  3968,  3074,  3075,  3076,  3077,
    3078,  3079,  4135,  3359,  2476,  1529,  1531,   929,  4137,  1553,
    2476,  3188,  4138,  1974,  2476,  1555,  1975,  1955,  3611,  3612,
     970,   350,  2975,  4205,  1580,  4206,   350,   970,  1562,   970,
    1976,  2573,  3436,  4001,  4234,   771,  4206,  1486,  1566,  1488,
     771,   392,  3425,  3315,  3428,  1621,  1597,  1619,  1656,  1979,
    3137,  3316,  1980,  1981,  1982,  1660,  1983,  1984,  1985,  1986,
    1987,  1988,  1668,  2389,  2639,  1669,  1674,  1676, -1575,  1681,
    2640,  1678,   779,  1686,  1442,  1688,  1695,   779,  1698,  1571,
    1737,  3360,  1743,  1521,  3317,  1739,  1749,  1747,  -169,  1751,
    1768,  1762,  1778,  3471,  1786,   778,  2133,  1788,  1793,  3177,
     778,   927,  1978,  1794,  1795,  4058,  1796,  1797,  1799,  1800,
    1805,  1386,  3476,  1808,  3071,  3072,  3073,  1809,  3074,  3075,
    3076,  3077,  3078,  3079,  1810,  1811,  1813,  1818,  1819,  1820,
    1825,  1857,  2528,  1885,  1887,  1891,  1899,  3498,  4075,  1907,
    1910,  3067,  4080,  4081,  4061,  1893,  1894,  1916,  1911,  1912,
    1993,   244,  2024,  2397,  1918,  2035,  1921,  1922,  2397,  1923,
    1924,  2397,  1929,  1931,  2020,  3798,  1932,  1933,  3825,  1934,
    1935,  1883,  1942,  1120,  1943,   392,  1121,  1122,  1123,  2643,
    1124,  1125,  1126,  1127,  1128,  1129,  1945,  1946,  1947,  2050,
    1948,  1949,  1979,  1950,  1951,  1980,  1981,  1982,  2060,  1983,
    1984,  1985,  1986,  1987,  1988,  3888,  2074,  4076,  1490,   392,
    4079,  2100,  2105,  2112,  1131,  1059,   351,   351,   351,  2120,
    2126,  2128,  2130,  1537,  2136,  2137,  3381,  2142,   390,   390,
     390,  2145,  2143,  2154, -2016,  2147,  2155,  3266,  2157,  2158,
    1581,  2159,   772,   772,   772,  2173,  2180,  2181,  2178,   929,
    2182,  2204,  2183,  2206,  4130,  2210,  2205,  2220,  2221,  3278,
    2222,  2223,  2229,  3416,  2230,   857,  2231,  3268,  2236,  2234,
    1582,  2238,  2239,  2241,  2248,  2249,  2255,   929,  2335,  2256,
    1642,  2263,  2264,  2270,  2292,  2272,   350,   350,   350,  2271,
    2862,  2277,  2279,  2862,  2862,  2304,  2306,  2862,  2528,  2528,
     771,   771,   771,  2307,  3382,  1903,   351,  2862,  2316,  2314,
    2326,  2317,  1694,  1913,   832,  2332,  3329,  1644,   390,  3394,
    2352,  1919,  3338,  2369,  3069,  1521,  1583,  2336,  2375,  2377,
    2378,  2380,   772,  2381,  1026,  2387,  2398,   779,   779,   779,
    3415,  2410,  2411,   927,  3329,  2412,  2426,  2427,  3333,  3336,
    2413,  2441,  2458,  1521,  2442,  2465,  1584,  3376,  3065,  3066,
     778,   778,   778,  3081,  2461,  3536,  3537,  3538,  3539,  2473,
     344,   927,  3850,  3851,  4030,  3853,   350,  2486,  2537,  2495,
    1603,  4068,  2550,  2555,  4069,   344,  1604,  3405,  1442,  3070,
     771,  4200,  2496,  1964,  2538,  2559,  2560,  2567,  2572,  2589,
    3458,  2641,  3114,  3115,  2591,  2618,   344,  2633,  2631,  2642,
    2664,  3695,  2630,  2389,    35,  2636,  2638,  2389,    37,    38,
      39,    40,    41,  2665,  1030,  1605,  2649,   779,  2656,  2685,
    2682,   863,  2010,  2670,  2701,  2684,  2702,  1100,  2703,  2699,
    2710,  2714,  1100,  2712,  1006,  2715,  2716,  3988,  1116,  1006,
     778,  1006,  1134,  2733,  1585,  2718,  2397,  1006,  3852,  2721,
    2728,  1144,  2735,  2779,  2772,  1006,   344,  2782,  2837,  2838,
    1006,  2839,  1100,  2843,  3505,  1606,  2847,  2848,  2851,  2397,
    2852,  2853,  1607,  1586,  2855,  1608,  1191,   207,  2856,  3189,
    1198,  1587,  2857,  1131,  2858,  3934,  2859,  1588,  2869,  2871,
    2878,  1207,   351,  2880,  1589,  3934,  2883,  2504,  2884,  2885,
    4186,  1590,  2886,  2902,   390,  2906,  2911,  1006,  2919,  1591,
    2924,  2923,  1100,  2940,  2943,  2989,  2959,  1592,   772,  1100,
    2941,  2958,  2960,  2961,  1609,  2982,  2968,  2987,  2988,  2997,
    2998,  2996,  3001,  3000,  3609,  2999,  3002,  3012,  3019,  3004,
    3517,  1386,  2528,  3006,  3071,  3072,  3073,  3031,  3074,  3075,
    3076,  3077,  3078,  3079,  3014,  2487,  4186,  3035,  1299,  2505,
    1883,  3037,   350,  3987,  3050,  1593,  2528,  2528,  3051,  3053,
    3054,  1955,  3055,  1006,  3058,  4134,   771,  2435,  1006,  1610,
    3118,  4186,  3553,  3089,  3113,  3059,  3061,   392,  3064,  1006,
    3082,   392,  3088,  3090,  1115,  1108, -1928,  3133,  3038,  3146,
    1108,  3091,  3098,  3111,  3112,  3151,  3126,  3152,  3202,   929,
    2770,  3210,  3592,   779,  2506,  1611,  3136,  2507,  3205,  3216,
    1006,  3206,   929,  1832,  3837,  3207,  3223,  3211,  3224,  3219,
    1108,  3228,  3843,  3261,  3262,  3269,   778,  3220,   351,  1006,
     351,  2397,  3271,  3229,  1612,  1006,  3279,   830,  1613,  3280,
     390,  3281,   390,  3282,  3283,  3284,  3285,  3286,  3568,  3295,
    3287,  3288,  3289,  1006,   772,  3301,   772,   351,  3302,  2123,
    3303,  3304,  1614,  1224,  3305,  3306,  3329,  3331,  3342,   390,
    1108,  3332,  4054,  3340,  3366,  1521,  3343,  1108,  3364,  3372,
    3610,  3370,  3383,   772,  3385,  3391,  3392,  3613,  3386,  3614,
    3398,  3396,  3419,   927,  3432,  3413,  3417,    81,   350,  3434,
     350,  2508,  3421,  3429,  3422,  3439,   927,  3441,  3457,  1996,
    3460,  2528,   771,  2862,   771,   835,  3461,  3470,  1900,  2862,
    2862,  2862,  2862,  2862,  2862,  3085,  3067,   350,  3512,  3084,
    1959,  3525,  4086,  4102,  -724,  3499,  3500,  4038,  3501,  3533,
    3524,   771,  4044,  4044,  3543,  3555,  3556,  3557,  3560,   779,
    2125,   779,  3563,  3338,  2397,  3580,  3566,  3569,  3582,  3589,
    3593,  3594,  3671,  3673,  3675,  3677,  3604,  1283,  1284,  3605,
     837,  3617,   778,  1108,   778,  3606,  3655,  3379,   779,   970,
    3336,  1100,  3632,   970,  3633,  3691,  3607,  3608,  1100,  3670,
    3630,  3658,  2509,  3684,  3410,  3694,  3696,  3699,    55,  3698,
      57,   778,  1883,  3710,   392,  1964,  3715,  3706,  3716,  3724,
    3718,  3728,  1108,  4083,  3721,  4085,  3729,  3222,  3737,  2909,
    3740,  3747,  3756,  3762,  3750,  3763,  3765,  3768,  3773,  3777,
    2663,  3770,  3778,  1006,  1006,  1006,  3828,  1967,  3782,  1100,
    3808,  3784,  1968,  3783,  3788,  3809,  2389,  4171,  3832,  3833,
    3835,  2389,  3834,  3854,  2389,  3240,  3241,  3838,  3844,  2949,
    3859,  3847,  4113,  3855,  3862,  3868,  3650,  3871,  3874,  3881,
    3889,  3893,  3897,  3899,  3903,  3916,  3918,  1581,  3907,  3919,
    3931,  3477,  3937,  3947,  3482,  3483,  3484,  3485,  3486,  3487,
    3488,  3489,  3490,  3491,  3948,  3952,  3953,  3955,  3960,  3961,
    3972,  3962,  3970,  3980,  3983,  3996,  3963,  1582,  4003,   844,
    3978,   845,  3990,  3991,  3997,  3690,  4010,  2446,   929,  4148,
     847,  4022,  1006,  4012,   929,  4021,  4032,  4033,  4044,  3116,
     850,  3883,  4228,  4034,  4035,  4036,  4051,  4067,   929,  4090,
    1031,  3528,  3529,  4098,  4071,  1006,  4094,  4100,  4106,  1108,
    4107,  4110,  4122,  4128,  4129,  4077,  1108,  4127,  4172,  1826,
    4139,  4140,  4143,  1583, -2292,  4145,  4149,  4150,  1970,  4159,
    3549,  4173,  4169,  4141,  3822,  3823,  4142,  1734,  1883,  4201,
    4202,  4218,  4196,  3821,  4220,  4231,  1040,    80,  1971,  1972,
    2908,  2047,  3179,  1584,  2775,  3238,    79,  4152,  3590,  3308,
    3999,  2133,  3708, -2292,  2747,  3583,  3712,  1108,  3886,  3218,
    1964,  1883,   927,  3011,    74,  1883,  1883,  4170,   927,   929,
    4199,  2950,  4146,  4144,  4179,  2368,  3395,  2726,  3713,  3720,
    3615,  3273,   927,  2889,  1965,  2349,  4233,  3374,  4221,  1975,
    3841,  3842,  1967,  3870,  3869,  3845,  3846,  1968,  3367,  3319,
    2862,  2862,  4180,  1976,  3989,  3894,    81,    81,  4136,    81,
    2331,  3860,  3861,  3992,   944,  3864,  3865,  1108,  1873,  3766,
    3722,  4039,  4112,  2741,  4212,   351,  3725,  4117,  3338,  3338,
    3338,  3338,  3338,  1006,  4232,  4016,  3435,   390,  1457,  2651,
    3438,   909,  3440,  2075,  3442,  3443,  1843,  3459,  3705,  3184,
    1734,   772,  1847,  3448,  3007,  3336,  3336,  3336,  3336,  3336,
    3764,  3187,  2675,   927,  3826,  2674,  3567,  3201,  2072,  2101,
    3900,   344,  1108,  2648,   207, -2292,  1476,  2667,  1587,  2964,
    3427,  3145,  3939,  1964,  1588,  1226,  3464,  3185,  3703,  3516,
    4060,  1589,  3506,  4161,  1465,   350,  3925,  4162,  1623,  4168,
    1108,  3131,  3190,  3046,  3129,  3024,  1591,  1965,  3414,   771,
    2617,  1849,  1074,  1780,  1592,  1967,  3686,  2957,  2383,  1969,
    1968,  2111,  2389,  1970,  2686,  4160,  1043,  2677,  1560,  2104,
    1270,  1108,  1108,  2693,  1108,  2949,  1882,  2690,  3571,   929,
    2691,  1532,  3572,  1971,  1972,  2009,   779,  1992,  3174,  3559,
    2108,  1108,  3817,  1581,  3009,  2443,  1066,  3755,  1973,  2697,
      83,  1829,  1593,     0,     0,  1979,  2952,  3410,     0,   778,
       0,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,
       0,     0,     0,  1582,  1006,     0,     0,     0,     0,     0,
    2031,  1974,     0,     0,  1975,  3976,     0,     0,     0,     0,
       0,     0,     0,  1108,   392,     0,  3329,     0,  1976,     0,
       0,  1977,     0,  3975,     0,  1521,     0,     0,     0,     0,
       0,     0,     0,  2862,     0,     0,     0,  4000,     0,     0,
    1108,  1006,     0,   927,  1108,  1108,     0,     0,     0,  1583,
    2276,     0,  1969,     0,     0,     0,  1970,     0,   392,   392,
     392,  1006,     0,     0,  1603,     0,  3415,     0,     0,     0,
    1604,     0,     0,     0,     0,     0,  1971,  1972,     0,  1584,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1978,  1973,  3792,  3793,  4037,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   392,  2950,     0,  1605,
       0,     0,     0,   392,     0,  1734,     0,     0,     0,   392,
       0,     0,     0,   970,  1974,     0,     0,  1975,     0,     0,
       0,     0,   344,     0,     0,     0,     0,  2338,     0,     0,
       0,  1976,     0,   970,  1977,     0,     0,     0,  4226,     0,
    1734,     0,  2276,     0,     0,   351,     0,     0,     0,  1606,
       0,     0,  4120,     0,     0,     0,  1607,   390,     0,  1608,
       0,  2396,  1734,  1100,     0,     0,   970,     0,     0,     0,
    1979,   772,  1100,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,  1006,     0,     0,     0,  3060,
       0,     0,     0,     0,  1006,     0,     0,     0,     0,     0,
     207,  2276,     0,  1978,  2951,     0,     0,     0,  1609,     0,
    1588,     0,     0,     0,     0,   350,     0,  1589,     0,     0,
       0,  1734,     0,     0,  1623,     0,     0,     0,     0,   771,
       0,     0,  1591,     0,     0,     0,     0,     0,  2312,  1100,
    1592,     0,  1006,  1006,     0,     0,  4119,     0,     0,     0,
       0,     0,     0,  1964,  1006,     0,  1734,     0,     0,     0,
       0,     0,     0,  1610,     0,     0,   779,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1734,     0,     0,     0,  1967,   392,  3757,  1593,   778,
    1968,     0,  2952,  1979,  3760,  3761,  1980,  1981,  1982,  1611,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,  1603,
       0,     0,  3106,     0,     0,  1604,     0,     0,  4188,     0,
       0,     0,     0,     0,     0,     0,     0,  4187,  1647,  1108,
       0,  1108,  1613,     0,     0,     0,  3951,  1734,     0,     0,
    1108,     0,     0,  1603,     0,  4184,     0,     0,     0,  1604,
       0,     0,     0,     0,  1605,     0,  1648,     0,     0,     0,
    3965,  3966,     0,     0,     0,     0,     0,     0,     0,   344,
    1006,     0,    81,     0,  4188,    81,     0,  3127,     0,     0,
       0,     0,     0,  4187,     0,  4225,     0,     0,  1605,     0,
       0,     0,     0,     0,     0,  1006,     0,     0,     0,  4188,
       0,  4184,     0,     0,  1606,   344,     0,  1108,  4187,     0,
       0,  1607, -2292,     0,  1608,     0,  1970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1971,  1972,  1606,     0,
       0,     0,  1108,  1108,  1006,  1607,     0,     0,  1608,     0,
    1108, -2292,     0,  1108,     0,     0,  1108,     0,     0,     0,
       0,  2513,     0,  1609,  1108,  1108,     0,     0,     0,     0,
       0,     0,  1108,     0,  1730,  1108,  1108,  1108,  1108,     0,
       0,     0,     0,     0,     0,  1108,  1108,  1975,  1108,     0,
    1108,     0,     0,  1108,     0,     0,     0,  1609,     0,     0,
       0,  1976,     0,     0,     0,     0,     0,  1734,  1108,   392,
       0,     0,  1108,     0,     0,  4057,  1108,     0,  1610,     0,
    1108,     0,     0,  1108,  1108,  1108,  1108,  1108,  1108,  1108,
    1108,  1108,     0,  1108,  2704,    85,     0,     0,  2707,  1108,
       0,    89,     0,  1108,     0,    93,     0,    94,     0,    96,
      97,     0,  1610,  2719,  1611,     0,     0,     0,     0,     0,
     106,  2731,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2292,     0,     0,     0,   119,   120,     0,
       0,     0,     0,  1664,  2745,     0,     0,  1613,  1611,     0,
       0,     0,     0,     0,     0,  1006,  1964,  1730,     0,     0,
       0,  2766,     0,   392,     0,     0,  3943,     0,  3944,  3945,
       0,  1665,     0,   128,  1108,     0,  2783,  3949,  2807,     0,
    1965,  1613,     0,   129,     0,   130,   131,     0,  1967,     0,
       0,     0,     0,  1968,     0,     0,  2823,     0,     0,  1039,
       0,     0,     0,  2827,     0,  1614,     0,     0,     0,     0,
    2840,     0,   392,     0,   392,     0,     0,  2844,     0,   141,
       0,   142,   143,  1979,     0,     0,   145,   146,     0,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,   147,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,    81,     0,
      81,     0,     0,     0,     0,     0,   151,     0,   152,     0,
     392,   155,     0,     0,     0,     0,     0,   156,     0,     0,
       0,  1006,     0,   157,     0,     0,     0,  1108,     0,   158,
       0,     0,     0,     0,     0,   159,     0,     0,     0,     0,
       0,   161,     0,   163,     0,     0,     0,  1734,   165,     0,
       0,     0,  1734,  1734,     0,  1006,     0,     0,     0,     0,
       0,   169,  1006,     0,     0,  1969,     0,     0,     0,  1970,
       0,     0,     0,  2396,     0,     0,   392,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,  1971,
    1972,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1973,     0,     0,     0,   392,     0,
    4056,     0,     0,   183,   184,     0,     0,     0,     0,   185,
       0,     0,     0,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,  1974,     0,     0,
    1975,     0,     0,     0,     0,     0,   191,     0,  3018,     0,
       0,     0,     0,     0,  1976,     0,     0,  1977,     0,     0,
       0,     0,  1730,     0,     0,     0,     0,  1108,     0,  1734,
       0,     0,     0,     0,     0,     0,  3018,     0,     0,     0,
       0,     0,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   204,     0,     0,  2203,   205,     0,
     206,     0,     0,     0,     0,   207,     0,     0,     0,     0,
     208,     0,     0,   210,     0,     0,     0,   212,     0,  1730,
       0,     0,     0,   213,     0,     0,  1978,     0,     0,   214,
       0,  1734,   216,     0,     0,     0,     0,     0,     0,   219,
       0,  1108,     0,     0,     0,     0,     0,     0,     0,     0,
    1117,  1108,   221,     0,     0,  1136,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,   226,     0,
     227,  1153,     0,     0,     0,     0,  1180,   229,  1730,   230,
       0,     0,   231,     0,     0,     0,   232,     0,  1108,     0,
       0,     0,     0,     0,     0,  1730,     0,  1006,   235,     0,
       0,     0,     0,  2396,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1730,     0,     0,  1979,     0,  1108,  1980,
    1981,  1982,  1964,  1983,  1984,  1985,  1986,  1987,  1988,  1734,
       0,     0,     0,  2558,     0,     0,     0,     0,  1730,   244,
       0,     0,     0,     0,     0,  1964,  1965,     0,  1108,  1108,
    1006,     0,     0,     0,  1967,     0,     0,     0,     0,  1968,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1967,  1108,  1108,
       0,     0,  1968,  1108,     0,     0,     0,     0,     0,  1301,
       0,  3213,  1964,     0,  1730,  1108,  1108,  1108,  1108,     0,
       0,     0,     0,   392,     0,  1312,     0,  1108,   392,     0,
    1108,     0,  1108,     0,     0,     0,  1965,     0,     0,     0,
       0,     0,  1108,  1108,  1967,  1108,     0,     0,     0,  1968,
       0,     0,     0,     0,     0,     0,  1434,     0,  1108,     0,
    1108,     0,     0,     0,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1459,     0,     0,     0,     0,
    1108,     0,     0,  2784,     0,     0,  1964,     0,     0,  3530,
       0,  1108,  3259,  1108,  1108,  1108,     0,     0,     0,  1482,
       0,  1969,     0,     0,     0,  1970,     0,     0,     0,     0,
    1965,     0,     0,  1108,     0,     0,     0,     0,  1967,     0,
       0,     0,  1108,  1968, -2292,  1971,  1972,     0,  1970,  1108,
       0,     0,     0,     0,  1108,     0,  2785,     0,     0,     0,
    1973,  1108,  1108,  1108,     0,  2786,  2787,  2788,  1971,  1972,
       0,     0,     0,     0,     0,     0,     0,  3291,     0,     0,
       0,     0,     0, -2292,     0,     0,     0,     0,     0,     0,
       0,  1969,     0,  1974,     0,  1970,  1975,     0,     0,     0,
       0,     0,     0,     0,  1730,  1108,     0,     0,     0,  2789,
    1976,     0,     0,  1977,     0,  1971,  1972,     0,     0,  1975,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1973,  1734,  1734,  1976,  1734,     0,     0,     0,     0,     0,
       0,  1734,  1006,     0,     0,     0,     0,     0,     0,     0,
       0,  2790,  1006,     0,     0,     0,  2791,     0,     0,     0,
       0,     0,     0,  1974,     0,  1969,  1975,     0,  1006,  1970,
       0,     0,  1734,     0,  1734,     0,     0,     0,     0,     0,
    1976,     0,  1978,  1977,     0,     0,     0,     0,     0,  1971,
    1972,     0,     0,  2396,     0,  2792,     0,  2396,     0,  1764,
    1766,  1767,     0,     0,  1973, -2292,     0,     0,   392,   392,
     392,     0,  2793,  2794,  2795,  2796,  2797,     0,  2798,     0,
       0,  1006,     0,     0,  1006,     0,     0,     0,     0,     0,
       0,  1006,  2276,     0,     0,     0,     0,  1974,     0,  1100,
    1975,     0,     0,     0,     0,  3453,  1734,     0,     0,     0,
       0,  2799,  1978,     0,  1976,     0,     0,  1977,     0,     0,
    1006,     0,     0,     0,     0,     0,     0,  3465,     0,     0,
    3320,  1734,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,  2800,  1434,  3330,
       0,     0,     0,     0,     0,  1979,     0,     0,   392,  1734,
       0,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,
       0,  1434,     0,     0,     0,  1734,     0,     0,     0,     0,
       0,     0,     0,  2801,     0,  2802,  1978,     0,     0,  1734,
       0,     0,     0,     0,  2736,     0,     0,     0,     0,  2203,
    2743,     0,  1979,     0,  1734,  1980,  1981,  1982,  2803,  1983,
    1984,  1985,  1986,  1987,  1988,  2804,     0,     0,  2805,  3515,
       0,  1108,     0,     0,     0,  1108,     0,     0,  1006,  1006,
       0,  1964,     0,     0,     0,  1108,     0,     0,     0,     0,
    1734,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1965,     0,     0,     0,     0,
       0,     0,     0,  1967,     0,     0,     0,  1108,  1968,     0,
       0,     0,     0,     0,     0,     0,  1979,     0,     0,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,  3547,     0,     0,     0,     0,  1108,     0,
       0,  1734,     0,     0,     0,     0,     0,  1108,     0,  2051,
    1964,     0,     0,  1108,  3578,  1108,  1730,     0,     0,     0,
    1734,  1108,     0,     0,  1108,  1108,  1108,  1108,  1108,  1108,
    1108,  1108,  1108,  1108,  1965,     0,     0,  1108,  1108,     0,
       0,     0,  1967,     0,     0,  1734,     0,  1968,     0,     0,
    1108,     0,     0,     0,   392,     0,  1108,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1108,     0,     0,  1108,
       0,  1108,     0,  3622,     0,  3624,     0,     0,  2203,  1734,
    1108,  1108,  1108,     0,     0,     0,  1108,     0,     0,  1108,
    1969,     0,     0,     0,  1970,     0,     0,     0,     0,  1108,
       0,     0,     0,     0,     0,     0,  2949,     0,  1108,     0,
       0,     0,     0,     0,  1971,  1972,     0,     0,     0,     0,
       0,     0,     0,     0,  1581,     0,  1006,     0,     0,  1973,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1582,     0,  1006,     0,     0,     0,
    2219,     0,  1974,     0,     0,  1975,     0,     0,     0,  1969,
       0,     0,     0,  1970,     0,     0,  1730,     0,     0,  1976,
     648,     0,  1977,     0,     0,   671,     0,   678,     0,     0,
       0,     0,     0,  1971,  1972,     0,     0,   678,     0,     0,
     392,  1734,   392,     0,     0,     0,  2396,  2269,  1973,     0,
    1583,  2396,     0,     0,  2396,     0,     0,     0,     0,     0,
       0,     0,     0,   671,     0,     0,     0,  2289,     0,   392,
       0,     0,     0,   678,     0,     0,     0,     0,     0, -2289,
    1584,  1974,   671,   678,  1975,  3018,   678,     0,     0,     0,
       0,  1978,   678,     0,     0,     0,   678,     0,  1976,     0,
     937,  1977,     0,     0,     0,     0,     0,     0,  2950,     0,
       0,     0,     0,     0,   939,     0,     0,   678,     0,     0,
       0,     0,   946,     0,     0,     0,     0,     0, -2289,     0,
       0,     0,     0,   678,     0,     0,     0,   956, -2289,   937,
       0,     0, -2289,   977,     0,     0,  1108, -2289,     0,     0,
       0, -2289,     0,     0, -2289,     0, -2289,     0,     0,  1734,
    1014,  1006,  1006,  1006,  1006,     0,   678,     0,     0,     0,
    1978,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1979, -2289,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,  1734,  1108,  1108,     0,  3565,     0,
       0,  2419, -2289,     0,     0,     0,     0,     0,  1964,     0,
    2423,   207,     0,     0,  1108,  1587,     0,     0,     0,  1108,
       0,  1588,  1108,  3839,     0,     0,     0,     0,  1589,     0,
       0,     0,  1965,     0,  3848,  1623,     0,     0,     0,     0,
    1967,     0,     0,  1591,     0,  1968, -2289,     0,     0,     0,
       0,  1592,     0,     0,  1964, -2289,     0,     0,  1434,  1434,
    1979,  1108,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,     0,     0,  3574,  2203,  2743,
       0,  2743,     0,     0,     0,     0,  1967,     0,  1730,     0,
       0,  1968,     0,     0,     0,     0,     0,  1108, -2289,  1593,
       0,     0,     0,  2952,  1108,  1108,     0,  1734,     0,     0,
       0,     0,  1108,  1108,     0,     0,     0,  1108,  1734,  1730,
       0,  1730,     0,  1108,  1108,     0,     0,  1108,     0,     0,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   942,     0,     0,     0,     0,  1108,     0,  1100,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,     0, -2289,     0,     0,  1969,     0,     0,
       0,  1970,  2396,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1734,     0,     0, -2289,  2616, -2289, -2289,     0,
    1734,  1971,  1972,  1730,     0,     0,     0,     0,  3018,     0,
       0,     0,     0,     0,     0,     0,  1973,     0,     0,     0,
       0,  2632,     0,  1969,     0,     0,     0,  1970,  2743,     0,
       0,     0,     0,     0,     0,     0,     0, -2289,     0,     0,
   -2289, -2289,     0, -2289,     0,     0,     0,  1971,  1972,  1974,
       0,     0,  1975,     0,     0,     0,  2743,     0,     0,     0,
       0,     0,  1973,     0,     0,     0,  1976,  1964,     0,  1977,
    2652,     0,  1730,     0,     0,     0,  1100,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1730,  1108,     0,     0,
       0,  1965,     0,     0,     0,     0,     0,   392,  1975,  1967,
       0,  2743,     0,     0,  1968,     0,     0,  1100,     0,     0,
       0,     0,  1976,     0,     0,     0,  1006,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1108,     0,     0,
       0,     0,  1734,     0,     0,     0,     0,  1730,  1978,     0,
       0,     0,  1006,     0,     0,     0,  1108,     0,     0,     0,
    1108,     0,     0,     0,  1100,  1734,     0,     0,     0,   671,
       0,     0,     0,     0,     0,     0,  1006,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1108,     0,     0,     0,
    1734,     0,     0,     0,  1978,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1730,     0,
    1108,  1108,     0,     0,  1108,     0,   678,   678,     0,     0,
       0,  1108,  1108,     0,     0,  1006,     0,  1730,     0,     0,
     678,  2765,     0,     0,     0,     0,  1969,     0,  1979,     0,
    1970,  1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,
    1988,  1734,  1730,     0,  1108,  3771,     0,     0,     0,     0,
    1971,  1972,     0,     0,     0,     0,  1100,     0,     0,     0,
       0,     0,     0,     0,     0,  1973,     0,     0,  1729,     0,
       0,     0,     0,     0,  1979,  1108,  1730,  1100, -2292, -2292,
       0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1974,     0,
       0,  1975,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1721,  1976,     0,     0,  1977,     0,
       0,     0,  1108,  1108,     0,     0,     0,     0,     0,  1734,
       0,     0,     0,     0,  1110,   671,  1110,  2907,     0,   648,
       0,  1133,     0,   648,   678,     0,   678,     0,   678,     0,
     678,  1110,   648,     0,     0,  1108,  1734,     0,  1108,     0,
    1108,  1155,     0,     0,     0,     0,     0,     0,     0,   678,
    1100,  2926,   671,     0,  1110,     0,     0,   648,  2944,  1133,
       0,   648,  1200,   678,   678,     0,  1108,  1978,   678,  1734,
    1110,  1729,   648,  1734,  1734,     0,     0,     0,  2743,     0,
       0,     0,     0,     0,     0,   678,     0,   678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   392,     0,   678,
       0,     0,   671,     0,  1108,     0,   678,     0,  1133,     0,
     678,   678,     0,     0,   678,     0,   678,  1721,   678,     0,
     678,     0,     0,  1110,     0,  1108,     0,     0,     0,     0,
       0,     0,  1734,     0,  4121,  1100,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   678,   678,     0,     0,     0,
    1108,     0,     0,     0,  1964,     0,     0,  1979,     0,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
    1964,   678,   877,   678,  3803,     0,  1313,     0,  1965,     0,
       0,     0,     0,     0,   878,     0,  1967,     0,     0,     0,
       0,  1968,     0,     0,  1965,     0,  1730,     0,     0,     0,
       0,     0,  1967,   678,   879,   671,     0,  1968,     0,  1441,
       0,  2029,     0,     0,     0,     0,     0,     0,  1108,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   880,     0,
       0,  2203,     0,     0,     0,     0,  1468,     0,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,   881,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   882,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3142,     0,     0,   883,   648,   648,     0,
       0,   884,     0,  1108,     0,     0,   885,     0,     0,     0,
     678,     0,   678,  1969,     0,     0,   678,  1970,     0,     0,
       0,   886,     0,     0,     0,     0,  1729,     0,     0,  1969,
       0,     0,     0,  1970,     0,     0,     0,  1971,  1972,  1110,
    1110,     0,     0,     0,  1730,     0,  1434,     0,     0,     0,
       0,     0,  1973,  1971,  1972,  1730,     0,     0,     0,     0,
       0,  1729,     0,     0,     0,     0,     0,   678,  1973,     0,
       0,     0,  1721,     0,     0,     0,     0,     0,     0,     0,
     678,     0,     0,  1729,     0,  1974,     0,  1133,  1975,   678,
       0,     0,     0,     0,     0,   678,     0,     0,     0,  1110,
       0,  1974,  1976,   887,  1975,  1977,   678,  1721,     0,     0,
       0,     0,     0,   888,     0,  1110,  1110,     0,  1976,  1730,
       0,  1977,     0,     0,     0,     0,     0,  1730,     0,  1721,
     801,     0,     0,  1110,  1772,     0,   678,  1776,     0,     0,
       0,     0,  1729,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   889,     0,     0,     0,   890,  1729,
     891,  1110,  1110,     0,     0,   678,   892,     0,   893,     0,
       0,     0,  1964,     0,  1978,     0,     0,  1729,     0,     0,
    1441,     0,     0,     0,     0,     0,     0,     0,  1721,     0,
    1978,     0,     0,     0,   894,   895,  1965,     0,     0,   896,
       0,     0,  1729,     0,  1967,  1721,   678,   897,     0,  1968,
       0,     0,   898,  1860,  1860,     0,     0,     0,     0,   678,
     937,     0,   899,  1721,     0,   678,     0,     0,     0,     0,
     678,     0,     0,     0,   900,     0,     0,     0,  1892,     0,
       0,     0,   678,     0,  1898,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1729,  3929,
       0,     0,     0,     0,  1979,     0,     0,  1980,  1981,  1982,
       0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,
    1979,  3959,  1730,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,     0,     0,     0,     0,  3974,  3373,     0,
       0,     0,     0,     0,  1721,     0,     0,  1730,  3384,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3397,     0,     0,     0,     0,     0,
       0,  1969,     0,     0,     0,  1970,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   671,
     671,     0,     0,     0,     0,  1971,  1972,     0,     0,     0,
       0,     0,     0,     0,     0,  1441,     0,     0,  2743,     0,
    1973,     0,  1441,  1441,     0,     0,     0,  3444,     0,     0,
    3445,     0,     0,     0,     0,  1964,     0,  3449,  2061,     0,
    2068,     0,     0,     0,     0,     0,     0,     0,   678,   678,
       0,     0,     0,  1974,     0,     0,  1975,     0,     0,  1965,
       0,     0,     0,     0,     0,     0,  1434,  1967,     0,     0,
    1976,     0,  1968,  1977,     0,     0,     0,     0,  1729,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   671,     0,   648,  1964,     0,     0,
       0,     0,     0,     0,     0,     0,  2743,  1603,     0,     0,
       0,     0,     0,  1604,     0,     0,     0,     0,     0,     0,
       0,  1965,     0,     0,  1721,     0,   678,     0,     0,  1967,
       0,     0,     0,  1730,  1968,     0,     0,  1628,     0,     0,
       0,     0,  1978,     0,     0,     0,     0,     0,     0,     0,
       0,   678,  1605,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1730,     0,     0,     0,
    1730,  1730,     0,     0,  3540,  3541,     0,     0,     0,  1964,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
       0,     0,  1133,     0,  1969,     0,     0,     0,  1970,     0,
       0,     0,  1606,     0,     0,     0,     0,     0,     0,  1607,
       0,  1967,  1608,     0,     0,     0,  1968,     0,  1971,  1972,
       0,     0,     0,  1110,  1110,  1110,  1110,     0,     0,  3929,
       0,   648,  1979,  1973,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,  1772,     0,     0,     0,  4008,
       0,     0,     0,  1110,  1110,     0,  1969,     0,  1630,  1110,
    1970,  1609,     0,     0,     0,     0,  1974,     0,     0,  1975,
       0,     0,     0,     0,     0,  1964,    35,     0,     0,     0,
    1971,  1972,     0,  1976,    41,     0,  1977,     0,     0,     0,
       0,     0,     0,     0,     0,  1973,     0,     0,     0,  1965,
       0,     0,  1966,  1631,     0,  1632,     0,  1967,  1729,     0,
     678,     0,  1968,  1729,  1729,     0,  1633,     0,   648,     0,
       0,     0,   678,     0,  1110,  1110,  1110,  1110,  1974,     0,
       0,  1975,     0,   648,     0,     0,     0,     0,  1969,  1441,
       0,  1772,  1970,     0,     0,  1976,     0,     0,  1977,     0,
       0,  1634,  1611,     0,  1721,  1978,     0,     0,     0,  1721,
    1721,     0,  1971,  1972,     0,     0,   671,   678,     0,     0,
     678,   678,  3667,     0,     0,     0,  1133,  1973,     0,   678,
     678,  1635,   678,     0,   678,  1613,  1636,     0,     0,   678,
    3692,   678,   648,     0,     0,     0,  1110,  1110,     0,     0,
       0,     0,  3697,     0,     0,     0,     0,     0,     0,  1637,
    1974,   678,   678,  1975,     0,     0,     0,  1978,     0,  1638,
       0,     0,     0,     0,     0,     0,     0,  1976,  1860,     0,
    1729,     0,     0,   678,  1969,     0,   678,   678,  1970,     0,
     678,     0,     0,     0,     0,  1979,  2464,     0,  1980,  1981,
    1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,  1971,  1972,
       0,     0,  4109,     0,   937,   937,     0,     0,  2489,     0,
       0,     0,     0,  1973,     0,     0,  1721,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1729,     0,     0,     0,     0,     0,     0,  1978,
       0,     0,  1133,     0,     0,     0,  1974,  1979,     0,  1975,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
       0,     0,  3558,  1976,     0,     0,  1977,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3804,  3805,  3806,
    3807,     0,     0,   678,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1979,
    1729,     0,  1980,  1981,  1982,  1978,  1983,  1984,  1985,  1986,
    1987,  1988,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2068,     0,     0,  1721,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,  1979,     0,     0,  1980,  1981,
    1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,     0,
       0,   648,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,     0,     0,  1723,     0,     0,
       0,     0,     0,     0,     0,   648,   678,     0,     0,   648,
     671,   678,     0,     0,     0,   678,     0,     0,     0,     0,
       0,   678,     0,     0,   648,     0,     0,   678,     0,     0,
       0,     0,   648,   678,     0,     0,     0,     0,   678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   648,   678,     0,     0,  2748,
    2749,   678,   678,   678,   678,  2756,     0,     0,   678,   678,
       0,     0,   648,   678,     0,     0,   678,     0,     0,     0,
       0,  2777,  2777,     0,     0,     0,     0,   648,     0,   648,
     678,     0,     0,     0,     0,     0,     0,     0,     0,  1110,
     678,     0,   678,     0,     0,     0,     0,   648,     0,     0,
       0,   678,   678,   678,   648,   678,     0,     0,     0,     0,
    1723,   648,   678,   678,     0,     0,     0,     0,   648,     0,
     678,   678,  1729,  1729,     0,  1729,     0,     0,     0,     0,
       0,     0,  1729,  1110,     0,     0,     0,     0,     0,     0,
    1110,  1110,  1110,  1110,  1110,  1110,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1724,     0,     0,     0,
       0,     0,  1964,  1729,     0,  1729,     0,     0,  1721,  1721,
       0,  1721,     0,  2777,     0,     0,     0,     0,  1721,     0,
       0,   937,  4006,     0,     0,     0,  1965,     0,     0,     0,
    2657,     0,  1964,     0,  1967,     0,     0,     0,     0,  1968,
       0,     0,     0,     0,     0,  2922,     0,     0,  1434,  1721,
       0,  1721,  2936,     0,     0,     0,  1965,     0,     0,  3048,
       0,     0,  1776,     0,  1967,     0,     0,     0,     0,  1968,
    2967,     0,  4050,     0,  2967,  2980,     0,  1729,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1110,  2777,  1110,  2777,     0,     0,     0,     0,     0,
       0,     0,  1729,     0,     0,     0,     0,     0,  1441,  2658,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1724,
       0,  4072,   678,  1721,     0,     0,     0,  1860,     0,     0,
    1729,   678,     0,     0,     0,   777,     0,     0,     0,   648,
       0,     0,  1964,     0,     0,     0,  1729,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,  1969,     0,   678,     0,  1970,  1965,   648,     0,     0,
       0,     0,     0,     0,  1967,  1729,  1721,     0,   777,  1968,
       0,     0,     0,     0,     0,  1971,  1972,     0,     0,     0,
       0,  1969,  1721,     0,     0,  1970,     0,     0,     0,     0,
    1973,     0,     0,     0,     0,  1723,  1721,     0,     0,     0,
       0,  1729,     0,     0,     0,  1971,  1972,     0,     0,     0,
       0,  1721,     0,     0,     0,   967,     0,     0,     0,     0,
    1973,     0,   967,  1974,   967,     0,  1975,     0,     0,     0,
    1723,  3110,     0,     0,     0,     0,   777,     0,     0,     0,
    1976,     0,     0,  1977,     0,     0,     0,  1721,     0,     0,
       0,     0,  1723,  1974,     0,     0,  1975,     0,     0,     0,
    1133,     0,  1729,     0,     0,     0,     0,     0,     0,     0,
    1976,  3084,     0,  1977,     0,     0,  3085,     0,     0,     0,
       0,  1729,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1969,     0,     0,     0,  1970,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1729,  1441,  1721,     0,
       0,  1723,  1978,     0,     0,  1971,  1972,     0,  2068,     0,
       0,     0,     0,     0,     0,     0,     0,  1721,  1723,     0,
    1973,     0,     0,  1964,     0,     0,     0,     0,     0,     0,
    1729,     0,  1978,     0,     0,     0,  1723,     0,     0,     0,
       0,     0,  1721,     0,     0,     0,     0,  1965,     0,     0,
    2659,     0,     0,  1974,  1724,  1967,  1975,     0,     0,     0,
    1968,  1723,   648,   678,   678,     0,     0,     0,     0,     0,
    1976,     0,     0,  1977,     0,     0,  1721,  1860,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,     0,  1724,
       0,     0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,     0,
       0,  1724,     0,     0,     0,     0,     0,  1723,   678,   678,
     678,   678,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,  1978,   648,     0,   678,     0,     0,     0,     0,
       0,     0,  1729,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,     0,     0,   678,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1969,     0,     0,     0,  1970,  1724,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1721,     0,
       0,  1964,     0,     0,   678,  1724,  1971,  1972,   648,   678,
       0,     0,     0,     0,     0,     0,     0,     0,  2777,  2777,
       0,  1973,     0,     0,     0,  1965,     0,     0,     0,     0,
    1724,     0,  1979,  1967,     0,  1980,  1981,  1982,  1968,  1983,
    1984,  1985,  1986,  1987,  1988,  3337,     0,     0,     0,     0,
       0,     0,     0,     0,  1974,     0,     0,  1975,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1729,  1976,     0,     0,  1977,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   678,   678,  1724,  1723,     0,     0,
       0,     0,  3507,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,     0,  1729,     0,     0,     0,     0,
       0,  1441,     0,     0,     0,     0,  1721,     0,     0,   671,
       0,     0,   678,  2967,     0,     0,  3418,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3431,
       0,     0,     0,  1978,     0,     0,     0,     0,     0,   678,
       0,  1721,     0,     0,     0,     0,  3508,     0,     0,     0,
    1969,     0,   678,   648,  1970,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,     0,   648,     0,     0,     0,
       0,     0,     0,  2464,  1971,  1972,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,     0,   648,  1973,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   792,     0,     0,     0,     0,     0,     0,  1729,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1729,
       0,     0,  1974,  1979,     0,  1975,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,  1976,
       0,     0,  1977,     0,     0,     0,  1724,     0,     0,     0,
       0,     0,     0,     0,  1721,  3062,     0,   793,     0,     0,
       0,     0,     0,     0,     0,  1721,     0,     0,     0,     0,
       0,     0,   777,     0,     0,     0,     0,   794,     0,     0,
    1106,     0,     0,  1729,     0,  1106,     0,     0,     0,     0,
       0,  1729,     0,     0,     0,     0,     0,     0,   795,     0,
       0,     0,     0,  3551,     0,     0,     0,  1723,     0,     0,
       0,  1978,  1723,  1723,     0,  1106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   796,     0,     0,     0,  1721,
     797,     0,     0,     0,  2068,   798,     0,  1721,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     799,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1964,     0,     0,  1106,     0,     0,     0,     0,
    1860,  1860,  1106,     0,     0,   648,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1965,     0,     0,  3092,
       0,     0,     0,     0,  1967,     0,     0,     0,     0,  1968,
       0,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,  1984,
    1985,  1986,  1987,  1988,   678,   678,  1964,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1723,
     678,     0,   800,     0,   648,   678,   648,   678,   678,   678,
     678,     0,     0,     0,     0,     0,  1729,     0,  1967,     0,
       0,     0,     0,  1968,     0,     0,     0,     0,     0,   801,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,     0,
       0,  1729,     0,     0,   967,     0,  1724,     0,   967,     0,
       0,  1724,  1724,   802,     0,     0,  3337,     0,     0,   803,
    1964,  1723,  1721,     0,     0,   804,     0,   805,     0,   678,
     678,   678,     0,   678,     0,     0,     0,  1106,     0,     0,
       0,     0,     0,     0,  1965,     0,     0,  1721,     0,     0,
       0,  1969,  1967,   806,   807,  1970,     0,  1968,   808,  2922,
       0,     0,  1729,     0,  2748,     0,   809,  2748,     0,  3714,
       0,   810,     0,     0,     0,  1971,  1972,     0,     0,  2777,
       0,   811,     0,     0,     0,     0,     0,     0,     0,     0,
    1973,     0,     0,   812,     0,     0,     0,     0,  2967,     0,
     678,     0,     0,     0,     0,  1969,     0,     0,  1721,  1970,
       0,  2922,     0,  3752,     0,   678,     0,     0,     0,  1723,
    2777,     0,  2777,  1974,     0,     0,  1975,     0,  1724,  1971,
    1972,     0,     0,     0,     0,     0,   648,     0,     0,     0,
    1976,     0,     0,  1977,  1973,     0,     0,     0,     0,     0,
    1729,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3097,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1106,     0,     0,  1729,     0,  1969,
    1975,  1106,     0,  1970,     0,     0,     0,     0,     0,     0,
    1724,     0,     0,     0,  1976,     0,  1721,     0,     0,     0,
       0,     0,  1732,  1971,  1972,     0,     0,     0,     0,     0,
    1729,     0,  1978,     0,  1729,  1729,     0,     0,  1973,     0,
       0,     0,     0,  1721,     0,     0,     0,     0,     0,     0,
    3815,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1133,     0,     0,     0,     0,     0,
       0,  1974,     0,     0,  1975,     0,  1721,     0,     0,     0,
    1721,  1721,     0,     0,     0,     0,  1978,     0,  1976,  3836,
       0,  1977,     0,     0,   648,   678,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   648,   678,     0,  1724,     0,
       0,     0,  1106,     0,     0,     0,     0,     0,   678,   678,
    1110,   678,  1979,     0,     0,  1980,  1981,  1982,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1732,     0,  1860,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1978,  3337,  3337,  3337,  3337,  3337,     0,  1106,     0,     0,
       0,     0,     0,     0,     0,     0,  1979,     0,     0,  1980,
    1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,     0,
       0,     0,     0,     0,     0,  1106,     0,     0,     0,   678,
       0,  1723,  1723,     0,  1723,     0,     0,     0,     0,     0,
       0,  1723,     0,     0,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,  3924,  1106,  1106,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,  3932,     0,
       0,   678,  1723,     0,  1723,     0,  1106,     0,     0,     0,
    1979,  3752,     0,  1980,  1981,  1982,     0,  1983,  1984,  1985,
    1986,  1987,  1988,   678,  3714,     0,     0,     0,     0,   648,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,   777,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1723,     0,     0,     0,
       0,     0,     0,     0,     0,  1106,     0,     0,     0,  1106,
    1106,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1723,     0,  1133,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1860,     0,     0,     0,     0,     0,  1723,
    1724,  1724,     0,  1724,     0,     0,     0,     0,     0,     0,
    1724,     0,     0,     0,     0,  1723,     0,     0,     0,     0,
       0,     0,     0,     0,  2777,     0,  2748,     0,     0,  1723,
    1732,     0,     0,     0,   777,     0,     0,     0,   967,     0,
       0,  1724,     0,  1724,  1723,     0,     0,     0,     0,  1110,
    3924,     0,     0,     0,  1110,  1110,     0,     0,   967,     0,
       0,     0,     0,  1964,     0,  1732,     0,     0,   678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1723,     0,     0,     0,     0,  1964,     0,  1732,     0,     0,
       0,   967,     0,     0,     0,  1967,     0,     0,     0,     0,
    1968,  4066,     0,     0,     0,     0,     0,     0,     0,  1965,
       0,     0,  3101,     0,     0,  1724,     0,  1967,     0,     0,
       0,     0,  1968,     0,  1110,  1110,  1110,  1110,   678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1724,  1723,     0,     0,     0,     0,  1732,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1723,     0,     0,  1732,     0,     0,     0,     0,  1724,     0,
       0,     0,     0,  3924,  1110,     0,     0,     0,     0,     0,
       0,  1732,     0,     0,  1724,  1723,     0,  3531,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1724,     0,
       0,     0,     0,     0,     0,     0,  1732,     0,     0,     0,
       0,   777,     0,  1724,     0,     0,     0,     0,     0,  1723,
       0,     0, -2292,     0,     0,     0,  1970,     0,     0,   678,
       0,  1110,     0,     0,     0,     0,     0,     0,     0,     0,
    1110,     0,     0,     0,  1969,     0,  1971,  1972,  1970,  1724,
       0,     0,     0,  3932,  1106,     0,  1106,     0,     0,  4066,
       0, -2292,  1732,     0,     0,  1106,     0,     0,  1971,  1972,
    1110,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4185,     0,  1973,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1975,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1724,  1976,     0,     0,     0,     0,  1974,     0,     0,  1975,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1724,
       0,     0,  1106,  1976,     0,     0,  1977,  4185,     0,     0,
       0,  1723,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1724,     0,     0,     0,     0,     0,
       0,     0,  4185,     0,     0,     0,     0,  1106,  1106,     0,
       0,     0,     0,     0,     0,  1106,     0,     0,  1106,     0,
       0,  1106,     0, -2292,     0,     0,     0,     0,  1724,  1106,
    1106,     0,     0,  1964,     0,     0,     0,  1106,     0,     0,
    1106,  1106,  1106,  1106,     0,  1978,     0,     0,     0,     0,
    1106,  1106,     0,  1106,     0,  1106,     0,  1965,  1106,     0,
    3514,     0,     0,     0,     0,  1967,     0,     0,     0,     0,
    1968,     0,  1732,  1106,   777,     0,     0,  1106,     0,     0,
       0,  1106,     0,     0,     0,  1106,     0,     0,  1106,  1106,
    1106,  1106,  1106,  1106,  1106,  1106,  1106,     0,  1106,  1723,
       0,     0,     0,     0,  1106,     0,     0,     0,  1106,     0,
       0,     0,     0,  1979,     0,     0,     0,  1964,     0,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,
       0,     0,     0,     0,  1723,  1979,     0,     0,  1980,  1981,
    1982,  1965,  1983,  1984,  1985,  1986,  1987,  1988,     0,  1967,
    1724,     0,     0,     0,  1968,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1964,     0,     0,     0,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1969,     0,     0,     0,  1970,     0,     0,     0,
       0,     0,     0,     0,     0,  1967,     0,     0,     0,     0,
    1968,     0,     0,     0,     0,     0,  1971,  1972,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1973,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1723,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1723,     0,
       0,     0,     0,   965,  1974,   777,     0,  1975,  1724,     0,
     965,     0,   965,     0,     0,     0,  1969,     0,     0,     0,
    1970,  1976,  1106,     0,  1977,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3534,     0,     0,
    1971,  1972,  1732,  1724,     0,     0,     0,  1732,  1732,     0,
       0,     0,     0,     0,     0,  1973,     0,     0,     0,     0,
       0,     0,  1723,     0,     0,     0,     0,     0,     0,     0,
    1723,   777, -2292,     0,     0,     0,  1970,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,  1974,     0,
       0,  1975,     0,  1978,     0,     0,  1971,  1972,     0,     5,
       0,     0,     0,   777,     0,  1976,     0,     0,  1977,     6,
       7, -2292,     0,     0,     0,     8,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,     0,    35,  1975,    36,     0,
      37,    38,    39,    40,    41,     0,  1724,     0,     0,     0,
       0,  1976,  1106,     0,  1732,     0,     0,  1724,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1978,     0,     0,
       0,     0,  1964,  1979,     0,     0,  1980,  1981,  1982,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,    42,     0,     0,
       0,     0,  3468,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1967,     0,     0,     0,     0,  1968,
       0,     0,     0,     0,     0,  1723,  1732,     0,     0,     0,
       0,  1724,     0, -2292,     0,     0,  1106,     0,     0,  1724,
       0,     0,     0,     0,     0,     0,  1106,     0,     0,     0,
    1723,     0,     0,     0,     0,     0,  1726,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1979,    43,     0,
    1980,  1981,  1982,     0,  1983,  1984,  1985,  1986,  1987,  1988,
       0,     0,    44,  1106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,  3801,     0,     0,     0,
       0,  1723,     0,  1106,     0,     0,     0,     0,     0,     0,
       0,     0,    46,  1979,  1732,     0,     0,     0,     0,     0,
    1983,  1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,
       0, -2292,     0,  1106,  1106,  1970,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
       0,     0,     0,     0,     0,  1971,  1972,     0,     0,     0,
       0,     0,     0,  1106,  1106,     0,     0,     0,  1106,  1726,
   -2292,    49,     0,     0,     0,     0,     0,     0,     0,     0,
    1106,  1106,  1106,  1106,  1724,     0,     0,     0,   777,  1723,
       0,     0,  1106,   777,     0,  1106,     0,  1106,     0,     0,
       0,     0,     0,     0,     0,     0,  1975,  1106,  1106,  1724,
    1106,     0,     0,     0,     0,     0,  1723,     0,     0,     0,
    1976,     0,     0,  1106,     0,  1106,     0,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,  1964,  1106,     0,     0,     0,  1723,
       0,     0,     0,  1723,  1723,     0,  1106,     0,  1106,  1106,
    1106,     0,     0,     0,     0,     0,     0,     0,  1965,     0,
    1724,     0,     0,     0,     0,     0,  1967,     0,  1106,     0,
       0,  1968,     0,    51,     0,     0,     0,  1106,     0,     0,
       0,     0, -2292,     0,  1106,     0,    52,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,  1106,  1106,  1106,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,    59,     0,
    1106,     0,    60,    61,    62,    63,    64,     0,  1724,    65,
      66,    67,    68,     0,    69,    70,    71,    72,    73,     0,
       0,     0,     0,     0,     0,     0,  1732,  1732,  1104,  1732,
       0,     0,  1979,  1104,     0,  1724,  1732,     0,     0,  1983,
    1984,  1985,  1986,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,  1969,     0,     0,     0,  1970,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,  1732,  1724,  1732,
       0,     0,  1724,  1724,  1726,     0,     0,  1971,  1972,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1973,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   777,   777,   777,     0,     0,     0,  1726,
       0,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,  1974,     0,     0,  1975,     0,
       0,  1726,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1732,  1976,     0,  1156,  1977,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1732,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1157,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1158,
    1726,     0,     0,   777,  1732,     0,  1159,     0,     0,     0,
    1160,     0,     0,     0,     0,     0,     0,  1726,     0,     0,
    1732,     0,     0,     0,  1978,     0,  1104,     0,     0,     0,
    1161,     0,   965,     0,  1732,  1726,   965,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1732,
       0,  1162,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,     0,  1104,  1106,     0,     0,     0,
    1106,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1106,     0,     0,  1163,     0,  1732,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1164,     0,     0,     0,     0,     0,     0,
       0,     0,  1106,     0,  1979,     0,  1726,  1980,  1981,  1982,
       0,  1983,  1984,  1985,  1986,  1987,  1988,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1106,     0,     0,  1732,     0,     0,     0,
       0,     0,  1106,     0,     0,     0,     0,     0,  1106,     0,
    1106,     0,     0,     0,     0,  1732,  1106,     0,     0,  1106,
    1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,  1106,     0,
       0,     0,  1106,  1106,     0,  1166,     0,     0,     0,     0,
    1732,     0,     0,     0,     0,  1106, -2291,     0,     0,   777,
       0,  1106,  1104,     0,     0,     0,     0,     0,     0,  1104,
       0,  1106,   801,     0,  1106,     0,  1106,     0,     0,     0,
       0,     0,     0,     0,  1732,  1106,  1106,  1106,     0,     0,
    1731,  1106,     0,     0,  1106,     0,  1167,     0,     0,     0,
    1168,     0,  1169,     0,  1106, -2291,     0,     0,  1170,     0,
       0,     0,     0,  1106,     0, -2291,     0,     0,     0, -2291,
    1104,     0,     0,     0, -2291,     0,     0,     0, -2291,     0,
       0, -2291,     0, -2291,     0,     0,  1171,  1172,     0,     0,
       0,  1173,     0,     0,     0,     0,  1726,     0,     0,  1174,
       0,     0,     0,     0,  1175,     0,     0,     0,     0, -2291,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1176,     0,     0, -2291,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   777,  1732,   777,     0,     0,
       0,     0,     0,  1731,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2291,     0,     0,     0,     0,     0,     0,
       0,     0, -2291,     0,   777,  1104,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2291,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,  1104,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1106,     0,     0,  1104,     0,     0,     0,     0,   942,
       0,     0,     0,     0,  1732,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1732,
    1106,  1106, -2291,     0, -2291, -2291,  1104,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1726,     0,     0,  1106,
       0,  1726,  1726,     0,  1106,     0,     0,  1106,     0,   827,
       0,     0,     0,  1104,     0,     0,     0,  1104,  1104,     0,
       0,   828,     0,     0, -2291,     0,     0, -2291, -2291,     0,
   -2291,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   829,     0,     0,     0,     0,  1106,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   830,     0,     0,     0,  -582,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1106,     0,     0,   831,     0,     0,  1731,  1106,
    1106,   832,  1732,     0,     0,     0,   965,  1106,  1106,     0,
       0,     0,  1106,  1732,     0,     0,   833,     0,  1106,  1106,
       0,     0,  1106,     0,     0,     0,   965,     0,  1726,     0,
       0,   661,     0,  1731,     0,     0,   675,     0,     0,     0,
       0,     0,  1106,   834,     0,     0,     0,     0,  -745,   835,
       0,     0,     0,   836,     0,  1731,     0,     0,     0,   965,
       0,     0,     0,     0,     0,     0,     0,     0,  -724,     0,
       0,     0,     0,     0,   675,     0,     0,  1732,     0,     0,
       0,     0,     0,     0,     0,  1732,     0,     0,     0,     0,
    1726,  -447,     0,   675,   675,     0,     0,     0,     0,     0,
       0,     0,     0,   675,   837,     0,     0,   661,     0,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   661,     0,
       0,  1731,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   675,     0,     0,     0,     0,  1731,
     838,     0,     0,   839,     0,     0,  1727,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1106,     0,  1731,     0,     0,  -447,     0,     0,
       0,     0,   777,     0,     0,     0,     0,     0,  1726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   840,     0,     0,     0,  -745,     0,   841,     0,     0,
       0,     0,  1106,     0,     0,   842,     0,  1732,     0,     0,
       0,     0,  1104,     0,  1104,     0,     0,     0,     0,     0,
    1731,  1106,     0,  1104,     0,  1106,     0,     0,     0,     0,
    1732,     0,   843,   844,     0,   845,   846,     0,     0,     0,
       0,     0,     0,     0,   847,     0,     0,     0,   848,   849,
       0,  1106,     0,     0,   850,  1732,     0,     0,     0,   851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,  1106,  1106,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,  1106,  1106,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1732,     0,     0,  1106,
       0,     0,     0,     0,     0,  1104,  1104,     0,     0,     0,
       0,   675,     0,  1104,     0,     0,  1104,     0,     0,  1104,
       0,     0,     0,     0,     0,     0,     0,  1104,  1104,     0,
    1106,     0,     0,     0,     0,  1104,     0,     0,  1104,  1104,
    1104,  1104,     0,     0,     0,     0,     0,     0,  1104,  1104,
       0,  1104,     0,  1104,     0,     0,  1104,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1731,  1104,     0,     0,     0,  1104,     0,  1106,  1106,  1104,
       0,     0,     0,  1104,  1732,     0,  1104,  1104,  1104,  1104,
    1104,  1104,  1104,  1104,  1104,     0,  1104,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,  1104,     0,     0,     0,
    1106,  1732,     0,  1106,     0,  1106,     0,     0,     0,     0,
    1726,  1726,     0,  1726,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1106,     0,     0,  1732,     0,     0,     0,  1732,  1732,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1726,     0,  1726,     0,     0,     0,     0,     0,     0,
       0,     0,   777,     0,     0,     0,     0,  1104,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1106,     0,     0,     0,  1727,     0,     0,  1732,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,  1106,     0,   680,     0,     0,
     675,     0,     0,     0,     0,  1726,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,  1727,     0,   818,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   867,     0,     0,   871,     0,     0,     0,
    1104,     0,   867,     0,     0,     0,   926,     0,  1726,     0,
       0,   675,     0,  1106,     0,     0,     0,     0,     0,     0,
    1731,     0,     0,     0,  1726,  1731,  1731,   945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1726,     0,
    1727,     0,     0,   867,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,     0,  1727,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1727,  1024,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1726,
       0,     0,     0,     0,     0,     0,     0,     0,  1106,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,  1731,     0,     0,     0,     0,     0,     0,     0,
    1726,     0,     0,     0,     0,     0,  1727,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1726,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1726,  1220,   675,     0,   675,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,  1726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   675,
    1070,     0,     0,   661,     0,   661,     0,   661,     0,     0,
       0,     0,     0,   661,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1731,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   675,     0,   675,     0,     0,     0,
       0,  1104,  1104,     0,     0,     0,  1727,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1726,  1104,  1104,     0,     0,     0,  1104,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,  1104,
    1104,  1104,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,  1104,     0,  1104,     0,     0,     0,     0,
       0,     0,     0,   661,     0,  1104,  1104,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   661,   661,
       0,  1104,  1536,  1104,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,  1104,  1104,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1104,     0,  1726,     0,
       0,     0,     0,     0,     0,  1104,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,  1104,  1104,  1104,     0,     0,     0,
       0,     0,     0,  1726,     0,     0,  1078,  1079,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1070,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1727,     0,     0,     0,
       0,  1727,  1727,     0,  1731,  1731,     0,  1731,     0,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1731,     0,  1731,     0,     0,
       0,     0,     0,     0,     0,     0,  1726,     0,     0,     0,
    1856,     0,     0,     0,     0,     0,     0,  1726,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   675,     0,
       0,     0,     0,     0,  1135,     0,  1137,     0,  1139,     0,
    1141,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1183,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,  1731,
       0,     0,     0,  1201,  1202,     0,     0,     0,  1204,     0,
       0,  1726,     0,     0,     0,     0,     0,     0,     0,  1726,
       0,     0,     0,     0,  1731,  1070,     0,   867,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1248,  1731,     0,  1250,     0,  1252,     0,  1255,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,  1731,  1728,
       0,  2004,     0,     0,     0,     0,     0,     0,     0,     0,
     675,   675,  1731,     0,     0,  1286,  1287,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1731,     0,   661,
       0,     0,     0,   661,   661,     0,     0,     0,     0,     0,
       0,  1310,     0,  1311,  1104,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,     0,  1731,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1070,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1726,   675,     0,   661,     0,     0,
       0,     0,  1024,     0,     0,  2135,     0,     0,     0,     0,
       0,  1104,  1728,     0,  1731,     0,     0,     0,     0,  1726,
    1104,     0,     0,     0,     0,     0,  1104,     0,  1104,     0,
       0,     0,     0,  1731,  1104,     0,     0,  1104,  1104,  1104,
    1104,  1104,  1104,  1104,  1104,  1104,  1104,     0,     0,     0,
    1104,  1104,     0,     0,   661,     0,     0,     0,  1731,     0,
     661,     0,     0,  1104,     0,     0,     0,     0,     0,  1104,
    1554,     0,  1556,     0,     0,     0,  1558,     0,     0,  1104,
    1726,     0,  1104,     0,  1104,     0,     0,     0,     0,     0,
       0,     0,  1731,  1104,  1104,  1104,     0,     0,     0,  1104,
     661,     0,  1104,   661,   661,     0,     0,     0,     0,     0,
       0,     0,  1104,     0,     0,     0,     0,     0,     0,     0,
       0,  1104,     0,     0,     0,     0,     0,  1667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1679,     0,     0,     0,     0,     0,     0,     0,     0,  1685,
       0,     0,     0,   661,     0,  1687,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1735,     0,  1726,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1726,  1774,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1731,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1726,     0,
       0,     0,  1726,  1726,     0,     0,     0,     0,     0,     0,
    1727,  1727,     0,  1727,     0,     0,     0,     0,     0,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1850,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1727,     0,  1727,     0,  1881,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1728,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   675,     0,     0,     0,     0,     0,  1104,
       0,     0,     0,     0,  1728,     0,     0,     0,  2004,     0,
       0,     0,  1731,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1727,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1731,  1104,  1104,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1727,     0,     0,  1728,     0,     0,     0,  1104,     0,     0,
       0,     0,  1104,     0,     0,  1104,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1728,     0,
       0,     0,     0,     0,  1727,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1104,     0,     0,     0,  1727,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1727,     0,     0,     0,     0,  1024,     0,
       0,     0,     0,     0,     0,     0,     0,  1856,     0,     0,
    1104,     0,     0,     0,  2627,     0,     0,  1104,  1104,     0,
    1731,     0,     0,  2135,     0,  1104,  1104,     0,     0,  1727,
    1104,  1731,     0,     0,     0,     0,  1104,  1104,     0,  1728,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1727,     0,     0,     0,     0,  1731,     0,   661,     0,     0,
       0,  2177,     0,  1731,     0,     0,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1727,     0,     0,     0,   661,     0,
       0,     0,   661,     0,     0,     0,  2689,     0,  1536,     0,
       0,     0,     0,     0,   675,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
    1107,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1104,     0,     0,     0,     0,  1731,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,  1104,
       0,     0,     0,  1104,   661,     0,     0,     0,  1731,     0,
    2329,     0,   661,     0,   661,     0,     0,     0,     0,     0,
       0,     0,  2351,     0,     0,     0,     0,     0,     0,  1104,
       0,     0,     0,  1731,     0,     0,     0,     0,     0,     0,
    1727,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,  1107,  1104,  1104,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,  1104,  1104,     0,  2405,     0,     0,
       0,  2409,     0,     0,     0,     0,     0,     0,     0,     0,
    2418,     0,  2420,     0,  2421,     0,     0,     0,     0,  2422,
       0,     0,     0,     0,  1731,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2439,   867,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1104,  1104,     0,     0,     0,
       0,     0,  1731,     0,     0,     0,     0,  1107,     0,  1728,
       0,     0,     0,  1727,  1728,  1728,     0,     0,     0,     0,
       0,     0,     0,   675,  1856,     0,     0,     0,  1104,  1731,
       0,  1104,     0,  1104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1104,
       0,     0,  1731,     0,     0,     0,  1731,  1731,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2626,     0,     0,     0,  1104,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1104,     0,
       0,     0,     0,     0,     0,  1731,  1727,     0,     0,     0,
       0,  1728,     0,     0,     0,     0,     0,  1727,     0,     0,
       0,     0,     0,  1104,  1107,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1733,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,  1727,  1107,     0,     0,     0,     0,     0,     0,  1727,
       0,  1104,     0,  2135,     0,     0,     0,     0,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1070,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2705,     0,     0,     0,
       0,  2709,     0,     0,     0,  2713,     0,     0,     0,     0,
       0,  2717,  1107,     0,     0,     0,     0,  2722,     0,     0,
       0,     0,     0,  2732,     0,     0,     0,     0,  2734,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1728,     0,     0,     0,  1733,  1104,     0,     0,     0,
       0,  2750,  2751,  2754,  2755,     0,     0,     0,  2761,  2764,
       0,     0,     0,  2767,     0,     0,  2771,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2811,     0,  2813,     0,     0,  1107,     0,     0,     0,     0,
       0,  2824,  2825,  2826,     0,  2828,     0,     0,     0,     0,
       0,     0,  2841,  2842,  1727,     0,     0,     0,     0,     0,
    2845,  2846,     0,     0,     0,     0,  1107,  1107,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1727,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
    1727,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,     0,  1107,
    1107,     0,     0,     0,     0,     0,     0,     0,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   675,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1070,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,     0,   675,     0,     0,     0,     0,     0,     0,
    1733,     0,     0,  1728,  1728,     0,  1728,     0,     0,     0,
       0,     0,     0,  1728,     0,  1727,     0,     0,     0,     0,
       0,     0,     0,  3033,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1733,     0,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,  1728,     0,  1727,     0,
       0,     0,  1727,  1727,     0,     0,     0,  1733,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,  1728,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1733,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,  1733,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1728,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1728,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1728,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1728,     0,     0,     0,
       0,     0,     0,     0,  1107,     0,  1107,     0,     0,     0,
       0,     0,  1733,     0,     0,  1107,     0,     0,  2689,     0,
       0,     0,     0,  3214,  3215,     0,     0,     0,     0,     0,
       0,     0,  1728,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   661,     0,     0,     0,     0,  3242,  3243,
    3244,  3245,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1728,     0,     0,     0,     0,  1107,  1107,     0,
       0,     0,     0,     0,     0,  1107,     0,     0,  1107,     0,
       0,  1107,     0,     0,     0,     0,     0,  1728,     0,  1107,
    1107,     0,     0,     0,     0,     0,     0,  1107,     0,     0,
    1107,  1107,  1107,  1107,     0,     0,     0,     0,     0,     0,
    1107,  1107,     0,  1107,  3290,  1107,     0,     0,  1107,  3292,
       0,  1728,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1733,  1107,     0,     0,     0,  1107,     0,     0,
       0,  1107,     0,     0,     0,  1107,     0,     0,  1107,  1107,
    1107,  1107,  1107,  1107,  1107,  1107,  1107,     0,  1107,  1404,
       0,     0,     0,     0,  1107,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3380,   867,     0,     0,  1473,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   867,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3437,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3446,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2135,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   661,
       0,     0,     0,     0,     0,   661,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1728,  1733,     0,     0,     0,     0,  1733,  1733,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1728,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1905,  1728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,     0,
    3616,     0,     0,     0,     0,  3623,  1107,  3625,  3626,  3627,
    3628,     0,     0,     0,     0,     0,  1107,  1952,  1953,     0,
    1956,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,     0,  1994,     0,     0,
       0,     0,  1728,     0,     0,     0,     0,     0,     0,     0,
     661,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3679,
    3681,  3683,     0,  3685,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,     0,     0,     0,     0,     0,  2052,
       0,     0,     0,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,  1107,     0,  2081,     0,     0,     0,
    2091,  2094,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,  1107,     0,     0,     0,  1107,     0,
       0,     0,     0,     0,     0,  3754,     0,     0,     0,     0,
    1107,  1107,  1107,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,  1107,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1107,  1107,     0,
    1107,     0,     0,     0,     0,     0,     0,  1728,     0,     0,
       0,     0,     0,  1107,     0,  1107,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1728,     0,     0,  1107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1107,     0,  1107,  1107,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1107,     0,
       0,     0,     0,   661,     0,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,  1107,     0,     0,     0,     0,  1107,
       0,     0,     0,  1728,     0,     0,  1107,  1107,  1107,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3840,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3849,     0,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,  1733,     0,  1733,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,  1728,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,     0,     0,     0,     0,     0,     0,  1733,  1728,  1733,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3896,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1728,     0,     0,     0,  1728,  1728,  3912,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1990,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1733,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3946,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2499,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1733,     0,     0,     0,  2521,     0,
       0,  2523,     0,     0,  2534,     0,     0,     0,     0,  1733,
       0,  2541,  2546,     0,     0,     0,  2551,     0,     0,  2556,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
    1107,     0,     0,     0,  2565,     0,     0,     0,  2571,     0,
    1107,     0,  2583,     0,     0,  1733,  2590,     0,     0,  2592,
    2593,  2594,  2595,  2596,  2597,  2598,  2599,  2600,     0,  2601,
       0,     0,     0,     0,     0,  1404,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,     0,     0,  1733,     0,     0,     0,
       0,     0,  1107,     0,     0,     0,     0,     0,  1107,     0,
    1107,     0,     0,     0,     0,  1733,  1107,     0,     0,  1107,
    1107,  1107,  1107,  1107,  1107,  1107,  1107,  1107,  1107,     0,
    1473,     0,  1107,  1107,     0,     0,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,  1107,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,  1107,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,  1733,  1107,  1107,  1107,     0,     0,
       0,  1107,     0,     0,  1107,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1107,     0,     0,     0,     0,     0,
       0,     0,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2720,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,  4147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,     0,     0,     0,     0,  2530,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1990,  1990,     0,     0,
    1990,     0,     0,  2879,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,     0,     0,     0,  1733,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1733,
    1107,  1107,     0,     0,     0,     0,     0,  2984,     0,     0,
       0,     0,     0,     0,     0,     0,  1990,     0,     0,  1107,
       0,     0,     0,     0,  1107,     0,     0,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3005,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,  1990,     0,
       0,     0,     0,     0,     0,     0,  1107,     0,     0,     0,
       0,     0,     0,     0,  1404,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1107,     0,     0,  3044,     0,     0,     0,  1107,
    1107,     0,  1733,     0,     0,     0,     0,  1107,  1107,     0,
       0,     0,  1107,  1733,     0,     0,     0,     0,  1107,  1107,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2546,  1107,  2546,  2546,     0,     0,     0,     0,     0,
       0,     0,     0,  3104,     0,     0,  3107,     0,  3109,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1733,     0,     0,
       0,     0,     0,     0,  3130,  1733,  3132,     0,     0,     0,
    3135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3180,
       0,     0,     0,     0,     0,     0,     0,     0,  1473,     0,
       0,     0,     0,     0,     0,  2081,     0,     0,     0,     0,
    3194,     0,     0,     0,     0,     0,     0,  2094,  2094,  2091,
       0,     0,  1107,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3217,  1107,     0,     0,     0,     0,  1733,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,  1107,     0,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,     0,  1733,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1107,  1107,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,  1107,  1107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1733,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,     0,     0,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,  1990,     0,  2530,
    2530,  3080,     0,     0,  2530,     0,     0,     0,  1990,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,  1990,     0,  1107,  1107,     0,
    1990,     0,     0,     0,  1733,     0,     0,     0,     0,  1990,
       0,     0,     0,  2530,  2530,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1990,     0,     0,
    1107,  1733,     0,  1107,  1990,  1107,  1990,  1990,  1990,  1990,
    1990,  1990,  1990,  1990,  1990,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1107,     0,     0,  1733,     0,     0,     0,  1733,  1733,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1107,     0,     0,     0,     0,     0,     0,  1733,     0,     0,
       0,     0,     0,     0,  3469,     0,     0,     0,     0,     0,
       0,     0,     0,  3472,     0,  1107,     0,     0,     0,  3473,
       0,  3474,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,     0,     0,     0,
       0,     0,     0,  3492,  3493,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2551,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3518,     0,     0,  3521,     0,  3523,     0,     0,
       0,     0,     0,  1107,     0,     0,  3527,     0,     0,     0,
       0,     0,  3532,     0,     0,  3535,     0,     0,     4,     0,
       0,     0,     0,     0,     0,  3542,     0,     0,     0,     0,
       0,     0,     0,     0,  3005,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,    35,     0,     0,  1107,    37,
      38,    39,    40,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,  3726,  3727,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,  3080,
    3080,     0,  2530,     0,     0,  2530,  2530,  2530,  2530,  2530,
    2530,  2530,  2530,  2530,  2530,  3080,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,  1990,     0,  1990,     0,     0,     0,  3769,  3080,  3080,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2530,  2530,  1990,     0,  1990,     0,     0,  1990,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,     0,     0,     0,
    3785,  3787,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3794,     0,     0,     0,     0,     0,  3799,
    3800,     0,     0,  3802,  1990,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,     0,    51,  3816,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    52,     0,     0,     0,     0,
       0,  1990,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    54,     0,     0,     0,     0,     0,    55,
      56,    57,     0,     0,     0,    58,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1263,     0,     0,     0,     0,    71,  1264,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3884,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2530,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,  3936,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3967,     0,     0,     0,     0,     0,     0,     0,  3969,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,  1990,  1990,  1990,     0,
       0,  3080,     0,    42,     0,     0,  3080,  3080,  3080,  3080,
    3080,  3080,  3080,  3080,  3080,  3080,  1990,  1990,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,  2530,  2530,  1990,     0,  1990,     0,     0,
       0,  1990,  3080,  3080,     0,     0,  1990,     0,     0,  1990,
       0,     0,     0,     0,     0,     0,  1990,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,  4040,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2551,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4074,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3080,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,  1990,     0,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1990,     0,     0,     0,  2530,     0,    51,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,  1990,    52,     0,     0,     0,  3080,  3080,  1990,     0,
       0,  2530,  2530,  1990,  1990,    53,  1990,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      54,     0,     0,     0,     0,     0,    55,    56,    57,     0,
       0,     0,    58,     0,    59,     0,     0,     0,    60,    61,
      62,    63,    64,     0,     0,    65,    66,  1263,  1828,     0,
       0,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3080,  2530,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3080,
    3080,  1990,     0,  1990,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,  1990,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,  3080,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,  1990,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   688,   422,   423,   424,   689,   690,   691,   692,
     693,   694,   695,   425,   426,   696,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,   697,   431,   432,     0,
     433,   434,   698,   699,     0,   435,   700,   140,   437,   701,
     438,   439,   440,   441,   144,   702,   703,   442,   443,   444,
     445,   446,   447,   704,   448,   449,   450,   451,   452,   453,
     705,   454,   455,   456,   149,   457,     0,   706,   707,   708,
     150,   709,   710,   711,   458,   459,   460,   461,   462,   463,
     153,   154,   464,   712,   465,   713,   466,     0,   467,   468,
     469,   714,   470,   471,   472,   715,   716,   473,   474,   475,
     476,   477,   717,   478,   479,   480,   718,     0,   481,   719,
     482,   483,   484,   162,   485,   486,   164,   720,   487,   721,
     488,   166,     0,   722,   489,   723,   490,   167,   724,   168,
     491,   492,   725,   493,   170,   726,   494,   727,   495,   496,
     497,   498,   499,   171,   500,   501,   502,   728,   503,   504,
     505,   506,   507,   508,   729,   172,   173,   730,   509,   510,
     511,   731,   175,   732,   176,   733,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,   734,   180,
     181,   520,   182,   735,   521,   522,   523,   736,   737,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,   188,   189,   738,   537,   538,   539,   540,
     541,   542,   543,   190,   544,   739,   545,   546,   192,   547,
     740,   193,   548,   194,   549,   550,   741,   742,   551,   743,
     744,   745,   552,   553,     0,   746,   747,   195,   196,   197,
     198,   199,   554,   555,   556,   557,     0,   558,   748,   559,
     200,     0,   201,   560,   561,   562,   749,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,   750,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,   751,
     582,   583,   209,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,   752,   593,   594,     0,   595,   753,
     596,   215,   597,   598,   217,   599,   218,   754,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
     755,   611,   612,   756,   613,   614,   615,   616,   617,   757,
     222,   223,   758,   759,   619,   224,   620,   225,   760,   621,
     622,   623,     0,   624,   625,   761,   762,   626,   627,   628,
     629,   763,   764,   630,   631,   632,   633,     0,   233,   765,
     635,   234,   636,   637,   638,   766,   767,   639,   768,   769,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      85,     0,     0,    86,    87,    88,    89,    90,    91,    92,
      93,     0,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   106,   904,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,   119,   120,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
     130,   131,     0,     0,     0,     0,     0,     0,     0,     0,
     132,   133,     0,     0,   134,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,   141,     0,   142,   143,   144,     0,
       0,   145,   146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   147,     0,   148,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,   151,     0,   152,   153,   154,   155,     0,     0,     0,
       0,     0,   156,     0,     0,     0,     0,     0,   157,     0,
       0,     0,     0,     0,   158,     0,     0,     0,     0,     0,
     159,   160,     0,     0,     0,     0,   161,   162,   163,     0,
     164,     0,     0,   165,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,   174,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,   183,   184,
       0,     0,     0,     0,   185,     0,     0,     0,     0,     0,
       0,     0,     0,   186,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,   191,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,     0,   205,     0,   206,     0,     0,     0,     0,
     207,     0,     0,     0,     0,   208,   209,     0,   210,   211,
       0,     0,   212,     0,     0,     0,     0,     0,   213,     0,
       0,     0,     0,     0,   214,   215,     0,   216,   217,     0,
     218,     0,     0,     0,   219,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,   221,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,   226,     0,   227,     0,     0,     0,   228,
       0,     0,   229,     0,   230,     0,     0,   231,     0,     0,
       0,   232,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,   235,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
       0,     0,     0,    55,     0,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   244,   104,   105,     0,  -122,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,   154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   160,     0,     0,     0,     0,     0,   162,
       0,     0,   164,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   167,     0,   168,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   172,   173,     0,     0,     0,     0,     0,   175,     0,
     176,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,   180,   181,     0,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,   190,
       0,     0,     0,     0,   192,     0,     0,   193,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   195,   196,   197,   198,   199,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   209,     0,
       0,   211,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
     217,     0,   218,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,   223,     0,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,     0,     0,   234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   236,   237,   238,   239,   240,   241,   242,   243,     0,
       0,     0,     0,     0,     0,    55,     0,     0,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,  2679,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,   154,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   162,     0,     0,   164,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,   167,     0,   168,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,     0,     0,   171,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   172,   173,     0,     0,     0,
       0,     0,   175,     0,   176,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,   180,
     181,     0,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,     0,   192,     0,
       0,   193,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   195,   196,   197,
     198,   199,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   209,     0,     0,   211,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,   217,     0,   218,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,   223,     0,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,     0,
       0,   234,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   236,   237,   238,   239,   240,
     241,   242,   243,     4,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,  2681,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,     0,
      35,     0,     0,     0,    37,    38,    39,    40,    41,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,    42,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,    35,     0,     0,     0,    37,    38,    39,    40,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    42,     0,     0,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,     0,     0,    55,    56,    57,     0,     0,     0,
      58,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1263,  2431,     0,    51,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,     0,    55,    56,    57,     0,     0,
       0,    58,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,  1263,     0,     0,     0,
       0,    71,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,  2620,   422,   423,   424,
       0,     0,     0,     0,  1325,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1326,   137,  1327,  1328,
       0,   431,   432,     0,   433,   434,  1329,  1330,     0,   435,
    1331,  1332,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
       0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,  1341,  1342,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,  2621,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,  1344,   485,   486,
    1345,  1346,   487,     0,   488,  1347,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,  1349,  1350,     0,  1351,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1355,   188,  1356,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,  1357,
     545,   546,   192,   547,  1358,  1359,   548,  1360,   549,   550,
       0,     0,   551,  1003,     0,     0,  1361,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1364,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,  1365,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
    1367,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1369,  1370,     0,     0,   619,  1371,
     620,  1372,  1373,   621,   622,   623,     0,   624,   625,     0,
    1374,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,   634,  1376,  2622,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,    56,    57,  1384,  1385,  1386,    58,
    1387,     0,     0,     0,     0,  1388,  1389,  2623,     0,     0,
       0,     0,     0,     0,  1391,  2624,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1325,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1326,   137,  1327,  1328,     0,   431,   432,     0,   433,   434,
    1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,   439,
     440,   441,  1333,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,
    1339,  1340,   458,   459,   460,   461,   462,   463,  1341,  1342,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,  1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,  1348,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,  1349,
    1350,     0,  1351,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,  1352,   181,   520,
     182,     0,   521,   522,   523,  1353,  1354,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1355,   188,  1356,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,  1357,   545,   546,   192,   547,  1358,  1359,
     548,  1360,   549,   550,     0,     0,   551,  1003,     0,     0,
    1361,   553,     0,     0,     0,   195,   196,   197,   198,  1362,
     554,   555,   556,   557,     0,   558,     0,   559,  1363,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1364,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,  1365,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,  1366,   596,   215,
     597,   598,   217,   599,  1367,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,  1368,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1369,  1370,
       0,     0,   619,  1371,   620,  1372,  1373,   621,   622,   623,
       0,   624,   625,     0,  1374,   626,   627,   628,   629,  1375,
       0,   630,   631,   632,   633,   634,  1376,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,
    1383,   644,   645,   646,     0,     0,     0,    55,    56,    57,
    1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,
    1389,     0,     0,     0,     0,     0,     0,     0,  1391,  2532,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1699,   137,  1700,  1701,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,  1702,  1703,
     437,     0,   438,   439,   440,   441,     0,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,     0,
       0,     0,   150,     0,     0,     0,   458,   459,   460,   461,
     462,   463,  1704,  1705,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,     0,   485,   486,     0,     0,
     487,     0,   488,  1706,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,     0,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,  2191,
     503,   504,   505,   506,   507,   508,     0,   172,  2192,     0,
     509,   510,   511,  1349,  1707,     0,  1708,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,     0,   181,   520,   182,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1709,   188,  1710,     0,   537,   538,
     539,   540,   541,   542,   543,     0,   544,     0,   545,   546,
     192,   547,     0,     0,   548,  1711,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,  2193,
     196,   197,   198,     0,   554,   555,   556,   557,     0,   558,
       0,   559,     0,     0,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1712,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,  2194,   597,   598,   217,   599,  1714,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1715,  1716,     0,     0,   619,     0,   620,     0,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,     0,
    1717,  2195,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,     0,     0,     0,
       0,     0,     0,     0,     0,   644,   645,   646,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,  2196,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1699,   137,  1700,  1701,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,  1702,  1703,
     437,     0,   438,   439,   440,   441,     0,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,     0,
       0,     0,   150,     0,     0,     0,   458,   459,   460,   461,
     462,   463,  1704,  1705,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,     0,   485,   486,     0,     0,
     487,     0,   488,  1706,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,     0,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,  2191,
     503,   504,   505,   506,   507,   508,     0,   172,  2192,     0,
     509,   510,   511,  1349,  1707,     0,  1708,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,     0,   181,   520,   182,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1709,   188,  1710,     0,   537,   538,
     539,   540,   541,   542,   543,     0,   544,     0,   545,   546,
     192,   547,     0,     0,   548,  1711,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,  2193,
     196,   197,   198,     0,   554,   555,   556,   557,     0,   558,
       0,   559,     0,     0,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1712,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,  2194,   597,   598,   217,   599,  1714,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1715,  1716,     0,     0,   619,     0,   620,     0,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,     0,
    1717,  2195,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,     0,     0,     0,
       0,     0,     0,     0,     0,   644,   645,   646,     0,     0,
       0,    55,     0,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,  2945,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,  4043,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   681,    86,    87,    88,   400,    90,
      91,    92,   401, -1564,   402,    95,     0, -1564,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,  1325,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1326,   137,
    1327,  1328,  2542,   431,   432,     0,   433,   434,  1329,  1330,
       0,   435,  1331,  1332,   437,     0,   438,   439,   440,   441,
    1333,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,
     458,   459,   460,   461,   462,   463,  1341,  1342,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,  1344,
     485,   486,  1345,  1346,   487,     0,   488,  1347,     0,     0,
     489,     0,   490,   167,  2543,   168,   491,   492,     0,   493,
    1348,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,   173,     0,   509,   510,   511,  1349,  1350,     0,
    1351,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,  2544,  1352,   181,   520,   182,     0,
     521,   522,   523,  1353,  1354,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1355,   188,
    1356,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,  1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,
     549,   550,     0,     0,   551,  1003,     0,     0,  1361,   553,
       0,     0,     0,   195,   196,   197,   198,  1362,   554,   555,
     556,   557,     0,   558,     0,   559,  1363,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1364,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,  1365,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,  1366,   596,   215,   597,   598,
     217,   599,  1367,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,  1368,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1369,  1370,     0,  2545,
     619,  1371,   620,  1372,  1373,   621,   622,   623,     0,   624,
     625,     0,  1374,   626,   627,   628,   629,  1375,     0,   630,
     631,   632,   633,   634,  1376,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,
     645,   646,     0,     0,     0,    55,    56,    57,  1384,  1385,
    1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,     0,
       0,     0,     0,     0,     0,     0,  1391,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1325,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1326,   137,  1327,  1328,     0,   431,   432,     0,   433,
     434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,  1341,
    1342,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,  1344,   485,   486,  1345,  1346,   487,     0,   488,
    1347,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
    1349,  1350,     0,  1351,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1355,   188,  1356,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,  1357,   545,   546,   192,   547,  1358,
    1359,   548,  1360,   549,   550,     0,     0,   551,  1003,     0,
       0,  1361,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1364,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,  1365,   586,   587,   588,   589,   590,
     591,   592,     0,   213,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,  1367,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,   221,   613,   614,   615,   616,   617,     0,  1369,
    1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,   622,
     623,     0,   624,   625,     0,  1374,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,  1954,  1376,     0,   635,
     234,   636,   637,   638,     0,     0,   639,     0,   235,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,    56,
      57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,
    1388,  1389,     0,     0,     0,     0,     0,     0,     0,  1391,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1325,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1326,   137,  1327,  1328,     0,   431,
     432,     0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,
     437,     0,   438,   439,   440,   441,  1333,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,  1334,
    1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,
     462,   463,  1341,  1342,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,  1344,   485,   486,  1345,  1346,
     487,     0,   488,  1347,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,  1348,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,   173,     0,
     509,   510,   511,  1349,  1350,     0,  1351,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,  1352,   181,   520,   182,     0,   521,   522,   523,  1353,
    1354,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1355,   188,  1356,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,  1357,   545,   546,
     192,   547,  1358,  1359,   548,  1360,   549,   550,     0,     0,
     551,  1003,     0,     0,  1361,   553,     0,     0,     0,   195,
     196,   197,   198,  1362,   554,   555,   556,   557,     0,   558,
       0,   559,  1363,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1364,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,  1365,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,  1366,   596,   215,   597,   598,   217,   599,  1367,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
    1368,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,
    1373,   621,   622,   623,     0,   624,   625,     0,  1374,   626,
     627,   628,   629,  1375,     0,   630,   631,   632,   633,   634,
    1376,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,  1377,  1378,
    1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,
       0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,
       0,     0,     0,  1388,  1389,     0,     0,     0,     0,     0,
    1900,  2491,  1391,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1325,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1326,   137,  1327,
    1328,     0,   431,   432,     0,   433,   434,  1329,  1330,     0,
     435,  1331,  1332,   437,     0,   438,   439,   440,   441,  1333,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,
     459,   460,   461,   462,   463,  1341,  1342,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,  1343,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,  1344,   485,
     486,  1345,  1346,   487,     0,   488,  1347,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,  1348,
       0,   494,     0,   495,   496,   497,   498,   499,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,  1349,  1350,     0,  1351,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,  1352,   181,   520,   182,     0,   521,
     522,   523,  1353,  1354,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1355,   188,  1356,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
    1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,   549,
     550,     0,     0,   551,  1003,     0,     0,  1361,   553,     0,
       0,     0,   195,   196,   197,   198,  1362,   554,   555,   556,
     557,     0,   558,     0,   559,  1363,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,  1364,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
    1365,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,  1366,   596,   215,   597,   598,   217,
     599,  1367,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,  1368,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,  1369,  1370,     0,     0,   619,
    1371,   620,  1372,  1373,   621,   622,   623,     0,   624,   625,
       0,  1374,   626,   627,   628,   629,  1375,     0,   630,   631,
     632,   633,   634,  1376,     0,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,
     646,     0,     0,     0,    55,    56,    57,  1384,  1385,  1386,
      58,  1387,     0,     0,     0,     0,  1388,  1389,  1390,     0,
       0,     0,     0,     0,     0,  1391,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1325,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1326,   137,  1327,  1328,     0,   431,   432,     0,   433,   434,
    1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,   439,
     440,   441,  1333,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,
    1339,  1340,   458,   459,   460,   461,   462,   463,  1341,  1342,
     464,  1472,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,  1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,  1348,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,  1349,
    1350,     0,  1351,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,  1352,   181,   520,
     182,     0,   521,   522,   523,  1353,  1354,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1355,   188,  1356,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,  1357,   545,   546,   192,   547,  1358,  1359,
     548,  1360,   549,   550,     0,     0,   551,  1003,     0,     0,
    1361,   553,     0,     0,     0,   195,   196,   197,   198,  1362,
     554,   555,   556,   557,     0,   558,     0,   559,  1363,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1364,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,  1365,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,  1366,   596,   215,
     597,   598,   217,   599,  1367,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,  1368,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1369,  1370,
       0,     0,   619,  1371,   620,  1372,  1373,   621,   622,   623,
       0,   624,   625,     0,  1374,   626,   627,   628,   629,  1375,
       0,   630,   631,   632,   633,   634,  1376,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,
    1383,   644,   645,   646,     0,     0,     0,    55,    56,    57,
    1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,
    1389,     0,     0,     0,     0,     0,     0,     0,  1391,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,  2089,   422,   423,   424,     0,     0,     0,
       0,  1325,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1326,   137,  1327,  1328,     0,   431,   432,
       0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,
       0,   438,   439,   440,   441,  1333,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,
     463,  1341,  1342,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,  1344,   485,   486,  1345,  1346,   487,
       0,   488,  1347,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,  1348,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,   173,     0,   509,
     510,   511,  1349,  1350,     0,  1351,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
    1352,   181,   520,   182,     0,   521,   522,   523,  1353,  1354,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1355,   188,  1356,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,  1357,   545,   546,   192,
     547,  1358,  1359,   548,  1360,   549,   550,     0,     0,   551,
    1003,     0,     0,  1361,   553,     0,     0,     0,   195,   196,
     197,   198,  1362,   554,   555,   556,   557,     0,   558,     0,
     559,  1363,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1364,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,  1365,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
    1366,   596,   215,   597,   598,   217,   599,  1367,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,  1368,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,
     621,   622,   623,     0,   624,   625,     0,  1374,   626,   627,
     628,   629,  1375,     0,   630,   631,   632,   633,   634,  1376,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,  1377,  1378,  1379,
    1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,     0,
      55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,
       0,     0,  1388,  1389,     0,     0,     0,     0,     0,     0,
       0,  1391,   681,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   682,   104,   105,   403,   683,     0,   107,   108,
     109,   110,   684,   685,   112,   113,   114,   115,     0,   116,
     686,   687,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1325,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1326,   137,  1327,  1328,
       0,   431,   432,     0,   433,   434,  1329,  1330,     0,   435,
    1331,  1332,   437,     0,   438,   439,   440,   441,  1333,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,   149,   457,
    2983,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,
     460,   461,   462,   463,  1341,  1342,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,  1343,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,  1344,   485,   486,
    1345,  1346,   487,     0,   488,  1347,     0,     0,   489,     0,
     490,   167,     0,   168,   491,   492,     0,   493,  1348,     0,
     494,     0,   495,   496,   497,   498,   499,   171,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,   172,
     173,     0,   509,   510,   511,  1349,  1350,     0,  1351,     0,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,     0,  1352,   181,   520,   182,     0,   521,   522,
     523,  1353,  1354,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,  1355,   188,  1356,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,  1357,
     545,   546,   192,   547,  1358,  1359,   548,  1360,   549,   550,
       0,     0,   551,  1003,     0,     0,  1361,   553,     0,     0,
       0,   195,   196,   197,   198,  1362,   554,   555,   556,   557,
       0,   558,     0,   559,  1363,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,  1364,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,   209,   584,   585,  1365,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,  1366,   596,   215,   597,   598,   217,   599,
    1367,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,  1368,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,  1369,  1370,     0,     0,   619,  1371,
     620,  1372,  1373,   621,   622,   623,     0,   624,   625,     0,
    1374,   626,   627,   628,   629,  1375,     0,   630,   631,   632,
     633,   634,  1376,     0,   635,   234,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
    1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,
       0,     0,     0,    55,    56,    57,  1384,  1385,  1386,    58,
    1387,     0,     0,     0,     0,  1388,  1389,     0,     0,     0,
       0,     0,     0,     0,  1391,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,  1325,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1326,
     137,  1327,  1328,     0,   431,   432,     0,   433,   434,  1329,
    1330,     0,   435,  1331,  1332,   437,     0,   438,   439,   440,
     441,  1333,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,
    1340,   458,   459,   460,   461,   462,   463,  1341,  1342,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
    1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,     0,
       0,   489,     0,   490,   167,  2543,   168,   491,   492,     0,
     493,  1348,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,   173,     0,   509,   510,   511,  1349,  1350,
       0,  1351,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,  1352,   181,   520,   182,
       0,   521,   522,   523,  1353,  1354,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1355,
     188,  1356,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,  1357,   545,   546,   192,   547,  1358,  1359,   548,
    1360,   549,   550,     0,     0,   551,  1003,     0,     0,  1361,
     553,     0,     0,     0,   195,   196,   197,   198,  1362,   554,
     555,   556,   557,     0,   558,     0,   559,  1363,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1364,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,  1365,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,  1366,   596,   215,   597,
     598,   217,   599,  1367,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,  1368,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1369,  1370,     0,
       0,   619,  1371,   620,  1372,  1373,   621,   622,   623,     0,
     624,   625,     0,  1374,   626,   627,   628,   629,  1375,     0,
     630,   631,   632,   633,   634,  1376,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,
     644,   645,   646,     0,     0,     0,    55,    56,    57,  1384,
    1385,  1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,
       0,     0,     0,     0,     0,     0,     0,  1391,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1325,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1326,   137,  1327,  1328,     0,   431,   432,     0,
     433,   434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,
     438,   439,   440,   441,  1333,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,  1334,  1335,  1336,
    1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,   463,
    1341,  1342,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,  1343,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,  1344,   485,   486,  1345,  1346,   487,     0,
     488,  1347,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,  1348,     0,   494,     0,   495,   496,
     497,   498,   499,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,  1349,  1350,     0,  1351,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,  1352,
     181,   520,   182,     0,   521,   522,   523,  1353,  1354,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1355,   188,  1356,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,  1357,   545,   546,   192,   547,
    1358,  1359,   548,  1360,   549,   550,     0,     0,   551,  1003,
       0,     0,  1361,   553,     0,     0,     0,   195,   196,   197,
     198,  1362,   554,   555,   556,   557,     0,   558,     0,   559,
    1363,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,  1364,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,  1365,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,  1366,
     596,   215,   597,   598,   217,   599,  1367,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,  1368,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
    1369,  1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,
     622,   623,     0,   624,   625,     0,  1374,   626,   627,   628,
     629,  1375,     0,   630,   631,   632,   633,   634,  1376,  3554,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,
    1381,  1382,  1383,   644,   645,   646,     0,     0,     0,    55,
      56,    57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,
       0,  1388,  1389,     0,     0,     0,     0,     0,     0,     0,
    1391,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1325,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1326,   137,  1327,  1328,     0,
     431,   432,     0,   433,   434,  1329,  1330,     0,   435,  1331,
    1332,   437,     0,   438,   439,   440,   441,  1333,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
    1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,
     461,   462,   463,  1341,  1342,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,  1344,   485,   486,  1345,
    1346,   487,     0,   488,  1347,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,  1348,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,  1349,  1350,     0,  1351,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,  1352,   181,   520,   182,     0,   521,   522,   523,
    1353,  1354,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1355,   188,  1356,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,  1357,   545,
     546,   192,   547,  1358,  1359,   548,  1360,   549,   550,     0,
       0,   551,  1003,     0,     0,  1361,   553,     0,     0,     0,
     195,   196,   197,   198,  1362,   554,   555,   556,   557,     0,
     558,     0,   559,  1363,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1364,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,  1365,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,  1366,   596,   215,   597,   598,   217,   599,  1367,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,  1368,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1369,  1370,     0,     0,   619,  1371,   620,
    1372,  1373,   621,   622,   623,     0,   624,   625,     0,  1374,
     626,   627,   628,   629,  1375,     0,   630,   631,   632,   633,
     634,  1376,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,
       0,     0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,
       0,     0,     0,     0,  1388,  1389,     0,     0,     0,     0,
       0,     0,     0,  1391,   681,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   682,   104,   105,   403,   683,     0,
     107,   108,   109,   110,   684,   685,   112,   113,   114,   115,
       0,   116,   686,   687,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,  1325,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1326,   137,
    1327,  1328,     0,   431,   432,     0,   433,   434,  1329,  1330,
       0,   435,  1331,  1332,   437,     0,   438,   439,   440,   441,
    1333,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
     149,   457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,
     458,   459,   460,   461,   462,   463,  1341,  1342,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,  1343,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,  1344,
     485,   486,  1345,  1346,   487,     0,   488,  1347,     0,     0,
     489,     0,   490,   167,     0,   168,   491,   492,     0,   493,
    1348,     0,   494,     0,   495,   496,   497,   498,   499,   171,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,   172,   173,     0,   509,   510,   511,  1349,  1350,     0,
    1351,     0,     0,   177,   178,   512,   179,   513,   514,   515,
     516,   517,   518,   519,     0,  1352,   181,   520,   182,     0,
     521,   522,   523,  1353,  1354,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,  1355,   188,
    1356,  1002,   537,   538,   539,   540,   541,   542,   543,   190,
     544,  1357,   545,   546,   192,   547,  1358,  1359,   548,  1360,
     549,   550,     0,     0,   551,  1003,     0,     0,  1361,   553,
       0,     0,     0,   195,   196,   197,   198,  1362,   554,   555,
     556,   557,     0,   558,     0,   559,  1363,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
    1364,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,   209,   584,
     585,  1365,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,  1366,   596,   215,   597,   598,
     217,   599,  1367,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,  1368,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,  1369,  1370,     0,     0,
     619,  1371,   620,  1372,  1373,   621,   622,   623,     0,   624,
     625,     0,  1374,   626,   627,   628,   629,  1375,     0,   630,
     631,   632,   633,   634,  1376,     0,   635,   234,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,  3779,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,
     645,   646,     0,     0,     0,    55,    56,    57,  1384,  1385,
    1386,    58,  1387,     0,     0,     0,     0,  1388,  1389,     0,
       0,     0,     0,     0,     0,     0,  1391,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1325,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1326,   137,  1327,  1328,     0,   431,   432,     0,   433,
     434,  1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,  1341,
    1342,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,  1344,   485,   486,  1345,  1346,   487,     0,   488,
    1347,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
    1349,  1350,     0,  1351,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1355,   188,  1356,  1002,   537,  3786,   539,   540,   541,
     542,   543,   190,   544,  1357,   545,   546,   192,   547,  1358,
    1359,   548,  1360,   549,   550,     0,     0,   551,  1003,     0,
       0,  1361,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1364,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,  1365,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,  1367,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1369,
    1370,     0,     0,   619,  1371,   620,  1372,  1373,   621,   622,
     623,     0,   624,   625,     0,  1374,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,   634,  1376,     0,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,    56,
      57,  1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,
    1388,  1389,     0,     0,     0,     0,     0,     0,     0,  1391,
     681,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     682,   104,   105,   403,   683,     0,   107,   108,   109,   110,
     684,   685,   112,   113,   114,   115,     0,   116,   686,   687,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1325,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1326,   137,  1327,  1328,     0,   431,
     432,     0,   433,   434,  1329,  1330,     0,   435,  1331,  1332,
     437,     0,   438,   439,   440,   441,  1333,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,   149,   457,     0,  1334,
    1335,  1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,
     462,   463,  1341,  1342,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,  1343,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,  1344,   485,   486,  1345,  1346,
     487,     0,   488,  1347,     0,     0,   489,     0,   490,   167,
       0,   168,   491,   492,     0,   493,  1348,     0,   494,     0,
     495,   496,   497,   498,   499,   171,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,   172,   173,     0,
     509,   510,   511,  1349,  1350,     0,  1351,     0,     0,   177,
     178,   512,   179,   513,   514,   515,   516,   517,   518,   519,
       0,  1352,   181,   520,   182,     0,   521,   522,   523,  1353,
    1354,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,  1355,   188,  1356,  1002,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
     192,   547,  1358,  1359,   548,  1360,   549,   550,     0,     0,
     551,  1003,     0,     0,  1361,   553,     0,     0,     0,   195,
     196,   197,   198,  1362,   554,   555,   556,   557,     0,   558,
       0,   559,  1363,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,  1364,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,   209,   584,   585,  1365,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,  1366,   596,   215,   597,   598,   217,   599,  1367,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
    1368,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,  1369,  1370,     0,     0,   619,  1371,   620,  1372,
    1373,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,  1375,     0,   630,   631,   632,   633,   634,
    1376,     0,   635,   234,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,  1377,  1378,
    1379,  1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,
       0,    55,    56,    57,  1384,  1385,  1386,    58,  1387,     0,
       0,     0,     0,  2525,  2526,     0,     0,     0,     0,     0,
       0,     0,  1391,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1325,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,     0,  1326,   137,  1327,
    1328,     0,   431,   432,     0,   433,   434,  1329,  1330,     0,
     435,  1331,  1332,   437,     0,   438,   439,   440,   441,  1333,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,  1334,  1335,  1336,  1337,  1338,  1339,  1340,   458,
     459,   460,   461,   462,   463,  1341,  1342,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,  1343,   476,   477,     0,   478,   479,
     480,     0,     0,     0,     0,   482,   483,   484,  1344,   485,
     486,  1345,  1346,   487,     0,   488,  1347,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,  1348,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,  1349,  1350,     0,  1351,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,  1352,   181,   520,     0,     0,   521,
     522,   523,  1353,  1354,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1355,   188,  1356,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,   192,   547,  1358,  1359,   548,  1360,   549,
     550,     0,     0,   551,  1003,     0,     0,  1361,   553,     0,
       0,     0,   195,   196,   197,   198,  1362,   554,   555,   556,
     557,     0,   558,     0,   559,  1363,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,  1364,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
    1365,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,  1366,   596,   215,   597,   598,     0,
     599,  1367,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,  1368,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,  1369,  1370,     0,     0,   619,
    1371,   620,  1372,  1373,   621,   622,   623,     0,   624,   625,
       0,  1374,   626,   627,   628,   629,  1375,     0,   630,   631,
     632,   633,   634,  1376,     0,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,  1377,  1378,  1379,  1380,  1381,  1382,  1383,   644,   645,
     646,     0,     0,     0,    55,    56,    57,  1384,  1385,  1386,
      58,  1387,     0,     0,     0,     0,  1388,  1389,     0,     0,
       0,     0,     0,     0,     0,  1391,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1325,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,     0,
    1326,   137,  1327,  1328,     0,   431,   432,     0,   433,   434,
    1329,  1330,     0,   435,  1331,  1332,   437,     0,   438,   439,
     440,   441,  1333,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,  1338,
    1339,  1340,   458,   459,   460,   461,   462,   463,  1341,  1342,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,  1343,   476,   477,
       0,   478,   479,   480,     0,     0,     0,     0,   482,   483,
     484,  1344,   485,   486,  1345,  1346,   487,     0,   488,  1347,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,  1348,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,  1349,
    1350,     0,  1351,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,  1352,   181,   520,
       0,     0,   521,   522,   523,  1353,  1354,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
    1355,   188,  1356,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,   192,   547,  1358,  1359,
     548,  1360,   549,   550,     0,     0,   551,  1003,     0,     0,
    1361,   553,     0,     0,     0,   195,   196,   197,   198,  1362,
     554,   555,   556,   557,     0,   558,     0,   559,  1363,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,  1364,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,  1365,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,  1366,   596,   215,
     597,   598,     0,   599,  1367,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,  1368,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,  1369,  1370,
       0,     0,   619,  1371,   620,  1372,  1373,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,  1375,
       0,   630,   631,   632,   633,   634,  1376,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,  1382,
    1383,   644,   645,   646,     0,     0,     0,    55,    56,    57,
    1384,  1385,  1386,    58,  1387,     0,     0,     0,     0,  2525,
    2526,     0,     0,     0,     0,     0,     0,     0,  1391,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
       0,   433,   434,     0,  1330,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,  1333,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,  1334,  1335,
    1336,  1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,  1345,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,  1348,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
    1352,   181,   520,   182,     0,   521,   522,   523,  1353,  1354,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,   188,   189,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,   192,
     547,     0,  1359,   548,   194,   549,   550,     0,     0,   551,
    1003,     0,  1004,   552,   553,     0,     0,     0,   195,   196,
     197,   198,  1362,   554,   555,   556,   557,     0,   558,     0,
     559,  1363,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,   213,   593,   594,     0,   595,
    1366,   596,   215,   597,   598,   217,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,  1368,
     610,     0,   611,   612,   221,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,  1371,   620,  1372,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,  1375,     0,   630,   631,   632,   633,  1954,   233,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
     235,   640,   641,     0,   642,   643,   236,  1377,  1378,  1379,
    1380,  1381,  1382,  1383,   644,   645,   646,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,  2388,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,     0,
     433,   434,     0,  1330,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,  1333,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,   149,   457,     0,  1334,  1335,  1336,
    1337,  1338,  1339,  1340,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,  1345,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,   167,     0,   168,
     491,   492,     0,   493,  1348,     0,   494,     0,   495,   496,
     497,   498,   499,   171,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,   172,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,     0,  1352,
     181,   520,   182,     0,   521,   522,   523,  1353,  1354,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,   188,   189,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,   192,   547,
       0,  1359,   548,   194,   549,   550,     0,     0,   551,  1003,
       0,  1004,   552,   553,     0,     0,     0,   195,   196,   197,
     198,  1362,   554,   555,   556,   557,     0,   558,     0,   559,
    1363,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,   209,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,  1366,
     596,   215,   597,   598,   217,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,  1368,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,  1371,   620,  1372,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,  1375,     0,   630,   631,   632,   633,   634,   233,     0,
     635,   234,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,
    1381,  1382,  1383,   644,   645,   646,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
    2388,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,     0,   433,
     434,     0,  1330,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,  1333,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,  1334,  1335,  1336,  1337,
    1338,  1339,  1340,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,  1345,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,  1348,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,  1352,   181,
     520,   182,     0,   521,   522,   523,  1353,  1354,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,   188,   189,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,   192,   547,     0,
    1359,   548,   194,   549,   550,     0,     0,   551,  1003,     0,
       0,   552,   553,     0,     0,     0,   195,   196,   197,   198,
    1362,   554,   555,   556,   557,     0,   558,     0,   559,  1363,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,  1366,   596,
     215,   597,   598,   217,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,  1368,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,  1371,   620,  1372,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
    1375,     0,   630,   631,   632,   633,   634,   233,     0,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,  1377,  1378,  1379,  1380,  1381,
    1382,  1383,   644,   645,   646,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,   681,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,  3920,
      98,    99,   100,   101,   102,   103,   682,   104,   105,   403,
     683,     0,   107,   108,   109,   110,   684,   685,   112,   113,
     114,   115,     0,   116,   686,   687,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,   149,   457,     0,     0,     0,     0,   150,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,   167,     0,   168,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,   171,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,   172,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,   177,   178,   512,   179,   513,
     514,   515,   516,   517,   518,   519,     0,   180,   181,   520,
     182,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,   188,   189,  1002,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,   192,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,  1003,     0,     0,
     552,   553,     0,     0,     0,   195,   196,   197,   198,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
     209,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,   217,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,   234,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,  3986,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,  2965,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456, -1169,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0, -1169,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0, -1169,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
   -1169,   513,   514,   515,   516,   517,   518,   519,     0,   180,
   -1169,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187, -1169,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583, -1169,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,     0,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,  1480,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    57,     0,     0,     0,    58,     0,
       0,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,  3334,  3335,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,    57,     0,     0,     0,    58,     0,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,  3335,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,   213,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,   221,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,  1954,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
     235,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,     0,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   244,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,   213,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,   221,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
    1954,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,   235,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   244,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,  1003,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,  1458,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,  2062,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,  3430,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,   681,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,  3549,    98,    99,   100,   101,   102,   103,   682,   104,
     105,   403,   683,     0,   107,   108,   109,   110,   684,   685,
     112,   113,   114,   115,     0,   116,   686,   687,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   688,   422,   423,   424,   689,   690,   691,   692,
     693,   694,   695,   425,   426,   696,   427,   133,   428,   429,
     430,   135,  1699,   137,  1700,  1701,   697,   431,   432,     0,
     433,   434,   698,   699,     0,   435,  1702,  1703,   437,   701,
     438,   439,   440,   441,     0,   702,   703,   442,   443,   444,
     445,   446,   447,   704,   448,   449,   450,   451,   452,   453,
     705,   454,   455,   456,   149,   457,     0,   706,   707,   708,
     150,   709,   710,   711,   458,   459,   460,   461,   462,   463,
    1704,  1705,   464,   712,   465,   713,   466,     0,   467,   468,
     469,   714,   470,   471,   472,   715,   716,   473,   474,  1343,
     476,   477,   717,   478,   479,   480,   718,     0,   481,   719,
     482,   483,   484,     0,   485,   486,     0,   720,   487,   721,
     488,  1706,     0,   722,   489,   723,   490,   167,   724,   168,
     491,   492,   725,   493,     0,   726,   494,   727,   495,   496,
     497,   498,   499,   171,   500,   501,   502,   728,   503,   504,
     505,   506,   507,   508,   729,   172,     0,     0,   509,   510,
     511,  1349,  1707,   732,  1708,   733,     0,   177,   178,   512,
     179,   513,   514,   515,   516,   517,   518,   519,   734,     0,
     181,   520,   182,   735,   521,   522,   523,   736,   737,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,  1709,   188,  1710,   738,   537,   538,   539,   540,
     541,   542,   543,     0,   544,   739,   545,   546,   192,   547,
     740,     0,   548,  1711,   549,   550,   741,   742,   551,   743,
     744,   745,  3321,   553,     0,   746,   747,     0,   196,   197,
     198,     0,   554,   555,   556,   557,     0,   558,   748,   559,
       0,     0,     0,   560,   561,   562,   749,   563,   564,   565,
     566,   567,     0,   568,  1712,   569,   570,   571,   750,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,   751,
     582,   583,   209,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,     0,   752,   593,   594,     0,   595,   753,
     596,  2194,   597,   598,   217,   599,  1714,   754,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     755,   611,   612,   756,   613,   614,   615,   616,   617,   757,
    1715,  1716,     0,   759,   619,     0,   620,     0,   760,   621,
     622,   623,     0,   624,   625,     0,   762,   626,   627,   628,
     629,   763,   764,   630,   631,   632,   633,     0,  1717,   765,
     635,   234,   636,   637,   638,   766,   767,   639,   768,   769,
     640,   641,     0,   642,   643,     0,     0,     0,     0,     0,
       0,     0,     0,   644,   645,   646,     0,     0,     0,    55,
      56,    57,     0,     0,  1120,    58,     0,  1121,  1122,  1123,
       0,  3322,  3323,  1126,  1127,  1128,  1129,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,  1118,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,  1119,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,     0,
       0,     0,  1120,     0,     0,  1121,  1122,  1123,     0,  1124,
    1125,  1126,  1127,  1128,  1129,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,  1194,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,  1195,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,     0,     0,     0,     0,
    1120,     0,     0,  1121,  1122,  1123,     0,  1124,  1125,  1126,
    1127,  1128,  1129,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,  1240,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,  1241,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,  1242,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,     0,     0,     0,     0,  1120,     0,
       0,  1121,  1122,  1123,     0,  1124,  1125,  1126,  1127,  1128,
    1129,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,  1682,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
    1683,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,     0,     0,     0,  1120,     0,     0,  1121,
    1122,  1123,     0,  1124,  1125,  1126,  1127,  1128,  1129,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
       0,     0,     0,     0,  1120,     0,     0,  1121,  1122,  1123,
       0,  1124,  1125,  1126,  1127,  1128,  1129,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   688,   422,   423,   424,   689,   690,   691,   692,   693,
     694,   695,   425,   426,   696,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,   697,   431,   432,     0,   433,
     434,   698,   699,     0,   435,   700,   140,   437,   701,   438,
     439,   440,   441,   144,   702,   703,   442,   443,   444,   445,
     446,   447,   704,   448,   449,   450,   451,   452,   453,   705,
     454,   455,   456,   149,   457,     0,   706,   707,   708,   150,
     709,   710,   711,   458,   459,   460,   461,   462,   463,   153,
     154,   464,   712,   465,   713,   466,     0,   467,   468,   469,
     714,   470,   471,   472,   715,   716,   473,   474,   475,   476,
     477,   717,   478,   479,   480,   718,     0,   481,   719,   482,
     483,   484,   162,   485,   486,   164,   720,   487,   721,   488,
     166,     0,   722,   489,   723,   490,   167,   724,   168,   491,
     492,   725,   493,   170,   726,   494,   727,   495,   496,   497,
     498,   499,   171,   500,   501,   502,   728,   503,   504,   505,
     506,   507,   508,   729,   172,   173,   730,   509,   510,   511,
     731,   175,   732,   176,   733,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,   734,   180,   181,
     520,   182,   735,   521,   522,   523,   736,   737,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,   188,   189,   738,   537,   538,   539,   540,   541,
     542,   543,   190,   544,   739,   545,   546,   192,   547,   740,
     193,   548,   194,   549,   550,   741,   742,   551,   743,   744,
     745,   552,   553,     0,   746,   747,   195,   196,   197,   198,
     199,   554,   555,   556,   557,     0,   558,   748,   559,   200,
       0,   201,   560,   561,   562,   749,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,   750,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   751,   582,
     583,   209,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,   752,   593,   594,     0,   595,   753,   596,
     215,   597,   598,   217,   599,   218,   754,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,   755,
     611,   612,   756,   613,   614,   615,   616,   617,   757,   222,
     223,   758,   759,   619,   224,   620,   225,   760,   621,   622,
     623,     0,   624,   625,   761,   762,   626,   627,   628,   629,
     763,   764,   630,   631,   632,   633,     0,   233,   765,   635,
     234,   636,   637,   638,   766,   767,   639,   768,   769,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,  2053,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1699,   137,  1700,  1701,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,  1702,  1703,   437,
       0,   438,   439,   440,   441,     0,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,     0,     0,
       0,   150,     0,     0,     0,   458,   459,   460,   461,   462,
     463,  1704,  1705,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,     0,   485,   486,     0,     0,   487,
       0,   488,  1706,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,     0,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,     0,     0,   509,
     510,   511,  1349,  1707,     0,  1708,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
       0,   181,   520,   182,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1709,   188,  1710,     0,   537,   538,   539,
     540,   541,   542,   543,     0,   544,     0,   545,   546,   192,
     547,     0,     0,   548,  1711,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,     0,   196,
     197,   198,     0,   554,   555,   556,   557,     0,   558,     0,
     559,     0,     0,     0,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1712,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,  1713,   597,   598,   217,   599,  1714,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,     0,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1715,  1716,     0,     0,   619,     0,   620,     0,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,     0,  1717,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,     0,     0,     0,     0,
       0,     0,     0,     0,   644,   645,   646,     0,     0,     0,
      55,     0,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,  2149,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  1013,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,  2036,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,  2037,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,  2038,     0,   551,     0,  2039,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,  2040,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    56,    57,     0,     0,     0,
      58,     0,     0,     0,     0,     0,   922,  1517,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,  2046,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,  2037,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,  2038,     0,   551,     0,  2039,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,  2040,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    56,
      57,     0,     0,     0,    58,     0,     0,     0,     0,     0,
     922,  1517,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
    2037,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,  2038,
       0,   551,     0,  2039,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,  2040,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    56,    57,     0,     0,     0,    58,     0,
       0,     0,     0,     0,   922,  1517,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   911,   416,   417,   418,   419,   420,   421,   912,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   913,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   914,   166,     0,
       0,   489,     0,   915,     0,   916,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,   917,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   918,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   919,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   920,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   921,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,   922,   923,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   911,   416,   417,   418,
     419,   420,   421,   912,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   913,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   914,   166,     0,     0,   489,     0,   915,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   918,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   919,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   920,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   921,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,   922,   923,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,   669,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,  1428,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,  1429,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
    1387,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    56,    57,  1384,  4181,     0,    58,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,   618,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,     0,
      57,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,  1073,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,     0,    57,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,     0,    57,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,  2022,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,     0,    57,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,     0,    57,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,  1823,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,   981,    57,    86,    87,    88,   400,
      90,    91,    92,   401,   982,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,   983,   435,   958,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   984,
       0,   985,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   986,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   987,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     988,   585,   211,   586,   587,   588,   989,   590,   591,   592,
       0,     0,   593,   594,     0,   990,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   991,   223,     0,
       0,   992,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   962,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   993,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   688,   422,   423,   424,   689,   690,   691,   692,   693,
     694,   695,   425,   426,   696,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,   697,   431,   432,     0,   433,
     434,   698,   699,     0,   435,   700,   140,   437,   701,   438,
     439,   440,   441,   144,   702,   703,   442,   443,   444,   445,
     446,   447,   704,   448,   449,   450,   451,   452,   453,   705,
     454,   455,   456,   149,   457,     0,   706,   707,   708,   150,
     709,   710,   711,   458,   459,   460,   461,   462,   463,   153,
     154,   464,   712,   465,   713,   466,     0,   467,   468,   469,
     714,   470,   471,   472,   715,   716,   473,   474,   475,   476,
     477,   717,   478,   479,   480,   718,     0,   481,   719,   482,
     483,   484,   162,   485,   486,   164,   720,   487,   721,   488,
     166,     0,   722,   489,   723,   490,   167,   724,   168,   491,
     492,   725,   493,   170,   726,   494,   727,   495,   496,   497,
     498,   499,   171,   500,   501,   502,   728,   503,   504,   505,
     506,   507,   508,   729,   172,   173,   730,   509,   510,   511,
     731,   175,   732,   176,   733,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,   734,   180,   181,
     520,   182,   735,   521,   522,   523,   736,   737,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,   188,   189,   738,   537,   538,   539,   540,   541,
     542,   543,   190,   544,   739,   545,   546,   192,   547,   740,
     193,   548,   194,   549,   550,   741,   742,   551,   743,   744,
     745,   552,   553,     0,   746,   747,   195,   196,   197,   198,
     199,   554,   555,   556,   557,     0,   558,   748,   559,   200,
       0,   201,   560,   561,   562,   749,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,   750,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,   751,   582,
     583,   209,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,   752,   593,   594,     0,   595,   753,   596,
     215,   597,   598,   217,   599,   218,   754,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,   755,
     611,   612,   756,   613,   614,   615,   616,   617,   757,   222,
     223,   758,   759,   619,   224,   620,   225,   760,   621,   622,
     623,     0,   624,   625,   761,   762,   626,   627,   628,   629,
     763,   764,   630,   631,   632,   633,     0,   233,   765,   635,
     234,   636,   637,   638,   766,   767,   639,   768,   769,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,  2815,
     419,   420,   421,   688,   422,   423,   424,   689,   690,   691,
     692,   693,   694,   695,   425,   426,   696,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,   697,   431,   432,
       0,   433,   434,   698,   699,     0,   435,   700,   140,   437,
     701,   438,   439,   440,   441,   144,   702,   703,   442,   443,
     444,   445,   446,   447,   704,   448,   449,   450,   451,   452,
     453,   705,   454,   455,   456,   149,   457,     0,   706,   707,
     708,   150,   709,   710,   711,   458,   459,   460,   461,   462,
     463,   153,   154,   464,   712,   465,   713,   466,     0,   467,
     468,   469,   714,   470,   471,   472,   715,   716,   473,   474,
     475,  2816,   477,   717,   478,   479,   480,   718,     0,   481,
     719,   482,   483,   484,   162,   485,   486,   164,   720,   487,
     721,   488,   166,     0,   722,   489,   723,   490,   167,   724,
     168,   491,   492,   725,   493,   170,   726,   494,   727,   495,
     496,   497,   498,   499,   171,   500,   501,   502,   728,   503,
     504,   505,   506,   507,   508,   729,   172,   173,   730,   509,
     510,   511,   731,   175,   732,   176,   733,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,   734,
     180,   181,   520,   182,   735,   521,   522,   523,   736,   737,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,   188,   189,   738,   537,   538,   539,
     540,   541,   542,   543,   190,   544,   739,   545,   546,   192,
     547,   740,   193,   548,   194,   549,   550,   741,   742,   551,
     743,   744,   745,   552,   553,     0,   746,   747,   195,   196,
     197,   198,   199,   554,   555,   556,   557,     0,   558,   748,
     559,   200,     0,   201,   560,   561,   562,   749,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,   750,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
     751,   582,   583,   209,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,   752,   593,   594,     0,   595,
     753,  2817,   215,   597,   598,   217,   599,   218,   754,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,   755,   611,   612,   756,   613,   614,   615,   616,   617,
     757,   222,   223,   758,   759,   619,   224,   620,   225,   760,
     621,   622,   623,     0,   624,   625,   761,   762,   626,   627,
     628,   629,   763,   764,   630,   631,   632,   633,     0,   233,
     765,   635,   234,   636,   637,   638,   766,   767,   639,   768,
     769,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
       0,     0,     0,   150,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,   180,   181,   520,   182,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,   188,   189,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,   192,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,  1003,     0,     0,   552,   553,     0,     0,     0,
     195,   196,   197,   198,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,   217,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,     0,     0,     0,   150,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,  1227,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,   180,   181,   520,   182,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,   188,   189,
    1002,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,   192,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,  1003,     0,     0,   552,   553,     0,
       0,     0,   195,   196,   197,   198,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,   217,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,     0,     0,     0,   150,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,  1235,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,   180,   181,   520,   182,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
     188,   189,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,   192,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,  1003,     0,     0,   552,
     553,     0,     0,     0,   195,   196,   197,   198,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,   217,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1699,   137,  1700,  1701,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,  1702,  1703,   437,     0,   438,
     439,   440,   441,     0,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,     0,     0,     0,   150,
       0,     0,     0,   458,   459,   460,   461,   462,   463,  1704,
    1705,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,     0,   485,   486,     0,     0,   487,     0,   488,
    1706,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,     0,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,  2191,   503,   504,   505,
     506,   507,   508,     0,   172,  2192,     0,   509,   510,   511,
    1349,  1707,     0,  1708,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,     0,   181,
     520,   182,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1709,   188,  1710,     0,   537,   538,   539,   540,   541,
     542,   543,     0,   544,     0,   545,   546,   192,   547,     0,
       0,   548,  1711,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,  2193,   196,   197,   198,
       0,   554,   555,   556,   557,     0,   558,     0,   559,     0,
       0,     0,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1712,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
    2194,   597,   598,   217,   599,  1714,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1715,
    1716,     0,     0,   619,     0,   620,     0,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,     0,  1717,  2195,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,     0,     0,     0,     0,     0,     0,
       0,     0,   644,   645,   646,     0,     0,     0,    55,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1699,   137,  1700,  1701,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,  1702,  1703,   437,
       0,   438,   439,   440,   441,     0,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,     0,     0,
       0,   150,     0,     0,     0,   458,   459,   460,   461,   462,
     463,  1704,  1705,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,     0,   485,   486,     0,     0,   487,
       0,   488,  1706,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,     0,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,     0,     0,   509,
     510,   511,  1349,  1707,     0,  1708,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
       0,   181,   520,   182,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1709,   188,  1710,     0,   537,   538,   539,
     540,   541,   542,   543,     0,   544,     0,   545,   546,   192,
     547,  2183,     0,   548,  1711,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,     0,   196,
     197,   198,     0,   554,   555,   556,   557,     0,   558,     0,
     559,     0,     0,     0,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1712,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,  2194,   597,   598,   217,   599,  1714,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,     0,
     610,     0,   611,   612,  3407,   613,   614,   615,   616,   617,
       0,  1715,  1716,     0,     0,   619,     0,   620,     0,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,     0,  1717,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,     0,     0,     0,     0,
       0,     0,     0,     0,   644,   645,   646,     0,     0,     0,
      55,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1699,   137,  1700,  1701,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,  1702,
    1703,   437,     0,   438,   439,   440,   441,     0,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
       0,     0,     0,   150,     0,     0,     0,   458,   459,   460,
     461,   462,   463,  1704,  1705,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,  1343,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,     0,   485,   486,     0,
       0,   487,     0,   488,  1706,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,     0,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,     0,
       0,   509,   510,   511,  1349,  1707,     0,  1708,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,     0,   181,   520,   182,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,  1709,   188,  1710,     0,   537,
     538,   539,   540,   541,   542,   543,  2232,   544,     0,   545,
     546,   192,   547,     0,     0,   548,  1711,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
       0,   196,   197,   198,     0,   554,   555,   556,   557,     0,
     558,     0,   559,     0,     0,     0,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,  1712,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,  1713,   597,   598,   217,   599,  1714,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,     0,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,  1715,  1716,     0,     0,   619,     0,   620,
       0,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
       0,  1717,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,     0,     0,
       0,     0,     0,     0,     0,     0,   644,   645,   646,     0,
       0,     0,    55,   681,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   682,   104,   105,   403,   683,     0,   107,
     108,   109,   110,   684,   685,   112,   113,   114,   115,     0,
     116,   686,   687,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1699,   137,  1700,
    1701,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,  1702,  1703,   437,     0,   438,   439,   440,   441,     0,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,   149,
     457,     0,     0,     0,     0,   150,     0,     0,     0,   458,
     459,   460,   461,   462,   463,  1704,  1705,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,  1343,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,     0,   485,
     486,     0,     0,   487,     0,   488,  1706,     0,     0,   489,
       0,   490,   167,     0,   168,   491,   492,     0,   493,     0,
       0,   494,     0,   495,   496,   497,   498,   499,   171,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
     172,     0,     0,   509,   510,   511,  1349,  1707,     0,  1708,
       0,     0,   177,   178,   512,   179,   513,   514,   515,   516,
     517,   518,   519,     0,     0,   181,   520,   182,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,  1709,   188,  1710,
       0,   537,   538,   539,   540,   541,   542,   543,  3257,   544,
       0,   545,   546,   192,   547,     0,     0,   548,  1711,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,     0,   196,   197,   198,     0,   554,   555,   556,
     557,     0,   558,     0,   559,     0,     0,     0,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,  1712,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,   209,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,  1713,   597,   598,   217,
     599,  1714,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,     0,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,  1715,  1716,     0,     0,   619,
       0,   620,     0,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,     0,  1717,     0,   635,   234,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
       0,     0,     0,     0,     0,     0,     0,     0,   644,   645,
     646,     0,     0,     0,    55,   681,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   682,   104,   105,   403,   683,
       0,   107,   108,   109,   110,   684,   685,   112,   113,   114,
     115,     0,   116,   686,   687,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1699,
     137,  1700,  1701,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,  1702,  1703,   437,     0,   438,   439,   440,
     441,     0,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,   149,   457,     0,     0,     0,     0,   150,     0,     0,
       0,   458,   459,   460,   461,   462,   463,  1704,  1705,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,  1343,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
       0,   485,   486,     0,     0,   487,     0,   488,  1706,     0,
       0,   489,     0,   490,   167,     0,   168,   491,   492,     0,
     493,     0,     0,   494,     0,   495,   496,   497,   498,   499,
     171,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,   172,     0,     0,   509,   510,   511,  1349,  1707,
       0,  1708,     0,     0,   177,   178,   512,   179,   513,   514,
     515,   516,   517,   518,   519,     0,     0,   181,   520,   182,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,  1709,
     188,  1710,     0,   537,   538,   539,   540,   541,   542,   543,
       0,   544,     0,   545,   546,   192,   547,     0,     0,   548,
    1711,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,     0,   196,   197,   198,     0,   554,
     555,   556,   557,     0,   558,     0,   559,     0,     0,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,  1712,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,   209,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,  1713,   597,
     598,   217,   599,  1714,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,  1715,  1716,     0,
       0,   619,     0,   620,     0,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,     0,  1717,     0,   635,   234,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,     0,     0,     0,     0,     0,     0,     0,     0,
     644,   645,   646,     0,     0,     0,    55,   681,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   682,   104,   105,
     403,   683,     0,   107,   108,   109,   110,   684,   685,   112,
     113,   114,   115,     0,   116,   686,   687,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1699,   137,  1700,  1701,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,  1702,  1703,   437,     0,   438,
     439,   440,   441,     0,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,   149,   457,     0,     0,     0,     0,   150,
       0,     0,     0,   458,   459,   460,   461,   462,   463,  1704,
    1705,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,  1343,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,     0,   485,   486,     0,     0,   487,     0,   488,
    1706,     0,     0,   489,     0,   490,   167,     0,   168,   491,
     492,     0,   493,     0,     0,   494,     0,   495,   496,   497,
     498,   499,   171,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,   172,     0,     0,   509,   510,   511,
    1349,  1707,     0,  1708,     0,     0,   177,   178,   512,   179,
     513,   514,   515,   516,   517,   518,   519,     0,     0,   181,
     520,   182,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,  1709,   188,  1710,     0,   537,   538,   539,   540,   541,
     542,   543,     0,   544,     0,   545,   546,   192,   547,     0,
       0,   548,  1711,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,     0,   196,   197,   198,
       0,   554,   555,   556,   557,     0,   558,     0,   559,     0,
       0,     0,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,  1712,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,   209,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
    2194,   597,   598,   217,   599,  1714,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,  1715,
    1716,     0,     0,   619,     0,   620,     0,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,     0,  1717,     0,   635,
     234,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,     0,     0,     0,     0,     0,     0,
       0,     0,   644,   645,   646,     0,     0,     0,    55,   681,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   682,
     104,   105,   403,   683,     0,   107,   108,   109,   110,   684,
     685,   112,   113,   114,   115,     0,   116,   686,   687,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1699,   137,  1700,  1701,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,  1702,  1703,   437,
       0,   438,   439,   440,   441,     0,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,   149,   457,     0,     0,     0,
       0,   150,     0,     0,     0,   458,   459,   460,   461,   462,
     463,  1704,  1705,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
    1343,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,     0,   485,   486,     0,     0,   487,
       0,   488,  1706,     0,     0,   489,     0,   490,   167,     0,
     168,   491,   492,     0,   493,     0,     0,   494,     0,   495,
     496,   497,   498,   499,   171,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,   172,     0,     0,   509,
     510,   511,  1349,  1707,     0,  1708,     0,     0,   177,   178,
     512,   179,   513,   514,   515,   516,   517,   518,   519,     0,
       0,   181,   520,   182,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,  1709,   188,  1710,     0,   537,   538,   539,
     540,   541,   542,   543,     0,   544,     0,   545,   546,   192,
     547,     0,     0,   548,  1711,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,     0,   196,
     197,   198,     0,   554,   555,   556,   557,     0,   558,     0,
     559,     0,     0,     0,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,  1712,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   209,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,     0,   597,   598,   217,   599,  1714,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,     0,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,  1715,  1716,     0,     0,   619,     0,   620,     0,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,     0,  1717,
       0,   635,   234,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,     0,     0,     0,     0,
       0,     0,     0,     0,   644,   645,   646,     0,     0,     0,
      55,   681,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   682,   104,   105,   403,   683,     0,   107,   108,   109,
     110,   684,   685,   112,   113,   114,   115,     0,   116,   686,
     687,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,     0,   137,     0,     0,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,     0,
       0,   437,     0,   438,   439,   440,   441,     0,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,   149,   457,     0,
       0,     0,     0,   150,     0,     0,     0,   458,   459,   460,
     461,   462,   463,     0,     0,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,     0,   485,   486,     0,
       0,   487,     0,   488,     0,     0,     0,   489,     0,   490,
     167,     0,   168,   491,   492,     0,   493,     0,     0,   494,
       0,   495,   496,   497,   498,   499,   171,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,   172,     0,
       0,   509,   510,   511,     0,     0,     0,     0,     0,     0,
     177,   178,   512,   179,   513,   514,   515,   516,   517,   518,
     519,     0,     0,   181,   520,   182,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,     0,   188,     0,     0,   537,
     538,   539,   540,   541,   542,   543,     0,   544,     0,   545,
     546,   192,   547,     0,     0,   548,     0,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
       0,   196,   197,   198,     0,   554,   555,   556,   557,     0,
     558,     0,   559,     0,     0,     0,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,   209,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,     0,   597,   598,   217,   599,     0,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,     0,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,     0,     0,     0,     0,   619,     0,   620,
       0,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
       0,     0,     0,   635,   234,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,     0,     0,
       0,     0,     0,     0,     0,     0,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   688,   422,   423,   424,
     689,   690,   691,   692,   693,   694,   695,   425,   426,   696,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     697,   431,   432,     0,   433,   434,   698,   699,     0,   435,
       0,   140,   437,   701,   438,   439,   440,   441,   144,   702,
     703,   442,   443,   444,   445,   446,   447,   704,   448,   449,
     450,   451,   452,   453,   705,   454,   455,   456,   149,   457,
       0,   706,   707,   708,   150,   709,   710,   711,   458,   459,
     460,   461,     0,   463,   153,   154,   464,   712,   465,   713,
     466,     0,   467,   468,   469,   714,   470,   471,   472,   715,
     716,   473,   474,   475,   476,   477,   717,   478,   479,   480,
     718,     0,   481,   719,   482,   483,   484,   162,   485,   486,
     164,   720,   487,   721,   488,   166,     0,   722,   489,   723,
     490,   167,   724,   168,   491,   492,   725,   493,   170,   726,
     494,   727,   495,   496,     0,   498,   499,   171,   500,   501,
     502,   728,   503,   504,   505,   506,   507,   508,   729,   172,
     173,     0,   509,   510,   511,     0,   175,   732,   176,   733,
       0,   177,   178,   512,   179,   513,   514,   515,   516,   517,
     518,   519,   734,   180,   181,   520,   182,   735,   521,   522,
     523,   736,   737,   524,   525,   526,   527,   528,   529,     0,
     531,   532,     0,   534,   535,   536,   187,   188,   189,   738,
     537,   538,   539,   540,   541,   542,   543,   190,   544,   739,
     545,   546,   192,   547,   740,   193,   548,   194,   549,   550,
     741,   742,   551,   743,   744,   745,   552,   553,     0,   746,
     747,   195,   196,   197,   198,   199,   554,   555,   556,   557,
       0,   558,   748,   559,   200,     0,   201,   560,   561,   562,
     749,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,   750,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,   751,   582,   583,   209,   584,   585,   211,
     586,   587,   588,   589,   590,   591,     0,     0,   752,   593,
     594,     0,   595,   753,   596,   215,   597,   598,   217,   599,
     218,   754,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,   755,   611,   612,   756,   613,   614,
     615,   616,   617,   757,   222,   223,     0,   759,   619,   224,
     620,   225,   760,   621,   622,   623,     0,   624,   625,     0,
     762,   626,   627,   628,   629,   763,   764,   630,   631,   632,
     633,     0,   233,   765,   635,   234,   636,   637,   638,   766,
     767,   639,   768,   769,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,     0,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,  2163,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,  2164,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
    2165,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,  2927,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,  2166,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,  2167,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   971,   420,   421,   930,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,   931,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,   972,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,   932,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
     933,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,   667,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,   668,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
     669,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
     930,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,   931,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,   932,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,   933,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,  1862,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,  1863,   490,     0,     0,     0,  1864,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,  1865,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,  1002,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,  1003,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,  1866,   590,
     591,   592,     0,     0,  1867,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,  1868,  1869,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
    2609,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,  2610,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,  2611,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,  1002,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,  1003,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,  2612,   613,  2613,   615,  2614,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,   130,   131,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,  1002,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
    1003,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,   864,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,   865,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   866,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,  1002,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,  1003,     0,  1004,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,  1431,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,  1002,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,  1003,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,   931,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,   932,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,   933,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,   669,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,  1002,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,  1003,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
    1222,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,   916,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,   917,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,  2273,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,  2274,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,  2752,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,  2753,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,  2762,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,  2763,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   676,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   817,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   907,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     947,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,  1444,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,   983,   435,   958,   140,  1445,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   987,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   988,   585,   211,   586,   587,   588,   989,   590,   591,
     592,     0,     0,   593,   594,     0,  1435,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   991,   223,
       0,     0,   992,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   962,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   993,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,  1775,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,  2965,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,  2978,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,  3015,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,  3678,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,  3680,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,  3682,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,  4043,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   870,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   955,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   957,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   958,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   959,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     960,   223,     0,     0,   961,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   962,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,   996,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   958,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   997,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   998,   223,     0,     0,   999,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   962,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,  1021,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,  1143,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,  1206,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
     586,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,  1232,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,   596,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,  1237,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,   445,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,  1245,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
    1247,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,  1249,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,  1251,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,   588,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,     0,   435,   436,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,   447,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,  1254,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   584,   585,   211,   586,   587,   588,
     589,   590,   591,   592,     0,     0,   593,   594,     0,   595,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,   613,   614,   615,   616,   617,
       0,   222,   223,     0,     0,   619,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   634,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   643,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,     0,   435,   436,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,   447,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,  1256,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,  1257,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   584,   585,   211,   586,   587,
     588,   589,   590,   591,   592,     0,     0,   593,   594,     0,
     595,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   222,   223,     0,     0,   619,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   634,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   643,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,  1260,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,   983,   435,
     958,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   987,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   988,   585,   211,
     586,   587,   588,   989,   590,   591,   592,     0,     0,   593,
     594,     0,  1435,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   991,   223,     0,     0,   992,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   962,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   993,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  1467,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,     0,   433,   434,     0,     0,     0,
     435,   436,   140,   437,     0,   438,   439,   440,   441,   144,
       0,     0,   442,   443,   444,   445,   446,   447,     0,   448,
     449,   450,   451,   452,   453,     0,   454,   455,   456,     0,
     457,     0,     0,     0,     0,     0,     0,     0,     0,   458,
     459,   460,   461,   462,   463,   153,   154,   464,     0,   465,
       0,   466,     0,   467,   468,   469,     0,   470,   471,   472,
       0,     0,   473,   474,   475,   476,   477,     0,   478,   479,
     480,     0,     0,   481,     0,   482,   483,   484,   162,   485,
     486,   164,     0,   487,     0,   488,   166,     0,     0,   489,
       0,   490,     0,     0,     0,   491,   492,     0,   493,   170,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   500,
     501,   502,     0,   503,   504,   505,   506,   507,   508,     0,
       0,   173,     0,   509,   510,   511,     0,   175,     0,   176,
       0,     0,     0,     0,   512,     0,   513,   514,   515,   516,
     517,   518,   519,     0,   180,     0,   520,     0,     0,   521,
     522,   523,     0,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   187,     0,   189,
       0,   537,   538,   539,   540,   541,   542,   543,   190,   544,
       0,   545,   546,     0,   547,     0,   193,   548,   194,   549,
     550,     0,     0,   551,     0,     0,     0,   552,   553,     0,
       0,     0,   195,     0,     0,     0,   199,   554,   555,   556,
     557,     0,   558,     0,   559,   200,     0,   201,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   568,   203,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,     0,   582,   583,     0,   584,   585,
     211,   586,   587,   588,   589,   590,   591,   592,     0,     0,
     593,   594,     0,   595,     0,     0,   215,   597,   598,     0,
     599,   218,     0,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   220,   610,     0,   611,   612,     0,   613,
     614,   615,   616,   617,     0,   222,   223,     0,     0,   619,
     224,   620,   225,     0,   621,   622,   623,     0,   624,   625,
       0,     0,   626,   627,   628,   629,     0,     0,   630,   631,
     632,   633,   634,   233,     0,   635,     0,   636,   637,   638,
       0,     0,   639,     0,     0,   640,   641,     0,   642,   643,
     236,   237,   238,   239,   240,   241,   242,   243,   644,   645,
     646,     0,     0,     0,    55,  1557,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,     0,   433,   434,     0,     0,
       0,   435,   436,   140,   437,     0,   438,   439,   440,   441,
     144,     0,     0,   442,   443,   444,   445,   446,   447,     0,
     448,   449,   450,   451,   452,   453,     0,   454,   455,   456,
       0,   457,     0,     0,     0,     0,     0,     0,     0,     0,
     458,   459,   460,   461,   462,   463,   153,   154,   464,     0,
     465,     0,   466,     0,   467,   468,   469,     0,   470,   471,
     472,     0,     0,   473,   474,   475,   476,   477,     0,   478,
     479,   480,     0,     0,   481,     0,   482,   483,   484,   162,
     485,   486,   164,     0,   487,     0,   488,   166,     0,     0,
     489,     0,   490,     0,     0,     0,   491,   492,     0,   493,
     170,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     500,   501,   502,     0,   503,   504,   505,   506,   507,   508,
       0,     0,   173,     0,   509,   510,   511,     0,   175,     0,
     176,     0,     0,     0,     0,   512,     0,   513,   514,   515,
     516,   517,   518,   519,     0,   180,     0,   520,     0,     0,
     521,   522,   523,     0,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   187,     0,
     189,     0,   537,   538,   539,   540,   541,   542,   543,   190,
     544,     0,   545,   546,     0,   547,     0,   193,   548,   194,
     549,   550,     0,     0,   551,     0,     0,     0,   552,   553,
       0,     0,     0,   195,     0,     0,     0,   199,   554,   555,
     556,   557,     0,   558,     0,   559,   200,     0,   201,   560,
     561,   562,     0,   563,   564,   565,   566,   567,     0,   568,
     203,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   579,   580,   581,     0,   582,   583,     0,   584,
     585,   211,   586,   587,   588,   589,   590,   591,   592,     0,
       0,   593,   594,     0,   595,     0,   596,   215,   597,   598,
       0,   599,   218,     0,   600,   601,   602,   603,   604,   605,
     606,   607,   608,   609,   220,   610,     0,   611,   612,     0,
     613,   614,   615,   616,   617,     0,   222,   223,     0,     0,
     619,   224,   620,   225,     0,   621,   622,   623,     0,   624,
     625,     0,     0,   626,   627,   628,   629,     0,     0,   630,
     631,   632,   633,   634,   233,     0,   635,     0,   636,   637,
     638,     0,     0,   639,     0,     0,   640,   641,     0,   642,
     643,   236,   237,   238,   239,   240,   241,   242,   243,   644,
     645,   646,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,     0,   433,   434,     0,
       0,     0,   435,   436,   140,   437,     0,   438,   439,   440,
     441,   144,     0,     0,   442,   443,   444,  1770,   446,   447,
       0,   448,   449,   450,   451,   452,   453,     0,   454,   455,
     456,     0,   457,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   459,   460,   461,   462,   463,   153,   154,   464,
       0,   465,     0,   466,     0,   467,   468,   469,     0,   470,
     471,   472,     0,     0,   473,   474,   475,   476,   477,     0,
     478,   479,   480,     0,     0,   481,     0,   482,   483,   484,
     162,   485,   486,   164,     0,   487,     0,   488,   166,     0,
       0,   489,     0,   490,     0,     0,     0,   491,   492,     0,
     493,   170,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   500,   501,   502,     0,   503,   504,   505,   506,   507,
     508,     0,     0,   173,     0,   509,   510,   511,     0,   175,
       0,   176,     0,     0,     0,     0,   512,     0,   513,   514,
     515,   516,   517,   518,   519,     0,   180,     0,   520,     0,
       0,   521,   522,   523,     0,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   187,
       0,   189,     0,   537,   538,   539,   540,   541,   542,   543,
     190,   544,     0,   545,   546,     0,   547,     0,   193,   548,
     194,   549,   550,     0,     0,   551,     0,     0,     0,   552,
     553,     0,     0,     0,   195,     0,     0,     0,   199,   554,
     555,   556,   557,     0,   558,     0,   559,   200,     0,   201,
     560,   561,   562,     0,   563,   564,   565,   566,   567,     0,
     568,   203,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   581,     0,   582,   583,     0,
     584,   585,   211,   586,   587,   588,   589,   590,   591,   592,
       0,     0,   593,   594,     0,   595,     0,   596,   215,   597,
     598,     0,   599,   218,     0,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   220,   610,     0,   611,   612,
       0,   613,   614,   615,   616,   617,     0,   222,   223,     0,
       0,   619,   224,   620,   225,     0,   621,   622,   623,     0,
     624,   625,     0,     0,   626,   627,   628,   629,     0,     0,
     630,   631,   632,   633,   634,   233,     0,   635,     0,   636,
     637,   638,     0,     0,   639,     0,     0,   640,   641,     0,
     642,   643,   236,   237,   238,   239,   240,   241,   242,   243,
     644,   645,   646,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,     0,   433,   434,
       0,     0,     0,   435,   436,   140,   437,     0,   438,   439,
     440,   441,   144,     0,     0,   442,   443,   444,   445,   446,
     447,     0,   448,   449,   450,   451,   452,   453,     0,   454,
     455,   456,     0,   457,     0,     0,     0,     0,     0,     0,
       0,     0,   458,   459,   460,   461,   462,   463,   153,   154,
     464,     0,   465,     0,   466,     0,   467,   468,   469,     0,
     470,   471,   472,     0,     0,   473,   474,   475,   476,   477,
       0,   478,   479,   480,     0,     0,   481,     0,   482,   483,
     484,   162,   485,   486,   164,     0,   487,     0,   488,   166,
       0,     0,   489,     0,   490,     0,     0,     0,   491,   492,
       0,   493,   170,     0,   494,     0,   495,   496,   497,   498,
    1801,     0,   500,   501,   502,     0,   503,   504,   505,   506,
     507,   508,     0,     0,   173,     0,   509,   510,   511,     0,
     175,     0,   176,     0,     0,     0,     0,   512,     0,   513,
     514,   515,   516,   517,   518,   519,     0,   180,     0,   520,
       0,     0,   521,   522,   523,     0,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     187,     0,   189,     0,   537,   538,   539,   540,   541,   542,
     543,   190,   544,     0,   545,   546,     0,   547,     0,   193,
     548,   194,   549,   550,     0,     0,   551,     0,     0,     0,
     552,   553,     0,     0,     0,   195,     0,     0,     0,   199,
     554,   555,   556,   557,     0,   558,     0,   559,   200,     0,
     201,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   568,   203,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,     0,   582,   583,
       0,   584,   585,   211,   586,   587,   588,   589,   590,   591,
     592,     0,     0,   593,   594,     0,   595,     0,   596,   215,
     597,   598,     0,   599,   218,     0,   600,   601,   602,   603,
     604,   605,   606,   607,   608,   609,   220,   610,     0,   611,
     612,     0,   613,   614,   615,   616,   617,     0,   222,   223,
       0,     0,   619,   224,   620,   225,     0,   621,   622,   623,
       0,   624,   625,     0,     0,   626,   627,   628,   629,     0,
       0,   630,   631,   632,   633,   634,   233,     0,   635,     0,
     636,   637,   638,     0,     0,   639,     0,     0,   640,   641,
       0,   642,   643,   236,   237,   238,   239,   240,   241,   242,
     243,   644,   645,   646,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,     0,   433,
     434,     0,     0,     0,   435,   436,   140,   437,     0,   438,
     439,   440,   441,   144,     0,     0,   442,   443,   444,   445,
     446,   447,     0,   448,   449,   450,   451,   452,   453,     0,
     454,   455,   456,     0,   457,     0,     0,     0,     0,     0,
       0,     0,     0,   458,   459,   460,   461,   462,   463,   153,
     154,   464,     0,   465,     0,   466,     0,   467,   468,   469,
       0,   470,   471,   472,     0,     0,   473,   474,   475,   476,
     477,     0,   478,   479,   480,     0,     0,   481,     0,   482,
     483,   484,   162,   485,   486,   164,     0,   487,     0,   488,
     166,     0,     0,   489,     0,   490,     0,     0,     0,   491,
     492,     0,   493,   170,     0,   494,     0,   495,   496,   497,
     498,  1803,     0,   500,   501,   502,     0,   503,   504,   505,
     506,   507,   508,     0,     0,   173,     0,   509,   510,   511,
       0,   175,     0,   176,     0,     0,     0,     0,   512,     0,
     513,   514,   515,   516,   517,   518,   519,     0,   180,     0,
     520,     0,     0,   521,   522,   523,     0,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   187,     0,   189,     0,   537,   538,   539,   540,   541,
     542,   543,   190,   544,     0,   545,   546,     0,   547,     0,
     193,   548,   194,   549,   550,     0,     0,   551,     0,     0,
       0,   552,   553,     0,     0,     0,   195,     0,     0,     0,
     199,   554,   555,   556,   557,     0,   558,     0,   559,   200,
       0,   201,   560,   561,   562,     0,   563,   564,   565,   566,
     567,     0,   568,   203,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   579,   580,   581,     0,   582,
     583,     0,   584,   585,   211,   586,   587,   588,   589,   590,
     591,   592,     0,     0,   593,   594,     0,   595,     0,   596,
     215,   597,   598,     0,   599,   218,     0,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   220,   610,     0,
     611,   612,     0,   613,   614,   615,   616,   617,     0,   222,
     223,     0,     0,   619,   224,   620,   225,     0,   621,   622,
     623,     0,   624,   625,     0,     0,   626,   627,   628,   629,
       0,     0,   630,   631,   632,   633,   634,   233,     0,   635,
       0,   636,   637,   638,     0,     0,   639,     0,     0,   640,
     641,     0,   642,   643,   236,   237,   238,   239,   240,   241,
     242,   243,   644,   645,   646,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,     0,
     433,   434,     0,     0,     0,   435,   436,   140,   437,     0,
     438,   439,   440,   441,   144,     0,     0,   442,   443,   444,
     445,   446,   447,     0,   448,   449,   450,   451,   452,   453,
       0,   454,   455,   456,     0,   457,     0,     0,     0,     0,
       0,     0,     0,     0,   458,   459,   460,   461,   462,   463,
     153,   154,   464,     0,   465,     0,   466,     0,   467,   468,
     469,     0,   470,   471,   472,     0,     0,   473,   474,   475,
     476,   477,     0,   478,   479,   480,     0,     0,   481,     0,
     482,   483,   484,   162,   485,   486,   164,     0,   487,     0,
     488,   166,     0,     0,   489,     0,   490,     0,     0,     0,
     491,   492,     0,   493,   170,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   500,   501,   502,     0,   503,   504,
     505,   506,   507,   508,     0,     0,   173,     0,   509,   510,
     511,     0,   175,     0,   176,     0,     0,     0,     0,   512,
       0,   513,   514,   515,   516,   517,   518,   519,     0,   180,
       0,   520,     0,     0,   521,   522,   523,     0,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   187,     0,   189,     0,   537,   538,   539,   540,
     541,   542,   543,   190,   544,     0,   545,   546,     0,   547,
       0,   193,   548,   194,   549,   550,     0,     0,   551,     0,
       0,     0,   552,   553,     0,     0,     0,   195,     0,     0,
       0,   199,   554,   555,   556,   557,     0,   558,     0,   559,
     200,     0,   201,   560,   561,   562,     0,   563,   564,   565,
     566,   567,     0,   568,   203,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   581,     0,
     582,   583,     0,   584,   585,   211,   586,   587,  1897,   589,
     590,   591,   592,     0,     0,   593,   594,     0,   595,     0,
     596,   215,   597,   598,     0,   599,   218,     0,   600,   601,
     602,   603,   604,   605,   606,   607,   608,   609,   220,   610,
       0,   611,   612,     0,   613,   614,   615,   616,   617,     0,
     222,   223,     0,     0,   619,   224,   620,   225,     0,   621,
     622,   623,     0,   624,   625,     0,     0,   626,   627,   628,
     629,     0,     0,   630,   631,   632,   633,   634,   233,     0,
     635,     0,   636,   637,   638,     0,     0,   639,     0,     0,
     640,   641,     0,   642,   643,   236,   237,   238,   239,   240,
     241,   242,   243,   644,   645,   646,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
       0,   433,   434,     0,     0,   983,   435,   958,   140,   437,
       0,   438,   439,   440,   441,   144,     0,     0,   442,   443,
     444,   445,   446,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   454,   455,   456,     0,   457,     0,     0,     0,
       0,     0,     0,     0,     0,   458,   459,   460,   461,   462,
     463,   153,   154,   464,     0,   465,     0,   466,     0,   467,
     468,   469,     0,   470,   471,   472,     0,     0,   473,   474,
     475,   476,   477,     0,   478,   479,   480,     0,     0,   481,
       0,   482,   483,   484,   162,   485,   486,   164,     0,   487,
       0,   488,   166,     0,     0,   489,     0,   490,     0,     0,
       0,   491,   492,     0,   493,   170,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   500,   501,   502,     0,   503,
     504,   505,   506,   507,   508,     0,     0,   173,     0,   509,
     510,   511,     0,   175,     0,   176,     0,     0,     0,     0,
     512,     0,   513,   514,   515,   516,   517,   518,   519,     0,
     180,     0,   520,     0,     0,   521,   522,   523,     0,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   987,   187,     0,   189,     0,   537,   538,   539,
     540,   541,   542,   543,   190,   544,     0,   545,   546,     0,
     547,     0,   193,   548,   194,   549,   550,     0,     0,   551,
       0,     0,     0,   552,   553,     0,     0,     0,   195,     0,
       0,     0,   199,   554,   555,   556,   557,     0,   558,     0,
     559,   200,     0,   201,   560,   561,   562,     0,   563,   564,
     565,   566,   567,     0,   568,   203,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,     0,   988,   585,   211,   586,   587,   588,
     989,   590,   591,   592,     0,     0,   593,   594,     0,  1435,
       0,   596,   215,   597,   598,     0,   599,   218,     0,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   609,   220,
     610,     0,   611,   612,     0,  2160,   614,   615,   616,   617,
       0,   991,   223,     0,     0,   992,   224,   620,   225,     0,
     621,   622,   623,     0,   624,   625,     0,     0,   626,   627,
     628,   629,     0,     0,   630,   631,   632,   633,   962,   233,
       0,   635,     0,   636,   637,   638,     0,     0,   639,     0,
       0,   640,   641,     0,   642,   993,   236,   237,   238,   239,
     240,   241,   242,   243,   644,   645,   646,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,     0,   433,   434,     0,     0,   983,   435,   958,   140,
     437,     0,   438,   439,   440,   441,   144,     0,     0,   442,
     443,   444,   445,   446,     0,     0,   448,   449,   450,   451,
     452,   453,     0,   454,   455,   456,     0,   457,     0,     0,
       0,     0,     0,     0,     0,     0,   458,   459,   460,   461,
     462,   463,   153,   154,   464,     0,   465,     0,   466,     0,
     467,   468,   469,     0,   470,   471,   472,     0,     0,   473,
     474,   475,   476,   477,     0,   478,   479,   480,     0,     0,
     481,     0,   482,   483,   484,   162,   485,   486,   164,     0,
     487,     0,   488,   166,     0,     0,   489,     0,   490,     0,
       0,     0,   491,   492,     0,   493,   170,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   500,   501,   502,     0,
     503,   504,   505,   506,   507,   508,     0,     0,   173,     0,
     509,   510,   511,     0,   175,     0,   176,     0,     0,     0,
       0,   512,     0,   513,   514,   515,   516,   517,   518,   519,
       0,   180,     0,   520,     0,     0,   521,   522,   523,     0,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   987,   187,     0,   189,     0,   537,   538,
     539,   540,   541,   542,   543,   190,   544,     0,   545,   546,
       0,   547,     0,   193,   548,   194,   549,   550,     0,     0,
     551,     0,     0,     0,   552,   553,     0,     0,     0,   195,
       0,     0,     0,   199,   554,   555,   556,   557,     0,   558,
       0,   559,   200,     0,   201,   560,   561,   562,     0,   563,
     564,   565,   566,   567,     0,   568,   203,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     581,     0,   582,   583,     0,   988,   585,   211,   586,   587,
     588,  2187,   590,   591,   592,     0,     0,   593,   594,     0,
    1435,     0,   596,   215,   597,   598,     0,   599,   218,     0,
     600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
     220,   610,     0,   611,   612,     0,   613,   614,   615,   616,
     617,     0,   991,   223,     0,     0,   992,   224,   620,   225,
       0,   621,   622,   623,     0,   624,   625,     0,     0,   626,
     627,   628,   629,     0,     0,   630,   631,   632,   633,   962,
     233,     0,   635,     0,   636,   637,   638,     0,     0,   639,
       0,     0,   640,   641,     0,   642,   993,   236,   237,   238,
     239,   240,   241,   242,   243,   644,   645,   646,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,     0,   433,   434,     0,     0,     0,   435,   436,
     140,   437,     0,   438,   439,   440,   441,   144,     0,     0,
     442,   443,   444,   445,   446,   447,     0,   448,   449,   450,
     451,   452,   453,     0,   454,   455,   456,     0,   457,     0,
       0,     0,     0,     0,     0,     0,     0,   458,   459,   460,
     461,   462,   463,   153,   154,   464,     0,   465,     0,   466,
       0,   467,   468,   469,     0,   470,   471,   472,     0,     0,
     473,   474,   475,   476,   477,     0,   478,   479,   480,     0,
       0,   481,     0,   482,   483,   484,   162,   485,   486,   164,
       0,   487,     0,   488,   166,     0,     0,   489,     0,   490,
       0,     0,     0,   491,   492,     0,   493,   170,     0,   494,
       0,   495,   496,   497,   498,  2404,     0,   500,   501,   502,
       0,   503,   504,   505,   506,   507,   508,     0,     0,   173,
       0,   509,   510,   511,     0,   175,     0,   176,     0,     0,
       0,     0,   512,     0,   513,   514,   515,   516,   517,   518,
     519,     0,   180,     0,   520,     0,     0,   521,   522,   523,
       0,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   187,     0,   189,     0,   537,
     538,   539,   540,   541,   542,   543,   190,   544,     0,   545,
     546,     0,   547,     0,   193,   548,   194,   549,   550,     0,
       0,   551,     0,     0,     0,   552,   553,     0,     0,     0,
     195,     0,     0,     0,   199,   554,   555,   556,   557,     0,
     558,     0,   559,   200,     0,   201,   560,   561,   562,     0,
     563,   564,   565,   566,   567,     0,   568,   203,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   579,
     580,   581,     0,   582,   583,     0,   584,   585,   211,   586,
     587,   588,   589,   590,   591,   592,     0,     0,   593,   594,
       0,   595,     0,   596,   215,   597,   598,     0,   599,   218,
       0,   600,   601,   602,   603,   604,   605,   606,   607,   608,
     609,   220,   610,     0,   611,   612,     0,   613,   614,   615,
     616,   617,     0,   222,   223,     0,     0,   619,   224,   620,
     225,     0,   621,   622,   623,     0,   624,   625,     0,     0,
     626,   627,   628,   629,     0,     0,   630,   631,   632,   633,
     634,   233,     0,   635,     0,   636,   637,   638,     0,     0,
     639,     0,     0,   640,   641,     0,   642,   643,   236,   237,
     238,   239,   240,   241,   242,   243,   644,   645,   646,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,     0,   433,   434,     0,     0,     0,   435,
     436,   140,   437,     0,   438,   439,   440,   441,   144,     0,
       0,   442,   443,   444,   445,   446,   447,     0,   448,   449,
     450,   451,   452,   453,     0,   454,   455,   456,     0,   457,
       0,     0,     0,     0,     0,     0,     0,     0,   458,   459,
     460,   461,   462,   463,   153,   154,   464,     0,   465,     0,
     466,     0,   467,   468,   469,     0,   470,   471,   472,     0,
       0,   473,   474,   475,   476,   477,     0,   478,   479,   480,
       0,     0,   481,     0,   482,   483,   484,   162,   485,   486,
     164,     0,   487,     0,   488,   166,     0,     0,   489,     0,
     490,     0,     0,     0,   491,   492,     0,   493,   170,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   500,   501,
     502,     0,   503,   504,   505,   506,   507,   508,     0,     0,
     173,     0,   509,   510,   511,     0,   175,     0,   176,     0,
       0,     0,     0,   512,     0,   513,   514,   515,   516,   517,
     518,   519,     0,   180,     0,   520,     0,     0,   521,   522,
     523,     0,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   187,     0,   189,     0,
     537,   538,   539,   540,   541,   542,   543,   190,   544,     0,
     545,   546,     0,   547,     0,   193,   548,   194,   549,   550,
       0,     0,   551,     0,     0,     0,   552,   553,     0,     0,
       0,   195,     0,     0,     0,   199,   554,   555,   556,   557,
       0,   558,     0,   559,   200,     0,   201,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   568,   203,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     579,   580,   581,     0,   582,   583,     0,   584,   585,   211,
       0,   587,   588,   589,   590,   591,   592,     0,     0,   593,
     594,     0,   595,     0,   596,   215,   597,   598,     0,   599,
     218,     0,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609,   220,   610,     0,   611,   612,     0,   613,   614,
     615,   616,   617,     0,   222,   223,     0,     0,   619,   224,
     620,   225,     0,   621,   622,   623,     0,   624,   625,     0,
       0,   626,   627,   628,   629,     0,     0,   630,   631,   632,
     633,   634,   233,     0,   635,     0,   636,   637,   638,     0,
       0,   639,     0,     0,   640,   641,     0,   642,   643,   236,
     237,   238,   239,   240,   241,   242,   243,   644,   645,   646,
      86,    87,    88,    55,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115, -1829,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,     0,    35,     0,   394,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,   154,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   160,     0,
       0,     0,     0,     0,   162,     0,     0,   164,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   172,   173,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,   190,     0,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   195,   196,
     197,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,   217,     0,   218,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,   223,     0,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
       0,     0,   234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   236,   237,   238,   239,
     240,   241,   242,   243,     0,     0,     0,    86,    87,    88,
      55,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115, -1830,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,   127,     0,    35,     0,  1067,     0,     0,     0,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,   154,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   160,     0,     0,     0,     0,
       0,   162,     0,     0,   164,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   167,     0,   168,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,     0,
       0,   171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   172,   173,     0,     0,     0,     0,     0,
     175,     0,   176,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,   180,   181,     0,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,   190,     0,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   195,   196,   197,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     209,     0,     0,   211,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,   217,     0,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,   223,
       0,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,     0,     0,   234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   236,   237,   238,   239,   240,   241,   242,
     243,     0,     0,     0,    86,    87,    88,    55,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   162,     0,
       0,   164,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     172,   173,     0,     0,     0,     0,     0,   175,     0,   176,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,   180,   181,     0,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,   223,     0,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,     0,     0,   234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,   237,   238,   239,   240,   241,   242,   243,     0,     0,
       0,    86,    87,    88,    55,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,   154,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   160,
       0,     0,     0,     0,     0,   162,     0,     0,   164,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   167,
       0,   168,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,     0,     0,   171,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   172,   173,     0,
       0,     0,     0,     0,   175,     0,   176,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,   180,   181,     0,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,   190,     0,     0,     0,     0,
     192,     0,     0,   193,     0,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
     196,   197,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   209,     0,     0,   211,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   215,     0,     0,   217,     0,   218,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,   223,     0,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,     0,     0,   234,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   236,   237,   238,
     239,   240,   241,   242,   243,     0,     0,     0,    86,    87,
      88,    55,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   149,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   153,
     154,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,   164,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,   167,     0,   168,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
       0,     0,   171,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   172,   173,     0,     0,     0,     0,
       0,   175,     0,   176,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,   180,   181,
       0,   182,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   187,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,   190,     0,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   195,   196,   197,   198,
     199,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,   201,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   209,     0,     0,   211,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     215,     0,     0,   217,     0,   218,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
     223,     0,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,     0,     0,
     234,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   236,   237,   238,   239,   240,   241,
     242,   243,     0,     0,     0,     0,     0,     0,    55
};

static const short yycheck[] =
{
       2,  1081,   244,   838,  1036,   932,   933,  1036,   165,     2,
     937,   800,   985,   226,   152,  1613,  1236,    78,   151,  1307,
      89,  1274,  1038,   148,  1293,  1243,  1729,     2,  1134,   186,
    1825,    78,  1110,  1151,   988,  1864,    78,    84,  1144,    78,
    1205,  2199,    84,  1341,  1342,    84,  1786,  1832,    78,   838,
     117,    78,   887,    78,  1320,  1713,    78,    84,   169,   679,
     208,   362,  1360,  1100,   202,  1370,   992,  1646,   221,   362,
    2231,  2011,  2662,    94,  2624,  2486,  1463,   230,   117,   132,
    1186,  2199,  2200,    78,   792,  1191,  1762,    89,  1748,   797,
     117,  1900,  1198,   160,  1597,  2953,   165,   208,   887,  1748,
    1182,  1207,   334,  2815,   117,  2817,  1748,  1748,  1748,    78,
    2388,   132,  1511,  1512,  1513,    84,  1748,   186,   207,   827,
    2062,   160,  2393,  2394,  2460,   214,  2906,   216,  1000,  2399,
     151,  1081,  3190,   160,   214,  1640,  2071,   348,  1391,  2878,
     158,  3408,  1566,  1275,  3360,  1821,  1228,   160,   117,   151,
    1266,  3380,   147,  1114,  1213,   348,  1061,  2108,    21,  2068,
      30,   228,   117,  1033,    73,  1033,    10,  2906,    71,   877,
    1933,  2332,  1081,  3086,  1561,    73,   884,   117,  1331,  1332,
      89,    71,   184,  2892,  2893,  2894,  2895,  2896,  2897,   228,
     165,   160,   793,  2144,   795,  1076,  1077,  2148,    72,   117,
     885,   228,   124,  1356,   889,   160,    80,    98,   904,   810,
     143,   186,  3882,   103,   899,   228,    72,    73,   110,    83,
      89,   117,   117,   108,    80,    84,    73,   170,   786,    89,
    1993,  3430,   833,  3432,   169,   194,    96,   234,   207,   215,
     133,   189,   160,   215,   864,   214,   252,   216,   849,   244,
    2411,    89,  2413,  1180,    71,    73,   163,  3711,    96,   228,
    1963,    76,    77,    78,    79,   160,   215,   117,   153,    89,
     170,    73,   256,   228,    29,   330,    96,   153,   102,   314,
     353,   315,    76,    77,    78,    79,   103,    89,    71,   209,
    4050,   252,   318,   354,   217,   102,   177,   136,   372,   130,
      76,    77,    78,    79,   359,  1259,  3924,   217,   141,    73,
     228,   294,   207,    76,    77,    78,    79,   350,    71,   214,
     362,   216,   163,   362,   354,   302,   312,   457,    22,   354,
    1448,  1166,   354,   228,   198,   362,   419,   215,   171,    76,
      77,    78,    79,   252,   126,   475,   197,   215,   124,   396,
     103,   133,    51,   348,   396,    78,   389,   396,   140,   354,
       0,  3577,   982,   220,  2315,    78,   350,   497,   456,   396,
      69,   348,    76,    77,    78,    79,  1413,  1166,   399,    73,
      76,    77,    78,    79,   235,    76,    77,    78,    79,    76,
      77,    78,    79,   362,   175,  4155,    37,    76,    77,    78,
      79,    73,   302,  1275,   437,   238,  1704,  1705,    38,   319,
      40,  1716,   500,  1711,  1286,  1287,   252,   500,   338,    76,
      77,    78,    79,   497,   497,   365,   170,   396,   124,  4189,
     212,   364,    73,   439,   460,    76,    77,    78,    79,    25,
     215,   117,   497,    76,    77,    78,    79,   419,  1156,  3903,
     252,   374,    73,   294,   187,  1163,    76,    77,    78,    79,
    1680,    92,    71,   497,   198,   500,  1684,   336,  3248,   365,
     419,    76,    77,    78,    79,  3691,   376,   384,   439,   170,
     252,    25,   117,   170,   315,   618,   421,   788,   471,   244,
    1444,  4109,   402,   252,   103,   788,    76,    77,    78,    79,
     312,   254,   255,   500,   452,    71,  1214,  3216,   372,  3248,
     252,   497,   484,   170,  3730,   365,   500,  1118,  1119,    76,
      77,    78,    79,   458,   500,   389,   419,   499,   215,  4199,
    1636,  1696,  1638,    71,   394,   252,  2194,   396,   497,  1411,
    1098,   484,  1447,   412,   429,   414,  1451,  1452,   126,  1702,
    1703,  3750,   305,   429,  1672,  2464,   394,  1710,   439,  1244,
     500,   343,  3475,    76,    77,    78,    79,   500,  1264,    76,
      77,    78,    79,   482,   394,   497,   439,  1178,  2306,   488,
     489,  1453,  1454,   407,   482,   400,   401,  1693,  1857,   326,
     493,   430,   501,  1194,  1195,  1677,   443,   618,  2177,   443,
     407,  3151,   476,   493,   500,   497,   497,    76,    77,    78,
      79,  1212,  1999,  1298,  3830,  1674,   618,    71,  2005,  1528,
     476,  2739,   500,  2741,  1309,   495,   482,  1497,   491,  1497,
      14,   354,   500,  3342,   212,  1596,  1321,   381,   252,  1240,
    1241,   354,    85,   500,  1525,   254,  1899,  1900,  2388,  2558,
     500,   433,  1730,   806,   387,   389,   437,  1910,   679,   294,
    1913,   794,   248,   478,   482,   501,   410,  3896,  1921,  1922,
     488,   489,   302,   490,   491,   492,   493,  1582,   910,   497,
     482,  1934,  1935,  1588,   478,   497,   488,   489,   254,   365,
    2968,  2631,  1945,  2644,  2972,   216,  2857,  2858,   831,   501,
     444,   495,   478,   497,   248,   499,  1838,   490,   491,   492,
     493,  1770,   456,  1829,  2649,   478,   254,   784,   482,   872,
    3335,   497,   497,  1628,   488,   489,  1631,  1632,   866,   501,
     365,   362,   419,  2157,   497,   488,   489,   490,   491,   492,
     493,   478,   501,   374,   187,   784,   788,  2000,   881,   788,
     307,   447,   387,   497,   911,   345,   913,   784,   915,   501,
    2878,   788,  2525,  2526,   921,   343,   172,  2530,   140,  4163,
     294,   784,  1925,  1926,   478,   198,  1681,    90,   457,   170,
     234,  4048,   478,   500,   456,    71,  1621,   478,  2906,  1184,
     943,   478,   423,  1478,   307,   174,   475,   484,   170,   478,
     254,   497,    85,   821,   175,   477,  2569,  2570,   138,    95,
     482,   332,   499,  3874,  1768,   784,   488,   489,   497,   788,
     822,   478,   175,   210,  4218,   482,   165,   447,   222,   784,
     330,  1492,  1621,  2951,  3908,   853,   477,   478,   479,   480,
    1767,   482,   911,   864,   913,   478,   915,   488,   489,   179,
     138,   170,   921,   108,   172,   433,   477,  1010,   478,   359,
     160,   482,   138,  2368,   497,   319,   784,   488,   489,   206,
     172,   392,  3730,   478,   253,   246,   126,   497,  2618,   488,
     489,   490,   491,   492,   493,   499,   907,   330,   227,   784,
     140,   179,   497,   246,  1867,  1868,   302,   986,   478,   419,
    4116,   990,   904,   179,   187,   165,   986,   497,   207,   101,
     990,   904,  1307,   217,    71,  3185,   307,   497,   442,   138,
     164,   478,   488,   489,   490,   491,   492,   493,   228,   904,
     302,   984,  2635,   270,   247,   256,   911,   196,   913,   241,
     915,  4002,  3831,   282,   387,   947,   921,   922,   923,  4023,
     488,   489,   490,   491,   492,   493,    76,    77,    78,    79,
     179,   982,   212,   984,  1836,   478,   389,   227,   254,  1011,
    1805,   478,  1011,   975,   361,   230,   370,   314,  1850,   234,
     500,   983,  3694,   302,  1011,   987,   988,   989,   457,   307,
     497,   250,  1061,   237,   293,  3545,  3546,  3547,  3887,    71,
     302,   331,    76,    77,    78,    79,   475,  1076,  1077,   478,
     381,   175,  1081,   421,   269,   319,  1805,   986,   361,   162,
     349,   990,   282,   187,   282,   285,  2324,   481,   497,   350,
     484,   485,   486,   319,   488,   489,   490,   491,   492,   493,
     379,   233,  1011,   331,   373,  3660,  3661,  3662,  3663,  3664,
     458,  1652,  1653,  1654,  1655,   331,  4114,  4115,  3838,    76,
      77,    78,    79,  2143,   323,   174,   437,   147,  1061,    76,
      77,    78,    79,   426,  1076,  1077,   359,   104,  1786,  1081,
    1788,  1682,  1683,   413,   437,   321,  1061,  1688,  1081,  1797,
     218,   986,  3981,   343,   330,   990,  1931,   254,   125,  3838,
      14,  2266,    76,    77,    78,    79,  1081,    76,    77,    78,
      79,   317,   331,   456,  1799,    76,    77,    78,    79,   379,
     182,   379,   184,  1808,  2852,   413,  3462,  2855,  2856,    85,
    3248,  2859,  4190,   342,    89,  1820,   391,   413,   281,   219,
     283,  2869,  1931,  3421,   253,   273,  3417,  2726,  3426,  1391,
      99,  3429,  1753,  1754,  1755,  1756,  1864,   500,    76,    77,
      78,    79,   319,   170,   448,   409,   410,  1562,    76,    77,
      78,    79,   110,   432,  4045,  4046,   340,  1862,  2050,  1181,
    1865,  1866,   254,   433,  1869,  3014,  2406,   215,  2353,  2354,
    2355,  2356,   142,  2143,   413,   481,  2414,   173,   484,   485,
     486,   330,   488,   489,   490,   491,   492,   493,    89,    71,
     470,   173,   421,   449,   118,  1276,    76,    77,    78,    79,
      37,  2126,   126,   161,  1619,  1826,   252,   182,  2968,   178,
     359,   187,  2972,  3042,   184,  2738,  3826,  3398,    85,  1471,
    1301,  3183,  2495,   227,    91,   173,  1276,   319,  2908,   458,
     312,  1276,  1553,   216,  1276,   231,    73,  1259,  4116,  2908,
    1553,  1263,  1264,  2650,  1266,    97,  2908,  2908,  2908,   231,
    1263,  1264,  1933,  1266,  1485,  1486,  2908,  1488,  3439,   242,
    3441,  1276,  4153,  1678,   412,  1306,   414,    25,  1263,  1264,
    2543,  1266,  1485,  1486,   257,  1488,   282,    35,   282,   285,
    1695,   182,  4014,   231,   267,  3068,  1301,   245,  3071,  3072,
    3073,  3074,  3075,  3076,  3077,  3078,  3079,  3080,  2400,  2572,
      76,    77,    78,    79,   481,   419,  3002,   484,   485,   486,
    1325,   488,   489,   490,   491,   492,   493,  2242,   170,  2937,
     187,   215,   411,  1738,   410,  2250,   307,  2252,   254,  1344,
      76,    77,    78,    79,  2607,   216,   294,  3768,   478,  2396,
     234,    76,    77,    78,    79,  3128,  3129,  2620,  2621,   273,
      76,    77,    78,    79,   330,  1428,  1429,   497,  1447,  1374,
       5,   389,  1451,  1452,   374,   123,   162,   456,   457,   374,
     484,  1393,   254,   379,  1461,   379,  1391,   141,  1575,  1794,
      25,  1403,   374,   359,   478,    71,   369,  1428,  1429,   481,
      35,   317,  1414,   485,   486,   330,   488,   489,   490,   491,
     492,   493,  1461,   497,  3974,   147,  1603,   171,   497,   437,
     372,   456,   924,   423,  1461,   495,   147,   103,   423,   377,
     456,   501,  1444,    87,   359,  1447,  2744,  2716,  1461,  1451,
    1452,   423,   944,   147,  1447,   170,  1525,   319,  1451,  1452,
     294,   478,   106,   239,  1506,  1507,  1505,  1506,  1507,  3747,
    1523,   478,  1447,  2427,   330,   500,  1451,  1452,  1505,  1506,
    1507,  1570,   457,   330,   500,   206,  2885,   321,   126,   210,
    1485,  1486,  1461,  1488,   238,   437,   330,   219,   123,  1566,
     475,  1590,  1523,   359,   478,   281,  1461,   283,   219,   478,
     248,  1553,   359,  1582,  1553,   330,   330,   478,  1560,  1588,
    2205,  1560,  2142,  1525,  1517,   219,  1553,  1566,   497,   182,
     342,   184,   170,  1560,  1623,   110,  1505,  1506,  1507,  1566,
    1515,   218,  1517,  1461,   359,   359,  1539,  1540,   363,   270,
    1505,   329,  4031,  1566,   175,   217,   372,   421,  1533,  1628,
     478,   186,  1631,  1632,  1539,  1540,  1461,  3295,   484,  1964,
     478,  3729,   387,  3301,  3302,  3303,  3304,  3305,  3306,   497,
     477,   243,   398,   499,  1553,   482,   161,  1505,   497,  1582,
    3353,  1560,   382,   314,  2981,  1588,   273,  1566,    72,    73,
     501,  1570,    76,    77,    78,    79,    80,  1582,   442,   421,
     163,  1566,  1681,  1588,   500,   210,  3556,   170,   478,   481,
     410,  1590,   381,   248,  4103,   246,   488,   489,   490,   491,
     492,   493,  4111,  1875,   229,  1628,  3023,  3340,  1631,  1632,
     498,   456,  1644,   501,   366,   381,   458,  2248,  1566,   302,
     382,   410,   484,  1628,  1623,   366,  1631,  1632,  2736,   312,
     450,  1111,  1795,   495,   302,   497,   498,   499,   500,   307,
     245,  1566,   366,  4152,   410,  1570,  1743,   350,   410,   501,
    2388,  3421,   303,   304,  1134,   444,  3426,   360,  1681,  3429,
     503,  2292,  2665,   165,  1144,  1590,   170,   456,  2299,  2300,
    2301,  2302,  2303,  2304,  1743,   343,  1681,  2633,   444,  3063,
     383,  3290,   498,    41,  1839,   501,  1743,   355,   450,   294,
    3838,  3108,   478,   359,   330,   439,  1879,   363,  1623,  2982,
    1743,  2636,  3893,  3087,   456,   412,   248,   414,   497,   210,
     359,   497,   147,   492,   363,   456,  1894,  1749,   497,   302,
     499,   387,   478,   359,  2589,   227,  3519,  3520,   229,  2060,
     381,   497,   456,   478,   169,  2450,  1768,  2060,   387,  3035,
     175,   497,   478,   450,  1743,  1604,   498,   251,  1607,   501,
     165,   387,  1893,   207,  3569,  3090,  3091,   498,  1743,   410,
     501,  1786,   216,   376,   199,   433,   412,   376,   414,   273,
    2589,  1662,   377,  1778,   498,   330,   163,   501,  3926,  2410,
     282,  2412,   492,   285,  3517,   133,   437,   497,  1647,   499,
     456,  2441,   140,   444,  1885,  1743,   495,  1829,   411,   116,
    1832,   376,   411,   502,   359,   456,  1829,   456,  3126,  1832,
     128,   246,   227,  1136,  3097,  1138,   399,   495,  1743,   402,
    1948,   499,  1145,  1951,  1829,  1885,  3514,  1832,   146,   146,
    1885,    71,   387,  1885,  2525,  2526,   411,   317,    16,  2530,
    2659,   159,   322,   456,   457,   378,   497,   456,   457,  1740,
    1875,   260,   412,    73,   414,  1746,    76,    77,    78,    79,
    1885,  4049,   206,   103,    34,   457,   210,   282,   108,  1966,
     285,   317,  1763,   419,  3632,  3633,   322,   379,  2569,  2570,
    2618,   456,   457,   475,   497,   202,  1918,   497,   497,   196,
      73,  2316,   210,    76,    77,    78,    79,  1966,  2085,   206,
    1250,   139,  3230,   210,   423,   497,  1911,  1912,   495,  1966,
     497,  1261,   499,     8,  1919,   232,    11,    12,  1923,  1924,
    3219,  3220,   497,  1966,    93,    94,   270,    22,    23,    24,
     500,    26,    27,  1938,   504,  1940,    31,    32,    33,   163,
     313,   175,   361,   250,   317,  1970,   381,   182,   500,   184,
    2907,   346,   504,   191,  3724,  1960,   496,  1962,   496,   495,
     500,   497,   500,   270,   379,   378,  2950,  1966,   470,   204,
     314,   144,   476,   477,   478,   410,   237,  3747,   482,   502,
    3773,  1966,   123,   124,   488,   489,  2085,  2542,  2060,  2544,
    2545,  2060,    72,    73,   234,   497,  2159,  2029,   490,   491,
     492,    73,   437,  2060,  3797,  3798,  2011,   314,   498,   444,
     500,   481,   246,  3872,   254,   255,   323,   498,  1966,   500,
     497,   456,   499,   456,   457,   263,   264,  2126,  3176,   115,
     229,  2130,  2109,   498,  2111,   500,   163,  2109,   276,  2111,
    2109,  1966,  2111,   498,  2143,   500,   363,   114,   365,  2074,
     367,  2476,  2109,   378,  2111,   470,   373,   500,   501,  2878,
    2157,  2060,   497,   380,   498,   305,   500,   302,   163,  2784,
     387,   498,   307,   500,   500,   501,   162,   312,   395,   319,
    2085,   498,   497,   500,   260,  2800,   403,  2906,  2157,  2804,
    3823,  2142,   330,   372,   373,  3311,  3312,  3855,  2130,  3315,
    2157,  3317,   498,  2126,   500,   498,   498,   500,   500,    71,
    2109,  2143,  2111,  2145,  2157,  2147,  2388,   497,  3226,   499,
    2143,  2126,  2145,   497,  2147,   432,  2223,   488,   489,   490,
     491,   492,   503,    95,   451,   372,   373,   498,  2143,   498,
    2145,   500,  2147,  2242,   498,   482,   500,   381,   151,  3919,
     236,  2250,   252,  2252,  2223,  2187,   456,   457,  2157,  3952,
     473,   474,   175,   182,   497,   184,  2223,   317,  3993,    71,
    3995,   114,  2157,   411,   104,   413,   410,   498,   472,   500,
    2223,   412,   256,   414,  2339,   204,  2255,   498,   320,   500,
     425,   498,   287,    95,   498,   281,   500,   283,  2255,   434,
     498,   103,   500,   437,   456,   457,   108,  3525,   294,  2157,
     444,   499,  2255,   216,   498,  3410,   500,   320,   498,  2242,
     500,  3504,   456,   498,  2223,   500,   498,  2250,   500,  2252,
    2968,    71,  2157,   246,  2972,  1311,  1312,  2242,  2223,   242,
     498,   481,   500,   329,   339,  2250,   317,  2252,   488,   489,
     490,   491,   492,   493,   257,    95,  2255,   477,   478,   479,
     480,   419,   482,   497,   267,   412,  2298,   414,   488,   489,
    2255,   498,  4042,   500,  2306,  2223,  3014,   498,   364,   500,
     317,   488,   489,   490,   491,   492,   472,   290,   307,   496,
       7,   304,   254,   312,   477,   478,   320,  3012,  2223,   482,
    2572,   104,    19,    20,   126,   472,   489,  2255,   498,   256,
     500,   397,    71,   498,   317,   500,   214,  2322,   140,  3034,
    2352,   387,    39,  2748,   498,    42,   500,   498,   230,   500,
    2255,   497,   234,   428,   151,   498,    95,   500,   498,   498,
     500,   500,   490,  2375,   103,     2,   500,  3646,   170,   108,
     172,   114,   254,   255,  2779,   498,  2781,   319,   498,   498,
     500,   500,   498,  2388,   500,   498,   369,   269,   381,   490,
    2613,  2614,   498,   498,   500,   500,   110,  3068,  2666,  2667,
    3071,  3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,  3080,
    2441,   498,   498,   500,   500,  2427,   221,   410,   503,   216,
     302,   503,   498,   305,   500,   230,   425,   498,   498,   500,
     500,   498,   501,   500,   254,   434,   248,   319,   152,   241,
     322,    78,  2668,  2669,   437,   242,   143,    84,  2853,  3248,
     498,   444,   500,   498,   497,   500,   439,  3128,  3129,  1789,
     257,   419,   176,   456,   498,   498,   500,   500,  1798,   498,
     267,   500,   498,  2550,   500,   419,  1806,  1807,  2555,  3777,
     117,   195,   498,   498,   500,   500,   183,   498,   498,   500,
     500,   230,   193,   290,  1824,   234,   498,   211,   500,   319,
     302,  2550,  4110,   419,   497,   307,  2555,   419,   498,   391,
     500,   225,   419,  2550,   151,   254,   255,  2922,  2555,   498,
     498,   500,   500,   160,   498,  3641,   500,  2550,    98,   114,
     269,  2936,  2555,   498,  3560,   500,   498,   439,   500,   481,
     248,   343,   484,   485,   486,  3808,   488,   489,   490,   491,
     492,   493,   498,   355,   500,  1078,  1079,  2636,   498,   254,
     500,   319,   498,   302,   500,   419,   305,  2572,  3263,  3264,
     207,  2550,   369,   498,   459,   500,  2555,   214,   497,   216,
     319,  2586,  2987,  3862,   498,  2550,   500,  1030,   499,  1032,
    2555,   228,  2973,   307,  2975,   499,   497,   497,   317,   481,
    2605,   315,   484,   485,   486,   210,   488,   489,   490,   491,
     492,   493,   501,  2618,   496,   268,   439,   317,   317,   311,
     502,   497,  2550,   378,  2636,   260,   497,  2555,   126,   456,
      98,   433,   497,  2636,   348,   459,   428,   104,   104,   330,
     260,   210,   502,  3048,   439,  2550,  2631,   200,   200,  2634,
    2555,  2636,   391,   497,   200,  3953,   459,   200,   200,   500,
     200,   481,  3067,   200,   484,   485,   486,   200,   488,   489,
     490,   491,   492,   493,   317,   200,   200,   200,   317,   200,
     200,   497,  3353,    98,   211,   268,   497,  3092,  3986,   497,
     497,    71,  3990,  3991,  3957,   210,   210,   339,   497,   497,
     327,   497,    98,  3421,   497,   153,   497,   497,  3426,   497,
     497,  3429,   497,   497,   500,    95,   497,   497,  3563,   497,
     497,  3126,   497,   481,   497,   362,   484,   485,   486,  2059,
     488,   489,   490,   491,   492,   493,   497,   497,   497,   268,
     497,   497,   481,   497,   497,   484,   485,   486,   254,   488,
     489,   490,   491,   492,   493,  3692,    98,  3987,   210,   396,
    3988,   210,   490,   248,  3563,   379,  2815,  2816,  2817,   285,
     500,   169,   438,    37,   500,   484,  2924,    14,  2815,  2816,
    2817,   497,   500,   419,   497,   497,   419,  2799,   499,   419,
     116,   419,  2815,  2816,  2817,   419,   380,   419,   317,  2878,
     419,   419,   307,   133,  4067,   317,   438,   239,   419,  2821,
     419,   497,   500,  2961,   439,  2958,   439,  2802,   419,   330,
     146,   419,   419,   114,   114,   419,   497,  2906,  2905,   419,
     321,   419,   419,   419,   317,   376,  2815,  2816,  2817,   419,
    2852,   419,   419,  2855,  2856,   317,   254,  2859,  3519,  3520,
    2815,  2816,  2817,   456,  2925,   447,  2905,  2869,    98,   497,
      87,    97,  2874,   497,   170,   439,  2878,   449,  2905,  2940,
     276,   497,  2884,    98,   254,  2878,   202,   450,   210,   317,
     497,    98,  2905,   499,  3136,   377,   453,  2815,  2816,  2817,
    2961,   200,   439,  2878,  2906,   200,   200,   200,  2883,  2884,
     439,    14,   419,  2906,   500,   366,   232,  2919,  2525,  2526,
    2815,  2816,  2817,  2530,   444,  3138,  3139,  3140,  3141,   306,
    2925,  2906,  3617,  3618,  3907,  3620,  2905,   215,   417,   497,
      85,  3973,   287,   287,  3973,  2940,    91,  2949,  2950,   319,
    2905,  4171,   452,    71,   472,   500,   387,   417,   497,   497,
    3021,   228,  2569,  2570,   419,   215,  2961,   421,   484,   228,
     318,  3366,   500,  2968,    72,   500,   498,  2972,    76,    77,
      78,    79,    80,   312,   250,   130,   484,  2905,   500,    34,
     498,   618,    10,   270,   419,   498,   419,   792,   376,   498,
     139,   258,   797,   497,   799,   258,   497,  3842,   798,   804,
    2905,   806,   802,   317,   330,   307,  3724,   812,  3619,   307,
     307,   811,   324,   500,   315,   820,  3021,   419,   359,   359,
     825,   359,   827,   384,  3101,   180,   419,   419,   350,  3747,
     254,    98,   187,   359,   254,   190,   836,   363,   254,  3838,
     840,   367,   439,  3842,   439,  3740,   254,   373,   254,   315,
     484,   851,  3101,    97,   380,  3750,   495,   165,   495,   419,
    4150,   387,   419,   210,  3101,   484,   212,   872,   497,   395,
     199,   384,   877,    98,   317,  2405,   226,   403,  3101,   884,
     223,   491,   226,   210,   239,   497,   500,    98,   200,  2419,
    2420,   317,   384,  2423,  3261,   317,   210,   459,    86,  2429,
    3112,   481,  3773,   410,   484,   485,   486,   284,   488,   489,
     490,   491,   492,   493,   500,   220,  4206,   317,   500,   227,
    3525,   114,  3101,  3841,   498,   451,  3797,  3798,   498,   498,
     215,  3136,   498,   938,   498,  4072,  3101,   500,   943,   294,
     215,  4231,  3154,   472,   472,   498,   498,   784,   498,   954,
     498,   788,   498,   498,  3872,   792,    14,   419,  2488,   453,
     797,   498,   498,   498,   498,   498,   497,   326,   206,  3248,
    3247,   498,  3249,  3101,   282,   330,   497,   285,   501,   270,
     985,   500,  3261,   500,  3589,   484,   442,   498,   419,   497,
     827,   244,  3597,   270,   334,   334,  3101,   497,  3247,  1004,
    3249,  3919,   436,   307,   359,  1010,   419,   140,   363,   279,
    3247,   279,  3249,   279,   419,   419,   419,   419,  3203,   254,
     419,   419,   419,  1028,  3247,   254,  3249,  3276,   254,   285,
     254,   254,   387,   870,   254,   254,  3248,   495,   270,  3276,
     877,   498,  3937,   498,   428,  3248,   484,   884,   321,   163,
    3262,   361,   497,  3276,   498,   315,   317,  3269,   500,  3271,
     439,   419,   497,  3248,   497,   317,   498,   904,  3247,   312,
    3249,   379,   257,   257,   325,   439,  3261,   439,   320,   500,
     198,  3952,  3247,  3295,  3249,   218,   198,   193,   495,  3301,
    3302,  3303,  3304,  3305,  3306,   215,    71,  3276,   449,   210,
     124,   497,  3997,  4021,   237,   498,   498,  3918,   498,   498,
     215,  3276,  3923,  3924,   222,   500,   484,   498,   484,  3247,
    3323,  3249,   497,  3335,  4042,   244,   318,   484,   428,   428,
     419,   419,  3344,  3345,  3346,  3347,   419,  3322,  3323,   419,
     273,   210,  3247,   980,  3249,   498,  3331,  3752,  3276,   986,
    3335,  1156,   254,   990,   254,   258,   498,   498,  1163,  3344,
     498,   496,   470,   497,   456,   497,    98,   210,   476,   459,
     478,  3276,  3777,   240,  1011,    71,   135,   456,   411,   497,
     456,   500,  1019,  3994,  3396,  3996,   497,  2717,   481,   322,
     497,   257,   498,   384,   497,   497,   219,   215,   215,   497,
    3567,   498,   498,  1208,  1209,  1210,  3573,   103,   454,  1214,
     114,   498,   108,   454,   500,   224,  3421,  4135,   428,   307,
    3587,  3426,   307,   200,  3429,  2755,  2756,   484,   500,    98,
     177,   500,  4043,   254,   307,   172,   241,   496,   217,   215,
     439,   439,   188,   199,   498,   259,   215,   116,   497,   497,
     419,  3068,   497,   210,  3071,  3072,  3073,  3074,  3075,  3076,
    3077,  3078,  3079,  3080,   320,   215,   497,   497,   443,   396,
     333,   498,   455,   355,   439,   456,   498,   146,    98,   412,
     498,   414,   497,   497,   210,   307,   280,   500,  3567,  4100,
     423,   163,  1297,   237,  3573,   347,   373,   373,  4109,   195,
     433,  3668,  4220,   126,   320,   126,   484,   114,  3587,   210,
     323,  3128,  3129,   411,   318,  1320,   317,   205,   320,  1156,
     320,   456,   481,   500,    98,   353,  1163,   443,  4139,   500,
     456,   188,   317,   202,   230,   317,    98,   497,   234,   183,
     497,   372,   498,   175,  3556,  3557,   437,  1184,  3953,   199,
      84,    95,   372,  3556,   347,   497,   354,  3569,   254,   255,
    2338,  1452,  2636,   232,  2229,  2749,  3569,  4108,  3247,  2874,
    3858,  3556,  3383,   269,  2208,  3235,  3386,  1214,  3685,  2713,
      71,  3986,  3567,  2446,  3569,  3990,  3991,  4134,  3573,  3668,
    4170,   260,  4097,  4096,  4142,  1764,  2941,  2177,  3388,  3395,
    3276,  2816,  3587,  2326,    95,  1750,  4231,  2918,  4206,   305,
    3595,  3596,   103,  3654,  3653,  3600,  3601,   108,  2905,  2877,
    3632,  3633,  4149,   319,  3844,  3696,  1263,  1264,  4079,  1266,
    1741,  3643,  3644,  3847,   186,  3647,  3648,  1274,  1299,  3455,
    3397,  3919,  4042,  2200,  4194,  3694,  3401,  4049,  3660,  3661,
    3662,  3663,  3664,  1458,  4230,  3894,  2986,  3694,  1001,  2069,
    2990,   163,  2992,  1482,  2994,  2995,  1276,  3022,  3381,  2647,
    1307,  3694,  1276,  3003,  2439,  3660,  3661,  3662,  3663,  3664,
    3450,  2656,  2103,  3668,  3567,  2102,  3202,  2670,  1477,  1495,
    3702,  3696,  1329,  2063,   363,   391,  1021,  2088,   367,  2388,
    2974,  2618,  3748,    71,   373,   872,  3036,  2648,  3378,  3111,
    3955,   380,  3103,  4128,  1010,  3694,  3728,  4129,   387,  4132,
    1357,  2586,  2659,  2497,  2584,  2465,   395,    95,  2958,  3694,
    1996,  1276,   618,  1219,   403,   103,  3353,  2381,  1780,   230,
     108,  1507,  3747,   234,  2130,  4122,   363,  2106,  1099,  1501,
     906,  1388,  1389,  2143,  1391,    98,  1306,  2136,  3206,  3838,
    2137,  1079,  3207,   254,   255,  1425,  3694,  1404,  2630,  3181,
    1505,  1408,  3555,   116,  2442,  1856,   395,  3434,   269,  2147,
       2,  1263,   451,    -1,    -1,   481,   455,   456,    -1,  3694,
      -1,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   146,  1609,    -1,    -1,    -1,    -1,    -1,
    1447,   302,    -1,    -1,   305,  3818,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1460,  1461,    -1,  3838,    -1,   319,    -1,
      -1,   322,    -1,  3818,    -1,  3838,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3855,    -1,    -1,    -1,  3859,    -1,    -1,
    1487,  1656,    -1,  3838,  1491,  1492,    -1,    -1,    -1,   202,
    1660,    -1,   230,    -1,    -1,    -1,   234,    -1,  1505,  1506,
    1507,  1676,    -1,    -1,    85,    -1,  3947,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    -1,    -1,   254,   255,    -1,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   269,  3519,  3520,  3916,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1553,   260,    -1,   130,
      -1,    -1,    -1,  1560,    -1,  1562,    -1,    -1,    -1,  1566,
      -1,    -1,    -1,  1570,   302,    -1,    -1,   305,    -1,    -1,
      -1,    -1,  3947,    -1,    -1,    -1,    -1,  1747,    -1,    -1,
      -1,   319,    -1,  1590,   322,    -1,    -1,    -1,  4210,    -1,
    1597,    -1,  1762,    -1,    -1,  4014,    -1,    -1,    -1,   180,
      -1,    -1,  4051,    -1,    -1,    -1,   187,  4014,    -1,   190,
      -1,  1786,  1619,  1788,    -1,    -1,  1623,    -1,    -1,    -1,
     481,  4014,  1797,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,  1810,    -1,    -1,    -1,   500,
      -1,    -1,    -1,    -1,  1819,    -1,    -1,    -1,    -1,    -1,
     363,  1821,    -1,   391,   367,    -1,    -1,    -1,   239,    -1,
     373,    -1,    -1,    -1,    -1,  4014,    -1,   380,    -1,    -1,
      -1,  1678,    -1,    -1,   387,    -1,    -1,    -1,    -1,  4014,
      -1,    -1,   395,    -1,    -1,    -1,    -1,    -1,  1695,  1864,
     403,    -1,  1867,  1868,    -1,    -1,  4051,    -1,    -1,    -1,
      -1,    -1,    -1,    71,  1879,    -1,  1713,    -1,    -1,    -1,
      -1,    -1,    -1,   294,    -1,    -1,  4014,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1738,    -1,    -1,    -1,   103,  1743,  3437,   451,  4014,
     108,    -1,   455,   481,  3444,  3445,   484,   485,   486,   330,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    85,
      -1,    -1,   500,    -1,    -1,    91,    -1,    -1,  4150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4150,   359,  1786,
      -1,  1788,   363,    -1,    -1,    -1,  3773,  1794,    -1,    -1,
    1797,    -1,    -1,    85,    -1,  4150,    -1,    -1,    -1,    91,
      -1,    -1,    -1,    -1,   130,    -1,   387,    -1,    -1,    -1,
    3797,  3798,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4194,
    1995,    -1,  1829,    -1,  4206,  1832,    -1,   195,    -1,    -1,
      -1,    -1,    -1,  4206,    -1,  4210,    -1,    -1,   130,    -1,
      -1,    -1,    -1,    -1,    -1,  2020,    -1,    -1,    -1,  4231,
      -1,  4206,    -1,    -1,   180,  4230,    -1,  1864,  4231,    -1,
      -1,   187,   230,    -1,   190,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   254,   255,   180,    -1,
      -1,    -1,  1899,  1900,  2069,   187,    -1,    -1,   190,    -1,
    1907,   269,    -1,  1910,    -1,    -1,  1913,    -1,    -1,    -1,
      -1,  1918,    -1,   239,  1921,  1922,    -1,    -1,    -1,    -1,
      -1,    -1,  1929,    -1,  1184,  1932,  1933,  1934,  1935,    -1,
      -1,    -1,    -1,    -1,    -1,  1942,  1943,   305,  1945,    -1,
    1947,    -1,    -1,  1950,    -1,    -1,    -1,   239,    -1,    -1,
      -1,   319,    -1,    -1,    -1,    -1,    -1,  1964,  1965,  1966,
      -1,    -1,  1969,    -1,    -1,  3952,  1973,    -1,   294,    -1,
    1977,    -1,    -1,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,    -1,  1990,  2154,     3,    -1,    -1,  2158,  1996,
      -1,     9,    -1,  2000,    -1,    13,    -1,    15,    -1,    17,
      18,    -1,   294,  2173,   330,    -1,    -1,    -1,    -1,    -1,
      28,  2181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   391,    -1,    -1,    -1,    45,    46,    -1,
      -1,    -1,    -1,   359,  2204,    -1,    -1,   363,   330,    -1,
      -1,    -1,    -1,    -1,    -1,  2220,    71,  1307,    -1,    -1,
      -1,  2221,    -1,  2060,    -1,    -1,  3756,    -1,  3758,  3759,
      -1,   387,    -1,    81,  2071,    -1,  2236,  3767,  2238,    -1,
      95,   363,    -1,    91,    -1,    93,    94,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,  2256,    -1,    -1,   107,
      -1,    -1,    -1,  2263,    -1,   387,    -1,    -1,    -1,    -1,
    2270,    -1,  2109,    -1,  2111,    -1,    -1,  2277,    -1,   127,
      -1,   129,   130,   481,    -1,    -1,   134,   135,    -1,    -1,
     488,   489,   490,   491,   492,   493,    -1,   145,    -1,   147,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2145,    -1,
    2147,    -1,    -1,    -1,    -1,    -1,   164,    -1,   166,    -1,
    2157,   169,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
      -1,  2336,    -1,   181,    -1,    -1,    -1,  2174,    -1,   187,
      -1,    -1,    -1,    -1,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,    -1,   201,    -1,    -1,    -1,  2194,   206,    -1,
      -1,    -1,  2199,  2200,    -1,  2370,    -1,    -1,    -1,    -1,
      -1,   219,  2377,    -1,    -1,   230,    -1,    -1,    -1,   234,
      -1,    -1,    -1,  2388,    -1,    -1,  2223,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   246,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,  2255,    -1,
    3950,    -1,    -1,   271,   272,    -1,    -1,    -1,    -1,   277,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,    -1,    -1,    -1,    -1,    -1,   304,    -1,  2458,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,    -1,
      -1,    -1,  1562,    -1,    -1,    -1,    -1,  2314,    -1,  2316,
      -1,    -1,    -1,    -1,    -1,    -1,  2486,    -1,    -1,    -1,
      -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   352,    -1,    -1,  1597,   356,    -1,
     358,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,
     368,    -1,    -1,   371,    -1,    -1,    -1,   375,    -1,  1619,
      -1,    -1,    -1,   381,    -1,    -1,   391,    -1,    -1,   387,
      -1,  2378,   390,    -1,    -1,    -1,    -1,    -1,    -1,   397,
      -1,  2388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     799,  2398,   410,    -1,    -1,   804,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   812,    -1,    -1,    -1,    -1,   426,    -1,
     428,   820,    -1,    -1,    -1,    -1,   825,   435,  1678,   437,
      -1,    -1,   440,    -1,    -1,    -1,   444,    -1,  2435,    -1,
      -1,    -1,    -1,    -1,    -1,  1695,    -1,  2612,   456,    -1,
      -1,    -1,    -1,  2618,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1713,    -1,    -1,   481,    -1,  2465,   484,
     485,   486,    71,   488,   489,   490,   491,   492,   493,  2476,
      -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,  1738,   497,
      -1,    -1,    -1,    -1,    -1,    71,    95,    -1,  2495,  2496,
    2665,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,  2525,  2526,
      -1,    -1,   108,  2530,    -1,    -1,    -1,    -1,    -1,   938,
      -1,  2701,    71,    -1,  1794,  2542,  2543,  2544,  2545,    -1,
      -1,    -1,    -1,  2550,    -1,   954,    -1,  2554,  2555,    -1,
    2557,    -1,  2559,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      -1,    -1,  2569,  2570,   103,  2572,    -1,    -1,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,   985,    -1,  2585,    -1,
    2587,    -1,    -1,    -1,  2591,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1004,    -1,    -1,    -1,    -1,
    2607,    -1,    -1,    86,    -1,    -1,    71,    -1,    -1,   195,
      -1,  2618,  2782,  2620,  2621,  2622,    -1,    -1,    -1,  1028,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      95,    -1,    -1,  2640,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,  2649,   108,   230,   254,   255,    -1,   234,  2656,
      -1,    -1,    -1,    -1,  2661,    -1,   139,    -1,    -1,    -1,
     269,  2668,  2669,  2670,    -1,   148,   149,   150,   254,   255,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2847,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,   302,    -1,   234,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1964,  2712,    -1,    -1,    -1,   192,
     319,    -1,    -1,   322,    -1,   254,   255,    -1,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     269,  2738,  2739,   319,  2741,    -1,    -1,    -1,    -1,    -1,
      -1,  2748,  2917,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   234,  2927,    -1,    -1,    -1,   239,    -1,    -1,    -1,
      -1,    -1,    -1,   302,    -1,   230,   305,    -1,  2943,   234,
      -1,    -1,  2779,    -1,  2781,    -1,    -1,    -1,    -1,    -1,
     319,    -1,   391,   322,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,    -1,  2968,    -1,   278,    -1,  2972,    -1,  1208,
    1209,  1210,    -1,    -1,   269,   391,    -1,    -1,  2815,  2816,
    2817,    -1,   295,   296,   297,   298,   299,    -1,   301,    -1,
      -1,  2996,    -1,    -1,  2999,    -1,    -1,    -1,    -1,    -1,
      -1,  3006,  3002,    -1,    -1,    -1,    -1,   302,    -1,  3014,
     305,    -1,    -1,    -1,    -1,  3015,  2853,    -1,    -1,    -1,
      -1,   334,   391,    -1,   319,    -1,    -1,   322,    -1,    -1,
    3035,    -1,    -1,    -1,    -1,    -1,    -1,  3037,    -1,    -1,
    2877,  2878,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,   370,  1297,   498,
      -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,  2905,  2906,
      -1,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,  1320,    -1,    -1,    -1,  2922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   406,    -1,   408,   391,    -1,    -1,  2936,
      -1,    -1,    -1,    -1,  2194,    -1,    -1,    -1,    -1,  2199,
    2200,    -1,   481,    -1,  2951,   484,   485,   486,   431,   488,
     489,   490,   491,   492,   493,   438,    -1,    -1,   441,   498,
      -1,  2968,    -1,    -1,    -1,  2972,    -1,    -1,  3143,  3144,
      -1,    71,    -1,    -1,    -1,  2982,    -1,    -1,    -1,    -1,
    2987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,  3014,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,  3045,    -1,
      -1,  3048,    -1,    -1,    -1,    -1,    -1,  3054,    -1,  1458,
      71,    -1,    -1,  3060,  3224,  3062,  2316,    -1,    -1,    -1,
    3067,  3068,    -1,    -1,  3071,  3072,  3073,  3074,  3075,  3076,
    3077,  3078,  3079,  3080,    95,    -1,    -1,  3084,  3085,    -1,
      -1,    -1,   103,    -1,    -1,  3092,    -1,   108,    -1,    -1,
    3097,    -1,    -1,    -1,  3101,    -1,  3103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3113,    -1,    -1,  3116,
      -1,  3118,    -1,  3283,    -1,  3285,    -1,    -1,  2378,  3126,
    3127,  3128,  3129,    -1,    -1,    -1,  3133,    -1,    -1,  3136,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,  3146,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,  3155,    -1,
      -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,  3341,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3359,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   146,    -1,  3371,    -1,    -1,    -1,
    1609,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,  2476,    -1,    -1,   319,
      89,    -1,   322,    -1,    -1,    94,    -1,    96,    -1,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,   106,    -1,    -1,
    3247,  3248,  3249,    -1,    -1,    -1,  3421,  1656,   269,    -1,
     202,  3426,    -1,    -1,  3429,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,  1676,    -1,  3276,
      -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,   147,
     232,   302,   151,   152,   305,  3455,   155,    -1,    -1,    -1,
      -1,   391,   161,    -1,    -1,    -1,   165,    -1,   319,    -1,
     169,   322,    -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,
      -1,    -1,    -1,    -1,   183,    -1,    -1,   186,    -1,    -1,
      -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   202,    -1,    -1,    -1,   206,   206,   208,
      -1,    -1,   210,   212,    -1,    -1,  3353,   215,    -1,    -1,
      -1,   219,    -1,    -1,   222,    -1,   224,    -1,    -1,  3366,
     229,  3536,  3537,  3538,  3539,    -1,   235,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   481,   250,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,  3401,  3402,  3403,    -1,   498,    -1,
      -1,  1810,   270,    -1,    -1,    -1,    -1,    -1,    71,    -1,
    1819,   363,    -1,    -1,  3421,   367,    -1,    -1,    -1,  3426,
      -1,   373,  3429,  3593,    -1,    -1,    -1,    -1,   380,    -1,
      -1,    -1,    95,    -1,  3604,   387,    -1,    -1,    -1,    -1,
     103,    -1,    -1,   395,    -1,   108,   314,    -1,    -1,    -1,
      -1,   403,    -1,    -1,    71,   323,    -1,    -1,  1867,  1868,
     481,  3468,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,   498,  2738,  2739,
      -1,  2741,    -1,    -1,    -1,    -1,   103,    -1,  2748,    -1,
      -1,   108,    -1,    -1,    -1,    -1,    -1,  3504,   366,   451,
      -1,    -1,    -1,   455,  3511,  3512,    -1,  3514,    -1,    -1,
      -1,    -1,  3519,  3520,    -1,    -1,    -1,  3524,  3525,  2779,
      -1,  2781,    -1,  3530,  3531,    -1,    -1,  3534,    -1,    -1,
     399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   410,    -1,    -1,    -1,    -1,  3554,    -1,  3724,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3569,    -1,   432,    -1,    -1,   230,    -1,    -1,
      -1,   234,  3747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3589,    -1,    -1,   453,  1995,   455,   456,    -1,
    3597,   254,   255,  2853,    -1,    -1,    -1,    -1,  3768,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
      -1,  2020,    -1,   230,    -1,    -1,    -1,   234,  2878,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   495,    -1,    -1,
     498,   499,    -1,   501,    -1,    -1,    -1,   254,   255,   302,
      -1,    -1,   305,    -1,    -1,    -1,  2906,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   319,    71,    -1,   322,
    2069,    -1,  2922,    -1,    -1,    -1,  3841,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2936,  3684,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,    -1,  3694,   305,   103,
      -1,  2951,    -1,    -1,   108,    -1,    -1,  3872,    -1,    -1,
      -1,    -1,   319,    -1,    -1,    -1,  3881,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3724,    -1,    -1,
      -1,    -1,  3729,    -1,    -1,    -1,    -1,  2987,   391,    -1,
      -1,    -1,  3907,    -1,    -1,    -1,  3743,    -1,    -1,    -1,
    3747,    -1,    -1,    -1,  3919,  3752,    -1,    -1,    -1,   618,
      -1,    -1,    -1,    -1,    -1,    -1,  3931,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3773,    -1,    -1,    -1,
    3777,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3048,    -1,
    3797,  3798,    -1,    -1,  3801,    -1,   665,   666,    -1,    -1,
      -1,  3808,  3809,    -1,    -1,  3980,    -1,  3067,    -1,    -1,
     679,  2220,    -1,    -1,    -1,    -1,   230,    -1,   481,    -1,
     234,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,  3838,  3092,    -1,  3841,   498,    -1,    -1,    -1,    -1,
     254,   255,    -1,    -1,    -1,    -1,  4021,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,  1184,    -1,
      -1,    -1,    -1,    -1,   481,  3872,  3126,  4042,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,
      -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1184,   319,    -1,    -1,   322,    -1,
      -1,    -1,  3919,  3920,    -1,    -1,    -1,    -1,    -1,  3926,
      -1,    -1,    -1,    -1,   793,   794,   795,  2336,    -1,   798,
      -1,   800,    -1,   802,   803,    -1,   805,    -1,   807,    -1,
     809,   810,   811,    -1,    -1,  3952,  3953,    -1,  3955,    -1,
    3957,   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   828,
    4135,  2370,   831,    -1,   833,    -1,    -1,   836,  2377,   838,
      -1,   840,   841,   842,   843,    -1,  3983,   391,   847,  3986,
     849,  1307,   851,  3990,  3991,    -1,    -1,    -1,  3248,    -1,
      -1,    -1,    -1,    -1,    -1,   864,    -1,   866,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4014,    -1,   878,
      -1,    -1,   881,    -1,  4021,    -1,   885,    -1,   887,    -1,
     889,   890,    -1,    -1,   893,    -1,   895,  1307,   897,    -1,
     899,    -1,    -1,   902,    -1,  4042,    -1,    -1,    -1,    -1,
      -1,    -1,  4049,    -1,  4051,  4220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   924,   925,    -1,    -1,    -1,
    4067,    -1,    -1,    -1,    71,    -1,    -1,   481,    -1,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      71,   950,    88,   952,   498,    -1,   955,    -1,    95,    -1,
      -1,    -1,    -1,    -1,   100,    -1,   103,    -1,    -1,    -1,
      -1,   108,    -1,    -1,    95,    -1,  3366,    -1,    -1,    -1,
      -1,    -1,   103,   982,   120,   984,    -1,   108,    -1,   988,
      -1,  1447,    -1,    -1,    -1,    -1,    -1,    -1,  4135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,    -1,
      -1,  3401,    -1,    -1,    -1,    -1,  1015,    -1,    -1,    -1,
      -1,    -1,  1021,    -1,    -1,    -1,    -1,    -1,   164,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   185,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2612,    -1,    -1,   212,  1076,  1077,    -1,
      -1,   217,    -1,  4220,    -1,    -1,   222,    -1,    -1,    -1,
    1089,    -1,  1091,   230,    -1,    -1,  1095,   234,    -1,    -1,
      -1,   237,    -1,    -1,    -1,    -1,  1562,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,   254,   255,  1118,
    1119,    -1,    -1,    -1,  3514,    -1,  2665,    -1,    -1,    -1,
      -1,    -1,   269,   254,   255,  3525,    -1,    -1,    -1,    -1,
      -1,  1597,    -1,    -1,    -1,    -1,    -1,  1146,   269,    -1,
      -1,    -1,  1562,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1159,    -1,    -1,  1619,    -1,   302,    -1,  1166,   305,  1168,
      -1,    -1,    -1,    -1,    -1,  1174,    -1,    -1,    -1,  1178,
      -1,   302,   319,   319,   305,   322,  1185,  1597,    -1,    -1,
      -1,    -1,    -1,   329,    -1,  1194,  1195,    -1,   319,  3589,
      -1,   322,    -1,    -1,    -1,    -1,    -1,  3597,    -1,  1619,
     346,    -1,    -1,  1212,  1213,    -1,  1215,  1216,    -1,    -1,
      -1,    -1,  1678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,   374,  1695,
     376,  1240,  1241,    -1,    -1,  1244,   382,    -1,   384,    -1,
      -1,    -1,    71,    -1,   391,    -1,    -1,  1713,    -1,    -1,
    1259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1678,    -1,
     391,    -1,    -1,    -1,   410,   411,    95,    -1,    -1,   415,
      -1,    -1,  1738,    -1,   103,  1695,  1285,   423,    -1,   108,
      -1,    -1,   428,  1292,  1293,    -1,    -1,    -1,    -1,  1298,
    1299,    -1,   438,  1713,    -1,  1304,    -1,    -1,    -1,    -1,
    1309,    -1,    -1,    -1,   450,    -1,    -1,    -1,  1317,    -1,
      -1,    -1,  1321,    -1,  1323,    -1,    -1,    -1,  1738,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1794,  3729,
      -1,    -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
     481,   498,  3752,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,   498,  2917,    -1,
      -1,    -1,    -1,    -1,  1794,    -1,    -1,  3777,  2927,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2943,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1428,
    1429,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1444,    -1,    -1,  3838,    -1,
     269,    -1,  1451,  1452,    -1,    -1,    -1,  2996,    -1,    -1,
    2999,    -1,    -1,    -1,    -1,    71,    -1,  3006,  1467,    -1,
    1469,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1477,  1478,
      -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,    95,
      -1,    -1,    -1,    -1,    -1,    -1,  3035,   103,    -1,    -1,
     319,    -1,   108,   322,    -1,    -1,    -1,    -1,  1964,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1523,    -1,  1525,    71,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3926,    85,    -1,    -1,
      -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    -1,    -1,  1964,    -1,  1555,    -1,    -1,   103,
      -1,    -1,    -1,  3953,   108,    -1,    -1,   115,    -1,    -1,
      -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1580,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3986,    -1,    -1,    -1,
    3990,  3991,    -1,    -1,  3143,  3144,    -1,    -1,    -1,    71,
      -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1621,    -1,   230,    -1,    -1,    -1,   234,    -1,
      -1,    -1,   180,    -1,    -1,    -1,    -1,    -1,    -1,   187,
      -1,   103,   190,    -1,    -1,    -1,   108,    -1,   254,   255,
      -1,    -1,    -1,  1652,  1653,  1654,  1655,    -1,    -1,  4049,
      -1,  1660,   481,   269,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,  1674,    -1,    -1,    -1,   498,
      -1,    -1,    -1,  1682,  1683,    -1,   230,    -1,   236,  1688,
     234,   239,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,
     254,   255,    -1,   319,    80,    -1,   322,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    95,
      -1,    -1,    98,   281,    -1,   283,    -1,   103,  2194,    -1,
    1739,    -1,   108,  2199,  2200,    -1,   294,    -1,  1747,    -1,
      -1,    -1,  1751,    -1,  1753,  1754,  1755,  1756,   302,    -1,
      -1,   305,    -1,  1762,    -1,    -1,    -1,    -1,   230,  1768,
      -1,  1770,   234,    -1,    -1,   319,    -1,    -1,   322,    -1,
      -1,   329,   330,    -1,  2194,   391,    -1,    -1,    -1,  2199,
    2200,    -1,   254,   255,    -1,    -1,  1795,  1796,    -1,    -1,
    1799,  1800,  3341,    -1,    -1,    -1,  1805,   269,    -1,  1808,
    1809,   359,  1811,    -1,  1813,   363,   364,    -1,    -1,  1818,
    3359,  1820,  1821,    -1,    -1,    -1,  1825,  1826,    -1,    -1,
      -1,    -1,  3371,    -1,    -1,    -1,    -1,    -1,    -1,   387,
     302,  1840,  1841,   305,    -1,    -1,    -1,   391,    -1,   397,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,  1857,    -1,
    2316,    -1,    -1,  1862,   230,    -1,  1865,  1866,   234,    -1,
    1869,    -1,    -1,    -1,    -1,   481,  1875,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,   254,   255,
      -1,    -1,   498,    -1,  1893,  1894,    -1,    -1,  1897,    -1,
      -1,    -1,    -1,   269,    -1,    -1,  2316,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2378,    -1,    -1,    -1,    -1,    -1,    -1,   391,
      -1,    -1,  1931,    -1,    -1,    -1,   302,   481,    -1,   305,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,   496,   319,    -1,    -1,   322,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3536,  3537,  3538,
    3539,    -1,    -1,  2002,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
    2476,    -1,   484,   485,   486,   391,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2062,    -1,    -1,  2476,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     476,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,  2130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2142,    -1,    -1,    -1,  1184,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2154,  2155,    -1,    -1,  2158,
    2159,  2160,    -1,    -1,    -1,  2164,    -1,    -1,    -1,    -1,
      -1,  2170,    -1,    -1,  2173,    -1,    -1,  2176,    -1,    -1,
      -1,    -1,  2181,  2182,    -1,    -1,    -1,    -1,  2187,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2204,  2205,    -1,    -1,  2208,
    2209,  2210,  2211,  2212,  2213,  2214,    -1,    -1,  2217,  2218,
      -1,    -1,  2221,  2222,    -1,    -1,  2225,    -1,    -1,    -1,
      -1,  2230,  2231,    -1,    -1,    -1,    -1,  2236,    -1,  2238,
    2239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2248,
    2249,    -1,  2251,    -1,    -1,    -1,    -1,  2256,    -1,    -1,
      -1,  2260,  2261,  2262,  2263,  2264,    -1,    -1,    -1,    -1,
    1307,  2270,  2271,  2272,    -1,    -1,    -1,    -1,  2277,    -1,
    2279,  2280,  2738,  2739,    -1,  2741,    -1,    -1,    -1,    -1,
      -1,    -1,  2748,  2292,    -1,    -1,    -1,    -1,    -1,    -1,
    2299,  2300,  2301,  2302,  2303,  2304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1184,    -1,    -1,    -1,
      -1,    -1,    71,  2779,    -1,  2781,    -1,    -1,  2738,  2739,
      -1,  2741,    -1,  2332,    -1,    -1,    -1,    -1,  2748,    -1,
      -1,  2340,  3881,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      99,    -1,    71,    -1,   103,    -1,    -1,    -1,    -1,   108,
      -1,    -1,    -1,    -1,    -1,  2364,    -1,    -1,  3907,  2779,
      -1,  2781,  2371,    -1,    -1,    -1,    95,    -1,    -1,    98,
      -1,    -1,  2381,    -1,   103,    -1,    -1,    -1,    -1,   108,
    2389,    -1,  3931,    -1,  2393,  2394,    -1,  2853,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2410,  2411,  2412,  2413,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2878,    -1,    -1,    -1,    -1,    -1,  2427,   178,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1307,
      -1,  3980,  2441,  2853,    -1,    -1,    -1,  2446,    -1,    -1,
    2906,  2450,    -1,    -1,    -1,   117,    -1,    -1,    -1,  2458,
      -1,    -1,    71,    -1,    -1,    -1,  2922,    -1,  2878,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2936,   230,    -1,  2482,    -1,   234,    95,  2486,    -1,    -1,
      -1,    -1,    -1,    -1,   103,  2951,  2906,    -1,   160,   108,
      -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,   230,  2922,    -1,    -1,   234,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,  1562,  2936,    -1,    -1,    -1,
      -1,  2987,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,  2951,    -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,
     269,    -1,   214,   302,   216,    -1,   305,    -1,    -1,    -1,
    1597,  2560,    -1,    -1,    -1,    -1,   228,    -1,    -1,    -1,
     319,    -1,    -1,   322,    -1,    -1,    -1,  2987,    -1,    -1,
      -1,    -1,  1619,   302,    -1,    -1,   305,    -1,    -1,    -1,
    2589,    -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,   210,    -1,   322,    -1,    -1,   215,    -1,    -1,    -1,
      -1,  3067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3092,  2636,  3048,    -1,
      -1,  1678,   391,    -1,    -1,   254,   255,    -1,  2647,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3067,  1695,    -1,
     269,    -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,
    3126,    -1,   391,    -1,    -1,    -1,  1713,    -1,    -1,    -1,
      -1,    -1,  3092,    -1,    -1,    -1,    -1,    95,    -1,    -1,
     439,    -1,    -1,   302,  1562,   103,   305,    -1,    -1,    -1,
     108,  1738,  2701,  2702,  2703,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,   322,    -1,    -1,  3126,  2716,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,  1597,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,  1619,    -1,    -1,    -1,    -1,    -1,  1794,  2757,  2758,
    2759,  2760,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   391,  2782,    -1,  2784,    -1,    -1,    -1,    -1,
      -1,    -1,  3248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2800,    -1,    -1,    -1,  2804,    -1,    -1,    -1,    -1,
    1678,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,   234,  1695,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3248,    -1,
      -1,    71,    -1,    -1,  2843,  1713,   254,   255,  2847,  2848,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2857,  2858,
      -1,   269,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
    1738,    -1,   481,   103,    -1,   484,   485,   486,   108,   488,
     489,   490,   491,   492,   493,  2884,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3366,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2923,  2924,  1794,  1964,    -1,    -1,
      -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2941,    -1,    -1,  3401,    -1,    -1,    -1,    -1,
      -1,  2950,    -1,    -1,    -1,    -1,  3366,    -1,    -1,  2958,
      -1,    -1,  2961,  2962,    -1,    -1,  2965,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2978,
      -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,  2988,
      -1,  3401,    -1,    -1,    -1,    -1,   404,    -1,    -1,    -1,
     230,    -1,  3001,  3002,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3012,    -1,    -1,  3015,    -1,    -1,    -1,
      -1,    -1,    -1,  3022,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3034,    -1,    -1,  3037,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,  3514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3525,
      -1,    -1,   302,   481,    -1,   305,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,  1964,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3514,   335,    -1,   144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3525,    -1,    -1,    -1,    -1,
      -1,    -1,   784,    -1,    -1,    -1,    -1,   164,    -1,    -1,
     792,    -1,    -1,  3589,    -1,   797,    -1,    -1,    -1,    -1,
      -1,  3597,    -1,    -1,    -1,    -1,    -1,    -1,   185,    -1,
      -1,    -1,    -1,  3152,    -1,    -1,    -1,  2194,    -1,    -1,
      -1,   391,  2199,  2200,    -1,   827,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,  3589,
     217,    -1,    -1,    -1,  3183,   222,    -1,  3597,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,   877,    -1,    -1,    -1,    -1,
    3219,  3220,   884,    -1,    -1,  3224,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,  3263,  3264,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,
    3279,    -1,   319,    -1,  3283,  3284,  3285,  3286,  3287,  3288,
    3289,    -1,    -1,    -1,    -1,    -1,  3752,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,   346,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   980,    -1,
      -1,  3777,    -1,    -1,   986,    -1,  2194,    -1,   990,    -1,
      -1,  2199,  2200,   370,    -1,    -1,  3335,    -1,    -1,   376,
      71,  2378,  3752,    -1,    -1,   382,    -1,   384,    -1,  3348,
    3349,  3350,    -1,  3352,    -1,    -1,    -1,  1019,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    -1,  3777,    -1,    -1,
      -1,   230,   103,   410,   411,   234,    -1,   108,   415,  3378,
      -1,    -1,  3838,    -1,  3383,    -1,   423,  3386,    -1,  3388,
      -1,   428,    -1,    -1,    -1,   254,   255,    -1,    -1,  3398,
      -1,   438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,   450,    -1,    -1,    -1,    -1,  3417,    -1,
    3419,    -1,    -1,    -1,    -1,   230,    -1,    -1,  3838,   234,
      -1,  3430,    -1,  3432,    -1,  3434,    -1,    -1,    -1,  2476,
    3439,    -1,  3441,   302,    -1,    -1,   305,    -1,  2316,   254,
     255,    -1,    -1,    -1,    -1,    -1,  3455,    -1,    -1,    -1,
     319,    -1,    -1,   322,   269,    -1,    -1,    -1,    -1,    -1,
    3926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1156,    -1,    -1,  3953,    -1,   230,
     305,  1163,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
    2378,    -1,    -1,    -1,   319,    -1,  3926,    -1,    -1,    -1,
      -1,    -1,  1184,   254,   255,    -1,    -1,    -1,    -1,    -1,
    3986,    -1,   391,    -1,  3990,  3991,    -1,    -1,   269,    -1,
      -1,    -1,    -1,  3953,    -1,    -1,    -1,    -1,    -1,    -1,
    3549,    -1,  1214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3563,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,  3986,    -1,    -1,    -1,
    3990,  3991,    -1,    -1,    -1,    -1,   391,    -1,   319,  3588,
      -1,   322,    -1,    -1,  3593,  3594,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3604,  3605,    -1,  2476,    -1,
      -1,    -1,  1274,    -1,    -1,    -1,    -1,    -1,  3617,  3618,
    3619,  3620,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1307,    -1,  3646,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,  3660,  3661,  3662,  3663,  3664,    -1,  1329,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,    -1,  3698,
      -1,  2738,  2739,    -1,  2741,    -1,    -1,    -1,    -1,    -1,
      -1,  2748,    -1,    -1,    -1,    -1,    -1,  3716,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3724,  1388,  1389,    -1,  1391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3737,    -1,
      -1,  3740,  2779,    -1,  2781,    -1,  1408,    -1,    -1,    -1,
     481,  3750,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,  3762,  3763,    -1,    -1,    -1,    -1,  3768,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1460,  1461,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2853,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1487,    -1,    -1,    -1,  1491,
    1492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2878,    -1,  3842,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3862,    -1,    -1,    -1,    -1,    -1,  2906,
    2738,  2739,    -1,  2741,    -1,    -1,    -1,    -1,    -1,    -1,
    2748,    -1,    -1,    -1,    -1,  2922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3893,    -1,  3895,    -1,    -1,  2936,
    1562,    -1,    -1,    -1,  1566,    -1,    -1,    -1,  1570,    -1,
      -1,  2779,    -1,  2781,  2951,    -1,    -1,    -1,    -1,  3918,
    3919,    -1,    -1,    -1,  3923,  3924,    -1,    -1,  1590,    -1,
      -1,    -1,    -1,    71,    -1,  1597,    -1,    -1,  3937,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2987,    -1,    -1,    -1,    -1,    71,    -1,  1619,    -1,    -1,
      -1,  1623,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,  3970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    98,    -1,    -1,  2853,    -1,   103,    -1,    -1,
      -1,    -1,   108,    -1,  3993,  3994,  3995,  3996,  3997,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2878,  3048,    -1,    -1,    -1,    -1,  1678,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3067,    -1,    -1,  1695,    -1,    -1,    -1,    -1,  2906,    -1,
      -1,    -1,    -1,  4042,  4043,    -1,    -1,    -1,    -1,    -1,
      -1,  1713,    -1,    -1,  2922,  3092,    -1,   195,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2936,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1738,    -1,    -1,    -1,
      -1,  1743,    -1,  2951,    -1,    -1,    -1,    -1,    -1,  3126,
      -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,  4098,
      -1,  4100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4109,    -1,    -1,    -1,   230,    -1,   254,   255,   234,  2987,
      -1,    -1,    -1,  4122,  1786,    -1,  1788,    -1,    -1,  4128,
      -1,   269,  1794,    -1,    -1,  1797,    -1,    -1,   254,   255,
    4139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4150,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3048,   319,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3067,
      -1,    -1,  1864,   319,    -1,    -1,   322,  4206,    -1,    -1,
      -1,  3248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3092,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4231,    -1,    -1,    -1,    -1,  1899,  1900,    -1,
      -1,    -1,    -1,    -1,    -1,  1907,    -1,    -1,  1910,    -1,
      -1,  1913,    -1,   391,    -1,    -1,    -1,    -1,  3126,  1921,
    1922,    -1,    -1,    71,    -1,    -1,    -1,  1929,    -1,    -1,
    1932,  1933,  1934,  1935,    -1,   391,    -1,    -1,    -1,    -1,
    1942,  1943,    -1,  1945,    -1,  1947,    -1,    95,  1950,    -1,
      98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,    -1,  1964,  1965,  1966,    -1,    -1,  1969,    -1,    -1,
      -1,  1973,    -1,    -1,    -1,  1977,    -1,    -1,  1980,  1981,
    1982,  1983,  1984,  1985,  1986,  1987,  1988,    -1,  1990,  3366,
      -1,    -1,    -1,    -1,  1996,    -1,    -1,    -1,  2000,    -1,
      -1,    -1,    -1,   481,    -1,    -1,    -1,    71,    -1,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3401,   481,    -1,    -1,   484,   485,
     486,    95,   488,   489,   490,   491,   492,   493,    -1,   103,
    3248,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,  2071,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,    -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3514,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3525,    -1,
      -1,    -1,    -1,   207,   302,  2157,    -1,   305,  3366,    -1,
     214,    -1,   216,    -1,    -1,    -1,   230,    -1,    -1,    -1,
     234,   319,  2174,    -1,   322,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,
     254,   255,  2194,  3401,    -1,    -1,    -1,  2199,  2200,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,
      -1,    -1,  3589,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3597,  2223,   230,    -1,    -1,    -1,   234,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,
      -1,   305,    -1,   391,    -1,    -1,   254,   255,    -1,    25,
      -1,    -1,    -1,  2255,    -1,   319,    -1,    -1,   322,    35,
      36,   269,    -1,    -1,    -1,    41,    -1,    43,    44,    -1,
      -1,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,   305,    74,    -1,
      76,    77,    78,    79,    80,    -1,  3514,    -1,    -1,    -1,
      -1,   319,  2314,    -1,  2316,    -1,    -1,  3525,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,
      -1,    -1,    71,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,   123,    -1,    -1,
      -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,
      -1,    -1,    -1,    -1,    -1,  3752,  2378,    -1,    -1,    -1,
      -1,  3589,    -1,   391,    -1,    -1,  2388,    -1,    -1,  3597,
      -1,    -1,    -1,    -1,    -1,    -1,  2398,    -1,    -1,    -1,
    3777,    -1,    -1,    -1,    -1,    -1,  1184,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,   194,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,   208,  2435,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   195,    -1,    -1,    -1,
      -1,  3838,    -1,  2465,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   248,   481,  2476,    -1,    -1,    -1,    -1,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   230,    -1,  2495,  2496,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,    -1,   285,
      -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,  2525,  2526,    -1,    -1,    -1,  2530,  1307,
     269,   307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2542,  2543,  2544,  2545,  3752,    -1,    -1,    -1,  2550,  3926,
      -1,    -1,  2554,  2555,    -1,  2557,    -1,  2559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   305,  2569,  2570,  3777,
    2572,    -1,    -1,    -1,    -1,    -1,  3953,    -1,    -1,    -1,
     319,    -1,    -1,  2585,    -1,  2587,    -1,    -1,    -1,  2591,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,    71,  2607,    -1,    -1,    -1,  3986,
      -1,    -1,    -1,  3990,  3991,    -1,  2618,    -1,  2620,  2621,
    2622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
    3838,    -1,    -1,    -1,    -1,    -1,   103,    -1,  2640,    -1,
      -1,   108,    -1,   419,    -1,    -1,    -1,  2649,    -1,    -1,
      -1,    -1,   391,    -1,  2656,    -1,   432,    -1,    -1,  2661,
      -1,    -1,    -1,    -1,    -1,    -1,  2668,  2669,  2670,   445,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,
     476,   477,   478,    -1,    -1,    -1,   482,    -1,   484,    -1,
    2712,    -1,   488,   489,   490,   491,   492,    -1,  3926,   495,
     496,   497,   498,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2738,  2739,   792,  2741,
      -1,    -1,   481,   797,    -1,  3953,  2748,    -1,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,
      -1,    -1,    -1,   827,    -1,    -1,    -1,  2779,  3986,  2781,
      -1,    -1,  3990,  3991,  1562,    -1,    -1,   254,   255,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2815,  2816,  2817,    -1,    -1,    -1,  1597,
      -1,    -1,    -1,   877,    -1,    -1,    -1,    -1,    -1,    -1,
     884,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
      -1,  1619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2853,   319,    -1,    88,   322,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2878,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   133,
    1678,    -1,    -1,  2905,  2906,    -1,   140,    -1,    -1,    -1,
     144,    -1,    -1,    -1,    -1,    -1,    -1,  1695,    -1,    -1,
    2922,    -1,    -1,    -1,   391,    -1,   980,    -1,    -1,    -1,
     164,    -1,   986,    -1,  2936,  1713,   990,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2951,
      -1,   185,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1738,    -1,    -1,    -1,    -1,  1019,  2968,    -1,    -1,    -1,
    2972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2982,    -1,    -1,   217,    -1,  2987,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3014,    -1,   481,    -1,  1794,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,   261,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3045,    -1,    -1,  3048,    -1,    -1,    -1,
      -1,    -1,  3054,    -1,    -1,    -1,    -1,    -1,  3060,    -1,
    3062,    -1,    -1,    -1,    -1,  3067,  3068,    -1,    -1,  3071,
    3072,  3073,  3074,  3075,  3076,  3077,  3078,  3079,  3080,    -1,
      -1,    -1,  3084,  3085,    -1,   319,    -1,    -1,    -1,    -1,
    3092,    -1,    -1,    -1,    -1,  3097,   147,    -1,    -1,  3101,
      -1,  3103,  1156,    -1,    -1,    -1,    -1,    -1,    -1,  1163,
      -1,  3113,   346,    -1,  3116,    -1,  3118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3126,  3127,  3128,  3129,    -1,    -1,
    1184,  3133,    -1,    -1,  3136,    -1,   370,    -1,    -1,    -1,
     374,    -1,   376,    -1,  3146,   196,    -1,    -1,   382,    -1,
      -1,    -1,    -1,  3155,    -1,   206,    -1,    -1,    -1,   210,
    1214,    -1,    -1,    -1,   215,    -1,    -1,    -1,   219,    -1,
      -1,   222,    -1,   224,    -1,    -1,   410,   411,    -1,    -1,
      -1,   415,    -1,    -1,    -1,    -1,  1964,    -1,    -1,   423,
      -1,    -1,    -1,    -1,   428,    -1,    -1,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   450,    -1,    -1,   270,
    1274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3247,  3248,  3249,    -1,    -1,
      -1,    -1,    -1,  1307,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   314,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   323,    -1,  3276,  1329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1357,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1388,  1389,    -1,  1391,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3353,    -1,    -1,  1408,    -1,    -1,    -1,    -1,   410,
      -1,    -1,    -1,    -1,  3366,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3401,
    3402,  3403,   453,    -1,   455,   456,  1460,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2194,    -1,    -1,  3421,
      -1,  2199,  2200,    -1,  3426,    -1,    -1,  3429,    -1,    88,
      -1,    -1,    -1,  1487,    -1,    -1,    -1,  1491,  1492,    -1,
      -1,   100,    -1,    -1,   495,    -1,    -1,   498,   499,    -1,
     501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,  3468,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   140,    -1,    -1,    -1,   144,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3504,    -1,    -1,   164,    -1,    -1,  1562,  3511,
    3512,   170,  3514,    -1,    -1,    -1,  1570,  3519,  3520,    -1,
      -1,    -1,  3524,  3525,    -1,    -1,   185,    -1,  3530,  3531,
      -1,    -1,  3534,    -1,    -1,    -1,  1590,    -1,  2316,    -1,
      -1,    89,    -1,  1597,    -1,    -1,    94,    -1,    -1,    -1,
      -1,    -1,  3554,   212,    -1,    -1,    -1,    -1,   217,   218,
      -1,    -1,    -1,   222,    -1,  1619,    -1,    -1,    -1,  1623,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,  3589,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3597,    -1,    -1,    -1,    -1,
    2378,   260,    -1,   151,   152,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   161,   273,    -1,    -1,   165,    -1,    -1,
      -1,    -1,    -1,    -1,  1678,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   186,    -1,
      -1,  1695,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,  1713,
     319,    -1,    -1,   322,    -1,    -1,  1184,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3684,    -1,  1738,    -1,    -1,   346,    -1,    -1,
      -1,    -1,  3694,    -1,    -1,    -1,    -1,    -1,  2476,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   370,    -1,    -1,    -1,   374,    -1,   376,    -1,    -1,
      -1,    -1,  3724,    -1,    -1,   384,    -1,  3729,    -1,    -1,
      -1,    -1,  1786,    -1,  1788,    -1,    -1,    -1,    -1,    -1,
    1794,  3743,    -1,  1797,    -1,  3747,    -1,    -1,    -1,    -1,
    3752,    -1,   411,   412,    -1,   414,   415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   423,    -1,    -1,    -1,   427,   428,
      -1,  3773,    -1,    -1,   433,  3777,    -1,    -1,    -1,   438,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1307,
      -1,    -1,    -1,    -1,    -1,  3797,  3798,    -1,    -1,  3801,
      -1,    -1,    -1,    -1,    -1,    -1,  3808,  3809,    -1,    -1,
    1864,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3838,    -1,    -1,  3841,
      -1,    -1,    -1,    -1,    -1,  1899,  1900,    -1,    -1,    -1,
      -1,   399,    -1,  1907,    -1,    -1,  1910,    -1,    -1,  1913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1921,  1922,    -1,
    3872,    -1,    -1,    -1,    -1,  1929,    -1,    -1,  1932,  1933,
    1934,  1935,    -1,    -1,    -1,    -1,    -1,    -1,  1942,  1943,
      -1,  1945,    -1,  1947,    -1,    -1,  1950,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1964,  1965,    -1,    -1,    -1,  1969,    -1,  3919,  3920,  1973,
      -1,    -1,    -1,  1977,  3926,    -1,  1980,  1981,  1982,  1983,
    1984,  1985,  1986,  1987,  1988,    -1,  1990,    -1,    -1,    -1,
      -1,    -1,  1996,    -1,    -1,    -1,  2000,    -1,    -1,    -1,
    3952,  3953,    -1,  3955,    -1,  3957,    -1,    -1,    -1,    -1,
    2738,  2739,    -1,  2741,    -1,    -1,    -1,    -1,    -1,    -1,
    2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3983,    -1,    -1,  3986,    -1,    -1,    -1,  3990,  3991,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2779,    -1,  2781,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4014,    -1,    -1,    -1,    -1,  2071,    -1,  4021,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4042,    -1,    -1,    -1,  1562,    -1,    -1,  4049,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4067,    -1,   106,    -1,    -1,
     618,    -1,    -1,    -1,    -1,  2853,    -1,    -1,    -1,  1597,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2878,  1619,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,    -1,   155,    -1,    -1,    -1,
    2174,    -1,   161,    -1,    -1,    -1,   165,    -1,  2906,    -1,
      -1,   679,    -1,  4135,    -1,    -1,    -1,    -1,    -1,    -1,
    2194,    -1,    -1,    -1,  2922,  2199,  2200,   186,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2936,    -1,
    1678,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2951,    -1,    -1,    -1,  1695,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1713,   235,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2987,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4220,    -1,
    1738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2314,    -1,  2316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3048,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3067,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3092,   863,   864,    -1,   866,    -1,
      -1,    -1,    -1,    -1,  2378,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2388,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2398,    -1,    -1,    -1,  3126,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
     399,    -1,    -1,   911,    -1,   913,    -1,   915,    -1,    -1,
      -1,    -1,    -1,   921,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2435,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2465,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   982,    -1,   984,    -1,    -1,    -1,
      -1,  2495,  2496,    -1,    -1,    -1,  1964,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3248,  2525,  2526,    -1,    -1,    -1,  2530,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2542,  2543,
    2544,  2545,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2554,    -1,    -1,  2557,    -1,  2559,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1061,    -1,  2569,  2570,    -1,  2572,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1076,  1077,
      -1,  2585,  1080,  2587,    -1,    -1,    -1,  2591,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2607,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2618,    -1,  2620,  2621,  2622,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2640,    -1,  3366,    -1,
      -1,    -1,    -1,    -1,    -1,  2649,    -1,    -1,    -1,    -1,
      -1,    -1,  2656,    -1,    -1,    -1,    -1,  2661,    -1,    -1,
      -1,    -1,    -1,    -1,  2668,  2669,  2670,    -1,    -1,    -1,
      -1,    -1,    -1,  3401,    -1,    -1,   665,   666,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2712,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2194,    -1,    -1,    -1,
      -1,  2199,  2200,    -1,  2738,  2739,    -1,  2741,    -1,    -1,
      -1,    -1,    -1,    -1,  2748,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2779,    -1,  2781,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3514,    -1,    -1,    -1,
    1288,    -1,    -1,    -1,    -1,    -1,    -1,  3525,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1306,    -1,
      -1,    -1,    -1,    -1,   803,    -1,   805,    -1,   807,    -1,
     809,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   828,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2316,  2853,
      -1,    -1,    -1,   842,   843,    -1,    -1,    -1,   847,    -1,
      -1,  3589,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3597,
      -1,    -1,    -1,    -1,  2878,   864,    -1,   866,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   878,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   890,  2906,    -1,   893,    -1,   895,    -1,   897,    -1,
    2378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,  1184,
      -1,  1419,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1428,  1429,  2936,    -1,    -1,   924,   925,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2951,    -1,  1447,
      -1,    -1,    -1,  1451,  1452,    -1,    -1,    -1,    -1,    -1,
      -1,   950,    -1,   952,  2968,    -1,    -1,    -1,  2972,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2982,    -1,
      -1,    -1,    -1,  2987,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   982,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2476,    -1,
    3014,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3752,  1523,    -1,  1525,    -1,    -1,
      -1,    -1,  1021,    -1,    -1,  1533,    -1,    -1,    -1,    -1,
      -1,  3045,  1307,    -1,  3048,    -1,    -1,    -1,    -1,  3777,
    3054,    -1,    -1,    -1,    -1,    -1,  3060,    -1,  3062,    -1,
      -1,    -1,    -1,  3067,  3068,    -1,    -1,  3071,  3072,  3073,
    3074,  3075,  3076,  3077,  3078,  3079,  3080,    -1,    -1,    -1,
    3084,  3085,    -1,    -1,  1582,    -1,    -1,    -1,  3092,    -1,
    1588,    -1,    -1,  3097,    -1,    -1,    -1,    -1,    -1,  3103,
    1089,    -1,  1091,    -1,    -1,    -1,  1095,    -1,    -1,  3113,
    3838,    -1,  3116,    -1,  3118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3126,  3127,  3128,  3129,    -1,    -1,    -1,  3133,
    1628,    -1,  3136,  1631,  1632,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3155,    -1,    -1,    -1,    -1,    -1,  1146,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1159,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1168,
      -1,    -1,    -1,  1681,    -1,  1174,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1185,    -1,  3926,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3953,  1215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3986,    -1,
      -1,    -1,  3990,  3991,    -1,    -1,    -1,    -1,    -1,    -1,
    2738,  2739,    -1,  2741,    -1,    -1,    -1,    -1,    -1,    -1,
    2748,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1285,  1562,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2779,    -1,  2781,    -1,  1304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1841,    -1,    -1,    -1,    -1,    -1,  3353,
      -1,    -1,    -1,    -1,  1619,    -1,    -1,    -1,  1856,    -1,
      -1,    -1,  3366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2853,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3401,  3402,  3403,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2878,    -1,    -1,  1678,    -1,    -1,    -1,  3421,    -1,    -1,
      -1,    -1,  3426,    -1,    -1,  3429,    -1,    -1,    -1,    -1,
    1695,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1713,    -1,
      -1,    -1,    -1,    -1,  2922,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3468,    -1,    -1,    -1,  2936,    -1,
      -1,    -1,    -1,  1738,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,  1477,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1995,    -1,    -1,
    3504,    -1,    -1,    -1,  2002,    -1,    -1,  3511,  3512,    -1,
    3514,    -1,    -1,  2011,    -1,  3519,  3520,    -1,    -1,  2987,
    3524,  3525,    -1,    -1,    -1,    -1,  3530,  3531,    -1,  1794,
    3534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1555,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3048,    -1,    -1,    -1,    -1,  3589,    -1,  2085,    -1,    -1,
      -1,  1580,    -1,  3597,    -1,    -1,    -1,    -1,    -1,  3067,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3092,    -1,    -1,    -1,  2126,    -1,
      -1,    -1,  2130,    -1,    -1,    -1,  2134,    -1,  2136,    -1,
      -1,    -1,    -1,    -1,  2142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3126,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3684,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1964,
     792,    -1,    -1,    -1,    -1,   797,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3724,    -1,    -1,    -1,    -1,  3729,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   827,    -1,    -1,    -1,  3743,
      -1,    -1,    -1,  3747,  2242,    -1,    -1,    -1,  3752,    -1,
    1739,    -1,  2250,    -1,  2252,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1751,    -1,    -1,    -1,    -1,    -1,    -1,  3773,
      -1,    -1,    -1,  3777,    -1,    -1,    -1,    -1,    -1,    -1,
    3248,    -1,    -1,    -1,    -1,   877,    -1,    -1,    -1,    -1,
      -1,    -1,   884,  3797,  3798,    -1,    -1,  3801,    -1,    -1,
      -1,    -1,    -1,    -1,  3808,  3809,    -1,  1796,    -1,    -1,
      -1,  1800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1809,    -1,  1811,    -1,  1813,    -1,    -1,    -1,    -1,  1818,
      -1,    -1,    -1,    -1,  3838,    -1,    -1,  3841,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1840,  1841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3872,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   980,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3366,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3919,  3920,    -1,    -1,    -1,
      -1,    -1,  3926,    -1,    -1,    -1,    -1,  1019,    -1,  2194,
      -1,    -1,    -1,  3401,  2199,  2200,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2441,  2442,    -1,    -1,    -1,  3952,  3953,
      -1,  3955,    -1,  3957,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3983,
      -1,    -1,  3986,    -1,    -1,    -1,  3990,  3991,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2002,    -1,    -1,    -1,  4021,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4042,    -1,
      -1,    -1,    -1,    -1,    -1,  4049,  3514,    -1,    -1,    -1,
      -1,  2316,    -1,    -1,    -1,    -1,    -1,  3525,    -1,    -1,
      -1,    -1,    -1,  4067,  1156,    -1,    -1,    -1,    -1,    -1,
      -1,  1163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1184,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2378,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3589,  1214,    -1,    -1,    -1,    -1,    -1,    -1,  3597,
      -1,  4135,    -1,  2631,    -1,    -1,    -1,    -1,  2636,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2142,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2155,    -1,    -1,    -1,
      -1,  2160,    -1,    -1,    -1,  2164,    -1,    -1,    -1,    -1,
      -1,  2170,  1274,    -1,    -1,    -1,    -1,  2176,    -1,    -1,
      -1,    -1,    -1,  2182,    -1,    -1,    -1,    -1,  2187,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2476,    -1,    -1,    -1,  1307,  4220,    -1,    -1,    -1,
      -1,  2210,  2211,  2212,  2213,    -1,    -1,    -1,  2217,  2218,
      -1,    -1,    -1,  2222,    -1,    -1,  2225,  1329,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2249,    -1,  2251,    -1,    -1,  1357,    -1,    -1,    -1,    -1,
      -1,  2260,  2261,  2262,    -1,  2264,    -1,    -1,    -1,    -1,
      -1,    -1,  2271,  2272,  3752,    -1,    -1,    -1,    -1,    -1,
    2279,  2280,    -1,    -1,    -1,    -1,  1388,  1389,    -1,  1391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3777,
      -1,    -1,    -1,    -1,    -1,    -1,  1408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1460,    -1,
    3838,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2878,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1487,    -1,    -1,    -1,  1491,
    1492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2906,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2924,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2441,    -1,    -1,    -1,    -1,    -1,  3926,    -1,
      -1,    -1,    -1,  2961,    -1,    -1,    -1,    -1,    -1,    -1,
    1562,    -1,    -1,  2738,  2739,    -1,  2741,    -1,    -1,    -1,
      -1,    -1,    -1,  2748,    -1,  3953,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2482,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1597,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2779,    -1,  2781,    -1,  3986,    -1,
      -1,    -1,  3990,  3991,    -1,    -1,    -1,  1619,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1678,    -1,  2853,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1695,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2878,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1713,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2906,    -1,    -1,    -1,    -1,  1738,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2936,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1786,    -1,  1788,    -1,    -1,    -1,
      -1,    -1,  1794,    -1,    -1,  1797,    -1,    -1,  3206,    -1,
      -1,    -1,    -1,  2702,  2703,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3261,    -1,    -1,    -1,    -1,  2757,  2758,
    2759,  2760,  1864,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3067,    -1,    -1,    -1,    -1,  1899,  1900,    -1,
      -1,    -1,    -1,    -1,    -1,  1907,    -1,    -1,  1910,    -1,
      -1,  1913,    -1,    -1,    -1,    -1,    -1,  3092,    -1,  1921,
    1922,    -1,    -1,    -1,    -1,    -1,    -1,  1929,    -1,    -1,
    1932,  1933,  1934,  1935,    -1,    -1,    -1,    -1,    -1,    -1,
    1942,  1943,    -1,  1945,  2843,  1947,    -1,    -1,  1950,  2848,
      -1,  3126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1964,  1965,    -1,    -1,    -1,  1969,    -1,    -1,
      -1,  1973,    -1,    -1,    -1,  1977,    -1,    -1,  1980,  1981,
    1982,  1983,  1984,  1985,  1986,  1987,  1988,    -1,  1990,   980,
      -1,    -1,    -1,    -1,  1996,    -1,    -1,    -1,  2000,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2923,  2924,    -1,    -1,  1019,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2961,    -1,    -1,    -1,    -1,    -1,    -1,  2071,
      -1,    -1,    -1,  3248,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2988,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3001,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3556,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3567,
      -1,    -1,    -1,    -1,    -1,  3573,    -1,    -1,    -1,    -1,
      -1,    -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,  3587,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3366,  2194,    -1,    -1,    -1,    -1,  2199,  2200,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3401,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3668,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2314,    -1,  2316,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1329,  3514,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3525,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,    -1,    -1,
    3279,    -1,    -1,    -1,    -1,  3284,  2388,  3286,  3287,  3288,
    3289,    -1,    -1,    -1,    -1,    -1,  2398,  1388,  1389,    -1,
    1391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3589,    -1,    -1,  1408,    -1,    -1,
      -1,    -1,  3597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3838,    -1,    -1,  2435,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3348,
    3349,  3350,    -1,  3352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2465,    -1,    -1,    -1,    -1,    -1,  1460,
      -1,    -1,    -1,    -1,  2476,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2495,  2496,    -1,  1487,    -1,    -1,    -1,
    1491,  1492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2525,  2526,    -1,    -1,    -1,  2530,    -1,
      -1,    -1,    -1,    -1,    -1,  3434,    -1,    -1,    -1,    -1,
    2542,  2543,  2544,  2545,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2554,    -1,    -1,  2557,    -1,  2559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2569,  2570,    -1,
    2572,    -1,    -1,    -1,    -1,    -1,    -1,  3752,    -1,    -1,
      -1,    -1,    -1,  2585,    -1,  2587,    -1,    -1,    -1,  2591,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3777,    -1,    -1,  2607,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2618,    -1,  2620,  2621,
    2622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2640,    -1,
      -1,    -1,    -1,  4051,    -1,    -1,    -1,  2649,    -1,    -1,
      -1,    -1,    -1,    -1,  2656,    -1,    -1,    -1,    -1,  2661,
      -1,    -1,    -1,  3838,    -1,    -1,  2668,  2669,  2670,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3594,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3605,    -1,    -1,    -1,
    2712,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2738,  2739,    -1,  2741,
      -1,    -1,    -1,    -1,    -1,    -1,  2748,    -1,    -1,    -1,
      -1,  3926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1404,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2779,  3953,  2781,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3698,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3986,    -1,    -1,    -1,  3990,  3991,  3716,    -1,    -1,
      -1,    -1,    -1,  