.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_cursor_open" "" "2010-05-14" "" "PostgreSQL 8.1.21 Documentation"
.SH NAME
SPI_cursor_open \- set up a cursor using a plan created with SPI_prepare

.SH SYNOPSIS
.sp
.nf
Portal SPI_cursor_open(const char * \fIname\fR, void * \fIplan\fR,
                       Datum * \fIvalues\fR, const char * \fInulls\fR,
                       bool \fIread_only\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_cursor_open\fR sets up a cursor (internally,
a portal) that will execute a plan prepared by
\fBSPI_prepare\fR. The parameters have the same
meanings as the corresponding parameters to
\fBSPI_execute_plan\fR.
.PP
Using a cursor instead of executing the plan directly has two
benefits. First, the result rows can be retrieved a few at a time,
avoiding memory overrun for queries that return many rows. Second,
a portal can outlive the current procedure (it can, in fact, live
to the end of the current transaction). Returning the portal name
to the procedure's caller provides a way of returning a row set as
result.
.SH "ARGUMENTS"
.TP
\fBconst char * \fIname\fB\fR
name for portal, or \fBNULL\fR to let the system
select a name
.TP
\fBvoid * \fIplan\fB\fR
execution plan (returned by \fBSPI_prepare\fR)
.TP
\fBDatum * \fIvalues\fB\fR
An array of actual parameter values. Must have same length as the
plan's number of arguments.
.TP
\fBconst char * \fInulls\fB\fR
An array describing which parameters are null. Must have same length as
the plan's number of arguments.
n indicates a null value (entry in
\fIvalues\fR will be ignored); a space indicates a
nonnull value (entry in \fIvalues\fR is valid).

If \fInulls\fR is \fBNULL\fR then
\fBSPI_cursor_open\fR assumes that no parameters are
null.
.TP
\fBbool \fIread_only\fB\fR
true for read-only execution
.SH "RETURN VALUE"
.PP
pointer to portal containing the cursor, or \fBNULL\fR
on error
