.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP AGGREGATE" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP AGGREGATE \- remove a user-defined aggregate function
.SH SYNOPSIS
.sp
.nf
DROP AGGREGATE \fIname\fR ( \fItype\fR ) [ CASCADE | RESTRICT ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing aggregate function.
.TP
\fB\fItype\fB\fR
The input data type of the aggregate function,
or * if the function accepts any input type.
(Refer to the \fIPostgreSQL User's Guide\fR for
further information about data types.)
[Comment: This should become a cross-reference rather than a
hard-coded chapter number]
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the aggregate.
.TP
\fBRESTRICT\fR
Refuse to drop the aggregate if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP AGGREGATE\fR
Message returned if the command is successful.
.TP
\fBERROR: RemoveAggregate: aggregate '\fIname\fB' for type \fItype\fB does not exist\fR
This message occurs if the aggregate function specified does not
exist in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP AGGREGATE\fR will delete an existing
aggregate definition. To execute this command the current
user must be the owner of the aggregate.
.SS "NOTES"
.PP
Use
CREATE AGGREGATE [\fBcreate_aggregate\fR(l)]
to create aggregate functions.
.SH "USAGE"
.PP
To remove the myavg aggregate for type
int4:
.sp
.nf
DROP AGGREGATE myavg(int4);
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP AGGREGATE\fR statement
in SQL92; the statement is a
PostgreSQL
language extension.
