/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.deployment;

import java.util.ArrayList;
import java.util.Collection;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployResult {
    private final DeployRequest request;
    private Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private Collection<Metadata> metadata = new ArrayList<Metadata>();

    public DeployResult(DeployRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("deploy request has not been specified");
        }
        this.request = request;
    }

    public DeployRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public DeployResult setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts == null ? new ArrayList<Artifact>() : artifacts;
        return this;
    }

    public DeployResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public DeployResult setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata == null ? new ArrayList<Metadata>() : metadata;
        return this;
    }

    public DeployResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

