/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.GlobalScopeTDZCheckNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GlobalScopeTDZCheckNode.class)
final class GlobalScopeTDZCheckNodeGen
extends GlobalScopeTDZCheckNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;
    @Node.Child
    private PropertyGetNode uncached_getNode_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile uncached_deadBranch_;

    private GlobalScopeTDZCheckNodeGen(JSContext context, String varName) {
        super(context, varName);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object scopeNodeValue_ = this.scopeNode.execute(frameValue);
        if ((state & 1) != 0 && JSTypes.isDynamicObject(scopeNodeValue_)) {
            DynamicObject scopeNodeValue__ = (DynamicObject)scopeNodeValue_;
            CachedData s1_ = this.cached_cache;
            while (s1_ != null) {
                if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.removeCached_(s1_);
                    return this.executeAndSpecialize(scopeNodeValue__);
                }
                if (scopeNodeValue__.getShape() == s1_.cachedShape_) {
                    return this.doCached(scopeNodeValue__, s1_.cachedShape_, s1_.dead_);
                }
                s1_ = s1_.next_;
            }
        }
        if ((state & 2) != 0) {
            return this.doUncached(scopeNodeValue_, this.uncached_getNode_, this.uncached_deadBranch_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object scopeNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && JSTypes.isDynamicObject(scopeNodeValue)) {
                DynamicObject scopeNodeValue_ = (DynamicObject)scopeNodeValue;
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && (scopeNodeValue_.getShape() != s1_.cachedShape_ || s1_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null) {
                    Assumption assumption0;
                    Shape cachedShape__ = scopeNodeValue_.getShape();
                    if (scopeNodeValue_.getShape() == cachedShape__ && Assumption.isValidAssumption((Assumption)(assumption0 = cachedShape__.getValidAssumption())) && count1_ < this.context.getPropertyCacheLimit()) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedShape_ = cachedShape__;
                        s1_.dead_ = this.isDead(cachedShape__);
                        s1_.assumption0_ = assumption0;
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doCached(scopeNodeValue_, s1_.cachedShape_, s1_.dead_);
                    return object;
                }
            }
            this.uncached_getNode_ = (PropertyGetNode)super.insert((Node)PropertyGetNode.create(this.varName, this.context));
            this.uncached_deadBranch_ = BranchProfile.create();
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = this.doUncached(scopeNodeValue, this.uncached_getNode_, this.uncached_deadBranch_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCached_(Object s1_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedData prev = null;
            CachedData cur = this.cached_cache;
            while (cur != null) {
                if (cur == s1_) {
                    if (prev == null) {
                        this.cached_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cached_cache == null) {
                this.state_ &= 0xFFFFFFFE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCached";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            CachedData s1_ = this.cached_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.dead_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Cloneable[]{this.uncached_getNode_, this.uncached_deadBranch_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static GlobalScopeTDZCheckNode create(JSContext context, String varName) {
        return new GlobalScopeTDZCheckNodeGen(context, varName);
    }

    @GeneratedBy(value=GlobalScopeTDZCheckNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean dead_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

