/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

public final class Encodings {
    public static final Encoding UTF_8 = new Encoding.UTF8();
    public static final Encoding UTF_16 = new Encoding.UTF16();
    public static final Encoding UTF_32 = new Encoding.UTF32();

    public static abstract class Encoding {
        public abstract String getName();

        public abstract int getEncodedSize(int var1);

        private static final class UTF8
        extends Encoding {
            private UTF8() {
            }

            @Override
            public String getName() {
                return "UTF-8";
            }

            @Override
            public int getEncodedSize(int codepoint) {
                if (codepoint < 128) {
                    return 1;
                }
                if (codepoint < 2048) {
                    return 2;
                }
                if (codepoint < 65536) {
                    return 3;
                }
                return 4;
            }
        }

        private static final class UTF16
        extends Encoding {
            private UTF16() {
            }

            @Override
            public String getName() {
                return "UTF-16";
            }

            @Override
            public int getEncodedSize(int codepoint) {
                return codepoint < 65536 ? 1 : 2;
            }
        }

        private static final class UTF32
        extends Encoding {
            private UTF32() {
            }

            @Override
            public String getName() {
                return "UTF-32";
            }

            @Override
            public int getEncodedSize(int codepoint) {
                return 1;
            }
        }
    }
}

