/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.util.EnumSet;

public final class JavaPackage
extends JSBuiltinObject {
    public static final String TYPE_NAME = "object";
    public static final String CLASS_NAME = "JavaPackage";
    public static final JavaPackage INSTANCE = new JavaPackage();
    private static final Property PACKAGE_PROPERTY;
    private static final HiddenKey PACKAGE_NAME_ID;

    private JavaPackage() {
    }

    public static DynamicObject create(JSContext context, JSRealm realm, String packageName) {
        DynamicObject obj = JSObject.createWithPrototype(context, context.getJavaPackageFactory(), realm, realm.getObjectPrototype(), packageName);
        JSObjectUtil.putDataProperty(obj, Symbol.SYMBOL_TO_PRIMITIVE, realm.getJavaPackageToPrimitiveFunction(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        assert (JavaPackage.isJavaPackage(obj));
        return obj;
    }

    public static DynamicObject createInit(JSRealm realm, String packageName) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject obj = realm.getContext().getJavaPackageFactory().createWithPrototype(realm, realm.getObjectPrototype(), (Object)packageName);
        JSObjectUtil.putDataProperty(obj, Symbol.SYMBOL_TO_PRIMITIVE, realm.getJavaPackageToPrimitiveFunction(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        assert (JavaPackage.isJavaPackage(obj));
        return obj;
    }

    public static boolean isJavaPackage(Object obj) {
        return JSObject.isDynamicObject(obj) && JavaPackage.isJavaPackage((DynamicObject)obj);
    }

    public static boolean isJavaPackage(DynamicObject obj) {
        return INSTANCE != null && JavaPackage.isInstance(obj, (JSClass)INSTANCE);
    }

    public static String getPackageName(DynamicObject obj) {
        assert (JavaPackage.isJavaPackage(obj));
        return (String)PACKAGE_PROPERTY.get(obj, JavaPackage.isJavaPackage(obj));
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T getClass(JSRealm realm, DynamicObject thisObj, String className, Class<? extends T> returnType) {
        Object clazz;
        Object javaType;
        TruffleLanguage.Env env = realm.getEnv();
        assert (env.isHostLookupAllowed());
        String qualifiedName = JavaPackage.prependPackageName(thisObj, className);
        try {
            javaType = env.lookupHostSymbol(qualifiedName);
        }
        catch (Exception e) {
            return null;
        }
        if (javaType == null) {
            return null;
        }
        if (env.isHostObject(javaType) && (clazz = env.asHostObject(javaType)) instanceof Class) {
            if (returnType == Class.class) {
                return returnType.cast(clazz);
            }
            return returnType.cast(javaType);
        }
        return null;
    }

    public static DynamicObject subpackage(JSContext context, JSRealm realm, DynamicObject thisObj, String name) {
        return JavaPackage.create(context, realm, JavaPackage.prependPackageName(thisObj, name));
    }

    public static Object getJavaClassOrConstructorOrSubPackage(JSContext context, DynamicObject thisObj, String name) {
        int openParen;
        JSRealm realm = context.getRealm();
        if (context.isOptionNashornCompatibilityMode() && Boundaries.stringEndsWith(name, ")") && (openParen = name.indexOf(40)) != -1) {
            String className = Boundaries.substring(name, 0, openParen);
            Object javaClass = JavaPackage.getClass(realm, thisObj, className, Object.class);
            if (javaClass != null) {
                return javaClass;
            }
            throw Errors.createTypeErrorFormat("No such Java class: %s", JavaPackage.prependPackageName(thisObj, className));
        }
        return JavaPackage.getJavaClassOrSubPackage(context, realm, thisObj, name);
    }

    private static Object getJavaClassOrSubPackage(JSContext context, JSRealm realm, DynamicObject thisObj, String name) {
        Object javaClass = JavaPackage.getClass(realm, thisObj, name, Object.class);
        if (javaClass != null) {
            return javaClass;
        }
        return JavaPackage.subpackage(context, realm, thisObj, name);
    }

    @CompilerDirectives.TruffleBoundary
    private static String prependPackageName(DynamicObject thisObj, String className) {
        String packageName = JavaPackage.getPackageName(thisObj);
        return !packageName.isEmpty() ? packageName + "." + className : className;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    public static String toPrimitiveString(DynamicObject obj) {
        return "[JavaPackage " + JavaPackage.getPackageName(obj) + "]";
    }

    public static DynamicObject createToPrimitiveFunction(JSContext context, JSRealm realm) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.JavaPackageToPrimitive, JavaPackage::createToPrimitiveFunctionImpl);
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createToPrimitiveFunctionImpl(JSContext context) {
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object hint;
                Object[] arguments = frame.getArguments();
                Object obj = JSArguments.getThisObject(arguments);
                Object object = hint = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : null;
                if (!JSRuntime.isObject(obj)) {
                    throw Errors.createTypeError("cannot call JavaPackage[@@toPrimitive] with non-object argument");
                }
                if ("string".equals(hint)) {
                    return JavaPackage.toPrimitiveString((DynamicObject)obj);
                }
                if ("default".equals(hint) || "number".equals(hint)) {
                    return JSObject.ordinaryToPrimitive((DynamicObject)obj, "number");
                }
                throw Errors.createTypeError("invalid hint");
            }
        });
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "[Symbol.toPrimitive]");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, Object name) {
        Object propertyValue = super.getHelper(store, thisObj, name);
        if (propertyValue != null) {
            return propertyValue;
        }
        if (name instanceof String) {
            return JavaPackage.getJavaClassOrConstructorOrSubPackage(JSObject.getJSContext(store), store, (String)name);
        }
        return null;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject objectPrototype) {
        return JSObjectUtil.getProtoChildShape(objectPrototype, INSTANCE, context).addProperty(PACKAGE_PROPERTY);
    }

    static {
        PACKAGE_NAME_ID = new HiddenKey("packageName");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        PACKAGE_PROPERTY = JSObjectUtil.makeHiddenProperty(PACKAGE_NAME_ID, allocator.locationForType(String.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

