/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexCompiler;
import com.oracle.truffle.regex.RegexEngine;
import com.oracle.truffle.regex.RegexObject;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.util.CompilationResult;
import com.oracle.truffle.regex.util.LRUCache;
import java.util.Collections;
import java.util.Map;

public class CachingRegexEngine
extends RegexEngine {
    private final Map<RegexSource, CompilationResult<RegexObject>> cache = Collections.synchronizedMap(new LRUCache(1000));

    public CachingRegexEngine(RegexCompiler compiler, RegexOptions options) {
        super(compiler, options);
    }

    @Override
    public RegexObject compile(RegexSource regexSource) throws RegexSyntaxException, UnsupportedRegexException {
        CompilationResult<RegexObject> result = this.cacheGet(regexSource);
        if (result == null) {
            result = this.doCompile(regexSource);
            this.cachePut(regexSource, result);
        }
        return result.unpack();
    }

    private CompilationResult<RegexObject> doCompile(RegexSource regexSource) {
        return CompilationResult.pack(() -> super.compile(regexSource));
    }

    @CompilerDirectives.TruffleBoundary
    private CompilationResult<RegexObject> cacheGet(RegexSource source) {
        return this.cache.get(source);
    }

    @CompilerDirectives.TruffleBoundary
    private CompilationResult<RegexObject> cachePut(RegexSource source, CompilationResult<RegexObject> result) {
        return this.cache.put(source, result);
    }
}

