/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.shell;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.Os;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BourneShell
extends Shell {
    private static final char[] BASH_QUOTING_TRIGGER_CHARS = new char[]{' ', '$', ';', '&', '|', '<', '>', '*', '?', '(', ')', '[', ']', '{', '}', '`'};

    public BourneShell() {
        this.setShellCommand("/bin/sh");
        this.setArgumentQuoteDelimiter('\'');
        this.setExecutableQuoteDelimiter('\"');
        this.setSingleQuotedArgumentEscaped(true);
        this.setSingleQuotedExecutableEscaped(false);
        this.setQuotedExecutableEnabled(true);
    }

    @Override
    public String getExecutable() {
        if (Os.isFamily("windows")) {
            return super.getExecutable();
        }
        return BourneShell.unifyQuotes(super.getExecutable());
    }

    @Override
    public List<String> getShellArgsList() {
        ArrayList<String> shellArgs = new ArrayList<String>();
        List<String> existingShellArgs = super.getShellArgsList();
        if (existingShellArgs != null && !existingShellArgs.isEmpty()) {
            shellArgs.addAll(existingShellArgs);
        }
        shellArgs.add("-c");
        return shellArgs;
    }

    @Override
    public String[] getShellArgs() {
        String[] shellArgs = super.getShellArgs();
        if (shellArgs == null) {
            shellArgs = new String[]{};
        }
        if (shellArgs.length > 0 && !shellArgs[shellArgs.length - 1].equals("-c")) {
            String[] newArgs = new String[shellArgs.length + 1];
            System.arraycopy(shellArgs, 0, newArgs, 0, shellArgs.length);
            newArgs[shellArgs.length] = "-c";
            shellArgs = newArgs;
        }
        return shellArgs;
    }

    @Override
    protected String getExecutionPreamble() {
        if (this.getWorkingDirectoryAsString() == null) {
            return null;
        }
        String dir = this.getWorkingDirectoryAsString();
        StringBuilder sb = new StringBuilder();
        sb.append("cd ");
        sb.append(BourneShell.unifyQuotes(dir));
        sb.append(" && ");
        return sb.toString();
    }

    @Override
    protected char[] getQuotingTriggerChars() {
        return BASH_QUOTING_TRIGGER_CHARS;
    }

    private static String unifyQuotes(String path) {
        if (path == null) {
            return null;
        }
        if (path.indexOf(32) == -1 && path.indexOf(39) != -1 && path.indexOf(34) == -1) {
            return StringUtils.escape(path);
        }
        return StringUtils.quoteAndEscape(path, '\"', BASH_QUOTING_TRIGGER_CHARS);
    }
}

