/*
 * textsearch_ja.h
 *
 *	Copyright (c) 2008-2009, NIPPON TELEGRAPH AND TELEPHONE CORPORATION
 */
#ifndef TEXTSEARCH_JA_H
#define TEXTSEARCH_JA_H

#include "lib/stringinfo.h"

typedef struct IgnorableWord
{
	int			len;
	const char *word;
} IgnorableWord;

typedef void (*append_t)(StringInfo dst, const char *src, int srclen);

extern void normalize_utf8(StringInfo dst, const char *src, size_t srclen, append_t append);
extern void normalize_eucjp(StringInfo dst, const char *src, size_t srclen, append_t append);
extern void hiragana_utf8(StringInfo dst, const char *src, size_t srclen);
extern void hiragana_eucjp(StringInfo dst, const char *src, size_t srclen);
extern void katakana_utf8(StringInfo dst, const char *src, size_t srclen);
extern void katakana_eucjp(StringInfo dst, const char *src, size_t srclen);

extern const IgnorableWord	IGNORE_UTF8[];
extern const IgnorableWord	IGNORE_EUCJP[];

#define StringInfoTail(str, at) \
	((unsigned char *) ((str)->data + (str)->len - (at)))

#if PG_VERSION_NUM < 80400
extern text *cstring_to_text_with_len(const char *s, int n);
extern text *cstring_to_text(const char *s);
#define CStringGetTextDatum(s) PointerGetDatum(cstring_to_text(s))
#endif

#endif /* TEXTSEARCH_JA_H */
