/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.sqlj.EntryStreamHandler;

public class Loader
extends ClassLoader {
    private static final Logger s_logger = Logger.getLogger(Loader.class.getName());
    private static final String PUBLIC_SCHEMA = "public";
    private static final Map s_schemaLoaders = new HashMap();
    private static final Map s_typeMap = new HashMap();
    private final Map m_entries;

    public static void clearSchemaLoaders() {
        s_schemaLoaders.clear();
        s_typeMap.clear();
        Backend.clearFunctionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getCurrentLoader() throws SQLException {
        String string;
        Statement statement = SQLUtils.getDefaultConnection().createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT current_schema()");
            if (!resultSet.next()) {
                throw new SQLException("Unable to determine current schema");
            }
            string = resultSet.getString(1);
        }
        finally {
            SQLUtils.close(resultSet);
            SQLUtils.close(statement);
        }
        return Loader.getSchemaLoader(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSchemaLoader(String string) throws SQLException {
        Object object;
        Object object2 = (ClassLoader)s_schemaLoaders.get(string = string == null || string.length() == 0 ? PUBLIC_SCHEMA : string.toLowerCase());
        if (object2 != null) {
            return object2;
        }
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        Connection connection = SQLUtils.getDefaultConnection();
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT r.jarId FROM sqlj.jar_repository r INNER JOIN sqlj.classpath_entry c ON r.jarId = c.jarId WHERE c.schemaName = ? ORDER BY c.ordinal DESC");
            preparedStatement2 = connection.prepareStatement("SELECT entryId, entryName FROM sqlj.jar_entry WHERE jarId = ?");
            preparedStatement.setString(1, string);
            object = preparedStatement.executeQuery();
            try {
                while (object.next()) {
                    preparedStatement2.setInt(1, object.getInt(1));
                    ResultSet resultSet = preparedStatement2.executeQuery();
                    try {
                        while (resultSet.next()) {
                            int n = resultSet.getInt(1);
                            String string2 = resultSet.getString(2);
                            int[] nArray = (int[])hashMap.get(string2);
                            if (nArray == null) {
                                hashMap.put(string2, new int[]{n});
                                continue;
                            }
                            int n2 = nArray.length;
                            int[] nArray2 = new int[n2 + 1];
                            nArray2[0] = n;
                            System.arraycopy(nArray, 0, nArray2, 1, n2);
                            hashMap.put(string2, nArray2);
                        }
                    }
                    finally {
                        SQLUtils.close(resultSet);
                    }
                }
            }
            finally {
                SQLUtils.close((ResultSet)object);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.close(preparedStatement);
            SQLUtils.close(preparedStatement2);
            throw throwable;
        }
        SQLUtils.close(preparedStatement);
        SQLUtils.close(preparedStatement2);
        object = ClassLoader.getSystemClassLoader();
        object2 = hashMap.size() == 0 ? (string.equals(PUBLIC_SCHEMA) ? object : Loader.getSchemaLoader(PUBLIC_SCHEMA)) : new Loader(hashMap, (ClassLoader)object);
        s_schemaLoaders.put(string, object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getTypeMap(final String string) throws SQLException {
        Map map = (Map)s_typeMap.get(string);
        if (map != null) {
            return map;
        }
        s_logger.fine("Creating typeMappings for schema " + string);
        map = new HashMap(){

            @Override
            public Object get(Object object) {
                s_logger.fine("Obtaining type mapping for OID " + object + " for schema " + string);
                return super.get(object);
            }
        };
        ClassLoader classLoader = Loader.getSchemaLoader(string);
        Statement statement = SQLUtils.getDefaultConnection().createStatement();
        ResultSet resultSet = null;
        try {
            Object object;
            resultSet = statement.executeQuery("SELECT javaName, sqlName FROM sqlj.typemap_entry");
            while (resultSet.next()) {
                try {
                    object = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    Class<?> clazz = classLoader.loadClass((String)object);
                    if (!SQLData.class.isAssignableFrom(clazz)) {
                        throw new SQLException("Class " + (String)object + " does not implement java.sql.SQLData");
                    }
                    Oid oid = Oid.forTypeName(string2);
                    map.put(oid, clazz);
                    s_logger.fine("Adding type mapping for OID " + oid + " -> class " + clazz.getName() + " for schema " + string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (map.isEmpty()) {
                map = Collections.EMPTY_MAP;
            }
            s_typeMap.put(string, map);
            object = map;
            return object;
        }
        finally {
            SQLUtils.close(resultSet);
            SQLUtils.close(statement);
        }
    }

    private static URL entryURL(int n) {
        try {
            return new URL("dbf", "localhost", -1, "/" + n, EntryStreamHandler.getInstance());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    Loader(Map map, ClassLoader classLoader) {
        super(classLoader);
        this.m_entries = map;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/').concat(".class");
        int[] nArray = (int[])this.m_entries.get(string2);
        if (nArray != null) {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block5: {
                Class<?> clazz;
                preparedStatement = null;
                resultSet = null;
                try {
                    preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryImage FROM sqlj.jar_entry WHERE entryId = ?");
                    preparedStatement.setInt(1, nArray[0]);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block5;
                    byte[] byArray = resultSet.getBytes(1);
                    resultSet.close();
                    resultSet = null;
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getAnonymousLogger().log(Level.INFO, "Failed to load class", sQLException);
                        throw new ClassNotFoundException(string + " due to: " + sQLException.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.close(resultSet);
                        SQLUtils.close(preparedStatement);
                        throw throwable;
                    }
                }
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement);
                return clazz;
            }
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    protected URL findResource(String string) {
        int[] nArray = (int[])this.m_entries.get(string);
        if (nArray == null) {
            return null;
        }
        return Loader.entryURL(nArray[0]);
    }

    protected Enumeration findResources(String string) throws IOException {
        int[] nArray = (int[])this.m_entries.get(string);
        if (nArray == null) {
            nArray = new int[]{};
        }
        return new EntryEnumeration(nArray);
    }

    static class EntryEnumeration
    implements Enumeration {
        private final int[] m_entryIds;
        private int m_top = 0;

        EntryEnumeration(int[] nArray) {
            this.m_entryIds = nArray;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_top < this.m_entryIds.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.m_top >= this.m_entryIds.length) {
                throw new NoSuchElementException();
            }
            return Loader.entryURL(this.m_entryIds[this.m_top++]);
        }
    }
}

