/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;

public class SQLOutputToChunk
implements SQLOutput {
    private static final byte[] s_byteBuffer = new byte[8];
    private long m_handle;

    public SQLOutputToChunk(long l) {
        this.m_handle = l;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw new UnsupportedOperationException("writeArray");
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("writeAsciiStream");
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.writeString(bigDecimal.toString());
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.writeBytes(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        throw new UnsupportedOperationException("writeBlob");
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.write(bl ? 1 : 0);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.write(by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        int n = byArray.length;
        if (n > 0) {
            if (n > 65535) {
                throw new SQLException("Byte buffer exceeds maximum size of 65535 bytes");
            }
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                if (this.m_handle == 0L) {
                    throw new SQLException("Stream is closed");
                }
                SQLOutputToChunk.s_byteBuffer[0] = (byte)(n >> 8 & 0xFF);
                SQLOutputToChunk.s_byteBuffer[1] = (byte)(n & 0xFF);
                SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 2);
                SQLOutputToChunk._writeBytes(this.m_handle, byArray, n);
            }
        }
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        char[] cArray = new char[1024];
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = reader.read(cArray)) > 0) {
                stringWriter.write(cArray, 0, n);
            }
            this.writeString(stringWriter.toString());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        throw new UnsupportedOperationException("writeClob");
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.writeLong(date.getTime());
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.writeInt(Float.floatToIntBits(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInt(int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SQLOutputToChunk.s_byteBuffer[0] = (byte)(n >>> 24);
            SQLOutputToChunk.s_byteBuffer[1] = (byte)(n >>> 16);
            SQLOutputToChunk.s_byteBuffer[2] = (byte)(n >>> 8);
            SQLOutputToChunk.s_byteBuffer[3] = (byte)(n >>> 0);
            SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLong(long l) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SQLOutputToChunk.s_byteBuffer[0] = (byte)(l >>> 56);
            SQLOutputToChunk.s_byteBuffer[1] = (byte)(l >>> 48);
            SQLOutputToChunk.s_byteBuffer[2] = (byte)(l >>> 40);
            SQLOutputToChunk.s_byteBuffer[3] = (byte)(l >>> 32);
            SQLOutputToChunk.s_byteBuffer[4] = (byte)(l >>> 24);
            SQLOutputToChunk.s_byteBuffer[5] = (byte)(l >>> 16);
            SQLOutputToChunk.s_byteBuffer[6] = (byte)(l >>> 8);
            SQLOutputToChunk.s_byteBuffer[7] = (byte)(l >>> 0);
            SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 8);
        }
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        throw new UnsupportedOperationException("writeObject");
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw new UnsupportedOperationException("writeRef");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeShort(short s) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SQLOutputToChunk.s_byteBuffer[0] = (byte)(s >>> 8);
            SQLOutputToChunk.s_byteBuffer[1] = (byte)(s >>> 0);
            SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 2);
        }
    }

    @Override
    public void writeString(String string) throws SQLException {
        try {
            this.writeBytes(string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("UTF8 encoding not supported by JVM");
        }
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        throw new UnsupportedOperationException("writeStruct");
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.writeLong(time.getTime());
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.writeLong(timestamp.getTime());
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        this.writeString(uRL.toString());
    }

    void close() {
        this.m_handle = 0L;
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeNClob( NClob ) not implemented yet.", "0A000");
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeNString( String ) not implemented yet.", "0A000");
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeRowId( RowId ) not implemented yet.", "0A000");
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeSQLXML( SQLXML ) not implemented yet.", "0A000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_handle == 0L) {
                throw new SQLException("Stream is closed");
            }
            SQLOutputToChunk._writeByte(this.m_handle, n);
        }
    }

    private static native void _writeByte(long var0, int var2);

    private static native void _writeBytes(long var0, byte[] var2, int var3);
}

