#!/bin/sh

BASE_PATH=`pwd`
ORG_PGPORT=`psql -tA -c "SHOW port" postgres`

## setup test dbcluster
export PGDATA=$BASE_PATH/results/pgdata
export PGPORT=$(($ORG_PGPORT + 1))
export PGARC=$BASE_PATH/results/pgarc

function show_stats() {
	psql contrib_regression_stats <<EOF
SELECT snapshot_id, hostname, dbname, port = $PGPORT AS port, level, description FROM statsinfo.snapshot_history WHERE snapshot_date IS NOT NULL AND snapshot_date >= '$1' AND snapshot_date < now() ORDER BY 1;
SELECT * FROM statsinfo.snapshot_history WHERE snapshot_date IS NULL OR snapshot_date < '$1' OR snapshot_date >= now() ORDER BY 1;
SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1;
SELECT snapshot_id, dbid, autovacuum_act_time IS NULL AS autovacuum_act_time, autovacuum_table, autovacuum_num_page_remove, autovacuum_num_page_remain, autovacuum_num_tup_remove, autovacuum_num_tup_remain, autovacuum_duration FROM statsinfo.t_autovacuuminfo ORDER BY 1;
SELECT host_snapshot_id, checkpoint_start_trig FROM statsinfo.t_checkpointinfo WHERE checkpoint_act_time IS NOT NULL AND checkpoint_num_buffers IS NOT NULL AND checkpoint_create_wal IS NOT NULL AND checkpoint_delete_wal IS NOT NULL AND checkpoint_recycle_wal IS NOT NULL AND checkpoint_write_duration IS NOT NULL AND checkpoint_sync_duration IS NOT NULL AND checkpoint_total_duration IS NOT NULL ORDER BY 1;
SELECT snapshot_id, dbid, schemaname, tablename, column_name, n_distinct IS NULL AS n_distinct, correlation IS NULL AS correlation FROM statsinfo.t_columninfo ORDER BY 1;
SELECT snapshot_id, dbid, conn_number, num_user_rel FROM statsinfo.t_dbinfo WHERE dbsize IS NOT NULL AND datfrozenxid_age IS NOT NULL AND db_xact_commit IS NOT NULL AND db_xact_rollback IS NOT NULL AND db_blks_read IS NOT NULL AND db_blks_hit IS NOT NULL AND db_tup_returned IS NOT NULL AND db_tup_fetched IS NOT NULL AND db_tup_inserted IS NOT NULL AND db_tup_updated IS NOT NULL AND db_tup_deleted IS NOT NULL ORDER BY 1;
SELECT host_snapshot_id, host_id FROM statsinfo.t_hostinfo WHERE host_snapshot_date IS NOT NULL AND kernel_version IS NOT NULL AND processors IS NOT NULL AND mem_total IS NOT NULL AND swap_total IS NOT NULL AND pg_version IS NOT NULL AND maxwritten_clean IS NOT NULL ORDER BY 1;
SELECT snapshot_id, dbid, schemaname, index_oid > 0 AS index_oid, indexname, tablename, indexdef, cluster_key, index_size, idx_scan, bmp_tup_fetch, idx_tup_fetch, idx_blks_read, idx_blks_hit FROM statsinfo.t_indexinfo ORDER BY 1;
SELECT snapshot_id, dbid, schemaname, table_oid > 0 AS table_oid, tablename, relpages, reltuples, n_tup_ins, n_tup_upd, n_tup_del, n_tup_hot_upd, seq_scan, idx_scan, seq_tup_read, idx_tup_fetch, heap_blks_hit, idx_blks_hit, toast_blks_hit, tidx_blks_hit, heap_blks_read, idx_blks_read, toast_blks_read, tidx_blks_read, n_live_tuple, n_dead_tuple, relation_size, last_vacuum, last_autovacuum IS NULL AS last_autovacuum, last_analyze, last_autoanalyze IS NULL AS last_autoanalyze FROM statsinfo.t_tableinfo ORDER BY 1;
EOF
}

mkdir -p $BASE_PATH/results/stats

## get dbid
DBID1=`psql -tA -c "SELECT dbid FROM statsinfo.t_dbconn WHERE dbname = 'contrib_regression_target1'" contrib_regression_stats`
DBID2=`psql -tA -c "SELECT dbid FROM statsinfo.t_dbconn WHERE dbname = 'contrib_regression_target2'" contrib_regression_stats`
DBID3=`psql -tA -c "SELECT dbid FROM statsinfo.t_dbconn WHERE dbname = 'contrib_regression_target3'" contrib_regression_stats`
echo DBID1 is $DBID1
echo DBID2 is $DBID2
echo DBID3 is $DBID3

## get stats and show stats tables
START_DATE=`psql -tA -c "SELECT to_char(now(), 'YYYY-MM-DD HH24:MI:SS')" contrib_regression_stats`

# execute checkpoint
psql -c "CHECKPOINT" contrib_regression_target1
psql -c "CHECKPOINT" contrib_regression_target1
psql -c "SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1" contrib_regression_stats

show_stats $START_DATE

psql -c "SELECT statsinfo.get_stats()" contrib_regression_stats
show_stats $START_DATE

# execute checkpoint
psql -c "CHECKPOINT" contrib_regression_target1
psql -c "SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1" contrib_regression_stats

psql -c "SELECT statsinfo.get_stats($DBID1)" contrib_regression_stats
show_stats $START_DATE

# needed autovacuum analyze
psql -c "INSERT INTO foo1 SELECT i, i FROM generate_series(1, 100) g(i)" contrib_regression_target1
psql -c "INSERT INTO foo3 SELECT i, i FROM generate_series(1, 100) g(i)" contrib_regression_target3

sleep 1
DEL_DATE=`psql -tA -c "SELECT to_char(now(), 'YYYY-MM-DD HH24:MI:SS')" contrib_regression_stats`
sleep 1

psql -c "SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1" contrib_regression_stats

psql -c "SELECT statsinfo.get_stats('description test1')" contrib_regression_stats
show_stats $START_DATE

psql -c "UPDATE foo1 SET id = id" contrib_regression_target1
psql -c "UPDATE foo3 SET id = id + 100" contrib_regression_target3
sleep 2
psql -c "SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1" contrib_regression_stats

psql -c "SELECT statsinfo.get_stats($DBID3, 'description test2')" contrib_regression_stats
show_stats $START_DATE

END_DATE=`psql -tA -c "SELECT to_char(now(), 'YYYY-MM-DD HH24:MI:SS')" contrib_regression_stats`

## test target_db
psql contrib_regression_target1 <<EOF
SELECT * FROM targetdb.check_column_correlation;
CLUSTER foo1 USING foo1_pkey;
SELECT relid > 0 AS relid, schemaname, relname, column_name, correlation IS NULL AS correlation FROM targetdb.check_column_correlation;
SELECT oid > 0 AS oid, schemaname, relname, reltuples, logical_pages > 0 AS logical_pages, physical_pages > 0 AS physical_pages FROM targetdb.table_sizes ORDER BY targetdb.table_sizes.oid;
SELECT targetdb.pg_fillfactor(reloptions, relam) FROM pg_class WHERE relname = 'foo1';
SELECT oid > 0 AS oid, schemaname, relname, reltuples, logical_pages, physical_pages, tratio FROM targetdb.check_filling_ratio;

SELECT oid, name, location = '$PGDATA/pg_xlog' AS location FROM targetdb.v_xlog_dir;
SELECT oid, name, location = '$PGARC/' AS location FROM targetdb.v_archive_dir;
SELECT oid, name, location IS NULL AS location FROM targetdb.pg_filesystem ORDER BY 2;
SELECT targetdb.pg_fs_size('$BASE_PATH/sql') > 0 AS pg_fs_size;
SELECT targetdb.pg_fs_avail('$BASE_PATH/sql') > 0 AS pg_fs_avail;
SELECT targetdb.pg_fs_devname('$BASE_PATH/sql') IS NULL AS pg_fs_devname;
SELECT targetdb.pg_fs_devid('$BASE_PATH/sql') IS NULL AS pg_fs_devid;
SELECT count(*) FROM targetdb.pg_filesystem_size;
SELECT model_name IS NULL AS model_name, processors > 0 AS processors, cpu_mhz > 0 AS cpu_mhz, bogompis > 0 AS bogompis FROM targetdb.stats_cpu_info();
SELECT mem_total IS NULL AS mem_total, mem_free IS NULL AS mem_free, buffers IS NULL AS buffers, cahced IS NULL AS cahced, active IS NULL AS cahced, inactive IS NULL AS inactive, swap_total IS NULL AS swap_total, swap_free IS NULL AS swap_free FROM targetdb.stats_mem_info();
SELECT kernel_info IS NULL AS kernel_info FROM targetdb.stats_kernel_info();
SELECT kernel_version IS NULL AS kernel_version, processors > 0 AS processors, mem_total > 0 AS mem_total, swap_total >= 0 AS swap_total FROM targetdb.stats_hostinfo();
SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1;
SELECT autovacuum_act_time IS NULL AS autovacuum_act_time, autovacuum_table, autovacuum_num_page_remove, autovacuum_num_page_remain, autovacuum_num_tup_remove, autovacuum_num_tup_remain, autovacuum_duration FROM targetdb.stats_autovacuuminfo();
SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1;
SELECT * FROM targetdb.stats_checkpointinfo();
SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1;
SELECT * FROM targetdb.unlink_stats_autovacuumlogfile('contrib_regression_target1');
SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1;
SELECT * FROM targetdb.unlink_stats_checkpointlogfile();
SELECT * FROM pg_ls_dir('pg_statslog') ORDER BY 1;
EOF

## delete stats and show stats tables
show_stats $START_DATE
psql -c "SELECT statsinfo.delete_stats(2)" contrib_regression_stats
show_stats $START_DATE
psql -c "SELECT statsinfo.delete_stats(snapshot_id) FROM statsinfo.snapshot_history WHERE snapshot_date < '$DEL_DATE'" contrib_regression_stats
show_stats $START_DATE
# become the error for a bug
psql -c "SELECT statsinfo.delete_stats(snapshot_id) FROM statsinfo.snapshot_history" contrib_regression_stats
show_stats $START_DATE

## stop postgres
pg_ctl stop > $BASE_PATH/results/stats/pg_stop.log 2>&1
