#include "connection.h"
#include "statement.h"
#include "protocol.h"
#include "common.h"

#define SQL_FUNC_IMPLEMENTED(pfExists, uwAPI) \
				((*(((UWORD*) (pfExists)) + ((uwAPI) >> 4)) \
					|= (1 << ((uwAPI) & 0x000F)) \
 				 ) \
				)

TCHAR c_SQLTables_query[]           = _T("SELECT g,n.nspname,c.relname,(SELECT CASE\?\?\? END),d.description FROM current_database() g,pg_namespace n,pg_class c LEFT JOIN pg_description d ON (c.oid=d.objoid AND d.objsubid=0) WHERE n.oid=c.relnamespace AND (?\?\?)\?\?\?\? ORDER BY 2,3,4");
TCHAR c_SQLColumns_query[]          = _T("SELECT a.atttypmod,n.nspname,c.relname,a.attname,a.atttypid,q.typname,a.attlen,null,null,null,case when a.attnotnull='f' then 1 else 0 end,d.description,f.adsrc,null,null,null,a.attnum,null FROM current_database() g,pg_catalog.pg_type q,pg_catalog.pg_namespace n,pg_catalog.pg_class c,pg_catalog.pg_attribute a LEFT JOIN pg_catalog.pg_description d ON (a.attrelid=d.objoid AND a.attnum=d.objsubid) LEFT JOIN pg_catalog.pg_attrdef f ON (a.attrelid=f.adrelid AND a.attnum=f.adnum) WHERE a.attnum>0 AND c.oid=a.attrelid AND n.oid=c.relnamespace AND a.atttypid=q.oid AND c.relkind in ('r','v')\?\?\?\?");
TCHAR c_SQLProcedureColumns[]       = _T("SELECT g,n.nspname,p.proname,CASE WHEN a.n=0 THEN''::text ELSE NULLIF(p.proargnames[a.n],''::text)END,NULL,CASE WHEN a.n=0 THEN p.prorettype ELSE p.proargtypes[a.n-1]END,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,a.n,NULL FROM current_database()g,pg_catalog.pg_proc p,pg_catalog.pg_namespace n,(SELECT 0 UNION SELECT information_schema._pg_keypositions())a(n)WHERE n.oid=p.pronamespace AND p.pronargs>=a.n\?\?\?\? ORDER BY 1,2,3");
TCHAR c_SQLProcedures_query[]       = _T("SELECT DISTINCT g,n.nspname,p.proname,'','','',d.description,CASE WHEN p.prorettype = 0 THEN 1 ELSE 2 END FROM current_database() g,pg_catalog.pg_namespace n, pg_catalog.pg_proc p LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid AND d.objsubid=0) WHERE p.pronamespace = n.oid\?\?\?\? ORDER BY 1,2,3");
TCHAR c_SQLStatistics_query[]       = _T("SELECT g,n.nspname,c.relname,CASE WHEN w.indisunique THEN 0 ELSE 1 END,w.relname,i.conname,CASE WHEN w.indisclustered THEN 1 WHEN w.amname='hash'THEN 2 ELSE 3 END,a.n,ta.attname,w.asc,w.reltuples,w.relpages,COALESCE(i.consrc,''::text)FROM current_database()g,pg_catalog.pg_namespace n,pg_catalog.pg_class c,pg_catalog.pg_attribute ta,pg_catalog.pg_constraint i LEFT JOIN(SELECT 'A'::char AS asc,y.relname,y.relnamespace,u.indrelid,u.indisunique,u.indisclustered,m.amname,y.reltuples,y.relpages FROM pg_catalog.pg_class y,pg_catalog.pg_am m,pg_catalog.pg_index u WHERE y.relam=m.oid AND u.indexrelid=y.oid) w ON(i.connamespace=w.relnamespace AND i.conrelid=w.indrelid AND i.conname=w.relname),information_schema._pg_keypositions()a(n)WHERE c.oid=i.conrelid AND n.oid=c.relnamespace AND(i.contype IN('u'::char,'c'::char))AND ta.attrelid=i.conrelid AND ta.attnum=i.conkey[a.n]AND(NOT ta.attisdropped)\?\?\? ORDER BY 4,7,5,6,8");
TCHAR c_SQLPrimaryKeys_query[]      = _T("SELECT g,n.nspname,c.relname,ta.attname,i.conkey[a.n],i.conname FROM current_database()g,pg_catalog.pg_namespace n,pg_catalog.pg_class c,pg_catalog.pg_attribute ta,pg_catalog.pg_constraint i,information_schema._pg_keypositions()a(n)WHERE c.oid=i.conrelid AND n.oid=c.relnamespace AND i.contype='p'::char AND ta.attrelid=i.conrelid AND ta.attnum=i.conkey[a.n]AND(NOT ta.attisdropped)\?\?\?\? ORDER BY 5");
TCHAR c_SQLForeignKeys_query_1[]    = _T("SELECT g,n.nspname,c.relname,a.attname,g,fn.nspname,fc.relname,fa.attname,b.n,NULL,NULL,f.conname,pr.conname,CASE WHEN NOT f.condeferred THEN 7 WHEN f.condeferrable THEN 5 ELSE 6 END FROM current_database()g,pg_catalog.pg_attribute a,pg_catalog.pg_attribute fa,pg_catalog.pg_class c,pg_catalog.pg_class fc,pg_catalog.pg_namespace n,pg_catalog.pg_namespace fn,pg_catalog.pg_constraint f left join pg_catalog.pg_constraint pr on(f.conrelid=pr.conrelid and pr.contype='p'),information_schema._pg_keypositions()b(n)WHERE fn.oid=fc.relnamespace AND n.oid=c.relnamespace AND c.oid=f.confrelid AND fc.oid=f.conrelid AND a.attrelid=f.confrelid AND fa.attrelid=f.conrelid AND a.attnum=f.confkey[b.n]AND fa.attnum=f.conkey[b.n]AND f.contype='f'AND f.conkey[b.n]<>0\?\?\?\?");
TCHAR c_SQLForeignKeys_query_2[]    = _T("SELECT g,n.nspname,pc.relname,pa.attname,g,n.nspname,c.relname,a.attname,b.n,NULL,NULL,f.conname,pr.conname,CASE WHEN NOT f.condeferred THEN 7 WHEN f.condeferrable THEN 5 ELSE 6 END FROM current_database()g,pg_catalog.pg_attribute a,pg_catalog.pg_attribute pa,pg_catalog.pg_class c,pg_catalog.pg_class pc,pg_catalog.pg_namespace n,pg_catalog.pg_namespace pn,pg_catalog.pg_constraint f left join pg_catalog.pg_constraint pr on(f.conrelid=pr.conrelid and pr.contype='p'),information_schema._pg_keypositions()b(n)WHERE n.oid=c.relnamespace AND pn.oid=pc.relnamespace AND pc.oid=f.confrelid AND c.oid=f.conrelid AND pa.attrelid=f.confrelid AND a.attrelid=f.conrelid AND pa.attnum=f.confkey[b.n]AND a.attnum=f.conkey[b.n]AND f.contype='f'AND f.conkey[b.n]<>0\?\?\?\?");
TCHAR c_SQLSpecialColumns_query[]   = _T("select c.relhasoids from pg_catalog.pg_class c, pg_catalog.pg_namespace n where c.relnamespace = n.oid and c.relhasoids and c.relname='\?' and n.nspname='\?'");
TCHAR c_SQLTablePrivileges_query[]  = _T("SELECT g,n.nspname,c.relname,CASE WHEN u.usename=o.usename THEN'_SYSTEM'::text ELSE u.usename END,o.usename,p.type,CASE WHEN aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,TRUE))THEN'YES'::text ELSE'NO'::text END FROM current_database()g,pg_catalog.pg_class c,pg_catalog.pg_namespace n,pg_catalog.pg_user u,(SELECT z.usename,z.usesysid,x.grosysid FROM pg_catalog.pg_user z LEFT JOIN pg_catalog.pg_group x ON z.usesysid=ANY(x.grolist))o,((((((SELECT'SELECT'UNION ALL SELECT'DELETE')UNION ALL SELECT'INSERT')UNION ALL SELECT'UPDATE')UNION ALL SELECT'REFERENCES')UNION ALL SELECT'RULE')UNION ALL SELECT'TRIGGER')p(type)WHERE c.relnamespace=n.oid AND(c.relkind in('r'::char,'v'::char)AND(c.relowner=o.usesysid AND u.usesysid=c.relowner) OR (aclcontains(c.relacl,makeaclitem(0,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(0,o.grosysid,u.usesysid,p.type,FALSE))))\?\?\?\? ORDER BY 1,2,3,6,5");
TCHAR c_SQLColumnPrivileges_query[] = _T("SELECT DISTINCT g,n.nspname,c.relname,a.attname,CASE WHEN u.usename=o.usename THEN'_SYSTEM'::text ELSE u.usename END,o.usename,p.type,CASE WHEN aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,TRUE))THEN'YES'::text ELSE'NO'::text END FROM current_database()g,pg_catalog.pg_class c,pg_catalog.pg_namespace n,pg_catalog.pg_user u,(SELECT z.usename,z.usesysid,x.grosysid FROM pg_catalog.pg_user z LEFT JOIN pg_catalog.pg_group x ON z.usesysid=ANY(x.grolist))o,((((((SELECT'SELECT'UNION ALL SELECT'DELETE')UNION ALL SELECT'INSERT')UNION ALL SELECT'UPDATE')UNION ALL SELECT'REFERENCES')UNION ALL SELECT'RULE')UNION ALL SELECT'TRIGGER')p(type),pg_catalog.pg_attribute a WHERE a.attnum>0 AND NOT a.attisdropped AND a.attrelid = c.oid ")_T("AND c.relnamespace=n.oid AND(c.relkind in('r'::char,'v'::char)AND(c.relowner=o.usesysid AND u.usesysid=c.relowner) OR (aclcontains(c.relacl,makeaclitem(0,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(0,o.grosysid,u.usesysid,p.type,FALSE))))\?\?\?\? ORDER BY 1,2,3,4,7");

TCHAR c_SQLTables_ST[]  = _T(" when(n.nspname='pg_catalog')then'SYSTEM TABLE'");
TCHAR c_SQLTables_T[]   = _T(" when(c.relkind='r')then'TABLE'");
TCHAR c_SQLTables_V[]   = _T(" when(c.relkind='v')then'VIEW'");
TCHAR c_SQLTables_ST_[] = _T("(n.nspname='pg_catalog'and c.relkind in('r','v'))");
/* WARNING! following string must begin from ' or ', used in SQLTables */
TCHAR c_SQLTables_V_[]  = _T(" or (n.nspname<>'pg_catalog'and c.relkind='v')");
TCHAR c_SQLTables_T_[]  = _T(" or (n.nspname<>'pg_catalog'and c.relkind='r')");

/* for CompileCSOCQuery(...) */
TCHAR c_query_catalog[]   = _T(" AND g\?'\?'");
TCHAR c_query_procedure[] = _T(" AND p.proname\?'\?'");
TCHAR c_query_schema[]    = _T(" AND n.nspname\?'\?'");
TCHAR c_query_table[]     = _T(" AND c.relname\?'\?'");
TCHAR c_query_column[]    = _T(" AND a.attname\?'\?'");
TCHAR c_query_like[]      = _T(" LIKE");
TCHAR c_query_equal[]     = _T("=");

/*-----------------------------------------------------------------------------
 * SQLColumns
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLColumns_(SQLHSTMT StatementHandle,
            SQLTCHAR *CatalogName, SQLSMALLINT CatalogNameLength,
            SQLTCHAR *SchemaName,  SQLSMALLINT SchemaNameLength,
            SQLTCHAR *TableName,   SQLSMALLINT TableNameLength,
            SQLTCHAR *ColumnName,  SQLSMALLINT ColumnNameLength)
{
	SQLRETURN      nRet       = SQL_ERROR;
	TextConversion conv       = TC_AS_IS;
	SQLTCHAR*      query      = NULL;
	Statement*     pStatement = (Statement*) StatementHandle;
	int         nRowsResulted = 0;
		
	ENTER_STMT(StatementHandle, _T("SQLColumns"));
    nRet = ResetStatement((Statement*) StatementHandle);
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement(pStatement))))
	{
		if (query = CompileCSOCQuery(pStatement, c_SQLColumns_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength,
TableName, TableNameLength, ColumnName, ColumnNameLength, CSOC_OBJ_TABLE))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery(pStatement, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement(pStatement, TRUE))) &&
					(0 == pStatement->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
    		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}
	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		SQLUINTEGER odbc_version = pStatement->connection->environment->attributes.odbc_version;
		/* choose correct data to return - ODBC 2.0 (15) and ODBC 3.0 (18) have different resultsets */
		int nColumns = (SQL_OV_ODBC2 == odbc_version) ? 15 : 18;

		Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);
		SetDescField(pIRD, 0, SQL_DESC_COUNT, (SQLPOINTER)(SQLSMALLINT)nColumns, SQL_IS_SMALLINT);
		RET_DESCRIPTOR(pIRD);

		RenameColumns(pStatement, c_ColumnsColumns, nColumns);
		/* -- handmade resultset -- */
		if (0 < (nRowsResulted = pStatement->ird->header.array_size))
		{
			int   length;
			TCHAR buffer[20];
		
			TCHAR* null_field;
			TCHAR* catalog;
			TCHAR* yes;
			TCHAR* no;

			SQLINTEGER  data_length;
			SQLINTEGER  display_length;
			SQLINTEGER  num_prec_radix;
			SQLSMALLINT concise_type;
			SQLSMALLINT type;
			TCHAR*      pBuffer;

			pIRD = GET_DESCRIPTOR(pStatement->ird);

			/* save catalog name */
			catalog = AddField(pStatement, length = _tcslen(pStatement->connection->parameters[DATABASE_PARAM]));
			_tcsncpy(catalog, pStatement->connection->parameters[DATABASE_PARAM], length);
			catalog -= sizeof(int)/sizeof(TCHAR);
			/* save "YES" and "NO" for nullability */
			_tcsncpy(yes = AddField(pStatement, STR_SIZEOF("YES")), _T("YES"), STR_SIZEOF("YES"));
			yes -= sizeof(int)/sizeof(TCHAR);
			_tcsncpy(no = AddField(pStatement, STR_SIZEOF("NO")), _T("NO"), STR_SIZEOF("NO"));
			no -= sizeof(int)/sizeof(TCHAR);
			null_field = AddField(pStatement, 0);
			null_field -= sizeof(int)/sizeof(TCHAR);

			/* prepare resultset */
			for (--nRowsResulted;0<=nRowsResulted;nRowsResulted--)
			{
				SQLTCHAR* type_name = (SQLTCHAR*)((int*)pIRD->id_records[5].common.data_ptr[nRowsResulted]+1);
				PostgreTypeConverter(_ttoi((TCHAR*)((int*)pIRD->id_records[4].common.data_ptr[nRowsResulted]+1)), /* type oid */
				_ttoi((TCHAR*)((int*)pIRD->id_records[0].common.data_ptr[nRowsResulted]+1)), /* type modifier */
                        &type_name,                                                                  /* type name */
														 *(int*)pIRD->id_records[5].common.data_ptr[nRowsResulted],
														 &concise_type,
														 &data_length,
														 NULL, NULL, NULL, NULL);
				SQLTypeDescriptor(concise_type, 0, &data_length, NULL, NULL, &type, &display_length, NULL, &num_prec_radix);
				/* TABLE_CAT */
				pIRD->id_records[0].common.data_ptr[nRowsResulted] = catalog;
				/* TABLE_SCHEM */
				/* TABLE_NAME */
				/* COLUMN_NAME */
				/* DATA_TYPE */
				_itot(concise_type, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				pIRD->id_records[4].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer)-sizeof(int);
				/* TYPE_NAME */
				/* COLUMN_SIZE */
				_itot(data_length, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				pIRD->id_records[6].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer)-sizeof(int);
				/* BUFFER_LENGTH */
				_itot(display_length, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				pIRD->id_records[7].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer)-sizeof(int);
				/* DECIMAL_DIGITS */
				/* NUM_PREC_RADIX */
				if (0 == num_prec_radix)
					pIRD->id_records[9].common.data_ptr[nRowsResulted] = null_field;
				else
				{
					_itot(num_prec_radix, buffer, 10);
					pBuffer = AddField(pStatement, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
					pIRD->id_records[9].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer)-sizeof(int);
				}
				/* NULLABLE */
				/* REMARKS */
				/* COLUMN_DEF */
				/* SQL_DATA_TYPE */
				_itot(type, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				pIRD->id_records[13].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer)-sizeof(int);
				/* SQL_DATETIME_SUB */
				/* CHAR_OCTET_LENGTH */

				/* ORDINAL_POSITION */
				/* IS_NULLABLE */
				pIRD->id_records[17].common.data_ptr[nRowsResulted] = (_T('0') == *(TCHAR*)((int*)pIRD->id_records[17].common.data_ptr[nRowsResulted]+1)) ? no : yes;
			}
			RET_DESCRIPTOR(pIRD);
		}
	}
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLDriverConnect
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLDriverConnect_(SQLHDBC ConnectionHandle, SQLHWND hwnd,
                  SQLTCHAR* ConnStrIn,  SQLSMALLINT ConnStrInLength,
                  SQLTCHAR* ConnStrOut, SQLSMALLINT ConnStrOutMax,
                  SQLSMALLINT* pcbConnStrOut, SQLUSMALLINT fDriverCompletion
								 )
{
	SQLRETURN nRet;
	SQLRETURN nRes;
	Connection* pConnection = (Connection*) ConnectionHandle;

	ENTER_CONN(ConnectionHandle, _T("SQLDriverConnect"));
	ConnStrOutMax = BYTES_TO_CHARACTERS(ConnStrOutMax);

	/* parse input connection string */	
	switch (ParseConnectionString(pConnection, ConnStrIn, ConnStrInLength))
	{
		case SQL_NEED_DATA:
			if (SQL_DRIVER_NOPROMPT == fDriverCompletion)
				nRet = SQL_ERROR;
			else
			{
			
			}
			break;
		case SQL_SUCCESS_WITH_INFO:
			if (SQL_SUCCESS == (nRet = Connect(pConnection)))
				nRet = SQL_SUCCESS_WITH_INFO;
			break;
		case SQL_SUCCESS:
			nRes = PrepareConnectionString(ConnStrOut, ConnStrOutMax, pcbConnStrOut, pConnection->parameters, pConnection->dsn);
			if (SQL_SUCCESS_WITH_INFO == nRes)
				SetError(SQL_HANDLE_DBC, pConnection, ERR_TOO_SMALL_BUFFER, _T("ConnStrOut"), NULL);
			nRet = Connect(pConnection);
			if (SQL_SUCCESS == nRet)
				nRet = nRes;
			break;
		default:
			nRet = SQL_ERROR;
	}

	LEAVE_CONN(ConnectionHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLGetData
 *
 * DESCRIPTION: returns the data in a specified column
 *
 *  -- relaxed restrictions ---------------------------------------------------
 *  1. SQL_GD_BOUND - applicable for any column in result set (including bound)
 *  2. SQL_GD_ANY_ORDER - can be called in any order for unbound columns
 *  3. SQL_GD_ANY_COLUMN - can be called for any unbound column before the last
 *                         bound column
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetData(SQLHSTMT StatementHandle, SQLUSMALLINT ColumnNumber, SQLSMALLINT TargetType,
           SQLPOINTER TargetValue, SQLINTEGER BufferLength, SQLINTEGER *StrLen_or_Ind
					)
{
	SQLRETURN nRet;

	ENTER_STMT(StatementHandle, _T("SQLGetData"));
	nRet = GetData((Statement*) StatementHandle, ColumnNumber, TargetType, TargetValue, BufferLength, StrLen_or_Ind);
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLGetFunctions
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetFunctions(SQLHDBC ConnectionHandle, SQLUSMALLINT FunctionId, SQLUSMALLINT *Supported)
{
	ENTER_CONN(ConnectionHandle, _T("SQLGetFunctions"));
	switch(FunctionId)
	{
		/* ODBC 3.0 and earlier */
		case SQL_API_ODBC3_ALL_FUNCTIONS:
			memset(Supported, SQL_FALSE, SQL_API_ODBC3_ALL_FUNCTIONS_SIZE*sizeof(SQLUSMALLINT));
			
			/* ODBC core level api */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCHANDLE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBINDCOL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBINDPARAMETER);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCANCEL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCLOSECURSOR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLATTRIBUTE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLUMNS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOPYDESC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDATASOURCES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDESCRIBECOL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDISCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDRIVERCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDRIVERS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLENDTRAN);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLEXECDIRECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLEXECUTE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFETCH);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFETCHSCROLL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREEHANDLE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREESTMT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETCONNECTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETCURSORNAME);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDATA);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDESCFIELD);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDESCREC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDIAGFIELD);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDIAGREC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETENVATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETFUNCTIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETINFO);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETSTMTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETTYPEINFO);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLNATIVESQL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLNUMPARAMS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLNUMRESULTCOLS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPARAMDATA);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPREPARE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPUTDATA);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLROWCOUNT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETCONNECTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETCURSORNAME);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETDESCFIELD);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETDESCREC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETENVATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETSTMTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSPECIALCOLUMNS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSTATISTICS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLTABLES);
			
			/* ODBC level 1 api */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBROWSECONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBULKOPERATIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLMORERESULTS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPRIMARYKEYS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPROCEDURECOLUMNS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPROCEDURES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETPOS);

			/* ODBC level 2 api */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLUMNPRIVILEGES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDESCRIBEPARAM);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFOREIGNKEYS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLTABLEPRIVILEGES);
			
			/* deprecated */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCENV);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCSTMT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBINDPARAM);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLATTRIBUTES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLERROR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREECONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREEENV);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETCONNECTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETSTMTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPARAMOPTIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETCONNECTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETPARAM);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETSCROLLOPTIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETSTMTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLTRANSACT);
			break;
		/* ODBC 2.0 and earlier */
		case SQL_API_ALL_FUNCTIONS:
			memset(Supported, SQL_FALSE, 100*sizeof(SQLUSMALLINT));

			/* ODBC core level api */
			Supported[SQL_API_SQLALLOCHANDLE]   = SQL_TRUE;
			Supported[SQL_API_SQLBINDCOL]       = SQL_TRUE;
			Supported[SQL_API_SQLBINDPARAMETER] = SQL_TRUE;
			Supported[SQL_API_SQLCANCEL]        = SQL_TRUE;
			Supported[SQL_API_SQLCLOSECURSOR]   = SQL_TRUE;
			Supported[SQL_API_SQLCOLATTRIBUTE]  = SQL_TRUE;
			Supported[SQL_API_SQLCOLUMNS]       = SQL_TRUE;
			Supported[SQL_API_SQLCONNECT]       = SQL_TRUE;
			Supported[SQL_API_SQLCOPYDESC]      = SQL_TRUE;
			Supported[SQL_API_SQLDATASOURCES]   = SQL_TRUE;
			Supported[SQL_API_SQLDESCRIBECOL]   = SQL_TRUE;
			Supported[SQL_API_SQLDISCONNECT]    = SQL_TRUE;
			Supported[SQL_API_SQLDRIVERCONNECT] = SQL_TRUE;
			Supported[SQL_API_SQLDRIVERS]       = SQL_TRUE;
			Supported[SQL_API_SQLENDTRAN]       = SQL_TRUE;
			Supported[SQL_API_SQLEXECDIRECT]    = SQL_TRUE;
			Supported[SQL_API_SQLEXECUTE]       = SQL_TRUE;
			Supported[SQL_API_SQLFETCH]         = SQL_TRUE;
			Supported[SQL_API_SQLFETCHSCROLL]   = SQL_TRUE;
			Supported[SQL_API_SQLFREEHANDLE]    = SQL_TRUE;
			Supported[SQL_API_SQLFREESTMT]      = SQL_TRUE;
			Supported[SQL_API_SQLGETCONNECTATTR]= SQL_TRUE;
			Supported[SQL_API_SQLGETCURSORNAME] = SQL_TRUE;
			Supported[SQL_API_SQLGETDATA]       = SQL_TRUE;
			Supported[SQL_API_SQLGETDESCFIELD]  = SQL_TRUE;
			Supported[SQL_API_SQLGETDESCREC]    = SQL_TRUE;
			Supported[SQL_API_SQLGETDIAGFIELD]  = SQL_TRUE;
			Supported[SQL_API_SQLGETDIAGREC]    = SQL_TRUE;
			Supported[SQL_API_SQLGETENVATTR]    = SQL_TRUE;
			Supported[SQL_API_SQLGETFUNCTIONS]  = SQL_TRUE;
			Supported[SQL_API_SQLGETINFO]       = SQL_TRUE;
			Supported[SQL_API_SQLGETSTMTATTR]   = SQL_TRUE;
			Supported[SQL_API_SQLGETTYPEINFO]   = SQL_TRUE;
			Supported[SQL_API_SQLNATIVESQL]     = SQL_TRUE;
			Supported[SQL_API_SQLNUMPARAMS]     = SQL_TRUE;
			Supported[SQL_API_SQLNUMRESULTCOLS] = SQL_TRUE;
			Supported[SQL_API_SQLPARAMDATA]     = SQL_TRUE;
			Supported[SQL_API_SQLPREPARE]       = SQL_TRUE;
			Supported[SQL_API_SQLPUTDATA]       = SQL_TRUE;
			Supported[SQL_API_SQLROWCOUNT]      = SQL_TRUE;
			Supported[SQL_API_SQLSETCONNECTATTR]= SQL_TRUE;
			Supported[SQL_API_SQLSETCURSORNAME] = SQL_TRUE;
			Supported[SQL_API_SQLSETDESCFIELD]  = SQL_TRUE;
			Supported[SQL_API_SQLSETDESCREC]    = SQL_TRUE;
			Supported[SQL_API_SQLSETENVATTR]    = SQL_TRUE;
			Supported[SQL_API_SQLSETSTMTATTR]   = SQL_TRUE;
			Supported[SQL_API_SQLSPECIALCOLUMNS]= SQL_TRUE;
			Supported[SQL_API_SQLSTATISTICS]    = SQL_TRUE;
			Supported[SQL_API_SQLTABLES]        = SQL_TRUE;
			
			/* ODBC level 1 api */
			Supported[SQL_API_SQLBROWSECONNECT]    = SQL_TRUE;
			Supported[SQL_API_SQLBULKOPERATIONS]   = SQL_TRUE;
			Supported[SQL_API_SQLMORERESULTS]      = SQL_TRUE;
			Supported[SQL_API_SQLPRIMARYKEYS]      = SQL_TRUE;
			Supported[SQL_API_SQLPROCEDURECOLUMNS] = SQL_TRUE;
			Supported[SQL_API_SQLPROCEDURES]       = SQL_TRUE;
			Supported[SQL_API_SQLSETPOS]           = SQL_TRUE;

			/* ODBC level 2 api */
			Supported[SQL_API_SQLCOLUMNPRIVILEGES] = SQL_TRUE;
			Supported[SQL_API_SQLDESCRIBEPARAM]    = SQL_TRUE;
			Supported[SQL_API_SQLFOREIGNKEYS]      = SQL_TRUE;
			Supported[SQL_API_SQLTABLEPRIVILEGES]  = SQL_TRUE;
			
			/* deprecated */
			Supported[SQL_API_SQLALLOCCONNECT]     = SQL_TRUE;
			Supported[SQL_API_SQLALLOCENV]         = SQL_TRUE;
			Supported[SQL_API_SQLALLOCSTMT]        = SQL_TRUE;
			Supported[SQL_API_SQLBINDPARAM]        = SQL_TRUE;
			Supported[SQL_API_SQLCOLATTRIBUTES]    = SQL_TRUE;
			Supported[SQL_API_SQLERROR]            = SQL_TRUE;
			Supported[SQL_API_SQLFREECONNECT]      = SQL_TRUE;
			Supported[SQL_API_SQLFREEENV]          = SQL_TRUE;
			Supported[SQL_API_SQLGETCONNECTOPTION] = SQL_TRUE;
			Supported[SQL_API_SQLGETSTMTOPTION]    = SQL_TRUE;
			Supported[SQL_API_SQLPARAMOPTIONS]     = SQL_TRUE;
			Supported[SQL_API_SQLSETCONNECTOPTION] = SQL_TRUE;
			Supported[SQL_API_SQLSETPARAM]         = SQL_TRUE;
			Supported[SQL_API_SQLSETSCROLLOPTIONS] = SQL_TRUE;
			Supported[SQL_API_SQLSETSTMTOPTION]    = SQL_TRUE;
			Supported[SQL_API_SQLTRANSACT]         = SQL_TRUE;
			break;
		/* single ODBC function id */
		default:
			/* only for ODBC 2.0 and earlier */
			switch(FunctionId)
			{
				/* ODBC core level api */
				case SQL_API_SQLALLOCHANDLE:
				case SQL_API_SQLBINDCOL:
				case SQL_API_SQLBINDPARAMETER:
				case SQL_API_SQLCANCEL:
				case SQL_API_SQLCLOSECURSOR:
				case SQL_API_SQLCOLATTRIBUTE:
				case SQL_API_SQLCOLUMNS:
				case SQL_API_SQLCONNECT:
				case SQL_API_SQLCOPYDESC:
				case SQL_API_SQLDATASOURCES:
				case SQL_API_SQLDESCRIBECOL:
				case SQL_API_SQLDISCONNECT:
				case SQL_API_SQLDRIVERCONNECT:
				case SQL_API_SQLDRIVERS:
				case SQL_API_SQLENDTRAN:
				case SQL_API_SQLEXECDIRECT:
				case SQL_API_SQLEXECUTE:
				case SQL_API_SQLFETCH:
				case SQL_API_SQLFETCHSCROLL:
				case SQL_API_SQLFREEHANDLE:
				case SQL_API_SQLFREESTMT:
				case SQL_API_SQLGETCONNECTATTR:
				case SQL_API_SQLGETCURSORNAME:
				case SQL_API_SQLGETDATA:
				case SQL_API_SQLGETDESCFIELD:
				case SQL_API_SQLGETDESCREC:
				case SQL_API_SQLGETDIAGFIELD:
				case SQL_API_SQLGETDIAGREC:
				case SQL_API_SQLGETENVATTR:
				case SQL_API_SQLGETFUNCTIONS:
				case SQL_API_SQLGETINFO:
				case SQL_API_SQLGETSTMTATTR:
				case SQL_API_SQLGETTYPEINFO:
				case SQL_API_SQLNATIVESQL:
				case SQL_API_SQLNUMPARAMS:
				case SQL_API_SQLNUMRESULTCOLS:
				case SQL_API_SQLPARAMDATA:
				case SQL_API_SQLPREPARE:
				case SQL_API_SQLPUTDATA:
				case SQL_API_SQLROWCOUNT:
				case SQL_API_SQLSETCONNECTATTR:
				case SQL_API_SQLSETCURSORNAME:
				case SQL_API_SQLSETDESCFIELD:
				case SQL_API_SQLSETDESCREC:
				case SQL_API_SQLSETENVATTR:
				case SQL_API_SQLSETSTMTATTR:
				case SQL_API_SQLSPECIALCOLUMNS:
				case SQL_API_SQLSTATISTICS:
				case SQL_API_SQLTABLES:
					*Supported = SQL_TRUE;
					break;

				/* unsupported function or reserved */

				/* ODBC level 1 api */
				case SQL_API_SQLBROWSECONNECT:
				case SQL_API_SQLBULKOPERATIONS:
				case SQL_API_SQLMORERESULTS:
				case SQL_API_SQLPRIMARYKEYS:
				case SQL_API_SQLPROCEDURECOLUMNS:
				case SQL_API_SQLPROCEDURES:
				case SQL_API_SQLSETPOS:

				/* ODBC level 2 api */
				case SQL_API_SQLCOLUMNPRIVILEGES:
				case SQL_API_SQLDESCRIBEPARAM:
				case SQL_API_SQLFOREIGNKEYS:
				case SQL_API_SQLTABLEPRIVILEGES:
			
				/* deprecated */
				case SQL_API_SQLALLOCCONNECT:
				case SQL_API_SQLALLOCENV:
				case SQL_API_SQLALLOCSTMT:
				case SQL_API_SQLBINDPARAM:
/*				case SQL_API_SQLCOLATTRIBUTES: */
				case SQL_API_SQLERROR:
				case SQL_API_SQLFREECONNECT:
				case SQL_API_SQLFREEENV:
				case SQL_API_SQLGETCONNECTOPTION:
				case SQL_API_SQLGETSTMTOPTION:
				case SQL_API_SQLPARAMOPTIONS:
				case SQL_API_SQLSETCONNECTOPTION:
				case SQL_API_SQLSETPARAM:
				case SQL_API_SQLSETSCROLLOPTIONS:
				case SQL_API_SQLSETSTMTOPTION:
				case SQL_API_SQLTRANSACT:
				default:
					*Supported = SQL_TRUE;
			}
	}

	LEAVE_CONN(ConnectionHandle, SQL_SUCCESS);
}


/*-----------------------------------------------------------------------------
 * SQLGetInfo (READY)
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetInfo_(SQLHDBC ConnectionHandle, SQLUSMALLINT InfoType, SQLPOINTER InfoValue,
            SQLSMALLINT BufferLength, SQLSMALLINT *StringLength)
{
	SQLRETURN nRet;

	ENTER_CONN(ConnectionHandle, _T("SQLGetInfo"));
	nRet = GetConnectionInfo((Connection*)ConnectionHandle, InfoType, InfoValue, (SQLSMALLINT)BYTES_TO_CHARACTERS(BufferLength), StringLength);
	LEAVE_CONN(ConnectionHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLGetTypeInfo
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetTypeInfo(SQLHSTMT StatementHandle, SQLSMALLINT DataType)
{
	SQLRETURN   nRet;
	SQLSMALLINT sql_type;
	TCHAR       buffer[100];
	TCHAR*      pBuffer;
	int         nRowsResulted;
	Descriptor* pIRD;
	int         i;
	Statement*  pStatement = (Statement*)StatementHandle;

	ENTER_STMT(StatementHandle, _T("SQLGetTypeInfo"));
	if (SQL_ERROR != (nRet = ResetStatement(pStatement)))
	{
		SQLINTEGER  interval_precision;
		SQLINTEGER  num_prec_radix;
		SQLSMALLINT concise_type;
		SQLSMALLINT is_nullable;
		SQLSMALLINT precision;
		SQLINTEGER  length;
		SQLINTEGER  display_size;
		SQLSMALLINT scale;
		BYTE        is_unsigned;

		const TCHAR* prefix;
		const TCHAR* suffix;

		((Statement*)StatementHandle)->use_buffering |= TRUE;
		/* handmade resultset */
		pIRD = GET_DESCRIPTOR(((Statement*)StatementHandle)->ird);
		SetDescField(pIRD, 0, SQL_DESC_COUNT, (SQLPOINTER)(SQLSMALLINT)(sizeof(c_GetTypeInfoColumns)/sizeof(ColumnNameType)), SQL_IS_SMALLINT);
		RET_DESCRIPTOR(pIRD);
		RenameColumns((Statement*) StatementHandle, c_GetTypeInfoColumns, sizeof(c_GetTypeInfoColumns)/sizeof(ColumnNameType));

		/* prepare resultset */
		for (nRowsResulted=0,i=0;i<PSQL_DATATYPES_NUMBER;i++)
		{
			concise_type = c_PostgreSQLDataTypes[i].sql_type;
			length       = c_PostgreSQLDataTypes[i].column_size;
			is_nullable  = c_PostgreSQLDataTypes[i].is_nullable;
			is_unsigned  = c_PostgreSQLDataTypes[i].is_unsigned;
			precision    = 0;
			scale        = 0;

			prefix = suffix = (i < 12) ? NULL : _T("'");
			SQLTypeDescriptor(concise_type, SQL_FALSE, &length, &precision, &scale, &sql_type, &display_size, &interval_precision, &num_prec_radix);
                        
			if (SQL_ALL_TYPES == DataType || DataType == concise_type || DataType == sql_type)
			{
				/* TYPE_NAME */
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(c_PostgreSQLDataTypes[i].name));
				_tcsncpy(pBuffer, c_PostgreSQLDataTypes[i].name, length);
				/* DATA_TYPE */
				_itot(concise_type, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* COLUMN_SIZE */
				_itot(display_size, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* LITERAL_PREFIX */
				if (NULL == prefix)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(prefix));
					_tcsncpy(pBuffer, prefix, length);				
				}
				/* LITERAL_SUFFIX */
				if (NULL == suffix)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(suffix));
					_tcsncpy(pBuffer, suffix, length);
				}
				/* CREATE_PARAMS */
				if (NULL == c_PostgreSQLDataTypes[i].create_params)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(c_PostgreSQLDataTypes[i].create_params));
					_tcsncpy(pBuffer, c_PostgreSQLDataTypes[i].create_params, length);				
				}
				/* NULLABLE */
				_itot(is_nullable, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* CASE_SENSITIVE */
				pBuffer = AddField((Statement*)StatementHandle, 0);
				/* SEARCHABLE */
				pBuffer = AddField((Statement*)StatementHandle, 0);
				/* UNSIGNED_ATTRIBUTE */
				if (0 == is_unsigned)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					_itot((1 == is_unsigned) ? SQL_FALSE : SQL_TRUE, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);				
				}
				/* FIXED_PREC_SCALE */
				pBuffer = AddField((Statement*)StatementHandle, 0);
				/* AUTO_UNIQUE_VALUE */
				pBuffer = AddField((Statement*)StatementHandle, 0);
				/* LOCAL_TYPE_NAME */
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(c_PostgreSQLDataTypes[i].local_name));
				_tcsncpy(pBuffer, c_PostgreSQLDataTypes[i].local_name, length);
				/* MINIMUM_SCALE */
				if (0 == precision)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					_itot(0, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}
				/* MAXIMUM_SCALE */
				if (0 == precision)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					_itot(precision, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}
				/* SQL_DATA_TYPE */
				_itot(sql_type, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* SQL_DATETIME_SUB */
				if (SQL_DATETIME == sql_type || SQL_INTERVAL == sql_type)
				{
					_itot(concise_type, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}
				else
					pBuffer = AddField((Statement*)StatementHandle, 0);

				/* NUM_PREC_RADIX */
				if (0 < num_prec_radix)
				{
					_itot(num_prec_radix, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}
				else
					pBuffer = AddField((Statement*)StatementHandle, 0);
				/* INTERVAL_PRECISION */
				if (SQL_INTERVAL != sql_type)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					_itot(interval_precision, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);				
				}

				nRowsResulted++;
			}
		}

		PrepareResultset((Statement*)StatementHandle, nRowsResulted);
		((Statement*)StatementHandle)->query.type = ST_SELECT;
		nRet = SQL_SUCCESS;
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLPutData
 *
 * DESCRIPTION: Supplies data for column or parameter, it can be called for any parameter,
 *              but only for character or binary data more than once
 *
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLPutData(SQLHSTMT StatementHandle, SQLPOINTER Data, SQLINTEGER StrLen_or_Ind)
{
	SQLRETURN nRet = SQL_SUCCESS;
	ENTER_STMT(StatementHandle, _T("SQLPutData"));
	{/* get info about data-buffer */
		DataAtExec* daexex = &((Statement*)StatementHandle)->data_at_exec;
		SQLINTEGER  length;

		/* get length of data to copy */
		switch(daexex->c_type)
		{
			case SQL_C_CHAR:
			case SQL_C_WCHAR:
			case SQL_C_BINARY:
				length = (SQL_NTS == StrLen_or_Ind) ? ((SQL_C_WCHAR == daexex->c_type) ? wcslen((WCHAR*)Data) : strlen((char*)Data)) : StrLen_or_Ind;
				if (daexex->free_size < length)
				{/* specified buffer smaller then data */
					length = daexex->free_size;
					SetError(SQL_HANDLE_STMT, StatementHandle, ERR_PUTPARAM_TRUNCATED_DATA, NULL);
					nRet = SQL_SUCCESS_WITH_INFO;
				}
			default:
				length = GetCTypeLength(daexex->c_type, 0);
		}

		/* put data into buffer */
		memcpy(daexex->data + daexex->length - daexex->free_size, Data, length);
		daexex->free_size -= length;
	}
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLSpecialColumns
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLSpecialColumns_(SQLHSTMT StatementHandle, SQLUSMALLINT IdentifierType,
									 SQLTCHAR *CatalogName, SQLSMALLINT CatalogNameLength,
									 SQLTCHAR *SchemaName, SQLSMALLINT SchemaNameLength,
									 SQLTCHAR *TableName, SQLSMALLINT TableNameLength,
									 SQLUSMALLINT Scope, SQLUSMALLINT Nullable)
{
	SQLRETURN      nRet   = SQL_ERROR;
	TextConversion conv   = TC_AS_IS;
	SQLTCHAR*      query  = NULL;
	int            rows   = 0;
	Statement* pStatement = (Statement*) StatementHandle;

	ENTER_STMT(StatementHandle, _T("SQLSpecialColumns"));
	if (NULL == TableName || _T('\0') == *TableName || 0 == TableNameLength)
	{/* TableName can't be a null pointer */
		SetError(SQL_HANDLE_STMT, pStatement, ERR_EMPTY_STRING, _T("TableName"), NULL);
		nRet = SQL_ERROR;
	}
	else
	{
		while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement(pStatement))))
		{
			if (query = CompileCSOCQuery(pStatement, c_SQLSpecialColumns_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, NULL, 0, NULL, 0, CSOC_OBJ_TABLE))
			{
				if ((SQL_ERROR != (nRet = PrepareQuery(pStatement, query, SQL_NTS))) &&
				    (SQL_ERROR != (nRet = ExecuteStatement(pStatement, TRUE))) &&
						(0 == ((Statement*)StatementHandle)->ird->header.array_size)
				   )
					conv++;
				else
					conv = TC_STOP;
				free(query);
			}
			else
			{
				SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
				conv = TC_STOP;
				nRet = SQL_ERROR;
			}
		}
		
		if (SQL_SUCCEEDED(nRet))
		{/* rename columns */
			Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);
			SetDescField(pIRD, 0, SQL_DESC_COUNT, (SQLPOINTER)(SQLSMALLINT)(sizeof(c_SpecialColumnsColumns)/sizeof(ColumnNameType)), SQL_IS_SMALLINT);
			RET_DESCRIPTOR(pIRD);
			RenameColumns(pStatement, c_SpecialColumnsColumns, sizeof(c_SpecialColumnsColumns)/sizeof(ColumnNameType));				
		}

		if (0 < (rows = pStatement->ird->header.rows_affected))
		{
			TCHAR  buffer[10];
			TCHAR* pBuffer;
			int   length;
			int   i;

			/* we should show info about oid */
			EmptyStatementResults(pStatement);
			for(i=0;i<rows;i++)
			{
				/* SCOPE */
				_itot(SQL_SCOPE_SESSION, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* COLUMN_NAME */
				pBuffer = AddField(pStatement, length = _tcslen(c_PostgreSQLDataTypes[PTN_OID].name));
				_tcsncpy(pBuffer, c_PostgreSQLDataTypes[PTN_OID].name, length);
				/* DATA_TYPE */
				_itot(SQL_INTEGER, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* TYPE_NAME */
				pBuffer = AddField(pStatement, length = _tcslen(c_PostgreSQLDataTypes[PTN_OID].name));
				_tcsncpy(pBuffer, c_PostgreSQLDataTypes[PTN_OID].name, length);
				/* COLUMN_SIZE */
				_itot(10, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* BUFFER_LENGTH */
				_itot(4, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* DECIMAL_DIGITS */
				_itot(0, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
				/* PSEUDO_COLUMN */
				_itot(SQL_PC_PSEUDO, buffer, 10);
				pBuffer = AddField(pStatement, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);
			}
			PrepareResultset(pStatement, rows);		
		}
	}
	LEAVE_STMT(StatementHandle, nRet);
}
/*-----------------------------------------------------------------------------
 * SQLStatistics
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLStatistics_(SQLHSTMT StatementHandle,
               SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
               SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
               SQLTCHAR* TableName,   SQLSMALLINT TableNameLength,
               SQLUSMALLINT Unique,   SQLUSMALLINT Reserved)
{
	SQLRETURN      nRet  = SQL_ERROR;
	TextConversion conv  = TC_AS_IS;
	SQLTCHAR*      query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLStatistics"));
	if (NULL == TableName || _T('\0') == *TableName)
	{/* TableName can't be a null pointer */
		SetError(SQL_HANDLE_STMT, StatementHandle, ERR_EMPTY_STRING, _T("TableName"), NULL);
		nRet = SQL_ERROR;
	}
	else while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLStatistics_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns(StatementHandle, c_StatisticsColumns, sizeof(c_StatisticsColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLTables
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLTables_(SQLHSTMT StatementHandle,
           SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
           SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
           SQLTCHAR* TableName, SQLSMALLINT TableNameLength,
           SQLTCHAR* TableType, SQLSMALLINT TableTypeLength)
{
	SQLRETURN  nRet;
	TableTypes types;

	ENTER_STMT(StatementHandle, _T("SQLTables"));
	if (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle)))
	{
		/* set table-types application requested */
		if (NULL == TableType || 0 == TableTypeLength || _T('\0') == *TableType)
			/* no types specified in parameter - use default */
			types = TT_DEFAULT;
		else
		{
			TableTypes type;
			SQLTCHAR*  LastChar;
			BOOL       bNewType;
		
			if (SQL_NTS == TableTypeLength)
				TableTypeLength = _tcslen(TableType);
			/* parse parameter string with types and determine supported */
			for (types=TT_NO_ONE, bNewType=TRUE, LastChar=TableType+TableTypeLength;LastChar!=TableType;TableType++)
			{
				if (TRUE == bNewType)
				{
					switch (*TableType)
					{
						case _T('\''):
						case _T(' '):
							continue;
						case _T('S'):
							if (0 == _tcsncmp(TableType, _T("SYSTEM TABLE"), STR_SIZEOF("SYSTEM TABLE")))
							{
								type = TT_SYSTEM_TABLE;
								TableType += STR_SIZEOF("SYSTEM TABLE")-1;
							}
							break;
						case _T('T'):
							if (0 == _tcsncmp(TableType, _T("TABLE"), STR_SIZEOF("TABLE")))
							{
								type = TT_TABLE;
								TableType += STR_SIZEOF("TABLE")-1;
							}
							break;
						case _T('V'):
							if (0 == _tcsncmp(TableType, _T("VIEW"), STR_SIZEOF("VIEW")))
							{
								type = TT_VIEW;
								TableType += STR_SIZEOF("VIEW")-1;
							}
							break;
					}
					bNewType = FALSE;
				}
				else
				{
					switch (*TableType)
					{
						case _T('\''):
						case _T(' '):
							break;
						case _T(','):
							types |= type;
							bNewType = TRUE;
							break;
						default:
							type = TT_NO_ONE;
					}
				}
			}
			types |= type;
		}

		if (TT_NO_ONE == types)
		{
			/* There was no one valid table type specified in parameter TableType */
			SQLTCHAR* typesStr;

			if (_T('\0') == *TableType)
				/* save time - do not duplicate string, use parameter because it's 0-terminated */
				typesStr = TableType - TableTypeLength;
			else if (typesStr = (SQLTCHAR*)malloc((TableTypeLength+1)*sizeof(SQLTCHAR)))
			{
				_tcsncpy(typesStr, TableType-TableTypeLength, TableTypeLength);
				typesStr[TableTypeLength] = _T('\0');
			}
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_STMT_NO_VALID_TABLE_TYPES, typesStr, NULL);
			if (_T('\0') != *TableType)
				free(typesStr);
			nRet = SQL_ERROR;
		}
		else
		{
			int i = 0;
			int or = STR_SIZEOF(" or ");
			const SQLTCHAR* params[6];
			TextConversion conv  = TC_AS_IS;

			SQLTCHAR* temp;  /* query after first parsing */
			SQLTCHAR* query; /* prepared query text */

			/* note: SYSTEM TABLE is a table in 'pg_catalog' schema */
			if (0 == (types & TT_SYSTEM_TABLE))
				params[0] = params[3] = _T("");
			else
			{
				params[0] = c_SQLTables_ST;
				params[3] = c_SQLTables_ST_;
				or = 0;
			}

			if (0 == (types & TT_TABLE))
				params[1] = params[4] = _T("");
			else
			{
				params[1] = c_SQLTables_T;
				params[4] = c_SQLTables_T_ + or;
				or = 0;
			}

			if (0 == (types & TT_VIEW))
				params[2] = params[5] = _T("");
			else
			{
				params[2] = c_SQLTables_V;
				params[5] = c_SQLTables_V_ + or;
			}

			if (temp = GetText(c_SQLTables_query, params[0], params[1], params[2], params[3], params[4], params[5], NULL))
			{
				while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
				{
					if (query = CompileCSOCQuery((Statement*) StatementHandle, temp, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE))
					{
						/* execute query */
						if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
						    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
								(0 == ((Statement*)StatementHandle)->ird->header.array_size)
						   )
							conv++;
						else
							conv = TC_STOP;
						free(query);
					}
					else
						conv = TC_STOP;
				}

				if (SQL_SUCCEEDED(nRet))
				{/* rename columns */
					RenameColumns(StatementHandle, c_TablesColumns, sizeof(c_TablesColumns)/sizeof(ColumnNameType));
				}
			}
			if (NULL == temp || NULL == query)
			{
				SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
				nRet = SQL_ERROR;
			}
			free(temp);
		}
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLProcedures
 *
 * DESCRIPTION: we will show only those fuctions - the user can execute
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLProcedures_(SQLHSTMT StatementHandle,
							 SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
               SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
               SQLTCHAR* ProcName, SQLSMALLINT ProcNameLength)
{
	SQLRETURN      nRet  = SQL_ERROR;
	TextConversion conv  = TC_AS_IS;
	SQLTCHAR*      query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLProcedures"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLProcedures_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, NULL, 0, NULL, 0, CSOC_OBJ_TABLE))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns(StatementHandle, c_ProceduresColumns, sizeof(c_ProceduresColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLPrimaryKeys
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLPrimaryKeys_(SQLHSTMT StatementHandle,
                SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
                SQLTCHAR* TableName, SQLSMALLINT TableNameLength)
{
	SQLRETURN      nRet  = SQL_ERROR;
	TextConversion conv  = TC_AS_IS;
	SQLTCHAR*      query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLPrimaryKeys"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLPrimaryKeys_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns(StatementHandle, c_PrimaryKeysColumns, sizeof(c_PrimaryKeysColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}


/*----------------------------------------------------------------------------
 * FUNCTION: SQLProcedureColumns
 *
 * DESCRIPTION: we will show only those fuctions - the user can execute
 *----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLProcedureColumns_(SQLHSTMT StatementHandle,
                     SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                     SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
                     SQLTCHAR* ProcName, SQLSMALLINT ProcNameLength,
                     SQLTCHAR* ColumnName, SQLSMALLINT ColumnNameLength
                    )
{
	SQLRETURN      nRet   = SQL_ERROR;
	TextConversion conv   = TC_AS_IS;
	SQLTCHAR*      query  = NULL;
	Statement* pStatement = (Statement*)StatementHandle;

	ENTER_STMT(StatementHandle, _T("SQLProcedureColumns"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLProcedureColumns, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, ProcName, ProcNameLength, ColumnName, ColumnNameLength, CSOC_OBJ_PROC))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* prepare handmade resultset */
		TCHAR buffer[SQLSMALLINT_LENGTH];
		int   i;

		TCHAR* temp         = NULL;
		TCHAR* param_input  = NULL;
		TCHAR* column_name  = NULL;
		TCHAR* table_name   = NULL;

		SQLSMALLINT concise_type = 0;
		SQLSMALLINT type         = 0;
		SQLSMALLINT scale        = 0;
		SQLSMALLINT precision    = 0;
		SQLSMALLINT nullable     = 0;
		SQLINTEGER  length       = 0;
		SQLINTEGER  radix        = 0;
		SQLINTEGER  oid          = 0;
		TCHAR*      yes          = NULL;
		TCHAR*      return_value = NULL;
		TCHAR*      param_value  = NULL;
		Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);

		/* save "YES" and SQL_NULLABLE for nullability */
		_tcsncpy(yes = AddField(pStatement, STR_SIZEOF("YES")), _T("YES"), STR_SIZEOF("YES"));
		yes -= sizeof(int)/sizeof(TCHAR);

		/* save SQL_RETURN_VALUE and SQL_PARAM_INPUT */
		_tcsncpy(return_value = AddField(pStatement, STR_SIZEOF("5")), _T("5"), STR_SIZEOF("5"));
		return_value -= sizeof(int)/sizeof(TCHAR);
		_tcsncpy(param_value = AddField(pStatement, STR_SIZEOF("1")), _T("1"), STR_SIZEOF("1"));
		param_value -= sizeof(int)/sizeof(TCHAR);

		for (i=pStatement->ird->header.array_size-1;i>=0;i--)
		{/* get data description for every oid, returned in resultset */
			TCHAR* type_name = NULL;

			/* get oid */
			FillBufferWithValue(&oid, sizeof(oid), SQL_C_SLONG, ((int*)pIRD->id_records[5].common.data_ptr[i]+1), *(int*)pIRD->id_records[5].common.data_ptr[i],SQL_INTEGER);
			PostgreTypeConverter(oid, 0, &type_name, 0, &concise_type, &length, &precision, &scale, &nullable, NULL);
			SQLTypeDescriptor(concise_type, 0, &length, &precision, &scale, &type, NULL, NULL, &radix);

			/* PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME - olready set */
			/* COLUMN_TYPE */
			pIRD->id_records[4].common.data_ptr[i] = (_T('0') == *(TCHAR*)((int*)pIRD->id_records[17].common.data_ptr[i]+1)) ? return_value : param_value;
			/* DATA_TYPE */
			_itot(concise_type, buffer, 10);
			temp = AddField(pStatement, length = _tcslen(buffer));
			_tcsncpy(temp, buffer, length);
			pIRD->id_records[5].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);
			/* TYPE_NAME */
			temp = AddField(pStatement, length = _tcslen(type_name));
			_tcsncpy(temp, type_name, length);
			pIRD->id_records[6].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);						
			/* COLUMN_SIZE */
			/* BUFFER_LENGTH */
			_itot(256, buffer, 10);
			temp = AddField(pStatement, length = _tcslen(buffer));
			_tcsncpy(temp, buffer, length);
			pIRD->id_records[8].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);
			/* DECIMAL_DIGITS */
			_itot(scale, buffer, 10);
			temp = AddField(pStatement, length = _tcslen(buffer));
			_tcsncpy(temp, buffer, length);
			pIRD->id_records[9].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);
			/* NUM_PREC_RADIX */
			_itot(radix, buffer, 10);
			temp = AddField(pStatement, length = _tcslen(buffer));
			_tcsncpy(temp, buffer, length);
			pIRD->id_records[10].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);
			/* NULLABLE */
			pIRD->id_records[11].common.data_ptr[i] = param_value;
			/* REMARKS, COLUMN_DEF - always null, PostgreSQL specyfic */
			/* SQL_DATA_TYPE */
			_itot(type, buffer, 10);
			temp = AddField(pStatement, length = _tcslen(buffer));
			_tcsncpy(temp, buffer, length);
			pIRD->id_records[14].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);
			/* SQL_DATETIME_SUB */
			/* CHAR_OCTET_LENGTH */
			_itot(256, buffer, 10);
			temp = AddField(pStatement, length = _tcslen(buffer));
			_tcsncpy(temp, buffer, length);
			pIRD->id_records[16].common.data_ptr[i] = ((BYTE*)temp) - sizeof(int);
			/* ORDINAL_POSITION - already set */
			/* IS_NULLABLE */
			pIRD->id_records[18].common.data_ptr[i] = yes;
		}

		RET_DESCRIPTOR(pIRD);

		/* rename columns */
		RenameColumns(pStatement, c_ProcedureColumnsColumns, sizeof(c_ProcedureColumnsColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*----------------------------------------------------------------------------
 * FUNCTION: CompileCSOCQuery
 *----------------------------------------------------------------------------
 */
TCHAR*
CompileCSOCQuery(Statement* pStatement,
								 SQLTCHAR* query,
								 TextConversion Conversion,
								 SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
								 SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
								 SQLTCHAR* ObjectName,  SQLSMALLINT ObjectNameLength,
								 SQLTCHAR* ColumnName,  SQLSMALLINT ColumnNameLength,
								 SQLSMALLINT ObjectType)
{
	int i = 4;
	const TCHAR* params[12];
	const TCHAR* oper = (SQL_FALSE == pStatement->attributes.metadata_id) ? c_query_like : c_query_equal;

	/* use 'public' schema name if no schema name specified */
	/*TCHAR* schema  = (0 == SchemaNameLength || NULL == SchemaName || _T('\0') == *SchemaName) ? _tcsdup(_T("public")) : GetSQLString(SchemaName, SchemaNameLength);*/


	/* do we need additional conditions ? */
	if (NULL != CatalogName && (SQL_NTS == CatalogNameLength || 0 < CatalogNameLength) && _T('\0') != CatalogName[0])
	{
		params[0]   = c_query_catalog;
		params[i++] = oper;
		params[i++] = GetSQLString(CatalogName, CatalogNameLength, Conversion);
	}
	else
		params[0] = _T("");

	if (NULL != SchemaName && (SQL_NTS == SchemaNameLength || 0 < SchemaNameLength) && _T('\0') != SchemaName[0])
	{
		params[1]   = c_query_schema;
		params[i++] = oper;
		params[i++] = GetSQLString(SchemaName, SchemaNameLength, Conversion);
	}
	else
		params[1] = _T("");

	if (NULL != ObjectName && (SQL_NTS == ObjectNameLength || 0 < ObjectNameLength) && _T('\0') != ObjectName[0])
	{
		switch (ObjectType)
		{
			case CSOC_OBJ_PROC:
				params[2] = c_query_procedure;
				break;
			case CSOC_OBJ_TABLE:
			default:
				params[2] = c_query_table;
		}
		params[i++] = oper;
		params[i++] = GetSQLString(ObjectName, ObjectNameLength, Conversion);
	}
	else
		params[2] = _T("");

	if (NULL != ColumnName && (SQL_NTS == ColumnNameLength || 0 < ColumnNameLength) && _T('\0') != ColumnName[0])
	{
		params[3]   = c_query_column;
		params[i++] = oper;
		params[i++] = GetSQLString(ColumnName, ColumnNameLength, Conversion);
	}
	else
		params[3] = _T("");

	query = GetText(query, params[0], params[1], params[2], params[3], NULL);
	if (4 < i)
	{
		int j;
		TCHAR* temp = query;
		for (j=i;j<12;j++)
			params[j] = NULL;
		query = (GetText(query, params[4], params[5], params[6], params[7], params[8], params[9], params[10], params[11], NULL));
		for(j=5;j<i;j+=2)
			free((TCHAR*)params[j]);
		free(temp);
	}

	return query;
}

/*-----------------------------------------------------------------------------
 * SQLTablePrivileges
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLTablePrivileges_(SQLHSTMT StatementHandle,
                    SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                    SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
                    SQLTCHAR* TableName,   SQLSMALLINT TableNameLength
									 )
{
	SQLRETURN      nRet  = SQL_ERROR;
	TextConversion conv  = TC_AS_IS;
	SQLTCHAR*      query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLTablePrivileges"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLTablePrivileges_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns(StatementHandle, c_TablePrivilegesColumns, sizeof(c_TablePrivilegesColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}


/*-----------------------------------------------------------------------------
 * FUNCTION: SQLMoreResults
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLMoreResults(SQLHSTMT StatementHandle)
{
	SQLRETURN  nRet       = SQL_ERROR;
	Statement* pStatement = (Statement*)StatementHandle;

	ENTER_STMT(StatementHandle, _T("SQLMoreResults"));
	
	if (pStatement->results.irds.used <= ++pStatement->results.current)
		/* no more results avaible */
		nRet = SQL_NO_DATA;
	else
	{
		/* populate new resultset - simply select next stored implementation descriptor */
		Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);
		CopyDescriptor((Descriptor*)pStatement->results.irds.handles[pStatement->results.current], pIRD);
		RET_DESCRIPTOR(pIRD);

		pStatement->fetch_first = -1;
		pStatement->fetch_position = -1;

		nRet = SQL_SUCCESS;
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLMoreResults
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLForeignKeys_(SQLHSTMT StatementHandle,
                SQLTCHAR* PkCatalogName, SQLSMALLINT PkCatalogNameLength,
                SQLTCHAR* PkSchemaName,  SQLSMALLINT PkSchemaNameLength,
                SQLTCHAR* PkTableName,   SQLSMALLINT PkTableNameLength,

                SQLTCHAR* FkCatalogName, SQLSMALLINT FkCatalogNameLength,
                SQLTCHAR* FkSchemaName,  SQLSMALLINT FkSchemaNameLength,
                SQLTCHAR* FkTableName,   SQLSMALLINT FkTableNameLength)
{
	SQLRETURN      nRet  = SQL_ERROR;
	TextConversion conv  = TC_AS_IS;
	SQLTCHAR*      query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLForeignKeys"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != PkTableName && 0 != PkTableNameLength && _T('\0') != PkTableName[0])
			query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLForeignKeys_query_1, conv, PkCatalogName, PkCatalogNameLength, PkSchemaName, PkSchemaNameLength, PkTableName, PkTableNameLength, NULL, 0, CSOC_OBJ_TABLE);
		else if (NULL != FkTableName && 0 != FkTableNameLength && _T('\0') != FkTableName[0])
			query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLForeignKeys_query_2, conv, FkCatalogName, FkCatalogNameLength, FkSchemaName, FkSchemaNameLength, FkTableName, FkTableNameLength, NULL, 0, CSOC_OBJ_TABLE);
		else
			query = NULL;

		if (NULL != query)
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns(StatementHandle, c_ForeignKeysColumns, sizeof(c_ForeignKeysColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLColumnPrivileges
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLColumnPrivileges_(SQLHSTMT StatementHandle,
										 SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
										 SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
										 SQLTCHAR* TableName,   SQLSMALLINT TableNameLength,
										 SQLTCHAR* ColumnName,  SQLSMALLINT ColumnNameLength)
{
	SQLRETURN      nRet  = SQL_ERROR;
	TextConversion conv  = TC_AS_IS;
	SQLTCHAR*      query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLColumnPrivileges"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLColumnPrivileges_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, ColumnName, ColumnNameLength, CSOC_OBJ_TABLE))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				conv++;
			else
				conv = TC_STOP;
			free(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns(StatementHandle, c_ColumnPrivilegesColumns, sizeof(c_ColumnPrivilegesColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}
