#!/usr/sbin/dtrace -qs

/*
 * Usage      : write_origin.d <file descriptor>
 * Description: Show write size distribution for different code paths
 * Author     : Robert Lor
 */

BEGIN
{
	endtime = timestamp + (5 * 1000000000ull);
}

syscall::write:entry
/ execname == "postgres" && arg0 == $1 /
{
	@trace[ustack()] = quantize(arg2);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
	exit(0);
}
