/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS InsertData v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el dialogo a traves del
* cual se inserta un registro en una tabla.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class InsertData extends JDialog implements ActionListener{

 JTextField area;
 Hashtable hashText = new Hashtable();
 String[] fieldName;
 int numFields;
 Table mytable;
 String SQLinsert = "";
 boolean wellDone = false;
 Language idiom;

 public InsertData(Table table,JFrame frame,Language leng) 
  {
    super(frame, true);
    idiom = leng;
    JPanel global = new JPanel();
    global.setLayout(new BoxLayout(global,BoxLayout.Y_AXIS));
    JScrollPane scroll;
    setTitle(idiom.getWord("INSFORM"));
    mytable = table;

    JPanel base = new JPanel();
    base.setLayout(new GridLayout(0,1));
    JPanel data = new JPanel();
    data.setLayout(new GridLayout(0,1));

    numFields = mytable.base.NumFields;
    Hashtable hashFields = mytable.getTableHeader().getHashtable();
    Vector fields = mytable.getTableHeader().getNameFields();
    fieldName = new String[numFields];
    for (int i=0; i<numFields ;i++) 
     {
      String nfield = (String) fields.elementAt(i);
      area = new JTextField(10);

      JLabel check = new JLabel(nfield + " [" + mytable.getTableHeader().getType(nfield) + "] = ");
      String label = "check-" + i;
      fieldName[i] = nfield;
      base.add(check);
      hashText.put(label,area);
      data.add(area);
     }

     Border etched1; 
     etched1 = BorderFactory.createEtchedBorder();
     TitledBorder title1 = BorderFactory.createTitledBorder(etched1);

     JPanel center = new JPanel();
     center.setLayout(new BorderLayout());
     center.add(base,BorderLayout.WEST);
     center.add(data,BorderLayout.CENTER);

     JLabel title = new JLabel("INSERT INTO " + mytable.getName(),JLabel.CENTER);
     JPanel first = new JPanel();
     first.setLayout(new FlowLayout(FlowLayout.CENTER));
     first.add(title);
     title1 = BorderFactory.createTitledBorder(etched1);
     first.setBorder(title1);

     title1 = BorderFactory.createTitledBorder(etched1,"VALUES");
     center.setBorder(title1);

     JButton ok = new JButton(idiom.getWord("OK"));
     ok.setActionCommand("ButtonOk");
     ok.addActionListener(this);
     JButton clear = new JButton(idiom.getWord("CLR"));
     clear.setActionCommand("ButtonClear");
     clear.addActionListener(this);
     JButton cancel = new JButton(idiom.getWord("CANCEL"));
     cancel.setActionCommand("ButtonCancel");
     cancel.addActionListener(this);

     JPanel botons = new JPanel();
     botons.setLayout(new FlowLayout(FlowLayout.CENTER));
     botons.add(ok);
     botons.add(clear);
     botons.add(cancel);

     global.add(first);

     if(numFields > 15) 
      {
       scroll = new JScrollPane(center);
       scroll.setPreferredSize(new Dimension(400,400));
       global.add(scroll);
      }
     else
      global.add(center);

     global.add(botons);

     getContentPane().add(global);
     pack();
     setLocationRelativeTo(frame);
     setVisible(true);
}

 public boolean wasOk(){
   return wellDone;
  }

 public String getSQLString(){
   return SQLinsert;
  }

 public void actionPerformed(java.awt.event.ActionEvent e) 
  {
   if(e.getActionCommand().equals("ButtonOk")) 
    {
     String values = "";
     int i=0;
     for (; i<numFields ;i++) 
        {
           String label = "check-" + i;
           JTextField tmp = (JTextField) hashText.get(label);
           String data = tmp.getText();
           data = data.trim();
           if(data.length()!=0) 
            {
             String type = mytable.getTableHeader().getType(fieldName[i]);
             int k = getTypeCode(type);
             if(k==1) 
               {
                 if (!data.startsWith("'"))
                     data = "'" + data;
                 if (!data.endsWith("'"))
                     data = data + "'";
               }
             if(k==2)
               {
                 if(!isNum(data))
                   {
                    JOptionPane.showMessageDialog(InsertData.this,
                    idiom.getWord("TNE1") + fieldName[i] + idiom.getWord("TNE2"),
                    idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                    tmp.requestFocus();
                    return;
                   }
               }

             values += data;
             if(i<numFields-1)
               values += ",";            
            } 
           else
            {
               JOptionPane.showMessageDialog(InsertData.this,idiom.getWord("EFIN") + fieldName[i] + "'.",idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
               tmp.requestFocus();
               return;
            } 
                                                           }
      if(i==numFields) 
       {
        SQLinsert = "INSERT INTO " + mytable.getName() + " VALUES(" + values + ");";
        wellDone = true;
        setVisible(false);
       }
   }

 if(e.getActionCommand().equals("ButtonCancel")) 
   {
     setVisible(false);
   }

 if(e.getActionCommand().equals("ButtonClear"))
   {
    for (Enumeration t = hashText.elements() ; t.hasMoreElements() ;) 
        {
           JTextField tmp = (JTextField) t.nextElement();
           tmp.setText("");
        }
   }

  }

 public int getTypeCode(String typeStr)
  {
   if(typeStr.startsWith("varchar") || typeStr.startsWith("char") || typeStr.startsWith("text") || typeStr.startsWith("name") || typeStr.startsWith("date") || typeStr.startsWith("time"))
     return 1;

   if(typeStr.startsWith("int") || typeStr.equals("serial") || typeStr.equals("smallint") || typeStr.equals("real") || typeStr.equals("double"))
     return 2;

   if(typeStr.startsWith("bool"))
     return 3;
   else
     return 4;
 }

 public boolean isNum(String word)
 {
   for(int i=0;i<word.length();i++)
    {
      char c = word.charAt(i);
      if(!Character.isDigit(c))
        return false;
    }
   return true;
 }

} // Fin de la Clase
