/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.postgresql.largeobject.LargeObject;

public class BlobOutputStream
extends OutputStream {
    private LargeObject lo;
    private byte[] buf;
    private int bsize;
    private int bpos;

    public BlobOutputStream(LargeObject largeObject) {
        this(largeObject, 1024);
    }

    public BlobOutputStream(LargeObject largeObject, int n) {
        this.lo = largeObject;
        this.bsize = n;
        this.buf = new byte[n];
        this.bpos = 0;
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.lo.close();
            this.lo = null;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public void flush() throws IOException {
        try {
            if (this.bpos > 0) {
                this.lo.write(this.buf, 0, this.bpos);
            }
            this.bpos = 0;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public void write(int n) throws IOException {
        try {
            if (this.bpos >= this.bsize) {
                this.lo.write(this.buf);
                this.bpos = 0;
            }
            this.buf[this.bpos++] = (byte)n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }
}

