/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import org.apache.log4j.Level;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class LevelRangeFilter
extends Filter {
    boolean acceptOnMatch = false;
    Level levelMin;
    Level levelMax;
    public static final String LEVEL_MIN_OPTION = "LevelMin";
    public static final String LEVEL_MAX_OPTION = "LevelMax";
    public static final String ACCEPT_ON_MATCH_OPTION = "AcceptOnMatch";

    public int decide(LoggingEvent event) {
        if (this.levelMin != null && !event.level.isGreaterOrEqual(this.levelMin)) {
            return -1;
        }
        if (this.levelMax != null && event.level.toInt() > this.levelMax.toInt()) {
            return -1;
        }
        if (this.acceptOnMatch) {
            return 1;
        }
        return 0;
    }

    public Level getLevelMax() {
        return this.levelMax;
    }

    public Level getLevelMin() {
        return this.levelMin;
    }

    public boolean getAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public void setLevelMax(Level levelMax) {
        this.levelMax = levelMax;
    }

    public void setLevelMin(Level levelMin) {
        this.levelMin = levelMin;
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public String[] getOptionStrings() {
        return new String[]{LEVEL_MIN_OPTION, LEVEL_MAX_OPTION, ACCEPT_ON_MATCH_OPTION};
    }

    public void setOption(String key, String value) {
        if (key.equalsIgnoreCase(LEVEL_MIN_OPTION)) {
            this.levelMin = OptionConverter.toLevel(value, null);
        } else if (key.equalsIgnoreCase(LEVEL_MAX_OPTION)) {
            this.levelMax = OptionConverter.toLevel(value, null);
        } else if (key.equalsIgnoreCase(ACCEPT_ON_MATCH_OPTION)) {
            this.acceptOnMatch = OptionConverter.toBoolean(value, this.acceptOnMatch);
        }
    }
}

