/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogFormatter;

public class ELogHandler
extends Handler {
    public static final int LOG_DEBUG5 = 10;
    public static final int LOG_DEBUG4 = 11;
    public static final int LOG_DEBUG3 = 12;
    public static final int LOG_DEBUG2 = 13;
    public static final int LOG_DEBUG1 = 14;
    public static final int LOG_LOG = 15;
    public static final int LOG_INFO = 17;
    public static final int LOG_NOTICE = 18;
    public static final int LOG_WARNING = 19;
    public static final int LOG_ERROR = 20;
    public static final int LOG_FATAL = 21;
    public static final int LOG_PANIC = 22;
    static /* synthetic */ Class class$0;

    public void publish(LogRecord record) {
        Level level = record.getLevel();
        int pgLevel = level == null ? 15 : (level.equals(Level.SEVERE) ? 20 : (level.equals(Level.WARNING) ? 19 : (level.equals(Level.INFO) ? 17 : (level.equals(Level.FINE) ? 14 : (level.equals(Level.FINER) ? 13 : (level.equals(Level.FINEST) ? 12 : 15))))));
        Backend.log(pgLevel, this.getFormatter().format(record));
    }

    public ELogHandler() {
        this.configure();
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    private void configure() {
        LogManager mgr = LogManager.getLogManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.postgresql.pljava.internal.ELogHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String cname = clazz.getName();
        String pgLevel = Backend.getConfigOption("log_min_messages");
        Level level = Level.ALL;
        if (pgLevel != null) {
            if ((pgLevel = pgLevel.toLowerCase().trim()).equals("panic") || pgLevel.equals("fatal")) {
                level = Level.OFF;
            } else if (pgLevel.equals("error")) {
                level = Level.SEVERE;
            } else if (pgLevel.equals("warning")) {
                level = Level.WARNING;
            } else if (pgLevel.equals("notice")) {
                level = Level.CONFIG;
            } else if (pgLevel.equals("info")) {
                level = Level.INFO;
            } else if (pgLevel.equals("debug1")) {
                level = Level.FINE;
            } else if (pgLevel.equals("debug2")) {
                level = Level.FINER;
            } else if (pgLevel.equals("debug3") || pgLevel.equals("debug4") || pgLevel.equals("debug5")) {
                level = Level.FINEST;
            }
        }
        this.setLevel(level);
        String val = mgr.getProperty(String.valueOf(cname) + ".filter");
        if (val != null) {
            try {
                this.setFilter((Filter)Class.forName(val.trim()).newInstance());
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            this.setFilter(null);
        }
        if ((val = mgr.getProperty(String.valueOf(cname) + ".formatter")) != null) {
            try {
                this.setFormatter((Formatter)Class.forName(val.trim()).newInstance());
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            this.setFormatter(new ELogFormatter());
        }
        if ((val = mgr.getProperty(String.valueOf(cname) + ".encoding")) != null) {
            try {
                this.setEncoding(val.trim());
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

