/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.PooledObject;

class ObjectPoolImpl
implements ObjectPool {
    private static Class[] s_ctorSignature = new Class[]{ObjectPool.class};
    private static PooledObjectHandle s_handlePool;
    private static final IdentityHashMap s_poolCache;
    private final Constructor m_ctor;
    private PooledObjectHandle m_providerPool;

    private ObjectPoolImpl(Class clazz) {
        if (!PooledObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " does not implement the " + PooledObject.class + " interface");
        }
        try {
            this.m_ctor = clazz.getConstructor(s_ctorSignature);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Unable to locate constructor " + clazz + "(ObjectPool)");
        }
    }

    public static ObjectPoolImpl getObjectPool(Class clazz) {
        ObjectPoolImpl objectPoolImpl = (ObjectPoolImpl)s_poolCache.get(clazz);
        if (objectPoolImpl == null) {
            objectPoolImpl = new ObjectPoolImpl(clazz);
            s_poolCache.put(clazz, objectPoolImpl);
        }
        return objectPoolImpl;
    }

    public PooledObject activateInstance() throws SQLException {
        PooledObject pooledObject;
        PooledObjectHandle pooledObjectHandle = this.m_providerPool;
        if (pooledObjectHandle != null) {
            this.m_providerPool = pooledObjectHandle.m_next;
            pooledObject = pooledObjectHandle.m_instance;
            pooledObjectHandle.m_instance = null;
            pooledObjectHandle.m_next = ObjectPoolImpl.s_handlePool;
            s_handlePool = pooledObjectHandle;
        } else {
            try {
                pooledObject = (PooledObject)this.m_ctor.newInstance(this);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new SQLException(invocationTargetException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Failed to create an instance of: " + this.m_ctor.getDeclaringClass() + " :" + exception.getMessage());
            }
        }
        try {
            pooledObject.activate();
        }
        catch (SQLException sQLException) {
            pooledObject.remove();
            throw sQLException;
        }
        return pooledObject;
    }

    public void passivateInstance(PooledObject pooledObject) throws SQLException {
        try {
            pooledObject.passivate();
        }
        catch (SQLException sQLException) {
            pooledObject.remove();
            throw sQLException;
        }
        PooledObjectHandle pooledObjectHandle = s_handlePool;
        if (pooledObjectHandle != null) {
            s_handlePool = pooledObjectHandle.m_next;
        } else {
            pooledObjectHandle = new PooledObjectHandle();
        }
        pooledObjectHandle.m_instance = pooledObject;
        pooledObjectHandle.m_next = this.m_providerPool;
        this.m_providerPool = pooledObjectHandle;
    }

    public void removeInstance(PooledObject pooledObject) throws SQLException {
        PooledObjectHandle pooledObjectHandle = null;
        PooledObjectHandle pooledObjectHandle2 = this.m_providerPool;
        while (pooledObjectHandle2 != null) {
            if (pooledObjectHandle2.m_instance == pooledObject) {
                if (pooledObjectHandle == null) {
                    this.m_providerPool = pooledObjectHandle2.m_next;
                } else {
                    pooledObjectHandle.m_next = pooledObjectHandle2.m_next;
                }
                pooledObjectHandle2.m_instance = null;
                pooledObjectHandle2.m_next = ObjectPoolImpl.s_handlePool;
                s_handlePool = pooledObjectHandle2;
                break;
            }
            pooledObjectHandle2 = pooledObjectHandle2.m_next;
        }
        pooledObject.remove();
    }

    static {
        s_poolCache = new IdentityHashMap();
    }

    private static class PooledObjectHandle {
        private PooledObject m_instance;
        private PooledObjectHandle m_next;

        private PooledObjectHandle() {
        }
    }
}

