<?php // $Id: dblib.php,v 1.8 2001/05/12 14:01:49 ciaccia Exp $ - #phpAdsNew Revision: 1.13 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by Matteo Beccati                                 */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/




/*********************************************************/
/* Open a connection to the database                     */
/*********************************************************/

function db_connect()
{
	global $phpAds_hostname, $phpAds_db, $phpAds_pgsqluser, $phpAds_pgsqlpassword;
	global $phpPgAds_timezone;
	global $link;

	$conn_str = (empty($phpAds_hostname) ? "" : "host=$phpAds_hostname ")."dbname=$phpAds_db user=$phpAds_pgsqluser".
		(empty($phpAds_pgsqlpassword) ? "" : " password=$phpAds_pgsqlpassword");

	if ($GLOBALS["phpAds_persistent_connections"])
		$link = @pg_pconnect($conn_str);
	else
		$link = @pg_connect($conn_str);

	if (!empty($phpPgAds_timezone))
		pg_Exec($link, "SET TIMEZONE = '$phpPgAds_timezone'");

	return $link;
	}



/*********************************************************/
/* Close the connection to the database			         */
/*********************************************************/

function db_close()
{
	global $link;

	//pg_close($link);
}



/*********************************************************/
/* Execute a query                                       */
/*********************************************************/

function db_query($query, $link = "")
	{
    global $phpAds_last_query;
	
    $phpAds_last_query = $query;
    $ret = pg_exec($GLOBALS["link"], $query);
	
    return $ret;
	}



/*********************************************************/
/* Log a click to the database                           */
/*********************************************************/

function db_log_click($bannerID, $host)
	{
   global $phpAds_compact_stats, $phpAds_tbl_adstats;
   global $phpAds_tbl_adclicks;
	
   if ($phpAds_compact_stats)
		{
		$result = @db_query("UPDATE $phpAds_tbl_adstats SET clicks = clicks+1 WHERE bannerID = '$bannerID' AND day = CURRENT_DATE")
			or pg_die();
		
      // If row didn't exist.  Create it.
      if (pg_cmdtuples($result) == 0) 
			{
         $result = @db_query("INSERT INTO $phpAds_tbl_adstats (clicks, views, bannerID) VALUES (1, 0, '$bannerID')")
				or pg_die();
        }
        return $result;
    }
    
    // else
    
    return @db_query("INSERT INTO $phpAds_tbl_adclicks VALUES ('$bannerID',  NOW(), '$host')")
		 or pg_die();
}



/*********************************************************/
/* Log a view to the database                            */
/*********************************************************/

function db_log_view($bannerID, $host)
{
    global $phpAds_compact_stats, $phpAds_tbl_adstats;
    global $phpAds_tbl_adviews;
    
    if ($phpAds_compact_stats)
    {
        $result = @db_query("UPDATE $phpAds_tbl_adstats SET views = views+1 WHERE bannerID = '$bannerID' AND day = CURRENT_DATE")
			  or pg_die();
		
        // If row didn't exist.  Create it.
        if (pg_cmdtuples($result) == 0) 
        {
            $result = @db_query("INSERT INTO $phpAds_tbl_adstats (clicks, views, bannerID) VALUES (0, 1, '$bannerID')")
					or pg_die();
        }
        return $result;
    }
    
    // else
    
    return @db_query("INSERT INTO $phpAds_tbl_adviews VALUES ('$bannerID', NOW(), '$host')")
		 or pg_die();
}



/*********************************************************/
/* Get overview statistics                               */
/*********************************************************/

function db_total_stats($table, $column, $bannerID, $timeconstraint="")
	{
	global $phpAds_tbl_adstats;
    
	$ret = 0;
	$where = "";
	
	if (!empty($bannerID))
		$where = "WHERE bannerID = $bannerID";
    
	if (!empty($timeconstraint))
		{
		if (!empty($bannerID))
			$where .= " AND ";
		else
			$where = "WHERE ";
		
		if ($timeconstraint == "month")
			{
			$begintime = date("Y-m-01 00:00:00"); // date ("Ym01000000");
			$endtime = date ("Y-m-d H:i:s", mktime(0, 0, 0, date("m") + 1, 1, date("Y")));
			$where .= "t_stamp >= '$begintime' AND t_stamp < '$endtime'";
			}
		elseif ($timeconstraint == "week")
			{
			$begintime = date ("Y-m-d 00:00:00", time() - 518400);
			$endtime = date ("Y-m-d 00:00:00", time() + 86400);
			$where .= "t_stamp >= '$begintime' AND t_stamp < '$endtime'";
			}
		else
			{
			$begintime = date ("Y-m-d 00:00:00");
			$endtime = date ("Y-m-d 00:00:00", time() + 86400);
			$where .= "t_stamp >= '$begintime' AND t_stamp < '$endtime'";
			}
		}
	
	$res = db_query("SELECT count(*) as qnt FROM $table $where") or pg_die();
	if (pg_numrows ($res))
		{
		$row = pg_fetch_array($res, 0);
		if (isset($row['qnt'])) $ret += $row['qnt'];
		}

	$where = "";
	if (!empty($bannerID)) 
		$where = "WHERE bannerID = $bannerID";
    
	if (!empty($timeconstraint))
		{
		if (!empty($bannerID))
			$where .= " AND ";
		else
			$where = "WHERE ";
		
		if ($timeconstraint == "month")
			$where .= "DATE_PART('month', day) = DATE_PART('month', CURRENT_DATE)";
		elseif ($timeconstraint == "week")
			$where .= "DATE_PART('week', day) = date_part('week', CURRENT_DATE) AND DATE_PART('year', day) = DATE_PART('year', CURRENT_DATE)";
		else
		    $where .= "day = CURRENT_DATE";
		}
	
	$res = db_query("SELECT sum($column) as qnt FROM $phpAds_tbl_adstats $where") or pg_die();
	if (pg_numrows ($res))
		{
		$row = pg_fetch_array($res, 0);
		if (isset($row['qnt'])) $ret += $row['qnt'];
		}

	return $ret;
}

function db_total_clicks($bannerID="", $timeconstraint="")
	{
	return db_total_stats($GLOBALS["phpAds_tbl_adclicks"], "clicks", $bannerID, $timeconstraint);
	}

function db_total_views($bannerID="", $timeconstraint="")
	{
	return db_total_stats($GLOBALS["phpAds_tbl_adviews"], "views", $bannerID, $timeconstraint);
	}



/*********************************************************/
/* Delete statistics                                     */
/*********************************************************/

function db_delete_stats($bannerID)
	{
	global $phpAds_tbl_adviews, $phpAds_tbl_adclicks, $phpAds_tbl_adstats;
	
	db_query("DELETE FROM $phpAds_tbl_adviews WHERE bannerID = $bannerID") or pg_die();
	db_query("DELETE FROM $phpAds_tbl_adclicks WHERE bannerID = $bannerID") or pg_die();
	db_query("DELETE FROM $phpAds_tbl_adstats WHERE bannerID = $bannerID") or pg_die();
}



/*********************************************************/
/* Check if host has to be ignored                       */
/*********************************************************/

function phpads_ignore_host()
	{
	global $phpAds_ignore_hosts, $phpAds_reverse_lookup, $REMOTE_HOST, $REMOTE_ADDR;
	
	if($phpAds_reverse_lookup)
		$host = isset($REMOTE_HOST) ? $REMOTE_HOST : gethostbyaddr($REMOTE_ADDR);
	
	$found=0;
	
	while (($found == 0) && (list (, $h)=each($phpAds_ignore_hosts)))
		{
		if (ereg("^([0-9]{1,3}\.){1,3}([0-9]{1,3}|\*)$", $h))
			{
			// It's an IP address, evenually with a wildcard, so I create a regexp
			$h = str_replace(".", '\.', str_replace("*$", "", "^".$h."$"));
			
			if (ereg($h, $REMOTE_ADDR))
				$found = 1;
			}
		elseif (eregi("^(\*\.)?([a-z0-9-]+\.)*[a-z0-9-]+$", $h))
			{
			// It's an host name, evenually with a wildcard, so I create a regexp
			$h = str_replace(".", '\.', str_replace("^*", "", "^".$h."$"));
						
			if (eregi($h, $host))
				$found = 1;
			}
		elseif (eregi("$host|$REMOTE_ADDR", $h)) // This check is backwards compatibile
				$found = 1;
		}
	
	// Returns hostname or IP address if OK, false if host is ignored
	return $found ? false : $host;
	}
?>
