<?
/**************************************************
Program name:	database.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Login and connect to PostgreSQL
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/


// If the server does not have pgsql-extensions compiled in, don't let them do anything.
if (!function_exists("pg_connect")) {
	echo "<div align=\"center\"><font face=\"arial,helvetican,sans-serif\" color=\"red\">
	It appears you do not have PosgreSQL functions built into PHP.<br>
	You cannot use phpPgAdmin without the pgsql extension<br>
	Check below to verify!<br><br><script language=\"JavaScript\"></script> </font></div>";
	phpinfo(INFO_MODULES);
	exit;
}


# Build connect string and re-connect if not using persistent connections, or if using
# persistant connections and the connect is new.
# Fix or understand this pg_pconnect issue later.
# if ( (!$cfgPersistentConnections) || (($cfgPersistentConnections) && ($need_new_connect)) ) {

# Reset $cfgServers Array before looping through array in next command
reset($cfgServers);

# For each cfgServers[][], check the 'host' and 'local' values.
# If 'host' is set to '' and 'local' is false
# then remove that server (i.e.. $key) from the array.

while(list($key, $val) = each($cfgServers)) {
	if (empty($val['host']) && !$val['local']) {
		unset($cfgServers[$key]);
	}
}

// Re-assign $server if it was changed by user ($nserver is POST var from indexpage.php)
if (!empty($nserver)) { $server = $nserver; }

# $server is an integer variable that is the index in array $cfgServers[][]
# which is the server that we are connected to. 
# If $server is '' OR $cfgServers[int][] isn't set OR $cfgServers[int][] isn't an arrary
# then set $server to $cfgServerDefault.
if (empty($server) || !isset($cfgServers[$server]) || !is_array($cfgServers[$server])) {
	$server = $cfgServerDefault;
}

if ( (isset($mode)) && ($mode == "logout") ) { $server = $cfgServerDefault; }

// Re-assign $db if it has changed by user on list of databases page ($ndb is GET var from databasepage.php)
if (!empty($ndb)) { $db = $ndb; }


# $db is name of database used in connect string ($conn_str) 
# If no database is selected, set it to default db
if ((empty($db)) || (!empty($nserver))) {
	$db = $cfgDefaultDB;
}

# If no server is selected (i.e. $server = 0), then make sure that $cfgServer is empty
# (so that nothing will work), and skip server authentication.
# If a server is selected, set up $cfgServer and do the usual login stuff.


if ($server == 0) {
	$cfgServer = array();
} else {

	# $cfgServer is an Array that the selected server is copied into

	#$cfgServerOld = $cfgServers[$serverold];

	$cfgServer = $cfgServers[$server];

	# Set $db to only_db if neccessary
	if (isset($cfgServer['only_db']) && !isset($db)) {
		$db = $cfgServer['only_db'];
	}

	# If adv_auth is set to TRUE (i.e. require username and password for login)
	if ($cfgServer['adv_auth']) {

		# set_username and set_password is what is entered on login.php form
		if ( (isset($conn_user)) && (isset($conn_pass)) ) {
			$PHP_PGADMIN_USER = $conn_user;
			$PHP_PGADMIN_PW = $conn_pass;
		}


		# set_username and set_password is what is entered on login.php form
		if ( (isset($set_username)) && (isset($set_password)) ) {
			$PHP_PGADMIN_USER = $set_username;
			$PHP_PGADMIN_PW = $set_password;
		}

		# if Logout was clicked (i.e. mode is logout), then delete the password cookie
		if ( (isset($mode)) && ($mode == "logout") ) {
			unset($PHP_PGADMIN_USER);
			unset($PHP_PGADMIN_PW);
			unset($conn_user);
			session_destroy();
			#setcookie("PHP_PGADMIN_USER"); // Delete user cookie (i added this since TRUST just allowed you to connect again if you clicked database, etc).
			#setcookie("PHP_PGADMIN_PW");   // Delete password cookie 
		}
		

		if ( (isset($mode)) && ($mode == "newserver") ) {
			#removes top info about server, db, user, host
			unset($conn_user);
			#redirect to login.php;
			RedirectTo("login.php");
			exit;
		}


		# if the user and password are empty then, go to login screen
		if ( (empty($PHP_PGADMIN_USER)) || (empty($PHP_PGADMIN_PW)) ) {
			#redirect to login.php;
			RedirectTo("login.php");
			exit;
		} else if (isset($set_username) && isset($set_password)) {
			#echo "try to connect with username"."<br>\n";
			//connect to see if right user.
			#if ($dbh = pg_connect($conn_str)) {
				
			# set_username and set_password is what is entered on login.php form

			#setcookie("PHP_PGADMIN_USER", $set_username, time() + (60 * 60 * 24 * 30)); // One month
			#setcookie("PHP_PGADMIN_PW", $set_password); // Till the browser is closed
			$PHP_PGADMIN_USER = $set_username;
			$PHP_PGADMIN_PW = $set_password;
		
		}
		
#		$cfgServer[stduser] = $PHP_PGADMIN_USER;
#		$cfgServer[stdpass] = $PHP_PGADMIN_PW;
		$conn_user = $PHP_PGADMIN_USER;
		$conn_pass = $PHP_PGADMIN_PW;


	# ELSE adv_auth is set to FALSE 
	# (i.e. do NOT require username and password for login)
	} else {

#		$cfgServer[stduser] = $cfgServer[user];
#		$cfgServer[stdpass] = $cfgServer[password];
		$conn_user = $cfgServer[user];
		$conn_pass = $cfgServer[password];

	# END IF of "if ($cfgServer['adv_auth'])"

	}
	


	# $conn_str is connection string that will be used with pg_connect.
#	$conn_str = "user=$cfgServer[stduser] password=$cfgServer[stdpass] ";
	$conn_str = "user=".$conn_user." password=".$conn_pass;

	# host and port
	$conn_host = $cfgServer[host];
	$conn_port = $cfgServer[port];

	# If Server is not local, then append host= clause to connect string.
	# Other wise the host= clause is not included.
	if (!$cfgServer['local']) {
		$conn_str .= " host=".$cfgServer[host];
	}	
		
	# Append port= and dbname= clauses to connect string
	$conn_str .= " port=".$cfgServer[port]." dbname='".$db."'";

	# CONNECT to PostgreSQL
	# using persistent or non-persistant connection
#	if ($cfgPersistentConnections) {
#		$link = pg_pconnect($conn_str);
#	} else {
		if ($cfgDebug) {
		$link = pg_connect($conn_str) ;
		} else {
		$link = @pg_connect($conn_str) ;		
		}

#		$link2 = pg_connect($conn_str) ;

#		echo $link.$conn_str."<br>";
#		echo $link2.$conn_str."<br>";

#	}

	# if the login connection was NOT successful, then display error message 
	if (!$link) {
		pg_die("Unable to connect to server", "", __FILE__, __LINE__);

	} else {


	$sql_get_userperm = "SELECT usecreatedb FROM pg_user WHERE usename = '".$cfgServer[user]."'";
	$rs_perm = @pg_exec($link, pre_query($sql_get_userperm)) or pg_die(pg_errormessage(), $sql_get_userperm, __FILE__, __LINE__);
	# can or can't create db
	$create_db = @pg_result($rs_perm, 0, "usecreatedb");
	
	$res_version = @pg_exec($link, "SELECT version() as version") or pg_die(pg_errormessage(), "", __FILE__, __LINE__);
	$row_version = @pg_result($res_version, 0, "version");
	// Split out the version numbers for later use  $ver_num[0] contains the entire version
	ereg("([6-9]).([0-9A-Za-z])[.]?([0-9])?", $row_version, $ver_num);
	// ereg("([6-9]).([0-9]).([0-9])", $row_version, $ver_num);
	#version
	$version = $ver_num[0];
	
	// Set the maximum built-in ID.  This assumes the oid of template1 for versions < 7.1, and gets it from
	// the database for 7.1 and above.
	if ($ver_num[1] >= 7 && $ver_num[2] >= 1) {
		$qrDB = "SELECT datlastsysoid FROM pg_database WHERE datname='template1'";
		$rs = @pg_exec($link, $qrDB) or pg_die(pg_errormessage(), $qrDB, __FILE__, __LINE__);
		$builtin_max = @pg_result($rs, 0, "datlastsysoid");
	} else {
		$rs = @pg_exec($link, "SELECT oid FROM pg_database WHERE datname='template1'") or pg_die(pg_errormessage(), "", __FILE__, __LINE__);
		$builtin_max = @pg_result($rs, 0, "oid");
	}
	

	$qrIsSuper = "SELECT usesuper FROM pg_user WHERE usename = '".$conn_user."' AND usesuper = 't'";
	$rsIsSuper = @pg_exec($link, pre_query($qrIsSuper));
	if (@pg_numrows($rsIsSuper)) {
		$bSuperUser = true;
	} else {
		$bSuperUser = false;
	}

	} 

	/////$only_db = $cfgServer['only_db'];
}

?>
