#import "PgWindowController.h"

@implementation PgWindowController

-(id)init
{
		self = [super init]	;
		
		pgConnection = [[[PostgreSQL alloc] init] retain]	;
		connected = NO	;
		
		return self	;
}

- (IBAction)executeQuery:(id)sender
{
		if (!connected)	{
			[errorMessage setStringValue:@"Not connected !"]	;
			return	;
		}	
	NSString	*query = [queryField stringValue]	;
	
		if ([query length] > 0)	{
			[pgConnection clearCommands]	;
			[pgConnection makeCommandWithString:query]	;
			[pgConnection executeCommand]	;
			
			[errorMessage setStringValue:[NSString stringWithCString:[pgConnection serverMessage]]];
			
			if ([pgConnection rowsAffected])	{
				NSArray	*columns = [tableView tableColumns]	;
				NSTableColumn	*aColumn	;
				int		i, n, metaDataNCols = [pgConnection resultColumnCount], curNCols = [columns count]	;
				
					// first remove the current data source, and colums
					if (metaDataNCols > curNCols)	// we need more columns than what we have
					{
						n = metaDataNCols - curNCols	;
						for(i=0;i<n;i++)	{
							[tableView addTableColumn:[[NSTableColumn alloc] initWithIdentifier:[NSString stringWithFormat:@"%d", (curNCols + i)]]]	;
						}
						n = curNCols	;
					}
					else	if (metaDataNCols < curNCols)	{	// we have more columns than what we need
						for(i=curNCols-1;i>=metaDataNCols;i--)	{
							[tableView removeTableColumn:[columns objectAtIndex:i]]	;
						}
						n = metaDataNCols	;
					}
				
					columns = [tableView tableColumns]	;
					for(i=0;i<n;i++)	{
						aColumn = [columns objectAtIndex:i]	;
						[aColumn setIdentifier:[NSString stringWithFormat:@"%d", i]]	;
					}
					
					for(i=0;i<metaDataNCols;i++)	{
						aColumn = [columns objectAtIndex:i]	;
						[[aColumn headerCell] setStringValue:[NSString stringWithCString:[pgConnection resultColumnName:i]]]	;
						[aColumn sizeToFit]	;
						[aColumn setEditable:NO]	;
					}
					
					[tableView setDataSource:[pgConnection getResultSet]]	;
			}
		}
}

- (IBAction)connect:(id)sender
{
	int	result	;
	
//		if (connected = [pgConnection connectAskingUser:&result])
		if (connected = [pgConnection connectAskingUserWithDefaults:[NSDictionary dictionaryWithObjectsAndKeys:	
						@"localhost", @"hostname",  
						@"pgsqltest", @"dbname", 
						@"pascal", @"user", 
						@"pascal", @"password", 
						nil ] return:&result forWindow:[self window]])
			[errorMessage setStringValue:@"OK"]	;
		else
			[errorMessage setStringValue:[NSString stringWithCString:[pgConnection connectErrorMessage:result]]]	;
}

@end
